<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * LiteCommerce
 * 
 * NOTICE OF LICENSE
 * 
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@litecommerce.com so we can send you a copy immediately.
 * 
 * PHP version 5.3.0
 * 
 * @category  LiteCommerce
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2011 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      http://www.magictoolbox.com/
 * @see       ____file_see____
 * @since     1.0.0
 */

namespace XLite\Module\MagicToolbox\MagicScroll\View;

/**
 * AdminHeader
 *
 * @see   ____class_see____
 * @since 1.0.0
 *
 * @ListChild (list="head", zone="admin", weight="10000")
 */
class AdminHeader extends \XLite\View\AView {

    /**
     * Return widget default template
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    protected function getDefaultTemplate() {
        return 'modules/MagicToolbox/MagicScroll/header.tpl';
    }

    /**
     * Returns the resource web path
     *
     * @param string $shortPath Short path
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getResourceWebPath($shortPath) {
        return \XLite\Core\Layout::getInstance()->getResourceWebPath($shortPath, \XLite\Core\Layout::WEB_PATH_OUTPUT_URL, \XLite::ADMIN_INTERFACE);
    }

    /**
     * Return list of allowed targets
     *
     * @return array
     * @see    ____func_see____
     * @since  1.0.0
     */
    public static function getAllowedTargets() {
        $result = parent::getAllowedTargets();
        $result[] = 'module';
        return $result;
    }

    /**
     * Check visibility
     *
     * @return boolean
     * @see    ____func_see____
     * @since  1.0.0
     */
    protected function isVisible() {
        $activeModules = \Includes\Utils\ModulesManager::getActiveModules();
        return in_array(\XLite\Core\Request::getInstance()->target, self::getAllowedTargets()) &&
               (\XLite\Core\Request::getInstance()->moduleId == $activeModules['MagicToolbox\MagicScroll']['moduleID']);
    }

}
