<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * LiteCommerce
 * 
 * NOTICE OF LICENSE
 * 
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@litecommerce.com so we can send you a copy immediately.
 * 
 * PHP version 5.3.0
 * 
 * @category  LiteCommerce
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2011 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      http://www.magictoolbox.com/
 * @see       ____file_see____
 * @since     1.0.0
 */

namespace XLite\Module\MagicToolbox\MagicScroll;

/**
 * MagicScroll module main class
 *
 * @see   ____class_see____
 * @since 1.0.0
 */
abstract class Main extends \XLite\Module\AModule {

    /**
     * Internal module version
     *
     * @var   string
     * @see   ____var_see____
     * @since 1.0.0
     */
    protected static  $internalVersion = '1.2.5';

    /**
     * Flag; determines if config is set in database
     *
     * @var   boolean
     * @see   ____var_see____
     * @since 1.0.0
     */
    protected static  $isConfigSet = false;

    /**
     * Return module name
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    public static function getModuleName() {
        return 'Magic Scroll &trade;';
    }

    /**
     * Return author name
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    public static function getAuthorName() {
        return 'Magic Toolbox';
    }

    /**
     * Return module description
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    public static function getDescription() {
        return "Effortlessly scroll through images and/or text on your web pages.";
    }

    /**
     * Get module major version
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    public static function getMajorVersion() {
        return '1.0';
    }

    /**
     * Get module minor version
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    public static function getMinorVersion() {
        return '16';
    }

    /**
     * Return link to the module author page
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    public static function getAuthorPageURL() {
        return 'http://www.magictoolbox.com/';
    }

    /**
     * Determines if we need to show settings form link
     *
     * @return boolean
     * @see    ____func_see____
     * @since  1.0.0
     */
    public static function showSettingsForm() {
        if(!self::$isConfigSet) {
            $config = \XLite\Core\Config::getInstance();
            if(($config->MagicToolbox === null) || ($config->MagicToolbox->MagicScroll === null)) {
                $yaml = \Includes\Utils\ModulesManager::getModuleYAMLFile('MagicToolbox', 'MagicScroll');
                if(\Includes\Utils\FileManager::isFileReadable($yaml)) {
                    \XLite\Core\Database::getInstance()->loadFixturesFromYaml($yaml);
                }
            }/* else {
                $currentVersion = self::getMajorVersion() . '.' . self::getMinorVersion();
                if(version_compare($currentVersion, $config->MagicToolbox->MagicScroll->version, '>')) {

                }
            }*/
            self::$isConfigSet = true;
        }
        return true;
    }

    /**
     * Remove original 'page.image.tpl' template from a view list
     *
     * @return void
     */
    public static function runBuildCacheHandler() {
        \XLite\View\AView::removeWidgetFromList('product/details/parts/page.image.tpl', true, 'product.details.page', \XLite\Model\ViewList::INTERFACE_CUSTOMER);
    }

    /**
     * Return list of mutually exclusive modules
     *
     * @return array
     */
    public static function getMutualModulesList() {
        $list = parent::getMutualModulesList();
        $list[] = 'MagicToolbox\MagicZoom';
        $list[] = 'MagicToolbox\MagicZoomPlus';
        $list[] = 'MagicToolbox\MagicThumb';
        $list[] = 'MagicToolbox\MagicSlideshow';
        $list[] = 'MagicToolbox\Magic360';
        return $list;
    }

}
