<?php
/*

Copyright 2017 MagicToolbox (email : support@magictoolbox.com)

*/

$error_message = false;
$update_plugin = true;

function Jigoshop_MagicThumb_activate () {

    set_transient( 'Jigoshop_MagicThumb_welcome_license_activation_redirect', true, 30 );

    if(!function_exists('file_put_contents')) {
        function file_put_contents($filename, $data) {
            $fp = fopen($filename, 'w+');
            if ($fp) {
                fwrite($fp, $data);
                fclose($fp);
            }
        }
    }

    /* === onlyForMod start: woocommerce */

    //fix url's in css files
    $fileContents = file_get_contents(dirname(__FILE__) . '/core/magicthumb.css');
    $cssPath = preg_replace('/https?:\/\/[^\/]*/is', '', get_option("siteurl"));

    $cssPath .= '/wp-content/'.preg_replace('/^.*?\/(plugins\/.*?)$/is', '$1', str_replace("\\","/",dirname(__FILE__))).'/core';

    $pattern = '#url\(\s*(\'|")?(?!data:|mhtml:|http(?:s)?:|/)([^\)\s\'"]+?)(?(1)\1)\s*\)#is';
    $replace = 'url($1'.$cssPath.'/$2$1)';

    $fixedFileContents = preg_replace($pattern, $replace, $fileContents);
    if($fixedFileContents != $fileContents) {
        file_put_contents(dirname(__FILE__) . '/core/magicthumb.css', $fixedFileContents);
    }

    magictoolbox_Jigoshop_MagicThumb_create_db();

    magictoolbox_Jigoshop_MagicThumb_init();

    Jigoshop_MagicThumb_send_stat('install');
}

function Jigoshop_MagicThumb_deactivate () {}

function Jigoshop_MagicThumb_uninstall() {

    magictoolbox_Jigoshop_MagicThumb_delete_row_from_db('Jigoshop_MagicThumb_magicscroll');
    magictoolbox_Jigoshop_MagicThumb_delete_row_from_db();

    if (magictoolbox_Jigoshop_MagicThumb_is_empty_db() && !count(Jigoshop_MagicThumb_get_active_modules())) {
        magictoolbox_Jigoshop_MagicThumb_remove_db();
    }

    delete_option("JigoshopMagicThumbCoreSettings");
    Jigoshop_MagicThumb_send_stat('uninstall');
}

function Jigoshop_MagicThumb_get_active_modules() {
    $name = explode('/', plugin_basename( __FILE__ ));
    $name = $name[0];
    $mtb_ap = array();

    foreach (get_option('active_plugins') as $value) {
        $name2 = explode('/', $value);
        $name2 = $name2[0];

        if ($name2 != $name && preg_match('/magiczoom|magiczoomplus|magic360|magicslideshow|magicscroll|magicthumb/', $value)) {
            $mtb_ap[] = $value;
        }
    }

    return $mtb_ap;
}

function Jigoshop_MagicThumb_send_stat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v.6.9.4' || 'working' == 'v3.0.19') {
        return;
    }

    $hostname = 'www.magictoolbox.com';

    $url = preg_replace('/^https?:\/\//is', '', get_option("siteurl"));
    $url = urlencode(urldecode($url));

    $platformVersion = defined('JIGOSHOP_VERSION') ? JIGOSHOP_VERSION : '';

    $path = "api/stat/?action={$action}&tool_name=magicthumb&license=trial&tool_version=v3.0.19&module_version=v.6.9.4&platform_name=jigoshop&platform_version={$platformVersion}&url={$url}";
    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers  = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }

}





function showMessage_Jigoshop_MagicThumb($message, $errormsg = false) {
    if ($errormsg) {
        echo '<div id="message" class="error">';
    } else {
        echo '<div id="message" class="updated fade">';
    }
    echo "<p><strong>$message</strong></p></div>";
}


function showAdminMessages_Jigoshop_MagicThumb(){
    global $error_message;
    if (current_user_can('edit_posts')) {
       showMessage_Jigoshop_MagicThumb($error_message,true);
    }
}

function Jigoshop_MagicThumb_LoadScroll($tool) {

    $tool->params->setProfile('product');

    if($tool->params->checkValue('magicscroll', 'yes') && $tool->type == 'standard') {
        require_once(dirname(__FILE__) . '/core/magicscroll.module.core.class.php');
        $scroll = new MagicScrollModuleCoreClass(false);
        $GLOBALS["magictoolbox"]["scroll"] = & $tool;
        //NOTE: load params in a separate profile, in order not to overwrite the options of MagicScroll module
        $scroll->params->appendParams($tool->params->getParams('product'), 'product-magicscroll-options');
        if($tool->params->checkValue('template', 'classic')) {
            $scroll->params->setValue('orientation', 'horizontal', 'product-magicscroll-options');
        }
        if($tool->params->checkValue('template', 'selectors-left')) {
            $scroll->params->setValue('orientation', 'vertical', 'product-magicscroll-options');
        }
        if($tool->params->checkValue('template', array('left', 'right'), 'product')) {
            $scroll->params->setValue('orientation', 'vertical', 'product-magicscroll-options');
        }
        if($tool->params->checkValue('template', array('top', 'bottom'), 'product')) {
            $scroll->params->setValue('orientation', 'horizontal', 'product-magicscroll-options');
        }
        return $scroll;
    }

    return false;
}

function plugin_get_version_Jigoshop_MagicThumb() {
    $plugin_data = get_plugin_data(dirname(plugin_dir_path(__FILE__)).'/mod_jigoshop_magicthumb.php');
    $plugin_version = $plugin_data['Version'];
    return $plugin_version;
}

function update_plugin_message_Jigoshop_MagicThumb() {
    $ver = json_decode(@file_get_contents('http://www.magictoolbox.com/api/platform/wordpress/version/'));
    if (empty($ver)) return false;
    $ver = str_replace('v','',$ver->version);
    $oldVer = plugin_get_version_Jigoshop_MagicThumb();
    if (version_compare($oldVer, $ver, '<')) {
        echo '<div id="message" class="updated fade">
                  <p>New version available! We recommend that you download the <a href="'.JigoshopMagicThumb_url('http://magictoolbox.com/magicthumb/modules/jigoshop/',' plugins page update link ').'">latest version</a> of Magic Thumb for Jigoshop . </p>
              </div>';
    }
}

function get_tool_version_Jigoshop_MagicThumb($tool=null) {
    global $wp_filesystem;

    if (!$tool) {
        $tool = 'magicthumb';
    }

    WP_Filesystem();

    if (empty($wp_filesystem)) {
        require_once (ABSPATH . '/wp-admin/includes/file.php');
        WP_Filesystem();
    }

    $r = $wp_filesystem->get_contents(plugin_dir_path( __FILE__ ).'core/'.$tool.'.js');

    if (!preg_match('/demo/is',$r)) {
        $version = 'commercial';
    } else {
        $version = 'trial';
    }
    return $version;
}


function  magictoolbox_Jigoshop_MagicThumb_init() {

    add_action( 'admin_init', 'JigoshopMagicThumb_welcome_license_do_redirect' );

    global $error_message;


    add_action("admin_menu", "magictoolbox_Jigoshop_MagicThumb_config_page_menu");
    add_action('admin_enqueue_scripts', 'Jigoshop_MagicThumb_load_admin_scripts');
    add_action('wp_enqueue_scripts', 'Jigoshop_MagicThumb_load_frontend_scripts');

    //add_filter('filesystem_method', create_function('$a', 'return "direct";' ));
    add_filter('filesystem_method', function($a) { return "direct"; });


    require_once(dirname(__FILE__)."/core/autoupdate.php");
    require_once(dirname(__FILE__)."/core/view/import_export/export.php");
    add_action('wp_ajax_Jigoshop_MagicThumb_import', 'Jigoshop_MagicThumb_import');
    add_action('wp_ajax_Jigoshop_MagicThumb_export', 'Jigoshop_MagicThumb_export');


    add_action('wp_ajax_magictoolbox_Jigoshop_MagicThumb_set_license', 'magictoolbox_Jigoshop_MagicThumb_set_license');



    add_action ("jigoshop_before_main_content","magictoolbox_Jigoshop_MagicThumb_start_parsing",10);
    add_action ("jigoshop_after_main_content","magictoolbox_Jigoshop_MagicThumb_end_parsing",10);
    add_action ("jigoshop_before_single_product","magictoolbox_Jigoshop_MagicThumb_start_alternative_parsing",11);
    add_action ("jigoshop_after_single_product","magictoolbox_Jigoshop_MagicThumb_end_alternative_parsing",11);
    add_filter ("the_content","magictoolbox_Jigoshop_MagicThumb_contentClean",13);
    
    
    
    add_filter( 'plugin_action_links', 'magictoolbox_Jigoshop_MagicThumb_links', 10, 2 );
    add_filter( 'plugin_row_meta', 'magictoolbox_Jigoshop_MagicThumb_plugin_row_meta' , 10, 2 );

    if (!file_exists(dirname(__FILE__) . '/core/magicthumb.js')) {
        $jsContents = file_get_contents('http://www.magictoolbox.com/static/magicthumb/trial/magicthumb.js');
        if (!empty($jsContents) && preg_match('/\/\*.*?\\\*/is',$jsContents)){
            if ( !is_writable(dirname(__FILE__) . '/core/')) {
                $error_message = 'The '.substr(dirname(__FILE__),strpos(dirname(__FILE__),'wp-content')).'/core/magicthumb.js file is missing. Please re-uplaod it.';
            }
            file_put_contents(dirname(__FILE__) . '/core/magicthumb.js', $jsContents);
            chmod(dirname(__FILE__) . '/core/magicthumb.js', 0777);
        } else {
            $error_message = 'The '.substr(dirname(__FILE__),strpos(dirname(__FILE__),'wp-content')).'/core/magicthumb.js file is missing. Please re-uplaod it.';
        }
    }
    if ($error_message) add_action('admin_notices', 'showAdminMessages_Jigoshop_MagicThumb');

    if(!isset($GLOBALS['magictoolbox']['JigoshopMagicThumb'])) {
        require_once(dirname(__FILE__) . '/core/magicthumb.module.core.class.php');
        $coreClassName = "MagicThumbModuleCoreClass";
        $GLOBALS['magictoolbox']['JigoshopMagicThumb'] = new $coreClassName;
        $coreClass = &$GLOBALS['magictoolbox']['JigoshopMagicThumb'];
    }
    $coreClass = &$GLOBALS['magictoolbox']['JigoshopMagicThumb'];
    /* get current settings from db */
    $settings = get_option("JigoshopMagicThumbCoreSettings");
    if($settings !== false && is_array($settings) && isset($settings['default']) && !isset($_GET['reset_settings'])) {
        foreach (JigoshopMagicThumb_getParamsProfiles() as $profile => $name) {
        if (isset($settings[$profile])) {
        $coreClass->params->appendParams($settings[$profile],$profile);
        }
    }
    } else { //set defaults
        $allParams = array();
        $defaults = $coreClass->params->getParams('default');
        $map = JigoshopMagicThumb_getParamsMap();

    foreach (JigoshopMagicThumb_getParamsProfiles() as $profile => $name) {
        $params = array();
        foreach ($defaults as $id => $param) {;
                if (isset($map[$profile][$param['group']]) && is_array($map[$profile][$param['group']]) && in_array($id,$map[$profile][$param['group']])) { //set defaults only according to mapping
                    $params[$id] = $param;
                }
            }
            $coreClass->params->setParams($params,$profile);

        $allParams[$profile] = $coreClass->params->getParams($profile);
    }

    $allParams['product']['page-status']['default'] = 'yes'; //TODO?

    delete_option("JigoshopMagicThumbCoreSettings");
        add_option("JigoshopMagicThumbCoreSettings", $allParams,'','no');
    }

    add_action( 'upgrader_process_complete', 'Jigoshop_MagicThumb_get_packed_js', 10, 2 );
    
}

function Jigoshop_MagicThumb_init_wp_filesystem($form_url) {
    global $wp_filesystem;
    $creds = request_filesystem_credentials($form_url, '', false, plugin_dir_path( __FILE__ ), false);

    if (!WP_Filesystem($creds)) {
        request_filesystem_credentials($form_url, '', true, plugin_dir_path( __FILE__ ), false);
        return false;
    }
    return true;
}

function Jigoshop_MagicThumb_write_file ($url, $content) {
    global $wp_filesystem;
    // if (empty($wp_filesystem)) {
    //     require_once (ABSPATH . '/wp-admin/includes/file.php');
    // }
    Jigoshop_MagicThumb_init_wp_filesystem($url);

    $result = $wp_filesystem->put_contents($url, $content, FS_CHMOD_FILE );

    return $result ? null : "Failed to write to file";
}

function Jigoshop_MagicThumb_rewrite ($option, $tool) {
    $response = get_option($option);
    $result = Jigoshop_MagicThumb_write_file(plugin_dir_path(__FILE__).'core/'.$tool.'.js', $response);
    //delete_option($option);
    return $result;
}

function Jigoshop_MagicThumb_get_packed_js ($upgrader_object, $options) {
    if ('update' == $options['action'] && 'plugin' == $options['type']) {
        foreach ($options['plugins'] as $pl) {
            $_plugin = explode("/", $pl);
            $_plugin = $_plugin[count($_plugin) - 1];
            if ('mod_jigoshop_magicthumb.php' === $_plugin) {
                $key = magictoolbox_Jigoshop_MagicThumb_get_data_from_db();
                if (!$key) {
                    $result = Jigoshop_MagicThumb_rewrite("Jigoshop_MagicThumb_backup", 'magicthumb');
                }
                $result2 = Jigoshop_MagicThumb_rewrite("Jigoshop_MagicThumb_magicscroll_backup", 'magicscroll');
                break;
            }
        }
    }
}

function Jigoshop_MagicThumb_load_frontend_scripts () {
    $plugin = $GLOBALS['magictoolbox']['JigoshopMagicThumb'];

    $tool_lower = 'magicthumb';
    switch ($tool_lower) {
        case 'magicthumb':      $priority = '10'; break;
        case 'magic360':        $priority = '11'; break;
        case 'magiczoom':       $priority = '12'; break;
        case 'magiczoomplus':   $priority = '13'; break;
        case 'magicscroll':     $priority = '14'; break;
        case 'magicslideshow':  $priority = '15'; break;
        default :               $priority = '11'; break;
    }

    wp_register_style( 'magictoolbox_magicthumb_style', plugin_dir_url( __FILE__ ).'core/magicthumb.css', array(), false, 'all');
    wp_register_style( 'magictoolbox_magicthumb_module_style', plugin_dir_url( __FILE__ ).'core/magicthumb.module.css', array(), false, 'all');
    wp_register_script( 'magictoolbox_magicthumb_script', plugin_dir_url( __FILE__ ).'core/magicthumb.js', array(), false, true);
    add_action("wp_footer", "magictoolbox_Jigoshop_MagicThumb_add_src_to_footer", $priority);
    add_action("wp_footer", "magictoolbox_Jigoshop_MagicThumb_add_options_script", 10001);
}

function Jigoshop_MagicThumb_load_admin_scripts () {
    wp_enqueue_script( 'jquery' ,includes_url('/js/jquery/jquery.js'));
    wp_enqueue_script( 'jquery-ui-core', includes_url('/js/jquery/ui/core.js') );
    wp_enqueue_script( 'jquery-ui-tabs', includes_url('/js/jquery/ui/tabs.js') );

    $ownPage = false;
    if (array_key_exists('page', $_GET)) {
        $ownPage =  "JigoshopMagicThumb-config-page" ==  $_GET["page"]        ||
                    "JigoshopMagicThumb-shortcodes-page" ==  $_GET["page"]    ||
                    "JigoshopMagicThumb-import-export-page" ==  $_GET["page"] ||
                    "JigoshopMagicThumb-license-page" ==  $_GET["page"];
    }

    if (is_admin()) {
        wp_register_script( 'jigoshop_MagicThumb_admin_adminpage_script', plugin_dir_url( __FILE__ ).'core/jigoshop_MagicThumb_adminpage.js', array('jquery', 'jquery-ui-core', 'jquery-ui-tabs'), null );
        wp_enqueue_style( 'magictoolbox_jigoshop_MagicThumb_admin_menu_style', plugin_dir_url( __FILE__ ).'core/admin_menu.css', array(), null );
        if ($ownPage) {
            wp_enqueue_style( 'magictoolbox_jigoshop_MagicThumb_admin_page_style', plugin_dir_url( __FILE__ ).'core/admin.css', array(), null );
        }

        if ($ownPage) {
            wp_enqueue_style( 'Jigoshop_MagicThumb_admin_import_export_style', plugin_dir_url( __FILE__ ).'core/view/import_export/jigoshop_MagicThumb_import_export.css', array(), null );
            wp_enqueue_style( 'Jigoshop_MagicThumb_admin_license_style', plugin_dir_url( __FILE__ ).'core/view/license/jigoshop_MagicThumb_license.css', array(), null );
        }
        wp_register_script( 'Jigoshop_MagicThumb_admin_import_export_script', plugin_dir_url( __FILE__ ).'core/view/import_export/jigoshop_MagicThumb_import_export.js', array('jquery'), null );
        wp_register_script( 'Jigoshop_MagicThumb_admin_license_script', plugin_dir_url( __FILE__ ).'core/view/license/jigoshop_MagicThumb_license.js', array('jquery'), null );
    }
}

/*
function magictoolbox_Jigoshop_MagicThumb_denided_prettyPhoto_inline(){
  if( wp_script_is( 'jquery', $list = 'enqueued' ) && (wp_script_is( 'avia-prettyPhoto', $list = 'enqueued' ) || wp_script_is( 'avia-default', $list = 'enqueued' )) ) {
    ?>
    <script type="text/javascript">
    if (typeof(jQuery)=="function" && typeof(jQuery.fn)=="object" && (typeof(jQuery.fn.prettyPhoto)=="function") || (typeof(jQuery.fn.avia_activate_lightbox)=="function")) {
      jQuery.fn.prettyPhoto = function(){};
      jQuery.fn.avia_activate_lightbox = function(){};
      jQuery.fn.avia_activate_hover_effect = function(){};

    function cart_improvement_functions_new()
      {
          //single products are added via ajax //doesnt work currently
          //jQuery('.summary .cart .button[type=submit]').addClass('add_to_cart_button product_type_simple');

          //downloadable products are now added via ajax as well
          jQuery('.product_type_downloadable, .product_type_virtual').addClass('product_type_simple');

          //clicking tabs dont activate smoothscrooling
          jQuery('.woocommerce-tabs .tabs a').addClass('no-scroll');
      }

      window.cart_improvement_functions = cart_improvement_functions_new;

    }
    </script>
    <?php
  }
}
*/

/**
  * Show row meta on the plugin screen.
  *
  * @param  mixed $links Plugin Row Meta
  * @param  mixed $file  Plugin Base file
  * @return array
  */

function magictoolbox_Jigoshop_MagicThumb_plugin_row_meta( $links, $file ) {

    if (strpos(plugin_dir_path(__FILE__),plugin_dir_path($file))) {
        $row_meta = array($links[0],$links[1]);
        $row_meta['Settings'] = '<a href="admin.php?page=JigoshopMagicThumb-config-page">'.__('Settings').'</a>';
        $row_meta['Support'] =  '<a target="_blank" href="'.JigoshopMagicThumb_url('https://www.magictoolbox.com/contact/','plugins page support link').'">Support</a>';
        $row_meta['Buy'] = '<a target="_blank" href="'.JigoshopMagicThumb_url('https://www.magictoolbox.com/buy/magicthumb/','plugins page buy link').'">Buy</a>';
        $row_meta['More cool plugins'] = '<a target="_blank" href="'.JigoshopMagicThumb_url('https://www.magictoolbox.com/jigoshop/','plugins page more cool plugins link').'">More cool plugins</a>';

        return $row_meta;
    }

    return (array) $links;
}

function JigoshopMagicThumb_config_page() {
    include 'core/view/settings/jigoshop_MagicThumb_settings.php';
}

function Jigoshop_MagicThumb_add_admin_src_to_menu_page() {
    wp_enqueue_script( 'jigoshop_MagicThumb_admin_adminpage_script' );

    $arr = array(
        'ajax'   => get_site_url().'/wp-admin/admin-ajax.php',
        'nonce'  => wp_create_nonce('magic-everywhere'),
        'mtburl' => 'https://www.magictoolbox.com/site/order/'
    );

    wp_localize_script( 'jigoshop_MagicThumb_admin_adminpage_script', 'magictoolbox_Jigoshop_MagicThumb_admin_modal_object', $arr);
}

function Jigoshop_MagicThumb_import() {
    if(!(is_array($_POST) && defined('DOING_AJAX') && DOING_AJAX)){
        return;
    }

    $nonce = $_POST['nonce'];
    $tool = 'jigoshop_magicthumb';

    if ( !wp_verify_nonce( $nonce, 'magic-everywhere' ) ) {
        return;
    }

    $file = $_FILES['file'];

    $arr = (array) simplexml_load_string(file_get_contents($file["tmp_name"]),'SimpleXMLElement', LIBXML_NOCDATA);

    if (array_key_exists('tool', $arr) && $tool == $arr['tool']) {
        if (array_key_exists('license', $arr) && $arr['license'] != 'trial' && strlen($arr['license']) == 7) {
            magictoolbox_Jigoshop_MagicThumb_update_db($arr['license']);

            $url = 'https://www.magictoolbox.com/site/order/'.$arr['license'].'/magicthumb.js';
            $response = magictoolbox_Jigoshop_MagicThumb_get_file($url);
            if($response['status'] == 200) {
                Jigoshop_MagicThumb_write_file(plugin_dir_path( __FILE__ ).'core/magicthumb.js', $response['content']);
            }
        }
        if (array_key_exists('scrolllicense', $arr) && $arr['scrolllicense'] != 'trial' && strlen($arr['scrolllicense']) == 7) {
            magictoolbox_Jigoshop_MagicThumb_update_db($arr['scrolllicense'], 'Jigoshop_MagicThumb_magicscroll');
            $url = 'https://www.magictoolbox.com/site/order/'.$arr['scrolllicense'].'/magicscroll.js';
            $response = magictoolbox_Jigoshop_MagicThumb_get_file($url);
            if($response['status'] == 200) {
                Jigoshop_MagicThumb_write_file(plugin_dir_path( __FILE__ ).'core/magicscroll.js', $response['content']);
            }
        }

        if (array_key_exists('core', $arr)) {
            $core = (array) $arr['core'];

            $settings = get_option("JigoshopMagicThumbCoreSettings");

            foreach ($core as $profile => $name) {
                $name = (array) $name;
                foreach ($name as $key => $value) {
                    $value = (array) $value;
                    if ('' != $value[0]) {
                        $settings[$profile][$key]['value'] = $value[0];
                    }
                }
            }

            delete_option("JigoshopMagicThumbCoreSettings");
            add_option("JigoshopMagicThumbCoreSettings", $settings,'','no');
        }

    }
    // exit;
}

function Jigoshop_MagicThumb_export() {
    if(!(is_array($_POST) && defined('DOING_AJAX') && DOING_AJAX)){
        return;
    }

    $nonce = $_POST['nonce'];
    $value = $_POST['value'];
    $secret_data = null;

    if ( !wp_verify_nonce( $nonce, 'magic-everywhere' ) ) {
        return;
    }

    //Jigoshop_MagicThumb_wp_export($value, get_option("JigoshopMagicThumbCoreSettings"), $secret_data);
    Jigoshop_MagicThumb_wp_export(get_option("JigoshopMagicThumbCoreSettings"), $secret_data, $value);
    exit;
}

function magictoolbox_Jigoshop_MagicThumb_add_src_to_footer() {
    global $magictoolbox_MagicThumb_page_has_shortcode,
           $magictoolbox_MagicThumb_page_has_tool,
           $magictoolbox_page_has_gallery,
           $magictoolbox_MagicThumb_page_added_script,
           $magictoolbox_page_added_gallery_script,
           $magictoolbox_page_has_shortcode_gallery,
           $magictoolbox_page_added_shortcode_gallery_script;

    if (!$magictoolbox_MagicThumb_page_has_tool) {
        $plugin = $GLOBALS['magictoolbox']['JigoshopMagicThumb'];

        if ($plugin->params->checkValue('include-headers','yes') || isset($GLOBALS['custom_template_headers'])) {
            $magictoolbox_MagicThumb_page_has_tool = true; // add footers for all pages
            //if (isset($GLOBALS['custom_template_headers'])) unset($GLOBALS['custom_template_headers']); //prevent render on non-product pages
            $magictoolbox_page_has_gallery = true;
        }
    }

    if (!$magictoolbox_MagicThumb_page_added_script) {
        $magictoolbox_MagicThumb_page_added_script = true;

        if ($magictoolbox_MagicThumb_page_has_shortcode || $magictoolbox_MagicThumb_page_has_tool) {
            wp_enqueue_style('magictoolbox_magicthumb_style');
            wp_enqueue_style('magictoolbox_magicthumb_module_style');
            wp_enqueue_script('magictoolbox_magicthumb_script');
        }


        if ($magictoolbox_MagicThumb_page_has_tool) {
            // wp_enqueue_style('magictoolbox_magicthumb_style');
            // wp_enqueue_style('magictoolbox_magicthumb_module_style');
            // wp_enqueue_script('magictoolbox_magicthumb_script');
        }
    }

}

function magictoolbox_Jigoshop_MagicThumb_add_options_script () {
    global $magictoolbox_MagicThumb_page_added_options,
            $magictoolbox_MagicThumb_page_has_shortcode,
            $magictoolbox_MagicThumb_page_has_tool;
    $footers = '';

    if (!$magictoolbox_MagicThumb_page_added_options) {
        $magictoolbox_MagicThumb_page_added_options = true;


        if ($magictoolbox_MagicThumb_page_has_shortcode || $magictoolbox_MagicThumb_page_has_tool) {
            $plugin = $GLOBALS['magictoolbox']['JigoshopMagicThumb'];
            $footers = $plugin->getOptionsTemplate();


            if (function_exists('plugins_url')) {
                $core_url = plugins_url();
            } else {
                $core_url = get_option("siteurl").'/wp-content/plugins';
            }
            $path = preg_replace('/^.*?\/plugins\/(.*?)$/is', '$1', str_replace("\\","/",dirname(__FILE__)));
            $scroll = Jigoshop_MagicThumb_LoadScroll($plugin);
            if($scroll) {
                $scroll->params->resetProfile();
                $footers .= $scroll->getHeadersTemplate($core_url."/{$path}/core", null, false);
            }

            global $sTemplateJs;
            if (isset($sTemplateJs) && !empty($sTemplateJs)) {
                $footers .= $sTemplateJs;
            }
        }
        echo $footers;
    }
}

function magictoolbox_Jigoshop_MagicThumb_get_file($url) {
    $result = array( 'content' => '', 'status' => 0);

    if ($url && is_string($url)) {
        $url = trim($url);
        if ('' != $url) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
            $response = curl_exec($ch);
            $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            $result['content'] = $response;
            $result['status'] = $code;
        }
    }

    return $result;
}

function magictoolbox_Jigoshop_MagicThumb_set_license() {
    global $wp_filesystem;

    if (empty($wp_filesystem)) {
        require_once (ABSPATH . '/wp-admin/includes/file.php');
    }

    WP_Filesystem();
    // ob_end_clean();

    if(!(is_array($_POST) && defined('DOING_AJAX') && DOING_AJAX)){
        return;
    }

    $nonce = $_POST['nonce'];
    $key = $_POST['key'];
    $extra_param = $_POST['param'];
    $result = '{"error": "error"}';

    if (!$extra_param || 'null' == $extra_param) {
        $extra_param = null;
        $tool_name = 'magicthumb';
    } else {
        $tool_name = $extra_param;
        $extra_param = 'Jigoshop_MagicThumb_'.$extra_param;
    }

    if ( !wp_verify_nonce( $nonce, 'magic-everywhere' ) ) {
        $result = '{"error": "verification failed"}';
    } else {
        if ($key && '' != $key) {
            $url = 'https://www.magictoolbox.com/site/order/'.$key.'/'.$tool_name.'.js';
            $response = magictoolbox_Jigoshop_MagicThumb_get_file($url);

            $code = $response['status'];
            $response = $response['content'];

            if($code == 200) {
                $result = Jigoshop_MagicThumb_write_file(plugin_dir_path( __FILE__ ).'core/'.$tool_name.'.js', $response);
                if (!$result) {
                    magictoolbox_Jigoshop_MagicThumb_update_db($key, $extra_param);
                    $result = 'null';
                }
                $result = '{"error": '.$result.'}';
            } else if($code == 403) {
                $result = '{"error": "limit"}';
                //Download limit reached
                //Your license has been downloaded 10 times already.
                //If you wish to download your license again, please contact us.
            } else if ($code == 404) {
                $result = '{"error": "license failed"}';
            } else {
                $result = '{"error": "Other errors"}';
            }
        }
    }
    ob_end_clean();
    echo $result;
    wp_die();
}

function magictoolbox_Jigoshop_MagicThumb_create_db() {
    global $wpdb;

    $table_name = $wpdb->prefix . 'magictoolbox_store';
    if($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
        $sql = "CREATE TABLE $table_name (
          id int unsigned NOT NULL auto_increment,
          name varchar(50) DEFAULT NULL,
          license varchar(50) DEFAULT NULL,
          UNIQUE KEY id (id));";

        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta( $sql );
    }
}

function magictoolbox_Jigoshop_MagicThumb_remove_db() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'magictoolbox_store';

    if($wpdb->get_var("SHOW TABLES LIKE '$table_name'") == $table_name) {
        $wpdb->query("DROP TABLE IF EXISTS ".$table_name);
    }
}

function magictoolbox_Jigoshop_MagicThumb_update_db($key, $name=null) {
    global $wpdb;
    $result = false;

    if (!$name || !is_string($name)) {
        $name = 'Jigoshop_MagicThumb';
    }

    if ($key && is_string($key)) {
        $table_name = $wpdb->prefix . 'magictoolbox_store';

        $data = $wpdb->get_results("SELECT * FROM ".$table_name." WHERE name = '" . $name . "'");

        if ($data && count($data) > 0) {
            $result = $wpdb->update($table_name, array('license' => $key), array('name' => $name), array( '%s' ), array( '%s' ));
            $result = !!$result;
        } else {
            $result = $wpdb->insert($table_name, array('name' => $name, 'license' => $key));
        }
    }

    return $result;
}

function magictoolbox_Jigoshop_MagicThumb_delete_row_from_db($name=null) {
    global $wpdb;

    if (!$name || !is_string($name)) {
        $name = 'Jigoshop_MagicThumb';
    }

    $table_name = $wpdb->prefix . 'magictoolbox_store';
    if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") == $table_name) {
        return $wpdb->delete( $table_name, array( 'name' => $name ) );
    } else {
        return false;
    }
}

function magictoolbox_Jigoshop_MagicThumb_is_empty_db() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'magictoolbox_store';
    if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") == $table_name) {
        $result = $wpdb->get_results("SELECT * FROM ".$table_name);
        return !(count($result) > 0);
    } else {
        return false;
    }
}

function magictoolbox_Jigoshop_MagicThumb_get_data_from_db($name=null) {
    global $wpdb;
    
    if (!$name || !is_string($name)) {
        $name = 'Jigoshop_MagicThumb';
    }
    
    if (isset($GLOBALS['Jigoshop_MagicThumb_get_data_from_db'][$name])) {
        return $GLOBALS['Jigoshop_MagicThumb_get_data_from_db'][$name];
    }

    $table_name = $wpdb->prefix . 'magictoolbox_store';
    $result = $wpdb->get_results("SELECT * FROM ".$table_name." WHERE name = '".$name."'");
    
    if ($result && count($result) > 0) {
        $GLOBALS['Jigoshop_MagicThumb_get_data_from_db'][$name] = $result[0];
        return $result[0];
    } else {
        $GLOBALS['Jigoshop_MagicThumb_get_data_from_db'][$name] = false;
        return false;
    }
}

function magictoolbox_Jigoshop_MagicThumb_links( $links, $file ) {
    $fileName = 'mod_jigoshop_magicthumb_trial/mod_jigoshop_magicthumb.php';
    
    $fileName = preg_replace('/\_trial\//', '/', $fileName);
    $fileName = preg_replace('/\_commercial\//', '/', $fileName);
    
    if ($file == $fileName) {
        $settings_link = '<a href="admin.php?page=JigoshopMagicThumb-config-page">'.__('Settings').'</a>';
        array_unshift( $links, $settings_link );
    }
    return $links;
}

function magictoolbox_Jigoshop_MagicThumb_config_page_menu() {
    if(function_exists("add_menu_page")) {
        $page = add_menu_page(__("Magic Thumb for Jigoshop"), __("Magic Thumb for Jigoshop"), "edit_posts", "JigoshopMagicThumb-config-page", "JigoshopMagicThumb_config_page", plugin_dir_url( __FILE__ )."core/admin_graphics/icon.svg");
        add_submenu_page( "JigoshopMagicThumb-config-page", 'Settings', 'Settings', 'edit_posts', "JigoshopMagicThumb-config-page" );
        add_action('admin_print_scripts-' . $page, 'Jigoshop_MagicThumb_add_admin_src_to_menu_page');
    }

    if(function_exists("add_submenu_page")) {

        $license_page = add_submenu_page("JigoshopMagicThumb-config-page", "License", "License", "edit_posts", "JigoshopMagicThumb-license-page", "Jigoshop_MagicThumb_license_page");
        add_action('admin_print_scripts-' . $license_page, 'Jigoshop_MagicThumb_add_admin_src_to_license_page');
        $import_export_page = add_submenu_page("JigoshopMagicThumb-config-page", "Backup / Restore", "Backup / Restore", "edit_posts", "JigoshopMagicThumb-import-export-page", "Jigoshop_MagicThumb_import_export_page");
        add_action('admin_print_scripts-' . $import_export_page, 'Jigoshop_MagicThumb_add_admin_src_to_import_export_page');

    }
}


function Jigoshop_MagicThumb_import_export_page() {
    include 'core/view/import_export/jigoshop_MagicThumb_import_export.php';
}

function Jigoshop_MagicThumb_add_admin_src_to_import_export_page() {
    wp_enqueue_script( 'Jigoshop_MagicThumb_admin_import_export_script' );
    wp_localize_script( 'Jigoshop_MagicThumb_admin_import_export_script', 'magictoolbox_Jigoshop_MagicThumb_admin_modal_object', array('ajax' =>  get_site_url().'/wp-admin/admin-ajax.php', 'nonce' => wp_create_nonce('magic-everywhere')) );
}

function Jigoshop_MagicThumb_license_page() {
    include 'core/view/license/jigoshop_MagicThumb_license.php';
}

function Jigoshop_MagicThumb_add_admin_src_to_license_page() {
    wp_enqueue_script( 'Jigoshop_MagicThumb_admin_license_script' );
    wp_localize_script( 'Jigoshop_MagicThumb_admin_license_script', 'magictoolbox_Jigoshop_MagicThumb_admin_modal_object', array('ajax' =>  get_site_url().'/wp-admin/admin-ajax.php', 'nonce' => wp_create_nonce('magic-everywhere')) );
}

function magictoolbox_Jigoshop_MagicThumb_styles() {
    if(!defined('MAGICTOOLBOX_MAGICTHUMB_HEADERS_LOADED')) {
        $plugin = $GLOBALS['magictoolbox']['JigoshopMagicThumb'];

        
        if (function_exists('plugins_url')) {
            $core_url = plugins_url();
        } else {
            $core_url = get_option("siteurl").'/wp-content/plugins';
        }


        $path = preg_replace('/^.*?\/plugins\/(.*?)$/is', '$1', str_replace("\\","/",dirname(__FILE__)));

        $headers = $plugin->getHeadersTemplate($core_url."/{$path}/core");

            $scroll = Jigoshop_MagicThumb_LoadScroll($plugin);
            if($scroll) {
                $scroll->params->resetProfile();
                $headers .= $scroll->getHeadersTemplate($core_url."/{$path}/core", null, false);
            }
        echo $headers;
        define('MAGICTOOLBOX_MAGICTHUMB_HEADERS_LOADED', true);
    }
}

function magictoolbox_Jigoshop_MagicThumb_start_parsing () {
    $GLOBALS['magictoolbox']['Jigoshop_MagicThumb']['parse_status'] = 'started';
    ob_start();
}

function magictoolbox_Jigoshop_MagicThumb_end_parsing () {
    if (!isset($GLOBALS['magictoolbox']['Jigoshop_MagicThumb']['parse_status'])) return;
    $GLOBALS['magictoolbox']['Jigoshop_MagicThumb']['parse_status'] = 'ended';
    $content = ob_get_contents();
    ob_end_clean();
    $content = magictoolbox_Jigoshop_MagicThumb_create($content);
    echo $content;
}

function magictoolbox_Jigoshop_MagicThumb_start_alternative_parsing () {
    if (!isset($GLOBALS['magictoolbox']['Jigoshop_MagicThumb']['parse_status'])) ob_start();
}

function magictoolbox_Jigoshop_MagicThumb_end_alternative_parsing () {
    if (!isset($GLOBALS['magictoolbox']['Jigoshop_MagicThumb']['parse_status'])) {
        $content = ob_get_contents();
        ob_end_clean();
        $content = magictoolbox_Jigoshop_MagicThumb_create($content);
        echo $content;
    }
}
function magictoolbox_Jigoshop_MagicThumb_contentClean ($content) {
    global $wp_query;
    $plugin = $GLOBALS['magictoolbox']['JigoshopMagicThumb'];
    if (!$plugin->params->checkValue('use-effect-on-product-page','No') && isset($wp_query->query_vars['post_type']) && $plugin->params->checkValue('use_only_product_gallery','No') && $wp_query->query_vars['post_type'] == 'product') { //TODO
        $content = preg_replace('/(?:<a([^>]*)>)[^<]*<img([^>]*)(?:>)(?:[^<]*<\/img>)?(.*?)[^<]*?<\/a>/is','',$content); //TODO delete only what we really need.
        $content = preg_replace ('/<div id=\"attachment\_[0-9]+\"[^>]*?>.*?<\/div>/is','',$content);
        $content = preg_replace ('/<div[^>]id=[\"\']gallery-1[\"\'][^>]*>.*?<\/div>/is','',$content);
    }
    return $content;
}



function  magictoolbox_Jigoshop_MagicThumb_create($content) {
    global $magictoolbox_MagicThumb_page_has_tool;
    /*add_action( 'wp_print_footer_scripts', 'magictoolbox_Jigoshop_MagicThumb_denided_prettyPhoto_inline' );*/

    $plugin = $GLOBALS['magictoolbox']['JigoshopMagicThumb'];


    /*set watermark options for all profiles START */
    $defaultParams = $plugin->params->getParams('default');
    $wm = array();
    $profiles = $plugin->params->getProfiles();
    foreach ($defaultParams as $id => $values) {
    if (($values['group']) == 'Watermark') {
        $wm[$id] = $values;
    }
    }
    foreach ($profiles as $profile) {
    $plugin->params->appendParams($wm,$profile);
    }
    /*set watermark options for all profiles END */

    $toolPatern = "<a\s+[^>]*class\s*=[^>]*\"MagicThumb[^>]*\"[^>]*>\s*<img[^>]*>\s*<\s*\/\s*a>";


    $cat = Jigoshop_MagicThumb_page_check('Jigoshop');
    if ($cat === false) {

        $pattern = "(?:<a([^>]*(?:rel|class|data-rel)=[\'\"][^\"]*(?:thumbnails|woocommerce\-main\-image|prettyPhoto|zoom)[^\"]*[\'\"][^>]*)>)(?:<[^>]*>)?[^<]*<img([^>]*)(?:>)(?:[^<]*<\/img>)?(.*?)[^<]*?<\/a>";

        if (!preg_match("/{$pattern}/is",$content)) {
            $pattern = "<div[^>]*class=\"woocommerce-product-gallery__image\"><a([^>]*?)><img([^>]*(?:rel|class|data-rel)=[\'\"][^\"]*(?:thumbnails|woocommerce\-main\-image|prettyPhoto|zoom|attachment-shop_single)[^>]*)>(.*?)<\/a><\/div>";
        }

    } else if ($cat === true) {
        $pattern = "(?:<a([^>]*)>)[^<]*(?:<span[^>]*>[^<]*<\/span>)?[^<]*<img([^>]*)(?:>)(?:[^<]*<\/img>)?(.*?)<\/a>";
    } else {
        return $content;
    }

    $oldContent = $content;
    global $wp_query;
    $post_id = $wp_query->post->ID;



        $content = preg_replace_callback("/{$pattern}/is","magictoolbox_Jigoshop_MagicThumb_callback",$content);
        if ($content == $oldContent) return $content;
        $magictoolbox_MagicThumb_page_has_tool = true;


    if (@count($GLOBALS['MAGICTOOLBOX_'.strtoupper('magicthumb').'_SELECTORS']) > 0) { //if there any additional images present
        $selectors = '<div class="MagicToolboxSelectorsContainer">'.implode($GLOBALS['MAGICTOOLBOX_'.strtoupper('magicthumb').'_SELECTORS']).'</div>';
        $content = str_replace('{MAGICTOOLBOX_'.strtoupper('magicthumb').'_SELECTORS}',$selectors,$content); // insert selectors under main image

        $contentWithGallery = $content;


    }

    /*$content = str_replace('{MAGICTOOLBOX_'.strtoupper('magicthumb').'_MAIN_IMAGE_SELECTOR}',$GLOBALS['MAGICTOOLBOX_'.strtoupper('magicthumb').'_MAIN_IMAGE_SELECTOR'],$content);  //add main image selector to other
    $content = str_replace('{MAGICTOOLBOX_'.strtoupper('magicthumb').'_SELECTORS}','',$content); //if no selectors - remove constant
     onlyForModend  */

    
    if (!$plugin->params->checkValue('template','original') && $plugin->type == 'standard' && isset($GLOBALS['magictoolbox']['MagicThumb']['main'])) {
        // template helper class
        require_once(dirname(__FILE__) . '/core/magictoolbox.templatehelper.class.php');
        MagicToolboxTemplateHelperClass::setPath(dirname(__FILE__).'/core/templates');
        MagicToolboxTemplateHelperClass::setOptions($plugin->params);
        if (!Jigoshop_MagicThumb_page_check('Jigoshop')) { //do not render thumbs on category pages
            $thumbs = Jigoshop_MagicThumb_get_prepared_selectors($post_id);
        } else {
            $thumbs = array();
        }

        if (isset($GLOBALS['MAGICTOOLBOX_'.strtoupper('MagicThumb').'_SELECTORS']) && is_array($GLOBALS['MAGICTOOLBOX_'.strtoupper('MagicThumb').'_SELECTORS'])) {
        $thumbs = array_merge($thumbs,$GLOBALS['MAGICTOOLBOX_'.strtoupper('MagicThumb').'_SELECTORS']);
        }



    if (!isset($GLOBALS['magictoolbox']['prods_info']['product_id']) && isset($post_id)) {
        $GLOBALS['magictoolbox']['prods_info']['product_id'] = $post_id;
    } else if (!isset($GLOBALS['magictoolbox']['prods_info']['product_id']) && !isset($post_id)) {
        $GLOBALS['magictoolbox']['prods_info']['product_id'] = '';
    }
        $scroll = Jigoshop_MagicThumb_LoadScroll($plugin);

        $mainHTML = $GLOBALS['magictoolbox']['MagicThumb']['main'];
        $magicscrollOptions = '';
        if($plugin->params->checkValue('magicscroll', 'Yes')) {
            $magicscrollOptions = $scroll->params->serialize(false, '', 'product-magicscroll-options');
        }


        $html = MagicToolboxTemplateHelperClass::render(array(
            'main' => $mainHTML,
            'thumbs' => (count($thumbs) >= 1) ? $thumbs : array(),
            'magicscrollOptions' => $magicscrollOptions,
            'pid' => $GLOBALS['magictoolbox']['prods_info']['product_id'],
        ));



        $content = str_replace('MAGICTOOLBOX_PLACEHOLDER', $html, $content);
    } else if ($plugin->params->checkValue('template','original') || $plugin->type != 'standard') {
        if (isset($GLOBALS['MAGICTOOLBOX_'.strtoupper('magicthumb').'_MAIN_IMAGE_SELECTOR'])) {
            $content = str_replace('{MAGICTOOLBOX_'.strtoupper('magicthumb').'_MAIN_IMAGE_SELECTOR}', $GLOBALS['MAGICTOOLBOX_'.strtoupper('magicthumb').'_MAIN_IMAGE_SELECTOR'], $content);  //add main image selector to other
        }
        if (isset($GLOBALS['magictoolbox']['MagicThumb'])) {
            $html = $GLOBALS['magictoolbox']['MagicThumb']['main'];
            $content = str_replace('MAGICTOOLBOX_PLACEHOLDER', $html, $content);
        }
    }
    $content = str_replace('{MAGICTOOLBOX_'.strtoupper('magicthumb').'_MAIN_IMAGE_SELECTOR}','',$content);
    $content = str_replace('{MAGICTOOLBOX_'.strtoupper('magicthumb').'_SELECTORS}','',$content); //if no selectors - remove constant
    $content = preg_replace ('/<div[^>]*?class="thumbnails[^"]*?"[^>]*?>.*?div>/is','',$content); // remove selectors div
    $content = preg_replace ('/<div[^>]*?class="woocommerce-product-gallery__image[^"]*?"[^>]*?>.*?div>/is','',$content); // remove selectors div



    if (!$magictoolbox_MagicThumb_page_has_tool) {
        if (preg_match("/{$toolPatern}/is", $content)) {
            $magictoolbox_MagicThumb_page_has_tool = true;
        }
    }

    return $content;
}

function magictoolbox_Jigoshop_MagicThumb_key_sort($a, $b){
    return strnatcasecmp(basename($a['img']),basename($b['img']));
}




function  magictoolbox_Jigoshop_MagicThumb_callback($matches) {
    $plugin = $GLOBALS['magictoolbox']['JigoshopMagicThumb'];
    $title = "";
    $float = "";
    $cat = Jigoshop_MagicThumb_page_check('Jigoshop');
    if ($cat === 'error') return $matches[0];
    if ($cat) $plugin->params->setProfile('category');
    if (!$cat) $plugin->params->setProfile('product');
    $plugin_enabled = true;
    $is_selector = true;
    $is_main = true;
    


    if(!preg_match("/class\s*=\s*[\'\"]zoom[\'\"]/iUs",$matches[0]) &&
       !preg_match("/class=[\'\"]attachment-(?:medium|large|shop_small|[0-9]+x[0-9]+)(?:\s+size-[^ ]*)?\s+(?:wp-post-image|tcp_size-thumbnail)?[\'\"]/iUs",$matches[0]) &&
       !preg_match("/class\s*=\s*[\'\"]tcp_size-thumbnail[\'\"]/iUs",$matches[0])
    ) {
    $is_main = false;
    }
    if(!preg_match("/class\s*=\s*[\'\"][^\"]*?(?:zoom|attachment-thumbnail|size-medium)[^\"]*?[\'\"]/iUs",$matches[0])) {
        $is_selector = false;
    }
    if (!$is_selector && !$is_main) {
        $plugin_enabled = false;
    }
    if ($plugin->params->checkValue('page-status','No')) $plugin_enabled = false;
    if (!$plugin_enabled) return $matches[0];


    $alignclass = preg_replace('/^.*?align(left|right|center|none).*$/is', '$1', $matches[2]);
    if($alignclass != $matches[2]) {
        $alignclass = ' align'.$alignclass;
    } else {
        $alignclass='';
        $float = preg_replace('/^.*?float:\s*(left|right|none).*$/is', '$1', $matches[2]);
        if($float == $matches[2]) {
            $float = '';
        } else {
            $float = ' float: ' . $float . ';';
        }
    }
    // get needed attributes
    global $wp_query;
    $alt = preg_replace("/^.*?alt\s*=\s*[\"\'](.*?)[\"\'].*$/is","$1",$matches[2]);
    if (isset($matches[1]) && !empty($matches[1])) { // thecartpress fix
    $img = preg_replace("/^.*?href\s*=\s*[\"\'](.*?)[\"\'].*$/is","$1",$matches[1]);
    $thumb = preg_replace("/^.*?src\s*=\s*[\"\'](.*?)[\"\'].*$/is","$1",$matches[2]);
    } else {
    $thumb = $img = preg_replace("/^.*?href\s*=\s*[\"\'](.*?)[\"\'].*$/is","$1",$matches[2]); // only thecartpress
    }
    
    
    //$prod_name = $wp_query->post->post_title;
    $title = get_post(get_post_thumbnail_id($wp_query->post->ID))->post_title;
    if (empty($title)) $title = $wp_query->post->post_title;
    
    $title = preg_replace("/^.*?<strong>([^<]*)<\/strong>.*$/is","$1",$matches[0]);
    if (!$cat) $title = $prod_name;
    
    

    

    if (!$cat) {
        $additionalDescription = preg_replace ('/<a[^>]*><img[^>]*><\/a>/is','',$wp_query->post->post_excerpt);
        $description = preg_replace ('/<a[^>]*><img[^>]*><\/a>/is','',$wp_query->post->post_content);
        $description = preg_replace ('/\[caption id=\"attachment_[0-9]+\"[^\]]*?\][^\[]*?\[\/caption\]/is','',$description);
        $id = '_Main_Product'.$wp_query->post->ID;
    } else {
        $id = '_Main';
        $description = $additionalDescription = '';
        $link = $img;
        $info = substr($matches[3],0,-1);
        $info = preg_replace('/(.*?)(<strong>.*?<\/strong>)(.*)/is','$1 <a href="'.$link.'">$2</a>$3',$info);


        $plugin->params->setValue('show-message', 'no');
        if (!$plugin->params->checkValue('link-to-product-page', 'Yes')) {
            $link = false;
        }
    }

    $aStyles = $matches[1];
    $imgStyles = $matches[2];
    
    $matches[1] = preg_replace("/^(.*?)rel\s*=\s*[\"\'].*?[\"\']/is","$1",$matches[1]);
    
    $matches[1] = preg_replace("/^(.*?)id\s*=\s*[\"\'].*?[\"\']/is","$1",$matches[1]);
    $matches[1] = preg_replace("/^(.*?)class\s*=\s*[\"\'].*?[\"\']/is","$1",$matches[1]);
    $matches[1] = preg_replace("/^(.*?)title\s*=\s*[\"\'].*?[\"\']/is","$1",$matches[1]);
    $matches[1] = preg_replace("/^(.*?)rev\s*=\s*[\"\'].*?[\"\']/is","$1",$matches[1]);
    $matches[1] = preg_replace("/^(.*?)href\s*=\s*[\"\'].*?[\"\']/is","$1",$matches[1]);
    // remove src attribute from img
    $matches[2] = preg_replace("/^(.*?)src\s*=\s*[\"\'].*?[\"\']/is","$1",$matches[2]);
    $matches[2] = preg_replace("/\/\s*$/is"," ",$matches[2]);
    $matches[2] = preg_replace("/^(.*?)srcset\s*=\s*[\"\'].*?[\"\']/is","$1",$matches[2]);
    

    if ($is_main) { //if it is MAIN IMAGE

        if ($cat) $id = $id.md5(rand());
        if (isset($GLOBALS['magictoolbox_main_image_set']) && !$cat) {
            return $matches[0];
        }
        $GLOBALS['magictoolbox_main_image_set'] = true;



        $img_name = preg_replace('/(^.*?)(\/wp-content.*?(?:\.(?:jpg|jpeg|gif|png)))(.*)/is','$2',$thumb);
        $img_name = preg_replace('/(.*)-[0-9]+x[0-9]+(\.(jpg|png|jpeg|gif))/is','$1$2',$img_name);


        if (!preg_match('/wp-content/is',$img_name)) { //try to fix subdomain path
           $img_name = '/wp-content/uploads'.$img_name;
        }

        if ($is_main && !$cat) { //90639
            $img_name = str_replace(get_site_url(),'',wp_get_attachment_url( get_post_thumbnail_id($GLOBALS['post']->ID) ));
        }

        $thumb = Jigoshop_MagicThumb_get_product_image($img_name,'thumb');
        $thumb2x = Jigoshop_MagicThumb_get_product_image($img_name,'thumb2x');

        $img = Jigoshop_MagicThumb_get_product_image($img_name,'original');

        if (!$cat) {
            $result = 'MAGICTOOLBOX_PLACEHOLDER';

            $GLOBALS['magictoolbox']['MagicThumb']['main'] = $plugin->getMainTemplate(compact('img','thumb','thumb2x','id','title','description','additionalDescription','link'));

        } else {
            $result = $plugin->getMainTemplate(compact('img','thumb','thumb2x','id','title','alt','description','additionalDescription','link'));
        }


        if (!$plugin->params->checkValue('create-main-image-selector','No') && !isset($GLOBALS['MAGICTOOLBOX_'.strtoupper('magicthumb').'_MAIN_IMAGE_SET'])) {
            $medium = Jigoshop_MagicThumb_get_product_image($img_name,'thumb');
            $medium2x = Jigoshop_MagicThumb_get_product_image($img_name,'thumb2x');
            $thumb = Jigoshop_MagicThumb_get_product_image($img_name,'selector');
            $thumb2x = Jigoshop_MagicThumb_get_product_image($img_name,'selector2x');
            //if (isset($title)) { $alt = $title; } else { $alt = ''; }
            $GLOBALS['MAGICTOOLBOX_'.strtoupper('magicthumb').'_MAIN_IMAGE_SELECTOR'] = $GLOBALS['magictoolbox']['MagicThumb']['selectors'][] = $plugin->getSelectorTemplate(compact('alt','img','medium','medium2x','thumb','thumb2x','id')); //save main image selector to globals
            $GLOBALS['MAGICTOOLBOX_'.strtoupper('magicthumb').'_MAIN_IMAGE_SELECTOR'] = str_replace('<img','<img class="attachment-90x90" ',$GLOBALS['MAGICTOOLBOX_'.strtoupper('magicthumb').'_MAIN_IMAGE_SELECTOR']);
        }

    }
     if ($is_selector && !$is_main && !$cat) { //if image is SELECTOR
        if (isset($title)) { $alt = $title; } else { $alt = ''; }
        $medium_name = str_replace(site_url('','http'),'',$thumb);
        if ($medium_name == $thumb) { //maybe https
        $medium_name = str_replace(site_url('','https'),'',$thumb);
        }
        if ($medium_name == $thumb) {
            $medium_name = preg_replace('/https?:\/\/.*?(\/.*)/ims','$1',$thumb);
        }
        $medium_name = preg_replace('/(.*)-[0-9]+x[0-9]+(\.(jpg|png|jpeg|gif))/is','$1$2',$medium_name);
        $medium = Jigoshop_MagicThumb_get_product_image($medium_name,'thumb');
        $medium2x = Jigoshop_MagicThumb_get_product_image($medium_name,'thumb2x');
        $img = Jigoshop_MagicThumb_get_product_image($medium_name,'original');
        $thumb = Jigoshop_MagicThumb_get_product_image($medium_name,'selector');
        $thumb2x = Jigoshop_MagicThumb_get_product_image($medium_name,'selector2x');
        if ($plugin->params->checkValue('template','original')) {
            $result = $plugin->getSelectorTemplate(compact('alt','img','medium','medium2x','thumb','thumb2x','id','title'));
        } else {
            $result = '';
            $GLOBALS['magictoolbox']['MagicThumb']['selectors'][] = $plugin->getSelectorTemplate(compact('alt','img','medium','medium2x','thumb','thumb2x','id','title'));
        }

        if (!isset($GLOBALS['MAGICTOOLBOX_'.strtoupper('magicthumb').'_MAIN_IMAGE_SELECTOR_SET'])) {
            $prefix = '{MAGICTOOLBOX_'.strtoupper('magicthumb').'_MAIN_IMAGE_SELECTOR}';
            $GLOBALS['MAGICTOOLBOX_'.strtoupper('magicthumb').'_MAIN_IMAGE_SELECTOR_SET'] = true;
        }
    }
    $result = preg_replace("/^(.*?)<a(.*?)$/is","$1<a {$matches[1]}$2",$result);
    $result = preg_replace("/^(.*?)<img(.*?)$/is","$1<img {$matches[2]}$2",$result);


    if (empty($prefix)) $prefix = '';
    if (empty($info)) $info = '';
     if ($is_main) {
        $result = $prefix."<div style=\"{$float}\" class=\"MagicToolboxContainer\">{$result}</div>";
        $result = $result . $info;
        if ($plugin->params->checkValue('keep-selectors-position','No')) {//load selectors under main image
            $result = $result.'{MAGICTOOLBOX_'.strtoupper('magicthumb').'_SELECTORS}';
        }
        /*if (!$cat) {
            if (!isset($GLOBALS['MAGICTOOLBOX_'.strtoupper('magicthumb').'_MAIN_IMAGE_SET'])) $result = $matches[0];
            $GLOBALS['MAGICTOOLBOX_'.strtoupper('magicthumb').'_MAIN_IMAGE_SET'] = 'true';
        }*/ //TODO WHAT IS THIS ?
    } else if ($is_selector) {
        $result = $prefix.$result;
         if ($plugin->params->checkValue('keep-selectors-position','No')) {//load selectors under main image
            $GLOBALS['MAGICTOOLBOX_'.strtoupper('magicthumb').'_SELECTORS'][] = $result;
            $result = $matches[0];
        }
    }

    return $result;

}

function Jigoshop_MagicThumb_get_product_image($title,$size = 'thumb', $image_id = false) {
    $cat = Jigoshop_MagicThumb_page_check('Jigoshop');
    $result = $title;

    global $wp_query;
    $post_id = $wp_query->post->ID;


    
    $oldLocale = setlocale(LC_ALL, NULL);
    setlocale(LC_ALL, 'en_US.UTF8');
    
    $plugin = $GLOBALS["magictoolbox"]["JigoshopMagicThumb"];
    //$plugin->params->setValue('caption-source','title');
    $useWpImages = $plugin->params->checkValue('use-wordpress-images','yes');
    
    if ($useWpImages ) { 
        
         if (!$image_id) {
            $image_id = get_post_thumbnail_id( $post_id );
        } 
        
        if ($size != 'original') {
            if (!$cat) {
                $thumb = wp_get_attachment_image_src( $image_id, $plugin->params->getValue('single-wordpress-image') );
            } else {
                $thumb = wp_get_attachment_image_src( $image_id, $plugin->params->getValue('category-wordpress-image') );
            }
        } else {
            $thumb = wp_get_attachment_image_src( $image_id, 'full' ); 
        }

        $result = $thumb[0];
        
    } else {

        

        if (!isset($GLOBALS['imagehelper'])) {
            require_once(dirname(__FILE__) . '/core/magictoolbox.imagehelper.class.php');
            $image_dir = 'wp-content/uploads/';
            $url = site_url();
            $shop_dir = ABSPATH;
            $GLOBALS['imagehelper'] = new MagicToolboxImageHelperClass($shop_dir, $image_dir.'magictoolbox_cache', $plugin->params, null, $url);
        }

        $result = $GLOBALS['imagehelper']->create( $title, $size, $post_id);
    }
    setlocale(LC_ALL, $oldLocale);

    return $result;

}

function Jigoshop_MagicThumb_get_post_attachments($addMain = false)  {

    global $wp_query;
    $plugin = $GLOBALS["magictoolbox"]["JigoshopMagicThumb"];
    $post_id = $wp_query->post->ID;
    $attachments = array();
    $postmeta = get_post_meta($post_id);
    if (isset($postmeta['_product_image_gallery'][0])) {
        $metaGallery = explode(',',$postmeta['_product_image_gallery'][0]);
    }
    $args = array(
            'post_type' => 'attachment',
            'numberposts' => '-1',
            'post_status' => null,
            'post_parent' => $post_id
        );

    $attachments = get_posts($args);
    return $attachments;
}


function Jigoshop_MagicThumb_get_prepared_selectors ($post_id, $useWpImages = false) {

    $attachments = Jigoshop_MagicThumb_get_post_attachments($useWpImages);

    /*global $wp_query, $product;
    $post_id = $wp_query->post->ID;*/
    if (empty($post_id) && !empty($_REQUEST['prodid'])) {
        $post_id = $_REQUEST['prodid'];
    }
    $product = wc_get_product( $post_id );
    $id = '_Main_Product'.$product->get_id();



    
    $selectors = array();
    $oldLocale = setlocale(LC_ALL, NULL);
    setlocale(LC_ALL, 'en_US.UTF8');

    $plugin = $GLOBALS['magictoolbox']['JigoshopMagicThumb'];

    if ($useWpImages) { 
    
        foreach ($attachments as $attachment) {

            $img = wp_get_attachment_image_src( $attachment->ID, 'full' ); 
            $img = $img[0];
            
            $medium = wp_get_attachment_image_src( $attachment->ID, $plugin->params->getValue('single-wordpress-image') );
            $medium = $medium[0];
            
            $thumb = wp_get_attachment_image_src( $attachment->ID, $plugin->params->getValue('thumbnails-wordpress-image') ); 
            $thumb = $thumb[0];
            
            $alt = get_post_meta($attachment->ID, '_wp_attachment_image_alt', true);
            $title = $attachment->post_title;
            
            $selectors[] = $plugin->getSelectorTemplate(compact('alt','img','medium','thumb','id','title'));
            
        }
        
    } else {

        require_once(dirname(__FILE__) . '/core/magictoolbox.imagehelper.class.php');
        $url = site_url();
        $shop_dir = ABSPATH;
        $image_dir = 'wp-content/uploads/';
        $imagehelper = new MagicToolboxImageHelperClass($shop_dir, $image_dir.'magictoolbox_cache', $plugin->params, null, $url);

        
        if (isset($GLOBALS['MAGICTOOLBOX_'.strtoupper('MagicThumb').'_MAIN_IMAGE_SELECTOR'])) $selectors[] = $GLOBALS['MAGICTOOLBOX_'.strtoupper('MagicThumb').'_MAIN_IMAGE_SELECTOR'];

        if (isset($GLOBALS['MAGICTOOLBOX_'.strtoupper('MagicThumb').'_MAIN_IMAGE_SELECTOR'])) {
            $test_link = preg_replace('/.*?href=[\'\"](.*?)[\'\"].*/is','$1',$GLOBALS['MAGICTOOLBOX_'.strtoupper('MagicThumb').'_MAIN_IMAGE_SELECTOR']);
            if (count($attachments) == 1) {
            $attachmentsKeys = array_keys($attachments);
            if (basename($attachments[$attachmentsKeys[0]]->guid) == basename($test_link)) return array();
            }
        } else {
            $test_link = false;
        }

        foreach ($attachments as $attachment) {
        if (is_object($attachment)) {
            if (!preg_match('/image/is',$attachment->post_mime_type)) continue;
            $meta = wp_get_attachment_metadata($attachment->ID);
            if ($test_link) {
                if (basename($attachment->guid) == basename($test_link)) continue;
            }
            //$title = $alt = '';
            $title = $attachment->post_title;
            $alt = get_post_meta($attachment->ID, '_wp_attachment_image_alt', true);

            
            $imgpath = str_replace($shop_dir,'/',get_attached_file($attachment->ID));

            $img = $imagehelper->create( $imgpath, 'original', $post_id);//$url.'/'.$image_dir.$meta['file'];
            $medium = $imagehelper->create( $imgpath, array($plugin->params->getValue('thumb-max-width'),$plugin->params->getValue('thumb-max-height')), $post_id);
            $medium2x = $imagehelper->create( $imgpath, array($plugin->params->getValue('thumb-max-width')*2,$plugin->params->getValue('thumb-max-height')*2), $post_id);
            $thumb = $imagehelper->create( $imgpath, array($plugin->params->getValue('selector-max-width'),$plugin->params->getValue('selector-max-height')), $post_id);
            $thumb2x = $imagehelper->create( $imgpath, array($plugin->params->getValue('selector-max-width')*2,$plugin->params->getValue('selector-max-height')*2), $post_id);
            $selectors[] = $plugin->getSelectorTemplate(compact('alt','img','medium','medium2x','thumb','thumb2x','id','title'));
        } else { // thecartpress
            $title = $alt = 'NO TITLE YET';
            $file = preg_replace('/^.*?wp-content\/uploads\//is','',$attachment);
            $img = $imagehelper->create( '/'.$image_dir.$file, 'original', $post_id);
            $medium = $imagehelper->create( '/'.$image_dir.$file, array($plugin->params->getValue('thumb-max-width'),$plugin->params->getValue('thumb-max-height')), $post_id);
            $medium2x = $imagehelper->create( '/'.$image_dir.$file, array($plugin->params->getValue('thumb-max-width')*2,$plugin->params->getValue('thumb-max-height')*2), $post_id);
            $thumb = $imagehelper->create( '/'.$image_dir.$file, array($plugin->params->getValue('selector-max-width'),$plugin->params->getValue('selector-max-height')), $post_id);
            $thumb2x = $imagehelper->create( '/'.$image_dir.$file, array($plugin->params->getValue('selector-max-width')*2,$plugin->params->getValue('selector-max-height')*2), $post_id);
            $selectors[] = $plugin->getSelectorTemplate(compact('alt','img','medium','medium2x','thumb','thumb2x','id','title'));
        }

        }
    }


    setlocale(LC_ALL, $oldLocale);

    return $selectors;
}


function Jigoshop_MagicThumb_page_check ($moduleName = false) {
    switch (strtolower($moduleName)) {
        case 'wpecommerce' : {
            if (!WPSC_VERSION) return 'error';
            if (WPSC_PRESENTABLE_VERSION == '3.7.6.3' || WPSC_PRESENTABLE_VERSION == '3.7.6.4' || WPSC_PRESENTABLE_VERSION == '3.7.8') {
                if ($GLOBALS["wpsc_title_data"]["product"]) {
                    $cat = false;
                }else {
                    $cat = true;
                }
            } else if (WPSC_VERSION == '3.8') {
                if (isset($GLOBALS['wp_the_query']->query_vars['wpsc-product']) && $GLOBALS['wp_the_query']->query_vars['wpsc-product'] != '') {
                    $cat = false;
                } else {
                    $cat = true;
                }
            } else
            if (version_compare(WPSC_VERSION, '3.8.1', '>=')) {
                    if ( $GLOBALS['wp_the_query']->is_single == '1') { /*isset($GLOBALS['wp_the_query']->is_product) && $GLOBALS['wp_the_query']->is_product == '1'*/
                        $cat = false;
                    } else {
                        $cat = true;
                    }
            } else {
                if (!empty($GLOBALS['wp_query']->query_vars['product_url_name']) && $GLOBALS['wp_query']->query_vars['product_url_name'] != '') {
                    $cat = false;
                } else {
                    $cat = true;
                }
            }
        break;}
        case 'jigoshop' : {
            if (!JIGOSHOP_VERSION) return 'error';
            if (function_exists('is_product') && function_exists('is_product_list')) {

              //if (is_product()) $cat = false; else $cat = true;
              if ($GLOBALS['post']->post_type=='product' || is_product()) $cat = false; else $cat = true;

              if (is_product_list()) $cat = true; else $cat = false;
            } else {
              return 'error';
            }
        break;}
    case 'woocommerce' : {
            if (!WOOCOMMERCE_VERSION) return 'error';
            if (function_exists('is_product') && function_exists('is_product_category')) {
              if (is_product()) { 
                    $cat = false; 
                } else { 
                    //if (isset($GLOBALS['post']->post_content) && preg_match('/\[product_page\s+id=\"\d+\"\]/is',$GLOBALS['post']->post_content) !== false) {
                    if (isset($GLOBALS['post']->post_content) && preg_match('/\[product_page\s+id=\"\d+\"\]/is',$GLOBALS['post']->post_content) != false) {
                        $cat = false; 
                    } else {
                        $cat = true;     
                    }
                }
              //if ($GLOBALS['post']->post_type=='product' || is_product()) $cat = false; else $cat = true;
            } else {
              return 'error';
            }
        break;}
        case 'thecartpress' : {
        global $thecartpress;
            if (!isset($thecartpress->settings)) return 'error';
            if (function_exists('is_single')) {
              if (is_single()) $cat = false; else $cat = true;
            } else {
              return 'error';
            }
        break;}

        default : return 'error';
    }
    return $cat;
}



function JigoshopMagicThumb_url ($url,$position) {

    if ('commercial' == get_tool_version_Jigoshop_MagicThumb()) {
    $utm_source = 'CommercialVerison';
    } else {
    if (magictoolbox_Jigoshop_MagicThumb_get_data_from_db()) {
        $utm_source = 'CommercialVersion';
    } else {
        $utm_source = 'TrialVersion';
    }
    }

    $utm_medium = 'Jigoshop';
    $utm_content = preg_replace('/\s+/is','-',trim($position));
    $utm_campaign = 'MagicThumb';

    $link = $url.'?utm_source='.$utm_source.'&utm_medium='.$utm_medium.'&utm_content='.$position.'&utm_campaign='.$utm_campaign;

    return $link;
}

// function JigoshopMagicThumb_params_map_check ($profile = 'default', $group, $parameter) {
//     $map = JigoshopMagicThumb_getParamsMap();
//     if (isset($map[$profile][$group][$parameter])) return true;
//     return false;
// }
function JigoshopMagicThumb_getParamsMap () {
    $map = array(
		'product' => array(
			'General' => array(
				'include-headers',
				'page-status',
				'magicscroll',
			),
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
				'square-images',
			),
			'Expanded view' => array(
				'expandEffect',
				'expandSpeed',
				'expandImageSize',
				'expandTrigger',
				'expandAlign',
				'expandEasing',
				'gallerySpeed',
			),
			'Multiple images' => array(
				'template',
				'selectors-margin',
				'selectorTrigger',
				'selectorEffect',
				'selector-max-width',
				'selector-max-height',
			),
			'Title and Caption' => array(
				'show-caption',
				'captionPosition',
			),
			'Miscellaneous' => array(
				'create-main-image-selector',
				'keyboard',
				'group',
				'cssClass',
				'rightClick',
				'lazyLoad',
				'autostart',
				'image-quality',
			),
			'Buttons' => array(
				'buttons',
				'textBtnClose',
				'textBtnNext',
				'textBtnPrev',
			),
			'Hint' => array(
				'hint',
				'textClickHint',
				'textHoverHint',
			),
			'Mobile' => array(
				'slideMobileEffect',
				'textClickHintForMobile',
			),
			'Scroll' => array(
				'width',
				'height',
				'mode',
				'items',
				'speed',
				'autoplay',
				'loop',
				'step',
				'arrows',
				'pagination',
				'easing',
				'scrollOnWheel',
				'lazy-load',
				'scroll-extra-styles',
				'show-image-title',
			),
			'Use Wordpress images' => array(
				'use-wordpress-images',
				'single-wordpress-image',
				'thumbnails-wordpress-image',
			),
		),
		'category' => array(
			'General' => array(
				'include-headers',
				'page-status',
			),
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
				'square-images',
			),
			'Expanded view' => array(
				'expandEffect',
				'expandSpeed',
				'expandImageSize',
				'expandTrigger',
				'expandAlign',
				'expandEasing',
				'gallerySpeed',
			),
			'Title and Caption' => array(
				'show-caption',
				'captionPosition',
			),
			'Miscellaneous' => array(
				'create-main-image-selector',
				'link-to-product-page',
				'keyboard',
				'group',
				'cssClass',
				'rightClick',
				'lazyLoad',
				'autostart',
				'image-quality',
			),
			'Buttons' => array(
				'buttons',
				'textBtnClose',
				'textBtnNext',
				'textBtnPrev',
			),
			'Hint' => array(
				'hint',
				'textClickHint',
				'textHoverHint',
			),
			'Mobile' => array(
				'slideMobileEffect',
				'textClickHintForMobile',
			),
			'Use Wordpress images' => array(
				'use-wordpress-images',
				'category-wordpress-image',
			),
		),
		'default' => array(
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
				'square-images',
			),
			'Expanded view' => array(
				'expandEffect',
				'expandSpeed',
				'expandImageSize',
				'expandTrigger',
				'expandAlign',
				'expandEasing',
				'gallerySpeed',
			),
			'Title and Caption' => array(
				'show-caption',
				'captionPosition',
			),
			'Miscellaneous' => array(
				'create-main-image-selector',
				'link-to-product-page',
				'keyboard',
				'group',
				'cssClass',
				'rightClick',
				'lazyLoad',
				'autostart',
				'imagemagick',
				'image-quality',
			),
			'Buttons' => array(
				'buttons',
				'textBtnClose',
				'textBtnNext',
				'textBtnPrev',
			),
			'Watermark' => array(
				'watermark',
				'watermark-max-width',
				'watermark-max-height',
				'watermark-opacity',
				'watermark-position',
				'watermark-offset-x',
				'watermark-offset-y',
			),
			'Hint' => array(
				'hint',
				'textClickHint',
				'textHoverHint',
			),
			'Mobile' => array(
				'slideMobileEffect',
				'textClickHintForMobile',
			),
			'Use Wordpress images' => array(
				'use-wordpress-images',
				'category-wordpress-image',
			),
		),
	);
    return $map;
}

function JigoshopMagicThumb_getParamsProfiles () {

    $blocks = array(
		'product' => 'Product pages',
		'category' => 'Category pages',
		'default' => 'General',
	);

    return $blocks;
}

function JigoshopMagicThumb_welcome_license_do_redirect() {
  // Bail if no activation redirect
    if ( ! get_transient( 'Jigoshop_MagicThumb_welcome_license_activation_redirect' ) ) {
    return;
  }

  // Delete the redirect transient
  delete_transient( 'Jigoshop_MagicThumb_welcome_license_activation_redirect' );

  // Bail if activating from network, or bulk
  if ( is_network_admin() || isset( $_GET['activate-multi'] ) ) {
    return;
  }

  // Redirect to bbPress about page
  wp_safe_redirect( add_query_arg( array( 'page' => 'JigoshopMagicThumb-license-page' ), admin_url( 'admin.php' ) ) );

}

function JigoshopMagicThumb_plugin_path() {

  return untrailingslashit( plugin_dir_path( __FILE__ ) );
 
}
 
function Jigoshop_MagicThumb_locate_template( $template, $template_name, $template_path ) {
 
  global $woocommerce;
 
  $_template = $template;
 
  if ( ! $template_path ) $template_path = $woocommerce->template_url;
 
  $plugin_path  = JigoshopMagicThumb_plugin_path() . '/core/templates/';
  
  $template = locate_template(
 
    array(
 
      $template_path . $template_name,
 
      $template_name
 
    )
 
  );
    $post_id = get_the_id();

    if(function_exists('wpml_get_default_language')){
        $default_language = wpml_get_default_language();
        global $main_id;
        $main_id = icl_object_id($post_id, 'post', true, $default_language);

        if($main_id !== $post_id) $post_id = $main_id;   
    }

    if (preg_match('/single-product\/images\/product-image-[^\.]*\.php/is',$template_name) != false) { //fix for puca theme
        $template_name = '/single-product/product-image.php'; 
    } 
      
    if ( file_exists( $plugin_path . $template_name ) ) {
        $template = $plugin_path . $template_name;
    } else {
        $template = $_template;
    }
  
    if ( ! $template ) {
        $template = $_template;
    }

  return $template;
 
}

function Jigoshop_MagicThumb_get_containers_data($thumbs = array(), $post_id = false, $useWpImages = false) {

    $mainHTML = '';
    $GLOBALS['defaultContainerId'] = 'zoom';
    $containersData = array(
        'zoom' => '',
        '360' => '',
    );
    $productImagesHTML = array();

    $plugin = $GLOBALS['magictoolbox']['JigoshopMagicThumb'];
    
    $main_image = $GLOBALS['magictoolbox']['MagicThumb']['main'];
    $main_image = preg_replace('/(<a.*?class=\".*?)\"/is', "$1" . ' lightbox-added"', $main_image);
    $containersData['zoom'] = $main_image;

    if(isset($thumbs) && !empty($thumbs)){ 
        foreach ($thumbs as $index => $thumb) {
            $thumbs[$index] = str_replace('<a ', '<a data-product-id="'.$post_id.'" data-magic-slide-id="zoom" ', $thumb);
        }
     }

    $sMaxWidth = $sMaxHeight = 0;
    if ($useWpImages) {
        global $_wp_additional_image_sizes;
        $imageSize = $plugin->params->getValue('thumbnails-wordpress-image', 'product');
        if (in_array( $imageSize, array('thumbnail', 'medium', 'medium_large', 'large'))) {
            $sMaxWidth = (int)get_option($imageSize.'_size_w');
            $sMaxHeight = (int)get_option($imageSize.'_size_h');
        } else if (isset( $_wp_additional_image_sizes[$imageSize] ) ) {
            $sMaxWidth = (int)$_wp_additional_image_sizes[$imageSize]['width'];
            $sMaxHeight = (int)$_wp_additional_image_sizes[$imageSize]['height'];
        }
    } else {
        $sMaxWidth = (int)$plugin->params->getValue('selector-max-width', 'product');
        $sMaxHeight = (int)$plugin->params->getValue('selector-max-height', 'product');
    }

    $sizeStyle = '';
    if ((int)$sMaxHeight && (int)$sMaxWidth) {
        $sizeStyle = ' style="max-width: '.$sMaxWidth.'px; max-height: '.$sMaxHeight.'px;" ';
    } 

    //video data
    if (metadata_exists( 'post', $post_id, '_provide_videolinks_field' )){
        $scrollEnabled = $plugin->params->checkValue('magicscroll', 'Yes');
        $productVideos = get_post_meta( $post_id, '_provide_videolinks_field', true );
        
        if (!empty($productVideos) && preg_match('/a\:\d+/is',$productVideos)) {
        
            $productVideos = unserialize($productVideos);
            $videoIndex = 1;
         
            foreach ($productVideos as $videoUrl => $videoData) {
                if($videoData['youtube']) {
                    $dataVideoType = 'youtube';
                    $url = 'https://www.youtube.com/embed/'.$videoData['code'];
                    $containersData['video-'.$videoIndex] = '<iframe src="https://www.youtube.com/embed/'.$videoData['code'].'?enablejsapi=1"';
                } else {
                    $dataVideoType = 'vimeo';
                    $url = 'https://player.vimeo.com/video/'.$videoData['code'];
                    $containersData['video-'.$videoIndex] = '<iframe src="https://player.vimeo.com/video/'.$videoData['code'].'?byline=0&portrait=0"';
                }
                
                $containersData['video-'.$videoIndex] .=' frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen data-product-id="'.$post_id.'" data-video-type="'.$dataVideoType.'"></iframe>';
                
                $videoData['thumb'] = str_replace('http://', 'https://', $videoData['thumb']);
                
                $productImagesHTML[] =
                    '<a data-magic-slide-id="video-'.$videoIndex.'" data-product-id="'.$post_id.'" data-video-type="'.$dataVideoType.'" class="video-selector" href="#" onclick="return false">'.
                    '<span><b></b></span>'.
                    '<img src="'.$videoData['thumb'].'" alt="video"'.($scrollEnabled ? '' : ' style="max-width: '.$sMaxWidth.'px; max-height: '.$sMaxHeight.'px;"').'/>'.
                    '</a>';
                $videoIndex++;
            }
            
        }
    }

    $main_id = 0;
    if(function_exists('wpml_get_default_language')){
        $default_language = wpml_get_default_language();
        global $main_id;
        $main_id = icl_object_id($post_id, 'post', true, $default_language);
    }


    if ((metadata_exists( 'post', $post_id, '_magic360_data' ) || metadata_exists( 'post', $main_id, '_magic360_data' )) && magictoolbox_Jigoshop_MagicThumb_check_plugin_active('magic360') ){

        $magic360_plugin = $GLOBALS['magictoolbox']['WooCommerceMagic360'];
        $magic360_plugin->params->setProfile('product');

        if(!empty($magic360_plugin) && $magic360_plugin->params->checkValue('page-status','Yes') ){

            $magic360_data = json_decode((get_post_meta( $post_id, '_magic360_data', true )), true);

            if(function_exists('wpml_get_default_language')){
                $default_language = wpml_get_default_language();
                global $main_id;
                $main_id = icl_object_id($post_id, 'post', true, $default_language);
                $magic360_data = json_decode((get_post_meta( $main_id, '_magic360_data', true )), true);
            }


            $magic360_image_gallery = Array();
            if(!empty($magic360_data) && array_key_exists('images_ids', $magic360_data)) $magic360_image_gallery = $magic360_data['images_ids'];

            if(!empty($magic360_image_gallery)){

                $watermark = $plugin->params->getValue('watermark');
                $plugin->params->setValue('watermark', '');

                $magic360_selector_path = $magic360_plugin->params->getValue('selector-path');
                
                if (!$useWpImages) {
                    $magic360_selector = '<a data-product-id="'.$post_id.'" data-magic-slide-id="360" style="display:inline-block;" class="m360-selector" title="360" href="#" onclick="return false;"><img src="'.Jigoshop_MagicThumb_get_product_image('/'.ltrim($magic360_selector_path,'/'),'selector').'" alt="360" /></a>';
                } else {
                    //$magic360_selector = '<a data-product-id="'.$post_id.'" data-magic-slide-id="360" style="display:inline-block;" class="m360-selector" title="360" href="#" onclick="return false;"><img style="max-width: '.$sMaxWidth.'px; max-height: '.$sMaxHeight.'px;" src="'.get_site_url().$magic360_selector_path.'" alt="360" /></a>';
                    $magic360_selector = '<a data-product-id="'.$post_id.'" data-magic-slide-id="360" style="display:inline-block;" class="m360-selector" title="360" href="#" onclick="return false;"><img '.$sizeStyle.' src="'.get_site_url().'/'.ltrim($magic360_selector_path,'/').'" alt="360" /></a>';
                }     
                
                $plugin->params->setValue('watermark', $watermark);
                array_unshift($thumbs, $magic360_selector);

                foreach($magic360_image_gallery as $i => $image_id) {
                    $image_src = wp_get_attachment_image_src($image_id, 'original', $image_id);
                    $image_src = preg_replace('/.*(\/wp-content.*)/','$1', $image_src[0]);
                    $GLOBALS['magic360images'][$i] = array(
                        'medium' => WooCommerce_Magic360_get_product_image($image_src,'thumb', $image_id),
                        'img' => WooCommerce_Magic360_get_product_image($image_src,'original', $image_id)
                    );
                }

                $magic360_plugin->params->setValue('columns', $magic360_data['options']['columns']);

                usort($GLOBALS['magic360images'], 'magictoolbox_Jigoshop_MagicThumb_key_sort');

                $containersData['360'] = $magic360_plugin->getMainTemplate($GLOBALS['magic360images']);
                
                $defaultView = $magic360_plugin->params->getValue('default-spin-view');
                if ($defaultView == 'Spin') {
                    $GLOBALS['defaultContainerId'] = '360';
                } else {
                    $GLOBALS['defaultContainerId'] = 'zoom';
                }

                global $magictoolbox_Magic360_page_has_tool;
                $magictoolbox_Magic360_page_has_tool = true;
                unset($GLOBALS['magic360images']);
            }
        }

    }
    
    return array('containersData'       => $containersData,
                 'productImagesHTML'    => $productImagesHTML,
                 'thumbs'               => $thumbs);
    
}


if( function_exists('register_block_type' ) ){
  if( !function_exists('Jigoshop_MagicThumb_addmedia_block')){
    function Jigoshop_MagicThumb_addmedia_block(){

      wp_register_script(
        'jigoshop-magicthumb-addmedia-block-editor-js',
        plugins_url('/gutenberg/addmedia-block/editor-script.js', __FILE__),
        array( 'wp-blocks', 'wp-element', 'wp-editor', 'jquery'), NULL
      );

      register_block_type( 'jigoshop-magicthumb/addmedia-block', array(
          'editor_script' => 'jigoshop-magicthumb-addmedia-block-editor-js',
      ) );
    }

    add_action( 'init', 'Jigoshop_MagicThumb_addmedia_block' );
  }

}

function Jigoshop_MagicThumb_slideshow_gallery($atts){

    global $wpdb;

    $table_name = $wpdb->prefix . strtolower('MagicThumb_store');
    $result = $wpdb->get_results("SELECT id,name FROM $table_name ");

    return rest_ensure_response( $result );
}

add_action( 'rest_api_init', 'Jigoshop_MagicThumb_gallery_route');

function Jigoshop_MagicThumb_gallery_route() {
            
    register_rest_route( 'MagicThumb', 'get-shortcodes', array(
            'methods' => 'GET',
            'callback' => 'Jigoshop_MagicThumb_slideshow_gallery',
            'permission_callback' => function() {
                return current_user_can( 'edit_posts' );
            }, 
    ));
}

?>