<?php
if ( ! function_exists( 'add_action' ) ) {
    echo "Please enable this plugin from your wp-admin.";
    exit;
}

class Jigoshop_MagicThumb_autoupdate {
    private $changelogURL = 'https://www.magictoolbox.com/magicthumb/modules/jigoshop/';

    private $slug = 'magicthumb';

    public static function init() {
        static $instance;
        if ( empty( $instance ) )
            $instance = new Jigoshop_MagicThumb_autoupdate();
        return $instance;
    }
    function __construct() {
        add_filter( 'pre_set_site_transient_update_plugins', array( $this, 'checkForUpdates' ), 10, 1 );
        add_action( 'install_plugins_pre_plugin-information', array( $this, 'overrideUpdateInformation' ), 1 );
    }

    function mod_Jigoshop_MagicThumb_backup() {
        $fileContetns = file_get_contents(plugin_dir_path(__FILE__).'magicthumb.js');
        delete_option("Jigoshop_MagicThumb_backup");
        add_option("Jigoshop_MagicThumb_backup", $fileContetns,'','no');
    }

    function mod_Jigoshop_MagicThumb_scroll_backup() {
        $fileContetns = file_get_contents(plugin_dir_path(__FILE__).'magicscroll.js');
        delete_option("Jigoshop_MagicThumb_magicscroll_backup");
        add_option("Jigoshop_MagicThumb_magicscroll_backup", $fileContetns,'','no');
    }

    function checkForUpdates( $value ) {
        global $update_plugin;
        if (!$update_plugin)
            return $value;

        $key = magictoolbox_Jigoshop_MagicThumb_get_data_from_db();
        if ($key) { $key = $key->license; }

        if (function_exists('mb_convert_encoding')) {
            $ver = json_decode(mb_convert_encoding(@file_get_contents('http://www.magictoolbox.com/api/platform/wordpress/version/'), 'HTML-ENTITIES', "UTF-8"));
        } else {
            $ver = json_decode(utf8_decode(htmlentities(@file_get_contents('http://www.magictoolbox.com/api/platform/wordpress/version/'), ENT_COMPAT, 'utf-8', false)));
        }

        if (empty($ver))
            return $value;

        $ver = str_replace('v', '', $ver->version);
        $oldVer = plugin_get_version_Jigoshop_MagicThumb();

        $this->mod_Jigoshop_MagicThumb_backup();
        $this->mod_Jigoshop_MagicThumb_scroll_backup();

        if ($key) {
            $_url = 'https://www.magictoolbox.com/site/order/'.$key.'/';
            $_package = 'https://www.magictoolbox.com/site/order/'.$key.'/jigoshop/magicthumb.zip';
        } else {
            $_url = 'https://www.magictoolbox.com/static/';
            $_package = 'https://www.magictoolbox.com/static/mod_jigoshop_magicthumb.zip';
        }


        if (version_compare($oldVer, $ver, '<')) {
            $response = new stdClass();
            $response->id = 0;
            $response->slug = 'magicthumb';
            $response->new_version = $ver;
            $response->plugin = 'mod_jigoshop_magicthumb/mod_jigoshop_magicthumb.php';
            $response->url = $_url;
            $response->package = $_package;

            $value->response['mod_jigoshop_magicthumb/mod_jigoshop_magicthumb.php'] = $response;
        }

        return $value;
    }

    function overrideUpdateInformation() {
        if ( wp_unslash( $_REQUEST['plugin'] ) !== $this->slug )
            return;

        wp_redirect( $this->changelogURL );
        exit;
    }
}

add_action( 'current_screen', function () {
    $current_screen = get_current_screen();
    if( $current_screen->id === "plugins" ) {
        add_action( 'plugins_loaded', array( 'Jigoshop_MagicThumb_autoupdate', 'init' ) );
    }    
} );
?>
