<?php defined("SYSPATH") or die("No direct script access.");

class Admin_MagicZoomPlus_Controller extends Admin_Controller {

    public function index() {
        $tool = $this->loadTool();
        foreach($tool->params->getParams() as $id => $param) {
            $tool->params->setValue($id, module::get_var('magiczoomplus', $id, $tool->params->getValue($id)));
        }
        $view = new Admin_View("admin.html");
        $view->content = new View("admin_magiczoomplus.html", array('tool' => $tool, 'groups' => $this->getParamsMap()));
        print $view;
    }

    public function saveSettings() {
        access::verify_csrf();
        $tool = $this->loadTool();
        foreach($tool->params->getParams() as $id => $param) {
            $value = Input::instance()->post($id, $tool->params->getValue($id));
            module::set_var("magiczoomplus", $id, $value);
            $tool->params->setValue($id, $value);
        }
        message::success("MagicZoomPlus settings saved.");
        $view = new Admin_View("admin.html");
        $view->content = new View("admin_magiczoomplus.html", array('tool' => $tool, 'groups' => $this->getParamsMap()));
        print $view;
    }

    private function loadTool() {
        if(!isset($GLOBALS['magictoolbox']['magiczoomplus']['class'])) {
            require_once(MODPATH . 'magiczoomplus/core/magiczoomplus.module.core.class.php');
            $tool = new MagicZoomPlusModuleCoreClass();
            $GLOBALS['magictoolbox']['magiczoomplus']['class'] = $tool;
        }
        return $GLOBALS['magictoolbox']['magiczoomplus']['class'];
    }

    public function getParamsMap() {
		return array(
				'General' => array(
					'enable-effect-on-photo-page',
					'enable-effect-on-album-page'
				),
				'Positioning and Geometry' => array(
					'zoomWidth',
					'zoomHeight',
					'zoomPosition',
					'zoomDistance'
				),
				'Multiple images' => array(
					'selectorTrigger',
					'transitionEffect'
				),
				'Miscellaneous' => array(
					'lazyZoom',
					'rightClick',
					'cssClass',
					'show-message',
					'message'
				),
				'Zoom mode' => array(
					'zoomMode',
					'zoomOn',
					'upscale',
					'smoothing',
					'variableZoom',
					'zoomCaption'
				),
				'Expand mode' => array(
					'expand',
					'expandZoomMode',
					'expandZoomOn',
					'expandCaption',
					'closeOnClickOutside'
				),
				'Hint' => array(
					'hint',
					'textHoverZoomHint',
					'textClickZoomHint',
					'textExpandHint',
					'textBtnClose',
					'textBtnNext',
					'textBtnPrev'
				),
				'Mobile' => array(
					'zoomModeForMobile',
					'textHoverZoomHintForMobile',
					'textClickZoomHintForMobile',
					'textExpandHintForMobile'
				)
		);
	}

}