<?php defined("SYSPATH") or die("No direct script access.");

class MagicZoom_theme_Core {

    static function head($theme) {
        $page = $theme->__get('page_subtype');
        if (!$theme->item()) return '';
        switch($page) {
            case 'photo':
                $tool = self::loadTool();
                if($tool->params->checkValue('enable-effect-on-photo-page', 'No')) return '';
                $theme->script("magictoolbox_photo.js");
                break;
            case 'album':
                $tool = self::loadTool();
                if($tool->params->checkValue('enable-effect-on-album-page', 'No')) return '';
                $theme->css("magictoolbox_album.css");
                $theme->script("magictoolbox_album.js");
                break;
            default: return '';
        }

        return $tool->getHeadersTemplate(url::file("modules/magiczoom/core"));
    }

    static function photo_top($theme) {
        ob_start();
        return '';
    }

    static function photo_bottom($theme) {
        $content = ob_get_contents();
        ob_end_clean();
        $tool = self::loadTool();
        if(!$tool->params->checkValue('enable-effect-on-photo-page', 'No')) {
            $item = $theme->__get('content')->__get('item');
            $pattern = '/<a[^>]*>[^<]*?<img[^>]*>[^<]*?<\/a>/is';
            $replace = '<div class="MagicToolboxContainer">' .
                        $tool->getMainTemplate(array(
                            'id' => $item->__get('id'),
                            'img' => $item->file_url(),
                            'thumb' => $item->resize_url(),
                            'title' => $item->__get('title'),
                            'description' => $item->__get('description')
                        )) .
                        '</div>';
            $replace = str_replace('<img', '<img id="g-item-id-'.$item->__get('id').'"', $replace);
            $content = preg_replace($pattern, $replace , $content);
        }
        return $content;
    }

    static function album_top($theme) {
        ob_start();
        return '';
    }

    static function album_bottom($theme) {
        $content = ob_get_contents();
        ob_end_clean();
        $tool = self::loadTool();
        if(!$tool->params->checkValue('enable-effect-on-album-page', 'No')) {
            $children = $theme->__get('content')->__get('children');
            foreach ($children as $i => $child) {
                if($child->is_album()) continue;
                list($height, $width) = $child->scale_dimensions(null);
                $link = $child->url();
                $pattern = '/<a[^>]*?href="' . preg_quote($link, '/') . '"[^>]*>[^<]*?<img[^>]*?class="[^"]*?g-thumbnail[^"]*"[^>]*>[^<]*?<\/a>/is';
                $replace = '<div class="MagicToolboxContainer">' .
                            $tool->getMainTemplate(array(
                                'id' => $child->__get('id'),
                                'img' => $child->file_url(),
                                'thumb' => $child->thumb_url(),
                                'title' => $child->__get('title'),
                                'description' => $child->__get('description'),
                                'link' => $link,
                                'height' => $height,
                                'width' => $width
                            )) .
                            '</div>';
                $replace = str_replace('<img', '<img id="g-thumbnail-'.$child->__get('id').'" class="g-thumbnail"', $replace);
                $content = preg_replace($pattern, $replace , $content);
            }
        }
        return $content;
    }

    private function loadTool() {
        if(!isset($GLOBALS['magictoolbox']['magiczoom']['class'])) {
            require_once(MODPATH . 'magiczoom/core/magiczoom.module.core.class.php');
            $tool = new MagicZoomModuleCoreClass();
            foreach($tool->params->getParams() as $id => $param) {
                $tool->params->setValue($id, module::get_var('magiczoom', $id, $tool->params->getValue($id)));
            }
            $GLOBALS['magictoolbox']['magiczoom']['class'] = $tool;
        }
        return $GLOBALS['magictoolbox']['magiczoom']['class'];
    }
}
