<?php defined("SYSPATH") or die("No direct script access.");

class Admin_MagicZoom_Controller extends Admin_Controller {

    public function index() {
        $tool = $this->loadTool();
        foreach($tool->params->getParams() as $id => $param) {
            $tool->params->setValue($id, module::get_var('magiczoom', $id, $tool->params->getValue($id)));
        }
        $view = new Admin_View("admin.html");
        $view->content = new View("admin_magiczoom.html", array('tool' => $tool, 'groups' => $this->getParamsMap()));
        print $view;
    }

    public function saveSettings() {
        access::verify_csrf();
        $tool = $this->loadTool();
        foreach($tool->params->getParams() as $id => $param) {
            $value = Input::instance()->post($id, $tool->params->getValue($id));
            module::set_var("magiczoom", $id, $value);
            $tool->params->setValue($id, $value);
        }
        message::success("MagicZoom settings saved.");
        $view = new Admin_View("admin.html");
        $view->content = new View("admin_magiczoom.html", array('tool' => $tool, 'groups' => $this->getParamsMap()));
        print $view;
    }

    private function loadTool() {
        if(!isset($GLOBALS['magictoolbox']['magiczoom']['class'])) {
            require_once(MODPATH . 'magiczoom/core/magiczoom.module.core.class.php');
            $tool = new MagicZoomModuleCoreClass();
            $GLOBALS['magictoolbox']['magiczoom']['class'] = $tool;
        }
        return $GLOBALS['magictoolbox']['magiczoom']['class'];
    }

    public function getParamsMap() {
		return array(
				'General' => array(
					'enable-effect-on-photo-page',
					'enable-effect-on-album-page'
				),
				'Positioning and Geometry' => array(
					'zoomWidth',
					'zoomHeight',
					'zoomPosition',
					'zoomDistance'
				),
				'Multiple images' => array(
					'selectorTrigger',
					'transitionEffect'
				),
				'Miscellaneous' => array(
					'lazyZoom',
					'rightClick',
					'cssClass',
					'show-message',
					'message'
				),
				'Zoom mode' => array(
					'zoomMode',
					'zoomOn',
					'upscale',
					'smoothing',
					'variableZoom',
					'zoomCaption'
				),
				'Hint' => array(
					'hint',
					'textHoverZoomHint',
					'textClickZoomHint'
				),
				'Mobile' => array(
					'zoomModeForMobile',
					'textHoverZoomHintForMobile',
					'textClickZoomHintForMobile'
				)
		);
	}

}