<?php defined("SYSPATH") or die("No direct script access.");

class Admin_MagicThumb_Controller extends Admin_Controller {

    public function index() {
        $tool = $this->loadTool();
        foreach($tool->params->getParams() as $id => $param) {
            $tool->params->setValue($id, module::get_var('magicthumb', $id, $tool->params->getValue($id)));
        }
        $view = new Admin_View("admin.html");
        $view->content = new View("admin_magicthumb.html", array('tool' => $tool, 'groups' => $this->getParamsMap()));
        print $view;
    }

    public function saveSettings() {
        access::verify_csrf();
        $tool = $this->loadTool();
        foreach($tool->params->getParams() as $id => $param) {
            $value = Input::instance()->post($id, $tool->params->getValue($id));
            module::set_var("magicthumb", $id, $value);
            $tool->params->setValue($id, $value);
        }
        message::success("MagicThumb settings saved.");
        $view = new Admin_View("admin.html");
        $view->content = new View("admin_magicthumb.html", array('tool' => $tool, 'groups' => $this->getParamsMap()));
        print $view;
    }

    private function loadTool() {
        if(!isset($GLOBALS['magictoolbox']['magicthumb']['class'])) {
            require_once(MODPATH . 'magicthumb/core/magicthumb.module.core.class.php');
            $tool = new MagicThumbModuleCoreClass();
            $GLOBALS['magictoolbox']['magicthumb']['class'] = $tool;
        }
        return $GLOBALS['magictoolbox']['magicthumb']['class'];
    }

    public function getParamsMap() {
		return array(
				'General' => array(
					'enable-effect-on-photo-page',
					'enable-effect-on-album-page'
				),
				'Expanded view' => array(
					'expandEffect',
					'expandSpeed',
					'expandImageSize',
					'expandTrigger',
					'expandAlign',
					'expandEasing',
					'gallerySpeed',
					'loop'
				),
				'Multiple images' => array(
					'selectorTrigger',
					'selectorEffect'
				),
				'Title and Caption' => array(
					'show-caption',
					'captionPosition'
				),
				'Miscellaneous' => array(
					'keyboard',
					'cssClass',
					'rightClick',
					'lazyLoad',
					'autostart'
				),
				'Buttons' => array(
					'buttons',
					'textBtnClose',
					'textBtnNext',
					'textBtnPrev'
				),
				'Hint' => array(
					'hint',
					'textClickHint',
					'textHoverHint'
				),
				'Mobile' => array(
					'slideMobileEffect',
					'textClickHintForMobile'
				)
		);
	}

}