{*
Magic Zoom Plus Module

@file AdminMagicZoomPlus.tpl (template for admin panel of module)
@package MagicZoomPlus
@author MagicToolbox <support@magictoolbox.com> <http://magictoolbox.com/>
@link http://magictoolbox.com/magiczoomplus/
@version v2.13.3 [v1.6.103:v5.3.7]
*}
<div class="gbBlock gcBackground1">
    <h2> {g->text text="Magic Zoom Plus Settings"} </h2>
</div>

{if isset($status.saved)}
<div class="gbBlock"><h2 class="giSuccess">
    {g->text text="Settings saved successfully"}
</h2></div>
{/if}
{if isset($status.activated)}
<div class="gbBlock"><h2 class="giSuccess">
    {g->text text="Module activated"}
</h2></div>
{/if}
<div class="gbBlock">
    <p class="giDescription">
        Magic Zoom Plus<sup>&#8482;</sup> lets you add a zoom and enlarge effect to your images. Try out some customisation options http://www.magictoolbox.com/magiczoomplus_integration/. By http://www.magictoolbox.com/.
        {if $form.show_warning === 'Yes'}
            <br /><br /><font color="red">You should grant write access (chmod 777) for these files:<br /><br />main.php<br />modules/core/classes/GalleryTemplateAdapter.class<br />modules/core/classes/GalleryTheme.class<br /></font>
        {/if}
    </p>
</div>
<div class="gbBlock">
    <table class="gbDataTable">
        {php}
            list($r,$tool) = GalleryCoreApi::loadPlugin('module','magiczoomplus',true);
            if($r) return array($r, null);
            $cl = 0;
            foreach($tool->params->getParams() as $k => $v) {
                if($k == 'use-thumbnails' && $GLOBALS['magiczoomplus_admin_form']['show_thumbnail_question'] == 'No') {
                    continue;
                }
                echo '<tr class="' . ($cl==1?'gbOdd':'gbEven') . '">';
                echo "<td>{$v['label']}<br />";
                echo isset($v['description']) ? $v['description'] : "";
                if(($v['type'] != 'array') && isset($v['values'])) echo ' #allowed values: ' . implode(', ',$v['values']);
                echo "</td>";
                echo "<td>";
                switch($v['type']) {
                    case 'array':
                        if($v['subType'] == 'radio') {
                            foreach($v['values'] as $vl) {
                                $selected = $tool->params->checkValue($k, $vl);
                                if($selected) $selected = ' checked="checked"';
                                else $selected = '';
                                echo '<input id="magiczoomplus_' . $k . '_' . md5($vl) . '" type="radio" size="40" autocomplete="off" name="g2_form[' . $k . ']" value="' . $vl . '"' . $selected . ' />';
                                echo '<label for="magiczoomplus_' . $k . '_' . md5($vl) . '">' . $vl . '</label>';
                            }
                        } else {
                            echo '<select id="magiczoomplus_' . $k . '" autocomplete="off" name="g2_form[' . $k . ']" />';                        
                            foreach($v['values'] as $vl) {
                                $selected = $tool->params->checkValue($k, $vl);
                                if($selected) $selected = ' selected="selected"';
                                else $selected = '';
                                echo "<option value=\"{$vl}\"{$selected}>{$vl}</option>";
                            }
                        }
                        break;
                    default: 
                        echo '<input id="magiczoomplus_' . $k . '" type="text" size="40" autocomplete="off" name="g2_form[' . $k . ']" value="' . $tool->params->getValue($k) . '" />';
                }
                if(isset($GLOBALS['magiczoomplus_admin_form']['error'][$k]['missing'])) {
                    echo '<div class="giError">Please correct this field</div>';
                }
                echo "</td>";
                $cl = 1 - $cl;
            }
        {/php}
        {if $form.show_activate_after_save === 'Yes'}
        <tr class="gbOdd">
            <td>{g->text text="Activate Magic Zoom Plus after save settings"}</td>
            <td>
                <input id="mz_activate_after_save_yes" type="radio" autocomplete="off" name="{g->formVar var="form[activate_after_save]"}" value="Yes" {if $form.activate_after_save === 'Yes'}checked="checked"{/if}/>
                <label for="mz_activate_after_save_yes">{g->text text="Yes"}</label>
                <input id="mz_activate_after_save_no" type="radio" autocomplete="off" name="{g->formVar var="form[activate_after_save]"}" value="No" {if $form.activate_after_save === 'No'}checked="checked"{/if}/>
                <label for="mz_activate_after_save_no">{g->text text="No"}</label>
                {if isset($form.error.activate_after_save.missing)}
                    <div class="giError">{g->text text="You must set this parameter"}</div>
                {/if}
            </td>
        </tr>
        {/if}
    </table>
</div>

<div class="gbBlock gcBackground1">
  <input type="submit" class="inputTypeSubmit" name="{g->formVar var="form[action][save]"}" value="{g->text text="Save Settings"}" onClick="/*mzEnableAllFields(this.form);*/" />
  <input type="submit" class="inputTypeSubmit" name="{g->formVar var="form[action][cancel]"}" value="{g->text text="Cancel"}"/>
</div>
