<?php
/**
 * Magic Zoom Plus Module
 *
 * @file module.inc (main module file)
 * @package MagicZoomPlus
 * @author MagicToolbox <support@magictoolbox.com> <http://magictoolbox.com/>
 * @link http://magictoolbox.com/magiczoomplus/
 * @version v2.13.3 [v1.6.103:v5.3.7]
 */
class MagicZoomPlusModule extends GalleryModule {

    var $coreClass;
    var $params;

    function MagicZoomPlusModule() {
        global $gallery, $template;
        $this->setId('magiczoomplus');
        $this->setName($gallery->i18n('Magic Zoom Plus'));
        $this->setDescription($gallery->i18n('Magic Zoom Plus<sup>&#8482;</sup> lets you add a zoom and enlarge effect to your images. Try out some customisation options http://www.magictoolbox.com/magiczoomplus_integration/. By http://www.magictoolbox.com/.'));
        $this->setVersion('v2.13.3 [v1.6.103:v5.3.7]');
        $this->setGroup('display', $gallery->i18n('Display'));
        $this->setCallbacks('getSiteAdminViews');
        $this->setRequiredCoreApi(array(7, 4));
        $this->setRequiredModuleApi(array(3, 2));

        $this->loadCore();
    }

    /* load core class */
    function loadCore() {
        require_once(dirname(__FILE__) . "/core/magiczoomplus.module.core.class.php");
        $this->coreClass = new MagicZoomPlusModuleCoreClass();
        //$this->params = & $this->coreClass->params;
        $this->loadParams();
    }

    /* load params into core class */
    function loadParams() {

        if(!$this->params) {

            $this->params = & $this->coreClass->params;

            $this->params->setParams(
                array_merge(
                    array(
                        "use-effect-on-item-page" => array(
                            "id" => "use-effect-on-item-page",
                            "default" => "No",
                            "label" => "Use effect on item page",
                            "type" => "array",
                            "subType" => "select",
                            "values" => array(
                                "Yes",
                                "No"
                            ),
                        ),
                        "use-effect-on-album-page" => array(
                            "id" => "use-effect-on-album-page",
                            "default" => "Yes",
                            "label" => "Use effect on album page",
                            "type" => "array",
                            "subType" => "select",
                            "values" => array(
                                "Yes",
                                "No"
                            ),
                        ),
                    ),
                    $this->params->getParams()
                )
            );

            $this->params->appendParams(array(
                "enabled-by-default" => array(
                    "id" => "enabled-by-default",
                    "default" => "Yes",
                    "label" => "Enabled by defaut in all albums",
                    "type" => "array",
                    "subType" => "radio",
                    "values" => array("Yes", "No"),
                ),
                /*"pages" => array(
                    "id" => "pages",
                    "default" => "Album page",
                    "label" => "Pages to show effect on",
                    "type" => "array",
                    "subType" => "select",
                    "values" => array("Album page", "Item page", "Both pages"),
                ),*/
                "enable-effect-on-album-image" => array(
                    "id" => "enable-effect-on-album-image",
                    "default" => "No",
                    "label" => "Enabled effect on album image",
                    "type" => "array",
                    "subType" => "radio",
                    "values" => array("Yes", "No"),
                ),
                "use-thumbnails" => array(
                    "id" => "use-thumbnails",
                    "default" => "Yes",
                    "label" => "Use thumbnails",
                    "description" => "(thumbnail manager module)",
                    "type" => "array",
                    "subType" => "radio",
                    "values" => array("Yes", "No"),
                ),
                "thumbnails-size" => array(
                    "id" => "thumbnails-size",
                    "default" => "200",
                    "label" => "Thumbnails size",
                    "description" => "(for images without thumbnails<br />or if prev setting set to 'No')",
                    "type" => "num",
                ),
                "show-link-to-photo-page" => array(
                    "id" => "show-link-to-photo-page",
                    "default" => "No",
                    "label" => "Show link to photo/album page",
                    "type" => "array",
                    "subType" => "radio",
                    "values" => array("Yes", "No"),
                ),
                "link-to-photo-page-title" => array(
                    "id" => "link-to-photo-page-title",
                    "default" => "Show photo page",
                    "label" => "Link to photo page title",
                    "type" => "text",
                ),
                "link-to-album-page-title" => array(
                    "id" => "link-to-album-page-title",
                    "default" => "Show album page",
                    "label" => "Link to album page title",
                    "type" => "text",
                ),
            ));

            foreach($this->params->getParams() as $id => $val) {
                list($ret, $val) = GalleryCoreApi::getPluginParameter('module', 'magiczoomplus', $id);
                if($ret) return '[Render error]';
                if($val !== null) $this->params->setValue($id, $val);
            }

        }
    }

    /* return true if module is active or false if not active */
    function isActived($module = false) {
        if(!$module) $module = $this;
        else {
            list($ret,$module) = GalleryCoreApi::loadPlugin('module',$module,true);
            if($ret) return false;
        }
        list($ret,$isActive) = $module->isActive();
        if($isActive) return true;
        else return false;
    }

    /* return false if module is configured or true if not configured */
    function notConfigured() {
        list($ret,$val) = GalleryCoreApi::getPluginParameter('module', 'magiczoomplus', 'is_configured');
        if($val != 'Yes') return true;
        else return false;
    }

    /* this module needs configuration before use */
    function needsConfiguration() {
        if($this->notConfigured()) return array(null, true);
        else return array(null, false);
    }

    /* exec when module is activate */
    function activate($postActivationEvent=true) {

        if($this->notConfigured()) {

            //fix url's in css files

            global $gallery;
            $platform = &$gallery->getPlatform();
            $sep = $platform->getDirectorySeparator();
            $urlGenerator = &$gallery->getUrlGenerator();

            $path = dirname(__FILE__).$sep.'core';
            $list = glob($path.$sep.'*');
            $files = array();
            if(is_array($list)) {
                for($i = 0; $i < count($list); $i++) {
                    if(is_dir($list[$i])) {
                        if(!in_array(basename($list[$i]), array('.svn', '.git'))) {
                            $add = glob($list[$i].'/*');
                            if(is_array($add)) {
                                $list = array_merge($list, $add);
                            }
                        }
                    } else if(preg_match('#\.css$#i', $list[$i])) {
                        $files[] = $list[$i];
                    }
                }
            }

            foreach($files as $file) {
                if(!is_writable($file)) {
                    //drupal_set_message(t('This installer need to modify some module files. Please check write access for "'.$file.'" file of your module.'), 'error');
                    continue;
                }
                $cssPath = dirname($file);
                $cssRelPath = str_replace($path, '', $cssPath);
                $toolPath = $urlGenerator->_path[0] . 'modules' . $sep . 'magiczoomplus' . $sep . 'core'.$cssRelPath;
                $pattern = '#url\(\s*(\'|")?(?!data:|mhtml:|http(?:s)?:|/)([^\)\s\'"]+?)(?(1)\1)\s*\)#is';
                $replace = 'url($1'.$toolPath.'/$2$1)';
                $fileContents = file_get_contents($file);
                $fixedFileContents = preg_replace($pattern, $replace, $fileContents);
                //preg_match_all($pattern, $fileContents, $matches, PREG_SET_ORDER);
                //debug_log($matches);
                if($fixedFileContents != $fileContents) {
                    $fp = fopen($file, 'w+');
                    if($fp) {
                        fwrite($fp, $fixedFileContents);
                        fclose($fp);
                    }
                }
            }

            return false;

        }
        $this->insertMagicAddons();
        /* Call original activation function */
        parent::activate();
    }

    /* exec when module is deactivate */
    function deactivate() {
        $this->removeMagicAddons();
        /* Call original deactivate function */
        parent::deactivate();
    }

    /* exec when module is install */
    function install() {
        //$this->insertMagicAddons();
        /* Call original install function */
        parent::install();
    }

    /* exec when module is uninstall */
    function uninstall() {
        $this->removeMagicAddons();
        /* Call original uninstall function */
        parent::uninstall();
    }

    /* Insert MagicToolbox PHP code into Gallery files  */
    function insertMagicAddons() {
        global $gallery;
        $path = dirname(__FILE__);
        $platform = &$gallery->getPlatform();
        $sep = $platform->getDirectorySeparator();

        $addons = array(
            /* main.php */
            array(
                'fname' => "{$path}{$sep}..{$sep}..{$sep}main.php",
                'addons' => '/*MagicZoomPlusAddons->*/
                            list($r,$mz) = GalleryCoreApi::loadPlugin(\'module\',\'magiczoomplus\',true);
                            if($r) return array($r, null);
                            $mz->loadIncludes($template);
                            /*<-MagicZoomPlusAddons*/',
                'string' => '$template = new GalleryTemplate(dirname(__FILE__));'
            ),
            /* modules/core/classes/GalleryTemplateAdapter.class */
            array(
                'fname' => "{$path}{$sep}..{$sep}core{$sep}classes{$sep}GalleryTemplateAdapter.class",
                'addons' => '/*MagicZoomPlusAddons->*/
                            list($r,$mz) = GalleryCoreApi::loadPlugin(\'module\',\'magiczoomplus\',true);
                            if($r) return array($r, null);
                            $html =  $mz->parceImgHtml($params,$this,$smarty,$html);
                            /*<-MagicZoomPlusAddons*/',
                'string' => '/* MagicToolboxAddonsStart */'
            ),
            /* modules/core/classes/GalleryTheme.class */
            array(
                'fname' => "{$path}{$sep}..{$sep}core{$sep}classes{$sep}GalleryTheme.class",
                'addons' => '/*MagicZoomPlusAddons->*/
                            foreach($childIds as $id) if(!isset($thumbnail[$id])) $thumbnail[$id] = array();
                            /*<-MagicZoomPlusAddons*/',
                'string' => '$childData[] = \'thumbnail\';',
                'before' => 'Yes'
            )
        );

        if(!preg_match("/MagicToolboxAddonsStart/is", file_get_contents("{$path}{$sep}..{$sep}core{$sep}classes{$sep}GalleryTemplateAdapter.class"))) {
            $addons = array_merge(array(array(
                'fname' => "{$path}{$sep}..{$sep}core{$sep}classes{$sep}GalleryTemplateAdapter.class",
                'addons' => '
                        $html = false;
                        /* MagicToolboxAddonsStart */
                        /* MagicToolboxAddonsEnd */
                        if($html == false) {
                            $html = $this->image_original($params, $smarty);
                        }
                        return $html;
                    }

                    function image_original($params, &$smarty) {',
                'string' => 'function image($params, &$smarty) {'
            )), $addons);
        }

        foreach($addons as $addon) {
            $this->_insertMagicAddons($addon['fname'],$addon['addons'],$addon['string'],(isset($addon['before'])&&$addon['before']=='Yes')?true:false);
        }
    }

    /* helper function for insertMagicAddons (see above) */
    function _insertMagicAddons($fname, $addons, $string, $before = false) {
        $content = file_get_contents($fname);
        if(!preg_match("/MagicZoomPlusAddons/is",$content)) {
            $content = str_replace($string,$before?($addons.$string):($string.$addons),$content);
            $fp = fopen($fname, 'w+');
            if($fp) {
                fwrite($fp, $content);
                fclose($fp);
            }
        }
    }

    /* Remove MagicToolbox PHP code from Gallery files */
    function removeMagicAddons() {
        global $gallery;
        $path = dirname(__FILE__);
        $sep = '/';
        if(strpos($path, '\\')) $sep = '\\';
        $fnames = array();

        /* main.php */
        $fnames[] = "{$path}{$sep}..{$sep}..{$sep}main.php";
        /* modules/core/classes/GalleryTemplateAdapter.class */
        $fnames[] = "{$path}{$sep}..{$sep}core{$sep}classes{$sep}GalleryTemplateAdapter.class";
        /* modules/core/classes/GalleryTheme.class */
        $fnames[] = "{$path}{$sep}..{$sep}core{$sep}classes{$sep}GalleryTheme.class";

        foreach($fnames as $fname) {
            $this->_removeMagicAddons($fname);
        }

    }

    /* helper function for removeMagicAddons (see above) */
    function _removeMagicAddons($fname) {
        $content = file_get_contents($fname);
        $content = preg_replace('/\/\*MagicZoomPlusAddons->\*\/.*\/\*<-MagicZoomPlusAddons\*\//iUs','',$content);
        $fp = fopen($fname, 'w+');
        if($fp) {
            fwrite($fp, $content);
            fclose($fp);
        }
    }

    /* get param value */
    /*function getParam($name, $default, $type='text') {
        list($ret,$val) = GalleryCoreApi::getPluginParameter('module', 'magiczoom', $name);
        $val = empty($val)?$default:$val;
        return $val;
    }*/

    /* get all params */
    /*function getParams($onlyKeys = false) {
        $params = array(
            'enabled-by-default' => $this->getParam('enabled-by-default','Yes','yesno'),
            'enable-zoom-on-album-image' => $this->getParam('enable-zoom-on-album-image','No','yesno'),
            'enabled-zoom-page' => $this->getParam('enabled-zoom-page','album','text'),
            'show-message' => $this->getParam('show-message','No','yesno'),
            'message' => $this->getParam('message','Move your mouse over image','text'),
            'show-caption' => $this->getParam('show-caption','Yes','yesno'),
            'loading-animation' => $this->getParam('loading-animation','Yes','yesno'),
            'loading-animation-image' => $this->getParam('loading-animation-image','/modules/magiczoom/core/loading.gif','text'),
            'loading-animation-text' => $this->getParam('loading-animation-text','Loading Zoom, please wait','text'),
            'zoom-width' => $this->getParam('zoom-width','300px','size'),
            'zoom-height' => $this->getParam('zoom-height','300px','size'),
            'zoom-position' => $this->getParam('zoom-position','right','pos'),
            'square-opacity' => $this->getParam('square-opacity','50','num'),
            'use-thumbnails' => $this->getParam('use-thumbnails','Yes','yesno'),
            'thumbnails-size' => $this->getParam('thumbnails-size','200px','size'),
            'show-link-to-photo-page' => $this->getParam('show-link-to-photo-page','No','yesno'),
            'link-to-photo-page-title' => $this->getParam('link-to-photo-page-title','Show photo page','text'),
            'link-to-album-page-title' => $this->getParam('link-to-album-page-title','Show album page','text'),
        );

        if($onlyKeys) return array_keys($params);
        return $params;
    }*/

    /* Load MagicToolbox Headers */
    function loadIncludes(&$template) {
        if(!$this->isActived()) return;

        //$template->style('modules/magiczoom/core/MagicZoom.css');
        //$template->javascript('modules/magiczoom/core/mz-packed.js');
        //$template->javascript('modules/magiczoom/core/utils.js');

        //$this->coreClass->general->setValue('disable-expand', $this->coreClass->params->getValue('disable-expand'));
        //$this->coreClass->general->setValue('disable-zoom', $this->coreClass->params->getValue('disable-zoom'));

        $template->head('modules/magiczoomplus/templates/MagicZoomPlusHeaders.tpl');
    }

    /* Parse Images */
    function parceImgHtml($params,&$tplAdapter,&$smarty,$html = false) {
        global $gallery;
        $itemType = ''; // item/any(random image/navigation image/etc)
        if(isset($params['item']['owner'])) $itemType = 'item';
        else $itemType = 'any';

        $page = '';
        if(isset($params['item']['thumbnail'])) $page = 'album';
        else $page = 'item';

        $enableMagicTool = false;
        //$html = '';

        $entityType = $params['item']['entityType'];

        //$conf = $this->getParams();

        /* if this module enabled and this no 'random image' or 'navigation image' */
        if($itemType == 'item' && $this->isActived()) {
            /* if this Item page and zoom allowed for Item page */
            //if($page == 'item' && $this->params->checkValue('pages',array('Item page','Both pages'))) {
            if($page == 'item' && !$this->params->checkValue('use-effect-on-item-page', 'No')) {
                //$enableMagicTool = true;
                    /* is zoom allowed for current album or no allowed */
                    list ($ret, $p) = GalleryCoreApi::fetchAllPluginParameters('module', 'magiczoomplus', $params['item']['parentId']);
                    if($ret) return array($ret, null, null);
                    if (!isset($p['enabled']) || $p['enabled'] == 0) {
                        //default
                        if($this->params->checkValue('enabled-by-default','Yes')) $enableMagicTool = true;
                        else $enableMagicTool = false;
                    } else if($p['enabled'] ==1) {
                        //yes
                        $enableMagicTool = true;
                    } else if($p['enabled'] ==2) {
                        //no
                        $enableMagicTool = false;
                    }
            }
            /* if this Album page and zoom allowed for Album page */
            //else if($page == 'album' && $this->params->checkValue('pages',array('Album page','Both pages'))) {
            else if($page == 'album' && !$this->params->checkValue('use-effect-on-album-page', 'No')) {
                /* if current Item is Album and zoom allowed for album images */
                if($entityType == 'GalleryAlbumItem' && $this->params->checkValue('enable-effect-on-album-image','No'))
                    $enableMagicTool = false;
                else {
                    /* is zoom allowed for current album or no allowed */
                    list ($ret, $p) = GalleryCoreApi::fetchAllPluginParameters('module', 'magiczoomplus', $params['item']['parentId'] /*$GLOBALS['itemId']*/);
                    if($ret) return array($ret, null, null);
                    if (!isset($p['enabled']) || $p['enabled'] == 0) {
                        //default
                        if($this->params->checkValue('enabled-by-default','Yes')) $enableMagicTool = true;
                        else $enableMagicTool = false;
                    } else if($p['enabled'] ==1) {
                        //yes
                        $enableMagicTool = true;
                    } else if($p['enabled'] ==2) {
                        //no
                        $enableMagicTool = false;
                    }
                }
            } else $enableMagicTool = false;
        } else {
            $enableMagicTool = false;
        }

        if($enableMagicTool) {
            $urlGenerator = &$gallery->getUrlGenerator();

            $item = $params['item'];
            $image = $params['item'];
            if($entityType == 'GalleryAlbumItem') {
                $image = $params['image'];
                //$query = 'SELECT [childentity::id] FROM [childentity] WHERE [childentity::parentId]='.intval($item['id']).' ORDER BY [childentity::id] ASC LIMIT 1';
                //$query = 'SELECT [childentity::id] FROM [childentity] WHERE [childentity::parentId]='.intval($item['id']).' AND [childentity::id] IN (SELECT [photoitem::id] FROM [photoitem]) ORDER BY [childentity::id] ASC LIMIT 1';
                $query = 'SELECT [ChildEntity::id] FROM [ChildEntity] WHERE [ChildEntity::parentId]='.intval($item['id']).' AND [ChildEntity::id] IN (SELECT [PhotoItem::id] FROM [PhotoItem]) ORDER BY [ChildEntity::id] ASC LIMIT 1';
                list ($ret, $res) = $gallery->search($query);
                $image['id'] = $res->_recordSet->fields[0];
            }
            //$thumbnail = isset($params['thumbnail'])?$params['thumbnail']:$params['image'];

            /* load original thumbnail if that avaliable and if allowed */
            if($this->params->checkValue("use-thumbnails",'Yes') && $this->isActived('thumbnail')) {
                list($ret, $html) = $tplAdapter->_image($params, $smarty);
                if($ret) return '[Render error]';
            }

            /* get image link */
            $src =  $urlGenerator->generateUrl(
                array(
                    'view' => 'core.DownloadItem',
                    'itemId' => $image["id"]
                ),
                array(
                    'forceFullUrl' => !empty($params['forceFullUrl'])
                )
            );

            /* get image page link */
            $lnk =  $urlGenerator->generateUrl(
                array(
                    'view' => 'core.ShowItem',
                    'itemId' => $item["id"]
                ),
                array(
                    'forceFullUrl' => !empty($params['forceFullUrl'])
                )
            );
            if($page == 'album' && $this->params->checkValue("link-enlarged-to-photo-page", "Yes")) {
                $link = $lnk;
            } else {
                $link = '';
            }
            //$src = preg_replace("\&amp;", "&",$src);

            /*$rel = array();
            $rel[] = "opacity: {$conf["square-opacity"]}";
            $rel[] = "zoom-width: {$conf["zoom-width"]}";
            $rel[] = "zoom-height: {$conf["zoom-height"]}";
            $rel[] = "zoom-position: {$conf["zoom-position"]}";
            //$rel[] = "thumb-change: {$conf["opacity"]}";
            $rel = implode(";",$rel);*/

            /*$title = '';
            if($conf["show-caption"] == 'Yes') {
                $title = ' title="'.trim($item['title']).'"';
            }*/

            $title = trim($item['title']);
            $summary = trim($item['summary']);
            $description = trim($item['description']);

            if(!isset($GLOBALS["_MAGICZOOMPLUS_IMAGE_ID"]))
                $GLOBALS["_MAGICZOOMPLUS_IMAGE_ID"] = 1;
            //$id = 'mz'.md5($src);
            $id = 'magiczoomplus'.($GLOBALS["_MAGICZOOMPLUS_IMAGE_ID"]++);

            $coreHTML = $this->coreClass->getMainTemplate(array(
                "id" => $id,
                "img" => $src,
                "thumb" => $src,
                "width" => $this->params->getValue('thumbnails-size'),
                "title" => $title,
                "summary" => $summary,
                "description" => $description,
                "link" => $link
            ));
            if(empty($html)) {
                /* this image hasn't thumbnail */
                //$html = "<img width=\"{$conf["thumbnails-size"]}\" src=\"{$src}\" />";
                $html = $coreHTML;
            } else {
                $html = preg_replace("/<img[^>]*>/is", $html, $coreHTML);
            }

            /* added <A> tag with 'MagicZoom' class name */
            //$html = "<a id=\"{$id}\" class=\"MagicZoom\" href=\"{$src}\" rel=\"{$rel}\" style=\"margin-left:auto;margin-right:auto;\"{$title}>{$html}</a>";

            $html = preg_replace("/^<a /is", "<a style=\"margin-left:auto;margin-right:auto;\" ", $html);

            //if(!defined('_MAGICZOOMPLUS_ADDONS_TEMPLATE_LOADED')) {
            //    $html .= $this->coreClass->addonsTemplate(dirname($gallery->_config['baseUri']));
            //    define('_MAGICZOOMPLUS_ADDONS_TEMPLATE_LOADED', 1);
            //}

            //if($conf["loading-animation"] == 'Yes') {
                /* added <IMG> tag for use loading animation */
                //$html .= "<img class=\"MagicZoomLoading\" src=\"{$gallery->_config['galleryBaseUrl']}{$conf["loading-animation-image"]}\" alt=\"{$conf["loading-animation-text"]}\" />";
            //}

            //if($conf["show-message"] == 'Yes') $html .= "<span style=\"display:block\">{$conf["message"]}</span>";
            //if($conf["show-link-to-photo-page"] == 'Yes') $html .= "<span style=\"display:block\"><a href=\"{$lnk}\">{$conf[($entityType=='GalleryAlbumItem'?"link-to-album-page-title":"link-to-photo-page-title")]}</a></span>";
            if($this->params->checkValue("show-link-to-photo-page", "Yes") && $page != 'item') {
                $title = $this->params->getValue(($entityType=='GalleryAlbumItem'?"link-to-album-page-title":"link-to-photo-page-title"));
                $html .= "<span style=\"display:block\"><a href=\"{$lnk}\">{$title}</a></span>";
            }
        } else {
            /* load original html */
            list($ret, $html) = $tplAdapter->_image($params, $smarty);
            if($ret) return '[Render error]';
        }
        return '<div class="MagicToolboxContainer">' . $html . '</div>';
    }

    /* link for admin menu */
    function getSiteAdminViews() {
        return  array(
                    null,
                    array(
                        array(
                            'name' => $this->translate('Magic Zoom Plus'),
                            'view' => 'magiczoomplus.AdminMagicZoomPlus'
                        )
                    )
                );
    }

    /* configuration page in admin panel */
    function getConfigurationView() {
        return 'magiczoomplus.AdminMagicZoomPlus';
    }

    /* check writable system files */
    function check_writable() {
        global $gallery;
        $path = dirname(__FILE__);
        $platform = &$gallery->getPlatform();
        $sep = $platform->getDirectorySeparator();
        $files = array(
            "{$path}{$sep}..{$sep}..{$sep}main.php",
            "{$path}{$sep}..{$sep}core{$sep}classes{$sep}GalleryTemplateAdapter.class",
            "{$path}{$sep}..{$sep}core{$sep}classes{$sep}GalleryTheme.class"
        );
        foreach($files as $file) {
            if(!is_writable($file)) return false;
        }
        return true;
    }

    /* MagicToolbox option for albums */
    function performFactoryRegistrations() {

        $ret = GalleryCoreApi::registerFactoryImplementation(
            'ItemEditOption', 'MagicZoomPlusOption', 'MagicZoomPlusOption',
            'modules/magiczoomplus/MagicZoomPlusOption.inc', 'magiczoomplus', array('ItemEditAlbum'));
        if ($ret) return $ret;

        return null;
    }

}
?>
