<?php
 /**
 * Magic Zoom Plus Module
 *
 * @file MagicZoomPlusOption.inc (added MagicZoomPlus options into albums)
 * @package MagicZoomPlus
 * @author MagicToolbox <support@magictoolbox.com> <http://magictoolbox.com/>
 * @link http://magictoolbox.com/magiczoomplus/
 * @version v2.13.3 [v1.6.103:v5.3.7]
 */
class MagicZoomPlusOption extends ItemEditOption {

    function isAppropriate($item, $thumbnail) {
        list($r,$tool) = GalleryCoreApi::loadPlugin('module', 'magiczoomplus', true);
        if(!$tool->isActived()) return false;
        //if($tool->params->checkValue('pages', 'Item page')) return false;
        //if($tool->params->checkValue('use-effect-on-album-page', 'No')) return false;
        return array(null, GalleryUtilities::isA($item, 'GalleryAlbumItem'));
    }

    function loadTemplate(&$template, &$form, $item, $thumbnail) {
        $option = array();
        list ($ret, $params) = GalleryCoreApi::fetchAllPluginParameters('module', 'magiczoomplus', $item->getId());
        if($ret) return array($ret, null, null);

        if (!isset($params['enabled']) || $params['enabled'] == 0) {
            $option['enabled'] = 0;
        } else {
            $option['enabled'] = $params['enabled'];
        }

        $template->setVariable('MagicZoomPlusOption', $option);

        return array(null,'modules/magiczoomplus/templates/MagicZoomPlusOption.tpl');
        //return array(null,'modules/magiczoom/templates/MagicZoomOption.tpl','modules_magiczoom');
    }

    function handleRequestAfterEdit($form, &$item, &$preferred) {
        global $gallery;

        $error = $warning = array();

        if (isset($form['changeInDescendents']['magiczoomplus'])) {
            /* TODO: We only need subalbums Items that we can administer */
            list ($ret, $subAlbumIds) = GalleryCoreApi::fetchDescendentAlbumItemIds($item);
            if ($ret) return array($ret, null, null);
            array_unshift($subAlbumIds, $item->getId());
        } else {
            $subAlbumIds = array($item->getId());
        }

        foreach ($subAlbumIds as $id) {
            $ret = GalleryCoreApi::setPluginParameter('module', 'magiczoomplus', 'enabled', $form['MagicZoomPlusOption']['enabled'], $id);
            if ($ret) return array($ret, null, null);
	    }
        
        return array(null, $error, $warning);
    }

}
?>
