<?php
 /**
 * Magic Zoom Module
 *
 * @file MagicZoomOption.inc (added MagicZoom options into albums)
 * @package MagicZoom
 * @author MagicToolbox <support@magictoolbox.com> <http://magictoolbox.com/>
 * @link http://magictoolbox.com/magiczoom/
 * @version v2.13.3 [v1.6.103:v5.3.7]
 */
class MagicZoomOption extends ItemEditOption {

    function isAppropriate($item, $thumbnail) {
        list($r,$tool) = GalleryCoreApi::loadPlugin('module', 'magiczoom', true);
        if(!$tool->isActived()) return false;
        //if($tool->params->checkValue('pages', 'Item page')) return false;
        //if($tool->params->checkValue('use-effect-on-album-page', 'No')) return false;
        return array(null, GalleryUtilities::isA($item, 'GalleryAlbumItem'));
    }

    function loadTemplate(&$template, &$form, $item, $thumbnail) {
        $option = array();
        list ($ret, $params) = GalleryCoreApi::fetchAllPluginParameters('module', 'magiczoom', $item->getId());
        if($ret) return array($ret, null, null);

        if (!isset($params['enabled']) || $params['enabled'] == 0) {
            $option['enabled'] = 0;
        } else {
            $option['enabled'] = $params['enabled'];
        }

        $template->setVariable('MagicZoomOption', $option);

        return array(null,'modules/magiczoom/templates/MagicZoomOption.tpl');
        //return array(null,'modules/magiczoom/templates/MagicZoomOption.tpl','modules_magiczoom');
    }

    function handleRequestAfterEdit($form, &$item, &$preferred) {
        global $gallery;

        $error = $warning = array();

        if (isset($form['changeInDescendents']['magiczoom'])) {
            /* TODO: We only need subalbums Items that we can administer */
            list ($ret, $subAlbumIds) = GalleryCoreApi::fetchDescendentAlbumItemIds($item);
            if ($ret) return array($ret, null, null);
            array_unshift($subAlbumIds, $item->getId());
        } else {
            $subAlbumIds = array($item->getId());
        }

        foreach ($subAlbumIds as $id) {
            $ret = GalleryCoreApi::setPluginParameter('module', 'magiczoom', 'enabled', $form['MagicZoomOption']['enabled'], $id);
            if ($ret) return array($ret, null, null);
	    }
        
        return array(null, $error, $warning);
    }

}
?>
