<?php
/**
* Magic Zoom Plus CubeCart Module
*
* @version v5.2.5 [v1.6.103:v5.3.7]
* @author Magic Toolbox
* @copyright (C) 2008 Magic Toolbox. All rights reserved.
* @link http://www.magictoolbox.com/magiczoomplus/
* @license http://www.magictoolbox.com/license/
* *
* Magic Zoom Plus CubeCart Module comes with absolute no warranty.
*
*/

define('MT_SKIN_FOLDER', defined('SKIN_FOLDER') ? SKIN_FOLDER : $config['skinDir']);

define('MT_ROOT_REL', rtrim($glob['rootRel'], '/').'/');

function loadMagicZoomPlusCoreClass($scroll = false) {
    if(!isset($GLOBALS['magictoolbox']['magiczoomplus'])) {
        require_once(dirname(__FILE__).CC_DS.'core'.CC_DS.'magiczoomplus.module.core.class.php');
        $GLOBALS['magictoolbox']['magiczoomplus'] = new MagicZoomPlusModuleCoreClass();
        $coreClass = &$GLOBALS['magictoolbox']['magiczoomplus'];

        //NOTE: load params
        $config = fetchDbConfig('MagicZoomPlus');
        if(CUBECART_VERSION_3 && is_array($config)) {
            $blocks = array(
				'default' => 'General',
				'product' => 'Product page',
				'category' => 'Category page',
				'latest' => 'Latest block',
				'featured' => 'Featured block',
			);
            foreach($config as $blockId => $data) {
                $blockId = preg_replace('/_block$/', '', $blockId);
                if(!array_key_exists($blockId, $blocks)) continue;
                $config[$blockId.'_block'] = unserialize($config[$blockId.'_block']);
            }
        }

        if(empty($config)) {
            //NOTE: load  defaults
            require_once(dirname(__FILE__).CC_DS.'defaults.php');
        }
        foreach($config as $blockId => $params) {
            if(!is_array($params)) continue;
            $blockId = preg_replace('/_block$/', '', $blockId);
            foreach($params as $id => $value) {
                $coreClass->params->setValue($id, $value, $blockId);
            }
        }

        $GLOBALS['magictoolbox']['magiczoomplus_magicscroll'] = null;
        if($coreClass->params->checkValue('magicscroll', 'Yes', 'product')) {
            require_once(dirname(__FILE__).CC_DS.'core'.CC_DS.'magicscroll.module.core.class.php');
            $GLOBALS['magictoolbox']['magiczoomplus_magicscroll'] = new MagicScrollModuleCoreClass(false);
            $scrollCoreClass = &$GLOBALS['magictoolbox']['magiczoomplus_magicscroll'];
            //NOTE: load params in a separate profile, in order not to overwrite the options of MagicScroll module
            $scrollCoreClass->params->appendParams($coreClass->params->getParams('product'), 'product-magicscroll-options');
            $scrollCoreClass->params->setValue('orientation', ($coreClass->params->checkValue('template', array('left', 'right'), 'product') ? 'vertical' : 'horizontal'), 'product-magicscroll-options');
            //NOTE: if Magic Scroll module installed we need to load settings before displaying custom options
            if(function_exists('loadMagicScrollCoreClass')) {
                loadMagicScrollCoreClass();
            }
        }
    }
    return $scroll ? $GLOBALS['magictoolbox']['magiczoomplus'.'_magicscroll'] : $GLOBALS['magictoolbox']['magiczoomplus'];
}

function &loadMagicZoomPlusImageHelperClass() {
    static $helper = null;
    if($helper == null) {
        $tool = loadMagicZoomPlusCoreClass();
        require_once(dirname(__FILE__).CC_DS.'core'.CC_DS.'magictoolbox.imagehelper.class.php');
        $helper = new MagicToolboxImageHelperClass(
            CC_ROOT_DIR,
            CC_DS.'images'.CC_DS.'uploads'.CC_DS.'magictoolbox_cache',
            $tool->params,
            null,
            $GLOBALS['rootRel']
        );
    }
    return $helper;
}

function applyMagicZoomPlus($contents, $bname) {

    static $showHeaders = false;

    $tool = loadMagicZoomPlusCoreClass();

    switch($bname) {
        //NOTE: product view
        case 'view_prod':
            if($tool->params->checkValue('enable-effect', 'No', 'product')) break;
            if(!is_array($GLOBALS['prodArray'])) break;
            $tool->params->setProfile('product');
            $product = & $GLOBALS['prodArray'][0];
            global $glob, $db, $lang;

            $moreImages = $db->select("SELECT img FROM {$glob['dbprefix']}CubeCart_img_idx WHERE productId={$product['productId']}");
            if(!is_array($moreImages)) $moreImages = array();
            //$mainImage = $db->select("SELECT image as img FROM {$glob['dbprefix']}CubeCart_inventory WHERE productId={$product['productId']}");
            //if(!is_array($mainImage)) $mainImage = array();
            if(empty($product['image'])) {
                if(empty($moreImages)) break;
                $pattern = preg_quote('skins/'.MT_SKIN_FOLDER.'/styleImages/nophoto.gif', '/');
            } else {
                $pattern = 'images\/uploads\/(?:'.preg_quote($product['image'], '/').'|thumbs\/thumb_'.preg_quote(basename($product['image'])).')';
            }

            array_unshift($moreImages, array('img' => $product['image']));

            $mainHtml = $tool->getMainTemplate(array(
                'id' => "Product{$product['productId']}",
                'img' => getMagicZoomPlusImage($product['image'], 'original', $product['productId']),
                'thumb' => getMagicZoomPlusImage($product['image'], 'thumb', $product['productId']),
                'title' => $product['name'],
            ));
            $selectorsHtml = array();
            if(count($moreImages) > 1) {
                foreach($moreImages as $imageData) {
                    $selectorsHtml[] = $tool->getSelectorTemplate(array(
                        'id' => "Product{$product['productId']}",
                        'img' => getMagicZoomPlusImage($imageData['img'], 'original', $product['productId']),
                        'medium' => getMagicZoomPlusImage($imageData['img'], 'thumb', $product['productId']),
                        'thumb' => getMagicZoomPlusImage($imageData['img'], 'selector', $product['productId']),
                        'title' => $product['name'],
                    ));
                }
            }
            require_once(dirname(__FILE__).CC_DS.'core'.CC_DS.'magictoolbox.templatehelper.class.php');
            MagicToolboxTemplateHelperClass::setPath(dirname(__FILE__).CC_DS.'templates');
            MagicToolboxTemplateHelperClass::setOptions($tool->params);
            $scroll = loadMagicZoomPlusCoreClass(true);
            if($tool->params->checkValue('template', 'original')) {
                if(!empty($selectorsHtml)) {
                    //NOTE: Product Image Gallery Type: Lightbox
                    if(preg_match('/<div[^>]*?id="imgThumbSpace"[^>]*>.*?<\/div>/is', $contents, $matches)) {
                        $html = '<div id="MagicToolboxSelectors'.$product['productId'].'" class="MagicToolboxSelectorsContainer '.MagicToolboxTemplateHelperClass::prepareMagicScrollClass().'">'.
                                implode('', $selectorsHtml).
                                '</div>';
                        //NOTE: place selectors in their original location
                        $contents = str_replace($matches[0], $html, $contents);
                        $selectorsHtml = array();
                    }
                }
                $tool->params->setValue('template', 'bottom');
            } else {
                //NOTE: cut image gallery
                $contents = preg_replace('/<div[^>]*?id="imgThumbSpace"[^>]*>.*?<\/div>/is', '', $contents);//NOTE: Product Image Gallery Type: Lightbox
            }
            $html = MagicToolboxTemplateHelperClass::render(array(
                'main' => $mainHtml,
                'thumbs' => $selectorsHtml,
                'magicscrollOptions' => $scroll ? $scroll->params->serialize(false, '', 'product-magicscroll-options') : '',
                'pid' => $product['productId'],
            ));

            $pattern = /*'(?:'.preg_quote(MT_ROOT_REL, '/').')?'.*/'[^"]*?'.$pattern;
            $pattern = '<img [^>]*?src="'.$pattern.'"[^>]*>(?:[^<]*<\/img>)?';

            //NOTE: replace main image
            $contents = preg_replace("/{$pattern}/is", $html, $contents);


            //NOTE: cut 'More Images [+]' link
            $langMoreImages  = isset($lang['front']['viewProd']['more_images']) ? $lang['front']['viewProd']['more_images'] : $lang['viewProd']['popup_more_images'];
            $contents = preg_replace('/<a [^>]*?openPopUp[^>]*>'.preg_quote($langMoreImages, '/').'<\/a>/is', '', $contents);//NOTE: Product Image Gallery Type: Popup in new window
            //NOTE: maybe this for CubeCart 3
            $contents = preg_replace('/<a [^>]*?href="[^"]*?index\.php\?_g=ex(?:\&|\&amp\;)_a=prodImages(?:\&|\&amp\;)productId='.$product['productId'].'[^"]*"[^>]*?onclick="openPopUp\(\s*this\.href[^"]*"[^>]*>.*?<\/a>/is', '', $contents);

            $showHeaders = true;
            break;
        //NOTE: Latest Products
        case 'index':
            $block = 'latest';
            $products = & $GLOBALS['latestProducts'];
        //NOTE: category view
        case 'view_cat':
            if(!isset($block)) {
                $block = 'category';
                $products = & $GLOBALS['productResults'];
            }
            if($tool->params->checkValue('enable-effect', 'No', $block)) break;
            $tool->params->setProfile($block);
            if(!is_array($products)) break;
            global $glob, $db;
            $useLink = $tool->params->checkValue('link-to-product-page', 'Yes');
            foreach($products as $product) {
                if(empty($product['image'])) continue;
                $html = $tool->getMainTemplate(array(
                    'id' => ucfirst($block).$product['productId'],
                    'img' => getMagicZoomPlusImage($product['image'], 'original', $product['productId']),
                    'thumb' => getMagicZoomPlusImage($product['image'], 'thumb', $product['productId']),
                    'title' => $product['name'],
                    'link' => $useLink ? MT_ROOT_REL.'index.php?'.(CUBECART_VERSION_4 ? '_a' : 'act').'=viewProd&productId='.$product['productId'] : '',
                ));
                $pattern = 'images\/uploads\/(?:'.preg_quote($product['image'], '/').'|thumbs\/thumb_'.preg_quote(basename($product['image'])).')';
                $pattern = /*'(?:'.preg_quote(MT_ROOT_REL, '/').')?'.*/'[^"]*?'.$pattern;
                $pattern = '<img [^>]*?src="'.$pattern.'"[^>]*>(?:[^<]*<\/img>)?';
                $pattern = '<a [^>]*?viewProd[^>]*>[^<]*'.$pattern.'[^<]*<\/a>';//href="index.php?_a=viewProd&amp;productId={PRODUCT_ID}"
                //NOTE: replace image
                $contents = preg_replace("/{$pattern}/is", $html, $contents);
            }

            $showHeaders = true;
            break;
        //NOTE: random product (featured product)
        case 'random_prod':
            if($tool->params->checkValue('enable-effect', 'No', 'featured')) break;
            $tool->params->setProfile('featured');
            if(!is_array($GLOBALS['randProd'])) break;
            $product = & $GLOBALS['randProd'][0];
            global $glob, $db;
            $useLink = $tool->params->checkValue('link-to-product-page', 'Yes');
            if(empty($product['image'])) break;
            if($useLink) {
                $link = MT_ROOT_REL.'index.php?'.(CUBECART_VERSION_4 ? '_a' : 'act').'=viewProd&productId='.$product['productId'];
            } else $link = '';
            $html = $tool->getMainTemplate(array(
                'id' => "Featured{$product['productId']}",
                'img' => getMagicZoomPlusImage($product['image'], 'original', $product['productId']),
                'thumb' => getMagicZoomPlusImage($product['image'], 'thumb', $product['productId']),
                'title' => $product['name'],
                'link' => $link,
            ));
            $pattern = 'images\/uploads\/(?:'.preg_quote($product['image'], '/').'|thumbs\/thumb_'.preg_quote(basename($product['image'])).')';
            $pattern = /*'(?:'.preg_quote(MT_ROOT_REL, '/').')?'.*/'[^"]*?'.$pattern;
            $pattern = '<img [^>]*?src="'.$pattern.'"[^>]*>(?:[^<]*<\/img>)?';
            $pattern = '<a [^>]*?viewProd[^>]*>[^<]*'.$pattern.'[^<]*<\/a>';//href="index.php?_a=viewProd&amp;productId={PRODUCT_ID}"
            //NOTE: replace image
            $contents = preg_replace("/{$pattern}/is", $html, $contents);

            $showHeaders = true;
            break;
        //NOTE: all page
        case 'body':
            $tool->params->resetProfile();
            global $body, $glob;

            if(!$showHeaders) break;
            // product page
            //(string)$body->vars['PHP']['page'] == 'viewProd'
            // category page
            //(string)$body->vars['PHP']['page'] == 'viewCat'

            $headers = '';
            $headers .= $tool->getHeadersTemplate(MT_ROOT_REL.'modules/magictoolbox/MagicZoomPlus/core');
            if($tool->params->checkValue('magicscroll', 'Yes', 'product')) {
                $scroll = loadMagicZoomPlusCoreClass(true);
                $scroll->params->resetProfile();
                $headers .= $scroll->getHeadersTemplate(MT_ROOT_REL.'modules/magictoolbox/MagicZoomPlus/core', MT_ROOT_REL.'modules/magictoolbox/MagicZoomPlus/core', false);
            }
            //$headers .= '<link type="text/css" href="'.MT_ROOT_REL.'modules/magictoolbox/MagicZoomPlus/core/styles.css" rel="stylesheet" media="screen" />';

            if(preg_match('/<\/head>/is', $contents, $matches)) {
                $contents = str_replace($matches[0], $headers.$matches[0], $contents);
            } else {
                $contents = $headers.$contents;
            }

            $showHeaders = false;
            break;
    }

    return $contents;
}


function getMagicZoomPlusImage($img, $resize = false, $pid = null) {

    static $noPhoto = null;
    if($noPhoto == null) {
        global $glob, $config;
        $noPhoto = MT_ROOT_REL.'skins/'.MT_SKIN_FOLDER.'/styleImages/thumb_nophoto.gif';
    }
    if(empty($img)) {
        return $noPhoto;
    }

    //$img = imgPath($img);

    $imgLink = MT_ROOT_REL.'images/uploads/'.$img;
    $img = str_replace(array('%20', '/'), array(' ', CC_DS), $img);

    if(!file_exists(CC_ROOT_DIR.CC_DS.'images'.CC_DS.'uploads'.CC_DS.$img)) {
        return $noPhoto;
    }

    if($resize) {
        $helper = loadMagicZoomPlusImageHelperClass();
        if(empty($pid)) $pid = null;
        $imgLink = $helper->create(CC_DS.'images'.CC_DS.'uploads'.CC_DS.$img, $resize, $pid);
    }

    return $imgLink;
}

?>
