<?php

//NOTE: this constant does not present in CubeCart 3
if(!defined('CC_ROOT_DIR')) define('CC_ROOT_DIR', $glob['rootDir']);
if(!defined('CC_DS')) define('CC_DS', DIRECTORY_SEPARATOR);

//NOTE: commented out because of issue #32231
//if(!defined('SKIN_FOLDER')) define('SKIN_FOLDER', $config['skinDir']);

if(empty($ini['ver'])) {
    define('CUBECART_VERSION_3', true);
    define('CUBECART_VERSION_4', false);
} else {
    if(version_compare($ini['ver'], '4.0.0', '<')) {
        define('CUBECART_VERSION_3', true);
        define('CUBECART_VERSION_4', false);
    } else {
        define('CUBECART_VERSION_3', false);
        define('CUBECART_VERSION_4', true);
    }
}

if(!isset($GLOBALS['magictoolbox']['statuses'])) {
    $GLOBALS['magictoolbox']['statuses'] = array(
        'Magic360' => false,
        'Magic360Flash' => false,
        'MagicMagnify' => false,
        'MagicMagnifyPlus' => false,
        'MagicScroll' => false,
        'MagicSlideshow' => false,
        'MagicTouch' => false,
        'MagicThumb' => false,
        'MagicZoom' => false,
        'MagicZoomPlus' => false,
    );
    if(isset($db))//NOTE: just in case for non-standard calls (ajax)
    foreach($GLOBALS['magictoolbox']['statuses'] as $id => $status) {
        $module = fetchDbConfig($id);
        if($module !== false && intval($module['status']) && file_exists(CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'magictoolbox'.CC_DS.$id.CC_DS.strtolower($id).'.php')) {
            $GLOBALS['magictoolbox']['statuses'][$id] = true;
            require_once(CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'magictoolbox'.CC_DS.$id.CC_DS.strtolower($id).'.php');
        }
    }
}

//NOTE: load original class
require_once(dirname(__FILE__).CC_DS.'xtpl_original.php');

class XTemplate extends XTemplate_original {

    function XTemplate() {
        //NOTE: constructor's args (CubeCart 3)
        //   $file, $tpldir = '', $files = null, $mainblock = 'main', $autosetup = true
        //NOTE: constructor's args (CubeCart 4)
        //$options, $tpldir = '', $files = null, $mainblock = 'main', $autosetup = true, $skipPath = false

        $args = func_get_args();
        $defaults = array('', null, 'main', true, false);
        foreach($defaults as $key => $value) {
            if(CUBECART_VERSION_3 && $key == 4) {
                continue;
            }
            if(!isset($args[$key + 1])) {
                $args[$key + 1] = $value;
            }
        }

        //NOTE init original construct function
        if(CUBECART_VERSION_3) {
            @parent::XTemplate_original($args[0], $args[1], $args[2], $args[3], $args[4]);
        } else {
            if(version_compare(PHP_VERSION, '5.0.0', '<')) {
                //NOTE: for PHP 4 an lower
                @parent::XTemplate_original($args[0], $args[1], $args[2], $args[3], $args[4], $args[5]);
            } else {
                @parent::__construct($args[0], $args[1], $args[2], $args[3], $args[4], $args[5]);
            }
        }

    }

    function text($bname = '') {
        global $magictoolbox;

        //NOTE: load original data
        $text = parent::text($bname);

        foreach($magictoolbox['statuses'] as $id => $status) {
            if($status) {
                //NOTE: parse text in our module function
                $func = "apply{$id}";
                $text = $func($text, $bname);
            }
        }

        return $text;
    }

}

?>
