<?php
/**
* Magic Slideshow CubeCart Module
*
* @version v5.2.5 [v1.6.103:v3.2.12]
* @author Magic Toolbox
* @copyright (C) 2008 Magic Toolbox. All rights reserved.
* @link http://www.magictoolbox.com/magicslideshow/
* @license http://www.magictoolbox.com/license/
* *
* Magic Slideshow CubeCart Module comes with absolute no warranty.
*
*/

define('MT_SKIN_FOLDER', defined('SKIN_FOLDER') ? SKIN_FOLDER : $config['skinDir']);

define('MT_ROOT_REL', rtrim($glob['rootRel'], '/').'/');

function loadMagicSlideshowCoreClass($scroll = false) {
    if(!isset($GLOBALS['magictoolbox']['magicslideshow'])) {
        require_once(dirname(__FILE__).CC_DS.'core'.CC_DS.'magicslideshow.module.core.class.php');
        $GLOBALS['magictoolbox']['magicslideshow'] = new MagicSlideshowModuleCoreClass();
        $coreClass = &$GLOBALS['magictoolbox']['magicslideshow'];

        //NOTE: load params
        $config = fetchDbConfig('MagicSlideshow');
        if(CUBECART_VERSION_3 && is_array($config)) {
            $blocks = array(
				'default' => 'General',
				'product' => 'Product page',
				'homeslideshow' => 'Home page Slideshow',
				'featured' => 'Featured block',
				'popular' => 'Popular block',
			);
            foreach($config as $blockId => $data) {
                $blockId = preg_replace('/_block$/', '', $blockId);
                if(!array_key_exists($blockId, $blocks)) continue;
                $config[$blockId.'_block'] = unserialize($config[$blockId.'_block']);
            }
        }

        if(empty($config)) {
            //NOTE: load  defaults
            require_once(dirname(__FILE__).CC_DS.'defaults.php');
        }
        foreach($config as $blockId => $params) {
            if(!is_array($params)) continue;
            $blockId = preg_replace('/_block$/', '', $blockId);
            foreach($params as $id => $value) {
                $coreClass->params->setValue($id, $value, $blockId);
            }
        }

    }
    return $scroll ? $GLOBALS['magictoolbox']['magicslideshow'.'_magicscroll'] : $GLOBALS['magictoolbox']['magicslideshow'];
}

function &loadMagicSlideshowImageHelperClass() {
    static $helper = null;
    if($helper == null) {
        $tool = loadMagicSlideshowCoreClass();
        require_once(dirname(__FILE__).CC_DS.'core'.CC_DS.'magictoolbox.imagehelper.class.php');
        $helper = new MagicToolboxImageHelperClass(
            CC_ROOT_DIR,
            CC_DS.'images'.CC_DS.'uploads'.CC_DS.'magictoolbox_cache',
            $tool->params,
            null,
            $GLOBALS['rootRel']
        );
    }
    return $helper;
}

function applyMagicSlideshow($contents, $bname) {

    static $showHeaders = false;

    $tool = loadMagicSlideshowCoreClass();

    switch($bname) {
        //NOTE: product view
        case 'view_prod':
            if($tool->params->checkValue('enable-effect', 'No', 'product')) break;
            if(!is_array($GLOBALS['prodArray'])) break;
            $tool->params->setProfile('product');
            $product = & $GLOBALS['prodArray'][0];
            global $glob, $db, $lang;

            $moreImages = $db->select("SELECT img FROM {$glob['dbprefix']}CubeCart_img_idx WHERE productId={$product['productId']}");
            if(!is_array($moreImages)) $moreImages = array();
            //$mainImage = $db->select("SELECT image as img FROM {$glob['dbprefix']}CubeCart_inventory WHERE productId={$product['productId']}");
            //if(!is_array($mainImage)) $mainImage = array();
            if(empty($product['image'])) {
                if(empty($moreImages)) break;
                $pattern = preg_quote('skins/'.MT_SKIN_FOLDER.'/styleImages/nophoto.gif', '/');
            } else {
                $pattern = 'images\/uploads\/(?:'.preg_quote($product['image'], '/').'|thumbs\/thumb_'.preg_quote(basename($product['image'])).')';
            }

            array_unshift($moreImages, array('img' => $product['image']));

            $htmlData = array();
            foreach($moreImages as $imageData) {
                $htmlData[] = array(
                    'title' => $product['name'],
                    'img' => getMagicSlideshowImage($imageData['img'], 'thumb', $product['productId']),
                    'thumb' => getMagicSlideshowImage($imageData['img'], 'selector', $product['productId']),
                    'fullscreen' => getMagicSlideshowImage($imageData['img'], 'original', $product['productId']),
                );
            }
            $html = $tool->getMainTemplate($htmlData, array('id' => "Product{$product['productId']}MagicSlideshow"));

            $pattern = /*'(?:'.preg_quote(MT_ROOT_REL, '/').')?'.*/'[^"]*?'.$pattern;
            $pattern = '<img [^>]*?src="'.$pattern.'"[^>]*>(?:[^<]*<\/img>)?';

            //NOTE: replace main image
            $contents = preg_replace("/{$pattern}/is", $html, $contents);

            //NOTE: cut image gallery title
            if(isset($lang['viewProd']['image_gallery'])) {
                $contents = preg_replace('/<p>'.preg_quote($lang['viewProd']['image_gallery'], '/').'<\/p>/is', '', $contents);
            }
            //NOTE: cut image gallery
            $contents = preg_replace('/<div[^>]*?id="imgThumbSpace"[^>]*>.*?<\/div>/is', '', $contents);//NOTE: Product Image Gallery Type: Lightbox

            //NOTE: cut 'More Images [+]' link
            $langMoreImages  = isset($lang['front']['viewProd']['more_images']) ? $lang['front']['viewProd']['more_images'] : $lang['viewProd']['popup_more_images'];
            $contents = preg_replace('/<a [^>]*?openPopUp[^>]*>'.preg_quote($langMoreImages, '/').'<\/a>/is', '', $contents);//NOTE: Product Image Gallery Type: Popup in new window
            //NOTE: maybe this for CubeCart 3
            $contents = preg_replace('/<a [^>]*?href="[^"]*?index\.php\?_g=ex(?:\&|\&amp\;)_a=prodImages(?:\&|\&amp\;)productId='.$product['productId'].'[^"]*"[^>]*?onclick="openPopUp\(\s*this\.href[^"]*"[^>]*>.*?<\/a>/is', '', $contents);

            $showHeaders = true;
            break;
        //NOTE: random product (featured product)
        case 'random_prod':
            if($tool->params->checkValue('enable-effect', 'No', 'featured')) break;
            $tool->params->setProfile('featured');
            global $glob, $db;
            $limit = $tool->params->getValue('count-of-products');
            if(empty($limit)) break;
            $seed = mt_rand(1, 10000);
            $where = array();
            if(isset($_GET['catId'])) {
                $where[] = 'p.cat_id = '.intval($_GET['catId']);
            }
            $where[] = 'p.cat_id > 0';
            $where[] = 'p.cat_id = c.cat_id';
            $where[] = 'p.image != \'\'';//NOTE: does not work! may be we should use left join
            if(CUBECART_VERSION_4) {
                $where[] = 'p.disabled !=\'1\'';
                $where[] = 'c.hide =\'0\'';
                $where[] = '(c.cat_desc IS NULL OR c.cat_desc != \'##HIDDEN##\')';
            }
            $sql = 'SELECT DISTINCT p.name, p.image, p.productId '.
                   'FROM '.$glob['dbprefix'].'CubeCart_inventory as p, '.$glob['dbprefix'].'CubeCart_category as c '.
                   'WHERE '.implode(' AND ', $where).
                   ' ORDER BY RAND('.intval($seed).') './/NOTE: this may be slow!
                   'LIMIT '.$limit;
            $products = $db->select($sql);
            if(empty($products)) break;
            $useLink = $tool->params->checkValue('link-to-product-page', 'Yes');
            $items = array();
            foreach($products as $product) {
                $items[] = array(
                    'title' => $product['name'],
                    'alt' => $product['name'],
                    'img' => getMagicSlideshowImage($product['image'], 'thumb', $product['productId']),
                    'thumb' => getMagicSlideshowImage($product['image'], 'selector', $product['productId']),
                    'fullscreen' => getMagicSlideshowImage($product['image'], 'original', $product['productId']),
                    'link' => $useLink ? MT_ROOT_REL.'index.php?'.(CUBECART_VERSION_4 ? '_a' : 'act').'=viewProd&productId='.$product['productId'] : ''
                );
            }
            $html = $tool->getMainTemplate($items, array('id' => 'Featured'));
            $html = '<div class="MagicToolboxContainer">'.$html.'</div>';
            $product = & $GLOBALS['randProd'][0];
            $pattern = 'images\/uploads\/(?:'.preg_quote($product['image'], '/').'|thumbs\/thumb_'.preg_quote(basename($product['image'])).')';
            if(empty($product['image'])) {
                $pattern = preg_quote('skins/'.MT_SKIN_FOLDER.'/styleImages/thumb_nophoto.gif', '/');
            }
            $pattern = /*'(?:'.preg_quote(MT_ROOT_REL, '/').')?'.*/'[^"]*?'.$pattern;
            $pattern = '<img [^>]*?src="'.$pattern.'"[^>]*>(?:[^<]*<\/img>)?';
            $pattern = '<a [^>]*?viewProd[^>]*>[^<]*'.$pattern.'[^<]*<\/a>';//href="index.php?_a=viewProd&amp;productId={PRODUCT_ID}"
            //NOTE: replace image
            $contents = preg_replace("/{$pattern}/is", $html, $contents);
            //NOTE: cut link under image
            $contents = preg_replace('/<span [^>]*?class="[^"]*?txtCopy[^"]*"[^>]*>.*?<\/span>/is', '', $contents);

            $showHeaders = true;
            break;
        //NOTE: popular products
        case 'popular_products':
            if($tool->params->checkValue('enable-effect', 'No', 'popular')) break;
            $tool->params->setProfile('popular');
            global $db, $glob;
            $limit = $tool->params->getValue('count-of-products');
            if(empty($limit)) break;
            $where = array();
            if(isset($_GET['catId'])) {
                $where[] = 'p.cat_id = '.intval($_GET['catId']);
            }
            $where[] = 'p.cat_id > 0';
            $where[] = 'p.cat_id = c.cat_id';
            $where[] = 'p.image != \'\'';
            if(CUBECART_VERSION_4) {
                $where[] = 'p.disabled !=\'1\'';
                $where[] = 'c.hide =\'0\'';
                $where[] = '(c.cat_desc IS NULL OR c.cat_desc != \'##HIDDEN##\')';
            }
            $sql = 'SELECT DISTINCT p.name, p.image, p.productId '.
                   'FROM '.$glob['dbprefix'].'CubeCart_inventory as p, '.$glob['dbprefix'].'CubeCart_category as c '.
                   'WHERE '.implode(' AND ', $where).
                   ' ORDER BY popularity DESC '.
                   'LIMIT '.$limit;
            $products = $db->select($sql);
            if(empty($products)) break;
            $useLink = $tool->params->checkValue('link-to-product-page', 'Yes');
            $items = array();
            foreach($products as $product) {
                $items[] = array(
                    'title' => $product['name'],
                    'alt' => $product['name'],
                    'img' => getMagicSlideshowImage($product['image'], 'thumb', $product['productId']),
                    'thumb' => getMagicSlideshowImage($product['image'], 'selector', $product['productId']),
                    'fullscreen' => getMagicSlideshowImage($product['image'], 'original', $product['productId']),
                    'link' => $useLink ? MT_ROOT_REL.'index.php?'.(CUBECART_VERSION_4 ? '_a' : 'act').'=viewProd&productId='.$product['productId'] : ''
                );
            }
            $html = $tool->getMainTemplate($items, array('id' => 'Popular'));
            $html = '<div class="MagicToolboxContainer">'.$html.'</div>';
            //NOTE: replace image
            $contents = preg_replace('/<ol(?:>| [^>]*>).*?<\/ol>/is', $html, $contents);

            $showHeaders = true;
            break;
        //TODO: sale items
        //case 'sale_items':
        //    break;
        //NOTE: Slideshow on home page
        case 'index':
            if($tool->params->checkValue('enable-effect', 'No', 'homeslideshow')) break;
            $tool->params->setProfile('homeslideshow');
            global $db, $glob;
            $imagesData = $db->select("SELECT * FROM {$glob['dbprefix']}magicslideshow_images ORDER BY `order`");
            if(empty($imagesData)) break;
            $items = array();
            //$imageBasePath = CC_ROOT_DIR.CC_DS.'images'.CC_DS.'magicslideshow'.CC_DS;
            $helper = loadMagicSlideshowImageHelperClass();
            foreach($imagesData as $imageData) {
                if($imageData['exclude']) continue;
                $items[] = array(
                    'title' => $imageData['title'],
                    'alt' => $imageData['title'],
                    'img' => $helper->create(CC_DS.'images'.CC_DS.'magicslideshow'.CC_DS.$imageData['name'], 'thumb'),
                    'thumb' => $helper->create(CC_DS.'images'.CC_DS.'magicslideshow'.CC_DS.$imageData['name'], 'selector'),
                    'fullscreen' => $helper->create(CC_DS.'images'.CC_DS.'magicslideshow'.CC_DS.$imageData['name'], 'original'),
                    'description' => $imageData['description'],
                    'link' => empty($imageData['link']) ? false : $imageData['link'],
                );
            }
            if(empty($items)) break;
            $html = $tool->getMainTemplate($items, array('id' => 'HomeMagicSlideshow'));
            $contents = '<div class="MagicToolboxContainer">'.$html.'</div>'.$contents;

            $showHeaders = true;
            break;
        //NOTE: all page
        case 'body':
            $tool->params->resetProfile();
            global $body, $glob;

            if(!$showHeaders) break;
            // product page
            //(string)$body->vars['PHP']['page'] == 'viewProd'

            $headers = '';
            $headers .= $tool->getHeadersTemplate(MT_ROOT_REL.'modules/magictoolbox/MagicSlideshow/core');
            //$headers .= '<link type="text/css" href="'.MT_ROOT_REL.'modules/magictoolbox/MagicSlideshow/core/styles.css" rel="stylesheet" media="screen" />';

            if(preg_match('/<\/head>/is', $contents, $matches)) {
                $contents = str_replace($matches[0], $headers.$matches[0], $contents);
            } else {
                $contents = $headers.$contents;
            }

            $showHeaders = false;
            break;
    }

    return $contents;
}


function getMagicSlideshowImage($img, $resize = false, $pid = null) {

    static $noPhoto = null;
    if($noPhoto == null) {
        global $glob, $config;
        $noPhoto = MT_ROOT_REL.'skins/'.MT_SKIN_FOLDER.'/styleImages/thumb_nophoto.gif';
    }
    if(empty($img)) {
        return $noPhoto;
    }

    //$img = imgPath($img);

    $imgLink = MT_ROOT_REL.'images/uploads/'.$img;
    $img = str_replace(array('%20', '/'), array(' ', CC_DS), $img);

    if(!file_exists(CC_ROOT_DIR.CC_DS.'images'.CC_DS.'uploads'.CC_DS.$img)) {
        return $noPhoto;
    }

    if($resize) {
        $helper = loadMagicSlideshowImageHelperClass();
        if(empty($pid)) $pid = null;
        $imgLink = $helper->create(CC_DS.'images'.CC_DS.'uploads'.CC_DS.$img, $resize, $pid);
    }

    return $imgLink;
}

?>
