<?php
    /**
     *  CubeCart module installer class
     */

    require_once(dirname(__FILE__).'/magictoolbox.installer.core.class.php');

    class MagicToolboxCubecartModuleInstallerClass extends MagicToolboxCoreInstallerClass {
        var $cubecartVersion;
        var $xtplFile;
        var $adminFolder = 'admin';
        var $isXtplPhpModified = false;
        var $isNavigationIncPhpModified = false;
        var $magictoolboxModules = array(
            'Magic360',
            'Magic360Flash',
            'MagicZoom',
            'MagicZoomPlus',
            'MagicThumb',
            'MagicMagnify',
            'MagicMagnifyPlus',
            'MagicSlideshow',
            'MagicScroll',
            'MagicTouch',
        );
        var $areThereOtherModules = false;

        function __construct() {
            $this->dir = dirname(dirname(__FILE__));
            $this->modDir = dirname(__FILE__).'/module';

            require_once(dirname(dirname(__FILE__)).'/includes/global.inc.php');

            //NOTE: for fix url's in css files
            //NOTE: www path to resources (relative to the root folder)
            $this->resDir = rtrim($glob['rootRel'], '/').'/modules/magictoolbox/MagicSlideshow/core';

            if(isset($glob['adminFolder'])) {
                $this->adminFolder = $glob['adminFolder'];
            } else {
                $this->adminFolder = 'admin';
            }

            if(file_exists($this->dir.'/classes/xtpl.php')) {
                $this->cubecartVersion = 3;
                $this->xtplFile = 'classes/xtpl.php';
            } else {
                $this->cubecartVersion = 4;
                $this->xtplFile = 'classes/xtpl/xtpl.php';
            }
            if(file_exists($this->dir.'/'.$this->xtplFile)) {
                $contents = file_get_contents($this->dir.'/'.$this->xtplFile);
                if(preg_match('/extends\s+XTemplate_original/is', $contents)) {
                    $this->isXtplPhpModified = true;
                }
            }
            if(file_exists($this->dir.'/'.$this->adminFolder.'/includes/navigation.inc.php')) {
                $contents = file_get_contents($this->dir.'/'.$this->adminFolder.'/includes/navigation.inc.php');
                if(strpos($contents, 'magictoolbox') !== false) {
                    $this->isNavigationIncPhpModified = true;
                }
            }

            foreach($this->magictoolboxModules as $module) {
                if($module != 'MagicSlideshow' && file_exists($this->dir.'/modules/magictoolbox/'.$module.'/'.strtolower($module).'.php')) {
                    $this->areThereOtherModules = true;
                    break;
                }
            }
        }

        function isModuleInstalled() {
            $this->setStatus('check', 'module');
            if(file_exists($this->dir.'/modules/magictoolbox/MagicSlideshow')) {
                return true;
            }
            return false;
        }

        function checkPlace() {
            $this->setStatus('check', 'place');
            if(!file_exists($this->dir.'/'.$this->xtplFile)) {
                $this->setError('Wrong location: please upload the files from the ZIP archive to the Cubecart store directory.');
                return false;
            }
            //if($this->installMode == 'install' && file_exists(dirname($this->dir.'/'.$this->xtplFile).'/xtpl_original.php')) {
            //    $this->setError('The file xtpl_original.php is present in '.dirname($this->dir.'/'.$this->xtplFile).' folder. Make sure that another version of module is not installed.');
            //    return false;
            //}
            return true;
        }

        function checkPerm() {
            $this->setStatus('check', 'perm');
            $files = array(
                // directory
                '/modules',
                '/classes'.($this->cubecartVersion == 4 ? '/xtpl' : ''),
                '/'.$this->adminFolder.'/includes',
                // file
                '/'.$this->xtplFile,
                '/'.$this->adminFolder.'/includes/navigation.inc.php'
            );
            if($this->cubecartVersion == 3) {
                $files[] = '/'.$this->adminFolder.'/modules';
            }
            list($result, $wrang) = $this->checkFilesPerm($files);
            if(!$result) {
                $this->setError('This installer need to modify some Cubecart store files.');
                $this->setError('Please check write access for following files of your Cubecart store:');
                $this->setError($wrang, '&nbsp;&nbsp;&nbsp;-&nbsp;');
                return false;
            }
            return true;
        }

        function backupFiles() {
            $this->setStatus('backup', 'files');
            $backups = array();
            if(!$this->isXtplPhpModified) {
                $backups[] = '/'.$this->xtplFile;
            }
            if(!$this->isNavigationIncPhpModified) {
                $backups[] = '/'.$this->adminFolder.'/includes/navigation.inc.php';
            }
            list($result, $wrang) = $this->createBackups($backups);
            if(!$result) {
                $this->setError('Can\'t create backups for following files:');
                $this->setError($wrang, '&nbsp;&nbsp;&nbsp;-&nbsp;');
                $this->setError('Please check write access');
                return false;
            }
            return true;
        }

        function restoreStep_backupFiles() {
            if(!$this->areThereOtherModules) {
                $this->removeBackups(array(
                    '/'.$this->xtplFile,
                    '/'.$this->adminFolder.'/includes/navigation.inc.php'
                ));
            }
            return true;
        }

        function installFiles() {
            $this->setStatus('install', 'files');

            //copy magictoolbox folder into /app/etc
            $this->copyDir($this->modDir.'/magictoolbox', $this->dir.'/modules/magictoolbox');

            if($this->cubecartVersion == 3) {
                //copy admin folder for CubeCart 3
                $this->copyDir($this->modDir.'/'.$this->adminFolder.'/modules', $this->dir.'/'.$this->adminFolder.'/modules');
            }

            if(!$this->isXtplPhpModified) {
                //modify xtpl.php file
                $c = file_get_contents($this->dir.'/'.$this->xtplFile);
                $pattern = '/class\s+XTemplate/is';
                $replace = 'class XTemplate_original';
                $c = preg_replace($pattern, $replace, $c);
                $pattern = '/function\s+XTemplate\s+\(/is';
                $replace = 'function XTemplate_original(';
                $c = preg_replace($pattern, $replace, $c);
                file_put_contents($this->dir.'/'.$this->xtplFile, $c);

                //move xtpl.php to xtpl_original.php
                if(rename($this->dir.'/'.$this->xtplFile, dirname($this->dir.'/'.$this->xtplFile).'/xtpl_original.php')) {
                    $this->log('CREATE FILE '.dirname($this->dir.'/'.$this->xtplFile).'/xtpl_original.php');
                }
            }

            //copy new xtpl.php
            if(copy($this->modDir.'/xtpl.php', $this->dir.'/'.$this->xtplFile)) {
                $this->log('CREATE FILE '.$this->dir.'/'.$this->xtplFile);
            }
            @chmod($this->dir.'/'.$this->xtplFile, 0755);

            if(!$this->isNavigationIncPhpModified) {
                //modify navigation.inc.php file
                $c = file_get_contents($this->dir.'/'.$this->adminFolder.'/includes/navigation.inc.php');
                if($this->cubecartVersion == 4) {
                    $pattern = '/(<ul[^>]*?id="navStoreModules"[^>]*>)/is';
                    $replace = "$1\n\t\t".
                    '<li><a <'.'?php if(permission(\'magictoolbox\',\'read\')){ ?>href="<'.'?php echo $glob[\'adminFile\']; ?>?_g=modules&amp;module=magictoolbox" class="txtLink"<'.'?php } else { echo $link401; } ?>>MagicToolbox</a></li>'.
                    "\n";
                } else {
                    $pattern = '/(<span[^>]*?class="[^"]*?navTitle[^"]*"[^>]*>.*?<\/span>[^<]*?<ul>)/is';
                    $replace = "$1\n\t\t".
                    '<li><a <'.'?php if(permission(\'magictoolbox\',\'read\')==TRUE){ ?>href="<'.'?php echo $GLOBALS[\'rootRel\']; ?>admin/modules/magictoolbox/" class="txtLink"<'.'?php } else { echo $link401; } ?>>MagicToolbox</a></li>'.
                    "\n";
                }
                $c = preg_replace($pattern, $replace, $c);
                file_put_contents($this->dir.'/'.$this->adminFolder.'/includes/navigation.inc.php', $c);
            }

            return true;
        }

        function restoreStep_installFiles() {
            if(!$this->areThereOtherModules) {
                $this->restoreFromBackups(array(
                    '/'.$this->xtplFile,
                    '/'.$this->adminFolder.'/includes/navigation.inc.php'
                ));
            }
            $this->removeDir($this->dir.'/modules/magictoolbox/MagicSlideshow');
            if($this->cubecartVersion == 3) {
                $this->removeDir($this->dir.'/'.$this->adminFolder.'/modules/magictoolbox/MagicSlideshow');
            }
            if(!$this->areThereOtherModules) @unlink(dirname($this->dir.'/'.$this->xtplFile).'/xtpl_original.php');
            return true;
        }

        function uninstall_from_logFile($exclude = array()) {
            if($this->areThereOtherModules) {
                $exclude[] = $this->xtplFile;
                $exclude[] = dirname($this->xtplFile).'/xtpl_original.php';
                $exclude[] = dirname($this->xtplFile).'/xtpl~backup~created~by~magictoolbox~team.php';
                $exclude[] = $this->adminFolder.'/includes/navigation.inc.php';
                $exclude[] = $this->adminFolder.'/includes/navigation.inc~backup~created~by~magictoolbox~team.php';
                if($this->cubecartVersion == 3) {
                    $exclude[] = $this->adminFolder.'/modules/magictoolbox/index.php';
                }
            }
            $result = parent::uninstall_from_logFile($exclude);
            if(!$this->areThereOtherModules) {
                //NOTE: spike for the case when the module is not installed first but removed the last
                $this->restoreFromBackups(array(
                    '/'.$this->xtplFile,
                    '/'.$this->adminFolder.'/includes/navigation.inc.php'
                ));
                @unlink(dirname($this->dir.'/'.$this->xtplFile).'/xtpl_original.php');
            }
            return $result;
        }

        function upgrade($files) {
            $path = $this->dir.'/modules/magictoolbox/MagicSlideshow/core/';
            foreach($files as $name => $file) {
                if(file_exists($path.$name)) {
                    unlink($path.$name);
                }
                file_put_contents($path.$name, $file);
                chmod($path.$name, 0755);
            }
            return true;
        }

        function getPlatformVersion() {
            if(file_exists($this->dir.'/ini.inc.php')) {
                $contents  = file_get_contents($this->dir.'/ini.inc.php');
                $match = array();
                if(preg_match('/\$ini\s*\[\s*\'ver\'\s*\]\s*=\s*\'([^\']*)\'/i', $contents, $match)) {
                    return $match[1];
                }
            }
            return '';
        }

    }
