<?php

ini_set('display_errors', true);
error_reporting(E_ALL & ~E_NOTICE);

defined('CUBECART_VERSION_3') || define('CUBECART_VERSION_3', false);

if(!CUBECART_VERSION_3) {
    if(!defined('CC_INI_SET')) { die('Access Denied'); }
    permission('settings', 'read', true);
    require($glob['adminFolder'].CC_DS.'includes'.CC_DS.'header.inc.php');
}

$moduleDir = CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'magictoolbox'.CC_DS.'MagicScroll';
$coreFile = $moduleDir.CC_DS.'core'.CC_DS.'magicscroll.module.core.class.php';
if(!file_exists($coreFile)) {
    echo '<p class="warnText">File: '.$coreFile.' does not exists! Make sure that the module is installed correctly.</p>';
    return;
}

require($coreFile);
$tool = new MagicScrollModuleCoreClass;

$blocks = array(
				'default' => 'General',
				'product' => 'Product page',
				'homeslideshow' => 'Home page Slideshow',
				'featured' => 'Featured block',
				'popular' => 'Popular block',
			);

global $glob, $db;
$tabels = $db->select("SHOW TABLES LIKE '{$glob['dbprefix']}magicscroll_images'");
if(empty($tabels)) {
    $db->misc("CREATE TABLE {$glob['dbprefix']}magicscroll_images (
                    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
                    `name` VARCHAR(64) NOT NULL,
                    `title` VARCHAR(64) DEFAULT '',
                    `description` TEXT,
                    `link` VARCHAR(256) DEFAULT '',
                    `order` INT UNSIGNED DEFAULT 0,
                    `exclude` INT(2) UNSIGNED DEFAULT 0,
                    PRIMARY KEY (id)
                ) ENGINE=MyISAM DEFAULT CHARSET=utf8;",
                false
    );
}

$imageBasePath = CC_ROOT_DIR.CC_DS.'images'.CC_DS.'magicscroll'.CC_DS;
$imageBaseUrl = rtrim($glob['rootRel'], '/').'/images/magicscroll/';

$imagesData = empty($_POST['images-data']) ? array() : $_POST['images-data'];
foreach($imagesData as $imageId => $imageData) {
    if(isset($imageData['delete'])) {
        $imagesData = $db->select("SELECT `name` FROM {$glob['dbprefix']}magicscroll_images WHERE `id`={$imageId}");
        if(!empty($imagesData)) {
            @unlink($imageBasePath.$imagesData[0]['name']);
            $db->misc("DELETE FROM {$glob['dbprefix']}magicscroll_images WHERE `id`={$imageId}", false);
        }
    } else {
        $imageData['title'] = $db->mySQLSafe($imageData['title'], '');
        $imageData['description'] = $db->mySQLSafe($imageData['description'], '');
        $imageData['link'] = $db->mySQLSafe($imageData['link'], '');
        $imageData['order'] = intval($imageData['order']);
        $imageData['exclude'] = isset($imageData['exclude']) ? 1 : 0;
        $db->misc(
            "UPDATE {$glob['dbprefix']}magicscroll_images SET ".
            "`title`='{$imageData['title']}', ".
            "`description`='{$imageData['description']}', ".
            "`link`='{$imageData['link']}', ".
            "`order`={$imageData['order']}, ".
            "`exclude`={$imageData['exclude']} ".
            "WHERE `id`={$imageId}",
            false
        );
    }
}

if(!empty($_FILES['magicscroll_image_files']['tmp_name'])) {
    if(is_dir($imageBasePath) || mkdir($imageBasePath)) {
        foreach($_FILES['magicscroll_image_files']['tmp_name'] as $key => $tempName) {
            if(!empty($tempName) && file_exists($tempName)) {
                $name = preg_replace('/[^a-zA-Z0-9()_\.-]/is', '', $_FILES['magicscroll_image_files']['name'][$key]);
                $ext = substr($name, strrpos($name, '.'));
                $name = substr($name, 0, -strlen($ext));
                $index = 0;
                $suffix = '';
                while(file_exists($imageBasePath.$name.$suffix.$ext)) {
                    $suffix = "({$index})";
                    $index++;
                }
                if(!move_uploaded_file($tempName, $imageBasePath.$name.$suffix.$ext)) {
                    //An error occurred during the image upload.
                    break;
                }
                $db->misc("INSERT INTO {$glob['dbprefix']}magicscroll_images (`name`) VALUES ('{$name}{$suffix}{$ext}')");
            }
        }
    }
}

$imagesData = $db->select("SELECT * FROM {$glob['dbprefix']}magicscroll_images ORDER BY `order`");


if(CUBECART_VERSION_3) $moduleName = 'MagicScroll';

if(isset($_POST['module'])) {
    if(!CUBECART_VERSION_3) {
        require CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'status.inc.php';
        $cache = new cache('config.'.$moduleName);
        $cache->clearCache();
    } else {
        //require_once('..'.CC_DS.'..'.CC_DS.'status.php');
        require_once(CC_ROOT_DIR.CC_DS.'admin'.CC_DS.'modules'.CC_DS.'status.php');
        //require_once('..'.CC_DS.'..'.CC_DS.'..'.CC_DS.'includes'.CC_DS.'functions.inc.php');
        require_once(CC_ROOT_DIR.CC_DS.'admin'.CC_DS.'includes'.CC_DS.'functions.inc.php');
    }

    if(isset($_POST['magic_reset'])) {
        $_POST['module'] = array(
            //'status' => $_POST['module']['status'],
        );
    }

    foreach($_POST['module'] as $blockId => $params) {
        if(!is_array($params)) continue;
        $blockId = preg_replace('/_block$/', '', $blockId);
        if(!array_key_exists($blockId, $blocks)) continue;
        foreach($params as $id => $value) {
            if($tool->params->paramExists($id, $blockId, false)) {
                $value = trim($value);
                if($tool->params->getType($id, $blockId, false) == 'array' && !in_array($value, $tool->params->getValues($id, $blockId, false))) {
                    $value = $tool->params->getDefaultValue($id, $blockId, false);
                }
                $_POST['module'][$blockId.'_block'][$id] = $value;
            }
        }
        if(CUBECART_VERSION_3) {
            $_POST['module'][$blockId.'_block'] = serialize($_POST['module'][$blockId.'_block']);
        }
    }
    $msg = writeDbConf($_POST['module'], $moduleName, array());
    global $lang;
    $msg = "<p class='infoText'>".$lang['admin_common']['incs_db_config_updated']."</p>";
    //echo '<p class="infoText">Configuration Updated.</p>';
    echo $msg;
}

$config = fetchDbConfig($moduleName);
if(CUBECART_VERSION_3 && is_array($config)) {
    foreach($config as $blockId => $data) {
        $blockId = preg_replace('/_block$/', '', $blockId);
        if(!array_key_exists($blockId, $blocks)) continue;
        $config[$blockId.'_block'] = unserialize($config[$blockId.'_block']);
    }
}
if($config === false || isset($_POST['magic_reset'])) {
    require($moduleDir.CC_DS.'defaults.php');
}
foreach($config as $blockId => $params) {
    if(!is_array($params)) continue;
    $blockId = preg_replace('/_block$/', '', $blockId);
    if(!array_key_exists($blockId, $blocks)) continue;
    foreach($params as $id => $value) {
        $tool->params->setValue($id, $value, $blockId);
    }
}

$graphics_path = $glob['storeURL'].'/modules/magictoolbox/MagicScroll/admin_graphics';
$paramsMap = array(
		'default' => array(
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
				'square-images',
			),
			'Scroll' => array(
				'width',
				'height',
				'orientation',
				'mode',
				'items',
				'speed',
				'autoplay',
				'loop',
				'step',
				'arrows',
				'pagination',
				'easing',
				'scrollOnWheel',
				'lazy-load',
				'scroll-extra-styles',
				'show-image-title',
			),
			'Miscellaneous' => array(
				'count-of-products',
				'link-to-product-page',
				'imagemagick',
				'image-quality',
			),
			'Watermark' => array(
				'watermark',
				'watermark-max-width',
				'watermark-max-height',
				'watermark-opacity',
				'watermark-position',
				'watermark-offset-x',
				'watermark-offset-y',
			),
		),
		'product' => array(
			'General' => array(
				'enable-effect',
			),
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
			),
			'Scroll' => array(
				'width',
				'height',
				'orientation',
				'mode',
				'items',
				'speed',
				'autoplay',
				'loop',
				'step',
				'arrows',
				'pagination',
				'easing',
				'scrollOnWheel',
				'lazy-load',
				'scroll-extra-styles',
				'show-image-title',
			),
		),
		'homeslideshow' => array(
			'General' => array(
				'enable-effect',
			),
			'Setup slideshow for home page' => array(
			),
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
			),
			'Scroll' => array(
				'width',
				'height',
				'orientation',
				'mode',
				'items',
				'speed',
				'autoplay',
				'loop',
				'step',
				'arrows',
				'pagination',
				'easing',
				'scrollOnWheel',
				'lazy-load',
				'scroll-extra-styles',
				'show-image-title',
			),
		),
		'featured' => array(
			'General' => array(
				'enable-effect',
			),
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
			),
			'Scroll' => array(
				'width',
				'height',
				'orientation',
				'mode',
				'items',
				'speed',
				'autoplay',
				'loop',
				'step',
				'arrows',
				'pagination',
				'easing',
				'scrollOnWheel',
				'lazy-load',
				'scroll-extra-styles',
				'show-image-title',
			),
			'Miscellaneous' => array(
				'count-of-products',
				'link-to-product-page',
			),
		),
		'popular' => array(
			'General' => array(
				'enable-effect',
			),
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
			),
			'Scroll' => array(
				'width',
				'height',
				'orientation',
				'mode',
				'items',
				'speed',
				'autoplay',
				'loop',
				'step',
				'arrows',
				'pagination',
				'easing',
				'scrollOnWheel',
				'lazy-load',
				'scroll-extra-styles',
				'show-image-title',
			),
			'Miscellaneous' => array(
				'count-of-products',
				'link-to-product-page',
			),
		),
	);

?>
<style type="text/css">
* {
    font-family: Arial,Verdana,Helvetica,sans-serif;
}
#container {
    margin: 0 auto;
    text-align: left;
    width: 921px;
    background-color: #EFEFDE;
    color: #000000;
    font-size: 12px;
    border: 1px solid #050F72;
    padding: 20px;
    border-radius: 5px;
}
h2 {
    color: #268CCD;
    font-size: 1.4em;
    margin: 0 0 0.83em;
}
legend {
    font-family: Trebuchet,Arial,Helvetica,sans-serif;
    background: none repeat scroll 0 0 #EFEFDE;
    border: 1px solid #050F72;
    font-weight: 700;
    margin: 0;
    padding: 0.2em 0.5em;
    text-align: left;
    border-radius: 5px;
}
label {
    float: left;
    font-weight: bold;
    padding: 0.2em 0.5em 0 0;
    /*padding: 0;*/
    text-align: right;
    width: 200px;
}
.margin-form {
    color: #7F7F7F;
    font-size: 0.85em;
    padding: 0 0 1em 210px;
}
.clear {
    clear: both;
}
.pspace {
    padding-top: 1em;
}
input[type="text"], input[type="password"], input[type="file"], textarea {
    border: 1px solid #A5ACB2;
}
input[type="text"], input[type="password"], input[type="file"], textarea, select, option {
    background-color: #FFFFFF;
}
input[type="text"], input[type="password"], input[type="file"], textarea {
    padding: 2px 4px;
}
input[type="radio"], input[type="checkbox"] {
    background-color: transparent;
}
input, textarea, option {
    color: #000000;
    font-size: 12px;
    margin: 0;
    padding: 0;
}
input {
    vertical-align: middle;
}
input[disabled] {
    color: #AFADAA;
}
select {
    border: 1px solid #E0D0B1;
    font-size: 12px;
}
label.t {
    clear: none;
    float: none;
    font-size: 12px;
    font-weight: bold;
    margin: 0;
    /*padding: 0;*/
    padding: 0 4px;
    /*padding:0.2em 0 0; */
    width: auto;
}
label img {
   vertical-align: bottom;
   padding: 0 4px 0 0;
}
.button {
    background-color: #0B70CE;
    border: 1px solid #000000;
    color: #FFFFFF;
    font-family: Verdana,Arial,Helvetica,sans-serif;
    font-size: 12px;
    font-weight: bold;
}
.hint {
    background-color: #FFFFCC;
    border: 1px solid #050F72;
    color: #7F7F7F;
    display: block;
    left: 0px;
    margin-bottom: 2px;
    margin-top: 4px;
    padding: 6px;
    position: relative;
    width: 501px;
}
#magicscroll_icon {
    float: left;
    margin: 0 5px 5px 0;
}
.margin-form a, .margin-form a:hover, .margin-form a:visited {
    color: #050F72;
}

.magic_tabs { margin: 0; padding: 0; float: left; width: 132px; position: relative; z-index: 1; }
.magic_tabs li { list-style-type: none; margin: 0; padding: 0; }
.magic_tabs a { display: inline-block; width: 120px; margin-bottom: -1px; border: 1px solid #050F72; color: #050F72; font-weight: bold; line-height: 22px; margin-right: -1px; padding: 2px 5px; text-decoration: none; background: #EFEFDE; font-size: 12px; border-top-left-radius: 5px; border-bottom-left-radius: 5px; }
.magic_tabs a.tabactive { text-decoration: none; color: #000; font-weight: bold; background: #FFFFED; border-right: none; width: 121px;}
.magic_tabs li a:hover { background: #050F72; color: #fff; text-decoration: none; border-right: none; }
.magic_tabs li a.tabactive:hover { background: #fff; color: #000; }
.magic_tabCont { display: none; border: 1px solid #050F72; padding: 10px; border-top-right-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; }
.magic_tabContWrapper { float: left; width: 790px; clear: right; margin: 0; margin-left: -1px;}
.magic_tabCont.magic_active { display: block; }
.magic_tabCont div.margin-form label { padding: 0 4px; }
.magic_tabCont label { padding: 0; width: 200px; }
.magic_tabCont .margin-form label { padding: 0.2em 0 0; margin-right: 10px; width: auto; }
.magic_tabCont .margin-form { padding-top: 1px !important; padding-left: 210px !important; }
.magic_hint {
    display: block;
    position: relative;
    left: 0px;
    width: 396px;
    margin-top: 4px;
    margin-bottom: 2px;
    border: 1px solid #c93;
    padding: 6px;
    color: #7F7F7F;
    background-color: #EFEFDE;
}
.margin-form input[type=text] {
    width: 400px;
}
#magicscroll_settings > p {
    margin: 0;
    padding-top: 6px;
    padding-bottom: 6px;
    clear: left;
}
#container fieldset, .magic_tabCont fieldset {
    margin: 17px 0px;
    background: none repeat scroll 0 0 #FFFFED;
    border: 1px solid #050F72;
    font-size: 1.1em;
    padding: 1em;
    border-radius: 5px;
}
#magicscroll_icon {
    float: left;
    margin: 0 5px 5px 0;
}
div.status-wrapper {
    width: 770px;
    margin: 0;
    margin-left: 132px;
    padding: 10px;
}
div.buttons-container {
    text-align: center;
}
div.buttons-container input {
    padding: 5px;
    border-radius: 5px;
}
div.buttons-container-fixed {
    background: none repeat scroll 0 0 #EFEFDE;
    border-bottom: 1px solid #988753;
    opacity: 0.85;
    position: fixed;
    left: 0;
    top: 0;
    width: 100%;
    z-index: 1000;
}
div.buttons-container-fixed input {
    margin: 5px 0;
}
</style>

<style type="text/css">
div.upload-container {
    text-align: center;
    overflow: hidden;
    width: 112px;
    height: 24px;
    margin: 10px 0 0;
}
input.upload-button {
    width: 112px;
    height: 24px;
}
input.upload-file {
    margin-top: -24px;
    margin-left:-410px;
    -moz-opacity: 0;
    filter: alpha(opacity=0);
    opacity: 0;
    font-size: 150px;
    height: 100px;
    cursor: pointer;
}
#magicscroll_images {
    border: 1px solid #DFD5C3;
    border-bottom: none;
}
#magicscroll_images th {
    background: none repeat scroll 0 0 #F2F2F2;
    padding: 0 1px 0 1px;
    text-align: center;
    border-bottom: 1px solid #DFD5C3;
    border-right: 1px solid #DFD5C3;
}
#magicscroll_images th:last-child {
    border-right: none;
}
#magicscroll_images td {
    padding: 4px 1px;
    text-align: center;
    border-bottom: 1px solid #DFD5C3;
}
#magicscroll_images img {
    max-width: 60px;
    max-height: 60px;
}
#magicscroll_images input[type="text"], #magicscroll_images textarea {
    width: 160px;
}
#magicscroll_images textarea {
    min-width: 160px;
    max-width: 160px;
    min-height: 18px;
}
#magicscroll_images input[type="text"].input-order {
    width: 18px;
}
</style>
<div id="container">
<h2>Magic Scroll configuration</h2>
<?php if(file_exists(dirname(__FILE__).'/../../../classes/xtpl.php')) { ?>
<form name="magicscroll_settings" action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post" enctype="multipart/form-data">
<?php } else { ?>
<form name="magicscroll_settings" action="<?php echo $glob['adminFile']; ?>?_g=<?php echo $_GET['_g']; ?>&amp;module=<?php echo $_GET['module']; ?>" method="post" enctype="multipart/form-data">
<?php } ?>

<div id="buttons-container-wrapper">
    <div id="buttons-container" class="buttons-container">
        <input class="button" type="submit" id="magic_submit" name="magic_submit" value="Save settings" />
        <input class="button" type="submit" name="magic_reset" value="Reset all options to default" />
    </div>
</div>

<div class="status-wrapper">
    <fieldset>
        <legend>Module status</legend>
        <label for="status">Magic Scroll status</label>
        <div class="margin-form">
            <select name="module[status]" id="status" class="textbox">
                <option value="1" <?php if($config['status'] == 1) echo "selected='selected'"; ?>>Enabled</option>
                <option value="0" <?php if($config['status'] == 0) echo "selected='selected'"; ?>>Disabled</option>
            </select>
        </div>
    </fieldset>
</div>

<ul class="magic_tabs">
<?php foreach($blocks as $blockId => $blockTitle) { ?>
<li><a id="<?php echo $blockId; ?>" onclick="return magic_changeTab(this);" <?php if($blockId == 'default') echo 'class="tabactive" '; ?>href="#"><?php echo $blockTitle; ?></a></li>
<?php } ?>
</ul>

<div class="magic_tabContWrapper">
<?php foreach($paramsMap as $blockId => $groups) {
    $tool->params->setProfile($blockId);
?>
<div id="<?php echo $blockId; ?>_content" class="magic_tabCont<?php if($blockId == 'default') echo ' magic_active'; ?>">
    <?php foreach($groups as $groupTitle => $params) { ?>
    <fieldset>
    <legend><?php echo $groupTitle; ?></legend>
        <?php
            if($blockId == 'homeslideshow' && $groupTitle == 'Setup slideshow for home page') {
                if(!empty($imagesData)) {
        ?>
                    <label style="float: none;">Slideshow images</label>
                    <div style="margin: 10px 0 10px 0;">
                    <table id="magicscroll_images" cellspacing="0" cellpadding="0" class="table">
                    <thead>
                    <tr>
                        <th>Image</th>
                        <th>Title</th>
                        <th>Description</th>
                        <th>Link</th>
                        <th>Order</th>
                        <th>Exclude</th>
                        <th>Remove</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                        foreach($imagesData as $imageData) {
                    ?>
                        <tr id="row-<?php echo $imageData['id']; ?>">
                            <td><img src="<?php echo $imageBaseUrl.$imageData['name']; ?>" alt="<?php echo $imageData['title']; ?>" title="<?php echo $imageData['title']; ?>" /></td>
                            <td style="vertical-align: top;"><input type="text" name="images-data[<?php echo $imageData['id']; ?>][title]" id="title-<?php echo $imageData['id']; ?>" value="<?php echo $imageData['title']; ?>" /></td>
                            <td style="vertical-align: top;"><textarea name="images-data[<?php echo $imageData['id']; ?>][description]" id="description-<?php echo $imageData['id']; ?>" ><?php echo $imageData['description']; ?></textarea></td>
                            <td style="vertical-align: top;"><input type="text" name="images-data[<?php echo $imageData['id']; ?>][link]" id="link-<?php echo $imageData['id']; ?>" value="<?php echo $imageData['link']; ?>" /></td>
                            <td style="vertical-align: top;"><input type="text" name="images-data[<?php echo $imageData['id']; ?>][order]" id="order-<?php echo $imageData['id']; ?>" value="<?php echo $imageData['order']; ?>" class="input-order" /></td>
                            <td class="center"><input type="checkbox" name="images-data[<?php echo $imageData['id']; ?>][exclude]" id="exclude-<?php echo $imageData['id']; ?>" value="<?php echo $imageData['exclude']; ?>" <?php echo intval($imageData['exclude'])?'checked="checked" ':''; ?> /></td>
                            <td class="center"><input type="checkbox" name="images-data[<?php echo $imageData['id']; ?>][delete]" id="delete-<?php echo $imageData['id']; ?>" value="0" /></td>
                        </tr>
                    <?php
                        }
                    ?>
                    </tbody>
                    </table>
                    </div>
                    <input class="button" type="button" onclick="document.magicscroll_settings.magic_submit.click();" value="Save" style="margin: 0 0 10px 0;" /><br />
        <?php
                }
        ?>
                    <div class="upload-container">
                        <input class="upload-button button" type="button" value="Upload images" />
                        <input class="upload-file" type="file" name="magicscroll_image_files[]" id="upload-file" multiple="multiple" accept="image/*" size="1" onchange="document.magicscroll_settings.magic_submit.click();"/>
                    </div>
        <?php
            }
        ?>
        <?php foreach($params as $id) {
            $param_value = $tool->params->getValue($id);
            $param_enable = ($blockId == 'default'
                            || in_array($id, array('enable-effect', 'template', 'magicscroll'))
                            || $tool->type == 'standard' && in_array($groupTitle, array('Scroll', 'Scroll Arrows', 'Scroll Slider', 'Scroll effect', 'Multiple images'))
                            || $tool->params->paramExists($id));
        ?>
        <label for="<?php echo $blockId.'-'.$id; ?>"><?php echo $tool->params->getLabel($id); ?></label>
        <div class="margin-form">
        <?php
        switch($tool->params->getType($id)) {
            case "array":
                if($tool->params->getSubType($id, $tool->params->generalProfile) == 'radio') {
                    foreach($tool->params->getValues($id) as $p) {
                        ?><input type="radio" value="<?php echo $p; ?>"<?php echo (($param_value == $p)?' checked="checked"':''); ?><?php echo $param_enable?'':' disabled="disabled"'; ?> name="module[<?php echo $blockId; ?>_block][<?php echo $id; ?>]" id="<?php echo $blockId.'-'.$id.'-'.$p; ?>" /><?php
                        ?><label class="t" for="<?php echo $blockId.'-'.$id.'-'.$p; ?>"><?php
                        $pLower = strtolower($p);
                        if($pLower == "yes")
                            echo '<img src="'.$graphics_path.'/yes.gif" alt="Enabled" title="Enabled" />';
                        else if($pLower == "no")
                            echo '<img src="'.$graphics_path.'/no.gif" alt="Disabled" title="Disabled" />';
                        else if($pLower == "left")
                            echo '<img src="'.$graphics_path.'/left.gif" alt="Left" title="Left" />';
                        else if($pLower == "right")
                            echo '<img src="'.$graphics_path.'/right.gif" alt="Right" title="Right" />';
                        else if($pLower == "top")
                            echo '<img src="'.$graphics_path.'/top.gif" alt="Top" title="Top" />';
                        else if($pLower == "bottom")
                            echo '<img src="'.$graphics_path.'/bottom.gif" alt="Bottom" title="Bottom" />';
                        else echo $p;
                        ?></label><?php
                    }
                } elseif($tool->params->getSubType($id, $tool->params->generalProfile) == 'select') {
                    ?><select name="module[<?php echo $blockId; ?>_block][<?php echo $id; ?>]" id="<?php echo $blockId.'-'.$id; ?>"<?php echo $param_enable?'':' disabled="disabled"'; ?>><?php
                    foreach($tool->params->getValues($id) as $p) {
                        ?><option value="<?php echo $p; ?>"<?php echo (($param_value==$p)?' selected="selected"':''); ?>><?php echo $p; ?></option><?php
                    }
                    ?></select><?php
                } else {
                    ?><input type="text" name="module[<?php echo $blockId; ?>_block][<?php echo $id; ?>]" id="<?php echo $blockId.'-'.$id; ?>" value="<?php echo $param_value; ?>"<?php echo $param_enable?'':' disabled="disabled"'; ?> /><?php
                }
                break;
            case "num":
            case "text":
            default:
                ?><input type="text" name="module[<?php echo $blockId; ?>_block][<?php echo $id; ?>]" id="<?php echo $blockId.'-'.$id; ?>" value="<?php echo $param_value; ?>"<?php echo $param_enable?'':' disabled="disabled"'; ?> /><?php
        }
        if($blockId != 'default'
          && !in_array($id, array('enable-effect', 'template', 'magicscroll'))
          && !($tool->type == 'standard' && in_array($groupTitle, array('Scroll', 'Scroll Arrows', 'Scroll Slider', 'Scroll effect', 'Multiple images')))) {
            if($param_enable) {
                echo '&nbsp;&nbsp;<a href="#" onclick="return useDefaultOption(this, \''.$id.'\', \''.$blockId.'\');">use default option</a>';
            } else {
                echo '&nbsp;&nbsp;<a href="#" onclick="return useDefaultOption(this, \''.$id.'\', \''.$blockId.'\');" class="optionDisabled">edit</a>';
            }
        }
        $hint = '';
        if($tool->params->getDescription($id))
            $hint = $tool->params->getDescription($id);
        if($tool->params->getType($id) != "array" && $tool->params->valuesExists($id, '', false)) {
            if($hint != '') $hint .= "<br />";
            $hint .= "#allowed values: ".implode(", ",$tool->params->getValues($id));
        }
        if($hint != '') {
            ?><p class="magic_hint clear"><?php echo $hint; ?></p><?php
        }
        ?>
        </div>
        <div class="clear pspace"></div>
        <?php } ?>
    </fieldset>
    <?php } ?>
</div>
<?php } ?>
</div>
<input type="hidden" id="magic_tabs_current" name="magic_tabs_current" value="default" />
<script type="text/javascript">
//<![CDATA[
var magic_tabs_current = 'default';
function magic_changeTab(elm) {
    if(document.getElementById(magic_tabs_current)) {
        document.getElementById(magic_tabs_current).className = '';
        document.getElementById(magic_tabs_current+'_content').className = 'magic_tabCont';
    }
    magic_tabs_current = document.getElementById('magic_tabs_current').value = elm.id;
    document.getElementById(magic_tabs_current).className = 'tabactive';
    document.getElementById(magic_tabs_current+'_content').className = 'magic_tabCont magic_active';
    elm.blur();
    return false;
}
<?php if(!empty($_POST['magic_tabs_current'])) { ?>
magic_changeTab(document.getElementById('<?php echo $_POST['magic_tabs_current']; ?>'));
<?php } ?>
function scrollHandler() {
    var buttonsContainer = document.getElementById('buttons-container');
    var buttonsContainerWrapper = buttonsContainer.parentNode;
    if(typeof(buttonsContainerWrapper.getBoundingClientRect) == 'undefined') return;
    var buttonsContainerWrapperBox = buttonsContainerWrapper.getBoundingClientRect();
    if(buttonsContainerWrapperBox.top < 0) {
        magicToolboxAddClass(buttonsContainer, 'buttons-container-fixed');
        //buttonsContainer.style.width = buttonsContainerWrapperBox.width+'px';
        //buttonsContainer.style.left = buttonsContainerWrapperBox.left+'px';
    } else {
        magicToolboxRemoveClass(buttonsContainer, 'buttons-container-fixed');
    }
}
if(window.addEventListener) {
    window.addEventListener('scroll', scrollHandler, false);
    window.addEventListener('resize', scrollHandler, false);
} else {
    window.attachEvent('scroll', scrollHandler);
    window.attachEvent('resize', scrollHandler);
}
//]]>
</script>
<script type="text/javascript">
//<![CDATA[
var blocks = ["<?php echo implode('", "', array_keys($blocks)); ?>"];
function magicToolboxHasClass(element, className) {
    return element.className.match(new RegExp('(\\s|^)'+className+'(\\s|$)'));
}
function magicToolboxAddClass(element, className) {
    if(!this.magicToolboxHasClass(element, className)) element.className += " "+className;
}
function magicToolboxRemoveClass(element, className) {
    if(magicToolboxHasClass(element, className)) {
        var reg = new RegExp('(\\s|^)'+className+'(\\s|$)');
        element.className = element.className.replace(reg, ' ');
    }
}

function useDefaultOption(anchorEl, optionId, blockId) {
    var elements = null;
    if(magicToolboxHasClass(anchorEl, 'optionDisabled')) {
        magicToolboxRemoveClass(anchorEl, 'optionDisabled');
        anchorEl.innerHTML = 'use default option';
        elements = anchorEl.parentNode.getElementsByTagName('select');
        for(var i = 0, l = elements.length; i < l; i++) {
            elements[i].removeAttribute('disabled');
        }
        elements = anchorEl.parentNode.getElementsByTagName('input');
        for(var i = 0, l = elements.length; i < l; i++) {
            elements[i].removeAttribute('disabled');
        }
    } else {
        magicToolboxAddClass(anchorEl, 'optionDisabled');
        anchorEl.innerHTML = 'edit';
        elements = anchorEl.parentNode.getElementsByTagName('select');
        for(var i = 0, l = elements.length; i < l; i++) {
            elements[i].setAttribute('disabled', true);
            var value = document.getElementById('default-'+optionId).value;
            for(var j = 0, ol = elements[i].options.length; j < ol; j++) {
                if(elements[i].options[j].value == value) {
                    elements[i].value = value;
                    elements[i].selectedIndex = j;
                    break;
                }
            }
        }
        elements = anchorEl.parentNode.getElementsByTagName('input');
        for(var i = 0, l = elements.length; i < l; i++) {
            if(elements[i].getAttribute('type') == 'text') {
                elements[i].setAttribute('disabled', true);
                elements[i].value = document.getElementById('default-'+optionId).value;
            } else if(elements[i].getAttribute('type') == 'radio') {
                elements[i].setAttribute('disabled', true);
                var radios = document.getElementsByName('module[default_block]['+optionId+']');
                var j = 0, rl;
                for(rl = radios.length; j < rl; j++) {
                    if(radios[j].checked) {
                        break;
                    }
                }
                if(j != rl) {
                    var id = radios[j].id.replace(/^default/, blockId);
                    radios = document.getElementsByName(elements[i].name);
                    for(j = 0, rl = radios.length; j < rl; j++) {
                        radios[j].checked = false;
                        radios[j].setAttribute('disabled', true);
                    }
                    document.getElementById(id).checked = true;
                }
                break;
            }
        }
    }
    return false;
}

var defaultContent = document.getElementById('default_content');
var elements = defaultContent.getElementsByTagName('select');
for(var i = 0, l = elements.length; i < l; i++) {
    elements[i].onchange = function() {
        var element = null;
        for(var k = 0; k < blocks.length; k++) {
            if(blocks[k] == 'default') continue;
            element = document.getElementById(this.id.replace(/^default/, blocks[k]));
            if(element && element.disabled) {
                for(var j = 0, ol = element.options.length; j < ol; j++) {
                    if(element.options[j].value == this.value) {
                        element.value = this.value;
                        element.selectedIndex = j;
                        break;
                    }
                }
            }
        }
    }
}
elements = defaultContent.getElementsByTagName('input');
for(var i = 0, l = elements.length; i < l; i++) {
    if(elements[i].getAttribute('type') == 'text') {
        elements[i].onchange = function() {
            var element = null;
            for(var k = 0; k < blocks.length; k++) {
                if(blocks[k] == 'default') continue;
                element = document.getElementById(this.id.replace(/^default/, blocks[k]));
                if(element && element.disabled) {
                    element.value = this.value
                }
            }
        }
    } else if(elements[i].getAttribute('type') == 'radio') {
        elements[i].onchange = function() {
            var element = null, radios = null, rl = null;
            for(var k = 0; k < blocks.length; k++) {
                if(blocks[k] == 'default') continue;
                radios = document.getElementsByName(this.name.replace(/^module\[default_block\]/, 'module['+blocks[k]+'_block]'));
                rl = radios.length;
                if(rl && radios[0].disabled) {
                    for(var j = 0; j < rl; j++) {
                        radios[j].checked = false;
                    }
                    element = document.getElementById(this.id.replace(/^default/, blocks[k]));
                    if(element) {
                        element.checked = true;
                    }
                }
            }
        }
    }
}


//]]>
</script>
</form>
<div class="clear pspace"></div>
</div>