<?php

if(!defined('MAGICTOOLBOX_FUNCTION_LOADED')) {

    define('MAGICTOOLBOX_FUNCTION_LOADED', true);

    function getResizedImage($toolID, $original, $resized = '', $pid = null) {
        if(!empty($original)) {
            $lcToolID = strtolower($toolID);
            if(!isset($GLOBALS['magictoolbox'][$lcToolID.'_imagehelper'])) {
                require_once(CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.$toolID.CC_DS.'core'.CC_DS.'magictoolbox.imagehelper.class.php');
                $funcName = "load{$toolID}CoreClass";
                $tool = $funcName();
                $GLOBALS['magictoolbox'][$lcToolID.'_imagehelper'] = new MagicToolboxImageHelperClass(
                    CC_ROOT_DIR,
                    '/images/magictoolbox_cache',
                    $tool['main']->params,
                    null,
                    CC_STORE_URL//$GLOBALS['storeURL']
                );
            }
            $imageHelper = &$GLOBALS['magictoolbox'][$lcToolID.'_imagehelper'];

            if(empty($resized)) $resized = 'original';
            $resized = $imageHelper->create($original, $resized, $pid);
        }
        return $resized;
    }

    function getRandomProductsData($count = '1') {
        $products = array();
        if(($products = $GLOBALS['db']->select('CubeCart_inventory', array('product_id', 'name', 'description'), array('status' => '1'), 'RAND()', $count)) !== false) {
            foreach($products as $i => $product) {
                $GLOBALS['language']->translateProduct($products[$i]);
                $products[$i]['image'] = $GLOBALS['gui']->getProductImage($products[$i]['product_id']);
                $products[$i]['url'] = $GLOBALS['seo']->buildURL('prod', $products[$i]['product_id']);
            }
        }
        return $products;
    }

}

    function loadMagicThumbCoreClass() {
        if(!isset($GLOBALS['magictoolbox']['magicthumb'])) {
            require_once(CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.'MagicThumb'.CC_DS.'core'.CC_DS.'magicthumb.module.core.class.php');
            $GLOBALS['magictoolbox']['magicthumb'] = new MagicThumbModuleCoreClass();
            $coreClass = &$GLOBALS['magictoolbox']['magicthumb'];

            //NOTE: load params
            $config = $GLOBALS['config']->get('MagicThumb');

            //NOTE: fix for CubeCart 6.x (because it is not empty)
            if(isset($config['status'])) unset($config['status']);
            if(isset($config['countries'])) unset($config['countries']);

            if(empty($config)) {
                /* load defaults */
                require CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.'MagicThumb'.CC_DS.'defaults.php';
                foreach($defaults as $block => $ids) {
                    foreach($ids as $id => $value) {
                        $coreClass->params->setValue($id, $value, $block);
                    }
                }
            } else {
                foreach($config as $paramId => $value) {
                    $parts = explode('-', $paramId, 2);
                    if(count($parts) != 2) continue;
                    $coreClass->params->setValue($parts[1], $value, $parts[0]);
                }
            }

            $blocks = array(
                'product',
                'category',
                'latest',
                'featured',
                'popular',
            );

            $languageStrings = $GLOBALS['language']->{'MagicThumb'};
            if($languageStrings) {
                foreach($blocks as $block) {
                    if(isset($languageStrings[$block.'-message-under-images']) && !empty($languageStrings[$block.'-message-under-images'])) {
                        $coreClass->params->setValue('message', $languageStrings[$block.'-message-under-images'], $block);
                    } else if(isset($languageStrings['default-message-under-images']) && !empty($languageStrings['default-message-under-images'])) {
                        $coreClass->params->setValue('message', $languageStrings['default-message-under-images'], $block);
                    }
                    if(isset($languageStrings[$block.'-loading-message']) && !empty($languageStrings[$block.'-loading-message'])) {
                        $coreClass->params->setValue('loading-msg', $languageStrings[$block.'-loading-message'], $block);
                    } else if(isset($languageStrings['default-loading-message']) && !empty($languageStrings['default-loading-message'])) {
                        $coreClass->params->setValue('loading-msg', $languageStrings['default-loading-message'], $block);
                    }
                }
            }
            $GLOBALS['magictoolbox']['magicthumb_magicscroll'] = null;
            if($coreClass->params->checkValue('magicscroll', 'yes', 'product')) {
                require_once(CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.'MagicThumb'.CC_DS.'core'.CC_DS.'magicscroll.module.core.class.php');
                $GLOBALS['magictoolbox']['magicthumb_magicscroll'] = new MagicScrollModuleCoreClass(false);
                $scrollCoreClass = &$GLOBALS['magictoolbox']['magicthumb_magicscroll'];
                //NOTE: load params in a separate profile, in order not to overwrite the options of MagicScroll module
                $scrollCoreClass->params->appendParams($coreClass->params->getParams('product'), 'product-magicscroll-options');
                $scrollCoreClass->params->setValue('orientation', ($coreClass->params->checkValue('template', array('left', 'right'), 'product') ? 'vertical' : 'horizontal'), 'product-magicscroll-options');
                //NOTE: if Magic Scroll module installed we need to load settings before displaying custom options
                if(function_exists('loadMagicThumbCoreClass')) {
                    loadMagicThumbCoreClass();
                }
            }
        }
        return array('main' => &$GLOBALS['magictoolbox']['magicthumb'], 'magicscroll' => &$GLOBALS['magictoolbox']['magicthumb'.'_magicscroll']);
    }

    function magicthumb_output_filter($output, $template) {

        $tool = loadMagicThumbCoreClass();

        switch($template->template_resource) {
            case 'templates/content.product.php':
                //$tool->params->generalProfile = 'product';
                if(!$tool['main']->params->checkValue('enable-effect', 'No', 'product')) {
                    $tool['main']->params->setProfile('product');

                    $product = $template->getTemplateVars('PRODUCT');
                    $gallery = $template->getTemplateVars('GALLERY');
                    if(empty($gallery)) break;
                    $imagesCount = count($gallery);

                    $resize = $tool['main']->params->checkValue('resize-images', 'Yes');
                    if(!$resize) {
                        $skins = $GLOBALS['gui']->getSkinData();
                        $size = (int)$skins['images']['medium']['maximum'];
                        $tool['main']->params->setValue('thumb-max-width', $size);
                        $tool['main']->params->setValue('thumb-max-height', $size);
                        $size = (int)$skins['images']['gallery']['maximum'];
                        $tool['main']->params->setValue('selector-max-width', $size);
                        $tool['main']->params->setValue('selector-max-height', $size);
                    }

                    $mainImageHTML = '';
                    $selectorsHTML = array();
                    foreach($gallery as $key => $image) {
                        $img = $image['source'];
                        $thumb = $image['medium'];
                        $selector = $image['gallery'];
                        if($resize) {
                            $image_ref = ($image['file_id']) ? $image['file_id'] : $image['img'];
                            $img = $GLOBALS['catalogue']->imagePath($image_ref, 'source', 'root');
                            $img = str_replace(CC_ROOT_DIR, '', $img);
                            $thumb = getResizedImage('MagicThumb', $img, 'thumb', $product['product_id']);
                            $selector = getResizedImage('MagicThumb', $img, 'selector', $product['product_id']);
                            $img = getResizedImage('MagicThumb', $img, 'original', $product['product_id']);
                        }
                        if($key == 0/*$image['main_img'] == 1*/) {
                            $mainImageHTML = $tool['main']->getMainTemplate(array(
                                'id' => 'Product'.$product['product_id'],
                                'img' => $img,
                                'thumb' => $thumb,
                                'title' => $product['name'],
                                'shortDescription' => $product['description_short'],
                                'description' => $product['description'],
                            ));
                        }
                        $selectorsHTML[] = $tool['main']->getSelectorTemplate(array(
                            'id' => 'Product'.$product['product_id'],
                            'group' => 'productPage',
                            'img' => $img,
                            'medium' => $thumb,
                            'thumb' => $selector,
                            'title' => $product['name'],
                        ));

                        //$title = $product['name'];
                        $description = '';
                    }

                    require_once(CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.'MagicThumb'.CC_DS.'core'.CC_DS.'magictoolbox.templatehelper.class.php');
                    MagicToolboxTemplateHelperClass::setPath(CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.'MagicThumb'.CC_DS.'templates');
                    MagicToolboxTemplateHelperClass::setOptions($tool['main']->params);
                    $options = array(
                        'main' => $mainImageHTML,
                        'thumbs' => $selectorsHTML,
                        'magicscrollOptions' => $tool['magicscroll'] ? $tool['magicscroll']->params->serialize(false, '', 'product-magicscroll-options') : '',
                        'pid' => $product['product_id']
                    );
                    $rendered = MagicToolboxTemplateHelperClass::render($options);
                    //$rendered .= '<div style="clear: both"></div>';
                    //$rendered = '<div class="MagicToolboxContainer">'.$rendered.'</div>';

                    //NOTE: cut main image (div.image)
                    $pattern =  '<div\b[^>]*?\bclass\s*+=\s*+"[^"]*?\bimage\b[^"]*+"[^>]*+>'.
                                '('.
                                '(?:'.
                                    '[^<]++'.
                                    '|'.
                                    '<(?!/?div\b|!--)'.
                                    '|'.
                                    '<!--.*?-->'.
                                    '|'.
                                    '<div\b[^>]*+>'.
                                        '(?1)'.
                                    '</div\s*+>'.
                                ')*+'.
                                ')'.
                                '</div\s*+>';
                    $output = preg_replace("#{$pattern}#is", '', $output);

                    //NOTE: cut selectors (div#gallery_select)
                    $pattern =  '<div\b[^>]*?\bid\s*+=\s*+"gallery_select"[^>]*+>'.
                                '('.
                                '(?:'.
                                    '[^<]++'.
                                    '|'.
                                    '<(?!/?div\b|!--)'.
                                    '|'.
                                    '<!--.*?-->'.
                                    '|'.
                                    '<div\b[^>]*+>'.
                                        '(?1)'.
                                    '</div\s*+>'.
                                ')*+'.
                                ')'.
                                '</div\s*+>';
                    $output = preg_replace("#{$pattern}#is", '', $output);

                    //NOTE: replace gallery (div#gallery)
                    $pattern =  '<div\b[^>]*?\bid\s*+=\s*+"gallery"[^>]*+>'.
                                '('.
                                '(?:'.
                                    '[^<]++'.
                                    '|'.
                                    '<(?!/?div\b|!--)'.
                                    '|'.
                                    '<!--.*?-->'.
                                    '|'.
                                    '<div\b[^>]*+>'.
                                        '(?1)'.
                                    '</div\s*+>'.
                                ')*+'.
                                ')'.
                                '</div\s*+>';
                    //$output = preg_replace("#{$pattern}#is", $rendered, $output);
                    $matches = array();
                    if(preg_match("#{$pattern}#is", $output, $matches)) {
                        $output = str_replace($matches[1], $rendered, $output);
                    } else {
                        //NOTE: CubeCart 6.x 'foundation' theme

                        //NOTE: replace main image (div.image)
                        $pattern = '<a\b[^>]*+>[^<]*+<img\b[^<]*?id="img-preview"[^>]*+>[^<]*+</a>';
                        $output = preg_replace("#{$pattern}#is", $rendered, $output);

                        //NOTE: cut gallery (ul.clearing-thumbs)
                        $pattern =  '<ul\b[^>]*?\bclass\s*+=\s*+"[^"]*?\bclearing-thumbs\b[^"]*+"[^>]*+>'.
                                    '('.
                                    '(?:'.
                                        '[^<]++'.
                                        '|'.
                                        '<(?!/?ul\b|!--)'.
                                        '|'.
                                        '<!--.*?-->'.
                                        '|'.
                                        '<ul\b[^>]*+>'.
                                            '(?1)'.
                                        '</ul\s*+>'.
                                    ')*+'.
                                    ')'.
                                    '</ul\s*+>';
                        $output = preg_replace("#{$pattern}#is", '', $output);
                    }

                }
            break;
            case 'templates/content.category.php':
                if(!$tool['main']->params->checkValue('enable-effect', 'No', 'category')) {
                    $tool['main']->params->setProfile('category');

                    $products = $template->getTemplateVars('PRODUCTS');
                    if($products === null) break;

                    $resize = $tool['main']->params->checkValue('resize-images', 'Yes');
                    if(!$resize) {
                        $skins = $GLOBALS['gui']->getSkinData();
                        $size = (int)$skins['images']['thumbnail']['maximum'];
                        $tool['main']->params->setValue('thumb-max-width', $size);
                        $tool['main']->params->setValue('thumb-max-height', $size);
                    }

                    $useLink = $tool['main']->params->checkValue('link-to-product-page', 'Yes');

                    foreach($products as $product) {
                        $img = $product['source'];
                        $thumb = $product['thumbnail'];
                        if($resize) {
                            if(($images = $GLOBALS['db']->select('CubeCart_image_index', false, array('product_id' => $product['product_id']), array('main_img' => 'DESC'), 1)) !== false) {
                                $image_ref  = ($images[0]['file_id']) ? $images[0]['file_id'] : $images[0]['img'];
                                $img = $GLOBALS['catalogue']->imagePath($image_ref, 'source', 'root');
                                $img = str_replace(CC_ROOT_DIR, '', $img);
                                $thumb = getResizedImage('MagicThumb', $img, 'thumb', $product['product_id']);
                                $img = getResizedImage('MagicThumb', $img, 'original', $product['product_id']);
                            }
                        }
                        if(empty($img)) continue;
                        $imageHTML = $tool['main']->getMainTemplate(array(
                            'id' => 'Category'.$product['product_id'],
                            'group' => 'category',
                            'img' => $img,
                            'thumb' => $thumb,
                            'title' => $product['name'],
                            'shortDescription' => $product['description_short'],
                            'description' => $product['description'],
                            'link' => $useLink?$product['url']:''
                        ));
                        $imageHTML = '<div class="MagicToolboxWrapper">'.$imageHTML.'</div>';
                        //NOTE: replace image
                        $output = preg_replace('/<a[^>]*>[^<]*<img[^>]*?src="'.preg_quote($product['thumbnail'], '/').'"[^>]*>[^<]*<\/a>/is', $imageHTML, $output);
                    }
                }
            break;
            case 'templates/content.homepage.php':
                if(!$tool['main']->params->checkValue('enable-effect', 'No', 'latest')) {
                    $tool['main']->params->setProfile('latest');

                    $products = $template->getTemplateVars('LATEST_PRODUCTS');
                    if($products === null) break;

                    $resize = $tool['main']->params->checkValue('resize-images', 'Yes');
                    if(!$resize) {
                        $skins = $GLOBALS['gui']->getSkinData();
                        $size = (int)$skins['images']['small']['maximum'];
                        $tool['main']->params->setValue('thumb-max-width', $size);
                        $tool['main']->params->setValue('thumb-max-height', $size);
                    }

                    $useLink = $tool['main']->params->checkValue('link-to-product-page', 'Yes');

                    foreach($products as $product) {
                        $img = $GLOBALS['gui']->getProductImage($product['product_id'], 'source');
                        $thumb = $product['image'];
                        if($resize) {
                            if(($images = $GLOBALS['db']->select('CubeCart_image_index', false, array('product_id' => $product['product_id']), array('main_img' => 'DESC'), 1)) !== false) {
                                $image_ref  = ($images[0]['file_id']) ? $images[0]['file_id'] : $images[0]['img'];
                                $img = $GLOBALS['catalogue']->imagePath($image_ref, 'source', 'root');
                                $img = str_replace(CC_ROOT_DIR, '', $img);
                                $thumb = getResizedImage('MagicThumb', $img, 'thumb', $product['product_id']);
                                $img = getResizedImage('MagicThumb', $img, 'original', $product['product_id']);
                            }
                        }
                        if(empty($img)) continue;

                        //get Short Description
                        if(!isset($product['description_short'])) {
                            $product['description_short'] = (strlen($product['description']) > $GLOBALS['config']->get('config', 'product_precis')) ? substr(strip_tags($product['description']), 0, $GLOBALS['config']->get('config', 'product_precis')).'&hellip;' : $product['description'];
                        }
                        $imageHTML = $tool['main']->getMainTemplate(array(
                            'id' => 'Latest'.$product['product_id'],
                            'group' => 'latest',
                            'img' => $img,
                            'thumb' => $thumb,
                            'title' => $product['name'],
                            'shortDescription' => $product['description_short'],
                            'description' => $product['description'],
                            'link' => $useLink?$product['url']:''
                        ));
                        //$imageHTML = '<div class="MagicToolboxWrapper">'.$imageHTML.'</div>';

                        //NOTE: replace image (p.image | div.text-center(CubeCart 6.x 'foundation' theme))
                        $pattern = preg_quote($product['image']);
                        $pattern = '(<(p|div)\b[^>]*+>)[^<]*+<a\b[^>]*+>[^<]*+<img\b[^>]*?src="'.$pattern.'"[^>]*+>[^<]*+</a>[^<]*+(</\2>)';
                        $output = preg_replace("#{$pattern}#is", '$1'.$imageHTML.'$3', $output);

                    }
                }
            break;
            case 'templates/box.popular.php':
                $isPopularBlock = true;
                $block = 'popular';
            case 'templates/box.featured.php':
                if(!isset($isPopularBlock)) {
                    $isPopularBlock = false;
                    $block = 'featured';
                }
                if(!$tool['main']->params->checkValue('enable-effect', 'No', $block)) {
                    $tool['main']->params->setProfile($block);

                    if(!isset($GLOBALS['magictoolbox_blocks_html'])) {
                        $GLOBALS['magictoolbox_blocks_html'] = array();
                        $GLOBALS['magictoolbox_blocks_html']['popular'] = array();
                        $GLOBALS['magictoolbox_blocks_html']['featured'] = array();
                    }
                    $GLOBALS['magictoolbox_blocks_html'][$block]['original'] = $output;

                    if($isPopularBlock) {
                        $products = $template->getTemplateVars('POPULAR');
                    } else {
                        $featured_product = $template->getTemplateVars('featured');
                        if($featured_product === null) break;
                        $products = array($featured_product);
                    }

                    $pCount = count($products);
                    if(!$pCount) break;

                    $resize = $tool['main']->params->checkValue('resize-images', 'Yes') || $isPopularBlock;
                    if(!$resize) {
                        $skins = $GLOBALS['gui']->getSkinData();
                        $size = (int)$skins['images']['small']['maximum'];
                        $tool['main']->params->setValue('thumb-max-width', $size);
                        $tool['main']->params->setValue('thumb-max-height', $size);
                    }

                    $useLink = $tool['main']->params->checkValue('link-to-product-page', 'Yes');

                    foreach($products as $product) {

                        $img = $GLOBALS['gui']->getProductImage($product['product_id'], 'source');
                        $thumb = empty($product['image']) ? $GLOBALS['gui']->getProductImage($product['product_id']) : $product['image'];
                        if(empty($thumb)) continue;
                        if(empty($img)) {
                            if($isPopularBlock) $img = $thumb; else continue;
                        }
                        if($resize) {
                            if(($images = $GLOBALS['db']->select('CubeCart_image_index', false, array('product_id' => $product['product_id']), array('main_img' => 'DESC'), 1)) !== false) {
                                $image_ref  = ($images[0]['file_id']) ? $images[0]['file_id'] : $images[0]['img'];
                                $img = $GLOBALS['catalogue']->imagePath($image_ref, 'source', 'root');
                                $img = str_replace(CC_ROOT_DIR, '', $img);
                                $thumb = getResizedImage('MagicThumb', $img, 'thumb', $product['product_id']);
                                $img = getResizedImage('MagicThumb', $img, 'original', $product['product_id']);
                            }
                        }

                        //get Short Description
                        if(!isset($product['description_short'])) {
                            $product['description_short'] = (strlen($product['description']) > $GLOBALS['config']->get('config', 'product_precis')) ? substr(strip_tags($product['description']), 0, $GLOBALS['config']->get('config', 'product_precis')).'&hellip;' : $product['description'];
                        }
                        $imageHTML = $tool['main']->getMainTemplate(array(
                            'id' => ucfirst($block).$product['product_id'],
                            'group' => $block,
                            'img' => $img,
                            'thumb' => $thumb,
                            'title' => $product['name'],
                            'shortDescription' => $product['description_short'],
                            'description' => $product['description'],
                            'link' => $useLink ? $product['url'] : ''//$GLOBALS['seo']->buildURL('prod', $product['product_id'])
                        ));

                        $imageHTML = '<div class="MagicToolboxContainer">'.$imageHTML.'</div>';

                        //NOTE: replace image
                        if($isPopularBlock) {
                            $output = preg_replace('#<a\b[^>]*?\bhref="'.preg_quote($product['url']).'"[^>]*+>.*?</a>#is', $imageHTML.'$0', $output);
                        } else {
                            //NOTE: replace image (p.image)
                            $src = preg_quote($product['image']);
                            $pattern = '<p\b[^>]*+>[^<]*+<a\b[^>]*+>[^<]*+<img\b[^>]*?src="'.$src.'"[^>]*+>[^<]*+</a>[^<]*+</p>';
                            //$output = preg_replace("#{$pattern}#is", $imageHTML, $output);
                            $matches = array();
                            if(preg_match("#{$pattern}#is", $output, $matches)) {
                                $output = str_replace($matches[0], $imageHTML, $output);
                            } else {
                                //NOTE: CubeCart 6.x 'foundation' theme
                                $imageHTML = str_replace('MagicToolboxWrapper', 'MagicToolboxWrapper th', $imageHTML);
                                //NOTE: replace image (a.th)
                                $pattern = '<a\b[^>]*+>[^<]*+<img\b[^>]*?src="'.$src.'"[^>]*+>[^<]*+</a>';
                                $output = preg_replace("#{$pattern}#is", $imageHTML, $output);
                            }
                        }
                    }
                    if($isPopularBlock) {
                        $output = preg_replace('#<(/?)ol#is', '<$1ul', $output);
                    }

                    $GLOBALS['magictoolbox_blocks_html'][$block]['modified'] = $output;

                }
            break;
            case 'templates/main.php':
                $tool['main']->params->resetProfile();

                $page = $template->getTemplateVars('SECTION_NAME');
                if($page === null && isset($_GET['_a']) && !empty($_GET['_a'])) {
                    $page = strtolower($_GET['_a']);
                }
                if($page == 'home') $page = 'latest';
                $useEffectOnPage = !$tool['main']->params->checkValue('enable-effect', 'No', $page);
                $useEffectOnFeaturedBlock = false;
                $useEffectOnPopularBlock = false;
                switch($page) {
                    case 'product':
                    case 'category':
                    case 'latest'://'home'
                    case 'checkout':
                    case 'search':
                    case 'document':
                        $useEffectOnFeaturedBlock = !$tool['main']->params->checkValue('enable-effect', 'No', 'featured');
                        $useEffectOnPopularBlock = !$tool['main']->params->checkValue('enable-effect', 'No', 'popular');
                        break;
                }
                if($useEffectOnPage || $useEffectOnFeaturedBlock || $useEffectOnPopularBlock) {
                    $path = str_replace(CC_DS, '/', CC_STORE_URL).'/modules/plugins/MagicThumb/core';
                    $headers = $tool['main']->getHeadersTemplate($path);
                    if($useEffectOnPage) {
                        if($page == 'product') {
                            if($tool['magicscroll'] && $tool['main']->params->checkValue('magicscroll', 'Yes', 'product')) {
                                $tool['magicscroll']->params->resetProfile();
                                $headers .= "\n".$tool['magicscroll']->getHeadersTemplate($path, $path, false);
                            }
                        } else if($page == 'category') {
                            //$headers .= "\n".
                            //"<style type=\"text/css\">\n".
                            //"div.category_product div.MagicToolboxWrapper {\n".
                            //    "\twidth: ".$tool['main']->params->getValue('thumb-max-width', 'category')."px;\n".
                            //"}\n".
                            //"</style>\n";
                        } else if($page == 'latest') {
                            //$headers .= "\n".
                            //"<style type=\"text/css\">\n".
                            //"div.latest_product div.MagicToolboxWrapper {\n".
                            //    "\theight: ".$tool['main']->params->getValue('thumb-max-height', 'latest')."px;\n".
                            //"}\n".
                            //"</style>\n";
                        }
                    }

                    //NOTE: in CubeCart 6.x some templates are included as subtemplates
                    //      and output filters do not apply to them
                    //      so this is a fix
                    if($useEffectOnFeaturedBlock && !empty($GLOBALS['magictoolbox_blocks_html']['featured']['original'])) {
                        $output = str_replace($GLOBALS['magictoolbox_blocks_html']['featured']['original'], $GLOBALS['magictoolbox_blocks_html']['featured']['modified'], $output);
                    }
                    if($useEffectOnPopularBlock && !empty($GLOBALS['magictoolbox_blocks_html']['popular']['original'])) {
                        $output = str_replace($GLOBALS['magictoolbox_blocks_html']['popular']['original'], $GLOBALS['magictoolbox_blocks_html']['popular']['modified'], $output);
                    }

                    $output = preg_replace('#</head>#is', "\n".$headers."\n".'</head>', $output, 1);
                }
                break;
        }

        return $output;
    }

?>
