<?php
/*
$GLOBALS['language']->loadDefinitions('magicthumb', CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.'MagicThumb'.CC_DS.'language', 'module.definitions.xml');
$params = $GLOBALS['config']->get('MagicZoomPlus');
$GLOBALS['main']->setACPNotify();
$GLOBALS['main']->setACPWarning();
*/

$reset = isset($_POST['magictoolboxSubmitAction']) && ($_POST['magictoolboxSubmitAction'] == 'reset');


$moduleDir = CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.'MagicThumb';
$coreFile = $moduleDir.CC_DS.'core'.CC_DS.'magicthumb.module.core.class.php';
$module = new Module(__FILE__, $_GET['module'], 'admin/index.tpl', false, false);
$template_vars = array();

if(file_exists($coreFile)) {
    require $coreFile;
    $tool = new MagicThumbModuleCoreClass;
    require $moduleDir.CC_DS.'defaults.php';
    $skippedOptions = array(
        'orientation',
    );

    $template_vars['currentTab'] = isset($_POST['magictoolboxCurrentTab']) ? $_POST['magictoolboxCurrentTab'] : '';
    $template_vars['blocks'] = get_magicthumb_blocks();
    $template_vars['grouped_options'] = get_magicthumb_params_map();
    $template_vars['hints'] = array();
    $template_vars['hidden_options'] = array();
    $template_vars['not_required_options'] = array(
        'scroll-extra-styles',
        'loading-msg',
        'message',
        'watermark',
    );

    foreach(get_magicthumb_blocks() as $blockId => $blockTitle) {
        foreach($tool->params->getParams() as $id => $param) {
            if(in_array($id, $skippedOptions)) continue;
            $value = $reset ? false : $module->__get($blockId.'-'.$id);
            if($value === false) {
                $value = isset($defaults[$blockId][$id]) ? $defaults[$blockId][$id] : $tool->params->getValue($id);
            }
            $tool->params->setValue($id, $value, $blockId);
            $hint = $tool->params->getDescription($id);
            if(($tool->params->getType($id) != "array") && $tool->params->valuesExists($id)) {
                if($hint) $hint .= "<br />";
                $hint .= "Allowed values: ".implode(", ", $tool->params->getValues($id));
            }
            if($hint) {
                $template_vars['hints'][$id] = $hint;
            }
        }
    }

//     if($tool->params->checkValue('resize-images', 'No')) {
//         $template_vars['hidden_options'] = array(
//             'thumb-max-width',
//             'thumb-max-height',
//             'selector-max-width',
//             'selector-max-height',
//             'square-images',
//             'imagemagick',
//             'image-quality',
//             'use-original-file-names'
//         );
//         foreach($template_vars['grouped_options']['Watermark'] as $id) {
//             $template_vars['hidden_options'][] = $id;
//         }
//     }

    $template_vars['params'] = &$tool->params;


    $template_vars['cubecart6x'] = false;
    if(defined('CC_VERSION') && version_compare(CC_VERSION, '6.0.0', '>=')) {
        $template_vars['cubecart6x'] = true;
    }

    $template_vars['errors'] = false;
} else {
    $GLOBALS['main']->setACPWarning('File: '.$coreFile.' does not exists! Please, make sure that the module is installed correctly.');
    $template_vars['errors'] = true;
}

$module->assign_to_template($template_vars, null);
$module->fetch();
$page_content = $module->display();

function get_magicthumb_blocks() {
    return array(
		'default' => 'General',
		'product' => 'Product page',
		'category' => 'Category page',
		'latest' => 'Latest block',
		'featured' => 'Featured block',
		'popular' => 'Popular block',
	);
}

function get_magicthumb_params_map() {
    return array(
		'default' => array(
			'Positioning and Geometry' => array(
				'square-images',
			),
			'Miscellaneous' => array(
				'resize-images',
				'imagemagick',
				'image-quality',
			),
			'Watermark' => array(
				'watermark',
				'watermark-max-width',
				'watermark-max-height',
				'watermark-opacity',
				'watermark-position',
				'watermark-offset-x',
				'watermark-offset-y',
			),
		),
		'product' => array(
			'General' => array(
				'enable-effect',
				'template',
				'magicscroll',
			),
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
			),
			'Expanded view' => array(
				'expandEffect',
				'expandSpeed',
				'expandImageSize',
				'expandTrigger',
				'expandAlign',
				'expandEasing',
				'gallerySpeed',
			),
			'Multiple images' => array(
				'selector-max-width',
				'selector-max-height',
				'selectorTrigger',
				'selectorEffect',
			),
			'Title and Caption' => array(
				'show-caption',
				'captionPosition',
			),
			'Miscellaneous' => array(
				'keyboard',
				'cssClass',
				'rightClick',
				'lazyLoad',
				'autostart',
			),
			'Buttons' => array(
				'buttons',
				'textBtnClose',
				'textBtnNext',
				'textBtnPrev',
			),
			'Hint' => array(
				'hint',
				'textClickHint',
				'textHoverHint',
			),
			'Mobile' => array(
				'slideMobileEffect',
				'textClickHintForMobile',
			),
			'Scroll' => array(
				'width',
				'height',
				'mode',
				'items',
				'speed',
				'autoplay',
				'loop',
				'step',
				'arrows',
				'pagination',
				'easing',
				'scrollOnWheel',
				'lazy-load',
				'scroll-extra-styles',
				'show-image-title',
			),
		),
		'category' => array(
			'General' => array(
				'enable-effect',
			),
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
			),
			'Expanded view' => array(
				'expandEffect',
				'expandSpeed',
				'expandImageSize',
				'expandTrigger',
				'expandAlign',
				'expandEasing',
				'gallerySpeed',
			),
			'Title and Caption' => array(
				'show-caption',
				'captionPosition',
			),
			'Miscellaneous' => array(
				'link-to-product-page',
				'keyboard',
				'cssClass',
				'rightClick',
				'lazyLoad',
				'autostart',
			),
			'Buttons' => array(
				'buttons',
				'textBtnClose',
				'textBtnNext',
				'textBtnPrev',
			),
			'Hint' => array(
				'hint',
				'textClickHint',
				'textHoverHint',
			),
			'Mobile' => array(
				'slideMobileEffect',
				'textClickHintForMobile',
			),
		),
		'latest' => array(
			'General' => array(
				'enable-effect',
			),
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
			),
			'Expanded view' => array(
				'expandEffect',
				'expandSpeed',
				'expandImageSize',
				'expandTrigger',
				'expandAlign',
				'expandEasing',
				'gallerySpeed',
			),
			'Title and Caption' => array(
				'show-caption',
				'captionPosition',
			),
			'Miscellaneous' => array(
				'link-to-product-page',
				'keyboard',
				'cssClass',
				'rightClick',
				'lazyLoad',
				'autostart',
			),
			'Buttons' => array(
				'buttons',
				'textBtnClose',
				'textBtnNext',
				'textBtnPrev',
			),
			'Hint' => array(
				'hint',
				'textClickHint',
				'textHoverHint',
			),
			'Mobile' => array(
				'slideMobileEffect',
				'textClickHintForMobile',
			),
		),
		'featured' => array(
			'General' => array(
				'enable-effect',
			),
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
			),
			'Expanded view' => array(
				'expandEffect',
				'expandSpeed',
				'expandImageSize',
				'expandTrigger',
				'expandAlign',
				'expandEasing',
				'gallerySpeed',
			),
			'Title and Caption' => array(
				'show-caption',
				'captionPosition',
			),
			'Miscellaneous' => array(
				'link-to-product-page',
				'keyboard',
				'cssClass',
				'rightClick',
				'lazyLoad',
				'autostart',
			),
			'Buttons' => array(
				'buttons',
				'textBtnClose',
				'textBtnNext',
				'textBtnPrev',
			),
			'Hint' => array(
				'hint',
				'textClickHint',
				'textHoverHint',
			),
			'Mobile' => array(
				'slideMobileEffect',
				'textClickHintForMobile',
			),
		),
		'popular' => array(
			'General' => array(
				'enable-effect',
			),
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
			),
			'Expanded view' => array(
				'expandEffect',
				'expandSpeed',
				'expandImageSize',
				'expandTrigger',
				'expandAlign',
				'expandEasing',
				'gallerySpeed',
			),
			'Title and Caption' => array(
				'show-caption',
				'captionPosition',
			),
			'Miscellaneous' => array(
				'link-to-product-page',
				'keyboard',
				'cssClass',
				'rightClick',
				'lazyLoad',
				'autostart',
			),
			'Buttons' => array(
				'buttons',
				'textBtnClose',
				'textBtnNext',
				'textBtnPrev',
			),
			'Hint' => array(
				'hint',
				'textClickHint',
				'textHoverHint',
			),
			'Mobile' => array(
				'slideMobileEffect',
				'textClickHintForMobile',
			),
		),
	);
}

?>
