<?php
    /**
     *  CubeCart 5 module installer class
     */

    require_once(dirname(__FILE__) . '/magictoolbox.installer.core.class.php');

    class MagicToolboxCubecart5ModuleInstallerClass extends MagicToolboxCoreInstallerClass {

        function __construct() {
            $this->dir = dirname(dirname(__FILE__));
            $this->modDir = dirname(__FILE__) . '/modules';

            //for fix url's in css files
            $script_name = (isset($_SERVER['PHP_SELF']) && !empty($_SERVER['PHP_SELF'])) ? $_SERVER['PHP_SELF'] : $_SERVER['REQUEST_URI'];
            $script_path = trim(dirname(dirname($script_name)));
            $script_path = preg_replace('#[\\\\/]{2,}#', '/', $script_path);
            if(substr($script_path, -1) != '/' && substr($script_path, -1) != '\\') {
                $script_path .= '/';
            }
            $this->resDir = $script_path . 'modules/plugins/MagicSlideshow/core';

        }

        function isModuleInstalled() {
            $this->setStatus('check', 'module');
            if(file_exists($this->dir.'/modules/plugins/MagicSlideshow')) {
                return true;
            }
            return false;
        }

        function checkPlace() {
            return true;
            if(!file_exists($this->dir . '/index_no_enc.php') && !file_exists($this->dir . '/index_enc_zend.php') && !file_exists($this->dir . '/index_enc_ion.php')) {
                $this->setError('Wrong location: please upload the files from the ZIP archive to the Cubecart store directory.');
                return false;
            }
            return true;
        }

        function checkPerm() {
            $this->setStatus('check', 'perm');
            $files = array(
                // directory
                '/modules/plugins',
            );
            list($result, $wrang) = $this->checkFilesPerm($files);
            if(!$result) {
                $this->setError('This installer need to modify some Cubecart store files.');
                $this->setError('Please check write access for following files and/or dirrectories of your Cubecart store:');
                $this->setError($wrang, '&nbsp;&nbsp;&nbsp;-&nbsp;');
                return false;
            }
            return true;
        }

        function installFiles() {
            $this->setStatus('install', 'files');
            //copy modules folder into Cubecart store dirrectory
            $this->copyDir($this->modDir, $this->dir . '/modules');
            return true;
        }

        function restoreStep_installFiles() {
            $this->removeDir($this->dir . '/modules/plugins/MagicSlideshow');
            return true;
        }

        function upgrade($files) {
            $path = $this->dir . '/modules/plugins/MagicSlideshow/core/';
            foreach($files as $name => $file) {
                if(file_exists($path . $name)) {
                    unlink($path . $name);
                }
                file_put_contents($path . $name, $file);
                chmod($path . $name, 0755);
            }
            return true;
        }

        function getPlatformVersion() {
            if(file_exists($this->dir.'/ini.inc.php')) {
                $contents  = file_get_contents($this->dir.'/ini.inc.php');
                $match = array();
                if(preg_match('/define\s*\(\s*\'CC_VERSION\'\s*,\s*\'([^\']*)\'\s*\)/i', $contents, $match)) {
                    return $match[1];
                }
            }
            return '';
        }

    }
