<?php

if(!defined('MAGICTOOLBOX_FUNCTION_LOADED')) {

    define('MAGICTOOLBOX_FUNCTION_LOADED', true);

    function getResizedImage($toolID, $original, $resized = '', $pid = null) {
        if(!empty($original)) {
            $lcToolID = strtolower($toolID);
            if(!isset($GLOBALS['magictoolbox'][$lcToolID.'_imagehelper'])) {
                require_once(CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.$toolID.CC_DS.'core'.CC_DS.'magictoolbox.imagehelper.class.php');
                $funcName = "load{$toolID}CoreClass";
                $tool = $funcName();
                $GLOBALS['magictoolbox'][$lcToolID.'_imagehelper'] = new MagicToolboxImageHelperClass(
                    CC_ROOT_DIR,
                    '/images/magictoolbox_cache',
                    $tool['main']->params,
                    null,
                    CC_STORE_URL//$GLOBALS['storeURL']
                );
            }
            $imageHelper = &$GLOBALS['magictoolbox'][$lcToolID.'_imagehelper'];

            if(empty($resized)) $resized = 'original';
            $resized = $imageHelper->create($original, $resized, $pid);
        }
        return $resized;
    }

    function getRandomProductsData($count = '1') {
        $products = array();
        if(($products = $GLOBALS['db']->select('CubeCart_inventory', array('product_id', 'name', 'description'), array('status' => '1'), 'RAND()', $count)) !== false) {
            foreach($products as $i => $product) {
                $GLOBALS['language']->translateProduct($products[$i]);
                $products[$i]['image'] = $GLOBALS['gui']->getProductImage($products[$i]['product_id']);
                $products[$i]['url'] = $GLOBALS['seo']->buildURL('prod', $products[$i]['product_id']);
            }
        }
        return $products;
    }

}

    function loadMagicScrollCoreClass() {
        if(!isset($GLOBALS['magictoolbox']['magicscroll'])) {
            require_once(CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.'MagicScroll'.CC_DS.'core'.CC_DS.'magicscroll.module.core.class.php');
            $GLOBALS['magictoolbox']['magicscroll'] = new MagicScrollModuleCoreClass();
            $coreClass = &$GLOBALS['magictoolbox']['magicscroll'];

            //NOTE: load params
            $config = $GLOBALS['config']->get('MagicScroll');

            //NOTE: fix for CubeCart 6.x (because it is not empty)
            if(isset($config['status'])) unset($config['status']);
            if(isset($config['countries'])) unset($config['countries']);

            if(empty($config)) {
                /* load defaults */
                require CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.'MagicScroll'.CC_DS.'defaults.php';
                foreach($defaults as $block => $ids) {
                    foreach($ids as $id => $value) {
                        $coreClass->params->setValue($id, $value, $block);
                    }
                }
            } else {
                foreach($config as $paramId => $value) {
                    $parts = explode('-', $paramId, 2);
                    if(count($parts) != 2) continue;
                    $coreClass->params->setValue($parts[1], $value, $parts[0]);
                }
            }

            $blocks = array(
                'product',
                'featured',
                'popular',
                'homeslideshow',
            );

            $languageStrings = $GLOBALS['language']->{'MagicScroll'};
            if($languageStrings) {
                foreach($blocks as $block) {
                    if(isset($languageStrings[$block.'-message-under-images']) && !empty($languageStrings[$block.'-message-under-images'])) {
                        $coreClass->params->setValue('message', $languageStrings[$block.'-message-under-images'], $block);
                    } else if(isset($languageStrings['default-message-under-images']) && !empty($languageStrings['default-message-under-images'])) {
                        $coreClass->params->setValue('message', $languageStrings['default-message-under-images'], $block);
                    }
                }
            }
        }
        return array('main' => &$GLOBALS['magictoolbox']['magicscroll'], 'magicscroll' => null);
    }

    function magicscroll_output_filter($output, $template) {

        $tool = loadMagicScrollCoreClass();

        switch($template->template_resource) {
            case 'templates/content.product.php':
                //$tool->params->generalProfile = 'product';
                if(!$tool['main']->params->checkValue('enable-effect', 'No', 'product')) {
                    $tool['main']->params->setProfile('product');

                    $product = $template->getTemplateVars('PRODUCT');
                    $gallery = $template->getTemplateVars('GALLERY');
                    if(empty($gallery)) break;
                    $imagesCount = count($gallery);
                    //if($imagesCount < $tool['main']->params->getValue('items')) {
                    //    $tool['main']->params->setValue('items', $imagesCount);
                    //}

                    $resize = $tool['main']->params->checkValue('resize-images', 'Yes');
                    if(!$resize) {
                        $skins = $GLOBALS['gui']->getSkinData();
                        $size = (int)$skins['images']['medium']['maximum'];
                        $tool['main']->params->setValue('thumb-max-width', $size);
                        $tool['main']->params->setValue('thumb-max-height', $size);
                    }

                    $magicscrollData = array();
                    foreach($gallery as $key => $image) {
                        $thumb = $image['medium'];
                        if($resize) {
                            $image_ref = ($image['file_id']) ? $image['file_id'] : $image['img'];
                            $img = $GLOBALS['catalogue']->imagePath($image_ref, 'source', 'root');
                            $img = str_replace(CC_ROOT_DIR, '', $img);
                            $thumb = getResizedImage('MagicScroll', $img, 'thumb', $product['product_id']);
                        }

                        //$title = $product['name'];
                        $description = '';
                        $magicscrollData[] = array(
                            'title' => $product['name'],
                            'img' => $thumb,
                            'alt' => $product['name'],
                            'description' => $description
                        );
                    }

                    $rendered = $tool['main']->getMainTemplate($magicscrollData, array("id" => "productMagicScroll"));
                    $rendered = '<div class="MagicToolboxContainer">'.$rendered.'</div>';

                    //NOTE: cut main image (div.image)
                    $pattern =  '<div\b[^>]*?\bclass\s*+=\s*+"[^"]*?\bimage\b[^"]*+"[^>]*+>'.
                                '('.
                                '(?:'.
                                    '[^<]++'.
                                    '|'.
                                    '<(?!/?div\b|!--)'.
                                    '|'.
                                    '<!--.*?-->'.
                                    '|'.
                                    '<div\b[^>]*+>'.
                                        '(?1)'.
                                    '</div\s*+>'.
                                ')*+'.
                                ')'.
                                '</div\s*+>';
                    $output = preg_replace("#{$pattern}#is", '', $output);

                    //NOTE: cut selectors (div#gallery_select)
                    $pattern =  '<div\b[^>]*?\bid\s*+=\s*+"gallery_select"[^>]*+>'.
                                '('.
                                '(?:'.
                                    '[^<]++'.
                                    '|'.
                                    '<(?!/?div\b|!--)'.
                                    '|'.
                                    '<!--.*?-->'.
                                    '|'.
                                    '<div\b[^>]*+>'.
                                        '(?1)'.
                                    '</div\s*+>'.
                                ')*+'.
                                ')'.
                                '</div\s*+>';
                    $output = preg_replace("#{$pattern}#is", '', $output);

                    //NOTE: replace gallery (div#gallery)
                    $pattern =  '<div\b[^>]*?\bid\s*+=\s*+"gallery"[^>]*+>'.
                                '('.
                                '(?:'.
                                    '[^<]++'.
                                    '|'.
                                    '<(?!/?div\b|!--)'.
                                    '|'.
                                    '<!--.*?-->'.
                                    '|'.
                                    '<div\b[^>]*+>'.
                                        '(?1)'.
                                    '</div\s*+>'.
                                ')*+'.
                                ')'.
                                '</div\s*+>';
                    //$output = preg_replace("#{$pattern}#is", $rendered, $output);
                    $matches = array();
                    if(preg_match("#{$pattern}#is", $output, $matches)) {
                        $output = str_replace($matches[1], $rendered, $output);
                    } else {
                        //NOTE: CubeCart 6.x 'foundation' theme

                        //NOTE: replace main image (div.image)
                        $pattern = '<a\b[^>]*+>[^<]*+<img\b[^<]*?id="img-preview"[^>]*+>[^<]*+</a>';
                        $output = preg_replace("#{$pattern}#is", $rendered, $output);

                        //NOTE: cut gallery (ul.clearing-thumbs)
                        $pattern =  '<ul\b[^>]*?\bclass\s*+=\s*+"[^"]*?\bclearing-thumbs\b[^"]*+"[^>]*+>'.
                                    '('.
                                    '(?:'.
                                        '[^<]++'.
                                        '|'.
                                        '<(?!/?ul\b|!--)'.
                                        '|'.
                                        '<!--.*?-->'.
                                        '|'.
                                        '<ul\b[^>]*+>'.
                                            '(?1)'.
                                        '</ul\s*+>'.
                                    ')*+'.
                                    ')'.
                                    '</ul\s*+>';
                        $output = preg_replace("#{$pattern}#is", '', $output);
                    }

                }
            break;
            case 'templates/content.homepage.php':
                if(!$tool['main']->params->checkValue('enable-effect', 'No', 'homeslideshow')) {
                    $tool['main']->params->setProfile('homeslideshow');
                    $imagesData = $tool['main']->params->getValue('images-data');
                    if(empty($imagesData)) break;
                    $imagesCount = count($imagesData);
                    //if($imagesCount < $tool['main']->params->getValue('items')) {
                    //    $tool['main']->params->setValue('items', $imagesCount);
                    //}
                    $homeSlideshowData = array();
                    $imageBasePath = CC_DS.'images'.CC_DS.'magicscroll'.CC_DS;
                    foreach($imagesData as $key => $imageData) {
                        if($imageData['exclude']) continue;
                        $homeSlideshowData[] = array(
                            'img' => getResizedImage('MagicScroll', $imageBasePath.$imageData['name'], 'thumb', 'homeslideshow'),
                            'title' => $imageData['title'],
                            'alt' => $imageData['title'],
                            'description' => '<br/ >'.$imageData['description'],
                            'link' => empty($imageData['link']) ? false : $imageData['link']
                        );
                    }
                    if(empty($homeSlideshowData)) break;
                    $html = $tool['main']->getMainTemplate($homeSlideshowData, array('id' => 'homeMagicScroll'));
                    //$output = '<div class="MagicSlideshowWrapper">'.$html.'</div>'.$output;
                    $output = '<div class="MagicToolboxContainer">'.$html.'</div>'.$output;
                }
            break;
            case 'templates/box.popular.php':
                $isPopularBlock = true;
                $block = 'popular';
            case 'templates/box.featured.php':
                if(!isset($isPopularBlock)) {
                    $isPopularBlock = false;
                    $block = 'featured';
                }
                if(!$tool['main']->params->checkValue('enable-effect', 'No', $block)) {
                    $tool['main']->params->setProfile($block);

                    if(!isset($GLOBALS['magictoolbox_blocks_html'])) {
                        $GLOBALS['magictoolbox_blocks_html'] = array();
                        $GLOBALS['magictoolbox_blocks_html']['popular'] = array();
                        $GLOBALS['magictoolbox_blocks_html']['featured'] = array();
                    }
                    $GLOBALS['magictoolbox_blocks_html'][$block]['original'] = $output;

                    if($isPopularBlock) {
                        $products = $template->getTemplateVars('POPULAR');
                    } else {
                        $featured_product = $template->getTemplateVars('featured');
                        if($featured_product === null) break;
                        $products = getRandomProductsData($tool['main']->params->getValue('count-of-products'));
                    }

                    $pCount = count($products);
                    if(!$pCount) break;
                    //if($pCount < $tool['main']->params->getValue('items')) {
                    //    $tool['main']->params->setValue('items', $pCount);
                    //}

                    $resize = $tool['main']->params->checkValue('resize-images', 'Yes') || $isPopularBlock;
                    if(!$resize) {
                        $skins = $GLOBALS['gui']->getSkinData();
                        $size = (int)$skins['images']['small']['maximum'];
                        $tool['main']->params->setValue('thumb-max-width', $size);
                        $tool['main']->params->setValue('thumb-max-height', $size);
                    }

                    $useLink = $tool['main']->params->checkValue('link-to-product-page', 'Yes');

                    $magicscrollData = array();
                    foreach($products as $product) {

                        $thumb = empty($product['image']) ? $GLOBALS['gui']->getProductImage($product['product_id']) : $product['image'];
                        if(empty($thumb)) continue;
                        if($resize) {
                            if(($images = $GLOBALS['db']->select('CubeCart_image_index', false, array('product_id' => $product['product_id']), array('main_img' => 'DESC'), 1)) !== false) {
                                $image_ref  = ($images[0]['file_id']) ? $images[0]['file_id'] : $images[0]['img'];
                                $img = $GLOBALS['catalogue']->imagePath($image_ref, 'source', 'root');
                                $img = str_replace(CC_ROOT_DIR, '', $img);
                                $thumb = getResizedImage('MagicScroll', $img, 'thumb', $product['product_id']);
                            }
                        }

                        $magicscrollData[] = array(
                            'title' => $product['name'],
                            'img' => $thumb,
                            'alt' => $product['name'],
                            'description' => '',
                            'link' => $useLink ? $product['url'] : ''
                        );
                    }
                    $rendered = $tool['main']->getMainTemplate($magicscrollData, array('id' => $block.'MagicScroll'));
                    $rendered = '<div class="MagicToolboxContainer">'.$rendered.'</div>';
                    //replace image
                    if($isPopularBlock) {
                        $output = preg_replace('#<ol[^>]*+>.*?</ol>#is', $rendered, $output);
                    } else {
                        //NOTICE: maybe better to replace div.featured_product
                        $src = preg_quote($featured_product['image']);
                        $pattern = '<p\b[^>]*+>[^<]*+<a\b[^>]*+>[^<]*+<img\b[^>]*?src="'.$src.'"[^>]*+>[^<]*+</a>[^<]*+</p>';
                        //NOTE: p.title
                        $pattern .= '[^<]*+<p\b[^>]*+>.*?</p>';
                        //$output = preg_replace("#{$pattern}#is", $rendered, $output);
                        $matches = array();
                        if(preg_match("#{$pattern}#is", $output, $matches)) {
                            $output = str_replace($matches[0], $rendered, $output);
                        } else {
                            //NOTE: CubeCart 6.x 'foundation' theme
                            $pattern =  '<div\b[^>]*?\bid\s*+=\s*+"box-featured"[^>]*+>[^<]*+'.
                                        '<h3>.*?</h3>'.
                                        '('.
                                        '(?:'.
                                            '[^<]++'.
                                            '|'.
                                            '<(?!/?div\b|!--)'.
                                            '|'.
                                            '<!--.*?-->'.
                                            '|'.
                                            '<div\b[^>]*+>'.
                                                '(?1)'.
                                            '</div\s*+>'.
                                        ')*+'.
                                        ')'.
                                        '</div\s*+>';
                            $matches = array();
                            if(preg_match("#{$pattern}#is", $output, $matches)) {
                                $output = str_replace($matches[1], $rendered, $output);
                            }
                        }
                    }

                    $GLOBALS['magictoolbox_blocks_html'][$block]['modified'] = $output;

                }
            break;
            case 'templates/main.php':
                $tool['main']->params->resetProfile();

                $page = $template->getTemplateVars('SECTION_NAME');
                if($page === null && isset($_GET['_a']) && !empty($_GET['_a'])) {
                    $page = strtolower($_GET['_a']);
                }
                if($page == 'home') $page = 'homeslideshow';
                $useEffectOnPage = !$tool['main']->params->checkValue('enable-effect', 'No', $page);
                $useEffectOnFeaturedBlock = false;
                $useEffectOnPopularBlock = false;
                switch($page) {
                    case 'product':
                    case 'category':
                    case 'homeslideshow'://'home'
                    case 'checkout':
                    case 'search':
                    case 'document':
                        $useEffectOnFeaturedBlock = !$tool['main']->params->checkValue('enable-effect', 'No', 'featured');
                        $useEffectOnPopularBlock = !$tool['main']->params->checkValue('enable-effect', 'No', 'popular');
                        break;
                }
                if($useEffectOnPage || $useEffectOnFeaturedBlock || $useEffectOnPopularBlock) {
                    $path = str_replace(CC_DS, '/', CC_STORE_URL).'/modules/plugins/MagicScroll/core';
                    $headers = $tool['main']->getHeadersTemplate($path);
                    if($useEffectOnPage) {
                        if($page == 'product') {
                            if($tool['magicscroll'] && $tool['main']->params->checkValue('magicscroll', 'Yes', 'product')) {
                                $tool['magicscroll']->params->resetProfile();
                                $headers .= "\n".$tool['magicscroll']->getHeadersTemplate($path, $path, false);
                            }
                            //$headers .= "\n".
                            //"<style type=\"text/css\">\n".
                            //"div.MagicToolboxContainer {\n".
                            //    "\twidth: ".$tool['main']->params->getValue('thumb-max-width', 'product')."px;\n".
                            //"}\n".
                            //"</style>\n";
                        } else if($page == 'category') {
                        } else if($page == 'latest') {
                        }
                    }

                    //NOTE: in CubeCart 6.x some templates are included as subtemplates
                    //      and output filters do not apply to them
                    //      so this is a fix
                    if($useEffectOnFeaturedBlock && !empty($GLOBALS['magictoolbox_blocks_html']['featured']['original'])) {
                        $output = str_replace($GLOBALS['magictoolbox_blocks_html']['featured']['original'], $GLOBALS['magictoolbox_blocks_html']['featured']['modified'], $output);
                    }
                    if($useEffectOnPopularBlock && !empty($GLOBALS['magictoolbox_blocks_html']['popular']['original'])) {
                        $output = str_replace($GLOBALS['magictoolbox_blocks_html']['popular']['original'], $GLOBALS['magictoolbox_blocks_html']['popular']['modified'], $output);
                    }

                    $output = preg_replace('#</head>#is', "\n".$headers."\n".'</head>', $output, 1);
                }
                break;
        }

        return $output;
    }

?>
