<?php
/*
$GLOBALS['language']->loadDefinitions('magicscroll', CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.'MagicScroll'.CC_DS.'language', 'module.definitions.xml');
$params = $GLOBALS['config']->get('MagicZoomPlus');
$GLOBALS['main']->setACPNotify();
$GLOBALS['main']->setACPWarning();
*/

$reset = isset($_POST['magictoolboxSubmitAction']) && ($_POST['magictoolboxSubmitAction'] == 'reset');

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    $imageBasePath = CC_ROOT_DIR.CC_DS.'images'.CC_DS.'magicscroll'.CC_DS;
    if(empty($_POST['module']['homeslideshow-images-data'])) $_POST['module']['homeslideshow-images-data'] = array();
    if(is_dir($imageBasePath) || mkdir($imageBasePath)) {
        foreach($_POST['module']['homeslideshow-images-data'] as $imageId => $imageData) {
            if(isset($imageData['delete']) && !empty($imageData['name'])) {
                @unlink($imageBasePath.$imageData['name']);
                unset($_POST['module']['homeslideshow-images-data'][$imageId]);
            } else {
                $_POST['module']['homeslideshow-images-data'][$imageId]['title'] = str_replace('"', '&quot;', $imageData['title']);
                //$_POST['module']['homeslideshow-images-data'][$imageId]['title'] = addslashes($imageData['title']);
                //$_POST['module']['homeslideshow-images-data'][$imageId]['description'] = addslashes($imageData['description']);
                $_POST['module']['homeslideshow-images-data'][$imageId]['link'] = str_replace('"', '&quot;', $imageData['link']);
                //$_POST['module']['homeslideshow-images-data'][$imageId]['link'] = addslashes($imageData['link']);
                $_POST['module']['homeslideshow-images-data'][$imageId]['order'] = intval($imageData['order']);
                $_POST['module']['homeslideshow-images-data'][$imageId]['exclude'] = isset($imageData['exclude']) ? 1 : 0;
            }
        }
        function sortMagicScrollImages($a, $b) {
            if($a['order'] == $b['order']) {
                return 0;
            }
            return ($a['order'] < $b['order']) ? -1 : 1;
        }
        usort($_POST['module']['homeslideshow-images-data'], 'sortMagicScrollImages');

        if(!empty($_FILES['magicscroll_image_files']['tmp_name'])) {
            foreach($_FILES['magicscroll_image_files']['tmp_name'] as $key => $tempName) {
                if(!empty($tempName) && file_exists($tempName)) {
                    $name = preg_replace('/[^a-zA-Z0-9()_\.-]/is', '', $_FILES['magicscroll_image_files']['name'][$key]);
                    $ext = substr($name, strrpos($name, '.'));
                    $name = substr($name, 0, -strlen($ext));
                    $index = 0;
                    $suffix = '';
                    while(file_exists($imageBasePath.$name.$suffix.$ext)) {
                        $suffix = "({$index})";
                        $index++;
                    }
                    if(move_uploaded_file($tempName, $imageBasePath.$name.$suffix.$ext)) {
                        $_POST['module']['homeslideshow-images-data'][] = array(
                            'name' => $name.$suffix.$ext,
                            'title' => '',
                            'description' => '',
                            'link' => '',
                            'order' => 0,
                            'exclude' => false,
                        );
                    }
                }
            }
        }
    }
}

$moduleDir = CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.'MagicScroll';
$coreFile = $moduleDir.CC_DS.'core'.CC_DS.'magicscroll.module.core.class.php';
$module = new Module(__FILE__, $_GET['module'], 'admin/index.tpl', false, false);
$template_vars = array();

if(file_exists($coreFile)) {
    require $coreFile;
    $tool = new MagicScrollModuleCoreClass;
    require $moduleDir.CC_DS.'defaults.php';
    $skippedOptions = array(
    );

    $template_vars['currentTab'] = isset($_POST['magictoolboxCurrentTab']) ? $_POST['magictoolboxCurrentTab'] : '';
    $template_vars['blocks'] = get_magicscroll_blocks();
    $template_vars['grouped_options'] = get_magicscroll_params_map();
    $template_vars['hints'] = array();
    $template_vars['hidden_options'] = array();
    $template_vars['not_required_options'] = array(
        'scroll-extra-styles',
        'message',
        'watermark',
    );

    foreach(get_magicscroll_blocks() as $blockId => $blockTitle) {
        foreach($tool->params->getParams() as $id => $param) {
            if(in_array($id, $skippedOptions)) continue;
            $value = $reset ? false : $module->__get($blockId.'-'.$id);
            if($value === false) {
                $value = isset($defaults[$blockId][$id]) ? $defaults[$blockId][$id] : $tool->params->getValue($id);
            }
            $tool->params->setValue($id, $value, $blockId);
            $hint = $tool->params->getDescription($id);
            if(($tool->params->getType($id) != "array") && $tool->params->valuesExists($id)) {
                if($hint) $hint .= "<br />";
                $hint .= "Allowed values: ".implode(", ", $tool->params->getValues($id));
            }
            if($hint) {
                $template_vars['hints'][$id] = $hint;
            }
        }
    }

//     if($tool->params->checkValue('resize-images', 'No')) {
//         $template_vars['hidden_options'] = array(
//             'thumb-max-width',
//             'thumb-max-height',
//             'selector-max-width',
//             'selector-max-height',
//             'square-images',
//             'imagemagick',
//             'image-quality',
//             'use-original-file-names'
//         );
//         foreach($template_vars['grouped_options']['Watermark'] as $id) {
//             $template_vars['hidden_options'][] = $id;
//         }
//     }

    $template_vars['params'] = &$tool->params;

    $template_vars['homeslideshow_image_base_url'] = CC_STORE_URL.'/images/magicscroll/';
    $template_vars['homeslideshow_data'] = $module->__get('homeslideshow-images-data');
    if($template_vars['homeslideshow_data'] === false) {
        $template_vars['homeslideshow_data'] = array();
    }

    $template_vars['cubecart6x'] = false;
    if(defined('CC_VERSION') && version_compare(CC_VERSION, '6.0.0', '>=')) {
        $template_vars['cubecart6x'] = true;
    }

    $template_vars['errors'] = false;
} else {
    $GLOBALS['main']->setACPWarning('File: '.$coreFile.' does not exists! Please, make sure that the module is installed correctly.');
    $template_vars['errors'] = true;
}

$module->assign_to_template($template_vars, null);
$module->fetch();
$page_content = $module->display();

function get_magicscroll_blocks() {
    return array(
		'default' => 'General',
		'product' => 'Product page',
		'homeslideshow' => 'Home page Slideshow',
		'featured' => 'Featured block',
		'popular' => 'Popular block',
	);
}

function get_magicscroll_params_map() {
    return array(
		'default' => array(
			'Positioning and Geometry' => array(
				'square-images',
			),
			'Miscellaneous' => array(
				'resize-images',
				'imagemagick',
				'image-quality',
			),
			'Watermark' => array(
				'watermark',
				'watermark-max-width',
				'watermark-max-height',
				'watermark-opacity',
				'watermark-position',
				'watermark-offset-x',
				'watermark-offset-y',
			),
		),
		'product' => array(
			'General' => array(
				'enable-effect',
			),
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
			),
			'Scroll' => array(
				'width',
				'height',
				'orientation',
				'mode',
				'items',
				'speed',
				'autoplay',
				'loop',
				'step',
				'arrows',
				'pagination',
				'easing',
				'scrollOnWheel',
				'lazy-load',
				'scroll-extra-styles',
				'show-image-title',
			),
		),
		'homeslideshow' => array(
			'General' => array(
				'enable-effect',
			),
			'Setup slideshow for home page' => array(
			),
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
			),
			'Scroll' => array(
				'width',
				'height',
				'orientation',
				'mode',
				'items',
				'speed',
				'autoplay',
				'loop',
				'step',
				'arrows',
				'pagination',
				'easing',
				'scrollOnWheel',
				'lazy-load',
				'scroll-extra-styles',
				'show-image-title',
			),
			'Miscellaneous' => array(
				'link-to-product-page',
			),
		),
		'featured' => array(
			'General' => array(
				'enable-effect',
			),
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
			),
			'Scroll' => array(
				'width',
				'height',
				'orientation',
				'mode',
				'items',
				'speed',
				'autoplay',
				'loop',
				'step',
				'arrows',
				'pagination',
				'easing',
				'scrollOnWheel',
				'lazy-load',
				'scroll-extra-styles',
				'show-image-title',
			),
			'Miscellaneous' => array(
				'count-of-products',
				'link-to-product-page',
			),
		),
		'popular' => array(
			'General' => array(
				'enable-effect',
			),
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
			),
			'Scroll' => array(
				'width',
				'height',
				'orientation',
				'mode',
				'items',
				'speed',
				'autoplay',
				'loop',
				'step',
				'arrows',
				'pagination',
				'easing',
				'scrollOnWheel',
				'lazy-load',
				'scroll-extra-styles',
				'show-image-title',
			),
			'Miscellaneous' => array(
				'link-to-product-page',
			),
		),
	);
}

?>
