<?php

if(!defined('MAGICTOOLBOX_FUNCTION_LOADED')) {

    define('MAGICTOOLBOX_FUNCTION_LOADED', true);

    function getResizedImage($toolID, $original, $resized = '', $pid = null) {
        if(!empty($original)) {
            $lcToolID = strtolower($toolID);
            if(!isset($GLOBALS['magictoolbox'][$lcToolID.'_imagehelper'])) {
                require_once(CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.$toolID.CC_DS.'core'.CC_DS.'magictoolbox.imagehelper.class.php');
                $funcName = "load{$toolID}CoreClass";
                $tool = $funcName();
                $GLOBALS['magictoolbox'][$lcToolID.'_imagehelper'] = new MagicToolboxImageHelperClass(
                    CC_ROOT_DIR,
                    '/images/magictoolbox_cache',
                    $tool['main']->params,
                    null,
                    CC_STORE_URL//$GLOBALS['storeURL']
                );
            }
            $imageHelper = &$GLOBALS['magictoolbox'][$lcToolID.'_imagehelper'];

            if(empty($resized)) $resized = 'original';
            $resized = $imageHelper->create($original, $resized, $pid);
        }
        return $resized;
    }

    function getRandomProductsData($count = '1') {
        $products = array();
        if(($products = $GLOBALS['db']->select('CubeCart_inventory', array('product_id', 'name', 'description'), array('status' => '1'), 'RAND()', $count)) !== false) {
            foreach($products as $i => $product) {
                $GLOBALS['language']->translateProduct($products[$i]);
                $products[$i]['image'] = $GLOBALS['gui']->getProductImage($products[$i]['product_id']);
                $products[$i]['url'] = $GLOBALS['seo']->buildURL('prod', $products[$i]['product_id']);
            }
        }
        return $products;
    }

}

    function loadMagic360CoreClass() {
        if(!isset($GLOBALS['magictoolbox']['magic360'])) {
            require_once(CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.'Magic360'.CC_DS.'core'.CC_DS.'magic360.module.core.class.php');
            $GLOBALS['magictoolbox']['magic360'] = new Magic360ModuleCoreClass();
            $coreClass = &$GLOBALS['magictoolbox']['magic360'];

            //NOTE: load params
            $config = $GLOBALS['config']->get('Magic360');

            //NOTE: fix for CubeCart 6.x (because it is not empty)
            if(isset($config['status'])) unset($config['status']);
            if(isset($config['countries'])) unset($config['countries']);

            if(empty($config)) {
                /* load defaults */
                require CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.'Magic360'.CC_DS.'defaults.php';
                foreach($defaults as $block => $ids) {
                    foreach($ids as $id => $value) {
                        $coreClass->params->setValue($id, $value, $block);
                    }
                }
            } else {
                foreach($config as $paramId => $value) {
                    $parts = explode('-', $paramId, 2);
                    if(count($parts) != 2) continue;
                    $coreClass->params->setValue($parts[1], $value, $parts[0]);
                }
            }

            $blocks = array(
                'product',
            );

            $languageStrings = $GLOBALS['language']->{'Magic360'};
            if($languageStrings) {
                foreach($blocks as $block) {
                    if(isset($languageStrings[$block.'-message-under-images']) && !empty($languageStrings[$block.'-message-under-images'])) {
                        $coreClass->params->setValue('message', $languageStrings[$block.'-message-under-images'], $block);
                    } else if(isset($languageStrings['default-message-under-images']) && !empty($languageStrings['default-message-under-images'])) {
                        $coreClass->params->setValue('message', $languageStrings['default-message-under-images'], $block);
                    }
                    if(isset($languageStrings[$block.'-loading-text']) && !empty($languageStrings[$block.'-loading-text'])) {
                        $coreClass->params->setValue('loading-text', $languageStrings[$block.'-loading-text'], $block);
                    } else if(isset($languageStrings['default-loading-text']) && !empty($languageStrings['default-loading-text'])) {
                        $coreClass->params->setValue('loading-text', $languageStrings['default-loading-text'], $block);
                    }
                    if(isset($languageStrings[$block.'-fullscreen-loading-text']) && !empty($languageStrings[$block.'-fullscreen-loading-text'])) {
                        $coreClass->params->setValue('fullscreen-loading-text', $languageStrings[$block.'-fullscreen-loading-text'], $block);
                    } else if(isset($languageStrings['default-fullscreen-loading-text']) && !empty($languageStrings['default-fullscreen-loading-text'])) {
                        $coreClass->params->setValue('fullscreen-loading-text', $languageStrings['default-fullscreen-loading-text'], $block);
                    }
                    if(isset($languageStrings[$block.'-hint-text']) && !empty($languageStrings[$block.'-hint-text'])) {
                        $coreClass->params->setValue('hint-text', $languageStrings[$block.'-hint-text'], $block);
                    } else if(isset($languageStrings['default-hint-text']) && !empty($languageStrings['default-hint-text'])) {
                        $coreClass->params->setValue('hint-text', $languageStrings['default-hint-text'], $block);
                    }
                    if(isset($languageStrings[$block.'-mobile-hint-text']) && !empty($languageStrings[$block.'-mobile-hint-text'])) {
                        $coreClass->params->setValue('mobile-hint-text', $languageStrings[$block.'-mobile-hint-text'], $block);
                    } else if(isset($languageStrings['default-mobile-hint-text']) && !empty($languageStrings['default-mobile-hint-text'])) {
                        $coreClass->params->setValue('mobile-hint-text', $languageStrings['default-mobile-hint-text'], $block);
                    }
                }
            }
        }
        return array('main' => &$GLOBALS['magictoolbox']['magic360'], 'magicscroll' => null);
    }

    function magic360_output_filter($output, $template) {

        $tool = loadMagic360CoreClass();

        switch($template->template_resource) {
            case 'templates/content.product.php':
                //$tool->params->generalProfile = 'product';
                if(!$tool['main']->params->checkValue('enable-effect', 'No', 'product')) {
                    $tool['main']->params->setProfile('product');

                    $product = $template->getTemplateVars('PRODUCT');
                    $gallery = $template->getTemplateVars('GALLERY');
                    if(empty($gallery)) break;
                    $imagesCount = count($gallery);
                    if($imagesCount < intval($tool['main']->params->getValue('columns'))) break;
                    //$tool['main']->isEnabled()
                    $ids = trim($tool['main']->params->getValue('product-ids'));
                    if($ids != 'all' && !in_array($product['product_id'], explode(',', $ids))) {
                        break;
                    }

                    function sortMagic360ProductImages($a, $b) {
                        if($a['file_id'] == $b['file_id']) {
                            return 0;
                        }
                        return ($a['file_id'] < $b['file_id']) ? -1 : 1;
                    }
                    usort($gallery, 'sortMagic360ProductImages');

                    $resize = $tool['main']->params->checkValue('resize-images', 'Yes');
                    if(!$resize) {
                        $skins = $GLOBALS['gui']->getSkinData();
                        $size = (int)$skins['images']['medium']['maximum'];
                        $tool['main']->params->setValue('thumb-max-width', $size);
                        $tool['main']->params->setValue('thumb-max-height', $size);
                    }

                    $mainImageHTML = '';
                    $selectorsHTML = array();
                    foreach($gallery as $key => $image) {
                        $img = $image['source'];
                        $thumb = $image['medium'];
                        if($resize) {
                            $image_ref = ($image['file_id']) ? $image['file_id'] : $image['img'];
                            $img = $GLOBALS['catalogue']->imagePath($image_ref, 'source', 'root');
                            $img = str_replace(CC_ROOT_DIR, '', $img);
                            $thumb = getResizedImage('Magic360', $img, 'thumb', $product['product_id']);
                            $img = getResizedImage('Magic360', $img, 'original', $product['product_id']);
                        }

                        //$title = $product['name'];
                        $description = '';
                        $magic360Data[] = array(
                            'medium' => $thumb,
                            'img' => $img,
                        );
                    }

                    $rendered = $tool['main']->getMainTemplate($magic360Data, array("id" => "productMagic360"));
                    $rendered = '<div class="MagicToolboxContainer">'.$rendered.'</div>';

                    //NOTE: cut main image (div.image)
                    $pattern =  '<div\b[^>]*?\bclass\s*+=\s*+"[^"]*?\bimage\b[^"]*+"[^>]*+>'.
                                '('.
                                '(?:'.
                                    '[^<]++'.
                                    '|'.
                                    '<(?!/?div\b|!--)'.
                                    '|'.
                                    '<!--.*?-->'.
                                    '|'.
                                    '<div\b[^>]*+>'.
                                        '(?1)'.
                                    '</div\s*+>'.
                                ')*+'.
                                ')'.
                                '</div\s*+>';
                    $output = preg_replace("#{$pattern}#is", '', $output);

                    //NOTE: cut selectors (div#gallery_select)
                    $pattern =  '<div\b[^>]*?\bid\s*+=\s*+"gallery_select"[^>]*+>'.
                                '('.
                                '(?:'.
                                    '[^<]++'.
                                    '|'.
                                    '<(?!/?div\b|!--)'.
                                    '|'.
                                    '<!--.*?-->'.
                                    '|'.
                                    '<div\b[^>]*+>'.
                                        '(?1)'.
                                    '</div\s*+>'.
                                ')*+'.
                                ')'.
                                '</div\s*+>';
                    $output = preg_replace("#{$pattern}#is", '', $output);

                    //NOTE: replace gallery (div#gallery)
                    $pattern =  '<div\b[^>]*?\bid\s*+=\s*+"gallery"[^>]*+>'.
                                '('.
                                '(?:'.
                                    '[^<]++'.
                                    '|'.
                                    '<(?!/?div\b|!--)'.
                                    '|'.
                                    '<!--.*?-->'.
                                    '|'.
                                    '<div\b[^>]*+>'.
                                        '(?1)'.
                                    '</div\s*+>'.
                                ')*+'.
                                ')'.
                                '</div\s*+>';
                    //$output = preg_replace("#{$pattern}#is", $rendered, $output);
                    $matches = array();
                    if(preg_match("#{$pattern}#is", $output, $matches)) {
                        $output = str_replace($matches[1], $rendered, $output);
                    } else {
                        //NOTE: CubeCart 6.x 'foundation' theme

                        //NOTE: replace main image (div.image)
                        $pattern = '<a\b[^>]*+>[^<]*+<img\b[^<]*?id="img-preview"[^>]*+>[^<]*+</a>';
                        $output = preg_replace("#{$pattern}#is", $rendered, $output);

                        //NOTE: cut gallery (ul.clearing-thumbs)
                        $pattern =  '<ul\b[^>]*?\bclass\s*+=\s*+"[^"]*?\bclearing-thumbs\b[^"]*+"[^>]*+>'.
                                    '('.
                                    '(?:'.
                                        '[^<]++'.
                                        '|'.
                                        '<(?!/?ul\b|!--)'.
                                        '|'.
                                        '<!--.*?-->'.
                                        '|'.
                                        '<ul\b[^>]*+>'.
                                            '(?1)'.
                                        '</ul\s*+>'.
                                    ')*+'.
                                    ')'.
                                    '</ul\s*+>';
                        $output = preg_replace("#{$pattern}#is", '', $output);
                    }

                }
            break;
            case 'templates/main.php':
                $tool['main']->params->resetProfile();

                $page = $template->getTemplateVars('SECTION_NAME');
                if($page === null && isset($_GET['_a']) && !empty($_GET['_a'])) {
                    $page = strtolower($_GET['_a']);
                }
                $useEffectOnPage = !$tool['main']->params->checkValue('enable-effect', 'No', $page);
                $useEffectOnFeaturedBlock = false;
                $useEffectOnPopularBlock = false;
                if($useEffectOnPage || $useEffectOnFeaturedBlock || $useEffectOnPopularBlock) {
                    $path = str_replace(CC_DS, '/', CC_STORE_URL).'/modules/plugins/Magic360/core';
                    $headers = $tool['main']->getHeadersTemplate($path);
                    if($useEffectOnPage) {
                        if($page == 'product') {
                            if($tool['magicscroll'] && $tool['main']->params->checkValue('magicscroll', 'Yes', 'product')) {
                                $tool['magicscroll']->params->resetProfile();
                                $headers .= "\n".$tool['magicscroll']->getHeadersTemplate($path, $path, false);
                            }
                            //$headers .= "\n".
                            //"<style type=\"text/css\">\n".
                            //"div.MagicToolboxContainer {\n".
                            //    "\twidth: ".$tool['main']->params->getValue('thumb-max-width', 'product')."px;\n".
                            //"}\n".
                            //"</style>\n";
                        } else if($page == 'category') {
                        } else if($page == 'latest') {
                        }
                    }


                    $output = preg_replace('#</head>#is', "\n".$headers."\n".'</head>', $output, 1);
                }
                break;
        }

        return $output;
    }

?>
