<?php
/*
$GLOBALS['language']->loadDefinitions('magic360', CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.'Magic360'.CC_DS.'language', 'module.definitions.xml');
$params = $GLOBALS['config']->get('MagicZoomPlus');
$GLOBALS['main']->setACPNotify();
$GLOBALS['main']->setACPWarning();
*/

$reset = isset($_POST['magictoolboxSubmitAction']) && ($_POST['magictoolboxSubmitAction'] == 'reset');


$moduleDir = CC_ROOT_DIR.CC_DS.'modules'.CC_DS.'plugins'.CC_DS.'Magic360';
$coreFile = $moduleDir.CC_DS.'core'.CC_DS.'magic360.module.core.class.php';
$module = new Module(__FILE__, $_GET['module'], 'admin/index.tpl', false, false);
$template_vars = array();

if(file_exists($coreFile)) {
    require $coreFile;
    $tool = new Magic360ModuleCoreClass;
    require $moduleDir.CC_DS.'defaults.php';
    $skippedOptions = array(
    );

    $template_vars['currentTab'] = isset($_POST['magictoolboxCurrentTab']) ? $_POST['magictoolboxCurrentTab'] : '';
    $template_vars['blocks'] = get_magic360_blocks();
    $template_vars['grouped_options'] = get_magic360_params_map();
    $template_vars['hints'] = array();
    $template_vars['hidden_options'] = array();
    $template_vars['not_required_options'] = array(
        'loading-text',
        'fullscreen-loading-text',
        'hint-text',
        'mobile-hint-text',
        'message',
        'watermark',
    );

    foreach(get_magic360_blocks() as $blockId => $blockTitle) {
        foreach($tool->params->getParams() as $id => $param) {
            if(in_array($id, $skippedOptions)) continue;
            $value = $reset ? false : $module->__get($blockId.'-'.$id);
            if($value === false) {
                $value = isset($defaults[$blockId][$id]) ? $defaults[$blockId][$id] : $tool->params->getValue($id);
            }
            $tool->params->setValue($id, $value, $blockId);
            $hint = $tool->params->getDescription($id);
            if(($tool->params->getType($id) != "array") && $tool->params->valuesExists($id)) {
                if($hint) $hint .= "<br />";
                $hint .= "Allowed values: ".implode(", ", $tool->params->getValues($id));
            }
            if($hint) {
                $template_vars['hints'][$id] = $hint;
            }
        }
    }

//     if($tool->params->checkValue('resize-images', 'No')) {
//         $template_vars['hidden_options'] = array(
//             'thumb-max-width',
//             'thumb-max-height',
//             'selector-max-width',
//             'selector-max-height',
//             'square-images',
//             'imagemagick',
//             'image-quality',
//             'use-original-file-names'
//         );
//         foreach($template_vars['grouped_options']['Watermark'] as $id) {
//             $template_vars['hidden_options'][] = $id;
//         }
//     }

    $template_vars['params'] = &$tool->params;


    $template_vars['cubecart6x'] = false;
    if(defined('CC_VERSION') && version_compare(CC_VERSION, '6.0.0', '>=')) {
        $template_vars['cubecart6x'] = true;
    }

    $template_vars['errors'] = false;
} else {
    $GLOBALS['main']->setACPWarning('File: '.$coreFile.' does not exists! Please, make sure that the module is installed correctly.');
    $template_vars['errors'] = true;
}

$module->assign_to_template($template_vars, null);
$module->fetch();
$page_content = $module->display();

function get_magic360_blocks() {
    return array(
		'default' => 'General',
		'product' => 'Product page',
	);
}

function get_magic360_params_map() {
    return array(
		'default' => array(
			'General' => array(
				'enable-effect',
			),
			'Positioning and Geometry' => array(
				'square-images',
			),
			'Miscellaneous' => array(
				'resize-images',
				'imagemagick',
				'image-quality',
			),
			'Watermark' => array(
				'watermark',
				'watermark-max-width',
				'watermark-max-height',
				'watermark-opacity',
				'watermark-position',
				'watermark-offset-x',
				'watermark-offset-y',
			),
		),
		'product' => array(
			'General' => array(
				'enable-effect',
			),
			'Magic 360' => array(
				'product-ids',
				'columns',
				'magnify',
				'magnifier-width',
				'magnifier-shape',
				'fullscreen',
				'spin',
				'autospin-direction',
				'sensitivityX',
				'sensitivityY',
				'mousewheel-step',
				'autospin-speed',
				'smoothing',
				'autospin',
				'autospin-start',
				'autospin-stop',
				'initialize-on',
				'start-column',
				'start-row',
				'loop-column',
				'loop-row',
				'reverse-column',
				'reverse-row',
				'column-increment',
				'row-increment',
			),
			'Positioning and Geometry' => array(
				'thumb-max-width',
				'thumb-max-height',
			),
			'Miscellaneous' => array(
				'show-message',
				'message',
				'loading-text',
				'fullscreen-loading-text',
				'hint',
				'hint-text',
				'mobile-hint-text',
			),
		),
	);
}

?>
