<?php

if ( !defined('AREA') ) { die('Access denied'); }

//options enabled by default
define('ENABLED_OPTIONS', '|enable-effect|arrows|orientation|thumb-max-width|thumb-max-height|show-message|items|show-image-title|fullscreen|');
define('MT_DS', DIRECTORY_SEPARATOR);

function fn_magicthumb($output, &$view) {

    if(isset($view->_tpl_vars['title'])) return $output;//avoid a second call

    $tool = fn_magicthumb_load();
    $tpl_vars = $view->get_template_vars();
    $tool->params->setValue('index-script', $tpl_vars['index_script']);
    $tool->params->setValue('currencies', $view->_tpl_vars['currencies'][$view->_tpl_vars['secondary_currency']]);

    if(isset($view->_tpl_vars['block'])) {
        //this is block
        $block = $view->_tpl_vars['block'];
        $GLOBALS['magictoolbox']['block'] = &$block;
        $block_fillings = isset($block['properties']['fillings'])?$block['properties']['fillings']:false;
        if($block_fillings && ($block['properties']['list_object'] == 'products'
                              )) {
            $allowable_block_fillings = array('newest', 'recent_products', 'popularity', 'bestsellers', 'rating', 'manually'
                                             );
            if(in_array($block_fillings,$allowable_block_fillings) && !$tool->params->checkValue('enable-effect', 'No', $block_fillings)) {
                $tool->params->setValue('block-id', $block['block_id']);
                $items = $view->get_template_vars('items');
                if($items) {
                    if($block['properties']['appearances'] == 'addons/hot_deals_block/blocks/hot_deals.tpl') {
                        return $output;
                        //Hot Deals specifically
                        $GLOBALS['magictoolbox']['hot_deals_block'] = true;
                    }
                    $output = fn_magicthumb_parse_standard($output, $items, $block_fillings);
                    $tool->params->setValue('headers', 'Yes');
                }
            }
        }
    } else {
        //this is not block
        $GLOBALS['magictoolbox']['block'] = null;
        //if(isset($view->_tpl_vars['left']) || isset($view->_tpl_vars['right']) || isset($view->_tpl_vars['top']) || isset($view->_tpl_vars['bottom'])) {
            //not all content
        //} else {
        if(!isset($view->_tpl_vars['left']) && !isset($view->_tpl_vars['right']) && !isset($view->_tpl_vars['top']) && !isset($view->_tpl_vars['bottom'])) {
            //all content
            switch($_REQUEST['dispatch']) {
                case 'products.view':
                    $page = 'product';
                break;
                case 'categories.view':
                    $page = 'category';
                break;
                case 'products.search':
                    $page = 'search';
                break;
                default: $page = '';
            }
            if($page && !$tool->params->checkValue('enable-effect', 'No', $page)) {
                $tool->params->setValue('block-id', '');
                $products = ($page == 'product' ? array($tpl_vars['product']) : $tpl_vars['products']);
                $output = fn_magicthumb_parse_standard($output, $products, $page);
                $tool->params->setValue('headers', 'Yes');
            }
            else if($_REQUEST['dispatch'] == 'products.options') {//ajax request
                $page = 'unknown';
                if(isset($_REQUEST['result_ids'])) {
                    if(strpos($_REQUEST['result_ids'], 'list_image_update_') !== false) {
                        if(strpos($_SERVER['HTTP_REFERER'], 'dispatch=products.search') !== false) {
                            $page = 'search';
                        } else if(strpos($_SERVER['HTTP_REFERER'], 'dispatch=categories.view') !== false) {
                            $page = 'category';
                        }
                    }
                    else if(strpos($_REQUEST['result_ids'], 'product_images_') !== false)
                        $page = 'product';
                }
                if($tool->params->profileExists($page) && !$tool->params->checkValue('enable-effect', 'No', $page)) {
                    $tool->params->setValue('block-id', '');
                    $products = array($tpl_vars['product']);
                    $output = fn_magicthumb_parse_standard($output, $products, $page);
                    $tool->params->setValue('headers', 'No');
                }
            }
            //if($tool->params->checkValue('headers', 'Yes')) {
            $includeHeaders = $tool->params->getValue('headers');
            if($includeHeaders == 'Yes' || !$includeHeaders && (strpos($output, "MagicThumb") !== false)) {
                $output = fn_magicthumb_headers($output);
            }
        }
    }
    return $output;
}

function fn_magicthumb_load($block = false) {
    if(!isset($GLOBALS['magictoolbox']['magicthumb'])) {
        require_once(dirname(__FILE__) . '/core/magicthumb.module.core.class.php');
        $GLOBALS['magictoolbox']['magicthumb'] = new MagicThumbModuleCoreClass();
        $tool = &$GLOBALS['magictoolbox']['magicthumb'];

        //CS-Cart 2.x.x
        $params = Registry::get('addons.magicthumb');
        //$tpl_vars = & Registry::get('view')->_tpl_vars;

        //CS-Cart v 1.x.x
        //$tpl_vars = & $GLOBALS['smarty']->_tpl_vars;
        //define(DIR_ROOT, CSCART_DIR);
        //$tool->params->setValue('cscart_config_http_path', $GLOBALS['cscart_http_dir']);
        //$tool->params->setValue('cscart_config_http_images_path', IMAGES_STORAGE_WEB_DIR);
        //if(!defined('IMAGES_STORAGE_DIR') && isset($GLOBALS['images_storage_dir'])) {
        //    define('DIR_IMAGES', $GLOBALS['images_storage_dir']);
        //}
        //if(!defined('DIR_IMAGES') && defined('IMAGES_STORAGE_DIR')) {
        //    define('DIR_IMAGES', IMAGES_STORAGE_DIR);
        //}


        foreach($params as $p_name => $p_value) {
            $param_value = '';
            if(strpos($p_value, $p_name . '-') === 0) {
                $param_value = substr($p_value, strlen($p_name)+1);
            } else {
                $param_value = $p_value;
            }
            if(strpos($p_name, 'general-') === 0) {
                $tool->params->setValue(substr($p_name, 8), $param_value);
            } else {
                $pattern = '/(product|category|search|newest|recent_products|popularity|bestsellers|rating|manually|banners)-(.*)/is';
                $matches = array();
                if(preg_match($pattern, $p_name, $matches)) {
                    if(isset($params[$matches[1] . "-enabled-options"])) $enabledOptions = $params[$matches[1] . "-enabled-options"];
                    else $enabledOptions = ENABLED_OPTIONS;
                    if(strpos($enabledOptions, '|' . $matches[2] . '|') !== false
                       || $tool->params->checkGroup($matches[2], array('General', 'Scroll', 'Scroll Arrows', 'Scroll Slider', 'Scroll effect', 'Multiple images'))
                      ) {
                        $tool->params->setValue($matches[2], $param_value, $matches[1]);
                    }
                }
            }
        }

        $detailed_image_width = Registry::get('settings.Thumbnails.product_detailed_image_width');
        $detailed_image_height = Registry::get('settings.Thumbnails.product_detailed_image_height');
        if(empty($detailed_image_width)) $detailed_image_width = 0;
        if(empty($detailed_image_height)) $detailed_image_height = 0;
        $tool->params->setValue('detailed-max-width', $detailed_image_width);
        $tool->params->setValue('detailed-max-height', $detailed_image_height);
        if(!$detailed_image_width && !$detailed_image_height) {
            $tool->params->setValue('resize-original-image', 'No');
        } else {
            $tool->params->setValue('resize-original-image', 'Yes');
        }
    } else {
        $tool = &$GLOBALS['magictoolbox']['magicthumb'];
    }
    return $tool;
}

function fn_magicthumb_magicscroll_load() {
    if(!isset($GLOBALS['magictoolbox']['magicthumb_magicscroll'])) {
        require_once(dirname(__FILE__).'/core/magicscroll.module.core.class.php');
        $GLOBALS['magictoolbox']['magicthumb_magicscroll'] = new MagicScrollModuleCoreClass(false);
        $tool = fn_magicthumb_load();
        //NOTE: load params in a separate profile, in order not to overwrite the options of MagicScroll module
        $GLOBALS['magictoolbox']['magicthumb_magicscroll']->params->appendParams($tool->params->getParams('product'), 'product-magicscroll-options');
        $GLOBALS['magictoolbox']['magicthumb_magicscroll']->params->setValue('orientation', ($tool->params->checkValue('template', array('left', 'right'), 'product') ? 'vertical' : 'horizontal'), 'product-magicscroll-options');
        //NOTE: if Magic Scroll module installed we need to load settings before displaying custom options
        if(function_exists('fn_magicscroll_load')) {
            fn_magicscroll_load();
        }
    }
    return $GLOBALS['magictoolbox']['magicthumb_magicscroll'];
}

function fn_magicthumb_headers($contents) {
    $tool = fn_magicthumb_load();
    $tool->params->resetProfile();
    $http_path = Registry::get('config.http_path');
    $headers = '';
    $headers .= $tool->getHeadersTemplate($http_path.'/addons/magicthumb/core');
    if($tool->params->checkValue('magicscroll', 'Yes', 'product')) {
        $scroll = fn_magicthumb_magicscroll_load();
        $scroll->params->resetProfile();
        $headers .= $scroll->getHeadersTemplate($http_path.'/addons/magicthumb/core', $http_path.'/addons/magicthumb/core', false);
    }
    if(!defined('MAGICTOOLBOX_FUNC_JS_INCLUDED')) {
        $headers .= '<script type="text/javascript" src="'.$http_path.'/addons/magicthumb/func.js"></script>'."\r\n";
        define('MAGICTOOLBOX_FUNC_JS_INCLUDED', true);
    }
    if(!$tool->params->checkValue('enable-effect', 'No', 'product')) {

        $headers .= '
<script type="text/javascript">
    var magicToolboxSelectorsEvent = \''.strtolower($tool->params->getValue('swap-image', 'product')).'\';
    var magicToolboxSelectorsDelay = 0;
</script>
';
    }
    if(!empty($_REQUEST['product_id'])) {
        $headers .= "
<script type=\"text/javascript\">
    $(document).ready(function() {
        if(typeof(MagicScroll) !== 'undefined') {
            var selectorsDiv = document.getElementById('MagicToolboxSelectors{$_REQUEST['product_id']}');
            if(selectorsDiv && selectorsDiv.className.match(new RegExp('(?:\\\\\\s|^)MagicScroll(?:\\\\\\s|$)'))) {
                MagicScrollOptions['onReady'] = function(id) {
                    if (id == 'MagicToolboxSelectors{$_REQUEST['product_id']}') {
                        fn_magictoolbox_selector_init('{$_REQUEST['product_id']}');
                    }
                };
            } else {
                fn_magictoolbox_selector_init('{$_REQUEST['product_id']}');
            }
        } else {
            fn_magictoolbox_selector_init('{$_REQUEST['product_id']}');
        }
    });
</script>\r\n";
    }

    //$headers .= '<style type="text/css">.central-column{overflow: visible !important;}';
    //$headers .= ' div.MagicToolboxSelectorsContainer img {border: 0px;}';

    //NOTE: these margins and borders lead to MagicScrollItem(and MagicToolboxSelectorsContainer) becomes wider
    //if($tool->params->checkValue('magicscroll', 'Yes', 'product')) {
    //    $headers .= ' div.MagicToolboxSelectorsContainer a, div.MagicToolboxSelectorsContainer a img { margin: 0; border: 0; }';
    //} else if($tool->params->checkValue('template', array('left', 'right'), 'product')) {
    //     $headers .= ' div.MagicToolboxSelectorsContainer a, div.MagicToolboxSelectorsContainer a img { margin-left: 0; margin-right: 0; border: 0; }';
    //}
    //$headers .= '</style>';

    if(strpos($contents, '<!-- Magic Slideshow CS-Cart module') !== false) {
        $contents = str_replace('<!-- Magic Slideshow CS-Cart module', $headers . "\r\n" . '<!-- Magic Slideshow CS-Cart module', $contents);
    } else
    $contents = preg_replace('#</head>#is', $headers . '</head>', $contents, 1);

    if(defined('MAGICTOOLBOX_JS_FILES_SUBSTITUTION')) {
        return $contents;
    }
    define('MAGICTOOLBOX_JS_FILES_SUBSTITUTION', true);
    //absolute path
    $module_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ADDONS.'/magicthumb');

    $jsFiles = array('/ajax', '/core');
    if(!defined('PRODUCT_VERSION') || version_compare(PRODUCT_VERSION, '2.2.0', '<')) {
        $jsFiles[] = '/tabs';
    }

    //to prevent page break as a result not property install
    foreach($jsFiles as $key => $fileName) {
        if(!file_exists($module_directory.$fileName.'.js')) {
            unset($jsFiles[$key]);
        }
    }

    if(!empty($jsFiles)) {
        if(Registry::get('config.tweaks.js_compression')) {
            //$dir_cache = substr(DIR_CACHE, strlen(DIR_ROOT));
            $js_path = Registry::get('config.cache_path') . '/js';
            $suffix = '_packed';
            foreach($jsFiles as $fileName) {
                if(!is_file($module_directory.$fileName.$suffix.'.js') && is_writeable($module_directory)) {
                    if(!class_exists('JavaScriptPacker')) include_once(DIR_LIB.'packer/class.JavaScriptPacker.php');
                    $packer = new JavaScriptPacker(fn_get_contents($module_directory.$fileName.'.js'));
                    fn_put_contents($module_directory.$fileName.$suffix.'.js', $packer->pack());
                }
            }
        } else {
            $js_path = Registry::get('config.current_path') . '/js';
            $suffix = '';
        }

        //relative to the site root
        $module_path = Registry::get('config.current_path').substr(DIR_ADDONS, strlen(DIR_ROOT)).'magicthumb';

        foreach($jsFiles as $fileName) {
            $pattern = preg_quote($js_path.$fileName.'.js', '/');
            $contents = preg_replace('/'.$pattern.'/is', $module_path.$fileName.$suffix.'.js', $contents);
        }
    }

    return $contents;
}

function fn_magicthumb_parse_standard($contents, $products, $block) {
    $tool = fn_magicthumb_load($block);
    $tool->params->setProfile($block);
    if(!$tool->params->checkValue('enable-effect', 'No')) {
        foreach($products as $product) {
            if(isset($product['main_pair']['icon'])) {
                //$pattern = preg_quote($product['main_pair']['icon']['image_path'], '/');
                //Non-ASCII filenames are chunked if no locale is provided
                $localName = pathinfo($product['main_pair']['icon']['image_path']);
                $pattern = preg_quote($localName['dirname'].'/'.$localName['filename'], '/').'\\.(?:jpg|png|gif)';
                $old_locale = setlocale(LC_ALL, NULL);
                setlocale(LC_ALL, 'en_US.UTF8');
            } elseif(isset($product['main_pair']['detailed'])) {
                //$pattern = '[^"]*' . preg_quote(preg_replace('/^.*\/([^\/]+)$/is', '$1', $product['main_pair']['detailed']['image_path']));
                //Non-ASCII filenames are chunked if no locale is provided
                $localName = pathinfo($product['main_pair']['detailed']['image_path']);
                //$localName = $localName['dirname'].'/'.$localName['basename'];
                //$pattern = '[^"]*\\/' . preg_quote(preg_replace('/^.*\/([^\/]+)$/is', '$1', $localName));
                $pattern = '[^"]*\\/'.preg_quote($localName['filename'], '/').'\\.(?:jpg|png|gif)';
                $old_locale = setlocale(LC_ALL, NULL);
                setlocale(LC_ALL, 'en_US.UTF8');
            } else {
                continue;
            }
            // for 'Compact list' mode
            //$pattern = str_replace('\\/product\\/', '((\\/thumbnails\\/thumbnail_[0-9]+__)|(\\/product\\/))', $pattern);
            $pattern = preg_replace('/\\\\\\/(?:product|product_option)\\\\\\/([0-9]+?\\\\\\/)?/is', '(?:(?:\\/thumbnails\\/thumbnail_[0-9]+__)|(?:\\/product\\/$1)|(?:\\/thumbnails\\/[0-9]+?\\/(?:[0-9]+?\\/)?(?:[0-9]+?\\/)?))', $pattern);

            $pattern = '<img[^>]*?src="'.$pattern.'"[^>]*>';
            //for CS-Cart 2.1.2 and ajax request in 2.2.x
            if($block == 'category' || $block == 'search' ||
               isset($GLOBALS['magictoolbox']['block']['properties']['appearances']) &&
               $GLOBALS['magictoolbox']['block']['properties']['appearances'] == 'blocks/products.tpl') {
                $pattern = '((?:<input[^>]*+>[^<]*+)*)'.$pattern;
            }
            $pattern = '(<span[^>]*+>[^<]*+<input[^>]*+>[^<]*+)?'.$pattern.'((?(2)[^<]*+<!--[^>]*?-->[^<]*+<\/span>))';
            $pattern = '(<a[^>]*>[^<]*)?'.$pattern.'(?(1)[^<]*<\/a>)';
            /*
            span outside
                with link
                    a input input image.tpl /a
                without link
                    input image.tpl
            span inside (old versions)
                with link
                    a span input image.tpl /span /a
                without link
                    span input image.tpl /span
            */

            //$html = fn_magicthumb_prepareHTML($product, $block, preg_match('/<ul[^>]*?id="product_thumbnails"[^>]*?class="[^">]*?jcarousel-skin[^">]*?"[^>]*>/is', $contents));
            $html = fn_magicthumb_prepareHTML($product, $block, Registry::get('settings.Appearance.thumbnails_gallery') == 'Y');
            setlocale(LC_ALL, $old_locale);
            if($html) {
                if($block == 'product') {
                    //NOTE: cut mini thumbnails (inside product thumbnails list)
                    $contents = preg_replace('/<a[^>]+?class="[^"]*?cm-thumbnails-mini[^"]*"[^>]*>.*?<\/a>/is', '', $contents);
                }
                preg_match('/' . $pattern . '/is', $contents, $matches);
                $spanOpen = (isset($matches[2]) && !empty($matches[2])) ? $matches[2] : '';
                $hiddenInputs = (isset($matches[3]) && !empty($matches[3])) ? $matches[3] : '';
                $spanClose = (isset($matches[4]) && !empty($matches[4])) ? $matches[4] : '';
                $contents = str_replace($matches[0], $spanOpen.$hiddenInputs.$html.$spanClose, $contents);
                if($block == 'product') {
                    $contents = preg_replace('/<p[^>]+?id="(?:detailed_box_|box_det_img_link_)' . intval($product['product_id']) . '(?:_[0-9]+)?"[^>]*>.*?<\/p>/is', '', $contents);
                    $contents = preg_replace('/<a[^>]+?id="(?:detailed_href[0-9]*_|det_img_link_)' . intval($product['product_id']) . '(?:_[0-9]+)?(?:_mini)?"[^>]*>.*?<\/a>/is', '', $contents);
                    //NOTE: cut product thumbnails list
                    $contents = preg_replace('/<ul[^>]+?id="product_thumbnails"[^>]*>[^<]*(?:<li>[^<]*<\/li>[^<]*)*<\/ul>/is', '', $contents);
                    $contents = str_replace('\'circular\'', '\'both\'', $contents);
                }
            }
        }
    }
    return $contents;
}

function fn_magicthumb_prepareHTML($data, $page, $jcarousel = false) {

    $tool = fn_magicthumb_load();

    $originalLayout = $tool->params->checkValue('template', 'original');

    if($jcarousel && $originalLayout) {
        $width  = $tool->params->checkValue('selector-max-width', array('0', '')) ? 'auto' : $tool->params->getValue('selector-max-width');
        $height = $tool->params->checkValue('selector-max-height', array('0', '')) ? 'auto' : $tool->params->getValue('selector-max-height');
    } else {
        $width = '';
        $height = '';
    }

    //$http_path = Registry::get('config.http_path');
    $big_img_type = $tool->params->checkValue('resize-original-image', 'No') ? 'original' : 'detailed';

    if(($page != 'product') && $tool->params->checkValue('link-to-product-page', 'Yes')) {
        $link = $tool->params->getValue('index-script') . '?dispatch=products.view&product_id=' . $data['product_id'];
        if(function_exists('fn_seo_url')) {
            $link = fn_seo_url($link, AREA, '&amp;', 'products.view&product_id=' . $data['product_id']);
        }
        //$link = $http_path.'/'.$link;
    } else {
        $link = false;
    }

    if($data['main_pair']) {
        if(!$data['main_pair']['detailed']) {
            $data['main_pair']['detailed'] = fn_get_image($data['main_pair']['detailed_id'], 'detailed');
        }
        if(!is_array($data['main_pair']['detailed'])) {
            return false;//module does not apply tool for product if there is no detailed image for it
        }
        $main = true;
    } else {
        $main = false;
    }

    $price = smarty_modifier_format_price($data['price'], $tool->params->getValue('currencies'), '');

    $useMagic360 = false;
    if($page == 'product' && function_exists('fn_magic360_load')) {
        $magic360tool = fn_magic360_load();
        if($magic360tool->params->checkValue('enable-effect', 'Yes', 'product')) {
            $rezult = db_get_row('SELECT gallery FROM ?:addon_magic360_images WHERE id = ?i', $data['product_id']);
            if(isset($rezult['gallery']) && !empty($rezult['gallery'])) {
                $magic360Images = explode(';', $rezult['gallery']);
                if(count($magic360Images)) {
                    $useMagic360 = true;
                }
            }
        }
    }

    $mainA = $a = false;
    if($main) {
        $title = !empty($data['main_pair']['detailed']['alt']) ? $data['main_pair']['detailed']['alt'] : $data['product'];
        $mainA = $a = $tool->getMainTemplate(array(
            'id' => $page . $data['product_id'],
            'group' => $page . $tool->params->getValue('block-id'),
            'img' => fn_magicthumb_create_thumb($data['main_pair']['detailed']['image_path'], $big_img_type, $tool, $data['product_id']),
            'thumb' => fn_magicthumb_create_thumb($data['main_pair']['detailed']['image_path'], 'thumb', $tool, $data['product_id']),
            'title' => $title,
            'shortDescription' => $data['short_description'],
            'description' => $data['full_description'],
            'price' => $price,
            'link' => $link,
        ));
    }

    $thumbs = array();

    $mainSelector = $tool->getSelectorTemplate(array(
        'id' => $page . $data['product_id'],
        'group' => $page . $tool->params->getValue('block-id'),
        'img' => fn_magicthumb_create_thumb($data['main_pair']['detailed']['image_path'], $big_img_type, $tool, $data['product_id']),
        'medium' => fn_magicthumb_create_thumb($data['main_pair']['detailed']['image_path'], 'thumb', $tool, $data['product_id']),
        'thumb' => fn_magicthumb_create_thumb($data['main_pair']['detailed']['image_path'], 'selector', $tool, $data['product_id']),
        'title' => $title,
        'width' => $width, //$GLOBALS['magictoolbox']['thumb_sizes'][$data['main_pair']['detailed']['image_path']][0],
        'height' => $height //$GLOBALS['magictoolbox']['thumb_sizes'][$data['main_pair']['detailed']['image_path']][1]
    ));
    if($originalLayout) {
        $mainSelector = str_replace('<a ', '<a class="cm-thumbnails-mini" ', $mainSelector);
    }

    if($data['image_pairs'] && count($data['image_pairs']) > 0) {

        if($main) {
            $thumbs[] = $mainSelector;
        }
        foreach($data['image_pairs'] as $t) {
            if($t['detailed']) {
                if($main) {
                    $a = $tool->getSelectorTemplate(array(
                        'id' => $page . $data['product_id'],
                        'group' => $page . $tool->params->getValue('block-id'),
                        'img' => fn_magicthumb_create_thumb($t['detailed']['image_path'], $big_img_type, $tool, $data['product_id']),
                        'medium' => fn_magicthumb_create_thumb($t['detailed']['image_path'], 'thumb', $tool, $data['product_id']),
                        'thumb' => fn_magicthumb_create_thumb($t['detailed']['image_path'], 'selector', $tool, $data['product_id']),
                        'title' => $t['detailed']['alt'],
                        'width' => $width, //$GLOBALS['magictoolbox']['thumb_sizes'][$t['detailed']['image_path']][0],
                        'height' => $height //$GLOBALS['magictoolbox']['thumb_sizes'][$t['detailed']['image_path']][1]
                    ));
                } else {
                    $a = $tool->getMainTemplate(array(
                        'id' => $page . $data['product_id'],
                        'group' => $page . $tool->params->getValue('block-id'),
                        'img' => fn_magicthumb_create_thumb($t['detailed']['image_path'], $big_img_type, $tool, $data['product_id']),
                        'thumb' => fn_magicthumb_create_thumb($t['detailed']['image_path'], 'selector', $tool, $data['product_id']),
                        'title' => $t['detailed']['alt'],
                        'shortDescription' => $data['short_description'],
                        'description' => $data['full_description'],
                        'price' => $price,
                        'width' => $width, //$GLOBALS['magictoolbox']['thumb_sizes'][$t['detailed']['image_path']][0],
                        'height' => $height //$GLOBALS['magictoolbox']['thumb_sizes'][$t['detailed']['image_path']][1]
                    ));
                }
                $thumbs[] = $originalLayout ? str_replace('<a ', '<a class="cm-thumbnails-mini" ', $a) : $a;
            }
        }
    }

    if($useMagic360) {
        $GLOBALS['magictoolbox']['cooperative_mode'] = 'magicthumb';
        $magic360tool->params->setValue('selector-max-width', $tool->params->getValue('selector-max-width'));
        $magic360tool->params->setValue('selector-max-height', $tool->params->getValue('selector-max-height'));
        $magic360tool->params->setValue('original-layout', $originalLayout, 'product');
        $mainA = 
            '<div style="position: relative;">'.
                '<div id="mainImageContainer'.$data['product_id'].'" style="position: absolute; left: -10000px;">'.
                    //NOTE: we need this div because of issue with MZP, which clones the parent node
                    '<div>'.$mainA.'</div>'.
                '</div>'.
                '<div id="magic360Container'.$data['product_id'].'"><!-- MAGIC360 --></div>'.
            '</div>';
        if(empty($thumbs)) {
            $thumbs[] = $mainSelector;
        }
        array_unshift($thumbs, '<!-- MAGIC360SELECTOR -->');
    }
    $mainA .= '<script type="text/javascript">'.
                'var magicToolboxTool = \'MagicThumb\', magicToolboxProductId = \''.$data['product_id'].'\', '.
                'magicToolboxOriginalLayout='.($originalLayout ? 'true' : 'false').';'.
                '</script>';

    // template helper class
    require_once(dirname(__FILE__) . '/core/magictoolbox.templatehelper.class.php');
    MagicToolboxTemplateHelperClass::setPath(dirname(__FILE__).DIRECTORY_SEPARATOR.'templates');
    MagicToolboxTemplateHelperClass::setOptions($tool->params);
    $scroll = fn_magicthumb_magicscroll_load();
    $options = array(
        'main' => $mainA,
        'thumbs' => $thumbs,
        'magicscrollOptions' => $scroll->params->serialize(false, '', 'product-magicscroll-options'),
        'pid' => $data['product_id'],
        'jcarousel' => $jcarousel
    );
    if($main) {
        return MagicToolboxTemplateHelperClass::render($options);
    } else {
        return MagicToolboxTemplateHelperClass::render('original', $options);
    }
}


function fn_magicthumb_create_thumb($src, $size, &$tool, $pid) {

    static $imageDir = '';
    static $imagesPathQuoted = '';
    static $imagehelper = null;

    if($imagehelper === null) {
        $imagesPathQuoted = preg_quote(Registry::get('config.images_path'), '/');
        $imageDir = str_replace(DIR_ROOT, '', DIR_IMAGES);
        //$config['images_path'] = $config['current_path'] . '/images/';
        require_once(dirname(__FILE__).'/core/magictoolbox.imagehelper.class.php');
        $imagehelper = new MagicToolboxImageHelperClass(DIR_ROOT, $imageDir.'magictoolbox_cache', $tool->params, null, Registry::get('config.http_path'));
    }

    $src = htmlspecialchars_decode($src, ENT_QUOTES);

    preg_match('/^.*?'.$imagesPathQuoted.'(.*?)$/is', $src, $matches);
    if(empty($matches)) return $src;
    $img = $imageDir.$matches[1];

    $thumb = $imagehelper->create($img, $size, $pid);
    //NOTE: spike to get real size of image
    $GLOBALS['magictoolbox']['file_path'] = $imagehelper->file;
    if(MT_DS != '/') {
        $thumb = str_replace(MT_DS, '/', $thumb);
    }

    return $thumb;
}

function fn_magicthumb_css() {

    return '
<style type="text/css">
#tabs_content_magicthumb .form-field { padding: 6px 5px 6px 250px !important; }
#tabs_content_magicthumb .form-field > label { margin-left: -250px !important; width: 240px !important;}
</style>
';

}

function fn_magicthumb_js_functions() {

    if(Registry::get("addons.magicthumb.status") === 'D') {
        $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic Thumb module should be enabled for proper operation of the settings page." .
                   "<br/>Please enable it before save settings.</span>";
        fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('warning').'</span>', $message, true, 'magicthumb_module_disabled_notification');
    }
    //$modulePath = Registry::get('config.current_path') . substr(DIR_ADDONS, strlen(DIR_ROOT)) . 'magicthumb';
    return '
        <script type="text/javascript">
            //<![CDATA[
            function fn_magicthumb_prepare_custom_options(block, skip) {
                skip = (skip || \'\').split(\'|\');
                skip.push(\'enable-effect\');
                var enabledOptionsID = "#addon_option_magicthumb_" + block + "-enabled-options";
                var enabledOptions = $(enabledOptionsID).val();
                var sectionID = "#content_magicthumb_magicthumb_" + block;
                $(sectionID + " div.form-field").
                 each(function(){
                        $(this).
                         find("select, input[type=\'text\']").
                         each(function(){
                                var optionId = this.id.replace("addon_option_magicthumb_" + block + "-","");
                                if(jQuery.inArray(optionId, skip) !== -1) {
                                    return;
                                }
                                if(enabledOptions.indexOf("|" + optionId + "|") == -1) {
                                    $(this).attr("disabled", true).after("&nbsp;&nbsp;<a href=\"#\" >edit</a>");
                                } else {
                                    $(this).after("&nbsp;&nbsp;<a href=\"#\" >use default option</a>");
                                }
                                $(this).next().
                                    bind("click", {optionId: optionId, enabledOptionsID: enabledOptionsID},
                                                    function(event) {
                                                        var enabledOptions = $(event.data.enabledOptionsID).val();
                                                        if($(this).html() == "edit") {
                                                            $(this).html("use default option").prev().removeAttr("disabled");
                                                            enabledOptions = enabledOptions.concat(event.data.optionId + "|");
                                                        } else {
                                                            $(this).html("edit").prev().attr("disabled", true).val($("#addon_option_magicthumb_general-" + event.data.optionId).val().replace("general-", block + "-"));
                                                            var pattern = new RegExp("\\\\|" + event.data.optionId + "\\\\|", "g");
                                                            enabledOptions = enabledOptions.replace(pattern, "|");
                                                        }
                                                        $(event.data.enabledOptionsID).val(enabledOptions);
                                                        return false;
                                                }
                                        );

                              }).
                         end().
                         find("input[type=\'radio\']:checked").
                         each(function(){
                                var optionId = this.name.replace("addon_data[options][" + block + "-","");
                                optionId = optionId.replace("]","");
                                if(jQuery.inArray(optionId, skip) !== -1) {
                                    return;
                                }
                                if(enabledOptions.indexOf("|" + optionId + "|") == -1) {
                                    $(this.parentNode).find("input").attr("disabled", true).end().
                                     find(":last-child").after("&nbsp;&nbsp;<a href=\"#\" >edit</a>");
                                } else {
                                    $(this.parentNode).find(":last-child").after("&nbsp;&nbsp;<a href=\"#\" >use default option</a>");
                                }
                                $(this.parentNode).find(":last-child").
                                    bind("click", {optionId: optionId, enabledOptionsID: enabledOptionsID},
                                                    function(event) {
                                                        var enabledOptions = $(event.data.enabledOptionsID).val();
                                                        if($(this).html() == "edit") {
                                                            $(this).html("use default option");
                                                            $(this.parentNode).find("input").removeAttr("disabled");
                                                            enabledOptions = enabledOptions.concat(event.data.optionId + "|");
                                                        } else {
                                                            $(this).html("edit");
                                                            $(this.parentNode).find("input").attr("disabled", true).val([$("#content_magicthumb_magicthumb_general div.form-field input[name=\'addon_data[options][general-" + event.data.optionId + "]\']:checked").val().replace("general", block)]);
                                                            var pattern = new RegExp("\\\\|" + event.data.optionId + "\\\\|", "g");
                                                            enabledOptions = enabledOptions.replace(pattern, "|");
                                                        }
                                                        $(event.data.enabledOptionsID).val(enabledOptions);
                                                        return false;
                                                }
                                        );

                              });
                      });
            }
            function fn_magicthumb_clear_cache_field(data, params) {
                if(data.html) {
                    for (var k in data.html) {
                        $("#addon_option_magicthumb_cache-total-items").val(data.html[k]);
                        $("#addon_option_magicthumb_cache-unused-items").val("0 (0 bytes)");
                        break;
                    }
                }
            }
            //]]>
        </script>
';

}

function fn_magicthumb_prepare_custom_options($block) {

    static $addon_options;
    $headersBind = '';
    $generalParamsChangeBind = '';
    $enabledOptions = '';
    $includeOptionsJs = '';
    $initOptionsValidation = '';
    $magicscrollIcon = '';

    if(!isset($addon_options)) {
        $addon_options = db_get_field("SELECT options FROM ?:addons WHERE addon = ?s", $_REQUEST['addon']);
        $addon_options = fn_parse_addon_options($addon_options);
    }

    switch($block) {
        case 'general':
            if(isset($addon_options['cache-path-to-cache'])) {
                $pathToCache = $addon_options['cache-path-to-cache'];
            } else {
                $pathToCache = str_replace(DIR_ROOT, '', DIR_IMAGES).'magictoolbox_cache';
            }
            $tool = fn_magicthumb_load();
            require_once(dirname(__FILE__) . '/core/magictoolbox.imagehelper.class.php');
            $imagehelper = new MagicToolboxImageHelperClass(DIR_ROOT, $pathToCache, $tool->params);
            $usedSubCache = $imagehelper->getOptionsHash();
            $cacheInfo = fn_magicthumb_getCacheInfo(DIR_ROOT.$pathToCache, $usedSubCache);
            return  '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magicthumb_cache-path-to-cache">Path to cache folder'.
                    '(<a onclick="return false;" class="cm-tooltip" title="Relative for site base path.">?</a>)<span class="hidden cm-tooltip-text">Relative for site base path.</span>'.
                    '</label>'.
                    '<input type="text" name="addon_data[options][cache-path-to-cache]" id="addon_option_magicthumb_cache-path-to-cache" value="'.$pathToCache.'" class="input-text" style="width:352px;" disabled="disabled" />'.
                    '</div>'.
                    '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magicthumb_cache-total-items">Total items:</label>'.
                    '<input type="text" name="addon_data[options][cache-total-items]" id="addon_option_magicthumb_cache-total-items" value="'.$cacheInfo['totalCount'].' ('.fn_magicthumb_format_size($cacheInfo['totalSize']).')" class="input-text" disabled="disabled" />'.
                    '</div>'.
                    '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magicthumb_cache-unused-items">Unused items:</label>'.
                    '<input type="text" name="addon_data[options][cache-unused-items]" id="addon_option_magicthumb_cache-unused-items" value="'.$cacheInfo['unusedCount'].' ('.fn_magicthumb_format_size($cacheInfo['unusedSize']).')" class="input-text" disabled="disabled" />'.
                    '</div>'.
                    '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magicthumb_cache-what-clear">Empty cache:</label>'.
                    '<select id="addon_option_magicthumb_cache-what-clear" onchange="$(\'#magicthumb_clear_cache_field\').attr(\'href\', \''.INDEX_SCRIPT.'?dispatch=cache.\'+this.value).attr(\'rev\', this.value);">'.
                    '<option  selected="selected" value="clear_unused_items">Delete unused items</option>'.
                    '<option value="clear_all_items">Delete all items</option>'.
                    '</select>'.
                    '&nbsp;<a name="magicthumb_clear_cache_field" id="magicthumb_clear_cache_field" href="'.INDEX_SCRIPT.'?dispatch=cache.clear_unused_items" class="cm-ajax cm-confirm" rev="clear_unused_items" >Clear</a>'.
                    '</div>'
                    ;
            break;
        case 'manually':
            //only after last block
            $headersBind = '$("#tabs_content_magicthumb h2.subheader").css({\'background-color\': \'#F4F4F4\', \'cursor\': \'pointer\'}).slice(0, 1).prepend("&nbsp;<img alt=\"\" src=\"./skins/basic/admin/images/icons/section_expanded.gif\">").end().slice(1).prepend("&nbsp;<img alt=\"\" src=\"./skins/basic/admin/images/icons/section_collapsed.gif\">").end().bind("click", function(){$(this).find("img").each(function(){if(this.src.indexOf("section_collapsed") == -1) this.src = this.src.replace("section_expanded", "section_collapsed"); else this.src = this.src.replace("section_collapsed", "section_expanded");}).end().nextAll().each(function slideToggleNode(){if(typeof slideToggleNode.stop == "undefined" ) {if(this.tagName=="H2") slideToggleNode.stop = true; else $(this).slideToggle(250);}}); return false;}).slice(1, 2).nextAll("div.form-field").css("display", "none");$("#tabs_content_magicthumb div").slice(1).find("h2.subheader:first").nextAll("div.form-field").css("display", "none");';
            //old variant
            //$headersBind = '$("#tabs_content_magicthumb h2.subheader").css({\'background-color\': \'#F4F4F4\', \'cursor\': \'pointer\'}).each(function(){$(this).prepend("&nbsp;<img alt=\"\" src=\"./skins/basic/admin/images/icons/section_expanded.gif\">")}).bind("click", function(){$(this).find("img").each(function(){if(this.src.indexOf("section_collapsed") == -1) this.src = this.src.replace("section_expanded", "section_collapsed"); else this.src = this.src.replace("section_collapsed", "section_expanded");}).end().nextAll().each(function slideToggleNode(){if(typeof slideToggleNode.stop == "undefined" ) {if(this.tagName=="H2") slideToggleNode.stop = true; else $(this).slideToggle(250);}}); return false;}).slice(1).click();';
            $generalParamsChangeBind = '
$("#content_magicthumb_magicthumb_general").find("input[type=\'text\']").bind("change", function(){
var block_array = ["product", "category", "search", "newest", "recent_products", "popularity", "bestsellers", "rating", "manually", "banners"];
var optionId = this.id.replace("addon_option_magicthumb_general-","");
var optioVal = $(this).val();
for(block in block_array) {
    $("#content_magicthumb_magicthumb_" + block_array[block]).
    find("#addon_option_magicthumb_" + block_array[block] + "-" + optionId + ":disabled").val(optioVal);
}
}).
end().find("select").bind("change", function(){
var block_array = ["product", "category", "search", "newest", "recent_products", "popularity", "bestsellers", "rating", "manually", "banners"];
var optionId = this.id.replace("addon_option_magicthumb_general-","");
var optioVal = $(this).val().replace("general-" + optionId + "-", "");
for(block in block_array) {
    $("#content_magicthumb_magicthumb_" + block_array[block]).
    find("#addon_option_magicthumb_" + block_array[block] + "-" + optionId + ":disabled").val(block_array[block] + "-" + optionId + "-" + optioVal);
}
}).
end().find("input[type=\'radio\']").bind("change", function(){
var block_array = ["product", "category", "search", "newest", "recent_products", "popularity", "bestsellers", "rating", "manually", "banners"];
var optionId = this.name.replace("addon_data[options][general-","");
optionId = optionId.replace("]","");
var optioVal = $(this).val().replace("general-" + optionId + "-", "");
for(block in block_array) {
    $("#content_magicthumb_magicthumb_" + block_array[block]).
    find("input[name=\'addon_data[options][" + block_array[block] + "-" + optionId + "]\']:disabled").val([block_array[block] + "-" + optionId + "-" + optioVal]);
}
});';
            $tool = fn_magicthumb_load();
            $http_path = Registry::get('config.http_path');
            $includeOptionsJs = '<script type="text/javascript" src="'.$http_path . '/addons/magicthumb/options.js"></script>';
            $initOptionsValidation = 'initOptionsValidation(\'addon_data[options][product-template]\', \'addon_data[options][product-magicscroll]\', \'product-template-\', \'product-magicscroll-\');';
            $magicscrollIcon = '
var magicscrollIcon = document.createElement("img");
magicscrollIcon.id = "magicscroll_icon";
magicscrollIcon.src = "'.Registry::get('config.http_path')."/addons/magicthumb/magicscroll.png".'";
magicscrollIcon.style.marginRight = "5px";
document.getElementById("variant_magicthumb_product-magicscroll_product-magicscroll-Yes").parentNode.insertBefore(magicscrollIcon, document.getElementById("variant_magicthumb_product-magicscroll_product-magicscroll-Yes"));
';
        default:
            if(isset($addon_options[$block . '-enabled-options'])) {
                $enabledOptions = $addon_options[$block . '-enabled-options'];
            } else {
                $enabledOptions = ENABLED_OPTIONS;
            }
    }

    $tool = fn_magicthumb_load();
    $skip = array();

    if($tool->type == 'standard') {
        foreach($tool->params->getParams() as $param) {
            if(in_array($param['group'], array('General', 'Scroll', 'Scroll Arrows', 'Scroll Slider', 'Scroll effect', 'Multiple images'))) {
                $skip[] = $param['id'];
            }
        }
    }

    $skip = implode('|', $skip);

    return $includeOptionsJs . '
        <input type="hidden" name="addon_data[options][' . $block . '-enabled-options]" id="addon_option_magicthumb_' . $block . '-enabled-options" value="' . $enabledOptions . '" />
        <script type="text/javascript">
            //<![CDATA[
            fn_magicthumb_prepare_custom_options("' . $block . '", \'' .$skip . '\');
            ' . $headersBind . $generalParamsChangeBind . $initOptionsValidation . $magicscrollIcon . '
            //]]>
        </script>
    ';
}

function fn_magicthumb_getCacheInfo($path, $usedSubCache = null) {

    $totalSize = 0;
    $totalCount = 0;
    $usedSize = 0;
    $usedCount = 0;
    if (is_dir($path))
    if ($handle = opendir($path)) {
        while (false !== ($file = readdir($handle))) {
            $next = $path . DIRECTORY_SEPARATOR . $file;
            if ($file != '.' && $file != '..' && !is_link($next)) {
                if (is_dir($next)) {
                    $result = fn_magicthumb_getCacheInfo($next);
                    if($file == $usedSubCache) {
                        $usedSize += $result['totalSize'];
                        $usedCount += $result['totalCount'];
                    }
                    $totalSize += $result['totalSize'];
                    $totalCount += $result['totalCount'];
                } elseif (is_file($next)) {
                    $totalSize += filesize($next);
                    $totalCount++;
                }
            }
        }
        closedir($handle);
    }
    return array('totalSize' => $totalSize, 'totalCount' => $totalCount, 'unusedSize' => $totalSize-$usedSize, 'unusedCount' => $totalCount-$usedCount);
}

function fn_magicthumb_format_size($size) {
    $units = array(' bytes', ' KB', ' MB', ' GB', ' TB');
    for ($i = 0; $size >= 1024 && $i < 4; $i++) $size /= 1024;
    return round($size, 2).$units[$i];
}

function fn_magicthumb_install() {

    $js_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ROOT . '/js');
    $module_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ADDONS . '/magicthumb');
    $jsFiles = array('/ajax', '/core');
    $suffix = '_packed';
    $cancel = false;

    if(!class_exists('JavaScriptPacker'))
        include_once(DIR_LIB . 'packer/class.JavaScriptPacker.php');

    foreach($jsFiles as $fileName) {
        if(@is_file($module_directory . $fileName . '.js')) {
           //installed
        } else {
            if(@is_file($js_directory . $fileName . '.js') && is_writeable($module_directory)) {
                switch($fileName) {
                    case '/ajax':
                        // modify ajax.js
                        $c = file_get_contents($js_directory . $fileName . '.js');
                        $stop = '
        if(params && params.result_ids) {
            if((params.result_ids.search(/(?:product_images_|list_image_update_|product_quick_view_)\d+(?:_update)?|product_filters_\*/i) != -1) || (params.result_ids == \'pagination_contents\')) {
                var productIdMatch = params.result_ids.match(/.*?(?:product_images_|list_image_update_|product_quick_view_)([0-9]+)(?:_update)?.*/i);
                if(productIdMatch) {
                    fn_magictoolbox_tool_update("stop", "product", productIdMatch[1]);
                } else {
                    fn_magictoolbox_tool_update("stop", "category", "");
                }
            }
        }';
                        $start = '
        if(params && params.result_ids) {
            if((params.result_ids.search(/(?:product_images_|list_image_update_|product_quick_view_)\d+(?:_update)?|product_filters_\*/i) != -1) || (params.result_ids == \'pagination_contents\')) {
                var productIdMatch = params.result_ids.match(/.*?(?:product_images_|list_image_update_|product_quick_view_)([0-9]+)(?:_update)?.*/i);
                if(productIdMatch) {
                    fn_magictoolbox_tool_update("start", "product", productIdMatch[1]);
                } else {
                    fn_magictoolbox_tool_update("start", "category", "");
                }
            }
        }';
                        $c = preg_replace('/(ajaxRequest\: function\(url, params\)\s+?\{)/', '$1' . $stop, $c);
                        $c = str_replace('jQuery.toggleStatusBox(\'hide\');', 'jQuery.toggleStatusBox(\'hide\');' . $start, $c);
                        file_put_contents($module_directory . $fileName . '.js', $c);

                        $packer = new JavaScriptPacker(fn_get_contents($module_directory . $fileName . '.js'));
                        fn_put_contents($module_directory . $fileName . $suffix . '.js', $packer->pack());

                        break;
                    case '/core':
                        //modify core.js file
                        $c = file_get_contents($js_directory . $fileName . '.js');

                        $pattern = 'for (var k in data) {';
                        $replace = 'for (var k in data) { if(!data.hasOwnProperty(k)) {continue;}';
                        $c = str_replace($pattern, $replace, $c);

                        $pattern = '/(fn_scroller_init_callback[^\{]*\{)/i';
                        $replace = "$1\n\t\t\tcarousel.options.wrap = 'both';\n";
                        $c = preg_replace($pattern, $replace, $c);

                        file_put_contents($module_directory . $fileName . '.js', $c);

                        $packer = new JavaScriptPacker(fn_get_contents($module_directory . $fileName . '.js'));
                        fn_put_contents($module_directory . $fileName . $suffix . '.js', $packer->pack());

                        break;
                }
            } else {
                //can't install
                $cancel = true;
                if(!is_writeable($module_directory) && !fn_notification_exists('E', 'magicthumb_module_directory_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic Thumb needs write access to the folder <b>'" . $module_directory . "'</b> for proper installation." .
                               "<br/>Please check this and reinstall Magic Thumb.</span>";
                    fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magicthumb_module_directory_notification');
                }
                if(!@is_file($js_directory . $fileName . '.js') && !fn_notification_exists('E', 'magicthumb_file' . $fileName . '_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic Thumb needs read access to the file <b>'" . $js_directory . $fileName . ".js'</b> for proper installation." .
                               "<br/>Please check this and reinstall Magic Thumb.</span>";
                    fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magicthumb_file' . $fileName . '_notification');
                }
            }
        }
    }

    if(!is_file($module_directory . '/tabs' . $suffix . '.js')) {
        $packer = new JavaScriptPacker(fn_get_contents($module_directory . '/tabs.js'));
        fn_put_contents($module_directory . '/tabs' . $suffix . '.js', $packer->pack());
    }

    //fix url's in css files
    $cancel = fn_magicthumb_fix_css();


    if($cancel) {
        $args = func_get_args();
        if(!empty($args)) fn_redirect("addons.manage");
    }

    //NOTE: fix the order in which modules call
    $magic_addons = db_get_fields("SELECT addon FROM ?:addons WHERE addon LIKE 'magic%'");
    if(!empty($magic_addons)) {
        $magic_addons_data = array();
        foreach($magic_addons as $addon) {
            $magic_addons_data[$addon] = db_get_row("SELECT * FROM ?:addons WHERE addon='{$addon}'");
            db_query("DELETE FROM ?:addons WHERE addon='{$addon}'");
        }
        if(isset($magic_addons_data['magicthumb'])) {
            db_query("INSERT INTO ?:addons ?e", $magic_addons_data['magicthumb']);
            unset($magic_addons_data['magicthumb']);
        }
        foreach($magic_addons_data as $addon => $data) {
            db_query("INSERT INTO ?:addons ?e", $data);
        }
    }

    fn_magicthumb_send_stat('install');

}

function fn_magicthumb_fix_css() {

    $cancel = false;

    $path = dirname(__FILE__).'/core';

    $resourcesPath = Registry::get('config.current_path').substr(DIR_ADDONS, strlen(DIR_ROOT)).'magicthumb/core';
    $resourcesPath = str_replace(array("//", "\\"), array("/", "/"), $resourcesPath);
 
    $list = glob($path.'/*');
    $files = array();
    if(is_array($list)) {
        for($i = 0; $i < count($list); $i++) {
            if(is_dir($list[$i])) {
                if(!in_array(basename($list[$i]), array('.svn', '.git'))) {
                    $add = glob($list[$i].'/*');
                    if(is_array($add)) {
                        $list = array_merge($list, $add);
                    }
                }
            } else if(preg_match('#\.css$#i', $list[$i])) {
                $files[] = $list[$i];
            }
        }
    }

    foreach($files as $file) {
        $cssPath = dirname($file);
        $cssRelPath = str_replace($path, '', $cssPath);
        $toolPath = $resourcesPath.$cssRelPath;
        $pattern = '#url\(\s*(\'|")?(?!data:|mhtml:|http(?:s)?:|/)([^\)\s\'"]+?)(?(1)\1)\s*\)#is';
        $replace = 'url($1'.$toolPath.'/$2$1)';
        $fileContents = file_get_contents($file);
        $fixedFileContents = preg_replace($pattern, $replace, $fileContents);
        if($fixedFileContents != $fileContents) {
            if(is_writeable($file)) {
                file_put_contents($file, $fixedFileContents);
            } else {
                //NOTE: install module anyway
                /*
                $cancel = true;
                if(!fn_notification_exists('E', 'magicthumb_file_'.md5($file).'_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic Thumb needs write access to the file <b>'".$file."'</b> for proper installation." .
                                "<br/>Please check this and reinstall Magic Thumb.</span>";
                    fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magicthumb_file_'.md5($file).'_notification');
                }
                */
            }
        }
    }

    return $cancel;

}

function fn_magicthumb_uninstall() {

    $js_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ROOT . '/js');
    $module_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ADDONS . '/magicthumb');
    $jsFiles = array('/ajax', '/core');
    $suffix = '_packed';

    foreach($jsFiles as $fileName) {
        if(@is_file($module_directory . $fileName . '.js')) {
            @unlink($module_directory . $fileName . '.js');
        }
        if(@is_file($module_directory . $fileName . $suffix . '.js')) {
            @unlink($module_directory . $fileName . $suffix . '.js');
        }
    }
    if(@is_file($module_directory . '/tabs' . $suffix . '.js')) {
        @unlink($module_directory . '/tabs' . $suffix . '.js');
    }

    fn_magicthumb_send_stat('uninstall');

}

function fn_magicthumb_send_stat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v6.5.7' || 'working' == 'v3.0.20') {
        return;
    }

    $hostname = 'www.magictoolbox.com';
    $url = $_SERVER['HTTP_HOST'].preg_replace('/\/[^\/]*?\.php.*$/i', '', $_SERVER['REQUEST_URI']);
    $url = urlencode(urldecode($url));
    $platformVersion = defined('PRODUCT_VERSION') ? PRODUCT_VERSION : '';
    $path = "api/stat/?action={$action}&tool_name=magicthumb&license=trial&tool_version=v3.0.20&module_version=v6.5.7&platform_name=cscart&platform_version={$platformVersion}&url={$url}";
    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers  = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }
}
