<?php
if ( !defined('AREA') ) { die('Access denied'); }

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    return;
}

if ($mode == 'clear_all_items' || $mode == 'clear_unused_items') {

    $addon_options = db_get_field("SELECT options FROM ?:addons WHERE addon = ?s", $_REQUEST['addon']);
    $addon_options = fn_parse_addon_options($addon_options);
    if(isset($addon_options['cache-path-to-cache'])) {
        //$fullPathToCache = DIR_ROOT.$addon_options['cache-path-to-cache'];
        $pathToCache = $addon_options['cache-path-to-cache'];
    } else {
        //$fullPathToCache = DIR_IMAGES.'magictoolbox_cache';
        $pathToCache = str_replace(DIR_ROOT, '', DIR_IMAGES).'magictoolbox_cache';
    }
    $tool = fn_magicscroll_load();
    require_once(dirname(__FILE__) . '/../../core/magictoolbox.imagehelper.class.php');
    $imagehelper = new MagicToolboxImageHelperClass(DIR_ROOT, $pathToCache, $tool->params);
    $usedSubCache = $imagehelper->getOptionsHash();

    if(is_dir(DIR_ROOT.$pathToCache))
        fn_magicscroll_clearCache(DIR_ROOT.$pathToCache, ($mode == 'clear_all_items')?null:$usedSubCache);

    fn_set_notification('N', fn_get_lang_var('notice'), "Image cache was cleared.");

    $cacheInfo = fn_magicscroll_getCacheInfo(DIR_ROOT.$pathToCache, $usedSubCache);
    echo '<div id="'.$mode.'">'.$cacheInfo['totalCount'].' ('.fn_magicscroll_format_size($cacheInfo['totalSize']).')<!--'.$mode.'--></div>';

    exit;
}

function fn_magicscroll_clearCache($path, $usedSubCache = null) {

    $files = glob($path.DIRECTORY_SEPARATOR.'*');
    if($files !== FALSE && !empty($files)) {
        foreach($files as $file) {
            if(is_dir($file)) {
                if(!$usedSubCache || $usedSubCache != substr($file, strrpos($file, DIRECTORY_SEPARATOR)+1)) {
                    fn_magicscroll_clearCache($file);
                    @rmdir($file);
                }
            } else {
                @unlink($file);
            }
        }
    }
    return;
}

?>