<?php

if ( !defined('AREA') ) { die('Access denied'); }

//options enabled by default
define('ENABLED_OPTIONS', '|enable-effect|arrows|orientation|thumb-max-width|thumb-max-height|show-message|items|show-image-title|fullscreen|');
define('MT_DS', DIRECTORY_SEPARATOR);

function fn_magic360($output, &$view) {

    if(isset($view->_tpl_vars['title'])) return $output;//avoid a second call

    $tool = fn_magic360_load();
    $tpl_vars = $view->get_template_vars();
    $tool->params->setValue('index-script', $tpl_vars['index_script']);

    if(false) {
        //this is block
        $block = $view->_tpl_vars['block'];
        $GLOBALS['magictoolbox']['block'] = &$block;
        $block_fillings = isset($block['properties']['fillings'])?$block['properties']['fillings']:false;
        if($block_fillings && ($block['properties']['list_object'] == 'products'
                              )) {
            $allowable_block_fillings = array('newest', 'recent_products', 'popularity', 'bestsellers', 'rating', 'manually'
                                             );
            if(in_array($block_fillings,$allowable_block_fillings) && !$tool->params->checkValue('enable-effect', 'No', $block_fillings)) {
                $tool->params->setValue('block-id', $block['block_id']);
                $items = $view->get_template_vars('items');
                if($items) {
                    if($block['properties']['appearances'] == 'addons/hot_deals_block/blocks/hot_deals.tpl') {
                        return $output;
                        //Hot Deals specifically
                        $GLOBALS['magictoolbox']['hot_deals_block'] = true;
                    }
                    $tool->params->setValue('headers', 'Yes');
                }
            }
        }
    } else {
        //this is not block
        $GLOBALS['magictoolbox']['block'] = null;
        //if(isset($view->_tpl_vars['left']) || isset($view->_tpl_vars['right']) || isset($view->_tpl_vars['top']) || isset($view->_tpl_vars['bottom'])) {
            //not all content
        //} else {
        if(!isset($view->_tpl_vars['left']) && !isset($view->_tpl_vars['right']) && !isset($view->_tpl_vars['top']) && !isset($view->_tpl_vars['bottom'])) {
            //all content
            if(($_REQUEST['dispatch'] == 'products.view') && !$tool->params->checkValue('enable-effect', 'No', 'product')) {
                $tool->params->setValue('block-id', '');
                $products = array($tpl_vars['product']);
                $output = fn_magic360_parse_circle($output, $products, 'product');
                if(!$tool->params->paramExists('headers')) $tool->params->setValue('headers', 'Yes');
            }
            else if($_REQUEST['dispatch'] == 'products.options') {//ajax request
                $page = 'unknown';
                if(isset($_REQUEST['result_ids'])) {
                    if(strpos($_REQUEST['result_ids'], 'list_image_update_') !== false) {
                        if(strpos($_SERVER['HTTP_REFERER'], 'dispatch=products.search') !== false) {
                            $page = 'search';
                        } else if(strpos($_SERVER['HTTP_REFERER'], 'dispatch=categories.view') !== false) {
                            $page = 'category';
                        }
                    }
                    else if(strpos($_REQUEST['result_ids'], 'product_images_') !== false)
                        $page = 'product';
                }
                if($tool->params->profileExists($page) && !$tool->params->checkValue('enable-effect', 'No', $page)) {
                    $tool->params->setValue('block-id', '');
                    $products = array($tpl_vars['product']);
                    $output = fn_magic360_parse_circle($output, $products, $page);
                    $tool->params->setValue('headers', 'No');
                }
            }
            //if($tool->params->checkValue('headers', 'Yes')) {
            $includeHeaders = $tool->params->getValue('headers');
            if($includeHeaders == 'Yes' || !$includeHeaders && (strpos($output, "Magic360") !== false)) {
                $output = fn_magic360_headers($output);
            }
        }
    }
    return $output;
}

function fn_magic360_load($block = false) {
    if(!isset($GLOBALS['magictoolbox']['magic360'])) {
        require_once(dirname(__FILE__) . '/core/magic360.module.core.class.php');
        $GLOBALS['magictoolbox']['magic360'] = new Magic360ModuleCoreClass();
        $tool = &$GLOBALS['magictoolbox']['magic360'];

        //CS-Cart 2.x.x
        $params = Registry::get('addons.magic360');
        //$tpl_vars = & Registry::get('view')->_tpl_vars;

        //CS-Cart v 1.x.x
        //$tpl_vars = & $GLOBALS['smarty']->_tpl_vars;
        //define(DIR_ROOT, CSCART_DIR);
        //$tool->params->setValue('cscart_config_http_path', $GLOBALS['cscart_http_dir']);
        //$tool->params->setValue('cscart_config_http_images_path', IMAGES_STORAGE_WEB_DIR);
        //if(!defined('IMAGES_STORAGE_DIR') && isset($GLOBALS['images_storage_dir'])) {
        //    define('DIR_IMAGES', $GLOBALS['images_storage_dir']);
        //}
        //if(!defined('DIR_IMAGES') && defined('IMAGES_STORAGE_DIR')) {
        //    define('DIR_IMAGES', IMAGES_STORAGE_DIR);
        //}


        foreach($params as $p_name => $p_value) {
            $param_value = '';
            if(strpos($p_value, $p_name . '-') === 0) {
                $param_value = substr($p_value, strlen($p_name)+1);
            } else {
                $param_value = $p_value;
            }
            if(strpos($p_name, 'general-') === 0) {
                $tool->params->setValue(substr($p_name, 8), $param_value);
            } else {
                $pattern = '/(product|category|search|newest|recent_products|popularity|bestsellers|rating|manually|banners)-(.*)/is';
                $matches = array();
                if(preg_match($pattern, $p_name, $matches)) {
                    if(isset($params[$matches[1] . "-enabled-options"])) $enabledOptions = $params[$matches[1] . "-enabled-options"];
                    else $enabledOptions = ENABLED_OPTIONS;
                    if(strpos($enabledOptions, '|' . $matches[2] . '|') !== false
                      ) {
                        $tool->params->setValue($matches[2], $param_value, $matches[1]);
                    }
                }
            }
        }

        $detailed_image_width = Registry::get('settings.Thumbnails.product_detailed_image_width');
        $detailed_image_height = Registry::get('settings.Thumbnails.product_detailed_image_height');
        if(empty($detailed_image_width)) $detailed_image_width = 0;
        if(empty($detailed_image_height)) $detailed_image_height = 0;
        $tool->params->setValue('detailed-max-width', $detailed_image_width);
        $tool->params->setValue('detailed-max-height', $detailed_image_height);
        if(!$detailed_image_width && !$detailed_image_height) {
            $tool->params->setValue('resize-original-image', 'No');
        } else {
            $tool->params->setValue('resize-original-image', 'Yes');
        }
    } else {
        $tool = &$GLOBALS['magictoolbox']['magic360'];
    }
    return $tool;
}

function fn_magic360_headers($contents) {
    $tool = fn_magic360_load();
    $tool->params->resetProfile();
    $http_path = Registry::get('config.http_path');
    $headers = '';
    $headers .= $tool->getHeadersTemplate($http_path.'/addons/magic360/core');
    if(!defined('MAGICTOOLBOX_FUNC_JS_INCLUDED')) {
        $headers .= '<script type="text/javascript" src="'.$http_path.'/addons/magic360/func.js"></script>'."\r\n";
        define('MAGICTOOLBOX_FUNC_JS_INCLUDED', true);
    }

    //$headers .= '<style type="text/css">.central-column{overflow: visible !important;}';
    //$headers .= ' div.MagicToolboxSelectorsContainer img {border: 0px;}';

    //$headers .= '</style>';

    $pattern = '<!-- Magic (Zoom|Thumb)(?: Plus)? CS-Cart module[^>]*+>'.
               '[^<]*+<link\b[^>]*?href="[^"]*?magic(?:zoom(?:plus)?|thumb|scroll)\.css"[^>]*+>';
    $matches = array();
    if(preg_match_all('#'.$pattern.'#is', $contents, $matches, PREG_SET_ORDER)) {
        if($matches[0][1] == 'Zoom') {
            //NOTE: place magic360 headers before magiczoom(plus) headers
            $contents = str_replace($matches[0][0], $headers."\r\n".$matches[0][0], $contents);
        } else if(isset($matches[1])) {
            //NOTE: place magic360 headers before magicscroll headers (after magicthumb)
            $contents = str_replace($matches[1][0], $headers."\r\n".$matches[1][0], $contents);
        } else {
            $contents = preg_replace('#</head>#is', $headers.'</head>', $contents, 1);
        }
    } else
    $contents = preg_replace('#</head>#is', $headers . '</head>', $contents, 1);

    if(defined('MAGICTOOLBOX_JS_FILES_SUBSTITUTION')) {
        return $contents;
    }
    define('MAGICTOOLBOX_JS_FILES_SUBSTITUTION', true);
    //absolute path
    $module_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ADDONS.'/magic360');

    $jsFiles = array('/ajax', '/core');
    if(!defined('PRODUCT_VERSION') || version_compare(PRODUCT_VERSION, '2.2.0', '<')) {
        $jsFiles[] = '/tabs';
    }

    //to prevent page break as a result not property install
    foreach($jsFiles as $key => $fileName) {
        if(!file_exists($module_directory.$fileName.'.js')) {
            unset($jsFiles[$key]);
        }
    }

    if(!empty($jsFiles)) {
        if(Registry::get('config.tweaks.js_compression')) {
            //$dir_cache = substr(DIR_CACHE, strlen(DIR_ROOT));
            $js_path = Registry::get('config.cache_path') . '/js';
            $suffix = '_packed';
            foreach($jsFiles as $fileName) {
                if(!is_file($module_directory.$fileName.$suffix.'.js') && is_writeable($module_directory)) {
                    if(!class_exists('JavaScriptPacker')) include_once(DIR_LIB.'packer/class.JavaScriptPacker.php');
                    $packer = new JavaScriptPacker(fn_get_contents($module_directory.$fileName.'.js'));
                    fn_put_contents($module_directory.$fileName.$suffix.'.js', $packer->pack());
                }
            }
        } else {
            $js_path = Registry::get('config.current_path') . '/js';
            $suffix = '';
        }

        //relative to the site root
        $module_path = Registry::get('config.current_path').substr(DIR_ADDONS, strlen(DIR_ROOT)).'magic360';

        foreach($jsFiles as $fileName) {
            $pattern = preg_quote($js_path.$fileName.'.js', '/');
            $contents = preg_replace('/'.$pattern.'/is', $module_path.$fileName.$suffix.'.js', $contents);
        }
    }

    return $contents;
}

function fn_magic360_parse_circle($contents, $products, $block) {
    $tool = fn_magic360_load();
    $tool->params->setProfile($block);
    $tool->params->setValue('headers', 'No');

    if(!$tool->params->checkValue('enable-effect', 'No')) {
        switch($block) {
            case 'product':
                $rezult = db_get_row('SELECT gallery, columns FROM ?:addon_magic360_images WHERE id = ?i', $products[0]['product_id']);
                if(empty($rezult) || empty($rezult['gallery'])) break;
                $magic360Images = explode(';', $rezult['gallery']);
                $magic360ImagesCount = count($magic360Images);
                $magic360Columns = $rezult['columns'];
                $magic360Rows = 1;
                if($rezult['columns'] && $rezult['columns'] < $magic360ImagesCount) {
                    $magic360Rows = floor($magic360ImagesCount/intval($rezult['columns']));
                }

                $baseImagePath = Registry::get('config.images_path').'magic360/';//Registry::get('config.http_images_path')
                $images_data = array();

                $old_locale = setlocale(LC_ALL, NULL);
                setlocale(LC_ALL, 'en_US.UTF8');

                foreach($magic360Images as $image_id => $image) {
                    //DIR_IMAGES.'magic360/';
                    $images_data[$image_id]['medium'] = fn_magic360_create_thumb($baseImagePath.$image, 'thumb', $tool, $products[0]['product_id']);
                    $images_data[$image_id]['img'] = fn_magic360_create_thumb($baseImagePath.$image, 'original', $tool, $products[0]['product_id']);
                }

                $tool->params->setValue('columns', $magic360Columns, 'product');

                /*
                $container_width = (int)$tool->params->getValue('thumb-max-width');
                if(!$container_width) {
                    reset($images_data);
                    $first_image = current($images_data);
                    $image_path_full = str_replace(Registry::get('config.current_path'), $first_image['img'], DIR_ROOT);
                    $first_image_size = getimagesize($image_path_full);
                    $container_width = $first_image_size[0];
                }
                /**/

                setlocale(LC_ALL, $old_locale);

                $toolHTML = $tool->getMainTemplate($images_data, array("id" => "Magic360Image".$block.$products[0]['product_id']));

                if(isset($GLOBALS['magictoolbox']['cooperative_mode'])) {
                    $s360IconPath = $tool->params->getValue('icon');
                    if(!empty($s360IconPath) && file_exists(DIR_IMAGES.$s360IconPath)) {
                        $magic360SelectorClass = 'm360-selector active-selector';
                        if($tool->params->getValue('original-layout', 'product')) {
                            $magic360SelectorClass .= ' cm-thumbnails-mini';
                        }
                        $magic360Selector = '<a class="'.$magic360SelectorClass.'" title="360" href="#" onclick="return false;"><img src="'.
                            fn_magic360_create_thumb(Registry::get('config.images_path').$s360IconPath, 'selector', $tool, '360selector').
                            '" alt="360" /></a>';
                        if(in_array($GLOBALS['magictoolbox']['cooperative_mode'], array('magiczoom', 'magiczoomplus'))) {
                            $magic360Selector = preg_replace('#<a\b[^>]+?class="#i', '$0zoom-with-360 ', $magic360Selector);
                        }
                        $contents = str_replace('<!-- MAGIC360SELECTOR -->', $magic360Selector, $contents);
                    } else {
                        $contents = str_replace('<!-- MAGIC360SELECTOR -->', '', $contents);
                    }
                    $contents = str_replace('<!-- MAGIC360 -->', $toolHTML, $contents);
                    $tool->params->setValue('headers', 'Yes');
                    break;
                }

                //$toolHTML = '<div class="MagicToolboxContainer" style="width:'.$container_width.'px;">'.$toolHTML.'</div>';
                $toolHTML = '<div class="MagicToolboxContainer">'.$toolHTML.'</div>';

                if(isset($products[0]['main_pair']['icon'])) {
                    $localName = pathinfo($products[0]['main_pair']['icon']['image_path']);
                    $pattern = preg_quote($localName['dirname'].'/'.$localName['filename'], '/').'\\.(?:jpg|png|gif)';
                } elseif(isset($products[0]['main_pair']['detailed'])) {
                    $localName = pathinfo($products[0]['main_pair']['detailed']['image_path']);
                    $pattern = '[^"]*\\/'.preg_quote($localName['filename'], '/').'\\.(?:jpg|png|gif)';
                } else {
                    $pattern = '[^"]*no_image\\.gif';
                }
                // for 'Compact list' mode
                //$pattern = preg_replace('/\\\\\\/(?:product|product_option)\\\\\\/([0-9]+?\\\\\\/)?/is', '((\\/thumbnails\\/thumbnail_[0-9]+__)|(\\/product\\/$1)|(\\/thumbnails\\/[0-9]+?\\/([0-9]+?\\/)?([0-9]+?\\/)?))', $pattern);
                $pattern = preg_replace('/\\\\\\/(?:product|product_option)\\\\\\/([0-9]+?\\\\\\/)?/is', '(?:(?:\\/thumbnails\\/thumbnail_[0-9]+__)|(?:\\/product\\/$1)|(?:\\/thumbnails\\/[0-9]+?\\/(?:[0-9]+?\\/)?(?:[0-9]+?\\/)?))', $pattern);
                $pattern = '<img[^>]*?src="' . $pattern . '"[^>]*+>';
                //$pattern = '(?:<a[^>]*>)?' . $pattern . '(?:<\/a>)?';
                $pattern = '(<a[^>]*+>[^<]*+)?'.$pattern.'(?(1)[^<]*+<\/a>)';

                //NOTE: cut mini thumbnails (inside product thumbnails list)
                $contents = preg_replace('/<a[^>]+?class="[^"]*?cm-thumbnails-mini[^"]*"[^>]*>.*?<\/a>/is', '', $contents);
                preg_match('/' . $pattern . '/is', $contents, $matches);
                $contents = str_replace($matches[0], $toolHTML, $contents);
                $contents = preg_replace('/<p[^>]+?id="(?:detailed_box_|box_det_img_link_)' . intval($products[0]['product_id']) . '(?:_[0-9]+)?"[^>]*>.*?<\/p>/is', '', $contents);
                $contents = preg_replace('/<a[^>]+?id="(?:detailed_href[0-9]*_|det_img_link_)' . intval($products[0]['product_id']) . '(?:_[0-9]+)?(?:_mini)?"[^>]*>.*?<\/a>/is', '', $contents);
                //NOTE: cut product thumbnails list
                $contents = preg_replace('/<ul[^>]+?id="product_thumbnails"[^>]*>[^<]*(?:<li>[^<]*<\/li>[^<]*)*<\/ul>/is', '', $contents);
                $contents = str_replace('\'circular\'', '\'both\'', $contents);
                $tool->params->setValue('headers', 'Yes');
                break;
        }
    }
    return $contents;
}


function fn_magic360_create_thumb($src, $size, &$tool, $pid) {

    static $imageDir = '';
    static $imagesPathQuoted = '';
    static $imagehelper = null;

    if($imagehelper === null) {
        $imagesPathQuoted = preg_quote(Registry::get('config.images_path'), '/');
        $imageDir = str_replace(DIR_ROOT, '', DIR_IMAGES);
        //$config['images_path'] = $config['current_path'] . '/images/';
        require_once(dirname(__FILE__).'/core/magictoolbox.imagehelper.class.php');
        $imagehelper = new MagicToolboxImageHelperClass(DIR_ROOT, $imageDir.'magictoolbox_cache', $tool->params, null, Registry::get('config.http_path'));
    }

    $src = htmlspecialchars_decode($src, ENT_QUOTES);

    preg_match('/^.*?'.$imagesPathQuoted.'(.*?)$/is', $src, $matches);
    if(empty($matches)) return $src;
    $img = $imageDir.$matches[1];

    $thumb = $imagehelper->create($img, $size, $pid);
    //NOTE: spike to get real size of image
    $GLOBALS['magictoolbox']['file_path'] = $imagehelper->file;
    if(MT_DS != '/') {
        $thumb = str_replace(MT_DS, '/', $thumb);
    }

    return $thumb;
}

function fn_magic360_css() {

    return '
<style type="text/css">
#tabs_content_magic360 .form-field { padding: 6px 5px 6px 250px !important; }
#tabs_content_magic360 .form-field > label { margin-left: -250px !important; width: 240px !important;}
</style>
';

}

function fn_magic360_js_functions() {

    if(Registry::get("addons.magic360.status") === 'D') {
        $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic 360 module should be enabled for proper operation of the settings page." .
                   "<br/>Please enable it before save settings.</span>";
        fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('warning').'</span>', $message, true, 'magic360_module_disabled_notification');
    }
    //$modulePath = Registry::get('config.current_path') . substr(DIR_ADDONS, strlen(DIR_ROOT)) . 'magic360';
    return '
        <script type="text/javascript">
            //<![CDATA[
            function fn_magic360_prepare_custom_options(block, skip) {
                skip = (skip || \'\').split(\'|\');
                skip.push(\'enable-effect\');
                var enabledOptionsID = "#addon_option_magic360_" + block + "-enabled-options";
                var enabledOptions = $(enabledOptionsID).val();
                var sectionID = "#content_magic360_magic360_" + block;
                $(sectionID + " div.form-field").
                 each(function(){
                        $(this).
                         find("select, input[type=\'text\']").
                         each(function(){
                                var optionId = this.id.replace("addon_option_magic360_" + block + "-","");
                                if(jQuery.inArray(optionId, skip) !== -1) {
                                    return;
                                }
                                if(enabledOptions.indexOf("|" + optionId + "|") == -1) {
                                    $(this).attr("disabled", true).after("&nbsp;&nbsp;<a href=\"#\" >edit</a>");
                                } else {
                                    $(this).after("&nbsp;&nbsp;<a href=\"#\" >use default option</a>");
                                }
                                $(this).next().
                                    bind("click", {optionId: optionId, enabledOptionsID: enabledOptionsID},
                                                    function(event) {
                                                        var enabledOptions = $(event.data.enabledOptionsID).val();
                                                        if($(this).html() == "edit") {
                                                            $(this).html("use default option").prev().removeAttr("disabled");
                                                            enabledOptions = enabledOptions.concat(event.data.optionId + "|");
                                                        } else {
                                                            $(this).html("edit").prev().attr("disabled", true).val($("#addon_option_magic360_general-" + event.data.optionId).val().replace("general-", block + "-"));
                                                            var pattern = new RegExp("\\\\|" + event.data.optionId + "\\\\|", "g");
                                                            enabledOptions = enabledOptions.replace(pattern, "|");
                                                        }
                                                        $(event.data.enabledOptionsID).val(enabledOptions);
                                                        return false;
                                                }
                                        );

                              }).
                         end().
                         find("input[type=\'radio\']:checked").
                         each(function(){
                                var optionId = this.name.replace("addon_data[options][" + block + "-","");
                                optionId = optionId.replace("]","");
                                if(jQuery.inArray(optionId, skip) !== -1) {
                                    return;
                                }
                                if(enabledOptions.indexOf("|" + optionId + "|") == -1) {
                                    $(this.parentNode).find("input").attr("disabled", true).end().
                                     find(":last-child").after("&nbsp;&nbsp;<a href=\"#\" >edit</a>");
                                } else {
                                    $(this.parentNode).find(":last-child").after("&nbsp;&nbsp;<a href=\"#\" >use default option</a>");
                                }
                                $(this.parentNode).find(":last-child").
                                    bind("click", {optionId: optionId, enabledOptionsID: enabledOptionsID},
                                                    function(event) {
                                                        var enabledOptions = $(event.data.enabledOptionsID).val();
                                                        if($(this).html() == "edit") {
                                                            $(this).html("use default option");
                                                            $(this.parentNode).find("input").removeAttr("disabled");
                                                            enabledOptions = enabledOptions.concat(event.data.optionId + "|");
                                                        } else {
                                                            $(this).html("edit");
                                                            $(this.parentNode).find("input").attr("disabled", true).val([$("#content_magic360_magic360_general div.form-field input[name=\'addon_data[options][general-" + event.data.optionId + "]\']:checked").val().replace("general", block)]);
                                                            var pattern = new RegExp("\\\\|" + event.data.optionId + "\\\\|", "g");
                                                            enabledOptions = enabledOptions.replace(pattern, "|");
                                                        }
                                                        $(event.data.enabledOptionsID).val(enabledOptions);
                                                        return false;
                                                }
                                        );

                              });
                      });
            }
            function fn_magic360_clear_cache_field(data, params) {
                if(data.html) {
                    for (var k in data.html) {
                        $("#addon_option_magic360_cache-total-items").val(data.html[k]);
                        $("#addon_option_magic360_cache-unused-items").val("0 (0 bytes)");
                        break;
                    }
                }
            }
            //]]>
        </script>
';

}

function fn_magic360_prepare_custom_options($block) {

    static $addon_options;
    $headersBind = '';
    $generalParamsChangeBind = '';
    $enabledOptions = '';
    $includeOptionsJs = '';
    $initOptionsValidation = '';
    $magicscrollIcon = '';

    if(!isset($addon_options)) {
        $addon_options = db_get_field("SELECT options FROM ?:addons WHERE addon = ?s", $_REQUEST['addon']);
        $addon_options = fn_parse_addon_options($addon_options);
    }

    switch($block) {
        case 'general':
            if(isset($addon_options['cache-path-to-cache'])) {
                $pathToCache = $addon_options['cache-path-to-cache'];
            } else {
                $pathToCache = str_replace(DIR_ROOT, '', DIR_IMAGES).'magictoolbox_cache';
            }
            $tool = fn_magic360_load();
            require_once(dirname(__FILE__) . '/core/magictoolbox.imagehelper.class.php');
            $imagehelper = new MagicToolboxImageHelperClass(DIR_ROOT, $pathToCache, $tool->params);
            $usedSubCache = $imagehelper->getOptionsHash();
            $cacheInfo = fn_magic360_getCacheInfo(DIR_ROOT.$pathToCache, $usedSubCache);
            return  '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magic360_cache-path-to-cache">Path to cache folder'.
                    '(<a onclick="return false;" class="cm-tooltip" title="Relative for site base path.">?</a>)<span class="hidden cm-tooltip-text">Relative for site base path.</span>'.
                    '</label>'.
                    '<input type="text" name="addon_data[options][cache-path-to-cache]" id="addon_option_magic360_cache-path-to-cache" value="'.$pathToCache.'" class="input-text" style="width:352px;" disabled="disabled" />'.
                    '</div>'.
                    '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magic360_cache-total-items">Total items:</label>'.
                    '<input type="text" name="addon_data[options][cache-total-items]" id="addon_option_magic360_cache-total-items" value="'.$cacheInfo['totalCount'].' ('.fn_magic360_format_size($cacheInfo['totalSize']).')" class="input-text" disabled="disabled" />'.
                    '</div>'.
                    '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magic360_cache-unused-items">Unused items:</label>'.
                    '<input type="text" name="addon_data[options][cache-unused-items]" id="addon_option_magic360_cache-unused-items" value="'.$cacheInfo['unusedCount'].' ('.fn_magic360_format_size($cacheInfo['unusedSize']).')" class="input-text" disabled="disabled" />'.
                    '</div>'.
                    '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magic360_cache-what-clear">Empty cache:</label>'.
                    '<select id="addon_option_magic360_cache-what-clear" onchange="$(\'#magic360_clear_cache_field\').attr(\'href\', \''.INDEX_SCRIPT.'?dispatch=cache.\'+this.value).attr(\'rev\', this.value);">'.
                    '<option  selected="selected" value="clear_unused_items">Delete unused items</option>'.
                    '<option value="clear_all_items">Delete all items</option>'.
                    '</select>'.
                    '&nbsp;<a name="magic360_clear_cache_field" id="magic360_clear_cache_field" href="'.INDEX_SCRIPT.'?dispatch=cache.clear_unused_items" class="cm-ajax cm-confirm" rev="clear_unused_items" >Clear</a>'.
                    '</div>'
                    ;
            break;
        case 'product':
            //only after last block
            $headersBind = '$("#tabs_content_magic360 h2.subheader").css({\'background-color\': \'#F4F4F4\', \'cursor\': \'pointer\'}).slice(0, 1).prepend("&nbsp;<img alt=\"\" src=\"./skins/basic/admin/images/icons/section_expanded.gif\">").end().slice(1).prepend("&nbsp;<img alt=\"\" src=\"./skins/basic/admin/images/icons/section_collapsed.gif\">").end().bind("click", function(){$(this).find("img").each(function(){if(this.src.indexOf("section_collapsed") == -1) this.src = this.src.replace("section_expanded", "section_collapsed"); else this.src = this.src.replace("section_collapsed", "section_expanded");}).end().nextAll().each(function slideToggleNode(){if(typeof slideToggleNode.stop == "undefined" ) {if(this.tagName=="H2") slideToggleNode.stop = true; else $(this).slideToggle(250);}}); return false;}).slice(1, 2).nextAll("div.form-field").css("display", "none");$("#tabs_content_magic360 div").slice(1).find("h2.subheader:first").nextAll("div.form-field").css("display", "none");';
            //old variant
            //$headersBind = '$("#tabs_content_magic360 h2.subheader").css({\'background-color\': \'#F4F4F4\', \'cursor\': \'pointer\'}).each(function(){$(this).prepend("&nbsp;<img alt=\"\" src=\"./skins/basic/admin/images/icons/section_expanded.gif\">")}).bind("click", function(){$(this).find("img").each(function(){if(this.src.indexOf("section_collapsed") == -1) this.src = this.src.replace("section_expanded", "section_collapsed"); else this.src = this.src.replace("section_collapsed", "section_expanded");}).end().nextAll().each(function slideToggleNode(){if(typeof slideToggleNode.stop == "undefined" ) {if(this.tagName=="H2") slideToggleNode.stop = true; else $(this).slideToggle(250);}}); return false;}).slice(1).click();';
            $generalParamsChangeBind = '
$("#content_magic360_magic360_general").find("input[type=\'text\']").bind("change", function(){
var block_array = ["product", "category", "search", "newest", "recent_products", "popularity", "bestsellers", "rating", "manually", "banners"];
var optionId = this.id.replace("addon_option_magic360_general-","");
var optioVal = $(this).val();
for(block in block_array) {
    $("#content_magic360_magic360_" + block_array[block]).
    find("#addon_option_magic360_" + block_array[block] + "-" + optionId + ":disabled").val(optioVal);
}
}).
end().find("select").bind("change", function(){
var block_array = ["product", "category", "search", "newest", "recent_products", "popularity", "bestsellers", "rating", "manually", "banners"];
var optionId = this.id.replace("addon_option_magic360_general-","");
var optioVal = $(this).val().replace("general-" + optionId + "-", "");
for(block in block_array) {
    $("#content_magic360_magic360_" + block_array[block]).
    find("#addon_option_magic360_" + block_array[block] + "-" + optionId + ":disabled").val(block_array[block] + "-" + optionId + "-" + optioVal);
}
}).
end().find("input[type=\'radio\']").bind("change", function(){
var block_array = ["product", "category", "search", "newest", "recent_products", "popularity", "bestsellers", "rating", "manually", "banners"];
var optionId = this.name.replace("addon_data[options][general-","");
optionId = optionId.replace("]","");
var optioVal = $(this).val().replace("general-" + optionId + "-", "");
for(block in block_array) {
    $("#content_magic360_magic360_" + block_array[block]).
    find("input[name=\'addon_data[options][" + block_array[block] + "-" + optionId + "]\']:disabled").val([block_array[block] + "-" + optionId + "-" + optioVal]);
}
});';
        default:
            if(isset($addon_options[$block . '-enabled-options'])) {
                $enabledOptions = $addon_options[$block . '-enabled-options'];
            } else {
                $enabledOptions = ENABLED_OPTIONS;
            }
    }

    $tool = fn_magic360_load();
    $skip = array();

    if($tool->type == 'standard') {
        foreach($tool->params->getParams() as $param) {
            if(in_array($param['group'], array('General', 'Scroll', 'Scroll Arrows', 'Scroll Slider', 'Scroll effect', 'Multiple images'))) {
                $skip[] = $param['id'];
            }
        }
    }

    $skip = implode('|', $skip);

    return $includeOptionsJs . '
        <input type="hidden" name="addon_data[options][' . $block . '-enabled-options]" id="addon_option_magic360_' . $block . '-enabled-options" value="' . $enabledOptions . '" />
        <script type="text/javascript">
            //<![CDATA[
            fn_magic360_prepare_custom_options("' . $block . '", \'' .$skip . '\');
            ' . $headersBind . $generalParamsChangeBind . $initOptionsValidation . $magicscrollIcon . '
            //]]>
        </script>
    ';
}

function fn_magic360_getCacheInfo($path, $usedSubCache = null) {

    $totalSize = 0;
    $totalCount = 0;
    $usedSize = 0;
    $usedCount = 0;
    if (is_dir($path))
    if ($handle = opendir($path)) {
        while (false !== ($file = readdir($handle))) {
            $next = $path . DIRECTORY_SEPARATOR . $file;
            if ($file != '.' && $file != '..' && !is_link($next)) {
                if (is_dir($next)) {
                    $result = fn_magic360_getCacheInfo($next);
                    if($file == $usedSubCache) {
                        $usedSize += $result['totalSize'];
                        $usedCount += $result['totalCount'];
                    }
                    $totalSize += $result['totalSize'];
                    $totalCount += $result['totalCount'];
                } elseif (is_file($next)) {
                    $totalSize += filesize($next);
                    $totalCount++;
                }
            }
        }
        closedir($handle);
    }
    return array('totalSize' => $totalSize, 'totalCount' => $totalCount, 'unusedSize' => $totalSize-$usedSize, 'unusedCount' => $totalCount-$usedCount);
}

function fn_magic360_format_size($size) {
    $units = array(' bytes', ' KB', ' MB', ' GB', ' TB');
    for ($i = 0; $size >= 1024 && $i < 4; $i++) $size /= 1024;
    return round($size, 2).$units[$i];
}

function fn_magic360_install() {

    $js_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ROOT . '/js');
    $module_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ADDONS . '/magic360');
    $jsFiles = array('/ajax', '/core');
    $suffix = '_packed';
    $cancel = false;

    if(!class_exists('JavaScriptPacker'))
        include_once(DIR_LIB . 'packer/class.JavaScriptPacker.php');

    foreach($jsFiles as $fileName) {
        if(@is_file($module_directory . $fileName . '.js')) {
           //installed
        } else {
            if(@is_file($js_directory . $fileName . '.js') && is_writeable($module_directory)) {
                switch($fileName) {
                    case '/ajax':
                        // modify ajax.js
                        $c = file_get_contents($js_directory . $fileName . '.js');
                        $stop = '
        if(params && params.result_ids) {
            if((params.result_ids.search(/(?:product_images_|list_image_update_|product_quick_view_)\d+(?:_update)?|product_filters_\*/i) != -1) || (params.result_ids == \'pagination_contents\')) {
                var productIdMatch = params.result_ids.match(/.*?(?:product_images_|list_image_update_|product_quick_view_)([0-9]+)(?:_update)?.*/i);
                if(productIdMatch) {
                    fn_magictoolbox_tool_update("stop", "product", productIdMatch[1]);
                } else {
                    fn_magictoolbox_tool_update("stop", "category", "");
                }
            }
        }';
                        $start = '
        if(params && params.result_ids) {
            if((params.result_ids.search(/(?:product_images_|list_image_update_|product_quick_view_)\d+(?:_update)?|product_filters_\*/i) != -1) || (params.result_ids == \'pagination_contents\')) {
                var productIdMatch = params.result_ids.match(/.*?(?:product_images_|list_image_update_|product_quick_view_)([0-9]+)(?:_update)?.*/i);
                if(productIdMatch) {
                    fn_magictoolbox_tool_update("start", "product", productIdMatch[1]);
                } else {
                    fn_magictoolbox_tool_update("start", "category", "");
                }
            }
        }';
                        $c = preg_replace('/(ajaxRequest\: function\(url, params\)\s+?\{)/', '$1' . $stop, $c);
                        $c = str_replace('jQuery.toggleStatusBox(\'hide\');', 'jQuery.toggleStatusBox(\'hide\');' . $start, $c);
                        file_put_contents($module_directory . $fileName . '.js', $c);

                        $packer = new JavaScriptPacker(fn_get_contents($module_directory . $fileName . '.js'));
                        fn_put_contents($module_directory . $fileName . $suffix . '.js', $packer->pack());

                        break;
                    case '/core':
                        //modify core.js file
                        $c = file_get_contents($js_directory . $fileName . '.js');

                        $pattern = 'for (var k in data) {';
                        $replace = 'for (var k in data) { if(!data.hasOwnProperty(k)) {continue;}';
                        $c = str_replace($pattern, $replace, $c);

                        $pattern = '/(fn_scroller_init_callback[^\{]*\{)/i';
                        $replace = "$1\n\t\t\tcarousel.options.wrap = 'both';\n";
                        $c = preg_replace($pattern, $replace, $c);

                        file_put_contents($module_directory . $fileName . '.js', $c);

                        $packer = new JavaScriptPacker(fn_get_contents($module_directory . $fileName . '.js'));
                        fn_put_contents($module_directory . $fileName . $suffix . '.js', $packer->pack());

                        break;
                }
            } else {
                //can't install
                $cancel = true;
                if(!is_writeable($module_directory) && !fn_notification_exists('E', 'magic360_module_directory_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic 360 needs write access to the folder <b>'" . $module_directory . "'</b> for proper installation." .
                               "<br/>Please check this and reinstall Magic 360.</span>";
                    fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magic360_module_directory_notification');
                }
                if(!@is_file($js_directory . $fileName . '.js') && !fn_notification_exists('E', 'magic360_file' . $fileName . '_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic 360 needs read access to the file <b>'" . $js_directory . $fileName . ".js'</b> for proper installation." .
                               "<br/>Please check this and reinstall Magic 360.</span>";
                    fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magic360_file' . $fileName . '_notification');
                }
            }
        }
    }

    if(!is_file($module_directory . '/tabs' . $suffix . '.js')) {
        $packer = new JavaScriptPacker(fn_get_contents($module_directory . '/tabs.js'));
        fn_put_contents($module_directory . '/tabs' . $suffix . '.js', $packer->pack());
    }

    //fix url's in css files
    $cancel = fn_magic360_fix_css();

    @copy($module_directory.'/360icon.png', DIR_IMAGES.'360icon.png');

    if($cancel) {
        $args = func_get_args();
        if(!empty($args)) fn_redirect("addons.manage");
    }


    fn_magic360_send_stat('install');

}

function fn_magic360_fix_css() {

    $cancel = false;

    $path = dirname(__FILE__).'/core';

    $resourcesPath = Registry::get('config.current_path').substr(DIR_ADDONS, strlen(DIR_ROOT)).'magic360/core';
    $resourcesPath = str_replace(array("//", "\\"), array("/", "/"), $resourcesPath);
 
    $list = glob($path.'/*');
    $files = array();
    if(is_array($list)) {
        for($i = 0; $i < count($list); $i++) {
            if(is_dir($list[$i])) {
                if(!in_array(basename($list[$i]), array('.svn', '.git'))) {
                    $add = glob($list[$i].'/*');
                    if(is_array($add)) {
                        $list = array_merge($list, $add);
                    }
                }
            } else if(preg_match('#\.css$#i', $list[$i])) {
                $files[] = $list[$i];
            }
        }
    }

    foreach($files as $file) {
        $cssPath = dirname($file);
        $cssRelPath = str_replace($path, '', $cssPath);
        $toolPath = $resourcesPath.$cssRelPath;
        $pattern = '#url\(\s*(\'|")?(?!data:|mhtml:|http(?:s)?:|/)([^\)\s\'"]+?)(?(1)\1)\s*\)#is';
        $replace = 'url($1'.$toolPath.'/$2$1)';
        $fileContents = file_get_contents($file);
        $fixedFileContents = preg_replace($pattern, $replace, $fileContents);
        if($fixedFileContents != $fileContents) {
            if(is_writeable($file)) {
                file_put_contents($file, $fixedFileContents);
            } else {
                //NOTE: install module anyway
                /*
                $cancel = true;
                if(!fn_notification_exists('E', 'magic360_file_'.md5($file).'_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic 360 needs write access to the file <b>'".$file."'</b> for proper installation." .
                                "<br/>Please check this and reinstall Magic 360.</span>";
                    fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magic360_file_'.md5($file).'_notification');
                }
                */
            }
        }
    }

    return $cancel;

}

function fn_magic360_uninstall() {

    $js_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ROOT . '/js');
    $module_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ADDONS . '/magic360');
    $jsFiles = array('/ajax', '/core');
    $suffix = '_packed';

    foreach($jsFiles as $fileName) {
        if(@is_file($module_directory . $fileName . '.js')) {
            @unlink($module_directory . $fileName . '.js');
        }
        if(@is_file($module_directory . $fileName . $suffix . '.js')) {
            @unlink($module_directory . $fileName . $suffix . '.js');
        }
    }
    if(@is_file($module_directory . '/tabs' . $suffix . '.js')) {
        @unlink($module_directory . '/tabs' . $suffix . '.js');
    }

    fn_magic360_send_stat('uninstall');

}

function fn_magic360_send_stat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v6.5.7' || 'working' == 'v4.6.13') {
        return;
    }

    $hostname = 'www.magictoolbox.com';
    $url = $_SERVER['HTTP_HOST'].preg_replace('/\/[^\/]*?\.php.*$/i', '', $_SERVER['REQUEST_URI']);
    $url = urlencode(urldecode($url));
    $platformVersion = defined('PRODUCT_VERSION') ? PRODUCT_VERSION : '';
    $path = "api/stat/?action={$action}&tool_name=magic360&license=trial&tool_version=v4.6.13&module_version=v6.5.7&platform_name=cscart&platform_version={$platformVersion}&url={$url}";
    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers  = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }
}
