(function($) {

    (function($){

        // Override default ajax method
        var ajax = $.ajax;
        $.ajax = function(settings) {
            if(settings.data && settings.data.result_ids) {
                //if(console && console.log) console.log((settings.data.result_ids) ? settings.data.result_ids.split(',') : []);
                //if((settings.data.result_ids.search(/(?:product_images_|list_image_update_|product_quick_view_)\d+(?:_update)?|product_filters_\*/i) != -1) || (settings.data.result_ids == 'pagination_contents')) {
                if(settings.data.result_ids.search(/product_images_(?:ajax)?\d+_update|^pagination_contents$|product_filters_\*|^product_quick_view$/i) != -1) {
                    //var productIdMatch = settings.data.result_ids.match(/.*?(?:product_images_|list_image_update_|product_quick_view_)([0-9]+)(?:_update)?.*/i);
                    var productIdMatch = settings.data.result_ids.match(/product_images_(?:ajax)?([0-9]+)_update/i);
                    //NOTE: for quick view
                    if(!productIdMatch && settings.url) {
                        productIdMatch = settings.url.match(/(?:&|\?)product_id=([0-9]+)/i);
                    }
                    var success = settings.success;
                    //var complete = settings.complete;
                    if(productIdMatch) {
                        fn_magictoolbox_tool_update('stop', 'product', productIdMatch[1]);
                        settings.success = function(data, textStatus) {
                            success(data, textStatus);
                            fn_magictoolbox_tool_update('start', 'product', productIdMatch[1]);
                            //NOTE: need to clear cache to start/stop tools when re-selected option
                            $.ceAjax('clearCache');
                        };
                        //settings.complete = function(XMLHttpRequest, textStatus) {
                        //    complete(XMLHttpRequest, textStatus);
                        //    fn_magictoolbox_tool_update('start', 'product', productIdMatch[1]);
                        //    $.ceAjax('clearCache');
                        //}
                    } else {
                        fn_magictoolbox_tool_update('stop', 'category', '');
                        settings.success = function(data, textStatus) {
                            success(data, textStatus);
                            fn_magictoolbox_tool_update('start', 'category', '');
                            //NOTE: need to clear cache to start/stop tools when re-selecteFd option
                            $.ceAjax('clearCache');
                        };
                        //settings.complete = function(XMLHttpRequest, textStatus) {
                        //    complete(XMLHttpRequest, textStatus);
                        //    fn_magictoolbox_tool_update('start', 'category', '');
                        //    $.ceAjax('clearCache');
                        //}
                    }
                }
            }
            return ajax(settings);
        };

    })($);

})(Tygh.$);

function fn_magictoolbox_selector_init(productId) {
    if(typeof(magicToolboxSelectorsEvent) == 'undefined') return;
    //var selectors = $('#MagicToolboxSelectors'+productId+' a.cm-thumbnails-mini');
    var selectors = $('#MagicToolboxSelectors'+productId+' a');
    var switchFunction = function(e) {
        var targetNode = e.target || e.srcElement;
        if(targetNode.tagName.toLowerCase() == 'img') {
            targetNode = targetNode.parentNode;
        }
        if(typeof(magicToolboxOriginalLayout) != 'undefined' && magicToolboxOriginalLayout) {
            var targetObj = $(targetNode);
            if(!targetObj.hasClass('cm-cur-item')) {
                $('div.MagicToolboxSelectorsContainer .cm-cur-item').removeClass('cm-cur-item');
                targetObj.addClass('cm-cur-item');
            }
        }
        var magic360Container = document.getElementById('magic360Container'+productId);
        if(magic360Container) {
            if(magicToolboxTool == 'MagicZoom' || magicToolboxTool == 'MagicZoomPlus') {
                //NOTE: in order to magiczoom(plus) was not switching selector
                e.stopQueue();
            }
            var isMagic360Visible = magic360Container.style.display != 'none';
            var magicToolboxToolMainId = magicToolboxTool+'Imageproduct'+magicToolboxProductId;
            var isThisMagic360Selector = targetNode.className.match(/(?:\s|^)m360-selector(?:\s|$)/i);
            if(isThisMagic360Selector && !isMagic360Visible) {
                var mainImageContainer = document.getElementById('mainImageContainer'+productId);
                mainImageContainer.style.display = 'none';
                magic360Container.style.display = 'block';
            } else if(isMagic360Visible && !isThisMagic360Selector) {
                var mainImageContainer = document.getElementById('mainImageContainer'+productId);
                //NOTE: only on page load (first time)
                if(mainImageContainer.style.position == 'absolute') {
                    mainImageContainer.style.left = 0;
                    mainImageContainer.style.position = 'static';
                }
                magic360Container.style.display = 'none';
                mainImageContainer.style.display = 'block';
                if(magicToolboxTool == 'MagicZoom' || magicToolboxTool == 'MagicZoomPlus') {
                    //NOTE: hide image to skip magiczoom(plus) switching effect
                    if(!$mjs(targetNode).jHasClass('mz-thumb-selected')) {
                        document.querySelector('#'+magicToolboxToolMainId+' .mz-figure > img').style.visibility = 'hidden';
                    }
                }
            }
            if(magicToolboxTool == 'MagicZoom' || magicToolboxTool == 'MagicZoomPlus') {
                //NOTE: switch image
                MagicZoom.switchTo(magicToolboxToolMainId, targetNode);
                //NOTE: to highlight magic360 selector when switching thumbnails
                var selectors = $('#MagicToolboxSelectors'+productId+' a');
                for(var k = 0; k < selectors.length; k++) {
                    $mjs(selectors[k]).jRemoveClass('active-selector');
                }
                $mjs(targetNode).jAddClass('active-selector');
            }
        }
        return false;
    };
    if(magicToolboxTool == 'MagicZoom' || magicToolboxTool == 'MagicZoomPlus') {
        var switchEvent = (magicToolboxSelectorsEvent == 'click' ? 'btnclick' : magicToolboxSelectorsEvent);
    }
    for(var j = 0; j < selectors.length; j++) {
        if(magicToolboxTool == 'MagicZoom' || magicToolboxTool == 'MagicZoomPlus') {
            $mjs(selectors[j]).jAddEvent(switchEvent+' tap', switchFunction, 1);
        } else if(magicToolboxTool == 'MagicThumb') {
            $mjs(selectors[j]).jAddEvent(magicToolboxSelectorsEvent, switchFunction);
            $mjs(selectors[j]).jAddEvent('touchstart', switchFunction);
        }
    }
}

function fn_magictoolbox_tool_update(action, block, productId) {
    var tools = ['MagicZoom', 'MagicZoomPlus', 'MagicThumb', 'Magic360', 'MagicSlideshow', 'MagicScroll'];
    var mainEl = null;
    var selectorsEl = null;
    var tool = '';

    if(block == 'product') {
        for(toolId in tools) {
            mainEl = document.getElementById(tools[toolId]+'Image'+block+productId);
            if(mainEl) {
                tool = tools[toolId];
                break;
            }
        }
    } else if(block == 'category') {
        var container = document.getElementById('pagination_contents');
        for(toolId in tools) {
            if($('.'+tools[toolId], container).length) {
                tool = tools[toolId];
                break;
            }
        }
    }

    if(!tool) return;

    if(productId) selectorsEl = document.getElementById('MagicToolboxSelectors'+productId);

    if(action == 'stop') {
        if(selectorsEl) {
            if(typeof(MagicScroll) !== 'undefined') MagicScroll.stop(selectorsEl);
            if(typeof(Magic360) !== 'undefined') {
                var m360El = document.getElementById('Magic360Image'+block+productId);
                if(m360El) Magic360.stop(m360El);
            }
        }
        switch(tool) {
            case 'MagicZoom':
            case 'MagicZoomPlus':
                if(mainEl) {
                    MagicZoom.stop(mainEl);
                } else {
                    MagicZoom.stop();
                }
                break;
            case 'MagicThumb':
                if(mainEl) {
                    MagicThumb.stop(mainEl);
                } else {
                    MagicThumb.stop();
                }
                break;
            case 'MagicSlideshow':
                MagicSlideshow.stop(tools[toolId]+'Image'+block+productId);
                break;
            case 'MagicScroll':
                MagicScroll.stop(tools[toolId]+'Image'+block+productId);
                break;
            case 'Magic360':
                Magic360.stop(mainEl);
                break;
        }
    } else if(action == 'start') {
        switch(tool) {
            case 'MagicZoom':
            case 'MagicZoomPlus':
                if(mainEl) {
                    MagicZoom.start(mainEl);
                } else {
                    MagicZoom.start();
                }
                break;
            case 'MagicThumb':
                if(mainEl) {
                    MagicThumb.start(mainEl);
                } else {
                    MagicThumb.start();
                }
                break;
            case 'MagicSlideshow':
                //MagicSlideshow.start(tools[toolId]+'Image'+block+productId);
                MagicSlideshow.refresh(tools[toolId]+'Image'+block+productId);
                break;
            case 'MagicScroll':
                MagicScroll.start(tools[toolId]+'Image'+block+productId);
                break;
            case 'Magic360':
                Magic360.start(mainEl);
                break;
        }
        if(selectorsEl) {
            fn_magictoolbox_selector_init(productId);
            //NOTE: start() function runs tool even if the element has no MagicScroll class
            if(typeof(MagicScroll) !== 'undefined' && selectorsEl.className.match(/(?:\s|^)MagicScroll(?:\s|$)/i)) {
                //MagicScroll.start(selectorsEl);
                //NOTE: this delay is necessary for the first start in quick view
                setTimeout(function() {
                    MagicScroll.start(selectorsEl);
                }, 500);
            }
            if(typeof(Magic360) !== 'undefined') {
                var m360El = document.getElementById('Magic360Image'+block+productId);
                if(m360El) Magic360.start(m360El);
            }
        }
    }

}
