<?php

use Tygh\Registry;
use Tygh\Storage;
use Tygh\Settings;

if(!defined('BOOTSTRAP')) die('Access denied');

defined('MT_DS') || define('MT_DS', DIRECTORY_SEPARATOR);

function fn_magiczoom_before_dispatch() {
    if(AREA == 'A') return;
    Registry::get('view')->registerFilter('output', 'fn_magiczoom');
}


function fn_magiczoom($output, $view) {

    $block = '';
    $blockId = '';
    $showGallery = false;
    $quickView = false;
    switch($view->template_resource) {
        case 'views/products/quick_view.tpl':
            $quickView = true;
        case 'views/products/view.tpl':
            $block = 'product';
            $products = array($view->getTemplateVars('product'));//$view->tpl_vars['product']->value
            //NOTE: this code leads to magicscroll headers are not displayed on product page, when it is taken from the cache
            //$tool = fn_magiczoom_load();
            //$tool->params->setValue('need-scroll-headers', true);
        break;
        case 'views/categories/view.tpl':
            $block = 'category';
            $products = $view->getTemplateVars('products');//$view->tpl_vars['products']->value
            $showGallery = ($view->getTemplateVars('selected_layout') == 'products_multicolumns');//products_multicolumns|products_without_options|short_list
        break;
        case 'views/products/search.tpl':
            $block = 'search';
            $products = $view->getTemplateVars('products');//$view->tpl_vars['products']->value
            $showGallery = ($view->getTemplateVars('selected_layout') == 'products_multicolumns');//products_multicolumns|products_without_options|short_list
        break;
        case 'blocks/products/products_multicolumns.tpl'://Grid
            //NOTE: this template contains the 'blocks/list_templates/grid_list.tpl' template (with show_gallery=true)
            $showGallery = true;
        case 'blocks/products/products_links_thumb.tpl'://Links thumb
        case 'blocks/products/products_scroller.tpl'://Scroller
        case 'blocks/products/grid_list.tpl'://Products grid
        case 'blocks/products/products.tpl'://Products
        case 'blocks/products/products2.tpl'://Products2
        case 'blocks/products/products_bar.tpl'://Products bar
        case 'blocks/products/products_multicolumns2.tpl'://Grid2
        case 'blocks/products/products_multicolumns_small.tpl'://Multicolumns small
        case 'blocks/products/products_sidebox_1_item.tpl'://Side box first item
        case 'blocks/products/products_small_items.tpl'://Small items
        case 'blocks/products/short_list.tpl'://Short list
        case 'blocks/products/products_text_links.tpl'://Text links
        case 'blocks/products/products_without_image.tpl'://Without image
            if(!isset($view->tpl_vars['block']->value['content']['items']['filling'])) return $output;
            $block = $view->tpl_vars['block']->value['content']['items']['filling'];
            if(!in_array($block, array('newest', 'recent_products', 'most_popular', 'bestsellers', 'rating', 'on_sale', 'manually'))) return $output;
            $blockId = $view->tpl_vars['block']->value['block_id'];
            $products = $view->getTemplateVars('items');//$view->tpl_vars['items']->value
        break;
        case 'index.tpl':
            $block = 'header';
            $tool = fn_magiczoom_load();
            //NOTE: we need to apply headers always because we don't know whether the effect is applied to the block in the cache
            fn_magiczoom_include_headers($output);
            return $output;
        default:
            return $output;
    }
    
    //NOTE: to prevent the re-processing block (e.g. banner block)
    if(isset($GLOBALS['magictoolbox']['processed_blocks']['magiczoom'][$block.$blockId])) {
        return $output;
    } else {
        $GLOBALS['magictoolbox']['processed_blocks']['magiczoom'][$block.$blockId] = $block;
    }

    $tool = fn_magiczoom_load();
    if($tool->params->checkValue('enable-effect', 'No', $block)) return $output;

    if($quickView && $tool->params->checkValue('activate-in-quick-view', 'No', $block)) return $output;

    $tool->params->setValue('block-id', $blockId);
    $tool->params->setValue('products-scroller', $view->template_resource == 'blocks/products/products_scroller.tpl');
    $tool->params->setValue('show-gallery', $showGallery);
    $tool->params->setValue('quick-view', $quickView);

    $output = fn_magiczoom_parse($output, $products, $block);

    return $output;
}

function fn_magiczoom_load() {
    if(!isset($GLOBALS['magictoolbox']['magiczoom'])) {
        require_once(dirname(__FILE__).'/classes/magiczoom.module.core.class.php');
        $GLOBALS['magictoolbox']['magiczoom'] = new MagicZoomModuleCoreClass();
        $tool = &$GLOBALS['magictoolbox']['magiczoom'];

        $params = Registry::get('addons.magiczoom');

        $enabledOptions = db_get_hash_single_array('SELECT block, value FROM ?:addon_magiczoom_options WHERE name = \'enabled_options\'', array('block', 'value'));

        foreach($params as $pName => $pValue) {
            $paramValue = '';
            if(strpos($pValue, $pName.'-') === 0) {
                $paramValue = substr($pValue, strlen($pName)+1);
            } else {
                $paramValue = $pValue;
            }
            if(strpos($pName, 'general-') === 0) {
                $tool->params->setValue(substr($pName, 8), $paramValue);
            } else {
                $pattern = '/(product|category|search|newest|recent_products|most_popular|bestsellers|rating|on_sale|manually|banners)-(.*)/is';
                $matches = array();
                if(preg_match($pattern, $pName, $matches)) {
                    if(strpos($enabledOptions[$matches[1]], '|'.$matches[2].'|') !== false
                       || $tool->params->checkGroup($matches[2], array('General', 'Scroll', 'Scroll Arrows', 'Scroll Slider', 'Scroll effect', 'Multiple images'))
                      ) {
                        $tool->params->setValue($matches[2], $paramValue, $matches[1]);
                    }
                }
            }
        }
    } else {
        $tool = &$GLOBALS['magictoolbox']['magiczoom'];
    }
    return $tool;
}

function fn_magiczoom_magicscroll_load() {
    if(!isset($GLOBALS['magictoolbox']['magiczoom_magicscroll'])) {
        require_once(dirname(__FILE__).'/classes/magicscroll.module.core.class.php');
        $GLOBALS['magictoolbox']['magiczoom_magicscroll'] = new MagicScrollModuleCoreClass(false);
        $scroll = &$GLOBALS['magictoolbox']['magiczoom_magicscroll'];
        $tool = fn_magiczoom_load();
        //NOTE: load params in a separate profile, in order not to overwrite the options of MagicScroll module
        $scroll->params->appendParams($tool->params->getParams('product'), 'product-magicscroll-options');
        $scroll->params->setValue('orientation', ($tool->params->checkValue('template', array('left', 'right'), 'product') ? 'vertical' : 'horizontal'), 'product-magicscroll-options');
        //NOTE: if Magic Scroll module installed we need to load settings before displaying custom options
        if(function_exists('fn_magicscroll_load')) {
            fn_magicscroll_load();
        }
    }
    return $GLOBALS['magictoolbox']['magiczoom_magicscroll'];
}

function fn_magiczoom_include_headers(&$contents, $simplifiedMode = false) {
    $tool = fn_magiczoom_load();
    $tool->params->resetProfile();
    $httpPath = Registry::get('config.http_path');
    $headers = '';
    $headers .= $tool->getHeadersTemplate($httpPath.'/app/addons/magiczoom/resources');
    if($tool->params->checkValue('magicscroll', 'Yes', 'product') &&
       //NOTE: this code leads to magicscroll headers are not displayed on product page, when it is taken from the cache
       //$tool->params->getValue('need-scroll-headers') &&
       //NOTE: so we just check that it is a product page
       !empty($_REQUEST['product_id'])
      ) {
        $scroll = fn_magiczoom_magicscroll_load();
        $scroll->params->resetProfile();
        $headers .= $scroll->getHeadersTemplate($httpPath.'/app/addons/magiczoom/resources', $httpPath.'/app/addons/magiczoom/resources', false);
    }

    if(!$tool->params->checkValue('enable-effect', 'No', 'product')) {

        $mouseEvent = $tool->params->getValue('selectorTrigger', 'product');
        if($mouseEvent == 'hover') $mouseEvent = 'mouseover';
        $headers .= '
<script type="text/javascript">
    var magicToolboxSelectorsEvent = \''.$mouseEvent.'\';
    var magicToolboxSelectorsDelay = 60;
</script>
';

    }

    if(!empty($_REQUEST['product_id'])) {
        $headers .= "
<script type=\"text/javascript\">
    //$(document).ready(function() {
    $mjs(document).jAddEvent('domready', function() {
        if(typeof(MagicScroll) !== 'undefined') {
            var selectorsDiv = document.getElementById('MagicToolboxSelectors{$_REQUEST['product_id']}');
            if(selectorsDiv && selectorsDiv.className.match(new RegExp('(?:\\\\\\s|^)MagicScroll(?:\\\\\\s|$)'))) {
                MagicScrollOptions['onReady'] = function(id) {
                    if (id == 'MagicToolboxSelectors{$_REQUEST['product_id']}') {
                        fn_magictoolbox_selector_init('{$_REQUEST['product_id']}');
                    }
                };
            } else {
                fn_magictoolbox_selector_init('{$_REQUEST['product_id']}');
            }
        } else {
            fn_magictoolbox_selector_init('{$_REQUEST['product_id']}');
        }
    });
</script>\r\n";
    }


    /*
    $headers .= '<style type="text/css">';
    //NOTE: these margins and borders lead to MagicScrollItem(and MagicToolboxSelectorsContainer) becomes wider
    if($tool->params->checkValue('magicscroll', 'Yes', 'product')) {
        $headers .= ' div.MagicToolboxSelectorsContainer a, div.MagicToolboxSelectorsContainer a img { margin: 0; border: 0; }';
    } else if($tool->params->checkValue('template', array('left', 'right'), 'product')) {
         $headers .= ' div.MagicToolboxSelectorsContainer a, div.MagicToolboxSelectorsContainer a img { margin-left: 0; margin-right: 0; border: 0; }';
    }
    $headers .= '</style>'."\r\n";
    */
    $containerMaxWidth = intval($tool->params->getValue('thumb-max-width', 'product'));
    if($containerMaxWidth) {
        $containerMaxWidth = $containerMaxWidth.'px';
    } else {
        $containerMaxWidth = 'auto';
    }
    $headers .= "
<style type=\"text/css\">
.MagicToolboxContainer.maxWidth {
    max-width: {$containerMaxWidth};
}
</style>\r\n";

    if($simplifiedMode) {
        return $contents."\r\n".$headers;
    }

    $contents = preg_replace('#</head>#is', $headers.'</head>', $contents, 1);

    $script = <<<SCRIPT
<script type="text/javascript">
//<![CDATA[
(function($) {

    var fn_jcarousel = $.fn.jcarousel;
    if(typeof(fn_jcarousel) === 'undefined') return;
    $.fn.jcarousel = function(o) {
        if(typeof(this) === 'object' && typeof(this.get) === 'function' && typeof(this.length) === 'number' && this.length) {
            var el = this.get(0);
            if(el.nodeName.toUpperCase() == 'UL' && el.className.match(/(?:\s|^)product-thumbnails(?:\s|$)/i)) {
                if(typeof(o) === 'object' && typeof(o.wrap) !== 'undefined') {
                    o.wrap = 'both';
                }
            }
        }
        return fn_jcarousel.apply(this, arguments);
    };

})(jQuery);
//]]>
</script>
SCRIPT;
    if(!defined('MAGICTOOLBOX_FUNC_JS_INCLUDED')) {
        $script = '<script type="text/javascript" src="'.$httpPath.'/app/addons/magiczoom/resources/func.js"></script>'."\r\n".$script;
        define('MAGICTOOLBOX_FUNC_JS_INCLUDED', true);
    }
    $contents = preg_replace('#</body>#is', $script.'</body>', $contents, 1);

    return $contents;

}

function fn_magiczoom_parse(&$contents, $products, $block) {

    $tool = fn_magiczoom_load();
    $tool->params->setProfile($block);

    //NOTE: Non-ASCII filenames are chunked if no locale is provided
    //$oldLocale = setlocale(LC_ALL, NULL);
    //setlocale(LC_ALL, 'en_US.UTF8');

    switch($block) {
        case 'product':
            $productThumbImageType = $tool->params->getValue('quick-view') ? 'quick-view-thumb' : 'thumb';
            $originalLayout = $tool->params->checkValue('template', 'original');
            $isMainPairExists = true;
            if(isset($products[0]['main_pair']['detailed']['image_path'])) {
                $imagePath = $products[0]['main_pair']['detailed']['image_path'];
                $imageAlt = $products[0]['main_pair']['detailed']['alt'];
            } else if(isset($products[0]['main_pair']['icon']['image_path'])) {
                $imagePath = $products[0]['main_pair']['icon']['image_path'];
                $imageAlt = $products[0]['main_pair']['icon']['alt'];
            } else if(!empty($products[0]['image_pairs'])) {
                $isMainPairExists = false;
                $mainImagePair = reset($products[0]['image_pairs']);
                if(isset($mainImagePair['detailed']['image_path'])) {
                    $imagePath = $mainImagePair['detailed']['image_path'];
                    $imageAlt = $mainImagePair['detailed']['alt'];
                } else {
                    $imagePath = $mainImagePair['icon']['image_path'];
                    $imageAlt = $mainImagePair['icon']['alt'];
                }
            } else {
                break;
            }

            $img = fn_magiczoom_create_thumb($imagePath, 'original', $products[0]['product_id']);
            if(!$img) break;//NOTE: possibly image does not exists

            $useMagic360 = false;
            if(function_exists('fn_magic360_load') && Registry::ifGet('addons.magic360.status', 'D') == 'A') {
                $magic360tool = fn_magic360_load();
                if($magic360tool->params->checkValue('enable-effect', 'Yes', 'product')) {
                    $rezult = db_get_row('SELECT gallery FROM ?:addon_magic360_images WHERE id = ?i', $products[0]['product_id']);
                    if(isset($rezult['gallery']) && !empty($rezult['gallery'])) {
                        $magic360Images = explode(';', $rezult['gallery']);
                        if(count($magic360Images)) {
                            $useMagic360 = true;
                            //NOTE: disable transition effect to prevent the disappearance of the image when it is toggled
                            //$tool->params->setValue('transitionEffect', 'No', 'product');
                        }
                    }
                }
            }

            $thumb = fn_magiczoom_create_thumb($imagePath, $productThumbImageType, $products[0]['product_id']);
            $title = !empty($imageAlt) ? $imageAlt : $products[0]['product'];
            $mainImageHTML = $tool->getMainTemplate(array(
                'id' => $block.$products[0]['product_id'],
                'group' => $block.$tool->params->getValue('block-id'),
                'img' => $img,
                'thumb' => $thumb,
                'title' => $title,
            ));

            $jcarousel = Registry::get('settings.Appearance.thumbnails_gallery') == 'Y';
            //NOTE: this important for JCarousel
            if($jcarousel && $originalLayout) {
                $width  = $tool->params->checkValue('selector-max-width', array('0', '')) ? 'auto' : $tool->params->getValue('selector-max-width');
                $height = $tool->params->checkValue('selector-max-height', array('0', '')) ? 'auto' : $tool->params->getValue('selector-max-height');
            } else {
                $width = '';
                $height = '';
            }

            $mainImageSelectorHTML = $tool->getSelectorTemplate(array(
                'id' => $block.$products[0]['product_id'],
                'group' => $block.$tool->params->getValue('block-id'),
                'img' => $img,
                'medium' => $thumb,
                'thumb' => fn_magiczoom_create_thumb($imagePath, 'selector', $products[0]['product_id']),
                'title' => $title,
                'width' => $width,
                'height' => $height
            ));
            if($originalLayout) {
                $mainImageSelectorHTML = str_replace('<a ', '<a class="cm-gallery-item cm-thumbnails-mini thumbnails-item" ', $mainImageSelectorHTML);
            }

            $additionalImages = array();
            if(!empty($products[0]['image_pairs'])) {
                if($isMainPairExists) {
                    $additionalImages[] = $mainImageSelectorHTML;
                }
                foreach($products[0]['image_pairs'] as $imagePair) {
                    if(isset($imagePair['detailed']['image_path'])) {
                        $imagePairPath = $imagePair['detailed']['image_path'];
                        $imageAlt = $imagePair['detailed']['alt'];
                        //if(!file_exists($imagePair['detailed']['absolute_path'])) {
                            //NOTICE: there is no guarantee that this picture exists
                            //NOTICE: there is no guarantee that this is a picture of this product (it may be a different picture, if the name is the same)
                            //$imageData = fn_image_to_display($imagePair, Registry::get('settings.Thumbnails.product_details_thumbnail_width'), Registry::get('settings.Thumbnails.product_details_thumbnail_height'));
                            //$imagePairPath = $imageData['image_path'];
                        //}
                    } else/* if(isset($imagePair['icon']['image_path']))*/ {
                        $imagePairPath = $imagePair['icon']['image_path'];
                        $imageAlt = $imagePair['icon']['alt'];
                    }
                    $img = fn_magiczoom_create_thumb($imagePairPath, 'original', $products[0]['product_id']);
                    if(!$img) continue;//NOTE: possibly image does not exists
                    $a = $tool->getSelectorTemplate(array(
                        'id' => $block.$products[0]['product_id'],
                        'group' => $block.$tool->params->getValue('block-id'),
                        'img' => $img,
                        'medium' => fn_magiczoom_create_thumb($imagePairPath, $productThumbImageType, $products[0]['product_id']),
                        'thumb' => fn_magiczoom_create_thumb($imagePairPath, 'selector', $products[0]['product_id']),
                        'title' => !empty($imageAlt) ? $imageAlt : $products[0]['product'],
                        'width' => $width,
                        'height' => $height
                    ));
                    $additionalImages[] = $originalLayout ? str_replace('<a ', '<a class="cm-gallery-item cm-thumbnails-mini thumbnails-item" ', $a) : $a;

                }

            }
            if($useMagic360) {
                $GLOBALS['magictoolbox']['cooperative_mode'] = 'magiczoom';
                $magic360tool->params->setValue('selector-max-width', $tool->params->getValue('selector-max-width'));
                $magic360tool->params->setValue('selector-max-height', $tool->params->getValue('selector-max-height'));
                $magic360tool->params->setValue('original-layout', $originalLayout, 'product');
                $mainImageHTML = 
                    '<div style="position: relative;">'.
                        '<div id="mainImageContainer'.$products[0]['product_id'].'" style="position: absolute; left: -10000px;">'.
                            //NOTE: we need this div because of issue with MZP, which clones the parent node
                            '<div>'.$mainImageHTML.'</div>'.
                        '</div>'.
                        '<div id="magic360Container'.$products[0]['product_id'].'"><!-- MAGIC360 --></div>'.
                    '</div>';
                if(empty($additionalImages)) {
                    $additionalImages[] = $mainImageSelectorHTML;
                }
                foreach($additionalImages as &$selector) {
                    if(preg_match('#(<a\b[^>]*?\bclass=")([^"]*+")#i', $selector, $_match)) {
                        $selector = str_replace($_match[0], $_match[1].'zoom-with-360 '.$_match[2], $selector);
                    } else {
                        $selector = str_replace('<a ', '<a class="zoom-with-360" ', $selector);
                    }
                }
                array_unshift($additionalImages, '<!-- MAGIC360SELECTOR -->');
            }
            $mainImageHTML .= '<script type="text/javascript">'.
                                'var magicToolboxTool = \'MagicZoom\', magicToolboxProductId = \''.$products[0]['product_id'].'\', '.
                                'magicToolboxOriginalLayout='.($originalLayout ? 'true' : 'false').';'.
                                '</script>';

            require_once(dirname(__FILE__).MT_DS.'classes'.MT_DS.'magictoolbox.templatehelper.class.php');
            MagicToolboxTemplateHelperClass::setPath(dirname(__FILE__).MT_DS.'templates');
            MagicToolboxTemplateHelperClass::setOptions($tool->params);
            $scroll = fn_magiczoom_magicscroll_load();
            $html = MagicToolboxTemplateHelperClass::render(array(
                'main' => $mainImageHTML,
                'thumbs' => $additionalImages,
                'magicscrollOptions' => $scroll->params->serialize(false, '', 'product-magicscroll-options'),
                'pid' => $products[0]['product_id'],
                'jcarousel' => $jcarousel,
                'ul' => version_compare(PRODUCT_VERSION, '4.1', '<'),
                //'containerMaxWidth' => intval($tool->params->getValue($productThumbImageType.'-max-width'))
            ));

            //NOTE: set width for a large number of selectors
            if($tool->params->checkValue('magicscroll', 'No') && $tool->params->checkValue('template', array('top', 'bottom', 'original'))) {
                $html = preg_replace('#(<div\b[^>]*?\bclass="[^"]*?MagicToolboxContainer[^"]*+)("[^>]*+>)#i', '$1 maxWidth$2', $html);
            }


            $contents =  preg_replace('/<div class="ty\-product\-img .*?product_images_'.$products[0]['product_id'].'_update\-\->/ims', $html, $contents, -1, $replaced);
            if ($replaced) {
                break;
            }

            $contents =  preg_replace('/<div class="ty\-product\-block__img cm.*?product_images_'.$products[0]['product_id'].'_update\-\-><\/div>/ims', $html, $contents, -1, $replaced);
            if ($replaced) {
                break;
            }

            $contents =  preg_replace('/<div class="ty\-product\-block__img cm.*?<div class="ty\-product\-thumbnails.*?<\/div>.*?<\/div>/ims', $html, $contents, $replaced);
            if ($replaced) {
                break;
            }

            preg_match_all('/<div id="product_images_'.$products[0]['product_id'].'[0-9a-z]{1,}" class="ty\-product\-img.*?<\/div>.*?<div class="ty\-center ty\-product\-bigpicture\-thumbnails_gallery.*?><div class="cm\-image\-gallery\-wrapper ty-thumbnails_gallery">[^<]*<div class="ty\-product\-thumbnails.*?>[^<]*(<div class="cm-item-gallery">.*?<\/div>){1,}[^<]*<\/div>[^<]*<\/div>[^<]*<\/div>/ims', $contents, $m);

            if (!empty($m[0][0])) {
                $contents = str_replace($m[0][0], '<!-- '.$m[0][0].' -->'.str_replace(' maxWidth', '', str_replace('$', '\$', $html)), $contents);
                break;
            }
            
            preg_match_all('/<div id="product_images_'.$products[0]['product_id'].'[0-9a-z]{1,}" class="ty\-product\-img.*?<a.*?<\/a>[^<]*<\/div>/ims', $contents, $m);
            if (!empty($m[0][0])) {
                $contents = str_replace($m[0][0], '<!-- '.$m[0][0].' -->'.str_replace(' maxWidth', '', str_replace('$', '\$', $html)), $contents);
                break;
            }

                $imagePattern = '<div id="product_images_'.$products[0]['product_id'].'[0-9a-z]{1,}" class="ty-product-img cm-preview-wrapper ab-vertical".*?</div>';
                $replaced = 0;
                $contents = preg_replace('#'.$imagePattern.'#ims', str_replace(' maxWidth', '', str_replace('$', '\$', $html)), $contents, 1, $replaced);
                if($replaced) {
                    $contents = preg_replace('#<div class="ty-product-thumbnails[^"]*"[^>]*id="images_preview_'.$products[0]['product_id'].'.*?</div>#is', '', $contents, 1);
                } else {
                


                $additionalThumbnailsPattern =
                    '(<div\b[^>]*?\bclass="[^"]*?\bcm-image-gallery-wrapper\b[^"]*+"[^>]*+>[^<]*+)?'.
                    '<(div|ul)\b[^>]*?\bclass="[^"]*?\bproduct-thumbnails\b[^"]*+"[^>]*+>'.
                    '('.
                    '(?:'.
                        '[^<]++'.
                        '|'.
                        '<(?!/?\2\b|!--)'.
                        '|'.
                        '<!--.*?-->'.
                        '|'.
                        '<\2\b[^>]*+>'.
                            '(?3)'.
                        '</\2\s*+>'.
                    ')*+'.
                    ')'.
                    '</\2\s*+>'.
                    '(?(1)[^<]*+</div\s*+>)';
                $matches = array();
                preg_match('#'.$additionalThumbnailsPattern.'#is', $contents, $matches);

                $imagePattern = '<div class="ty-product-img cm-preview-wrapper" id="product_images_'.$products[0]['product_id'].'[0-9a-z]{1,}">.*?</div>';
                $replaced = 0;
                $contents = preg_replace('#'.$imagePattern.'#ims', str_replace(' maxWidth', '', str_replace('$', '\$', $html)), $contents, 1, $replaced);
                if($replaced) {
                    $contents = preg_replace('#<div class="ty-product-thumbnails[^"]*" id="images_preview_'.$products[0]['product_id'].'.*?</div>#is', '', $contents, 1);
                } else {
                    $imagePattern =
                        '(?:'.
                        //'<img [^>]*?id="det_img_(?!variant_image)[^"]*+"[^>]*+>'.//class=pict, det_img_{$preview_id}_

                        //NOTE: fixed an issue with replacing wrong image (templates/addons/call_requests/views/call_requests/components/lscall_requests_content.tpl)
                        //$preview_id = $products[0]['product_id'].uniqid();
                        '<img [^>]*?id="det_img_'.$products[0]['product_id'].'[0-9][^"]*+"[^>]*+>'.//class=pict, det_img_{$preview_id}_

                        '|'.
                        '<div [^>]*?class="no-image"[^>]*+>.*?</div>'.
                        '|'.
                        '<span [^>]*?class="ty-no-image"[^>]*+>.*?</span>'.
                        ')';
                    $imagePattern =
                        '(?:<a [^>]*?id="det_img_link_[^"]*+"[^>]*+>[^<]*+'.//class=cm-image-previewer, det_img_link_{$preview_id}_
                            $imagePattern.'[^<]*+'.
                            '(?:<span\b[^>]*+>[^<]*+</span>[^<]*+)?'.
                        '</a>|'.
                        $imagePattern.')[^<]*+';

                    $replaced = 0;
                    $contents = preg_replace('#(?:'.$imagePattern.')+#is', str_replace('$', '\$', $html), $contents, 1, $replaced);//NOTE: $limit = 1 to prevent the replacement of product in product tabs(product id == block id)
                    if($replaced && !empty($matches)) {
                        //NOTE: cut selectors
                        $contents = str_replace($matches[0], '', $contents);
                    }
                }
            }
        break;
        case 'category':
        case 'search':
        case 'newest':
        case 'recent_products':
        case 'most_popular':
        case 'bestsellers':
        case 'rating':
        case 'on_sale':
        case 'manually':
            $useLink = $tool->params->checkValue('link-to-product-page', 'Yes');
            $showGallery = $tool->params->getValue('show-gallery');

            foreach($products as $product) {
                $imagePairs = $product['image_pairs'];
                if(isset($product['main_pair']['detailed']['image_path'])) {
                    $imagePath = $product['main_pair']['detailed']['image_path'];
                    $imageAlt = $product['main_pair']['detailed']['alt'];
                    if(isset($product['main_pair']['icon']['image_path'])) {
                        $srcPattern = $product['main_pair']['icon']['image_path'];
                    } else {
                        $srcPattern = $imagePath;
                    }
                } else if(isset($product['main_pair']['icon']['image_path'])) {
                    $imagePath = $product['main_pair']['icon']['image_path'];
                    $imageAlt = $product['main_pair']['icon']['alt'];
                    $srcPattern = $imagePath;
                } else if($showGallery && !empty($imagePairs)) {
                    $imagePair = array_shift($imagePairs);
                    if(isset($imagePair['detailed']['image_path'])) {
                        $imagePath = $imagePair['detailed']['image_path'];
                        $imageAlt = $imagePair['detailed']['alt'];
                        if(isset($imagePair['icon']['image_path'])) {
                            $srcPattern = $imagePair['icon']['image_path'];
                        } else {
                            $srcPattern = $imagePath;
                        }
                    } else {
                        $imagePath = $imagePair['icon']['image_path'];
                        $imageAlt = $imagePair['icon']['alt'];
                        $srcPattern = $imagePath;
                    }
                } else {
                    continue;
                }

                //NOTE: cut off timestamp from URL
                $srcPattern = preg_replace('#\?t=\d+$#i', '', $srcPattern);
                //NOTE: prepare regexp
                $srcPattern = '[^"]*?/'.preg_quote(basename($srcPattern)).'(?:\?t=\d++)?';

                $img = fn_magiczoom_create_thumb($imagePath, 'original', $product['product_id']);
                if(!$img) continue;//NOTE: possibly image does not exists


                if($showGallery && !empty($product['image_pairs'])) {
                    //product_icon.tpl (with gallery)
                    /*
                    $galleryPattern =
                        '<div [^>]*?id="icons_[^"]*?'.$product['product_id'].'"[^>]*+>[^<]*+'.//cm-image-gallery `$block.block_id`000`$product.product_id`
                        '(?:'.
                        //new 4.1.x pattern
                        '(?:<div [^>]*?class="[^"]*?cm-gallery-item[^"]*+"[^>]*+>[^<]*+'.
                        '<a [^>]*+>[^<]*+'.
                        '<img [^>]*?id="det_img_[^"]*?'.$product['product_id'].'(?:_[^"]*+)?"[^>]*+>[^<]*+'.
                        '</a>[^<]*+'.
                        '</div>[^<]*+)+'.
                        '|'.
                        //old 4.0.x pattern
                        '<ul[^>]*+>[^<]*+'.
                        '(?:<li [^>]*?class="[^"]*?cm-gallery-item[^"]*+"[^>]*+>[^<]*+'.
                        '<a [^>]*+>[^<]*+'.
                        '<img [^>]*?id="det_img_[^"]*?'.$product['product_id'].'(?:_[^"]*+)?"[^>]*+>[^<]*+'.
                        '</a>[^<]*+'.
                        '</li>[^<]*+)+'.
                        '</ul>[^<]*+'.
                        '(?:<i [^>]*+></i>[^<]*+){2}?'.
                        ')'.
                        '</div>';
                    */
                    $galleryPattern =
                        '<div\b[^>]*?\bid\s*+=\s*+"icons_[^"]*?'.$product['product_id'].'"[^>]*+>'.//cm-image-gallery `$block.block_id`000`$product.product_id`
                        '('.
                        '(?:'.
                            '[^<]++'.
                            '|'.
                            '<(?!/?div\b|!--)'.
                            '|'.
                            '<!--.*?-->'.
                            '|'.
                            '<div\b[^>]*+>'.
                                '(?1)'.
                            '</div\s*+>'.
                        ')*+'.
                        ')'.
                        '</div\s*+>';
                    
                    $matches = array();
                    if(preg_match('#'.$galleryPattern.'#is', $contents, $matches)) {
                        $galleryHTML = $matches[0];
                        //product_icon.tpl
                        $galleryItemPattern =
                            '<a\b[^>]*+>[^<]*+'.
                            '<img\b[^>]*+>[^<]*+'.
                            '</a>';
                        $index = 0;
                        $html = $tool->getMainTemplate(array(
                            'id' => $block.$product['product_id']."_{$index}",
                            'group' => $block.$tool->params->getValue('block-id')."_{$product['product_id']}",
                            'img' => $img,
                            'thumb' => fn_magiczoom_create_thumb($imagePath, 'thumb', $product['product_id']),
                            'title' => $product['product'],
                            'link' => $useLink ? fn_url("products.view?product_id={$product['product_id']}") : '',
                        ));
                        $galleryHTML = preg_replace('#'.$galleryItemPattern.'#is', str_replace('$', '\$', $html), $galleryHTML, 1);
                        foreach($imagePairs as $imagePair) {
                            $index++;
                            if(isset($imagePair['detailed']['image_path'])) {
                                $imagePath = $imagePair['detailed']['image_path'];
                                $imageAlt = $imagePair['detailed']['alt'];
                            } else {
                                $imagePath = $imagePair['icon']['image_path'];
                                $imageAlt = $imagePair['icon']['alt'];
                            }
                            $img = fn_magiczoom_create_thumb($imagePath, 'original', $product['product_id']);
                            if(!$img) continue;//NOTE: possibly image does not exists
                            $html = $tool->getMainTemplate(array(
                                'id' => $block.$product['product_id']."_{$index}",
                                'group' => $block.$tool->params->getValue('block-id')."_{$product['product_id']}",
                                'img' => $img,
                                'thumb' => fn_magiczoom_create_thumb($imagePath, 'thumb', $product['product_id']),
                                'title' => $product['product'],
                                'link' => $useLink ? fn_url("products.view?product_id={$product['product_id']}") : '',
                            ));
                            $galleryHTML = preg_replace('#'.$galleryItemPattern.'#is', str_replace('$', '\$', $html), $galleryHTML, 1);
                        }
                        $contents = str_replace($matches[0], $galleryHTML, $contents);
                    }
                } else {
                    $html = $tool->getMainTemplate(array(
                        'id' => $block.$product['product_id'],
                        'group' => $block.$tool->params->getValue('block-id'),
                        'img' => $img,
                        'thumb' => fn_magiczoom_create_thumb($imagePath, 'thumb', $product['product_id']),
                        'title' => $product['product'],
                        'link' => $useLink ? fn_url("products.view?product_id={$product['product_id']}") : '',
                    ));
                    //products_list.tpl
                    $productListPattern =
                        '(?P<discount><span [^>]*?class="[^"]*?thumb-discount-label[^"]*+"[^>]*+>.*?</span>[^<]*+)?'.
                        '(?P<input1><input [^>]*+>[^<]*+)'.
                        //'<img [^>]*?src="'.$srcPattern.'"[^>]*+>[^<]*+'.
                        '<img [^>]*?id="det_img_[^"]*?'.$product['product_id'].'"[^>]*+>';
                    $productListPattern =
                        '(<a [^>]*+>[^<]*+(?P<input2><input [^>]*+>)[^<]*+)?'.
                        $productListPattern.
                        '(?(1)[^<]*+</a>)';
                    //product_icon.tpl (without gallery)
                    $productIconPattern =
                        '<a [^>]*+>[^<]*+'.
                        '(?:<img [^>]*?id="det_img_[^"]*?'.$product['product_id'].'"[^>]*+>|'.
                           '<img [^>]*?src="'.$srcPattern.'"[^>]*+>)'.
                        '[^<]*+</a>';
                    /*
                    //product_icon.tpl (with gallery)
                    $productIconPattern =
                        '<div [^>]*?id="icons_'.$product['product_id'].'"[^>]*>[^<]*'.//cm-image-gallery
                        '<ul>[^<]*'.
                        '(?:<li [^>]*?class="[^"]*?cm-gallery-item[^"]*"[^>]*>[^<]*'.
                        '<a [^>]*>[^<]*'.
                        '<img [^>]*?id="det_img_[^"]*?'.$product['product_id'].'(?:_[^"]*)?"[^>]*>[^<]*'.
                        '</a>[^<]*'.
                        '</li>[^<]*)+'.
                        '</ul>[^<]*'.
                        '(?:<i [^>]*></i>[^<]*){2}?'.
                        '</div>|'.$productIconPattern;
                    */
                    $matches = array();
                    $matchedData = '';//inputs, span
                    if(preg_match('#'.$productListPattern.'|'.$productIconPattern.'#is', $contents, $matches)) {
                        $matchedData = (empty($matches['discount']) ? '' : $matches['discount']).(empty($matches['input1']) ? '' : $matches['input1']).(empty($matches['input2']) ? '' : $matches['input2']);
                        $contents = str_replace($matches[0], $matchedData.$html, $contents);
                    }
                }

            }
            if($tool->params->getValue('products-scroller')) {
                $contents = str_replace('wrap: \'circular\'', 'wrap: \'both\'', $contents);
            }

        break;
    }

    //setlocale(LC_ALL, $oldLocale);
    $tool->params->resetProfile();

    return $contents;

}

function fn_magiczoom_create_thumb($src, $size, $pid) {

    static $imagehelper = null;
    static $prefix = '';

    if($imagehelper === null) {

        $prefix = Registry::get('config.current_location');

        $options = Settings::instance()->getValue('cdn', '');

        //NOTE: in some cases CDN is disabled at frontend (although it is activated in the settings)
        //      so this is an additional check
        $_options = Storage::instance('images')->options;
        $isCdnEnabled = isset($_options['cdn']) && $_options['cdn'];

        if(!empty($options) && $isCdnEnabled) {
            $options = unserialize($options);
            if((bool)$options['is_enabled']) {
                /*
                $cdn = Cdn::instance()->getHost('host');
                if(!empty($cdn)) {
                    $prefix = (defined('HTTPS') ? 'https:' : 'http:').'//'.$cdn;
                }
                */
                if(!empty($options['cname'])) {
                    $prefix = (defined('HTTPS') ? 'https:' : 'http:').'//'.$options['cname'];
                } else if(!empty($options['host'])) {
                    $prefix = (defined('HTTPS') ? 'https:' : 'http:').'//'.$options['host'];
                }
            }
        }

        $tool = fn_magiczoom_load();
        require_once(dirname(__FILE__).'/classes/magictoolbox.imagehelper.class.php');
        $imagehelper = new MagicToolboxImageHelperClass(Registry::get('config.dir.root'), '/images/magictoolbox_cache', $tool->params, null, Registry::get('config.http_path'));
    }

    $src = str_replace($prefix, '', $src);//NOTE: with /
    $src = preg_replace('#\?.*+$#', '', $src);//NOTE: if it has some GET options, cut it
    $src = htmlspecialchars_decode($src, ENT_QUOTES);

    $thumb = $imagehelper->create($src, $size, $pid);
    //NOTE: spike to get real size of image
    //$GLOBALS['magictoolbox']['file_path'] = $imagehelper->file;
    if(MT_DS != '/') {
        $thumb = str_replace(MT_DS, '/', $thumb);
    }

    return $thumb;

}

function fn_magiczoom_js_functions() {

    global $magiczoomDisableNotification;

    if(!isset($magiczoomDisableNotification) || !$magiczoomDisableNotification)
    if(Registry::get("addons.magiczoom.status") === 'D') {
        $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic Zoom module should be enabled for proper operation of the settings page." .
                   "<br/>Please enable it before save settings.</span>";
        fn_set_notification('E', __('warning'), $message, true, 'magiczoom_module_disabled_notification');
    }

    return '
        <script type="text/javascript">
            //<![CDATA[
            function fn_magiczoom_prepare_custom_options(block, skip) {
                skip = (skip || \'\').split(\'|\');
                skip.push(\'enable-effect\');
                var enabledOptionsID = "#addon_option_magiczoom_" + block + "-enabled-options";
                var enabledOptions = $(enabledOptionsID).val();
                var sectionID = "#content_magiczoom_magiczoom_" + block;
                $(sectionID + " div.controls").
                each(function(){
                        $(this).
                         find("select, input[type=\'text\']").
                         each(function(){
                                var optionId = this.id.replace("addon_option_magiczoom_" + block + "-","");
                                if(jQuery.inArray(optionId, skip) !== -1) {
                                    return;
                                }
                                if(enabledOptions.indexOf("|" + optionId + "|") == -1) {
                                    $(this).attr("disabled", true).after("&nbsp;&nbsp;<a href=\"#\" >edit</a>");
                                } else {
                                    $(this).after("&nbsp;&nbsp;<a href=\"#\" >use default option</a>");
                                }
                                $(this).next().
                                    bind("click", {optionId: optionId, enabledOptionsID: enabledOptionsID},
                                                    function(event) {
                                                        var enabledOptions = $(event.data.enabledOptionsID).val();
                                                        if($(this).html() == "edit") {
                                                            $(this).html("use default option").prev().removeAttr("disabled");
                                                            enabledOptions = enabledOptions.concat(event.data.optionId + "|");
                                                        } else {
                                                            $(this).html("edit").prev().attr("disabled", true).val($("#addon_option_magiczoom_general-" + event.data.optionId).val().replace("general-", block + "-"));
                                                            var pattern = new RegExp("\\\\|" + event.data.optionId + "\\\\|", "g");
                                                            enabledOptions = enabledOptions.replace(pattern, "|");
                                                        }
                                                        $(event.data.enabledOptionsID).val(enabledOptions);
                                                        return false;
                                                }
                                        );
                              }).
                         end().
                         find("input[type=\'radio\']:checked").
                         each(function(){
                                var optionId = this.parentNode.parentNode.id.replace("addon_option_magiczoom_" + block + "-","");
                                if(jQuery.inArray(optionId, skip) !== -1) {
                                    return;
                                }
                                if(enabledOptions.indexOf("|" + optionId + "|") == -1) {
                                    $(this.parentNode.parentNode).find("input").attr("disabled", true).end().
                                     find("label:last-child").after("&nbsp;&nbsp;<a href=\"#\" >edit</a>");
                                } else {
                                    $(this.parentNode.parentNode).find("label:last-child").after("&nbsp;&nbsp;<a href=\"#\" >use default option</a>");
                                }
                                $(this.parentNode.parentNode).find("a:last-child").
                                    bind("click", {optionId: optionId, enabledOptionsID: enabledOptionsID},
                                                    function(event) {
                                                        var enabledOptions = $(event.data.enabledOptionsID).val();
                                                        if($(this).html() == "edit") {
                                                            $(this).html("use default option");
                                                            $(this.parentNode.parentNode).find("input").removeAttr("disabled");
                                                            enabledOptions = enabledOptions.concat(event.data.optionId + "|");
                                                        } else {
                                                            $(this).html("edit");
                                                            $(this.parentNode.parentNode).find("input").attr("disabled", true).val([$("#addon_option_magiczoom_general-" + optionId + " input:checked").val().replace("general", block)]);
                                                            var pattern = new RegExp("\\\\|" + event.data.optionId + "\\\\|", "g");
                                                            enabledOptions = enabledOptions.replace(pattern, "|");
                                                        }
                                                        $(event.data.enabledOptionsID).val(enabledOptions);
                                                        return false;
                                                }
                                        );
                              });
                      });
            }
            //]]>
        </script>
';

}

function fn_magiczoom_prepare_custom_options($block) {

    static $addonOptions;
    static $enabledOptions;
    $headersBind = '';
    $generalParamsChangeBind = '';
    $includeOptionsJs = '';
    $initOptionsValidation = '';
    $magicscrollIcon = '';
    $blocks = array('product',
                    'category',
                    'search',
                    'newest', 'recent_products', 'most_popular', 'bestsellers', 'rating', 'on_sale', 'manually',
                   );

    if(!isset($addonOptions)) {
        $section = Settings::instance()->getSectionByName($_REQUEST['addon'], Settings::ADDON_SECTION);
        $addonOptions = db_get_hash_single_array('SELECT name, value FROM ?:settings_objects WHERE section_id = \'?p\' AND type != \'H\'', array('name', 'value'), $section['section_id']);
        $enabledOptions = db_get_hash_single_array('SELECT block, value FROM ?:addon_magiczoom_options WHERE name = \'enabled_options\'', array('block', 'value'));
    }

    switch($block) {
        case 'general':
            if(isset($addonOptions['cache-path-to-cache'])) {
                $pathToCache = $addonOptions['cache-path-to-cache'];
            } else {
                $pathToCache = '/images/magictoolbox_cache';
            }
            $tool = fn_magiczoom_load();
            require_once(dirname(__FILE__).'/classes/magictoolbox.imagehelper.class.php');
            $imagehelper = new MagicToolboxImageHelperClass(Registry::get('config.dir.root'), $pathToCache, $tool->params);
            $usedSubCache = $imagehelper->getOptionsHash();
            $cacheInfo = fn_magiczoom_getCacheInfo(Registry::get('config.dir.root').$pathToCache, $usedSubCache);
            $cacheInfo['formatedTotalSize'] = fn_magiczoom_format_size($cacheInfo['totalSize']);
            $cacheInfo['formatedUnusedSize'] = fn_magiczoom_format_size($cacheInfo['unusedSize']);
            $indexScript = Registry::get('config.admin_index');
            $return =<<<RETURN
<div class="control-group setting-wide magiczoom">
    <label for="addon_option_magiczoom_cache-path-to-cache" class="control-label" >Path to cache folder&nbsp;<a class="cm-tooltip" title="Relative for site base path."><i class="icon-question-sign"></i></a>:</label>
    <div class="controls">
        <input id="addon_option_magiczoom_cache-path-to-cache" type="text" name="addon_data[options][cache-path-to-cache]" value="{$pathToCache}" style="width:352px;" disabled="disabled" />
        <div class="right update-for-all"></div>
    </div>
</div>
<div class="control-group setting-wide magiczoom">
    <label for="addon_option_magiczoom_cache-total-items" class="control-label" >Total items:</label>
    <div class="controls">
        <input id="addon_option_magiczoom_cache-total-items" type="text" name="addon_data[options][cache-total-items]" value="{$cacheInfo['totalCount']} ({$cacheInfo['formatedTotalSize']})" size="30" disabled="disabled" />
        <div class="right update-for-all"></div>
    </div>
</div>
<div class="control-group setting-wide magiczoom">
    <label for="addon_option_magiczoom_cache-unused-items" class="control-label" >Unused items:</label>
    <div class="controls">
        <input id="addon_option_magiczoom_cache-unused-items" type="text" name="addon_data[options][cache-unused-items]" value="{$cacheInfo['unusedCount']} ({$cacheInfo['formatedUnusedSize']})" size="30" disabled="disabled" />
        <div class="right update-for-all"></div>
    </div>
</div>
<div class="control-group setting-wide magiczoom">
    <label for="addon_option_magiczoom_cache-what-clear" class="control-label " >Empty cache:</label>
    <div class="controls">
        <select id="addon_option_magiczoom_cache-what-clear" onchange="$('#magiczoom_clear_cache_field').attr('href', '{$indexScript}?dispatch=magiczoom_cache.'+this.value).attr('rev', this.value);">
            <option value="clear_unused_items" selected="selected">Delete unused items</option>
            <option value="clear_all_items">Delete all items</option>
        </select>
        &nbsp;<a data-ca-event="ce.magiczoom_clear_cache_field" name="magiczoom_clear_cache_field" id="magiczoom_clear_cache_field" href="{$indexScript}?dispatch=magiczoom_cache.clear_unused_items" class="cm-ajax cm-confirm" rev="clear_unused_items" >Clear</a>
        <div class="right update-for-all"></div>
    </div>
</div>
RETURN;
            return $return;
            break;
        case 'manually':
            //only after last block
            $blocks  = '"'.implode('", "', $blocks).'"';

            //NOTE: does not work in hidden tabs
            //$headersBind = '$("#tabs_content_magiczoom h4.subheader").slice(1).click();';

            $headersBind = '
$("#tabs_content_magiczoom h4.subheader").slice(1).each(function() {
    var subheader = $(this);
    var target = subheader.attr(\'data-target\');
    subheader.addClass(\'collapsed\');
    $(target).removeClass(\'in\');
});
';

            $generalParamsChangeBind = '
$("#content_magiczoom_magiczoom_general").find("input[type=\'text\']").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.id.replace("addon_option_magiczoom_general-","");
var optioVal = $(this).val();
for(block in block_array) {
    $("#content_magiczoom_magiczoom_" + block_array[block]).
    find("#addon_option_magiczoom_" + block_array[block] + "-" + optionId + ":disabled").val(optioVal);
}
}).
end().find("select").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.id.replace("addon_option_magiczoom_general-","");
var optioVal = $(this).val().replace("general-" + optionId + "-", "");
for(block in block_array) {
    $("#content_magiczoom_magiczoom_" + block_array[block]).
    find("#addon_option_magiczoom_" + block_array[block] + "-" + optionId + ":disabled").val(block_array[block] + "-" + optionId + "-" + optioVal);
}
}).
end().find("input[type=\'radio\']").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.parentNode.parentNode.id.replace("addon_option_magiczoom_general-","");
var optioVal = $(this).val().replace("general-" + optionId + "-", "");
for(block in block_array) {
    $("#content_magiczoom_magiczoom_" + block_array[block]).
    find("#addon_option_magiczoom_" + block_array[block] + "-" + optionId + " input:disabled").val([block_array[block] + "-" + optionId + "-" + optioVal]);
}
});';
            $tool = fn_magiczoom_load();
            $includeOptionsJs = '<script type="text/javascript" src="'.Registry::get('config.http_path').'/js/addons/magiczoom/options.js"></script>';
            $templateOptionId = Settings::instance()->getId('product-template', 'magiczoom');
            $magicscrollOptionId = Settings::instance()->getId('product-magicscroll', 'magiczoom');
            $initOptionsValidation = 'initOptionsValidation(\'addon_data[options]['.$templateOptionId.']\', \'addon_data[options]['.$magicscrollOptionId.']\', \'product-template-\', \'product-magicscroll-\');';
            $magicscrollIcon = '
var magicscrollIcon = document.createElement("img");
magicscrollIcon.id = "magicscroll_icon";
magicscrollIcon.src = "'.Registry::get('config.http_path')."/design/backend/media/images/addons/magiczoom/magicscroll.png".'";
magicscrollIcon.style.marginRight = "5px";
document.getElementById("addon_option_magiczoom_product-magicscroll").insertBefore(magicscrollIcon, document.getElementById("addon_option_magiczoom_product-magicscroll").firstChild);
';
    }

    $tool = fn_magiczoom_load();
    //$skip = array('zoomOn');
    $skip = array();
    $skip[] = 'quick-view-thumb-max-width';
    $skip[] = 'quick-view-thumb-max-height';

    foreach($tool->params->getParams() as $param) {
        if(in_array($param['group'], array('General', 'Scroll', 'Scroll Arrows', 'Scroll Slider', 'Scroll effect', 'Multiple images'))) {
            $skip[] = $param['id'];
        }
    }

    $skip = implode('|', $skip);
    return $includeOptionsJs.'
        <input type="hidden" name="addon_data[options]['.$block.'-enabled-options]" id="addon_option_magiczoom_'.$block.'-enabled-options" value="'.$enabledOptions[$block].'" />
        <script type="text/javascript">
            //<![CDATA[
                function fn_magiczoom_prepare_'.$block.'_block_options() {
                    fn_magiczoom_prepare_custom_options("'.$block.'", \''.$skip.'\');
                    '.$headersBind.$generalParamsChangeBind.$initOptionsValidation.$magicscrollIcon.'
                }
            //]]>
        </script>
    ';
}

function fn_magiczoom_getCacheInfo($path, $usedSubCache = null) {

    $totalSize = 0;
    $totalCount = 0;
    $usedSize = 0;
    $usedCount = 0;
    if (is_dir($path))
    if ($handle = opendir($path)) {
        while (false !== ($file = readdir($handle))) {
            $next = $path.MT_DS.$file;
            if ($file != '.' && $file != '..' && !is_link($next)) {
                if (is_dir($next)) {
                    $result = fn_magiczoom_getCacheInfo($next);
                    if($file == $usedSubCache) {
                        $usedSize += $result['totalSize'];
                        $usedCount += $result['totalCount'];
                    }
                    $totalSize += $result['totalSize'];
                    $totalCount += $result['totalCount'];
                } elseif (is_file($next)) {
                    $totalSize += filesize($next);
                    $totalCount++;
                }
            }
        }
        closedir($handle);
    }
    return array('totalSize' => $totalSize, 'totalCount' => $totalCount, 'unusedSize' => $totalSize-$usedSize, 'unusedCount' => $totalCount-$usedCount);
}

function fn_magiczoom_format_size($size) {
    $units = array(' bytes', ' KB', ' MB', ' GB', ' TB');
    for ($i = 0; $size >= 1024 && $i < 4; $i++) $size /= 1024;
    return round($size, 2).$units[$i];
}

function fn_magiczoom_install() {

    global $magiczoomDisableNotification;
    $magiczoomDisableNotification = true;

    $moduleDirectory = str_replace(array("//", "\\"), array("/", "/"), Registry::get('config.dir.addons').'/magiczoom');

    $cancel = false;

    if(!defined('PRODUCT_VERSION') || version_compare(PRODUCT_VERSION, '4.0.0', '<')) {
        $cancel = true;
        if(!fn_notification_exists('E', 'magiczoom_module_version_notification')) {
            $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">This Magic Zoom module is intended only for CS Cart Version 4 and above.".
                       "<br/>Your version of CS Cart is ".PRODUCT_VERSION."</span>";
            fn_set_notification('E', __('error'), $message, true, 'magiczoom_module_version_notification');
        }
    }

    if($cancel) {
        $args = func_get_args();
        if(!empty($args)) fn_redirect("addons.manage");
        return;
    }

    //fix url's in css files
    $cancel = fn_magiczoom_fix_css();


    if($cancel) {
        $args = func_get_args();
        if(!empty($args)) fn_redirect("addons.manage");
        return;
    }

    //NOTE: fix the order in which modules call
    $magicAddons = db_get_fields("SELECT addon FROM ?:addons WHERE addon LIKE 'magic%'");
    if(!empty($magicAddons)) {
        $magicAddonsData = array();
        foreach($magicAddons as $addon) {
            $magicAddonsData[$addon] = db_get_row("SELECT * FROM ?:addons WHERE addon='{$addon}'");
            db_query("DELETE FROM ?:addons WHERE addon='{$addon}'");
        }
        if(isset($magicAddonsData['magiczoom'])) {
            db_query("INSERT INTO ?:addons ?e", $magicAddonsData['magiczoom']);
            unset($magicAddonsData['magiczoom']);
        }
        foreach($magicAddonsData as $addon => $data) {
            db_query("INSERT INTO ?:addons ?e", $data);
        }
    }

    fn_magiczoom_send_stat('install');

}

function fn_magiczoom_fix_css() {

    $cancel = false;

    $path = dirname(__FILE__).'/resources';

    $resourcesPath = Registry::get('config.current_path').substr(Registry::get('config.dir.addons'), strlen(Registry::get('config.dir.root'))).'magiczoom/resources';
    $resourcesPath = str_replace(array("//", "\\"), array("/", "/"), $resourcesPath);

    $list = glob($path.'/*');
    $files = array();
    if(is_array($list)) {
        for($i = 0; $i < count($list); $i++) {
            if(is_dir($list[$i])) {
                if(!in_array(basename($list[$i]), array('.svn', '.git'))) {
                    $add = glob($list[$i].'/*');
                    if(is_array($add)) {
                        $list = array_merge($list, $add);
                    }
                }
            } else if(preg_match('#\.css$#i', $list[$i])) {
                $files[] = $list[$i];
            }
        }
    }

    foreach($files as $file) {
        $cssPath = dirname($file);
        $cssRelPath = str_replace($path, '', $cssPath);
        $toolPath = $resourcesPath.$cssRelPath;
        $pattern = '#url\(\s*(\'|")?(?!data:|mhtml:|http(?:s)?:|/)([^\)\s\'"]+?)(?(1)\1)\s*\)#is';
        $replace = 'url($1'.$toolPath.'/$2$1)';
        $fileContents = file_get_contents($file);
        $fixedFileContents = preg_replace($pattern, $replace, $fileContents);
        if($fixedFileContents != $fileContents) {
            if(is_writeable($file)) {
                file_put_contents($file, $fixedFileContents);
            } else {
                //NOTE: install module anyway
                /*
                $cancel = true;
                if(!fn_notification_exists('E', 'magiczoom_file_'.md5($file).'_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic Zoom needs write access to the file <b>'".$file."'</b> for proper installation." .
                                "<br/>Please fix this and reinstall Magic Zoom.</span>";
                    fn_set_notification('E', __('error'), $message, true, 'magiczoom_file_'.md5($file).'_notification');
                }
                */
            }
        }
    }

    return $cancel;

}

function fn_magiczoom_after_install() {

    global $magiczoomDisableNotification;
    $magiczoomDisableNotification = false;

    //NOTE: we need to change position of options in DB, that the content displayed in the right order
    $section = Settings::instance()->getSectionByName($_REQUEST['addon'], Settings::ADDON_SECTION);
    //$section = Settings::instance()->getSectionByName('magiczoom', Settings::ADDON_SECTION);
    $query = 'UPDATE ?:settings_objects SET ?:settings_objects.position = ?:settings_objects.object_id WHERE ?:settings_objects.section_id = ?s';
    db_query($query , $section['section_id']);

    //NOTE: get some default values from CS-Cart settings
    // Products list (category, search, etc) thumbnail width:
    // Products list (category, search, etc) thumbnail height:
    $width = Registry::get('settings.Thumbnails.product_lists_thumbnail_width');
    $height = Registry::get('settings.Thumbnails.product_lists_thumbnail_height');
    if(empty($width)) $width = 0;
    if(empty($height)) $height = 0;
    $query = 'UPDATE ?:settings_objects SET ?u WHERE section_id = ?s AND name = \'category-thumb-max-width\'';
    db_query($query, array('value' => $width), $section['section_id']);
    $query = 'UPDATE ?:settings_objects SET ?u WHERE section_id = ?s AND name = \'category-thumb-max-height\'';
    db_query($query, array('value' => $height), $section['section_id']);
    // Product details page thumbnail width:
    // Product details page thumbnail height:
    $width = Registry::get('settings.Thumbnails.product_details_thumbnail_width');
    $height = Registry::get('settings.Thumbnails.product_details_thumbnail_height');
    if(empty($width)) $width = 0;
    if(empty($height)) $height = 0;
    $query = 'UPDATE ?:settings_objects SET ?u WHERE section_id = ?s AND name = \'product-thumb-max-width\'';
    db_query($query, array('value' => $width), $section['section_id']);
    $query = 'UPDATE ?:settings_objects SET ?u WHERE section_id = ?s AND name = \'product-thumb-max-height\'';
    db_query($query, array('value' => $height), $section['section_id']);
    // Product quick view thumbnail width:
    // Product quick view thumbnail height:
    $width = Registry::get('settings.Thumbnails.product_quick_view_thumbnail_width');
    $height = Registry::get('settings.Thumbnails.product_quick_view_thumbnail_height');
    if(empty($width)) $width = 0;
    if(empty($height)) $height = 0;
    $query = 'UPDATE ?:settings_objects SET ?u WHERE section_id = ?s AND name = \'product-quick-view-thumb-max-width\'';
    db_query($query, array('value' => $width), $section['section_id']);
    $query = 'UPDATE ?:settings_objects SET ?u WHERE section_id = ?s AND name = \'product-quick-view-thumb-max-height\'';
    db_query($query, array('value' => $height), $section['section_id']);
    //NOTE: selector size is hardcoded in design/themes/basic/templates/views/products/components/product_images.tpl

}

function fn_magiczoom_uninstall() {
    fn_magiczoom_send_stat('uninstall');
}

function fn_magiczoom_send_stat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v1.2.18' || 'working' == 'v5.3.7') {
        return;
    }

    $hostname = 'www.magictoolbox.com';
    $url = $_SERVER['HTTP_HOST'].preg_replace('/\/[^\/]*?\.php.*$/i', '', $_SERVER['REQUEST_URI']);
    $url = urlencode(urldecode($url));
    $platformVersion = defined('PRODUCT_VERSION') ? PRODUCT_VERSION : '';
    $path = "api/stat/?action={$action}&tool_name=magiczoom&license=trial&tool_version=v5.3.7&module_version=v1.2.18&platform_name=cscart4&platform_version={$platformVersion}&url={$url}";
    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers  = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }

}
