<?php

use Tygh\Settings;

if(!defined('BOOTSTRAP')) die('Access denied');

if(isset($_REQUEST['addon']) && $_REQUEST['addon'] == 'magicthumb') {

    if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_REQUEST['addon_data'])) {

        $blocks = array('product',
                        'category',
                        'search',
                        'newest', 'recent_products', 'most_popular', 'bestsellers', 'rating', 'on_sale', 'manually',
                   );

        foreach($blocks as $block) {
            if(isset($_REQUEST['addon_data']['options'][$block.'-enabled-options'])) {
                $query = 'UPDATE ?:addon_magicthumb_options SET ?u WHERE block = ?s AND name = \'enabled_options\'';
                db_query($query, array('value' => $_REQUEST['addon_data']['options'][$block.'-enabled-options']), $block);
                //NOTE: fix PHP Notice:  Undefined index: name
                unset($_REQUEST['addon_data']['options'][$block.'-enabled-options']);
                if(isset($_POST['addon_data']['options'][$block.'-enabled-options'])) {
                    unset($_POST['addon_data']['options'][$block.'-enabled-options']);
                }
            }
        }

        $section = Settings::instance()->getSectionByName('magicthumb', Settings::ADDON_SECTION);
        $setting_names = db_get_hash_single_array('SELECT object_id, name FROM ?:settings_objects WHERE section_id = \'?p\' AND type != \'H\' AND type != \'O\'', array('object_id', 'name'), $section['section_id']);
        foreach($_REQUEST['addon_data']['options'] as $setting_id => $value) {
            if(strpos($setting_id, '-enabled-options') !== false) {
                //NOTE: skip 'enabled-options' param
                continue;
            }
            $name = $setting_names[$setting_id];
            if(strpos($name, 'general-') === 0) {
                $param_name = substr($name, 8);
                $param_value = '';
                if(strpos($value, $name.'-') === 0) {
                    $param_value = substr($value, 7);
                }
                foreach($blocks as $block) {
                    $_setting_id  = Settings::instance()->getId($block.'-'.$param_name, 'magicthumb');
                    if(!$_setting_id) {
                        //NOTE: if param does not exists
                        continue;
                    }
                    if(!isset($_REQUEST['addon_data']['options'][$_setting_id])) {
                        $_POST['addon_data']['options'][$_setting_id] =
                        $_REQUEST['addon_data']['options'][$_setting_id] = ($param_value == '')? $value : $block.$param_value;
                    }
                }
            }
        }

    }
}

return array(CONTROLLER_STATUS_OK);

?>
