<?php

use Tygh\Registry;
use Tygh\Storage;
use Tygh\Settings;

if(!defined('BOOTSTRAP')) die('Access denied');

defined('MT_DS') || define('MT_DS', DIRECTORY_SEPARATOR);

function fn_magicslideshow_before_dispatch() {
    if(AREA == 'A') return;
    Registry::get('view')->registerFilter('output', 'fn_magicslideshow');
}


function fn_magicslideshow($output, $view) {

    $block = '';
    $blockId = '';
    $showGallery = false;
    $quickView = false;
    switch($view->template_resource) {
        case 'views/products/view.tpl':
            $block = 'product';
            $products = array($view->getTemplateVars('product'));//$view->tpl_vars['product']->value
        break;
        case 'blocks/products/products_multicolumns.tpl'://Grid
            //NOTE: this template contains the 'blocks/list_templates/grid_list.tpl' template (with show_gallery=true)
            $showGallery = true;
        case 'blocks/products/products_links_thumb.tpl'://Links thumb
        case 'blocks/products/products_scroller.tpl'://Scroller
        case 'blocks/products/grid_list.tpl'://Products grid
        case 'blocks/products/products.tpl'://Products
        case 'blocks/products/products2.tpl'://Products2
        case 'blocks/products/products_bar.tpl'://Products bar
        case 'blocks/products/products_multicolumns2.tpl'://Grid2
        case 'blocks/products/products_multicolumns_small.tpl'://Multicolumns small
        case 'blocks/products/products_sidebox_1_item.tpl'://Side box first item
        case 'blocks/products/products_small_items.tpl'://Small items
        case 'blocks/products/short_list.tpl'://Short list
        case 'blocks/products/products_text_links.tpl'://Text links
        case 'blocks/products/products_without_image.tpl'://Without image
            if(!isset($view->tpl_vars['block']->value['content']['items']['filling'])) return $output;
            $block = $view->tpl_vars['block']->value['content']['items']['filling'];
            if(!in_array($block, array('newest', 'recent_products', 'most_popular', 'bestsellers', 'rating', 'on_sale', 'manually'))) return $output;
            $blockId = $view->tpl_vars['block']->value['block_id'];
            $products = $view->getTemplateVars('items');//$view->tpl_vars['items']->value
        break;
        case 'addons/banners/blocks/carousel.tpl':
        case 'addons/banners/blocks/original.tpl':
            if(!isset($view->tpl_vars['block']->value['properties']['magicslideshow_effect']) || $view->tpl_vars['block']->value['properties']['magicslideshow_effect'] == 'No') return $output;
            $block = 'banners';
            $products = $view->getTemplateVars('items');//$view->tpl_vars['items']->value
            $tool = fn_magicslideshow_load();
            $tool->params->setValue('enable-effect', 'Yes', 'banners');
        break;
        case 'index.tpl':
            $block = 'header';
            $tool = fn_magicslideshow_load();
            //NOTE: we need to apply headers always because we don't know whether the effect is applied to the block in the cache
            fn_magicslideshow_include_headers($output);
            return $output;
        default:
            return $output;
    }
    
    //NOTE: to prevent the re-processing block (e.g. banner block)
    if(isset($GLOBALS['magictoolbox']['processed_blocks']['magicslideshow'][$block.$blockId])) {
        return $output;
    } else {
        $GLOBALS['magictoolbox']['processed_blocks']['magicslideshow'][$block.$blockId] = $block;
    }

    $tool = fn_magicslideshow_load();
    if($tool->params->checkValue('enable-effect', 'No', $block)) return $output;

    if($quickView && $tool->params->checkValue('activate-in-quick-view', 'No', $block)) return $output;

    $tool->params->setValue('block-id', $blockId);
    $tool->params->setValue('products-scroller', $view->template_resource == 'blocks/products/products_scroller.tpl');
    $tool->params->setValue('show-gallery', $showGallery);
    $tool->params->setValue('quick-view', $quickView);

    $output = fn_magicslideshow_parse($output, $products, $block);

    return $output;
}

function fn_magicslideshow_load() {
    if(!isset($GLOBALS['magictoolbox']['magicslideshow'])) {
        require_once(dirname(__FILE__).'/classes/magicslideshow.module.core.class.php');
        $GLOBALS['magictoolbox']['magicslideshow'] = new MagicSlideshowModuleCoreClass();
        $tool = &$GLOBALS['magictoolbox']['magicslideshow'];

        $params = Registry::get('addons.magicslideshow');

        $enabledOptions = db_get_hash_single_array('SELECT block, value FROM ?:addon_magicslideshow_options WHERE name = \'enabled_options\'', array('block', 'value'));

        foreach($params as $pName => $pValue) {
            $paramValue = '';
            if(strpos($pValue, $pName.'-') === 0) {
                $paramValue = substr($pValue, strlen($pName)+1);
            } else {
                $paramValue = $pValue;
            }
            if(strpos($pName, 'general-') === 0) {
                $tool->params->setValue(substr($pName, 8), $paramValue);
            } else {
                $pattern = '/(product|category|search|newest|recent_products|most_popular|bestsellers|rating|on_sale|manually|banners)-(.*)/is';
                $matches = array();
                if(preg_match($pattern, $pName, $matches)) {
                    if(strpos($enabledOptions[$matches[1]], '|'.$matches[2].'|') !== false
                      ) {
                        $tool->params->setValue($matches[2], $paramValue, $matches[1]);
                    }
                }
            }
        }
    } else {
        $tool = &$GLOBALS['magictoolbox']['magicslideshow'];
    }
    return $tool;
}


function fn_magicslideshow_include_headers(&$contents, $simplifiedMode = false) {
    $tool = fn_magicslideshow_load();
    $tool->params->resetProfile();
    $httpPath = Registry::get('config.http_path');
    $headers = '';
    $headers .= $tool->getHeadersTemplate($httpPath.'/app/addons/magicslideshow/resources');



    if($simplifiedMode) {
        return $contents."\r\n".$headers;
    }

    $contents = preg_replace('#</head>#is', $headers.'</head>', $contents, 1);

    $script = '';
    if(!defined('MAGICTOOLBOX_FUNC_JS_INCLUDED')) {
        $script = '<script type="text/javascript" src="'.$httpPath.'/app/addons/magicslideshow/resources/func.js"></script>'."\r\n".$script;
        define('MAGICTOOLBOX_FUNC_JS_INCLUDED', true);
    }
    $contents = preg_replace('#</body>#is', $script.'</body>', $contents, 1);

    return $contents;

}

function fn_magicslideshow_parse(&$contents, $products, $block) {

    $tool = fn_magicslideshow_load();
    $tool->params->setProfile($block);

    //NOTE: Non-ASCII filenames are chunked if no locale is provided
    //$oldLocale = setlocale(LC_ALL, NULL);
    //setlocale(LC_ALL, 'en_US.UTF8');

    switch($block) {
        case 'product':
            $productThumbImageType = $tool->params->getValue('quick-view') ? 'quick-view-thumb' : 'thumb';
            $isMainPairExists = true;
            if(isset($products[0]['main_pair']['detailed']['image_path'])) {
                $imagePath = $products[0]['main_pair']['detailed']['image_path'];
                $imageAlt = $products[0]['main_pair']['detailed']['alt'];
            } else if(isset($products[0]['main_pair']['icon']['image_path'])) {
                $imagePath = $products[0]['main_pair']['icon']['image_path'];
                $imageAlt = $products[0]['main_pair']['icon']['alt'];
            } else if(!empty($products[0]['image_pairs'])) {
                $isMainPairExists = false;
            } else {
                break;
            }

            $imagesData = array();
            $title = $products[0]['product'];
            if($isMainPairExists) {
                $thumb = fn_magicslideshow_create_thumb($imagePath, $productThumbImageType, $products[0]['product_id']);
                if($thumb) {
                    $imagesData[] = array(
                        'title' => $title,
                        'alt' => $imageAlt,
                        'img' => $thumb,
                        'thumb' => fn_magicslideshow_create_thumb($imagePath, 'selector', $products[0]['product_id']),
                        'fullscreen' => fn_magicslideshow_create_thumb($imagePath, 'original', $products[0]['product_id']),
                    );
                }
            }

            $jcarousel = Registry::get('settings.Appearance.thumbnails_gallery') == 'Y';
            if(!empty($products[0]['image_pairs'])) {
                foreach($products[0]['image_pairs'] as $imagePair) {
                    if(isset($imagePair['detailed']['image_path'])) {
                        $imagePairPath = $imagePair['detailed']['image_path'];
                        $imageAlt = $imagePair['detailed']['alt'];
                        //if(!file_exists($imagePair['detailed']['absolute_path'])) {
                            //NOTICE: there is no guarantee that this picture exists
                            //NOTICE: there is no guarantee that this is a picture of this product (it may be a different picture, if the name is the same)
                            //$imageData = fn_image_to_display($imagePair, Registry::get('settings.Thumbnails.product_details_thumbnail_width'), Registry::get('settings.Thumbnails.product_details_thumbnail_height'));
                            //$imagePairPath = $imageData['image_path'];
                        //}
                    } else/* if(isset($imagePair['icon']['image_path']))*/ {
                        $imagePairPath = $imagePair['icon']['image_path'];
                        $imageAlt = $imagePair['icon']['alt'];
                    }
                    $thumb = fn_magicslideshow_create_thumb($imagePairPath, $productThumbImageType, $products[0]['product_id']);
                    if(!$thumb) continue;//NOTE: possibly image does not exists
                    $imagesData[] = array(
                        'title' => $title,
                        'alt' => $imageAlt,
                        'img' => $thumb,
                        'thumb' => fn_magicslideshow_create_thumb($imagePairPath, 'selector', $products[0]['product_id']),
                        'fullscreen' => fn_magicslideshow_create_thumb($imagePairPath, 'original', $products[0]['product_id']),
                    );

                }

            }
            if(empty($imagesData)) break;
            $html = $tool->getMainTemplate($imagesData, array("id" => "MagicSlideshowImage".$block.$products[0]['product_id']));
            /*
            $containerWidth = $tool->params->getValue($productThumbImageType.'-max-width');
            if(!$containerWidth) {
                reset($imagesData);
                $firstItem = current($imagesData);
                $firstItem['img'] = preg_replace('#^'.preg_quote(Registry::get('config.http_path')).'#', '', $firstItem['img']);
                $imagePathFull = Registry::get('config.dir.root').$firstItem['img'];
                if(file_exists($imagePathFull)) {
                    $firstImageSize = getimagesize($imagePathFull);
                    $containerWidth = $firstImageSize[0];
                }
            }
            */
            //$html = '<div class="MagicToolboxContainer" style="width:'.$containerWidth.'px;">'.$html.'</div>';
            $html = '<div class="MagicToolboxContainer">'.$html.'</div>';

            $contents =  preg_replace('/<div class="ty\-product\-img .*?product_images_'.$products[0]['product_id'].'_update\-\->/ims', $html, $contents, -1, $replaced);
            if ($replaced) {
                break;
            }

            $contents =  preg_replace('/<div class="ty\-product\-block__img cm.*?product_images_'.$products[0]['product_id'].'_update\-\-><\/div>/ims', $html, $contents, -1, $replaced);
            if ($replaced) {
                break;
            }

            $contents =  preg_replace('/<div class="ty\-product\-block__img cm.*?<div class="ty\-product\-thumbnails.*?<\/div>.*?<\/div>/ims', $html, $contents, $replaced);
            if ($replaced) {
                break;
            }

            preg_match_all('/<div id="product_images_'.$products[0]['product_id'].'[0-9a-z]{1,}" class="ty\-product\-img.*?<\/div>.*?<div class="ty\-center ty\-product\-bigpicture\-thumbnails_gallery.*?><div class="cm\-image\-gallery\-wrapper ty-thumbnails_gallery">[^<]*<div class="ty\-product\-thumbnails.*?>[^<]*(<div class="cm-item-gallery">.*?<\/div>){1,}[^<]*<\/div>[^<]*<\/div>[^<]*<\/div>/ims', $contents, $m);

            if (!empty($m[0][0])) {
                $contents = str_replace($m[0][0], '<!-- '.$m[0][0].' -->'.str_replace(' maxWidth', '', str_replace('$', '\$', $html)), $contents);
                break;
            }
            
            preg_match_all('/<div id="product_images_'.$products[0]['product_id'].'[0-9a-z]{1,}" class="ty\-product\-img.*?<a.*?<\/a>[^<]*<\/div>/ims', $contents, $m);
            if (!empty($m[0][0])) {
                $contents = str_replace($m[0][0], '<!-- '.$m[0][0].' -->'.str_replace(' maxWidth', '', str_replace('$', '\$', $html)), $contents);
                break;
            }

                $imagePattern = '<div id="product_images_'.$products[0]['product_id'].'[0-9a-z]{1,}" class="ty-product-img cm-preview-wrapper ab-vertical".*?</div>';
                $replaced = 0;
                $contents = preg_replace('#'.$imagePattern.'#ims', str_replace(' maxWidth', '', str_replace('$', '\$', $html)), $contents, 1, $replaced);
                if($replaced) {
                    $contents = preg_replace('#<div class="ty-product-thumbnails[^"]*"[^>]*id="images_preview_'.$products[0]['product_id'].'.*?</div>#is', '', $contents, 1);
                } else {
                


                $additionalThumbnailsPattern =
                    '(<div\b[^>]*?\bclass="[^"]*?\bcm-image-gallery-wrapper\b[^"]*+"[^>]*+>[^<]*+)?'.
                    '<(div|ul)\b[^>]*?\bclass="[^"]*?\bproduct-thumbnails\b[^"]*+"[^>]*+>'.
                    '('.
                    '(?:'.
                        '[^<]++'.
                        '|'.
                        '<(?!/?\2\b|!--)'.
                        '|'.
                        '<!--.*?-->'.
                        '|'.
                        '<\2\b[^>]*+>'.
                            '(?3)'.
                        '</\2\s*+>'.
                    ')*+'.
                    ')'.
                    '</\2\s*+>'.
                    '(?(1)[^<]*+</div\s*+>)';
                $matches = array();
                preg_match('#'.$additionalThumbnailsPattern.'#is', $contents, $matches);

                $imagePattern = '<div class="ty-product-img cm-preview-wrapper" id="product_images_'.$products[0]['product_id'].'[0-9a-z]{1,}">.*?</div>';
                $replaced = 0;
                $contents = preg_replace('#'.$imagePattern.'#ims', str_replace(' maxWidth', '', str_replace('$', '\$', $html)), $contents, 1, $replaced);
                if($replaced) {
                    $contents = preg_replace('#<div class="ty-product-thumbnails[^"]*" id="images_preview_'.$products[0]['product_id'].'.*?</div>#is', '', $contents, 1);
                } else {
                    $imagePattern =
                        '(?:'.
                        //'<img [^>]*?id="det_img_(?!variant_image)[^"]*+"[^>]*+>'.//class=pict, det_img_{$preview_id}_

                        //NOTE: fixed an issue with replacing wrong image (templates/addons/call_requests/views/call_requests/components/lscall_requests_content.tpl)
                        //$preview_id = $products[0]['product_id'].uniqid();
                        '<img [^>]*?id="det_img_'.$products[0]['product_id'].'[0-9][^"]*+"[^>]*+>'.//class=pict, det_img_{$preview_id}_

                        '|'.
                        '<div [^>]*?class="no-image"[^>]*+>.*?</div>'.
                        '|'.
                        '<span [^>]*?class="ty-no-image"[^>]*+>.*?</span>'.
                        ')';
                    $imagePattern =
                        '(?:<a [^>]*?id="det_img_link_[^"]*+"[^>]*+>[^<]*+'.//class=cm-image-previewer, det_img_link_{$preview_id}_
                            $imagePattern.'[^<]*+'.
                            '(?:<span\b[^>]*+>[^<]*+</span>[^<]*+)?'.
                        '</a>|'.
                        $imagePattern.')[^<]*+';

                    $replaced = 0;
                    $contents = preg_replace('#(?:'.$imagePattern.')+#is', str_replace('$', '\$', $html), $contents, 1, $replaced);//NOTE: $limit = 1 to prevent the replacement of product in product tabs(product id == block id)
                    if($replaced && !empty($matches)) {
                        //NOTE: cut selectors
                        $contents = str_replace($matches[0], '', $contents);
                    }
                }
            }
        break;
        case 'newest':
        case 'recent_products':
        case 'most_popular':
        case 'bestsellers':
        case 'rating':
        case 'on_sale':
        case 'manually':
            if(count($products) < 2) break;
            $imagesData = array();
            $useLink = $tool->params->checkValue('link-to-product-page', 'Yes');
            $showGallery = $tool->params->getValue('show-gallery');

            foreach($products as $product) {
                if(isset($product['main_pair']['detailed']['image_path'])) {
                    $imagePath = $product['main_pair']['detailed']['image_path'];
                    $imageAlt = $product['main_pair']['detailed']['alt'];
                    if(isset($product['main_pair']['icon']['image_path'])) {
                        $srcPattern = $product['main_pair']['icon']['image_path'];
                    } else {
                        $srcPattern = $imagePath;
                    }
                } else if(isset($product['main_pair']['icon']['image_path'])) {
                    $imagePath = $product['main_pair']['icon']['image_path'];
                    $imageAlt = $product['main_pair']['icon']['alt'];
                    $srcPattern = $imagePath;
                } else {
                    continue;
                }

                //NOTE: cut off timestamp from URL
                $srcPattern = preg_replace('#\?t=\d+$#i', '', $srcPattern);
                //NOTE: prepare regexp
                $srcPattern = '[^"]*?/'.preg_quote(basename($srcPattern)).'(?:\?t=\d++)?';

                $thumb = fn_magicslideshow_create_thumb($imagePath, 'thumb', $product['product_id']);
                if(!$thumb) continue;//NOTE: possibly image does not exists


                $imagesData[] = array(
                    'title' => $product['product'],
                    'alt' => $imageAlt,
                    'img' => $thumb,
                    'thumb' => fn_magicslideshow_create_thumb($imagePath, 'selector', $product['product_id']),
                    'fullscreen' => fn_magicslideshow_create_thumb($imagePath, 'original', $product['product_id']),
                    'link' => $useLink ? fn_url("products.view?product_id={$product['product_id']}") : '',
                );

            }
            if(count($imagesData) > 1) {
                $html = $tool->getMainTemplate($imagesData, array("id" => $block."MagicSlideshow"));
                $html = '<div class="MagicToolboxContainer">'.$html.'</div>';

                $tags = array('table', 'ul', 'ol', 'div');
                $classes = array(
                    // for table
                    'multicolumns-list',
                    'products2-table',
                    'template-small-list',
                    'products',
                    //'template-grid-list',
                    //'template-grid-list2',

                    // for ul/ol
                    'template-small-item',
                    'ty-template-small',
                    'bullets-list',
                    'text-link-list',
                    'jcarousel-skin',
                    //'template-without-image',

                    // for div
                    'product-container',
                    'ty-product-list',
                    'products-bar-item',
                    'product-item-image',
                    'ty-thumbnail-list',
                    'grid-list',
                    'owl-carousel',
                    'template-item-first',
                    'ty-compact-list',
                    //'template-products',
                    //  'list',
                    //'template-links-thumb',
                    //'ty-scroller-list',
                 );
                $pattern =
                    // Products grid
                    // blocks/products/grid_list.tpl
                    // includes file "blocks/list_templates/products_grid.tpl"
                    // Products2
                    // blocks/products/products2.tpl
                    // includes file "blocks/list_templates/products2.tpl"
                    // Products
                    // blocks/products/products.tpl
                    // includes file "blocks/list_templates/products_list.tpl"
                    // Products bar
                    // blocks/products/products_bar.tpl
                    // includes file "blocks/list_templates/products_bar.tpl"
                    // Links thumb
                    // blocks/products/products_links_thumb.tpl
                    // includes file "blocks/list_templates/links_thumb.tpl"
                    // Grid
                    // blocks/products/products_multicolumns.tpl
                    // includes file "blocks/list_templates/grid_list.tpl"
                    // Grid2
                    // blocks/products/products_multicolumns2.tpl
                    // includes file "blocks/list_templates/grid_list2.tpl"
                    // Multicolumns small
                    // blocks/products/products_multicolumns_small.tpl
                    // includes file "blocks/list_templates/small_list.tpl"
                    // Scroller
                    // blocks/products/products_scroller.tpl
                    // Side box first item
                    // blocks/products/products_sidebox_1_item.tpl
                    // includes file "blocks/list_templates/first_item.tpl"
                    // Small items
                    // blocks/products/products_small_items.tpl
                    // includes file "blocks/list_templates/small_items.tpl"
                    // Text links
                    // blocks/products/products_text_links.tpl
                    // Without image
                    // blocks/products/products_without_image.tpl
                    // includes file "blocks/list_templates/without_image.tpl"
                    // Short list
                    // blocks/products/short_list.tpl
                    // includes file "blocks/product_list_templates/short_list.tpl"
                    //     includes file "blocks/list_templates/compact_list.tpl"
                    '(?:'.
                    '<('.implode('|', $tags).')\b[^>]*?\bclass="[^"]*?(?<=\s|")(?:'.implode('|', $classes).')(?=\s|")[^"]*+"[^>]*+>'.
                    '('.
                    '(?:'.
                        '[^<]++'.
                        '|'.
                        '<(?!/?\1\b|!--)'.
                        '|'.
                        '<!--.*?-->'.
                        '|'.
                        '<\1\b[^>]*+>'.
                            '(?2)'.
                        '</\1\s*+>'.
                    ')*+'.
                    ')'.
                    '</\1\s*+>'.
                    '[^<]*+'.
                    '(?:<hr\b[^>]*+>[^<]*+)?'.
                    ')+'
                    ;
                //$matches = array();
                //preg_match_all('#'.$pattern.'#is', $contents, $matches, PREG_SET_ORDER);
                $contents = preg_replace('#'.$pattern.'#is', str_replace('$', '\$', $html), $contents, 1);
            }

        break;
        case 'banners':
            if(count($products) < 2) break;
            $imagesData = array();
            //$wysiwygContentData = array();
            $notUseLink = $tool->params->checkValue('link-to-product-page', 'No');

            foreach($products as $banner) {
                if(isset($banner['main_pair']['icon']['image_path'])) {
                    $imagePath = $banner['main_pair']['icon']['image_path'];
                    $imageAlt = $banner['main_pair']['icon']['alt'];
                } else {
                    //if($banner['type'] != "G") {
                    //    $wysiwygContentData[] = preg_quote($banner['description'], '/');
                    //}
                    continue;
                }
                $thumb = fn_magicslideshow_create_thumb($imagePath, 'thumb', 'banners');
                if(!$thumb) continue;//NOTE: possibly image does not exists
                $link = $notUseLink || empty($banner['url']) ? '' : fn_url($banner['url']);

                if(empty($imageAlt)) {
                    $title = $alt = '';
                    $description = $banner['banner'];
                } else {
                    $title = $alt = $banner['banner'];
                    $description = $imageAlt;
                }

                $imagesData[] = array(
                    'title' => $title,
                    'alt' => $alt,
                    'description' => $description,
                    'img' => $thumb,
                    'thumb' => fn_magicslideshow_create_thumb($imagePath, 'selector', 'banners'),
                    'fullscreen' => fn_magicslideshow_create_thumb($imagePath, 'original', 'banners'),
                    'link' => $link,
                    'target' => $banner['target'] == 'B' ? '_blank' : '',
                );
            }

            if(count($imagesData) > 1 ) {
                $html = $tool->getMainTemplate($imagesData, array("id" => $block."MagicSlideshow"));
                //$html = '<div class="MagicToolboxContainer" style="margin: auto;">'.$html.'</div>';
                $html = '<div class="MagicToolboxContainer">'.$html.'</div>';


                $contents = $html;
            }

        break;
    }

    //setlocale(LC_ALL, $oldLocale);
    $tool->params->resetProfile();

    return $contents;

}

function fn_magicslideshow_create_thumb($src, $size, $pid) {

    static $imagehelper = null;
    static $prefix = '';

    if($imagehelper === null) {

        $prefix = Registry::get('config.current_location');

        $options = Settings::instance()->getValue('cdn', '');

        //NOTE: in some cases CDN is disabled at frontend (although it is activated in the settings)
        //      so this is an additional check
        $_options = Storage::instance('images')->options;
        $isCdnEnabled = isset($_options['cdn']) && $_options['cdn'];

        if(!empty($options) && $isCdnEnabled) {
            $options = unserialize($options);
            if((bool)$options['is_enabled']) {
                /*
                $cdn = Cdn::instance()->getHost('host');
                if(!empty($cdn)) {
                    $prefix = (defined('HTTPS') ? 'https:' : 'http:').'//'.$cdn;
                }
                */
                if(!empty($options['cname'])) {
                    $prefix = (defined('HTTPS') ? 'https:' : 'http:').'//'.$options['cname'];
                } else if(!empty($options['host'])) {
                    $prefix = (defined('HTTPS') ? 'https:' : 'http:').'//'.$options['host'];
                }
            }
        }

        $tool = fn_magicslideshow_load();
        require_once(dirname(__FILE__).'/classes/magictoolbox.imagehelper.class.php');
        $imagehelper = new MagicToolboxImageHelperClass(Registry::get('config.dir.root'), '/images/magictoolbox_cache', $tool->params, null, Registry::get('config.http_path'));
    }

    $src = str_replace($prefix, '', $src);//NOTE: with /
    $src = preg_replace('#\?.*+$#', '', $src);//NOTE: if it has some GET options, cut it
    $src = htmlspecialchars_decode($src, ENT_QUOTES);

    $thumb = $imagehelper->create($src, $size, $pid);
    //NOTE: spike to get real size of image
    //$GLOBALS['magictoolbox']['file_path'] = $imagehelper->file;
    if(MT_DS != '/') {
        $thumb = str_replace(MT_DS, '/', $thumb);
    }

    return $thumb;

}

function fn_magicslideshow_js_functions() {

    global $magicslideshowDisableNotification;

    if(!isset($magicslideshowDisableNotification) || !$magicslideshowDisableNotification)
    if(Registry::get("addons.magicslideshow.status") === 'D') {
        $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic Slideshow module should be enabled for proper operation of the settings page." .
                   "<br/>Please enable it before save settings.</span>";
        fn_set_notification('E', __('warning'), $message, true, 'magicslideshow_module_disabled_notification');
    }

    return '
        <script type="text/javascript">
            //<![CDATA[
            function fn_magicslideshow_prepare_custom_options(block, skip) {
                skip = (skip || \'\').split(\'|\');
                skip.push(\'enable-effect\');
                var enabledOptionsID = "#addon_option_magicslideshow_" + block + "-enabled-options";
                var enabledOptions = $(enabledOptionsID).val();
                var sectionID = "#content_magicslideshow_magicslideshow_" + block;
                $(sectionID + " div.controls").
                each(function(){
                        $(this).
                         find("select, input[type=\'text\']").
                         each(function(){
                                var optionId = this.id.replace("addon_option_magicslideshow_" + block + "-","");
                                if(jQuery.inArray(optionId, skip) !== -1) {
                                    return;
                                }
                                if(enabledOptions.indexOf("|" + optionId + "|") == -1) {
                                    $(this).attr("disabled", true).after("&nbsp;&nbsp;<a href=\"#\" >edit</a>");
                                } else {
                                    $(this).after("&nbsp;&nbsp;<a href=\"#\" >use default option</a>");
                                }
                                $(this).next().
                                    bind("click", {optionId: optionId, enabledOptionsID: enabledOptionsID},
                                                    function(event) {
                                                        var enabledOptions = $(event.data.enabledOptionsID).val();
                                                        if($(this).html() == "edit") {
                                                            $(this).html("use default option").prev().removeAttr("disabled");
                                                            enabledOptions = enabledOptions.concat(event.data.optionId + "|");
                                                        } else {
                                                            $(this).html("edit").prev().attr("disabled", true).val($("#addon_option_magicslideshow_general-" + event.data.optionId).val().replace("general-", block + "-"));
                                                            var pattern = new RegExp("\\\\|" + event.data.optionId + "\\\\|", "g");
                                                            enabledOptions = enabledOptions.replace(pattern, "|");
                                                        }
                                                        $(event.data.enabledOptionsID).val(enabledOptions);
                                                        return false;
                                                }
                                        );
                              }).
                         end().
                         find("input[type=\'radio\']:checked").
                         each(function(){
                                var optionId = this.parentNode.parentNode.id.replace("addon_option_magicslideshow_" + block + "-","");
                                if(jQuery.inArray(optionId, skip) !== -1) {
                                    return;
                                }
                                if(enabledOptions.indexOf("|" + optionId + "|") == -1) {
                                    $(this.parentNode.parentNode).find("input").attr("disabled", true).end().
                                     find("label:last-child").after("&nbsp;&nbsp;<a href=\"#\" >edit</a>");
                                } else {
                                    $(this.parentNode.parentNode).find("label:last-child").after("&nbsp;&nbsp;<a href=\"#\" >use default option</a>");
                                }
                                $(this.parentNode.parentNode).find("a:last-child").
                                    bind("click", {optionId: optionId, enabledOptionsID: enabledOptionsID},
                                                    function(event) {
                                                        var enabledOptions = $(event.data.enabledOptionsID).val();
                                                        if($(this).html() == "edit") {
                                                            $(this).html("use default option");
                                                            $(this.parentNode.parentNode).find("input").removeAttr("disabled");
                                                            enabledOptions = enabledOptions.concat(event.data.optionId + "|");
                                                        } else {
                                                            $(this).html("edit");
                                                            $(this.parentNode.parentNode).find("input").attr("disabled", true).val([$("#addon_option_magicslideshow_general-" + optionId + " input:checked").val().replace("general", block)]);
                                                            var pattern = new RegExp("\\\\|" + event.data.optionId + "\\\\|", "g");
                                                            enabledOptions = enabledOptions.replace(pattern, "|");
                                                        }
                                                        $(event.data.enabledOptionsID).val(enabledOptions);
                                                        return false;
                                                }
                                        );
                              });
                      });
            }
            //]]>
        </script>
';

}

function fn_magicslideshow_prepare_custom_options($block) {

    static $addonOptions;
    static $enabledOptions;
    $headersBind = '';
    $generalParamsChangeBind = '';
    $includeOptionsJs = '';
    $initOptionsValidation = '';
    $magicscrollIcon = '';
    $blocks = array('product',
                    'newest', 'recent_products', 'most_popular', 'bestsellers', 'rating', 'on_sale', 'manually',
                    'banners',
                   );

    if(!isset($addonOptions)) {
        $section = Settings::instance()->getSectionByName($_REQUEST['addon'], Settings::ADDON_SECTION);
        $addonOptions = db_get_hash_single_array('SELECT name, value FROM ?:settings_objects WHERE section_id = \'?p\' AND type != \'H\'', array('name', 'value'), $section['section_id']);
        $enabledOptions = db_get_hash_single_array('SELECT block, value FROM ?:addon_magicslideshow_options WHERE name = \'enabled_options\'', array('block', 'value'));
    }

    switch($block) {
        case 'general':
            if(isset($addonOptions['cache-path-to-cache'])) {
                $pathToCache = $addonOptions['cache-path-to-cache'];
            } else {
                $pathToCache = '/images/magictoolbox_cache';
            }
            $tool = fn_magicslideshow_load();
            require_once(dirname(__FILE__).'/classes/magictoolbox.imagehelper.class.php');
            $imagehelper = new MagicToolboxImageHelperClass(Registry::get('config.dir.root'), $pathToCache, $tool->params);
            $usedSubCache = $imagehelper->getOptionsHash();
            $cacheInfo = fn_magicslideshow_getCacheInfo(Registry::get('config.dir.root').$pathToCache, $usedSubCache);
            $cacheInfo['formatedTotalSize'] = fn_magicslideshow_format_size($cacheInfo['totalSize']);
            $cacheInfo['formatedUnusedSize'] = fn_magicslideshow_format_size($cacheInfo['unusedSize']);
            $indexScript = Registry::get('config.admin_index');
            $return =<<<RETURN
<div class="control-group setting-wide magicslideshow">
    <label for="addon_option_magicslideshow_cache-path-to-cache" class="control-label" >Path to cache folder&nbsp;<a class="cm-tooltip" title="Relative for site base path."><i class="icon-question-sign"></i></a>:</label>
    <div class="controls">
        <input id="addon_option_magicslideshow_cache-path-to-cache" type="text" name="addon_data[options][cache-path-to-cache]" value="{$pathToCache}" style="width:352px;" disabled="disabled" />
        <div class="right update-for-all"></div>
    </div>
</div>
<div class="control-group setting-wide magicslideshow">
    <label for="addon_option_magicslideshow_cache-total-items" class="control-label" >Total items:</label>
    <div class="controls">
        <input id="addon_option_magicslideshow_cache-total-items" type="text" name="addon_data[options][cache-total-items]" value="{$cacheInfo['totalCount']} ({$cacheInfo['formatedTotalSize']})" size="30" disabled="disabled" />
        <div class="right update-for-all"></div>
    </div>
</div>
<div class="control-group setting-wide magicslideshow">
    <label for="addon_option_magicslideshow_cache-unused-items" class="control-label" >Unused items:</label>
    <div class="controls">
        <input id="addon_option_magicslideshow_cache-unused-items" type="text" name="addon_data[options][cache-unused-items]" value="{$cacheInfo['unusedCount']} ({$cacheInfo['formatedUnusedSize']})" size="30" disabled="disabled" />
        <div class="right update-for-all"></div>
    </div>
</div>
<div class="control-group setting-wide magicslideshow">
    <label for="addon_option_magicslideshow_cache-what-clear" class="control-label " >Empty cache:</label>
    <div class="controls">
        <select id="addon_option_magicslideshow_cache-what-clear" onchange="$('#magicslideshow_clear_cache_field').attr('href', '{$indexScript}?dispatch=magicslideshow_cache.'+this.value).attr('rev', this.value);">
            <option value="clear_unused_items" selected="selected">Delete unused items</option>
            <option value="clear_all_items">Delete all items</option>
        </select>
        &nbsp;<a data-ca-event="ce.magicslideshow_clear_cache_field" name="magicslideshow_clear_cache_field" id="magicslideshow_clear_cache_field" href="{$indexScript}?dispatch=magicslideshow_cache.clear_unused_items" class="cm-ajax cm-confirm" rev="clear_unused_items" >Clear</a>
        <div class="right update-for-all"></div>
    </div>
</div>
RETURN;
            return $return;
            break;
        case 'banners':
            //only after last block
            $blocks  = '"'.implode('", "', $blocks).'"';

            //NOTE: does not work in hidden tabs
            //$headersBind = '$("#tabs_content_magicslideshow h4.subheader").slice(1).click();';

            $headersBind = '
$("#tabs_content_magicslideshow h4.subheader").slice(1).each(function() {
    var subheader = $(this);
    var target = subheader.attr(\'data-target\');
    subheader.addClass(\'collapsed\');
    $(target).removeClass(\'in\');
});
';

            $generalParamsChangeBind = '
$("#content_magicslideshow_magicslideshow_general").find("input[type=\'text\']").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.id.replace("addon_option_magicslideshow_general-","");
var optioVal = $(this).val();
for(block in block_array) {
    $("#content_magicslideshow_magicslideshow_" + block_array[block]).
    find("#addon_option_magicslideshow_" + block_array[block] + "-" + optionId + ":disabled").val(optioVal);
}
}).
end().find("select").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.id.replace("addon_option_magicslideshow_general-","");
var optioVal = $(this).val().replace("general-" + optionId + "-", "");
for(block in block_array) {
    $("#content_magicslideshow_magicslideshow_" + block_array[block]).
    find("#addon_option_magicslideshow_" + block_array[block] + "-" + optionId + ":disabled").val(block_array[block] + "-" + optionId + "-" + optioVal);
}
}).
end().find("input[type=\'radio\']").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.parentNode.parentNode.id.replace("addon_option_magicslideshow_general-","");
var optioVal = $(this).val().replace("general-" + optionId + "-", "");
for(block in block_array) {
    $("#content_magicslideshow_magicslideshow_" + block_array[block]).
    find("#addon_option_magicslideshow_" + block_array[block] + "-" + optionId + " input:disabled").val([block_array[block] + "-" + optionId + "-" + optioVal]);
}
});';
    }

    $tool = fn_magicslideshow_load();
    $skip = array();
    $skip[] = 'quick-view-thumb-max-width';
    $skip[] = 'quick-view-thumb-max-height';


    $skip = implode('|', $skip);
    return $includeOptionsJs.'
        <input type="hidden" name="addon_data[options]['.$block.'-enabled-options]" id="addon_option_magicslideshow_'.$block.'-enabled-options" value="'.$enabledOptions[$block].'" />
        <script type="text/javascript">
            //<![CDATA[
                function fn_magicslideshow_prepare_'.$block.'_block_options() {
                    fn_magicslideshow_prepare_custom_options("'.$block.'", \''.$skip.'\');
                    '.$headersBind.$generalParamsChangeBind.$initOptionsValidation.$magicscrollIcon.'
                }
            //]]>
        </script>
    ';
}

function fn_magicslideshow_getCacheInfo($path, $usedSubCache = null) {

    $totalSize = 0;
    $totalCount = 0;
    $usedSize = 0;
    $usedCount = 0;
    if (is_dir($path))
    if ($handle = opendir($path)) {
        while (false !== ($file = readdir($handle))) {
            $next = $path.MT_DS.$file;
            if ($file != '.' && $file != '..' && !is_link($next)) {
                if (is_dir($next)) {
                    $result = fn_magicslideshow_getCacheInfo($next);
                    if($file == $usedSubCache) {
                        $usedSize += $result['totalSize'];
                        $usedCount += $result['totalCount'];
                    }
                    $totalSize += $result['totalSize'];
                    $totalCount += $result['totalCount'];
                } elseif (is_file($next)) {
                    $totalSize += filesize($next);
                    $totalCount++;
                }
            }
        }
        closedir($handle);
    }
    return array('totalSize' => $totalSize, 'totalCount' => $totalCount, 'unusedSize' => $totalSize-$usedSize, 'unusedCount' => $totalCount-$usedCount);
}

function fn_magicslideshow_format_size($size) {
    $units = array(' bytes', ' KB', ' MB', ' GB', ' TB');
    for ($i = 0; $size >= 1024 && $i < 4; $i++) $size /= 1024;
    return round($size, 2).$units[$i];
}

function fn_magicslideshow_install() {

    global $magicslideshowDisableNotification;
    $magicslideshowDisableNotification = true;

    $moduleDirectory = str_replace(array("//", "\\"), array("/", "/"), Registry::get('config.dir.addons').'/magicslideshow');

    $cancel = false;

    if(!defined('PRODUCT_VERSION') || version_compare(PRODUCT_VERSION, '4.0.0', '<')) {
        $cancel = true;
        if(!fn_notification_exists('E', 'magicslideshow_module_version_notification')) {
            $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">This Magic Slideshow module is intended only for CS Cart Version 4 and above.".
                       "<br/>Your version of CS Cart is ".PRODUCT_VERSION."</span>";
            fn_set_notification('E', __('error'), $message, true, 'magicslideshow_module_version_notification');
        }
    }

    if($cancel) {
        $args = func_get_args();
        if(!empty($args)) fn_redirect("addons.manage");
        return;
    }

    //fix url's in css files
    $cancel = fn_magicslideshow_fix_css();


    if($cancel) {
        $args = func_get_args();
        if(!empty($args)) fn_redirect("addons.manage");
        return;
    }


    fn_magicslideshow_send_stat('install');

}

function fn_magicslideshow_fix_css() {

    $cancel = false;

    $path = dirname(__FILE__).'/resources';

    $resourcesPath = Registry::get('config.current_path').substr(Registry::get('config.dir.addons'), strlen(Registry::get('config.dir.root'))).'magicslideshow/resources';
    $resourcesPath = str_replace(array("//", "\\"), array("/", "/"), $resourcesPath);

    $list = glob($path.'/*');
    $files = array();
    if(is_array($list)) {
        for($i = 0; $i < count($list); $i++) {
            if(is_dir($list[$i])) {
                if(!in_array(basename($list[$i]), array('.svn', '.git'))) {
                    $add = glob($list[$i].'/*');
                    if(is_array($add)) {
                        $list = array_merge($list, $add);
                    }
                }
            } else if(preg_match('#\.css$#i', $list[$i])) {
                $files[] = $list[$i];
            }
        }
    }

    foreach($files as $file) {
        $cssPath = dirname($file);
        $cssRelPath = str_replace($path, '', $cssPath);
        $toolPath = $resourcesPath.$cssRelPath;
        $pattern = '#url\(\s*(\'|")?(?!data:|mhtml:|http(?:s)?:|/)([^\)\s\'"]+?)(?(1)\1)\s*\)#is';
        $replace = 'url($1'.$toolPath.'/$2$1)';
        $fileContents = file_get_contents($file);
        $fixedFileContents = preg_replace($pattern, $replace, $fileContents);
        if($fixedFileContents != $fileContents) {
            if(is_writeable($file)) {
                file_put_contents($file, $fixedFileContents);
            } else {
                //NOTE: install module anyway
                /*
                $cancel = true;
                if(!fn_notification_exists('E', 'magicslideshow_file_'.md5($file).'_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic Slideshow needs write access to the file <b>'".$file."'</b> for proper installation." .
                                "<br/>Please fix this and reinstall Magic Slideshow.</span>";
                    fn_set_notification('E', __('error'), $message, true, 'magicslideshow_file_'.md5($file).'_notification');
                }
                */
            }
        }
    }

    return $cancel;

}

function fn_magicslideshow_after_install() {

    global $magicslideshowDisableNotification;
    $magicslideshowDisableNotification = false;

    //NOTE: we need to change position of options in DB, that the content displayed in the right order
    $section = Settings::instance()->getSectionByName($_REQUEST['addon'], Settings::ADDON_SECTION);
    //$section = Settings::instance()->getSectionByName('magicslideshow', Settings::ADDON_SECTION);
    $query = 'UPDATE ?:settings_objects SET ?:settings_objects.position = ?:settings_objects.object_id WHERE ?:settings_objects.section_id = ?s';
    db_query($query , $section['section_id']);


}

function fn_magicslideshow_uninstall() {
    fn_magicslideshow_send_stat('uninstall');
}

function fn_magicslideshow_send_stat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v1.2.18' || 'working' == 'v3.2.12') {
        return;
    }

    $hostname = 'www.magictoolbox.com';
    $url = $_SERVER['HTTP_HOST'].preg_replace('/\/[^\/]*?\.php.*$/i', '', $_SERVER['REQUEST_URI']);
    $url = urlencode(urldecode($url));
    $platformVersion = defined('PRODUCT_VERSION') ? PRODUCT_VERSION : '';
    $path = "api/stat/?action={$action}&tool_name=magicslideshow&license=trial&tool_version=v3.2.12&module_version=v1.2.18&platform_name=cscart4&platform_version={$platformVersion}&url={$url}";
    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers  = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }

}
