<?php

use Tygh\Registry;
use Tygh\Settings;

if(!defined('BOOTSTRAP')) die('Access denied');

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    return array(CONTROLLER_STATUS_OK);
}

if($mode == 'clear_all_items' || $mode == 'clear_unused_items') {

    $section = Settings::instance()->getSectionByName(/*$_REQUEST['addon']*/'magicscroll', Settings::ADDON_SECTION);
    $addon_options = db_get_hash_single_array('SELECT name, value FROM ?:settings_objects WHERE section_id = \'?p\' AND type != \'H\'', array('name', 'value'), $section['section_id']);

    if(isset($addon_options['cache-path-to-cache'])) {
        $pathToCache = $addon_options['cache-path-to-cache'];
    } else {
        $pathToCache = '/images/magictoolbox_cache';
    }
    $tool = fn_magicscroll_load();
    require_once(dirname(__FILE__) . '/../../classes/magictoolbox.imagehelper.class.php');
    $imagehelper = new MagicToolboxImageHelperClass(Registry::get('config.dir.root'), $pathToCache, $tool->params);
    $usedSubCache = $imagehelper->getOptionsHash();

    if(is_dir(Registry::get('config.dir.root').$pathToCache))
        fn_magicscroll_clearCache(Registry::get('config.dir.root').$pathToCache, ($mode == 'clear_all_items') ? null : $usedSubCache);

    fn_set_notification('N', __('notice'), "Image cache was cleared.");

    $cacheInfo = fn_magicscroll_getCacheInfo(Registry::get('config.dir.root').$pathToCache, $usedSubCache);
    echo $cacheInfo['totalCount'].' ('.fn_magicscroll_format_size($cacheInfo['totalSize']).')';
    exit;
}

return array(CONTROLLER_STATUS_OK);

function fn_magicscroll_clearCache($path, $usedSubCache = null) {

    $files = glob($path.DIRECTORY_SEPARATOR.'*');
    if($files !== FALSE && !empty($files)) {
        foreach($files as $file) {
            if(is_dir($file)) {
                if(!$usedSubCache || $usedSubCache != substr($file, strrpos($file, DIRECTORY_SEPARATOR)+1)) {
                    fn_magicscroll_clearCache($file);
                    @rmdir($file);
                }
            } else {
                @unlink($file);
            }
        }
    }
    return;
}

?>
