<?php

use Tygh\Registry;
use Tygh\Storage;
use Tygh\Settings;

if(!defined('BOOTSTRAP')) die('Access denied');

defined('MT_DS') || define('MT_DS', DIRECTORY_SEPARATOR);

function fn_magic360_before_dispatch() {
    if(AREA == 'A') return;
    Registry::get('view')->registerFilter('output', 'fn_magic360');
}


function fn_magic360($output, $view) {

    $block = '';
    $blockId = '';
    $showGallery = false;
    $quickView = false;
    switch($view->template_resource) {
        case 'views/products/view.tpl':
            $block = 'product';
            $products = array($view->getTemplateVars('product'));//$view->tpl_vars['product']->value
        break;
        case 'index.tpl':
            $block = 'header';
            $tool = fn_magic360_load();
            //NOTE: we need to apply headers always because we don't know whether the effect is applied to the block in the cache
            fn_magic360_include_headers($output);
            return $output;
        default:
            return $output;
    }
    
    //NOTE: to prevent the re-processing block (e.g. banner block)
    if(isset($GLOBALS['magictoolbox']['processed_blocks']['magic360'][$block.$blockId])) {
        return $output;
    } else {
        $GLOBALS['magictoolbox']['processed_blocks']['magic360'][$block.$blockId] = $block;
    }

    $tool = fn_magic360_load();
    if($tool->params->checkValue('enable-effect', 'No', $block)) return $output;

    if($quickView && $tool->params->checkValue('activate-in-quick-view', 'No', $block)) return $output;

    $tool->params->setValue('block-id', $blockId);
    $tool->params->setValue('products-scroller', $view->template_resource == 'blocks/products/products_scroller.tpl');
    $tool->params->setValue('show-gallery', $showGallery);
    $tool->params->setValue('quick-view', $quickView);

    $output = fn_magic360_parse($output, $products, $block);

    return $output;
}

function fn_magic360_load() {
    if(!isset($GLOBALS['magictoolbox']['magic360'])) {
        require_once(dirname(__FILE__).'/classes/magic360.module.core.class.php');
        $GLOBALS['magictoolbox']['magic360'] = new Magic360ModuleCoreClass();
        $tool = &$GLOBALS['magictoolbox']['magic360'];

        $params = Registry::get('addons.magic360');

        $enabledOptions = db_get_hash_single_array('SELECT block, value FROM ?:addon_magic360_options WHERE name = \'enabled_options\'', array('block', 'value'));

        foreach($params as $pName => $pValue) {
            $paramValue = '';
            if(strpos($pValue, $pName.'-') === 0) {
                $paramValue = substr($pValue, strlen($pName)+1);
            } else {
                $paramValue = $pValue;
            }
            if(strpos($pName, 'general-') === 0) {
                $tool->params->setValue(substr($pName, 8), $paramValue);
            } else {
                $pattern = '/(product|category|search|newest|recent_products|most_popular|bestsellers|rating|on_sale|manually|banners)-(.*)/is';
                $matches = array();
                if(preg_match($pattern, $pName, $matches)) {
                    if(strpos($enabledOptions[$matches[1]], '|'.$matches[2].'|') !== false
                      ) {
                        $tool->params->setValue($matches[2], $paramValue, $matches[1]);
                    }
                }
            }
        }
    } else {
        $tool = &$GLOBALS['magictoolbox']['magic360'];
    }
    return $tool;
}


function fn_magic360_include_headers(&$contents, $simplifiedMode = false) {
    $tool = fn_magic360_load();
    $tool->params->resetProfile();
    $httpPath = Registry::get('config.http_path');
    $headers = '';
    $headers .= $tool->getHeadersTemplate($httpPath.'/app/addons/magic360/resources');



    if($simplifiedMode) {
        return $contents."\r\n".$headers;
    }

    $pattern = '<!-- Magic (Zoom|Thumb)(?: Plus)? CS-Cart module[^>]*+>'.
               '[^<]*+<link\b[^>]*?href="[^"]*?magic(?:zoom(?:plus)?|thumb|scroll)\.css"[^>]*+>';
    $matches = array();
    if(preg_match_all('#'.$pattern.'#is', $contents, $matches, PREG_SET_ORDER)) {
        if($matches[0][1] == 'Zoom') {
            //NOTE: place magic360 headers before magiczoom(plus) headers
            $contents = str_replace($matches[0][0], $headers."\r\n".$matches[0][0], $contents);
        } else if(isset($matches[1])) {
            //NOTE: place magic360 headers before magicscroll headers (after magicthumb)
            $contents = str_replace($matches[1][0], $headers."\r\n".$matches[1][0], $contents);
        } else {
            $contents = preg_replace('#</head>#is', $headers.'</head>', $contents, 1);
        }
    } else
    $contents = preg_replace('#</head>#is', $headers.'</head>', $contents, 1);

    $script = '';
    if(!defined('MAGICTOOLBOX_FUNC_JS_INCLUDED')) {
        $script = '<script type="text/javascript" src="'.$httpPath.'/app/addons/magic360/resources/func.js"></script>'."\r\n".$script;
        define('MAGICTOOLBOX_FUNC_JS_INCLUDED', true);
    }
    $contents = preg_replace('#</body>#is', $script.'</body>', $contents, 1);

    return $contents;

}

function fn_magic360_parse(&$contents, $products, $block) {

    $tool = fn_magic360_load();
    $tool->params->setProfile($block);

    //NOTE: Non-ASCII filenames are chunked if no locale is provided
    //$oldLocale = setlocale(LC_ALL, NULL);
    //setlocale(LC_ALL, 'en_US.UTF8');

    switch($block) {
        case 'product':
            $productThumbImageType = $tool->params->getValue('quick-view') ? 'quick-view-thumb' : 'thumb';

            $data = db_get_row('SELECT gallery, columns FROM ?:addon_magic360_images WHERE id = ?i', $products[0]['product_id']);
            if(empty($data) || empty($data['gallery'])) break;
            $magic360Images = explode(';', $data['gallery']);
            $magic360ImagesCount = count($magic360Images);
            $magic360Columns = $data['columns'];
            $magic360Rows = 1;
            if($data['columns'] && $data['columns'] < $magic360ImagesCount) {
                $magic360Rows = floor($magic360ImagesCount/intval($data['columns']));
            }
            //$baseImagePath = Registry::get('config.dir.root').'/images/magic360/';
            $baseImagePath = '/images/magic360/';
            $imagesData = array();

            $jcarousel = Registry::get('settings.Appearance.thumbnails_gallery') == 'Y';
            foreach($magic360Images as $imageId => $image) {
                $imagesData[] = array(
                    'img' => fn_magic360_create_thumb($baseImagePath.$image, 'original', $products[0]['product_id']),
                    'medium' => fn_magic360_create_thumb($baseImagePath.$image, $productThumbImageType, $products[0]['product_id']),
                );
            }
            $tool->params->setValue('columns', $magic360Columns, 'product');

            $containerWidth = $tool->params->getValue($productThumbImageType.'-max-width');
            if(!$containerWidth) {
                reset($magic360Images);
                $firstImage = current($magic360Images);
                $imagePathFull = Registry::get('config.dir.root').'/images/magic360/'.$firstImage;
                $firstImageSize = getimagesize($imagePathFull);
                $containerWidth = $firstImageSize[0];
            }

            $html = $tool->getMainTemplate($imagesData, array("id" => "Magic360Image".$block.$products[0]['product_id']));

            if(isset($GLOBALS['magictoolbox']['cooperative_mode'])) {
                $s360IconPath = $tool->params->getValue('icon');
                if(!empty($s360IconPath) && file_exists(Registry::get('config.dir.root').'/images/'.$s360IconPath)) {
                    $magic360SelectorClass = 'm360-selector active-selector';
                    if($tool->params->getValue('original-layout', 'product')) {
                        $magic360SelectorClass .= ' cm-gallery-item cm-thumbnails-mini thumbnails-item';
                    }
                    $magic360Selector = '<a class="'.$magic360SelectorClass.'" title="360" href="#" onclick="return false;"><img src="'.
                        fn_magic360_create_thumb('/images/'.$s360IconPath, 'selector', '360selector').
                        '" alt="360" /></a>';
                    if(in_array($GLOBALS['magictoolbox']['cooperative_mode'], array('magiczoom', 'magiczoomplus'))) {
                        $magic360Selector = preg_replace('#<a\b[^>]+?class="#i', '$0zoom-with-360 ', $magic360Selector);
                    }
                    $contents = str_replace('<!-- MAGIC360SELECTOR -->', $magic360Selector, $contents);
                } else {
                    $contents = str_replace('<!-- MAGIC360SELECTOR -->', '', $contents);
                }
                $contents = str_replace('<!-- MAGIC360 -->', $html, $contents);
                break;
            }

            $html = '<div class="MagicToolboxContainer" style="width:'.$containerWidth.'px; margin: auto;">'.$html.'</div>';


            $contents =  preg_replace('/<div class="ty\-product\-img .*?product_images_'.$products[0]['product_id'].'_update\-\->/ims', $html, $contents, -1, $replaced);
            if ($replaced) {
                break;
            }

            $contents =  preg_replace('/<div class="ty\-product\-block__img cm.*?product_images_'.$products[0]['product_id'].'_update\-\-><\/div>/ims', $html, $contents, -1, $replaced);
            if ($replaced) {
                break;
            }

            $contents =  preg_replace('/<div class="ty\-product\-block__img cm.*?<div class="ty\-product\-thumbnails.*?<\/div>.*?<\/div>/ims', $html, $contents, $replaced);
            if ($replaced) {
                break;
            }

            preg_match_all('/<div id="product_images_'.$products[0]['product_id'].'[0-9a-z]{1,}" class="ty\-product\-img.*?<\/div>.*?<div class="ty\-center ty\-product\-bigpicture\-thumbnails_gallery.*?><div class="cm\-image\-gallery\-wrapper ty-thumbnails_gallery">[^<]*<div class="ty\-product\-thumbnails.*?>[^<]*(<div class="cm-item-gallery">.*?<\/div>){1,}[^<]*<\/div>[^<]*<\/div>[^<]*<\/div>/ims', $contents, $m);

            if (!empty($m[0][0])) {
                $contents = str_replace($m[0][0], '<!-- '.$m[0][0].' -->'.str_replace(' maxWidth', '', str_replace('$', '\$', $html)), $contents);
                break;
            }
            
            preg_match_all('/<div id="product_images_'.$products[0]['product_id'].'[0-9a-z]{1,}" class="ty\-product\-img.*?<a.*?<\/a>[^<]*<\/div>/ims', $contents, $m);
            if (!empty($m[0][0])) {
                $contents = str_replace($m[0][0], '<!-- '.$m[0][0].' -->'.str_replace(' maxWidth', '', str_replace('$', '\$', $html)), $contents);
                break;
            }

                $imagePattern = '<div id="product_images_'.$products[0]['product_id'].'[0-9a-z]{1,}" class="ty-product-img cm-preview-wrapper ab-vertical".*?</div>';
                $replaced = 0;
                $contents = preg_replace('#'.$imagePattern.'#ims', str_replace(' maxWidth', '', str_replace('$', '\$', $html)), $contents, 1, $replaced);
                if($replaced) {
                    $contents = preg_replace('#<div class="ty-product-thumbnails[^"]*"[^>]*id="images_preview_'.$products[0]['product_id'].'.*?</div>#is', '', $contents, 1);
                } else {
                


                $additionalThumbnailsPattern =
                    '(<div\b[^>]*?\bclass="[^"]*?\bcm-image-gallery-wrapper\b[^"]*+"[^>]*+>[^<]*+)?'.
                    '<(div|ul)\b[^>]*?\bclass="[^"]*?\bproduct-thumbnails\b[^"]*+"[^>]*+>'.
                    '('.
                    '(?:'.
                        '[^<]++'.
                        '|'.
                        '<(?!/?\2\b|!--)'.
                        '|'.
                        '<!--.*?-->'.
                        '|'.
                        '<\2\b[^>]*+>'.
                            '(?3)'.
                        '</\2\s*+>'.
                    ')*+'.
                    ')'.
                    '</\2\s*+>'.
                    '(?(1)[^<]*+</div\s*+>)';
                $matches = array();
                preg_match('#'.$additionalThumbnailsPattern.'#is', $contents, $matches);

                $imagePattern = '<div class="ty-product-img cm-preview-wrapper" id="product_images_'.$products[0]['product_id'].'[0-9a-z]{1,}">.*?</div>';
                $replaced = 0;
                $contents = preg_replace('#'.$imagePattern.'#ims', str_replace(' maxWidth', '', str_replace('$', '\$', $html)), $contents, 1, $replaced);
                if($replaced) {
                    $contents = preg_replace('#<div class="ty-product-thumbnails[^"]*" id="images_preview_'.$products[0]['product_id'].'.*?</div>#is', '', $contents, 1);
                } else {
                    $imagePattern =
                        '(?:'.
                        //'<img [^>]*?id="det_img_(?!variant_image)[^"]*+"[^>]*+>'.//class=pict, det_img_{$preview_id}_

                        //NOTE: fixed an issue with replacing wrong image (templates/addons/call_requests/views/call_requests/components/lscall_requests_content.tpl)
                        //$preview_id = $products[0]['product_id'].uniqid();
                        '<img [^>]*?id="det_img_'.$products[0]['product_id'].'[0-9][^"]*+"[^>]*+>'.//class=pict, det_img_{$preview_id}_

                        '|'.
                        '<div [^>]*?class="no-image"[^>]*+>.*?</div>'.
                        '|'.
                        '<span [^>]*?class="ty-no-image"[^>]*+>.*?</span>'.
                        ')';
                    $imagePattern =
                        '(?:<a [^>]*?id="det_img_link_[^"]*+"[^>]*+>[^<]*+'.//class=cm-image-previewer, det_img_link_{$preview_id}_
                            $imagePattern.'[^<]*+'.
                            '(?:<span\b[^>]*+>[^<]*+</span>[^<]*+)?'.
                        '</a>|'.
                        $imagePattern.')[^<]*+';

                    $replaced = 0;
                    $contents = preg_replace('#(?:'.$imagePattern.')+#is', str_replace('$', '\$', $html), $contents, 1, $replaced);//NOTE: $limit = 1 to prevent the replacement of product in product tabs(product id == block id)
                    if($replaced && !empty($matches)) {
                        //NOTE: cut selectors
                        $contents = str_replace($matches[0], '', $contents);
                    }
                }
            }
        break;
    }

    //setlocale(LC_ALL, $oldLocale);
    $tool->params->resetProfile();

    return $contents;

}

function fn_magic360_create_thumb($src, $size, $pid) {

    static $imagehelper = null;
    static $prefix = '';

    if($imagehelper === null) {

        $prefix = Registry::get('config.current_location');

        $options = Settings::instance()->getValue('cdn', '');

        //NOTE: in some cases CDN is disabled at frontend (although it is activated in the settings)
        //      so this is an additional check
        $_options = Storage::instance('images')->options;
        $isCdnEnabled = isset($_options['cdn']) && $_options['cdn'];

        if(!empty($options) && $isCdnEnabled) {
            $options = unserialize($options);
            if((bool)$options['is_enabled']) {
                /*
                $cdn = Cdn::instance()->getHost('host');
                if(!empty($cdn)) {
                    $prefix = (defined('HTTPS') ? 'https:' : 'http:').'//'.$cdn;
                }
                */
                if(!empty($options['cname'])) {
                    $prefix = (defined('HTTPS') ? 'https:' : 'http:').'//'.$options['cname'];
                } else if(!empty($options['host'])) {
                    $prefix = (defined('HTTPS') ? 'https:' : 'http:').'//'.$options['host'];
                }
            }
        }

        $tool = fn_magic360_load();
        require_once(dirname(__FILE__).'/classes/magictoolbox.imagehelper.class.php');
        $imagehelper = new MagicToolboxImageHelperClass(Registry::get('config.dir.root'), '/images/magictoolbox_cache', $tool->params, null, Registry::get('config.http_path'));
    }

    $src = str_replace($prefix, '', $src);//NOTE: with /
    $src = preg_replace('#\?.*+$#', '', $src);//NOTE: if it has some GET options, cut it
    $src = htmlspecialchars_decode($src, ENT_QUOTES);

    $thumb = $imagehelper->create($src, $size, $pid);
    //NOTE: spike to get real size of image
    //$GLOBALS['magictoolbox']['file_path'] = $imagehelper->file;
    if(MT_DS != '/') {
        $thumb = str_replace(MT_DS, '/', $thumb);
    }

    return $thumb;

}

function fn_magic360_js_functions() {

    global $magic360DisableNotification;

    if(!isset($magic360DisableNotification) || !$magic360DisableNotification)
    if(Registry::get("addons.magic360.status") === 'D') {
        $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic 360 module should be enabled for proper operation of the settings page." .
                   "<br/>Please enable it before save settings.</span>";
        fn_set_notification('E', __('warning'), $message, true, 'magic360_module_disabled_notification');
    }

    return '
        <script type="text/javascript">
            //<![CDATA[
            function fn_magic360_prepare_custom_options(block, skip) {
                skip = (skip || \'\').split(\'|\');
                skip.push(\'enable-effect\');
                var enabledOptionsID = "#addon_option_magic360_" + block + "-enabled-options";
                var enabledOptions = $(enabledOptionsID).val();
                var sectionID = "#content_magic360_magic360_" + block;
                $(sectionID + " div.controls").
                each(function(){
                        $(this).
                         find("select, input[type=\'text\']").
                         each(function(){
                                var optionId = this.id.replace("addon_option_magic360_" + block + "-","");
                                if(jQuery.inArray(optionId, skip) !== -1) {
                                    return;
                                }
                                if(enabledOptions.indexOf("|" + optionId + "|") == -1) {
                                    $(this).attr("disabled", true).after("&nbsp;&nbsp;<a href=\"#\" >edit</a>");
                                } else {
                                    $(this).after("&nbsp;&nbsp;<a href=\"#\" >use default option</a>");
                                }
                                $(this).next().
                                    bind("click", {optionId: optionId, enabledOptionsID: enabledOptionsID},
                                                    function(event) {
                                                        var enabledOptions = $(event.data.enabledOptionsID).val();
                                                        if($(this).html() == "edit") {
                                                            $(this).html("use default option").prev().removeAttr("disabled");
                                                            enabledOptions = enabledOptions.concat(event.data.optionId + "|");
                                                        } else {
                                                            $(this).html("edit").prev().attr("disabled", true).val($("#addon_option_magic360_general-" + event.data.optionId).val().replace("general-", block + "-"));
                                                            var pattern = new RegExp("\\\\|" + event.data.optionId + "\\\\|", "g");
                                                            enabledOptions = enabledOptions.replace(pattern, "|");
                                                        }
                                                        $(event.data.enabledOptionsID).val(enabledOptions);
                                                        return false;
                                                }
                                        );
                              }).
                         end().
                         find("input[type=\'radio\']:checked").
                         each(function(){
                                var optionId = this.parentNode.parentNode.id.replace("addon_option_magic360_" + block + "-","");
                                if(jQuery.inArray(optionId, skip) !== -1) {
                                    return;
                                }
                                if(enabledOptions.indexOf("|" + optionId + "|") == -1) {
                                    $(this.parentNode.parentNode).find("input").attr("disabled", true).end().
                                     find("label:last-child").after("&nbsp;&nbsp;<a href=\"#\" >edit</a>");
                                } else {
                                    $(this.parentNode.parentNode).find("label:last-child").after("&nbsp;&nbsp;<a href=\"#\" >use default option</a>");
                                }
                                $(this.parentNode.parentNode).find("a:last-child").
                                    bind("click", {optionId: optionId, enabledOptionsID: enabledOptionsID},
                                                    function(event) {
                                                        var enabledOptions = $(event.data.enabledOptionsID).val();
                                                        if($(this).html() == "edit") {
                                                            $(this).html("use default option");
                                                            $(this.parentNode.parentNode).find("input").removeAttr("disabled");
                                                            enabledOptions = enabledOptions.concat(event.data.optionId + "|");
                                                        } else {
                                                            $(this).html("edit");
                                                            $(this.parentNode.parentNode).find("input").attr("disabled", true).val([$("#addon_option_magic360_general-" + optionId + " input:checked").val().replace("general", block)]);
                                                            var pattern = new RegExp("\\\\|" + event.data.optionId + "\\\\|", "g");
                                                            enabledOptions = enabledOptions.replace(pattern, "|");
                                                        }
                                                        $(event.data.enabledOptionsID).val(enabledOptions);
                                                        return false;
                                                }
                                        );
                              });
                      });
            }
            //]]>
        </script>
';

}

function fn_magic360_prepare_custom_options($block) {

    static $addonOptions;
    static $enabledOptions;
    $headersBind = '';
    $generalParamsChangeBind = '';
    $includeOptionsJs = '';
    $initOptionsValidation = '';
    $magicscrollIcon = '';
    $blocks = array('product',
                   );

    if(!isset($addonOptions)) {
        $section = Settings::instance()->getSectionByName($_REQUEST['addon'], Settings::ADDON_SECTION);
        $addonOptions = db_get_hash_single_array('SELECT name, value FROM ?:settings_objects WHERE section_id = \'?p\' AND type != \'H\'', array('name', 'value'), $section['section_id']);
        $enabledOptions = db_get_hash_single_array('SELECT block, value FROM ?:addon_magic360_options WHERE name = \'enabled_options\'', array('block', 'value'));
    }

    switch($block) {
        case 'general':
            if(isset($addonOptions['cache-path-to-cache'])) {
                $pathToCache = $addonOptions['cache-path-to-cache'];
            } else {
                $pathToCache = '/images/magictoolbox_cache';
            }
            $tool = fn_magic360_load();
            require_once(dirname(__FILE__).'/classes/magictoolbox.imagehelper.class.php');
            $imagehelper = new MagicToolboxImageHelperClass(Registry::get('config.dir.root'), $pathToCache, $tool->params);
            $usedSubCache = $imagehelper->getOptionsHash();
            $cacheInfo = fn_magic360_getCacheInfo(Registry::get('config.dir.root').$pathToCache, $usedSubCache);
            $cacheInfo['formatedTotalSize'] = fn_magic360_format_size($cacheInfo['totalSize']);
            $cacheInfo['formatedUnusedSize'] = fn_magic360_format_size($cacheInfo['unusedSize']);
            $indexScript = Registry::get('config.admin_index');
            $return =<<<RETURN
<div class="control-group setting-wide magic360">
    <label for="addon_option_magic360_cache-path-to-cache" class="control-label" >Path to cache folder&nbsp;<a class="cm-tooltip" title="Relative for site base path."><i class="icon-question-sign"></i></a>:</label>
    <div class="controls">
        <input id="addon_option_magic360_cache-path-to-cache" type="text" name="addon_data[options][cache-path-to-cache]" value="{$pathToCache}" style="width:352px;" disabled="disabled" />
        <div class="right update-for-all"></div>
    </div>
</div>
<div class="control-group setting-wide magic360">
    <label for="addon_option_magic360_cache-total-items" class="control-label" >Total items:</label>
    <div class="controls">
        <input id="addon_option_magic360_cache-total-items" type="text" name="addon_data[options][cache-total-items]" value="{$cacheInfo['totalCount']} ({$cacheInfo['formatedTotalSize']})" size="30" disabled="disabled" />
        <div class="right update-for-all"></div>
    </div>
</div>
<div class="control-group setting-wide magic360">
    <label for="addon_option_magic360_cache-unused-items" class="control-label" >Unused items:</label>
    <div class="controls">
        <input id="addon_option_magic360_cache-unused-items" type="text" name="addon_data[options][cache-unused-items]" value="{$cacheInfo['unusedCount']} ({$cacheInfo['formatedUnusedSize']})" size="30" disabled="disabled" />
        <div class="right update-for-all"></div>
    </div>
</div>
<div class="control-group setting-wide magic360">
    <label for="addon_option_magic360_cache-what-clear" class="control-label " >Empty cache:</label>
    <div class="controls">
        <select id="addon_option_magic360_cache-what-clear" onchange="$('#magic360_clear_cache_field').attr('href', '{$indexScript}?dispatch=magic360_cache.'+this.value).attr('rev', this.value);">
            <option value="clear_unused_items" selected="selected">Delete unused items</option>
            <option value="clear_all_items">Delete all items</option>
        </select>
        &nbsp;<a data-ca-event="ce.magic360_clear_cache_field" name="magic360_clear_cache_field" id="magic360_clear_cache_field" href="{$indexScript}?dispatch=magic360_cache.clear_unused_items" class="cm-ajax cm-confirm" rev="clear_unused_items" >Clear</a>
        <div class="right update-for-all"></div>
    </div>
</div>
RETURN;
            return $return;
            break;
        case 'product':
            //only after last block
            $blocks  = '"'.implode('", "', $blocks).'"';

            //NOTE: does not work in hidden tabs
            //$headersBind = '$("#tabs_content_magic360 h4.subheader").slice(1).click();';

            $headersBind = '
$("#tabs_content_magic360 h4.subheader").slice(1).each(function() {
    var subheader = $(this);
    var target = subheader.attr(\'data-target\');
    subheader.addClass(\'collapsed\');
    $(target).removeClass(\'in\');
});
';

            $generalParamsChangeBind = '
$("#content_magic360_magic360_general").find("input[type=\'text\']").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.id.replace("addon_option_magic360_general-","");
var optioVal = $(this).val();
for(block in block_array) {
    $("#content_magic360_magic360_" + block_array[block]).
    find("#addon_option_magic360_" + block_array[block] + "-" + optionId + ":disabled").val(optioVal);
}
}).
end().find("select").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.id.replace("addon_option_magic360_general-","");
var optioVal = $(this).val().replace("general-" + optionId + "-", "");
for(block in block_array) {
    $("#content_magic360_magic360_" + block_array[block]).
    find("#addon_option_magic360_" + block_array[block] + "-" + optionId + ":disabled").val(block_array[block] + "-" + optionId + "-" + optioVal);
}
}).
end().find("input[type=\'radio\']").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.parentNode.parentNode.id.replace("addon_option_magic360_general-","");
var optioVal = $(this).val().replace("general-" + optionId + "-", "");
for(block in block_array) {
    $("#content_magic360_magic360_" + block_array[block]).
    find("#addon_option_magic360_" + block_array[block] + "-" + optionId + " input:disabled").val([block_array[block] + "-" + optionId + "-" + optioVal]);
}
});';
    }

    $tool = fn_magic360_load();
    $skip = array();
    $skip[] = 'quick-view-thumb-max-width';
    $skip[] = 'quick-view-thumb-max-height';


    $skip = implode('|', $skip);
    return $includeOptionsJs.'
        <input type="hidden" name="addon_data[options]['.$block.'-enabled-options]" id="addon_option_magic360_'.$block.'-enabled-options" value="'.$enabledOptions[$block].'" />
        <script type="text/javascript">
            //<![CDATA[
                function fn_magic360_prepare_'.$block.'_block_options() {
                    fn_magic360_prepare_custom_options("'.$block.'", \''.$skip.'\');
                    '.$headersBind.$generalParamsChangeBind.$initOptionsValidation.$magicscrollIcon.'
                }
            //]]>
        </script>
    ';
}

function fn_magic360_getCacheInfo($path, $usedSubCache = null) {

    $totalSize = 0;
    $totalCount = 0;
    $usedSize = 0;
    $usedCount = 0;
    if (is_dir($path))
    if ($handle = opendir($path)) {
        while (false !== ($file = readdir($handle))) {
            $next = $path.MT_DS.$file;
            if ($file != '.' && $file != '..' && !is_link($next)) {
                if (is_dir($next)) {
                    $result = fn_magic360_getCacheInfo($next);
                    if($file == $usedSubCache) {
                        $usedSize += $result['totalSize'];
                        $usedCount += $result['totalCount'];
                    }
                    $totalSize += $result['totalSize'];
                    $totalCount += $result['totalCount'];
                } elseif (is_file($next)) {
                    $totalSize += filesize($next);
                    $totalCount++;
                }
            }
        }
        closedir($handle);
    }
    return array('totalSize' => $totalSize, 'totalCount' => $totalCount, 'unusedSize' => $totalSize-$usedSize, 'unusedCount' => $totalCount-$usedCount);
}

function fn_magic360_format_size($size) {
    $units = array(' bytes', ' KB', ' MB', ' GB', ' TB');
    for ($i = 0; $size >= 1024 && $i < 4; $i++) $size /= 1024;
    return round($size, 2).$units[$i];
}

function fn_magic360_install() {

    global $magic360DisableNotification;
    $magic360DisableNotification = true;

    $moduleDirectory = str_replace(array("//", "\\"), array("/", "/"), Registry::get('config.dir.addons').'/magic360');

    $cancel = false;

    if(!defined('PRODUCT_VERSION') || version_compare(PRODUCT_VERSION, '4.0.0', '<')) {
        $cancel = true;
        if(!fn_notification_exists('E', 'magic360_module_version_notification')) {
            $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">This Magic 360 module is intended only for CS Cart Version 4 and above.".
                       "<br/>Your version of CS Cart is ".PRODUCT_VERSION."</span>";
            fn_set_notification('E', __('error'), $message, true, 'magic360_module_version_notification');
        }
    }

    if($cancel) {
        $args = func_get_args();
        if(!empty($args)) fn_redirect("addons.manage");
        return;
    }

    //fix url's in css files
    $cancel = fn_magic360_fix_css();

    @copy($moduleDirectory.'/360icon.png', Registry::get('config.dir.root').'/images/360icon.png');

    if($cancel) {
        $args = func_get_args();
        if(!empty($args)) fn_redirect("addons.manage");
        return;
    }


    fn_magic360_send_stat('install');

}

function fn_magic360_fix_css() {

    $cancel = false;

    $path = dirname(__FILE__).'/resources';

    $resourcesPath = Registry::get('config.current_path').substr(Registry::get('config.dir.addons'), strlen(Registry::get('config.dir.root'))).'magic360/resources';
    $resourcesPath = str_replace(array("//", "\\"), array("/", "/"), $resourcesPath);

    $list = glob($path.'/*');
    $files = array();
    if(is_array($list)) {
        for($i = 0; $i < count($list); $i++) {
            if(is_dir($list[$i])) {
                if(!in_array(basename($list[$i]), array('.svn', '.git'))) {
                    $add = glob($list[$i].'/*');
                    if(is_array($add)) {
                        $list = array_merge($list, $add);
                    }
                }
            } else if(preg_match('#\.css$#i', $list[$i])) {
                $files[] = $list[$i];
            }
        }
    }

    foreach($files as $file) {
        $cssPath = dirname($file);
        $cssRelPath = str_replace($path, '', $cssPath);
        $toolPath = $resourcesPath.$cssRelPath;
        $pattern = '#url\(\s*(\'|")?(?!data:|mhtml:|http(?:s)?:|/)([^\)\s\'"]+?)(?(1)\1)\s*\)#is';
        $replace = 'url($1'.$toolPath.'/$2$1)';
        $fileContents = file_get_contents($file);
        $fixedFileContents = preg_replace($pattern, $replace, $fileContents);
        if($fixedFileContents != $fileContents) {
            if(is_writeable($file)) {
                file_put_contents($file, $fixedFileContents);
            } else {
                //NOTE: install module anyway
                /*
                $cancel = true;
                if(!fn_notification_exists('E', 'magic360_file_'.md5($file).'_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic 360 needs write access to the file <b>'".$file."'</b> for proper installation." .
                                "<br/>Please fix this and reinstall Magic 360.</span>";
                    fn_set_notification('E', __('error'), $message, true, 'magic360_file_'.md5($file).'_notification');
                }
                */
            }
        }
    }

    return $cancel;

}

function fn_magic360_after_install() {

    global $magic360DisableNotification;
    $magic360DisableNotification = false;

    //NOTE: we need to change position of options in DB, that the content displayed in the right order
    $section = Settings::instance()->getSectionByName($_REQUEST['addon'], Settings::ADDON_SECTION);
    //$section = Settings::instance()->getSectionByName('magic360', Settings::ADDON_SECTION);
    $query = 'UPDATE ?:settings_objects SET ?:settings_objects.position = ?:settings_objects.object_id WHERE ?:settings_objects.section_id = ?s';
    db_query($query , $section['section_id']);


}

function fn_magic360_uninstall() {
    fn_magic360_send_stat('uninstall');
}

function fn_magic360_send_stat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v1.2.18' || 'working' == 'v4.6.13') {
        return;
    }

    $hostname = 'www.magictoolbox.com';
    $url = $_SERVER['HTTP_HOST'].preg_replace('/\/[^\/]*?\.php.*$/i', '', $_SERVER['REQUEST_URI']);
    $url = urlencode(urldecode($url));
    $platformVersion = defined('PRODUCT_VERSION') ? PRODUCT_VERSION : '';
    $path = "api/stat/?action={$action}&tool_name=magic360&license=trial&tool_version=v4.6.13&module_version=v1.2.18&platform_name=cscart4&platform_version={$platformVersion}&url={$url}";
    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers  = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }

}
