<?php

use Tygh\Registry;

if(!defined('BOOTSTRAP')) die('Access denied');

if($_SERVER['REQUEST_METHOD'] == 'POST') {

    if($mode == 'update') {

        if(!empty($_REQUEST['product_id']) && isset($_FILES, $_FILES['magic360images'])) {

            $product_id = &$_REQUEST['product_id'];
            $baseImagePath = Registry::get('config.dir.root').'/images/magic360/';
            $gallery = '';
            $magic360Images = array();
            $magic360Columns = 0;

            $rezult = db_get_row('SELECT gallery, columns FROM ?:addon_magic360_images WHERE id = ?i', $product_id);

            if(!empty($rezult)) {
                $magic360Images = empty($rezult['gallery']) ? array() : explode(';', $rezult['gallery']);
                $magic360Columns = $rezult['columns'];
            }

            $magic360ImagesCount = count($magic360Images);

            switch($_REQUEST['magic360_action_type']) {
                case 'upload':
                    if(fn_mkdir($baseImagePath)) {
                        foreach($_FILES['magic360images']['tmp_name'] as $key => $tempName) {
                            if(!empty($tempName) && file_exists($tempName)) {
                                $name = preg_replace('/[^a-zA-Z0-9()_\.-]/is', '', $_FILES['magic360images']['name'][$key]);
                                $ext = substr($name, strrpos($name, '.'));
                                $name = substr($name, 0, -strlen($ext));
                                $index = 0;
                                $suffix = '';
                                while(file_exists($baseImagePath.$name.$suffix.$ext)) {
                                    $suffix = "({$index})";
                                    $index++;
                                }
                                if(move_uploaded_file($tempName, $baseImagePath.$name.$suffix.$ext)) {
                                    $magic360Images[] = $name.$suffix.$ext;
                                }
                            }
                        }
                        if($magic360Columns == $magic360ImagesCount) {
                            $magic360Columns = count($magic360Images);
                        }
                    }
                break;
                case 'save':
                    if(isset($_REQUEST['magic360data']['columns']) && !empty($_REQUEST['magic360data']['columns']) && (intval($_REQUEST['magic360data']['columns']) < $magic360ImagesCount)) {
                        $magic360Columns = intval($_REQUEST['magic360data']['columns']);
                    } else {
                        $magic360Columns = $magic360ImagesCount;
                    }
                break;
                case 'delete':
                    $index = (int)($_REQUEST['magic360data']['imageIndex']);
                    if(file_exists($baseImagePath.$magic360Images[$index])) {
                        @unlink($baseImagePath.$magic360Images[$index]);
                    }
                    unset($magic360Images[$index]);
                    if($magic360Columns == $magic360ImagesCount) {
                        $magic360Columns--;
                    }
                break;
                case 'deleteAll':
                    foreach($magic360Images as $image) {
                        if(file_exists($baseImagePath.$image)) {
                            @unlink($baseImagePath.$image);
                        }
                    }
                    $magic360Images = array();
                    $magic360Columns = 0;
                break;
            }

            $gallery = implode(';', $magic360Images);
            if(empty($rezult)) {
                $query = "INSERT INTO ?:addon_magic360_images (`id`, `gallery`, `columns`) VALUES ({$product_id}, '{$gallery}', {$magic360Columns})";
            } else {
                $query = "UPDATE ?:addon_magic360_images SET `gallery`='{$gallery}', `columns`={$magic360Columns} WHERE `id`={$product_id}";
            }
            db_query($query);
        }

    }

    return array(CONTROLLER_STATUS_OK);

}

if($mode == 'update') {

    $product_id = empty($_REQUEST['product_id']) ? 0 : intval($_REQUEST['product_id']);

    $magic360Images = array();
    $magic360ImagesCount = 0;
    $magic360Columns = 0;
    $magic360Rows = 0;
    $magic360MultiRows = false;
    $baseImageUrl = Registry::get('config.current_location').'/images/magic360/';

    if($product_id) {
        $rezult = db_get_row('SELECT gallery, columns FROM ?:addon_magic360_images WHERE id = ?i', $product_id);
        if(!empty($rezult)) {
            $magic360Images = empty($rezult['gallery']) ? array() : explode(';', $rezult['gallery']);
            $magic360ImagesCount = count($magic360Images);
            $magic360Columns = $rezult['columns'];
            if($rezult['columns']) {
                if($rezult['columns'] < $magic360ImagesCount) {
                    $magic360Rows = floor($magic360ImagesCount/intval($rezult['columns']));
                    $magic360MultiRows = true;
                } else {
                    $magic360Rows = 1;
                }
            }
        }
    }

    Registry::set('navigation.tabs.magic360images', array (
        'title' => __('magic360images'),
        'js' => true
    ));

    $viewObj = Registry::get('view');
    $viewObj->assign('magic360Images', $magic360Images);
    $viewObj->assign('magic360ImagesCount', $magic360ImagesCount);
    $viewObj->assign('magic360Columns', $magic360Columns);
    $viewObj->assign('magic360Rows', $magic360Rows);
    $viewObj->assign('magic360MultiRows', $magic360MultiRows);
    $viewObj->assign('baseImageUrl', $baseImageUrl);

}

return array(CONTROLLER_STATUS_OK);

?>
