var mjsAddEventMethod = 'je1';
if(typeof(magicJS.Doc.je1) == 'undefined') mjsAddEventMethod = 'jAddEvent';

function fn_magictoolbox_selector_init(productId) {
    //var selectors = $('#MagicToolboxSelectors'+productId+' a.cm-thumbnails-mini');
    var selectors = $('#MagicToolboxSelectors'+productId+' a');
    var switchFunction = function(e) {
        var targetNode = e.target || e.srcElement;
        if(targetNode.tagName.toLowerCase() == 'img') {
            targetNode = targetNode.parentNode;
        }
        if(typeof(magicToolboxOriginalLayout) != 'undefined' && magicToolboxOriginalLayout) {
            var targetObj = $(targetNode);
            if(!targetObj.hasClass('cm-cur-item')) {
                $('div.MagicToolboxSelectorsContainer .cm-cur-item').removeClass('cm-cur-item');
                targetObj.addClass('cm-cur-item');
            }
        }
        var magic360Container = document.getElementById('magic360Container'+productId);
        if(magic360Container) {
            if(magicToolboxTool == 'MagicZoom' || magicToolboxTool == 'MagicZoomPlus') {
                //NOTE: in order to magiczoom(plus) was not switching selector
                e.stopQueue();
            }
            var isMagic360Visible = magic360Container.style.display != 'none';
            var magicToolboxToolMainId = magicToolboxTool+'Imageproduct'+magicToolboxProductId; 
            var isThisMagic360Selector = targetNode.className.match(new RegExp('(?:\\s|^)m360-selector(?:\\s|$)'));
            if(isThisMagic360Selector && !isMagic360Visible) {
                var mainImageContainer = document.getElementById('mainImageContainer'+productId);
                mainImageContainer.style.display = 'none';
                magic360Container.style.display = 'block';
            } else if(isMagic360Visible && !isThisMagic360Selector) {
                var mainImageContainer = document.getElementById('mainImageContainer'+productId);
                //NOTE: only on page load (first time)
                if(mainImageContainer.style.position == 'absolute') {
                    mainImageContainer.style.left = 0;
                    mainImageContainer.style.position = 'static';
                }
                magic360Container.style.display = 'none';
                mainImageContainer.style.display = 'block';
                if(magicToolboxTool == 'MagicZoom' || magicToolboxTool == 'MagicZoomPlus') {
                    //NOTE: hide image to skip magiczoom(plus) switching effect
                    if(!$mjs(targetNode).jHasClass('mz-thumb-selected')) {
                        document.querySelector('#'+magicToolboxToolMainId+' .mz-figure > img').style.visibility = 'hidden';
                    }
                }
            }
            if(magicToolboxTool == 'MagicZoom' || magicToolboxTool == 'MagicZoomPlus') {
                //NOTE: switch image
                MagicZoom.switchTo(magicToolboxToolMainId, targetNode);
                //NOTE: to highlight magic360 selector when switching thumbnails
                var selectors = $('#MagicToolboxSelectors'+productId+' a');
                for(var k = 0; k < selectors.length; k++) { 
                    $mjs(selectors[k]).jRemoveClass('active-selector');
                }
                $mjs(targetNode).jAddClass('active-selector');
            }
        }
        return false;
    };
    if(magicToolboxTool == 'MagicZoom' || magicToolboxTool == 'MagicZoomPlus') {
        var switchEvent = (magicToolboxSelectorsEvent == 'click' ? 'btnclick' : magicToolboxSelectorsEvent);
    }
    for(var j = 0; j < selectors.length; j++) {
        if(magicToolboxTool == 'MagicZoom' || magicToolboxTool == 'MagicZoomPlus') {
            $mjs(selectors[j])[mjsAddEventMethod](switchEvent+' tap', switchFunction, 1);
        } else if(magicToolboxTool == 'MagicThumb') {
            $mjs(selectors[j])[mjsAddEventMethod](magicToolboxSelectorsEvent, switchFunction);
            $mjs(selectors[j])[mjsAddEventMethod]('touchstart', switchFunction);
        }
    }
}

function fn_magictoolbox_tool_update(action, block, productId) {

    var tools = ['MagicZoom', 'MagicZoomPlus', 'MagicThumb', 'Magic360', 'MagicSlideshow', 'MagicScroll'];
    var mainEl = null;
    var selectorsEl = null;
    var tool = '';

    if(block == 'product') {
        for(toolId in tools) {
            mainEl = document.getElementById(tools[toolId]+'Image'+block+productId);
            if(mainEl) {
                tool = tools[toolId];
                break;
            }
        }
    } else if(block == 'category') {
        var container = document.getElementById('pagination_contents');
        for(toolId in tools) {
            if($('.'+tools[toolId], container).length) {
                tool = tools[toolId];
                break;
            }
        }
    }

    if(!tool) return;

    if(productId) selectorsEl = document.getElementById('MagicToolboxSelectors'+productId);

    if(action == 'stop') {
        if(selectorsEl) {
            if(typeof(MagicScroll) !== 'undefined') MagicScroll.stop(selectorsEl);
            if(typeof(Magic360) !== 'undefined') {
                var m360El = document.getElementById('Magic360Image'+block+productId);
                if(m360El) Magic360.stop(m360El);
            }
        }
        switch(tool) {
            case 'MagicZoom':
            case 'MagicZoomPlus':
                if(mainEl) {
                    MagicZoom.stop(mainEl);
                } else {
                    MagicZoom.stop();
                }
                break;
            case 'MagicThumb':
                MagicThumb.thumbs && MagicThumb.stop();
                break;
            case 'MagicSlideshow':
                MagicSlideshow.stop(tools[toolId]+'Image'+block+productId);
                break;
            case 'MagicScroll':
                MagicScroll.stop(tools[toolId]+'Image'+block+productId);
                break;
            case 'Magic360':
                Magic360.stop(mainEl);
                break;
        }
    } else if(action == 'start') {
        switch(tool) {
            case 'MagicZoom':
            case 'MagicZoomPlus':
                if(mainEl) {
                    MagicZoom.start(mainEl);
                } else {
                    MagicZoom.start();
                }
                break;
            case 'MagicThumb':
                MagicThumb.start();
                break;
            case 'MagicSlideshow':
                //MagicSlideshow.start(tools[toolId]+'Image'+block+productId);
                MagicSlideshow.refresh(tools[toolId]+'Image'+block+productId);
                break;
            case 'MagicScroll':
                MagicScroll.start(tools[toolId]+'Image'+block+productId);
                break;
            case 'Magic360':
                Magic360.start(mainEl);
                break;
        }
        if(selectorsEl) {
            fn_magictoolbox_selector_init(productId);
            //NOTE: start() function runs tool even if the element has no MagicScroll class
            if(typeof(MagicScroll) !== 'undefined' && selectorsEl.className.match(new RegExp("(?:\\s|^)MagicScroll(?:\\s|$)"))) {
                MagicScroll.start(selectorsEl);
            }
            if(typeof(Magic360) !== 'undefined') {
                var m360El = document.getElementById('Magic360Image'+block+productId);
                if(m360El) Magic360.start(m360El);
            }
        }
    }

}
