<?php

if ( !defined('AREA') ) { die('Access denied'); }

define('MT_DS', DIRECTORY_SEPARATOR);

function fn_magiczoom($output, &$view) {

    $block = '';
    $block_id = '';
    static $ajax = null;
    static $main_product_processed = false;
    static $products_search_processed = false;

    if($ajax === null) {
        $ajax = isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest');
                //&& in_array($_REQUEST['dispatch'], array('products.options', 'categories.view'))
    }

    $search = !$products_search_processed  && isset($view->_tpl_vars['layouts']) && (
              ($view->_tpl_vars['mode'] == 'search' && $view->_tpl_vars['controller'] == 'products') ||
              //NOTE: to support tags page
              ($view->_tpl_vars['controller'] == 'tags' && $view->_tpl_vars['mode'] == 'view')  );

    if($ajax) {
        //check block
        if(isset($view->_tpl_vars['obj_prefix']) && $view->_tpl_vars['obj_prefix'] != 'ajax') {
            if(substr($view->_tpl_vars['obj_prefix'], -3) == '000') {
                $block_id = substr($view->_tpl_vars['obj_prefix'], 0, -3);
                $block_data = Bm_Block::instance()->get_by_id($block_id);
                if(isset($block_data['content']['items']['filling'])) {
                    $block = $block_data['content']['items']['filling'];
                }
            }
        } else if(defined('MAGICZOOM_GET_PRODUCT_DETAILS_LAYOUT_POST_HOOK') ||
                  in_array($view->_tpl_vars['mode'], array('quick_view', 'options')) && $view->_tpl_vars['controller'] == 'products') {
            $block = 'product';
        }
    } else {
        if(!$main_product_processed && defined('MAGICZOOM_GET_PRODUCT_DETAILS_LAYOUT_POST_HOOK')) {
            if(isset($view->_tpl_vars['block']['type']) && $view->_tpl_vars['block']['type'] == 'main') {
                //$block_id = $view->_tpl_vars['block']['block_id'];
                $block = 'product';
                $main_product_processed = true;
            }
        } else {
            if(isset($view->_smarty_vars['capture']['magiczoom_capture']) || $search) {
            } else
            //process template if inclusion depth = 0
            //if($view->_inclusion_depth) return $output;
            //NOTICE: in some cases, this value is set to -1 for some reason, maybe it's a bug
            if($view->_inclusion_depth && $view->_inclusion_depth != -1) return $output;
        }
    }

    if(isset($view->_smarty_vars['capture']['magiczoom_capture'])) {
        $block = $view->_smarty_vars['capture']['magiczoom_capture'];
        unset($view->_smarty_vars['capture']['magiczoom_capture']);
    } else if($search) {
        $block = 'search';
        $products_search_processed = true;
    } else if(isset($view->_tpl_vars['block'],
                   $view->_tpl_vars['block']['content'],
                   $view->_tpl_vars['block']['content']['items'],
                   $view->_tpl_vars['block']['content']['items']['filling'])
             ) {
        $block = $view->_tpl_vars['block']['content']['items']['filling'];
        if($view->_tpl_vars['block']['type'] != 'products') {
            return $output;
        }
        $block_id = $view->_tpl_vars['block']['block_id'];
    }
    if(empty($block)) return $output;

    $blocks = array('product',
                    'category',
                    'search',
                    'newest', 'recent_products', 'popularity', 'bestsellers', 'rating', 'manually',
                    'head'//footer
                   );

    if($block == 'most_popular') {
        //NOTE: filling changed since v3.0.1 RC 5
        $block = 'popularity';
    } else if(isset($_REQUEST['sef_rewrite']) && $block == 'scripts') {
        //NOTE: for output headers on '404' (etc.) pages
        $simpleHeaders = true;
        $block = 'head';
    }

    if(!in_array($block, $blocks)) return $output;

    $tool = fn_magiczoom_load();

    if($block == 'head') {
        //NOTE: we need to apply headers always because we don't know whether the effect is applied to the block in the cache.
        //if($tool->params->paramExists('headers', $tool->params->generalProfile) && $tool->params->getValue('headers', $tool->params->generalProfile) == 'Yes') {
        if(isset($simpleHeaders)) {
            return fn_magiczoom_headers($output, true);
        }
        foreach($tool->params->getProfiles() as $block) {
            if(!$tool->params->checkValue('enable-effect', 'No', $block)) {
                return fn_magiczoom_headers($output);
            }
        }
        //}
        return $output;
    }

    if($tool->params->checkValue('enable-effect', 'No', $block)) return $output;

    //$tpl_vars = $view->get_template_vars();
    $tool->params->setValue('index-script', $view->get_template_vars('index_script'));
    $tool->params->setValue('block-id', $block_id);
    $tool->params->setValue('mode', $view->get_template_vars('mode'));

    switch($block) {
        case 'product':
        case 'category':
        case 'search':
            $products = ($block != 'product') ? $view->get_template_vars('products') : array($view->get_template_vars('product'));
            $output = fn_magiczoom_parse_standard($output, $products, $block);
        break;
        case 'newest':
        case 'recent_products':
        case 'popularity':
        case 'bestsellers':
        case 'rating':
        case 'manually':
            //NOTE: to prevent the re-processing block(e.g. banner block)
            if(isset($GLOBALS['magictoolbox']['processed_blocks'][$block_id])) {
                break;
            } else {
                $GLOBALS['magictoolbox']['processed_blocks'][$block_id] = $block;
            }
            $products = $ajax ? array($view->get_template_vars('product')) : $view->get_template_vars('items');
            if($products) {
                $output = fn_magiczoom_parse_standard($output, $products, $block);
            }
        break;
        default:
    }
    return $output;
}

function fn_magiczoom_get_product_details_layout_post($result, $product_id) {
    //NOTE: to identify the main product template
    define('MAGICZOOM_GET_PRODUCT_DETAILS_LAYOUT_POST_HOOK', true);
}

function fn_magiczoom_dispatch_assign_template() {
    //NOTE: for register output filter on '404' (etc.) pages
    if(isset($_REQUEST['sef_rewrite'])) {
        $view = & Registry::get('view');
        $view->register_outputfilter('fn_magiczoom');
    }
}

function fn_magiczoom_load($block = false) {
    if(!isset($GLOBALS['magictoolbox']['magiczoom'])) {
        require_once(dirname(__FILE__).'/core/magiczoom.module.core.class.php');
        $GLOBALS['magictoolbox']['magiczoom'] = new MagicZoomModuleCoreClass();
        $tool = &$GLOBALS['magictoolbox']['magiczoom'];

        $params = Registry::get('addons.magiczoom');

        $enabledOptions = db_get_hash_single_array('SELECT block, value FROM ?:addon_magiczoom_options WHERE name = \'enabled_options\'', array('block', 'value'));

        foreach($params as $p_name => $p_value) {
            $param_value = '';
            if(strpos($p_value, $p_name.'-') === 0) {
                $param_value = substr($p_value, strlen($p_name)+1);
            } else {
                $param_value = $p_value;
            }
            if(strpos($p_name, 'general-') === 0) {
                $tool->params->setValue(substr($p_name, 8), $param_value);
            } else {
                $pattern = '/(product|category|search|newest|recent_products|popularity|bestsellers|rating|manually|banners)-(.*)/is';
                $matches = array();
                if(preg_match($pattern, $p_name, $matches)) {
                    if(strpos($enabledOptions[$matches[1]], '|'.$matches[2].'|') !== false
                       || $tool->params->checkGroup($matches[2], array('General', 'Scroll', 'Scroll Arrows', 'Scroll Slider', 'Scroll effect', 'Multiple images'))
                       //|| $matches[2] == 'disable-zoom'
                      ) {
                        $tool->params->setValue($matches[2], $param_value, $matches[1]);
                    }
                }
            }
        }
    } else {
        $tool = &$GLOBALS['magictoolbox']['magiczoom'];
    }
    return $tool;
}

function fn_magiczoom_magicscroll_load() {
    if(!isset($GLOBALS['magictoolbox']['magiczoom_magicscroll'])) {
        require_once(dirname(__FILE__).'/core/magicscroll.module.core.class.php');
        $GLOBALS['magictoolbox']['magiczoom_magicscroll'] = new MagicScrollModuleCoreClass(false);
        $tool = fn_magiczoom_load();
        //NOTE: load params in a separate profile, in order not to overwrite the options of MagicScroll module
        $GLOBALS['magictoolbox']['magiczoom_magicscroll']->params->appendParams($tool->params->getParams('product'), 'product-magicscroll-options');
        $GLOBALS['magictoolbox']['magiczoom_magicscroll']->params->setValue('orientation', ($tool->params->checkValue('template', array('left', 'right'), 'product') ? 'vertical' : 'horizontal'), 'product-magicscroll-options');
        //NOTE: if Magic Scroll module installed we need to load settings before displaying custom options
        if(function_exists('fn_magicscroll_load')) {
            fn_magicscroll_load();
        }
    }
    return $GLOBALS['magictoolbox']['magiczoom_magicscroll'];
}

function fn_magiczoom_headers($contents, $simplifiedMode = false) {
    $tool = fn_magiczoom_load();
    $tool->params->resetProfile();
    $http_path = Registry::get('config.http_path');
    $headers = '';
    $headers .= $tool->getHeadersTemplate($http_path.'/addons/magiczoom/core');
    if($tool->params->checkValue('magicscroll', 'Yes', 'product')) {
        $scroll = fn_magiczoom_magicscroll_load();
        $scroll->params->resetProfile();
        $headers .= $scroll->getHeadersTemplate($http_path.'/addons/magiczoom/core', $http_path.'/addons/magiczoom/core', false);
    }
    if(!defined('MAGICTOOLBOX_FUNC_JS_INCLUDED')) {
        $headers .= '<script type="text/javascript" src="'.$http_path.'/addons/magiczoom/func.js"></script>'."\r\n";
        define('MAGICTOOLBOX_FUNC_JS_INCLUDED', true);
    }
    if(!$tool->params->checkValue('enable-effect', 'No', 'product')) {

        $mouseEvent = $tool->params->getValue('selectorTrigger', 'product');
        if($mouseEvent == 'hover') $mouseEvent = 'mouseover';
        $headers .= '
<script type="text/javascript">
    var magicToolboxSelectorsEvent = \''.$mouseEvent.'\';
    var magicToolboxSelectorsDelay = 60;
</script>
';

    }

    if(!empty($_REQUEST['product_id'])) {
        $headers .= "
<script type=\"text/javascript\">
    $(document).ready(function() {
        if(typeof(MagicScroll) !== 'undefined') {
            var selectorsDiv = document.getElementById('MagicToolboxSelectors{$_REQUEST['product_id']}');
            if(selectorsDiv && selectorsDiv.className.match(new RegExp('(?:\\\\\\s|^)MagicScroll(?:\\\\\\s|$)'))) {
                MagicScrollOptions['onReady'] = function(id) {
                    if (id == 'MagicToolboxSelectors{$_REQUEST['product_id']}') {
                        fn_magictoolbox_selector_init('{$_REQUEST['product_id']}');
                    }
                };
            } else {
                fn_magictoolbox_selector_init('{$_REQUEST['product_id']}');
            }
        } else {
            fn_magictoolbox_selector_init('{$_REQUEST['product_id']}');
        }
    });
</script>\r\n";
    }


    $containerMaxWidth = intval($tool->params->getValue('thumb-max-width', 'product'));
    if($containerMaxWidth) {
        $containerMaxWidth = $containerMaxWidth.'px';
    } else {
        $containerMaxWidth = 'auto';
    }
    $headers .= "
<style type=\"text/css\">
.MagicToolboxContainer.maxWidth {
    max-width: {$containerMaxWidth};
}
</style>\r\n";

    if($simplifiedMode) {
        return $contents."\r\n".$headers;
    }

    $contents = preg_replace('#</head>#is', $headers.'</head>', $contents, 1);


    if(defined('MAGICTOOLBOX_JS_FILES_SUBSTITUTION')) {
        return $contents;
    }
    define('MAGICTOOLBOX_JS_FILES_SUBSTITUTION', true);
    //absolute path
    $module_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ADDONS.'/magiczoom');

    $jsFiles = array('/ajax', '/core');

    //to prevent page break as a result not property install
    foreach($jsFiles as $key => $fileName) {
        if(!file_exists($module_directory.$fileName.'.js')) {
            unset($jsFiles[$key]);
        }
    }

    if(!empty($jsFiles)) {
        if(Registry::get('config.tweaks.js_compression')) {
            //$dir_cache = substr(DIR_CACHE, strlen(DIR_ROOT));
            $js_path = Registry::get('config.cache_path') . '/js';
            $suffix = '_packed';
            foreach($jsFiles as $fileName) {
                if(!is_file($module_directory.$fileName.$suffix.'.js') && is_writeable($module_directory)) {
                    if(!class_exists('JavaScriptPacker')) include_once(DIR_LIB.'packer/class.JavaScriptPacker.php');
                    $packer = new JavaScriptPacker(fn_get_contents($module_directory.$fileName.'.js'));
                    fn_put_contents($module_directory.$fileName.$suffix.'.js', $packer->pack());
                }
            }
        } else {
            $js_path = Registry::get('config.current_path') . '/js';
            $suffix = '';
        }

        //relative to the site root
        $module_path = Registry::get('config.current_path').substr(DIR_ADDONS, strlen(DIR_ROOT)).'magiczoom';

        foreach($jsFiles as $fileName) {
            $pattern = preg_quote($js_path.$fileName.'.js', '/');
            $contents = preg_replace('/'.$pattern.'/is', $module_path.$fileName.$suffix.'.js', $contents);
        }
    }

    return $contents;
}

function fn_magiczoom_parse_standard($contents, $products, $block) {
    $tool = fn_magiczoom_load($block);
    $tool->params->setProfile($block);

    $useLink = (($block != 'product') && $tool->params->checkValue('link-to-product-page', 'Yes'));

    //$http_path = Registry::get('config.http_path');

    $jcarousel = Registry::get('settings.Appearance.thumbnails_gallery') == 'Y';
    $quickView = $tool->params->checkValue('mode', array('quick_view', 'options'));
    $originalLayout = $tool->params->checkValue('template', 'original');

    //NOTE: this important for JCarousel
    if($jcarousel && $originalLayout) {
        $width  = $tool->params->checkValue('selector-max-width', array('0', '')) ? 'auto' : $tool->params->getValue('selector-max-width');
        $height = $tool->params->checkValue('selector-max-height', array('0', '')) ? 'auto' : $tool->params->getValue('selector-max-height');
    } else {
        $width = '';
        $height = '';
    }

    foreach($products as $product) {

        $isMainPairExists = true;
        if(isset($product['main_pair']['icon']['image_path'])) {
            $main_image_path = $image_path = $product['main_pair']['icon']['image_path'];
            $imageAlt = $product['main_pair']['icon']['alt'];
            if(isset($product['main_pair']['detailed']['image_path'])) {
                $main_image_path = $product['main_pair']['detailed']['image_path'];
                $imageAlt = $product['main_pair']['detailed']['alt'];
            }
        } else if(isset($product['main_pair']['detailed']['image_path'])) {
            $main_image_path = $image_path = $product['main_pair']['detailed']['image_path'];
            $imageAlt = $product['main_pair']['detailed']['alt'];
            if(isset($product['main_pair']['icon']['image_path'])) {
                $image_path = $product['main_pair']['icon']['image_path'];
            }
        } else if(isset($product['image_pairs']) && count($product['image_pairs']) > 0) {
            $isMainPairExists = false;
            $image_path = 'no_image.gif';//Registry::get('config.no_image_path');
            $mainImagePair = reset($product['image_pairs']);
            if(isset($mainImagePair['detailed']['image_path'])) {
                $main_image_path = $mainImagePair['detailed']['image_path'];
                $imageAlt = $mainImagePair['detailed']['alt'];
            } else {
                $main_image_path = $mainImagePair['icon']['image_path'];
                $imageAlt = $mainImagePair['icon']['alt'];
            }
        } else {
            continue;
        }

        //NOTE: used to get detailed image in old CS-Cart
        //fn_get_image($product['main_pair']['detailed_id'], 'detailed');

        //NOTE: Non-ASCII filenames are chunked if no locale is provided
        $localName = pathinfo($image_path);
        $src_pattern = '[^"]*?\\/'.preg_quote($localName['filename'], '/').'\\.(?:jpg|png|gif)';
        $old_locale = setlocale(LC_ALL, NULL);
        setlocale(LC_ALL, 'en_US.UTF8');

        if($useLink) {
            $link = $tool->params->getValue('index-script').'?dispatch=products.view&product_id='.$product['product_id'];
            if(function_exists('fn_seo_url')) {
                $link = fn_seo_url($link, AREA, '&amp;', 'products.view&product_id='.$product['product_id']);
            }
            //$link = $http_path.'/'.$link;
        }


        $mainImageHTML = '';

        $thumb = fn_magiczoom_create_thumb($main_image_path, 'thumb', $tool, $product['product_id']);

        if($quickView) {
            //NOTE: spike to get real size of image for quick-view
            list($thumb_width, $thumb_height, , ) = getimagesize($GLOBALS['magictoolbox']['file_path']);

            //NOTE: fix issue with height of quick-view popup window
            $quickViewAdditions = <<<ADDITIONS
div.quick-view-wrap #MagicZoomImage{$block}{$product['product_id']} {
    width: {$thumb_width}px;
    height: {$thumb_height}px;
}
ADDITIONS;
            if($tool->params->checkValue('magicscroll', 'Yes', 'product') && $tool->params->checkValue('template', array('bottom', 'top'), 'product')) {
                $scrollHeight = $tool->params->getValue('height');
                $itemHeight = $tool->params->getValue('item-height');
                $scrollHeight = $scrollHeight > $itemHeight ? $scrollHeight : $itemHeight;
                if(!$scrollHeight) {
                    $scrollHeight = $tool->params->getValue('selector-max-height');
                    if($scrollHeight) {
                        $scrollHeight = (int)$scrollHeight + 10;//for some reason MagicScrollItem is higher
                    }
                }
                if($scrollHeight) {
                    $quickViewAdditions .= <<<SCROLLADDITIONS
div.quick-view-wrap #MagicToolboxSelectors{$product['product_id']}.MagicScroll {
    display: block !important;
    visibility: hidden !important;
    overflow: hidden;
    height: {$scrollHeight}px;
}
SCROLLADDITIONS;
                }
                //NOTE: for some reason MagicScroll width becomes smaller
                $scrollWidth = $tool->params->getValue('width');
                if(!$scrollWidth) {
                    $scrollWidth = $thumb_width;
                }
                if($scrollWidth) {
                    $quickViewAdditions .= <<<SCROLLWIDTHADDITIONS
div.quick-view-wrap #MagicToolboxSelectors{$product['product_id']}.MagicScroll {
    width: {$thumb_width}px !important;
}
SCROLLWIDTHADDITIONS;
                }
            }
            $quickViewAdditions = '<style type="text/css">'.$quickViewAdditions.'</style>';
        } else {
            $thumb_width = $thumb_height = '';
            $quickViewAdditions = '';
        }

        $title = !empty($imageAlt) ? $imageAlt : $product['product'];

        $useMagic360 = false;
        if($block == 'product' && function_exists('fn_magic360_load')) {
            $magic360tool = fn_magic360_load();
            if($magic360tool->params->checkValue('enable-effect', 'Yes', 'product')) {
                $rezult = db_get_row('SELECT gallery FROM ?:addon_magic360_images WHERE id = ?i', $product['product_id']);
                if(isset($rezult['gallery']) && !empty($rezult['gallery'])) {
                    $magic360Images = explode(';', $rezult['gallery']);
                    if(count($magic360Images)) {
                        $useMagic360 = true;
                        //NOTE: disable transition effect to prevent the disappearance of the image when it is toggled
                        //$tool->params->setValue('transitionEffect', 'No', 'product');
                    }
                }
            }
        }

        $mainImageHTML = $a = $tool->getMainTemplate(array(
            'id' => $block.$product['product_id'],
            'group' => $block.$tool->params->getValue('block-id'),
            'img' => fn_magiczoom_create_thumb($main_image_path, 'original', $tool, $product['product_id']),
            'thumb' => $thumb,
            'title' => $title,
            'link' => $link,
            //NOTE: disabled, because when switching pictures become disproportionate
            //'width' => $thumb_width,
            //'height' => $thumb_height
        )).$quickViewAdditions;

        $additionalImages = array();

        $mainImageSelectorHTML = $tool->getSelectorTemplate(array(
            'id' => $block.$product['product_id'],
            'group' => $block.$tool->params->getValue('block-id'),
            'img' => fn_magiczoom_create_thumb($main_image_path, 'original', $tool, $product['product_id']),
            'medium' => fn_magiczoom_create_thumb($main_image_path, 'thumb', $tool, $product['product_id']),
            'thumb' => fn_magiczoom_create_thumb($main_image_path, 'selector', $tool, $product['product_id']),
            'title' => $title,
            'width' => $width,
            'height' => $height
        ));
        if($originalLayout) {
            $mainImageSelectorHTML = str_replace('<a ', '<a class="cm-thumbnails-mini" ', $mainImageSelectorHTML);
        }

        if(isset($product['image_pairs']) && count($product['image_pairs']) > 0) {

            if($isMainPairExists) {
                $additionalImages[] = $mainImageSelectorHTML;
            }

            foreach($product['image_pairs'] as $imagePair) {

                if(isset($imagePair['detailed']['image_path'])) {
                    $imagePairPath = $imagePair['detailed']['image_path'];
                    $imageAlt = $imagePair['detailed']['alt'];
                } else {
                    $imagePairPath = $imagePair['icon']['image_path'];
                    $imageAlt = $imagePair['icon']['alt'];
                }

                $title = !empty($imageAlt) ? $imageAlt : $product['product'];

                $a = $tool->getSelectorTemplate(array(
                    'id' => $block.$product['product_id'],
                    'group' => $block.$tool->params->getValue('block-id'),
                    'img' => fn_magiczoom_create_thumb($imagePairPath, 'original', $tool, $product['product_id']),
                    'medium' => fn_magiczoom_create_thumb($imagePairPath, 'thumb', $tool, $product['product_id']),
                    'thumb' => fn_magiczoom_create_thumb($imagePairPath, 'selector', $tool, $product['product_id']),
                    'title' => $title,
                    'width' => $width,
                    'height' => $height
                ));

                $additionalImages[] = $originalLayout ? str_replace('<a ', '<a class="cm-thumbnails-mini" ', $a) : $a;

            }

            //NOTE: fix width
            if($tool->params->checkValue('template', array('left', 'right'), 'product')) {
                $additionalImages[] = '
                    <script type="text/javascript">
                        var selectorsContainer = $("#MagicToolboxSelectors'.$product['product_id'].'");
                        var selectorA = $("#MagicToolboxSelectors'.$product['product_id'].' a:first");
                        var magicToolboxContainerWidth = parseFloat(selectorsContainer.parent().css("width"));
                        var selectorsContainerWidth = parseFloat(selectorsContainer.css("width"));
                        var fixedWidth = parseFloat(selectorA.css("width")) +
                                         parseFloat(selectorA.css("margin-left")) +
                                         parseFloat(selectorA.css("margin-right")) +
                                         parseFloat(selectorA.css("border-left-width")) +
                                         parseFloat(selectorA.css("border-right-width"));
                        if(fixedWidth - selectorsContainerWidth > 0) {
                            selectorsContainer.css("width", fixedWidth);
                            selectorsContainer.parent().css("width", magicToolboxContainerWidth + fixedWidth - selectorsContainerWidth);
                        }
                    </script>';
            }

        }

        if($block == 'product' && $useMagic360) {
            $GLOBALS['magictoolbox']['cooperative_mode'] = 'magiczoom';
            $magic360tool->params->setValue('selector-max-width', $tool->params->getValue('selector-max-width'));
            $magic360tool->params->setValue('selector-max-height', $tool->params->getValue('selector-max-height'));
            $magic360tool->params->setValue('original-layout', $originalLayout, 'product');
            $mainImageHTML = 
                '<div style="position: relative;">'.
                    '<div id="mainImageContainer'.$product['product_id'].'" style="position: absolute; left: -10000px;">'.
                        //NOTE: we need this div because of issue with MZP, which clones the parent node
                        '<div>'.$mainImageHTML.'</div>'.
                    '</div>'.
                    '<div id="magic360Container'.$product['product_id'].'"><!-- MAGIC360 --></div>'.
                '</div>';
            if(empty($additionalImages)) {
                $additionalImages[] = $mainImageSelectorHTML;
            }
            foreach($additionalImages as &$selector) {
                if(preg_match('#(<a\b[^>]*?\bclass=")([^"]*+")#i', $selector, $_match)) {
                    $selector = str_replace($_match[0], $_match[1].'zoom-with-360 '.$_match[2], $selector);
                } else {
                    $selector = str_replace('<a ', '<a class="zoom-with-360" ', $selector);
                }
            }
            array_unshift($additionalImages, '<!-- MAGIC360SELECTOR -->');
        }

        if($block == 'product') {
            $mainImageHTML .= '<script type="text/javascript">'.
                                'var magicToolboxTool = \'MagicZoom\', magicToolboxProductId = \''.$product['product_id'].'\', '.
                                'magicToolboxOriginalLayout='.($originalLayout ? 'true' : 'false').';'.
                                '</script>';

            require_once(dirname(__FILE__).'/core/magictoolbox.templatehelper.class.php');
            MagicToolboxTemplateHelperClass::setPath(dirname(__FILE__).DIRECTORY_SEPARATOR.'templates');
            MagicToolboxTemplateHelperClass::setOptions($tool->params);
            $scroll = fn_magiczoom_magicscroll_load();
            $options = array(
                'main' => $mainImageHTML,
                'thumbs' => $additionalImages,
                'magicscrollOptions' => $scroll->params->serialize(false, '', 'product-magicscroll-options'),
                'pid' => $product['product_id'],
                'jcarousel' => $jcarousel
            );

            $html = MagicToolboxTemplateHelperClass::render($options);

            //NOTE: set width for a large number of selectors
            if($tool->params->checkValue('magicscroll', 'No') && $tool->params->checkValue('template', array('top', 'bottom', 'original'))) {
                $html = preg_replace('#(<div\b[^>]*?\bclass="[^"]*?MagicToolboxContainer[^"]*+)("[^>]*+>)#i', '$1 maxWidth$2', $html);
            }

        } else {
            $html = '<div class="MagicToolboxContainer">'.$mainImageHTML.'</div>';
        }

        setlocale(LC_ALL, $old_locale);

        if($html) {
            if($block == 'product') {
                $additional_thumbnails_pattern = '<'.($jcarousel?'ul':'div').'[^>]+?class="[^"]*?(?:cm-)?product-thumbnails[^"]*"[^>]*>[^<]*(?:'.
                    ($jcarousel?'<li[^>]*>':'').
                    '<a[^>]+?class="[^"]*?cm-thumbnails-mini[^"]*"[^>]*>[^<]*'.
                    '<img[^>]*>[^<]*'.
                    '<\/a>[^<]*'.
                    ($jcarousel?'<\/li>':'').
                    ')+<\/'.($jcarousel?'ul':'div').'>';
                $contents = preg_replace('/'.$additional_thumbnails_pattern.'/is', '', $contents);
                if($jcarousel) {
                    //DEPRECATED: the option value is changed in core.js
                    //$contents = str_replace('\'circular\'', '\'both\'', $contents);

                    //NOTE: to init jCarousel
                    $productImageGalleryInitPattern = '((?:\$|jQuery)\.ceProductImageGallery\(\s*\$\(\s*")(#images_preview_'.$product['product_id'].'[^"]*)("\s*\)\s*\))';
                    $matches = array();
                    if(preg_match('/'.$productImageGalleryInitPattern.'/is', $contents, $matches)) {
                        $contents = str_replace($matches[0], $matches[1].'div.MagicToolboxSelectorsContainer ul.jcarousel-skin'.$matches[3], $contents);
                    }
                }
                $image_pattern = '(?:<span[^>]+?class="[^"]*?larger-image-wrap[^"]*"[^>]*>[^<]*'.
                    '<a[^>]+?class="[^"]*?view-larger-image[^"]*"[^>]*>[^<]*'.
                    '<\/a>[^<]*'.
                    '<\/span>[^<]*)?'.
                    '(?:<a[^>]+?id="det_img_link_[^"]*"[^>]*>[^<]*)?'.
                    '<img[^>]+?id="det_img_'.$product['product_id'].'[^"]*"[^>]*>[^<]*'.
                    '(?:<\/a>[^<]*)?';
                $contents = preg_replace('/(?:'.$image_pattern.')+/is', str_replace('$', '\$', $html), $contents, 1);//NOTE: $limit = 1 to prevent the replacement of product in product tabs(product id == block id)
            } else {
                $image_with_update_pattern = '(?:<a[^>]+>[^<]*(<input[^>]+>)[^<]*)?(<input[^>]+>)[^<]*<img[^>]+?src="'.$src_pattern.'"[^>]*>(?:[^<]*<\/a>)?';
                $simple_image_pattern = '(?:<a[^>]+>[^<]*)?<img[^>]+?src="'.$src_pattern.'"[^>]*>(?:[^<]*<\/a>)?';

                $matches = array();
                $inputs = '';
                if(preg_match('/'.$image_with_update_pattern.'/is', $contents, $matches)) {
                    $inputs = (isset($matches[1]) && !empty($matches[1]))? $matches[1] : '';
                    $inputs .= (isset($matches[2]) && !empty($matches[2]))? $matches[2] : '';
                    $contents = str_replace($matches[0], $inputs.$html, $contents);
                } else if(preg_match('/'.$simple_image_pattern.'/is', $contents, $matches)) {
                    $contents = str_replace($matches[0], $html, $contents);
                }
            }
        }

    }

    if($block != 'product') {
        if($tool->params->checkValue('disable-quick-view', 'Yes')) {
            $quick_view_button_pattern = '<div[^>]+?class="[^"]*?quick-view[^"]*"[^>]*>[^<]*'.
                '<span[^>]*>[^<]*<span[^>]*>[^<]*<a[^>]*>[^<]*'.
                '.*?'.
                '<\/a>[^<]*<\/span>[^<]*<\/span>[^<]*'.
                '<\/div>';
            $contents = preg_replace('/'.$quick_view_button_pattern.'/is', '', $contents);
        }
    }

    return $contents;
}

function fn_magiczoom_create_thumb($src, $size, &$tool, $pid) {

    static $imageDir = '';
    static $imagesPathQuoted = '';
    static $imagehelper = null;

    if($imagehelper === null) {
        $imagesPathQuoted = preg_quote(Registry::get('config.images_path'), '/');
        $imageDir = str_replace(DIR_ROOT, '', DIR_IMAGES);
        //$config['images_path'] = $config['current_path'] . '/images/';
        require_once(dirname(__FILE__).'/core/magictoolbox.imagehelper.class.php');
        $imagehelper = new MagicToolboxImageHelperClass(DIR_ROOT, $imageDir.'magictoolbox_cache', $tool->params, null, Registry::get('config.http_path'));
    }

    $src = htmlspecialchars_decode($src, ENT_QUOTES);

    //preg_match('/^(.*?(product|detailed|banner|promo|magic360)\/(.*?\/)?)([^\/]*?)\.([^\.]*)$/is', $src, $matches);
    //if(empty($matches)) return $src;
    //list(, $path, $iType, $subDir, $name, $ext) = $matches;
    //if(empty($iType)) { $iType = 'product'; $subDir = '';}
    //if($subDir == $path) $subDir = '';
    //$img = $imageDir.$iType.'/'.$subDir.$name.'.'.$ext;

    preg_match('/^.*?'.$imagesPathQuoted.'(.*?)$/is', $src, $matches);
    if(empty($matches)) return $src;
    $img = $imageDir.$matches[1];

    $thumb = $imagehelper->create($img, $size, $pid);
    //NOTE: spike to get real size of image
    $GLOBALS['magictoolbox']['file_path'] = $imagehelper->file;
    if(MT_DS != '/') {
        $thumb = str_replace(MT_DS, '/', $thumb);
    }

    return $thumb;
}

function fn_magiczoom_js_functions() {

    if(Registry::get("addons.magiczoom.status") === 'D') {
        $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic Zoom module should be enabled for proper operation of the settings page." .
                   "<br/>Please enable it before save settings.</span>";
        fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('warning').'</span>', $message, true, 'magiczoom_module_disabled_notification');
    }

    //$modulePath = Registry::get('config.current_path').substr(DIR_ADDONS, strlen(DIR_ROOT)).'magiczoom';
    return '
        <script type="text/javascript">
            //<![CDATA[
            function fn_magiczoom_prepare_custom_options(block, skip) {
                skip = (skip || \'\').split(\'|\');
                skip.push(\'enable-effect\');
                var enabledOptionsID = "#addon_option_magiczoom_" + block + "-enabled-options";
                var enabledOptions = $(enabledOptionsID).val();
                var sectionID = "#content_magiczoom_magiczoom_" + block;
                $(sectionID + " div.form-field").
                 each(function(){
                        $(this).
                         find("select, input[type=\'text\']").
                         each(function(){
                                var optionId = this.id.replace("addon_option_magiczoom_" + block + "-","");
                                if(jQuery.inArray(optionId, skip) !== -1) {
                                    return;
                                }
                                if(enabledOptions.indexOf("|" + optionId + "|") == -1) {
                                    $(this).attr("disabled", true).after("&nbsp;&nbsp;<a href=\"#\" >edit</a>");
                                } else {
                                    $(this).after("&nbsp;&nbsp;<a href=\"#\" >use default option</a>");
                                }
                                $(this).next().
                                    bind("click", {optionId: optionId, enabledOptionsID: enabledOptionsID},
                                                    function(event) {
                                                        var enabledOptions = $(event.data.enabledOptionsID).val();
                                                        if($(this).html() == "edit") {
                                                            $(this).html("use default option").prev().removeAttr("disabled");
                                                            enabledOptions = enabledOptions.concat(event.data.optionId + "|");
                                                        } else {
                                                            $(this).html("edit").prev().attr("disabled", true).val($("#addon_option_magiczoom_general-" + event.data.optionId).val().replace("general-", block + "-"));
                                                            var pattern = new RegExp("\\\\|" + event.data.optionId + "\\\\|", "g");
                                                            enabledOptions = enabledOptions.replace(pattern, "|");
                                                        }
                                                        $(event.data.enabledOptionsID).val(enabledOptions);
                                                        return false;
                                                }
                                        );

                              }).
                         end().
                         find("input[type=\'radio\']:checked").
                         each(function(){
                                var optionId = this.parentNode.id.replace("addon_option_magiczoom_" + block + "-","");
                                if(jQuery.inArray(optionId, skip) !== -1) {
                                    return;
                                }
                                if(enabledOptions.indexOf("|" + optionId + "|") == -1) {
                                    $(this.parentNode).find("input").attr("disabled", true).end().
                                     find(":last-child").after("&nbsp;&nbsp;<a href=\"#\" >edit</a>");
                                } else {
                                    $(this.parentNode).find(":last-child").after("&nbsp;&nbsp;<a href=\"#\" >use default option</a>");
                                }
                                $(this.parentNode).find(":last-child").
                                    bind("click", {optionId: optionId, enabledOptionsID: enabledOptionsID},
                                                    function(event) {
                                                        var enabledOptions = $(event.data.enabledOptionsID).val();
                                                        if($(this).html() == "edit") {
                                                            $(this).html("use default option");
                                                            $(this.parentNode).find("input").removeAttr("disabled");
                                                            enabledOptions = enabledOptions.concat(event.data.optionId + "|");
                                                        } else {
                                                            $(this).html("edit");
                                                            $(this.parentNode).find("input").attr("disabled", true).val([$("#addon_option_magiczoom_general-" + optionId + " input:checked").val().replace("general", block)]);
                                                            var pattern = new RegExp("\\\\|" + event.data.optionId + "\\\\|", "g");
                                                            enabledOptions = enabledOptions.replace(pattern, "|");
                                                        }
                                                        $(event.data.enabledOptionsID).val(enabledOptions);
                                                        return false;
                                                }
                                        );

                              });
                      });
            }
            function fn_magiczoom_clear_cache_field(data, params) {
                if(data.html) {
                    for (var k in data.html) {
                        $("#addon_option_magiczoom_cache-total-items").val(data.html[k]);
                        $("#addon_option_magiczoom_cache-unused-items").val("0 (0 bytes)");
                        break;
                    }
                }
            }
            //]]>
        </script>
';

}

function fn_magiczoom_prepare_custom_options($block) {

    static $addonOptions;
    static $enabledOptions;
    $headersBind = '';
    $generalParamsChangeBind = '';
    $includeOptionsJs = '';
    $initOptionsValidation = '';
    $magicscrollIcon = '';
    $blocks = array('product',
                    'category',
                    'search',
                    'newest', 'recent_products', 'popularity', 'bestsellers', 'rating', 'manually',
                   );

    if(!isset($addonOptions)) {
        $section = CSettings::instance()->get_section_by_name($_REQUEST['addon'], CSettings::ADDON_SECTION);
        $addonOptions = db_get_hash_single_array('SELECT name, value FROM ?:settings_objects WHERE section_id = \'?p\' AND type != \'H\'', array('name', 'value'), $section['section_id']);
        $enabledOptions = db_get_hash_single_array('SELECT block, value FROM ?:addon_magiczoom_options WHERE name = \'enabled_options\'', array('block', 'value'));
    }

    switch($block) {
        case 'general':
            if(isset($addonOptions['cache-path-to-cache'])) {
                $pathToCache = $addonOptions['cache-path-to-cache'];
            } else {
                $pathToCache = str_replace(DIR_ROOT, '', DIR_IMAGES).'magictoolbox_cache';
            }
            $tool = fn_magiczoom_load();
            require_once(dirname(__FILE__).'/core/magictoolbox.imagehelper.class.php');
            $imagehelper = new MagicToolboxImageHelperClass(DIR_ROOT, $pathToCache, $tool->params);
            $usedSubCache = $imagehelper->getOptionsHash();
            $cacheInfo = fn_magiczoom_getCacheInfo(DIR_ROOT.$pathToCache, $usedSubCache);
            return  '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magiczoom_cache-path-to-cache">Path to cache folder'.
                    '(<a onclick="return false;" class="cm-tooltip" title="Relative for site base path.">?</a>)<span class="hidden cm-tooltip-text"></span>'.
                    '</label>'.
                    '<input type="text" name="addon_data[options][cache-path-to-cache]" id="addon_option_magiczoom_cache-path-to-cache" value="'.$pathToCache.'" class="input-text" style="width:352px;" disabled="disabled" />'.
                    '</div>'.
                    '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magiczoom_cache-total-items">Total items:</label>'.
                    '<input type="text" name="addon_data[options][cache-total-items]" id="addon_option_magiczoom_cache-total-items" value="'.$cacheInfo['totalCount'].' ('.fn_magiczoom_format_size($cacheInfo['totalSize']).')" class="input-text" disabled="disabled" />'.
                    '</div>'.
                    '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magiczoom_cache-unused-items">Unused items:</label>'.
                    '<input type="text" name="addon_data[options][cache-unused-items]" id="addon_option_magiczoom_cache-unused-items" value="'.$cacheInfo['unusedCount'].' ('.fn_magiczoom_format_size($cacheInfo['unusedSize']).')" class="input-text" disabled="disabled" />'.
                    '</div>'.
                    '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magiczoom_cache-what-clear">Empty cache:</label>'.
                    '<select id="addon_option_magiczoom_cache-what-clear" onchange="$(\'#magiczoom_clear_cache_field\').attr(\'href\', \''.INDEX_SCRIPT.'?dispatch=magiczoom_cache.\'+this.value).attr(\'rev\', this.value);">'.
                    '<option  selected="selected" value="clear_unused_items">Delete unused items</option>'.
                    '<option value="clear_all_items">Delete all items</option>'.
                    '</select>'.
                    '&nbsp;<a name="magiczoom_clear_cache_field" id="magiczoom_clear_cache_field" href="'.INDEX_SCRIPT.'?dispatch=magiczoom_cache.clear_unused_items" class="cm-ajax cm-confirm" rev="clear_unused_items" >Clear</a>'.
                    '</div>'
                    ;
            break;
        case 'manually':
            //only after last block
            $blocks  = '"'.implode('", "', $blocks).'"';
            $headersBind = '$("#tabs_content_magiczoom h2.subheader").css({\'background-color\': \'#F4F4F4\', \'cursor\': \'pointer\'}).slice(0, 1).prepend("&nbsp;<img alt=\"\" src=\"./skins/basic/admin/images/icons/advanced_search_expanded.gif\">").end().slice(1).prepend("&nbsp;<img alt=\"\" src=\"./skins/basic/admin/images/icons/advanced_search_collapsed.gif\">").end().bind("click", function(){$(this).find("img").each(function(){if(this.src.indexOf("advanced_search_collapsed") == -1) this.src = this.src.replace("advanced_search_expanded", "advanced_search_collapsed"); else this.src = this.src.replace("advanced_search_collapsed", "advanced_search_expanded");}).end().nextAll().each(function slideToggleNode(){if(typeof slideToggleNode.stop == "undefined" ) {if(this.tagName=="H2") slideToggleNode.stop = true; else $(this).slideToggle(250);}}); return false;}).slice(1, 2).nextAll("div.form-field").css("display", "none");$("#tabs_content_magiczoom div").slice(1).find("h2.subheader:first").nextAll("div.form-field").css("display", "none");';
            $generalParamsChangeBind = '
$("#content_magiczoom_magiczoom_general").find("input[type=\'text\']").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.id.replace("addon_option_magiczoom_general-","");
var optioVal = $(this).val();
for(block in block_array) {
    $("#content_magiczoom_magiczoom_" + block_array[block]).
    find("#addon_option_magiczoom_" + block_array[block] + "-" + optionId + ":disabled").val(optioVal);
}
}).
end().find("select").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.id.replace("addon_option_magiczoom_general-","");
var optioVal = $(this).val().replace("general-" + optionId + "-", "");
for(block in block_array) {
    $("#content_magiczoom_magiczoom_" + block_array[block]).
    find("#addon_option_magiczoom_" + block_array[block] + "-" + optionId + ":disabled").val(block_array[block] + "-" + optionId + "-" + optioVal);
}
}).
end().find("input[type=\'radio\']").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.parentNode.id.replace("addon_option_magiczoom_general-","");
var optioVal = $(this).val().replace("general-" + optionId + "-", "");
for(block in block_array) {
    $("#content_magiczoom_magiczoom_" + block_array[block]).
    find("#addon_option_magiczoom_" + block_array[block] + "-" + optionId + " input:disabled").val([block_array[block] + "-" + optionId + "-" + optioVal]);
}
});';
            $tool = fn_magiczoom_load();
            $http_path = Registry::get('config.http_path');
            $includeOptionsJs = '<script type="text/javascript" src="'.$http_path.'/addons/magiczoom/options.js"></script>';
            $template_option_id = CSettings::instance()->get_id('product-template', 'magiczoom');
            $magicscroll_option_id = CSettings::instance()->get_id('product-magicscroll', 'magiczoom');
            $initOptionsValidation = 'initOptionsValidation(\'addon_data[options]['.$template_option_id.']\', \'addon_data[options]['.$magicscroll_option_id.']\', \'product-template-\', \'product-magicscroll-\');';
            $magicscrollIcon = '
var magicscrollIcon = document.createElement("img");
magicscrollIcon.id = "magicscroll_icon";
magicscrollIcon.src = "'.Registry::get('config.http_path')."/addons/magiczoom/magicscroll.png".'";
magicscrollIcon.style.marginRight = "5px";
magicscrollIcon.style.verticalAlign = "middle";
document.getElementById("addon_option_magiczoom_product-magicscroll").insertBefore(magicscrollIcon, document.getElementById("addon_option_magiczoom_product-magicscroll").firstChild);
';
        default:
    }

    $tool = fn_magiczoom_load();
    //$skip = array('disable-zoom');
    $skip = array();

    if($tool->type == 'standard') {
        foreach($tool->params->getParams() as $param) {
            if(in_array($param['group'], array('General', 'Scroll', 'Scroll Arrows', 'Scroll Slider', 'Scroll effect', 'Multiple images'))) {
                $skip[] = $param['id'];
            }
        }
    }

    $skip = implode('|', $skip);
    return $includeOptionsJs.'
        <input type="hidden" name="addon_data[options]['.$block.'-enabled-options]" id="addon_option_magiczoom_'.$block.'-enabled-options" value="'.$enabledOptions[$block].'" />
        <script type="text/javascript">
            //<![CDATA[
            fn_magiczoom_prepare_custom_options("'.$block.'", \''.$skip.'\');
            '.$headersBind.$generalParamsChangeBind.$initOptionsValidation.$magicscrollIcon.'
            //]]>
        </script>
    ';
}

function fn_magiczoom_getCacheInfo($path, $usedSubCache = null) {

    $totalSize = 0;
    $totalCount = 0;
    $usedSize = 0;
    $usedCount = 0;
    if (is_dir($path))
    if ($handle = opendir($path)) {
        while (false !== ($file = readdir($handle))) {
            $next = $path.DIRECTORY_SEPARATOR.$file;
            if ($file != '.' && $file != '..' && !is_link($next)) {
                if (is_dir($next)) {
                    $result = fn_magiczoom_getCacheInfo($next);
                    if($file == $usedSubCache) {
                        $usedSize += $result['totalSize'];
                        $usedCount += $result['totalCount'];
                    }
                    $totalSize += $result['totalSize'];
                    $totalCount += $result['totalCount'];
                } elseif (is_file($next)) {
                    $totalSize += filesize($next);
                    $totalCount++;
                }
            }
        }
        closedir($handle);
    }
    return array('totalSize' => $totalSize, 'totalCount' => $totalCount, 'unusedSize' => $totalSize-$usedSize, 'unusedCount' => $totalCount-$usedCount);
}

function fn_magiczoom_format_size($size) {
    $units = array(' bytes', ' KB', ' MB', ' GB', ' TB');
    for ($i = 0; $size >= 1024 && $i < 4; $i++) $size /= 1024;
    return round($size, 2).$units[$i];
}

function fn_magiczoom_install() {

    $js_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ROOT.'/js');
    $module_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ADDONS.'/magiczoom');
    $jsFiles = array('/ajax', '/core');
    $suffix = '_packed';
    $cancel = false;

    if(!defined('PRODUCT_VERSION') || version_compare(PRODUCT_VERSION, '3.0.0', '<')) {
        if(!fn_notification_exists('E', 'magiczoom_module_version_notification')) {
            $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">This Magic Zoom module is intended only for CS Cart Version 3 and above.".
                       "<br/>Your version of CS Cart is ".PRODUCT_VERSION."</span>";
            fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magiczoom_module_version_notification');
        }
    }

    if(!class_exists('JavaScriptPacker'))
        include_once(DIR_LIB.'packer/class.JavaScriptPacker.php');

    foreach($jsFiles as $fileName) {
        if(@is_file($module_directory.$fileName.'.js')) {
           //installed
        } else {
            if(@is_file($js_directory.$fileName.'.js') && is_writeable($module_directory)) {
                switch($fileName) {
                    case '/ajax':
                        // modify ajax.js
                        $c = file_get_contents($js_directory.$fileName.'.js');
                        $stop = '
        if(params && params.result_ids) {
            if((params.result_ids.search(/(?:product_images_|list_image_update_|product_quick_view_)\d+(?:_update)?|product_filters_\*/i) != -1) || (params.result_ids == \'pagination_contents\')) {
                var productIdMatch = params.result_ids.match(/.*?(?:product_images_|list_image_update_|product_quick_view_)([0-9]+)(?:_update)?.*/i);
                if(productIdMatch) {
                    fn_magictoolbox_tool_update("stop", "product", productIdMatch[1]);
                } else {
                    fn_magictoolbox_tool_update("stop", "category", "");
                }
            }
        }';
                        $start = '
        if(params && params.result_ids) {
            if((params.result_ids.search(/(?:product_images_|list_image_update_|product_quick_view_)\d+(?:_update)?|product_filters_\*/i) != -1) || (params.result_ids == \'pagination_contents\')) {
                var productIdMatch = params.result_ids.match(/.*?(?:product_images_|list_image_update_|product_quick_view_)([0-9]+)(?:_update)?.*/i);
                if(productIdMatch) {
                    fn_magictoolbox_tool_update("start", "product", productIdMatch[1]);
                } else {
                    fn_magictoolbox_tool_update("start", "category", "");
                }
            }
        }';
                        $c = preg_replace('/(ajaxRequest\: function\(url, params\)\s+?\{)/', '$1'.$stop, $c);
                        $c = preg_replace('/((?:\$|jQuery)\.toggleStatusBox\(\'hide\'\);)/', '$1'.$start, $c);
                        file_put_contents($module_directory.$fileName.'.js', $c);

                        $packer = new JavaScriptPacker(fn_get_contents($module_directory.$fileName.'.js'));
                        fn_put_contents($module_directory.$fileName.$suffix.'.js', $packer->pack());

                        break;
                    case '/core':
                        //modify core.js file
                        $c = file_get_contents($js_directory.$fileName.'.js');

                        $pattern = 'for (var k in data) {';
                        $replace = 'for (var k in data) { if(!data.hasOwnProperty(k)) {continue;}';
                        $c = str_replace($pattern, $replace, $c);

                        //NOTE: change function name since version 3.0.1 RC6
                        $pattern = '/((?:fn_scroller_)?init_callback[^\{]*\{)/i';
                        $replace = "$1\n\t\t\tif(carousel.list.parents('div.MagicToolboxSelectorsContainer').length || carousel.list.find('div.MagicToolboxContainer').length) {".
                        "\n\t\t\t\tcarousel.options.wrap = 'both';\n\t\t\t}";

                        $c = preg_replace($pattern, $replace, $c);

                        file_put_contents($module_directory.$fileName.'.js', $c);

                        $packer = new JavaScriptPacker(fn_get_contents($module_directory.$fileName.'.js'));
                        fn_put_contents($module_directory.$fileName.$suffix.'.js', $packer->pack());

                        break;
                }
            } else {
                //can't install
                $cancel = true;
                if(!is_writeable($module_directory) && !fn_notification_exists('E', 'magiczoom_module_directory_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic Zoom needs write access to the folder <b>'".$module_directory."'</b> for proper installation." .
                               "<br/>Please check this and reinstall Magic Zoom.</span>";
                    fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magiczoom_module_directory_notification');
                }
                if(!@is_file($js_directory.$fileName.'.js') && !fn_notification_exists('E', 'magiczoom_file'.$fileName.'_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic Zoom needs read access to the file <b>'".$js_directory.$fileName.".js'</b> for proper installation." .
                               "<br/>Please check this and reinstall Magic Zoom.</span>";
                    fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magiczoom_file'.$fileName.'_notification');
                }
            }
        }
    }

    if(!is_file($module_directory.'/tabs'.$suffix.'.js')) {
        $packer = new JavaScriptPacker(fn_get_contents($module_directory.'/tabs.js'));
        fn_put_contents($module_directory.'/tabs'.$suffix.'.js', $packer->pack());
    }


    //fix url's in css files
    $cancel = fn_magiczoom_fix_css();


    if($cancel) {
        $args = func_get_args();
        if(!empty($args)) fn_redirect("addons.manage");
    }

    //NOTE: fix the order in which modules call
    $magic_addons = db_get_fields("SELECT addon FROM ?:addons WHERE addon LIKE 'magic%'");
    if(!empty($magic_addons)) {
        $magic_addons_data = array();
        foreach($magic_addons as $addon) {
            $magic_addons_data[$addon] = db_get_row("SELECT * FROM ?:addons WHERE addon='{$addon}'");
            db_query("DELETE FROM ?:addons WHERE addon='{$addon}'");
        }
        if(isset($magic_addons_data['magiczoom'])) {
            db_query("INSERT INTO ?:addons ?e", $magic_addons_data['magiczoom']);
            unset($magic_addons_data['magiczoom']);
        }
        foreach($magic_addons_data as $addon => $data) {
            db_query("INSERT INTO ?:addons ?e", $data);
        }
    }

    fn_magiczoom_send_stat('install');

}

function fn_magiczoom_fix_css() {

    $cancel = false;

    $path = dirname(__FILE__).'/core';

    $resourcesPath = Registry::get('config.current_path').substr(DIR_ADDONS, strlen(DIR_ROOT)).'magiczoom/core';
    $resourcesPath = str_replace(array("//", "\\"), array("/", "/"), $resourcesPath);

    $list = glob($path.'/*');
    $files = array();
    if(is_array($list)) {
        for($i = 0; $i < count($list); $i++) {
            if(is_dir($list[$i])) {
                if(!in_array(basename($list[$i]), array('.svn', '.git'))) {
                    $add = glob($list[$i].'/*');
                    if(is_array($add)) {
                        $list = array_merge($list, $add);
                    }
                }
            } else if(preg_match('#\.css$#i', $list[$i])) {
                $files[] = $list[$i];
            }
        }
    }

    foreach($files as $file) {
        $cssPath = dirname($file);
        $cssRelPath = str_replace($path, '', $cssPath);
        $toolPath = $resourcesPath.$cssRelPath;
        $pattern = '#url\(\s*(\'|")?(?!data:|mhtml:|http(?:s)?:|/)([^\)\s\'"]+?)(?(1)\1)\s*\)#is';
        $replace = 'url($1'.$toolPath.'/$2$1)';
        $fileContents = file_get_contents($file);
        $fixedFileContents = preg_replace($pattern, $replace, $fileContents);
        if($fixedFileContents != $fileContents) {
            if(is_writeable($file)) {
                file_put_contents($file, $fixedFileContents);
            } else {
                //NOTE: install module anyway
                /*
                $cancel = true;
                if(!fn_notification_exists('E', 'magiczoom_file_'.md5($file).'_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic Zoom needs write access to the file <b>'".$file."'</b> for proper installation." .
                                "<br/>Please check this and reinstall Magic Zoom.</span>";
                    fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magiczoom_file_'.md5($file).'_notification');
                }
                */
            }
        }
    }

    return $cancel;

}

function fn_magiczoom_after_install() {
    //NOTE: we need to change position of options in DB, that the content displayed in the right order
    $section = CSettings::instance()->get_section_by_name($_REQUEST['addon'], CSettings::ADDON_SECTION);
    $query = 'UPDATE ?:settings_objects SET ?:settings_objects.position = ?:settings_objects.object_id WHERE ?:settings_objects.section_id = ?s';
    db_query($query , $section['section_id']);
}

function fn_magiczoom_uninstall() {

    $js_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ROOT.'/js');
    $module_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ADDONS.'/magiczoom');
    $jsFiles = array('/ajax', '/core');
    $suffix = '_packed';

    foreach($jsFiles as $fileName) {
        if(@is_file($module_directory.$fileName.'.js')) {
            @unlink($module_directory.$fileName.'.js');
        }
        if(@is_file($module_directory.$fileName.$suffix.'.js')) {
            @unlink($module_directory.$fileName.$suffix.'.js');
        }
    }
    if(@is_file($module_directory.'/tabs'.$suffix.'.js')) {
        @unlink($module_directory.'/tabs'.$suffix.'.js');
    }

    fn_magiczoom_send_stat('uninstall');

}

function fn_magiczoom_send_stat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v1.4.7' || 'working' == 'v5.3.7') {
        return;
    }

    $hostname = 'www.magictoolbox.com';
    $url = $_SERVER['HTTP_HOST'].preg_replace('/\/[^\/]*?\.php.*$/i', '', $_SERVER['REQUEST_URI']);
    $url = urlencode(urldecode($url));
    $platformVersion = defined('PRODUCT_VERSION') ? PRODUCT_VERSION : '';
    $path = "api/stat/?action={$action}&tool_name=magiczoom&license=trial&tool_version=v5.3.7&module_version=v1.4.7&platform_name=cscart3&platform_version={$platformVersion}&url={$url}";
    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers  = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }
}
