<?php

if ( !defined('AREA') ) { die('Access denied'); }

define('MT_DS', DIRECTORY_SEPARATOR);

function fn_magicslideshow($output, &$view) {

    $block = '';
    $block_id = '';
    static $ajax = null;
    static $main_product_processed = false;
    static $products_search_processed = false;

    if($ajax === null) {
        $ajax = isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest');
                //&& in_array($_REQUEST['dispatch'], array('products.options', 'categories.view'))
    }

    $search = !$products_search_processed  && isset($view->_tpl_vars['layouts']) && (
              ($view->_tpl_vars['mode'] == 'search' && $view->_tpl_vars['controller'] == 'products') ||
              //NOTE: to support tags page
              ($view->_tpl_vars['controller'] == 'tags' && $view->_tpl_vars['mode'] == 'view')  );

    if($ajax) {
        //check block
        if(isset($view->_tpl_vars['obj_prefix']) && $view->_tpl_vars['obj_prefix'] != 'ajax') {
            if(substr($view->_tpl_vars['obj_prefix'], -3) == '000') {
                $block_id = substr($view->_tpl_vars['obj_prefix'], 0, -3);
                $block_data = Bm_Block::instance()->get_by_id($block_id);
                if(isset($block_data['content']['items']['filling'])) {
                    $block = $block_data['content']['items']['filling'];
                }
            }
        } else if(defined('MAGICSLIDESHOW_GET_PRODUCT_DETAILS_LAYOUT_POST_HOOK') ||
                  in_array($view->_tpl_vars['mode'], array('quick_view', 'options')) && $view->_tpl_vars['controller'] == 'products') {
            $block = 'product';
        }
    } else {
        if(!$main_product_processed && defined('MAGICSLIDESHOW_GET_PRODUCT_DETAILS_LAYOUT_POST_HOOK')) {
            if(isset($view->_tpl_vars['block']['type']) && $view->_tpl_vars['block']['type'] == 'main') {
                //$block_id = $view->_tpl_vars['block']['block_id'];
                $block = 'product';
                $main_product_processed = true;
            }
        } else {
            if(isset($view->_smarty_vars['capture']['magicslideshow_capture']) || $search) {
            } else
            //process template if inclusion depth = 0
            //if($view->_inclusion_depth) return $output;
            //NOTICE: in some cases, this value is set to -1 for some reason, maybe it's a bug
            if($view->_inclusion_depth && $view->_inclusion_depth != -1) return $output;
        }
    }

    if(isset($view->_smarty_vars['capture']['magicslideshow_capture'])) {
        $block = $view->_smarty_vars['capture']['magicslideshow_capture'];
        unset($view->_smarty_vars['capture']['magicslideshow_capture']);
    } else if($search) {
        $block = 'search';
        $products_search_processed = true;
    } else if(isset($view->_tpl_vars['block'],
                   $view->_tpl_vars['block']['content'],
                   $view->_tpl_vars['block']['content']['items'],
                   $view->_tpl_vars['block']['content']['items']['filling'])
             ) {
        $block = $view->_tpl_vars['block']['content']['items']['filling'];
        if($view->_tpl_vars['block']['type'] == 'banners') {
            $magicslideshow_effect = isset($view->_tpl_vars['block']['properties']['magicslideshow_effect'])?$view->_tpl_vars['block']['properties']['magicslideshow_effect']:'No';
            $block = 'banners';
        } else
        if($view->_tpl_vars['block']['type'] != 'products') {
            return $output;
        }
        $block_id = $view->_tpl_vars['block']['block_id'];
    }
    if(empty($block)) return $output;

    $blocks = array('product',
                    'newest', 'recent_products', 'popularity', 'bestsellers', 'rating', 'manually',
                    'banners',
                    'head'//footer
                   );

    if($block == 'most_popular') {
        //NOTE: filling changed since v3.0.1 RC 5
        $block = 'popularity';
    } else if(isset($_REQUEST['sef_rewrite']) && $block == 'scripts') {
        //NOTE: for output headers on '404' (etc.) pages
        $simpleHeaders = true;
        $block = 'head';
    }

    if(!in_array($block, $blocks)) return $output;

    $tool = fn_magicslideshow_load();

    if($block == 'head') {
        //NOTE: we need to apply headers always because we don't know whether the effect is applied to the block in the cache.
        //if($tool->params->paramExists('headers', $tool->params->generalProfile) && $tool->params->getValue('headers', $tool->params->generalProfile) == 'Yes') {
        if(isset($simpleHeaders)) {
            return fn_magicslideshow_headers($output, true);
        }
        foreach($tool->params->getProfiles() as $block) {
            if(!$tool->params->checkValue('enable-effect', 'No', $block)) {
                return fn_magicslideshow_headers($output);
            }
        }
        //NOTE: for banner blocks
        if(isset($GLOBALS['magictoolbox']['processed_blocks'])/* && count($GLOBALS['magictoolbox']['processed_blocks'])*/) {
            return fn_magicslideshow_headers($output);
        }
        //}
        return $output;
    }

    if($block == 'banners') {
        $tool->params->setValue('enable-effect', $magicslideshow_effect, 'banners');
    }
    if($tool->params->checkValue('enable-effect', 'No', $block)) return $output;

    //$tpl_vars = $view->get_template_vars();
    $tool->params->setValue('index-script', $view->get_template_vars('index_script'));
    $tool->params->setValue('block-id', $block_id);
    $tool->params->setValue('mode', $view->get_template_vars('mode'));

    switch($block) {
        case 'product':
            $products = ($block != 'product') ? $view->get_template_vars('products') : array($view->get_template_vars('product'));
            $output = fn_magicslideshow_parse_category($output, $products, $block);
        break;
        case 'newest':
        case 'recent_products':
        case 'popularity':
        case 'bestsellers':
        case 'rating':
        case 'manually':
        case 'banners':
            //NOTE: to prevent the re-processing block(e.g. banner block)
            if(isset($GLOBALS['magictoolbox']['processed_blocks'][$block_id])) {
                break;
            } else {
                $GLOBALS['magictoolbox']['processed_blocks'][$block_id] = $block;
            }
            $products = $ajax ? array($view->get_template_vars('product')) : $view->get_template_vars('items');
            if($products) {
                $output = fn_magicslideshow_parse_category($output, $products, $block);
            }
        break;
        default:
    }
    return $output;
}

function fn_magicslideshow_get_product_details_layout_post($result, $product_id) {
    //NOTE: to identify the main product template
    define('MAGICSLIDESHOW_GET_PRODUCT_DETAILS_LAYOUT_POST_HOOK', true);
}

function fn_magicslideshow_dispatch_assign_template() {
    //NOTE: for register output filter on '404' (etc.) pages
    if(isset($_REQUEST['sef_rewrite'])) {
        $view = & Registry::get('view');
        $view->register_outputfilter('fn_magicslideshow');
    }
}

function fn_magicslideshow_load($block = false) {
    if(!isset($GLOBALS['magictoolbox']['magicslideshow'])) {
        require_once(dirname(__FILE__).'/core/magicslideshow.module.core.class.php');
        $GLOBALS['magictoolbox']['magicslideshow'] = new MagicSlideshowModuleCoreClass();
        $tool = &$GLOBALS['magictoolbox']['magicslideshow'];

        $params = Registry::get('addons.magicslideshow');

        $enabledOptions = db_get_hash_single_array('SELECT block, value FROM ?:addon_magicslideshow_options WHERE name = \'enabled_options\'', array('block', 'value'));

        foreach($params as $p_name => $p_value) {
            $param_value = '';
            if(strpos($p_value, $p_name.'-') === 0) {
                $param_value = substr($p_value, strlen($p_name)+1);
            } else {
                $param_value = $p_value;
            }
            if(strpos($p_name, 'general-') === 0) {
                $tool->params->setValue(substr($p_name, 8), $param_value);
            } else {
                $pattern = '/(product|category|search|newest|recent_products|popularity|bestsellers|rating|manually|banners)-(.*)/is';
                $matches = array();
                if(preg_match($pattern, $p_name, $matches)) {
                    if(strpos($enabledOptions[$matches[1]], '|'.$matches[2].'|') !== false
                      ) {
                        $tool->params->setValue($matches[2], $param_value, $matches[1]);
                    }
                }
            }
        }
    } else {
        $tool = &$GLOBALS['magictoolbox']['magicslideshow'];
    }
    return $tool;
}

function fn_magicslideshow_headers($contents, $simplifiedMode = false) {
    $tool = fn_magicslideshow_load();
    $tool->params->resetProfile();
    $http_path = Registry::get('config.http_path');
    $headers = '';
    $headers .= $tool->getHeadersTemplate($http_path.'/addons/magicslideshow/core');
    if(!defined('MAGICTOOLBOX_FUNC_JS_INCLUDED')) {
        $headers .= '<script type="text/javascript" src="'.$http_path.'/addons/magicslideshow/func.js"></script>'."\r\n";
        define('MAGICTOOLBOX_FUNC_JS_INCLUDED', true);
    }


    if($simplifiedMode) {
        return $contents."\r\n".$headers;
    }

    $contents = preg_replace('#</head>#is', $headers.'</head>', $contents, 1);

    //$quickView = $tool->params->checkValue('mode', array('quick_view', 'options'));
    //NOTICE: we need headers for quick view
    //if(in_array($_REQUEST['dispatch'], array('categories.view', 'products.search', 'index.index'))) return $contents;

    if(defined('MAGICTOOLBOX_JS_FILES_SUBSTITUTION')) {
        return $contents;
    }
    define('MAGICTOOLBOX_JS_FILES_SUBSTITUTION', true);
    //absolute path
    $module_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ADDONS.'/magicslideshow');

    $jsFiles = array('/ajax', '/core');

    //to prevent page break as a result not property install
    foreach($jsFiles as $key => $fileName) {
        if(!file_exists($module_directory.$fileName.'.js')) {
            unset($jsFiles[$key]);
        }
    }

    if(!empty($jsFiles)) {
        if(Registry::get('config.tweaks.js_compression')) {
            //$dir_cache = substr(DIR_CACHE, strlen(DIR_ROOT));
            $js_path = Registry::get('config.cache_path') . '/js';
            $suffix = '_packed';
            foreach($jsFiles as $fileName) {
                if(!is_file($module_directory.$fileName.$suffix.'.js') && is_writeable($module_directory)) {
                    if(!class_exists('JavaScriptPacker')) include_once(DIR_LIB.'packer/class.JavaScriptPacker.php');
                    $packer = new JavaScriptPacker(fn_get_contents($module_directory.$fileName.'.js'));
                    fn_put_contents($module_directory.$fileName.$suffix.'.js', $packer->pack());
                }
            }
        } else {
            $js_path = Registry::get('config.current_path') . '/js';
            $suffix = '';
        }

        //relative to the site root
        $module_path = Registry::get('config.current_path').substr(DIR_ADDONS, strlen(DIR_ROOT)).'magicslideshow';

        foreach($jsFiles as $fileName) {
            $pattern = preg_quote($js_path.$fileName.'.js', '/');
            $contents = preg_replace('/'.$pattern.'/is', $module_path.$fileName.$suffix.'.js', $contents);
        }
    }

    return $contents;
}

function fn_magicslideshow_parse_category($contents, $products, $block) {
    $tool = fn_magicslideshow_load();
    $tool->params->setProfile($block);
    switch($block) {
        case 'product':
            //if we don't have a thumbnail or detailed
            if(!isset($products[0]['main_pair']['icon']) && !isset($products[0]['main_pair']['detailed'])) {
                break;
            }

            $images_data = array();
            $image_path = false;

            $old_locale = setlocale(LC_ALL, NULL);
            setlocale(LC_ALL, 'en_US.UTF8');

            if(!$products[0]['main_pair']['detailed']) {
                $products[0]['main_pair']['detailed'] = fn_get_image($products[0]['main_pair']['detailed_id'], 'detailed');
            }
            if(is_array($products[0]['main_pair']['detailed']) && $products[0]['main_pair']['detailed']) {
                $image_path = $products[0]['main_pair']['detailed']['image_path'];
                $image_id = intval($products[0]['main_pair']['pair_id']);
                $images_data[$image_id]['title'] = $products[0]['product'];
                $images_data[$image_id]['alt'] = $products[0]['main_pair']['detailed']['alt'];
                $images_data[$image_id]['img'] = fn_magicslideshow_create_thumb($image_path, 'thumb', $tool, $products[0]['product_id']);
                $images_data[$image_id]['thumb'] = fn_magicslideshow_create_thumb($image_path, 'selector', $tool, $products[0]['product_id']);
                $images_data[$image_id]['fullscreen'] = fn_magicslideshow_create_thumb($image_path, 'original', $tool, $products[0]['product_id']);
            } else if($products[0]['main_pair']['image_id']) {
                $image_path = $products[0]['main_pair']['icon']['image_path'];
                $image_id = intval($products[0]['main_pair']['pair_id']);
                $images_data[$image_id]['title'] = $products[0]['product'];
                $images_data[$image_id]['alt'] = $products[0]['main_pair']['icon']['alt'];
                $images_data[$image_id]['img'] = fn_magicslideshow_create_thumb($image_path, 'thumb', $tool, $products[0]['product_id']);
                $images_data[$image_id]['thumb'] = fn_magicslideshow_create_thumb($image_path, 'selector', $tool, $products[0]['product_id']);
                $images_data[$image_id]['fullscreen'] = fn_magicslideshow_create_thumb($image_path, 'original', $tool, $products[0]['product_id']);
            }
            if($products[0]['image_pairs'] && count($products[0]['image_pairs']) > 0) {
                foreach($products[0]['image_pairs'] as $image_pair) {
                    if(!$image_pair['detailed']) {
                        $image_pair['detailed'] = fn_get_image($image_pair['detailed_id'], 'detailed');
                    }
                    if(is_array($image_pair['detailed']) && $image_pair['detailed']) {
                        $image_id = intval($image_pair['pair_id']);
                        $images_data[$image_id]['title'] = $products[0]['product'];
                        $images_data[$image_id]['alt'] = $image_pair['detailed']['alt'];
                        $images_data[$image_id]['img'] = fn_magicslideshow_create_thumb($image_pair['detailed']['image_path'], 'thumb', $tool, $products[0]['product_id']);
                        $images_data[$image_id]['thumb'] = fn_magicslideshow_create_thumb($image_pair['detailed']['image_path'], 'selector', $tool, $products[0]['product_id']);
                        $images_data[$image_id]['fullscreen'] = fn_magicslideshow_create_thumb($image_pair['detailed']['image_path'], 'original', $tool, $products[0]['product_id']);
                    } else if($image_pair['image_id']) {
                        $image_id = intval($image_pair['pair_id']);
                        $images_data[$image_id]['title'] = $products[0]['product'];
                        $images_data[$image_id]['alt'] = $image_pair['icon']['alt'];
                        $images_data[$image_id]['img'] = fn_magicslideshow_create_thumb($image_pair['icon']['image_path'], 'thumb', $tool, $products[0]['product_id']);
                        $images_data[$image_id]['thumb'] = fn_magicslideshow_create_thumb($image_pair['icon']['image_path'], 'selector', $tool, $products[0]['product_id']);
                        $images_data[$image_id]['thumb'] = fn_magicslideshow_create_thumb($image_pair['icon']['image_path'], 'selector', $tool, $products[0]['product_id']);
                        $images_data[$image_id]['fullscreen'] = fn_magicslideshow_create_thumb($image_pair['icon']['image_path'], 'original', $tool, $products[0]['product_id']);
                    }
                }
            }
            if(count($images_data) > 1 ) {
                $container_width = 320;
                $first_image = reset($images_data);
                if($tool->params->checkValue('thumb-max-width', 0)) {
                   $image_path_full = str_replace(Registry::get('config.current_path'), $first_image['img'], DIR_ROOT);
                   $first_image_size = getimagesize($image_path_full);
                   $container_width = $first_image_size[0];
                } else {
                   $container_width = (int)$tool->params->getValue('thumb-max-width');
                }
                if($tool->params->checkValue('selectors', array('right', 'left'))) {
                    if($tool->params->checkValue('selector-max-width', 0)) {
                        $image_path_full = str_replace(Registry::get('config.current_path'), $first_image['thumb'], DIR_ROOT);
                        $first_image_size = getimagesize($image_path_full);
                        $container_width += $first_image_size[0];
                    } else {
                        $container_width += (int)$tool->params->getValue('selector-max-width');
                    }
                }

                $toolHTML = $tool->getMainTemplate($images_data, array("id" => "MagicSlideshowImage".$block.$products[0]['product_id']));

                //NOTE: need to set min-width because of [parent container].float-left
                $toolHTML = '<div class="MagicToolboxContainer" style="min-width:'.$container_width.'px;">'.$toolHTML.'</div>';

                $jcarousel = Registry::get('settings.Appearance.thumbnails_gallery') == 'Y';
                $additional_thumbnails_pattern = '<'.($jcarousel?'ul':'div').'[^>]+?class="[^"]*?(?:cm-)?product-thumbnails[^"]*"[^>]*>[^<]*(?:'.
                    ($jcarousel?'<li[^>]*>':'').
                    '<a[^>]+?class="[^"]*?cm-thumbnails-mini[^"]*"[^>]*>[^<]*'.
                    '<img[^>]*>[^<]*'.
                    '<\/a>[^<]*'.
                    ($jcarousel?'<\/li>':'').
                    ')+<\/'.($jcarousel?'ul':'div').'>';
                $contents = preg_replace('/'.$additional_thumbnails_pattern.'/is', '', $contents);

                $image_pattern = '(?:<span[^>]+?class="[^"]*?larger-image-wrap[^"]*"[^>]*>[^<]*'.
                    '<a[^>]+?class="[^"]*?view-larger-image[^"]*"[^>]*>[^<]*'.
                    '<\/a>[^<]*'.
                    '<\/span>[^<]*)?'.
                    '(?:<a[^>]+?id="det_img_link_[^"]*"[^>]*>[^<]*)?'.
                    '<img[^>]+?id="det_img_'.$products[0]['product_id'].'[^"]*"[^>]*>[^<]*'.
                    '(?:<\/a>[^<]*)?';
                $contents = preg_replace('/(?:'.$image_pattern.')+/is', $toolHTML, $contents, 1);//NOTE: $limit = 1 to prevent the replacement of product in product tabs(product id == block id)
                //$tool->params->setValue('headers', 'Yes', $tool->params->generalProfile);

            }
            setlocale(LC_ALL, $old_locale);
            break;
        case 'newest':
        case 'recent_products':
        case 'popularity':
        case 'bestsellers':
        case 'rating':
        case 'manually':
            if(count($products) < 2 ) break;
            $images_data = array();

            $old_locale = setlocale(LC_ALL, NULL);
            setlocale(LC_ALL, 'en_US.UTF8');

            $useLink = $tool->params->checkValue('link-to-product-page', 'Yes');

            foreach($products as $product) {
                if($product['main_pair']) {//if we have a thumbnail or detailed
                    if($useLink && ($product['product_id'] != $_REQUEST['product_id'])) {
                        $link = $tool->params->getValue('index-script').'?dispatch=products.view&product_id='.$product['product_id'];
                        if(function_exists('fn_seo_url')) {
                            $link = fn_seo_url($link, AREA, '&amp;', 'products.view&product_id='.$product['product_id']);
                        }
                    } else {
                        $link = false;
                    }
                    if(!$product['main_pair']['detailed_id']) {
                        $product['main_pair']['detailed'] = fn_get_image($product['main_pair']['detailed_id'], 'detailed');
                    }
                    if(is_array($product['main_pair']['detailed'])) {
                        $image_id = intval($product['main_pair']['pair_id']);
                        $images_data[$image_id]['title'] = $product['product'];
                        $images_data[$image_id]['link'] = $link;
                        $images_data[$image_id]['img'] = fn_magicslideshow_create_thumb($product['main_pair']['detailed']['image_path'], 'thumb', $tool, $product['product_id']);
                        $images_data[$image_id]['thumb'] = fn_magicslideshow_create_thumb($product['main_pair']['detailed']['image_path'], 'selector', $tool, $product['product_id']);
                        $images_data[$image_id]['fullscreen'] = fn_magicslideshow_create_thumb($product['main_pair']['detailed']['image_path'], 'original', $tool, $product['product_id']);
                    } elseif($product['main_pair']['image_id']) {
                        $image_id = intval($product['main_pair']['pair_id']);
                        $images_data[$image_id]['title'] = $product['product'];
                        $images_data[$image_id]['link'] = $link;
                        $images_data[$image_id]['img'] = fn_magicslideshow_create_thumb($product['main_pair']['icon']['image_path'], 'thumb', $tool, $product['product_id']);
                        $images_data[$image_id]['thumb'] = fn_magicslideshow_create_thumb($product['main_pair']['icon']['image_path'], 'selector', $tool, $product['product_id']);
                        $images_data[$image_id]['fullscreen'] = fn_magicslideshow_create_thumb($product['main_pair']['icon']['image_path'], 'original', $tool, $product['product_id']);
                    }

                }
            }

            setlocale(LC_ALL, $old_locale);

            if(count($images_data) > 1 ) {
                $toolHTML = $tool->getMainTemplate($images_data, array("id" => $block."MagicSlideshow"));
                //$toolHTML = '<div class="MagicToolboxContainer" style="margin: 0 auto;">'.$toolHTML.'</div>';
                $toolHTML = '<div class="MagicToolboxContainer">'.$toolHTML.'</div>';

                //for 'products_scroller.tpl'
                $scroller_pattern = '<ul[^>]*?class="[^"]*?jcarousel-skin[^"]*"[^>]*>.*?<\/ul>';
                $scroller_pattern = '<div[^>]*>[^<]*'.$scroller_pattern.'[^<]*<\/div>|'.$scroller_pattern;
                //for 'links_thumb.tpl' and 'products_list.tpl'
                $pattern = '(?:<div[^>]*?class="[^"]*?(?:product-item-image|product-container)[^"]*"[^>]*>[^<]*'.
                    '<form[^>]*>.*?<\/form>[^<]*'.
                    '<\/div>[^<]*(?:<hr[^>]*>[^<]*)?)+';

                $matches = array();
                if(preg_match('/'.$scroller_pattern.'/is', $contents, $matches)) {
                    $contents = str_replace($matches[0], $toolHTML, $contents);
                    //$tool->params->setValue('headers', 'Yes', $tool->params->generalProfile);
                } else if(preg_match('/'.$pattern.'/is', $contents, $matches)) {
                    $contents = str_replace($matches[0], $toolHTML, $contents);
                    //$tool->params->setValue('headers', 'Yes', $tool->params->generalProfile);
                }
            }
            break;
        case 'banners':
            if(count($products) < 2 ) break;
            $images_data = array();
            $statistics_status = db_get_field("SELECT status FROM ?:addons WHERE addon = ?s", 'statistics');

            $old_locale = setlocale(LC_ALL, NULL);
            setlocale(LC_ALL, 'en_US.UTF8');

            $useLink = $tool->params->checkValue('link-to-product-page', 'Yes');

            foreach($products as $banner) {
                if($banner['main_pair']) {//if we have a thumbnail or detailed
                    if($useLink && !empty($banner['url']) ) {
                        if($statistics_status == 'A') {
                            $link = $tool->params->getValue('index-script').'?dispatch=statistics.banners&banner_id='.$banner['banner_id'];
                        } else {
                            $link = $banner['url'];
                        }
                    } else {
                        $link = false;
                    }
                    if($banner['main_pair']['image_id']) {
                        $image_id = intval($banner['main_pair']['pair_id']);
                        $images_data[$image_id]['title'] = $banner['banner'];
                        $images_data[$image_id]['description'] = $banner['main_pair']['icon']['alt'];
                        $images_data[$image_id]['link'] = $link;
                        $images_data[$image_id]['target'] = ($banner['target'] == "B")?"_blank":"";
                        $images_data[$image_id]['img'] = fn_magicslideshow_create_thumb($banner['main_pair']['icon']['image_path'], 'thumb', $tool, 'banners');
                        $images_data[$image_id]['thumb'] = fn_magicslideshow_create_thumb($banner['main_pair']['icon']['image_path'], 'selector', $tool, 'banners');
                        $images_data[$image_id]['fullscreen'] = fn_magicslideshow_create_thumb($banner['main_pair']['icon']['image_path'], 'original', $tool, 'banners');
                    }
                }
            }

            setlocale(LC_ALL, $old_locale);

            if(count($images_data) > 1 ) {
                $toolHTML = $tool->getMainTemplate($images_data, array("id" => $block."MagicSlideshow"));
                //$toolHTML = '<div class="MagicToolboxContainer" style="margin: auto;">'.$toolHTML.'</div>';
                $toolHTML = '<div class="MagicToolboxContainer">'.$toolHTML.'</div>';
                //for 'original.tpl'
                $original_template_pattern = '(?:<div[^>]*?class="[^"]*?ad-container[^"]*"[^>]*>[^<]*'.
                    '(?:<a[^>]*>[^<]*)?'.
                    '<img[^>]*>[^<]*'.
                    '(?:<\/a>[^<]*)?'.
                    '<\/div>[^<]*)+';
                //for 'carousel.tpl'
                $carousel_template_pattern = '<div[^>]*?class="[^"]*?cm-slider[^"]*"[^>]*>[^<]*'.
                    '<div[^>]*?class="[^"]*?cm-slider-window[^"]*"[^>]*>[^<]*'.
                    '<div[^>]*?class="[^"]*?cm-slide-page-reel[^"]*"[^>]*>[^<]*'.
                    '(?:<div[^>]*?class="[^"]*?cm-slide-page[^"]*"[^>]*>[^<]*'.
                    '(?:<a[^>]*>[^<]*)?'.
                    '<img[^>]*>[^<]*'.
                    '(?:<\/a>[^<]*)?'.
                    '<\/div>[^<]*)+'.
                    '<\/div>[^<]*'.
                    '<\/div>[^<]*'.
                    '<div[^>]*?class="[^"]*?cm-paging[^"]*"[^>]*>[^<]*'.
                    '(?:<a[^>]*>[^<]*<\/a>[^<]*)+'.
                    '<\/div>[^<]*'.
                    '<\/div>';
                $matches = array();
                if(preg_match('/'.$original_template_pattern.'/is', $contents, $matches)) {
                    $contents = str_replace($matches[0], $toolHTML, $contents);
                    //$tool->params->setValue('headers', 'Yes', $tool->params->generalProfile);
                } else if(preg_match('/'.$carousel_template_pattern.'/is', $contents, $matches)) {
                    $contents = str_replace($matches[0], $toolHTML, $contents);
                    //$tool->params->setValue('headers', 'Yes', $tool->params->generalProfile);
                }
            }
            break;
    }
    return $contents;
}

function fn_magicslideshow_create_thumb($src, $size, &$tool, $pid) {

    static $imageDir = '';
    static $imagesPathQuoted = '';
    static $imagehelper = null;

    if($imagehelper === null) {
        $imagesPathQuoted = preg_quote(Registry::get('config.images_path'), '/');
        $imageDir = str_replace(DIR_ROOT, '', DIR_IMAGES);
        //$config['images_path'] = $config['current_path'] . '/images/';
        require_once(dirname(__FILE__).'/core/magictoolbox.imagehelper.class.php');
        $imagehelper = new MagicToolboxImageHelperClass(DIR_ROOT, $imageDir.'magictoolbox_cache', $tool->params, null, Registry::get('config.http_path'));
    }

    $src = htmlspecialchars_decode($src, ENT_QUOTES);

    //preg_match('/^(.*?(product|detailed|banner|promo|magic360)\/(.*?\/)?)([^\/]*?)\.([^\.]*)$/is', $src, $matches);
    //if(empty($matches)) return $src;
    //list(, $path, $iType, $subDir, $name, $ext) = $matches;
    //if(empty($iType)) { $iType = 'product'; $subDir = '';}
    //if($subDir == $path) $subDir = '';
    //$img = $imageDir.$iType.'/'.$subDir.$name.'.'.$ext;

    preg_match('/^.*?'.$imagesPathQuoted.'(.*?)$/is', $src, $matches);
    if(empty($matches)) return $src;
    $img = $imageDir.$matches[1];

    $thumb = $imagehelper->create($img, $size, $pid);
    //NOTE: spike to get real size of image
    $GLOBALS['magictoolbox']['file_path'] = $imagehelper->file;
    if(MT_DS != '/') {
        $thumb = str_replace(MT_DS, '/', $thumb);
    }

    return $thumb;
}

function fn_magicslideshow_js_functions() {

    if(Registry::get("addons.magicslideshow.status") === 'D') {
        $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic Slideshow module should be enabled for proper operation of the settings page." .
                   "<br/>Please enable it before save settings.</span>";
        fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('warning').'</span>', $message, true, 'magicslideshow_module_disabled_notification');
    }

    //$modulePath = Registry::get('config.current_path').substr(DIR_ADDONS, strlen(DIR_ROOT)).'magicslideshow';
    return '
        <script type="text/javascript">
            //<![CDATA[
            function fn_magicslideshow_prepare_custom_options(block, skip) {
                skip = (skip || \'\').split(\'|\');
                skip.push(\'enable-effect\');
                var enabledOptionsID = "#addon_option_magicslideshow_" + block + "-enabled-options";
                var enabledOptions = $(enabledOptionsID).val();
                var sectionID = "#content_magicslideshow_magicslideshow_" + block;
                $(sectionID + " div.form-field").
                 each(function(){
                        $(this).
                         find("select, input[type=\'text\']").
                         each(function(){
                                var optionId = this.id.replace("addon_option_magicslideshow_" + block + "-","");
                                if(jQuery.inArray(optionId, skip) !== -1) {
                                    return;
                                }
                                if(enabledOptions.indexOf("|" + optionId + "|") == -1) {
                                    $(this).attr("disabled", true).after("&nbsp;&nbsp;<a href=\"#\" >edit</a>");
                                } else {
                                    $(this).after("&nbsp;&nbsp;<a href=\"#\" >use default option</a>");
                                }
                                $(this).next().
                                    bind("click", {optionId: optionId, enabledOptionsID: enabledOptionsID},
                                                    function(event) {
                                                        var enabledOptions = $(event.data.enabledOptionsID).val();
                                                        if($(this).html() == "edit") {
                                                            $(this).html("use default option").prev().removeAttr("disabled");
                                                            enabledOptions = enabledOptions.concat(event.data.optionId + "|");
                                                        } else {
                                                            $(this).html("edit").prev().attr("disabled", true).val($("#addon_option_magicslideshow_general-" + event.data.optionId).val().replace("general-", block + "-"));
                                                            var pattern = new RegExp("\\\\|" + event.data.optionId + "\\\\|", "g");
                                                            enabledOptions = enabledOptions.replace(pattern, "|");
                                                        }
                                                        $(event.data.enabledOptionsID).val(enabledOptions);
                                                        return false;
                                                }
                                        );

                              }).
                         end().
                         find("input[type=\'radio\']:checked").
                         each(function(){
                                var optionId = this.parentNode.id.replace("addon_option_magicslideshow_" + block + "-","");
                                if(jQuery.inArray(optionId, skip) !== -1) {
                                    return;
                                }
                                if(enabledOptions.indexOf("|" + optionId + "|") == -1) {
                                    $(this.parentNode).find("input").attr("disabled", true).end().
                                     find(":last-child").after("&nbsp;&nbsp;<a href=\"#\" >edit</a>");
                                } else {
                                    $(this.parentNode).find(":last-child").after("&nbsp;&nbsp;<a href=\"#\" >use default option</a>");
                                }
                                $(this.parentNode).find(":last-child").
                                    bind("click", {optionId: optionId, enabledOptionsID: enabledOptionsID},
                                                    function(event) {
                                                        var enabledOptions = $(event.data.enabledOptionsID).val();
                                                        if($(this).html() == "edit") {
                                                            $(this).html("use default option");
                                                            $(this.parentNode).find("input").removeAttr("disabled");
                                                            enabledOptions = enabledOptions.concat(event.data.optionId + "|");
                                                        } else {
                                                            $(this).html("edit");
                                                            $(this.parentNode).find("input").attr("disabled", true).val([$("#addon_option_magicslideshow_general-" + optionId + " input:checked").val().replace("general", block)]);
                                                            var pattern = new RegExp("\\\\|" + event.data.optionId + "\\\\|", "g");
                                                            enabledOptions = enabledOptions.replace(pattern, "|");
                                                        }
                                                        $(event.data.enabledOptionsID).val(enabledOptions);
                                                        return false;
                                                }
                                        );

                              });
                      });
            }
            function fn_magicslideshow_clear_cache_field(data, params) {
                if(data.html) {
                    for (var k in data.html) {
                        $("#addon_option_magicslideshow_cache-total-items").val(data.html[k]);
                        $("#addon_option_magicslideshow_cache-unused-items").val("0 (0 bytes)");
                        break;
                    }
                }
            }
            //]]>
        </script>
';

}

function fn_magicslideshow_prepare_custom_options($block) {

    static $addonOptions;
    static $enabledOptions;
    $headersBind = '';
    $generalParamsChangeBind = '';
    $includeOptionsJs = '';
    $initOptionsValidation = '';
    $magicscrollIcon = '';
    $blocks = array('product',
                    'newest', 'recent_products', 'popularity', 'bestsellers', 'rating', 'manually',
                    'banners',
                   );

    if(!isset($addonOptions)) {
        $section = CSettings::instance()->get_section_by_name($_REQUEST['addon'], CSettings::ADDON_SECTION);
        $addonOptions = db_get_hash_single_array('SELECT name, value FROM ?:settings_objects WHERE section_id = \'?p\' AND type != \'H\'', array('name', 'value'), $section['section_id']);
        $enabledOptions = db_get_hash_single_array('SELECT block, value FROM ?:addon_magicslideshow_options WHERE name = \'enabled_options\'', array('block', 'value'));
    }

    switch($block) {
        case 'general':
            if(isset($addonOptions['cache-path-to-cache'])) {
                $pathToCache = $addonOptions['cache-path-to-cache'];
            } else {
                $pathToCache = str_replace(DIR_ROOT, '', DIR_IMAGES).'magictoolbox_cache';
            }
            $tool = fn_magicslideshow_load();
            require_once(dirname(__FILE__).'/core/magictoolbox.imagehelper.class.php');
            $imagehelper = new MagicToolboxImageHelperClass(DIR_ROOT, $pathToCache, $tool->params);
            $usedSubCache = $imagehelper->getOptionsHash();
            $cacheInfo = fn_magicslideshow_getCacheInfo(DIR_ROOT.$pathToCache, $usedSubCache);
            return  '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magicslideshow_cache-path-to-cache">Path to cache folder'.
                    '(<a onclick="return false;" class="cm-tooltip" title="Relative for site base path.">?</a>)<span class="hidden cm-tooltip-text"></span>'.
                    '</label>'.
                    '<input type="text" name="addon_data[options][cache-path-to-cache]" id="addon_option_magicslideshow_cache-path-to-cache" value="'.$pathToCache.'" class="input-text" style="width:352px;" disabled="disabled" />'.
                    '</div>'.
                    '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magicslideshow_cache-total-items">Total items:</label>'.
                    '<input type="text" name="addon_data[options][cache-total-items]" id="addon_option_magicslideshow_cache-total-items" value="'.$cacheInfo['totalCount'].' ('.fn_magicslideshow_format_size($cacheInfo['totalSize']).')" class="input-text" disabled="disabled" />'.
                    '</div>'.
                    '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magicslideshow_cache-unused-items">Unused items:</label>'.
                    '<input type="text" name="addon_data[options][cache-unused-items]" id="addon_option_magicslideshow_cache-unused-items" value="'.$cacheInfo['unusedCount'].' ('.fn_magicslideshow_format_size($cacheInfo['unusedSize']).')" class="input-text" disabled="disabled" />'.
                    '</div>'.
                    '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magicslideshow_cache-what-clear">Empty cache:</label>'.
                    '<select id="addon_option_magicslideshow_cache-what-clear" onchange="$(\'#magicslideshow_clear_cache_field\').attr(\'href\', \''.INDEX_SCRIPT.'?dispatch=magicslideshow_cache.\'+this.value).attr(\'rev\', this.value);">'.
                    '<option  selected="selected" value="clear_unused_items">Delete unused items</option>'.
                    '<option value="clear_all_items">Delete all items</option>'.
                    '</select>'.
                    '&nbsp;<a name="magicslideshow_clear_cache_field" id="magicslideshow_clear_cache_field" href="'.INDEX_SCRIPT.'?dispatch=magicslideshow_cache.clear_unused_items" class="cm-ajax cm-confirm" rev="clear_unused_items" >Clear</a>'.
                    '</div>'
                    ;
            break;
        case 'banners':
            //only after last block
            $blocks  = '"'.implode('", "', $blocks).'"';
            $headersBind = '$("#tabs_content_magicslideshow h2.subheader").css({\'background-color\': \'#F4F4F4\', \'cursor\': \'pointer\'}).slice(0, 1).prepend("&nbsp;<img alt=\"\" src=\"./skins/basic/admin/images/icons/advanced_search_expanded.gif\">").end().slice(1).prepend("&nbsp;<img alt=\"\" src=\"./skins/basic/admin/images/icons/advanced_search_collapsed.gif\">").end().bind("click", function(){$(this).find("img").each(function(){if(this.src.indexOf("advanced_search_collapsed") == -1) this.src = this.src.replace("advanced_search_expanded", "advanced_search_collapsed"); else this.src = this.src.replace("advanced_search_collapsed", "advanced_search_expanded");}).end().nextAll().each(function slideToggleNode(){if(typeof slideToggleNode.stop == "undefined" ) {if(this.tagName=="H2") slideToggleNode.stop = true; else $(this).slideToggle(250);}}); return false;}).slice(1, 2).nextAll("div.form-field").css("display", "none");$("#tabs_content_magicslideshow div").slice(1).find("h2.subheader:first").nextAll("div.form-field").css("display", "none");';
            $generalParamsChangeBind = '
$("#content_magicslideshow_magicslideshow_general").find("input[type=\'text\']").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.id.replace("addon_option_magicslideshow_general-","");
var optioVal = $(this).val();
for(block in block_array) {
    $("#content_magicslideshow_magicslideshow_" + block_array[block]).
    find("#addon_option_magicslideshow_" + block_array[block] + "-" + optionId + ":disabled").val(optioVal);
}
}).
end().find("select").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.id.replace("addon_option_magicslideshow_general-","");
var optioVal = $(this).val().replace("general-" + optionId + "-", "");
for(block in block_array) {
    $("#content_magicslideshow_magicslideshow_" + block_array[block]).
    find("#addon_option_magicslideshow_" + block_array[block] + "-" + optionId + ":disabled").val(block_array[block] + "-" + optionId + "-" + optioVal);
}
}).
end().find("input[type=\'radio\']").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.parentNode.id.replace("addon_option_magicslideshow_general-","");
var optioVal = $(this).val().replace("general-" + optionId + "-", "");
for(block in block_array) {
    $("#content_magicslideshow_magicslideshow_" + block_array[block]).
    find("#addon_option_magicslideshow_" + block_array[block] + "-" + optionId + " input:disabled").val([block_array[block] + "-" + optionId + "-" + optioVal]);
}
});';
        default:
    }

    $tool = fn_magicslideshow_load();
    $skip = array();

    if($tool->type == 'standard') {
        foreach($tool->params->getParams() as $param) {
            if(in_array($param['group'], array('General', 'Scroll', 'Scroll Arrows', 'Scroll Slider', 'Scroll effect', 'Multiple images'))) {
                $skip[] = $param['id'];
            }
        }
    }

    $skip = implode('|', $skip);
    return $includeOptionsJs.'
        <input type="hidden" name="addon_data[options]['.$block.'-enabled-options]" id="addon_option_magicslideshow_'.$block.'-enabled-options" value="'.$enabledOptions[$block].'" />
        <script type="text/javascript">
            //<![CDATA[
            fn_magicslideshow_prepare_custom_options("'.$block.'", \''.$skip.'\');
            '.$headersBind.$generalParamsChangeBind.$initOptionsValidation.$magicscrollIcon.'
            //]]>
        </script>
    ';
}

function fn_magicslideshow_getCacheInfo($path, $usedSubCache = null) {

    $totalSize = 0;
    $totalCount = 0;
    $usedSize = 0;
    $usedCount = 0;
    if (is_dir($path))
    if ($handle = opendir($path)) {
        while (false !== ($file = readdir($handle))) {
            $next = $path.DIRECTORY_SEPARATOR.$file;
            if ($file != '.' && $file != '..' && !is_link($next)) {
                if (is_dir($next)) {
                    $result = fn_magicslideshow_getCacheInfo($next);
                    if($file == $usedSubCache) {
                        $usedSize += $result['totalSize'];
                        $usedCount += $result['totalCount'];
                    }
                    $totalSize += $result['totalSize'];
                    $totalCount += $result['totalCount'];
                } elseif (is_file($next)) {
                    $totalSize += filesize($next);
                    $totalCount++;
                }
            }
        }
        closedir($handle);
    }
    return array('totalSize' => $totalSize, 'totalCount' => $totalCount, 'unusedSize' => $totalSize-$usedSize, 'unusedCount' => $totalCount-$usedCount);
}

function fn_magicslideshow_format_size($size) {
    $units = array(' bytes', ' KB', ' MB', ' GB', ' TB');
    for ($i = 0; $size >= 1024 && $i < 4; $i++) $size /= 1024;
    return round($size, 2).$units[$i];
}

function fn_magicslideshow_install() {

    $js_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ROOT.'/js');
    $module_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ADDONS.'/magicslideshow');
    $jsFiles = array('/ajax', '/core');
    $suffix = '_packed';
    $cancel = false;

    if(!defined('PRODUCT_VERSION') || version_compare(PRODUCT_VERSION, '3.0.0', '<')) {
        if(!fn_notification_exists('E', 'magicslideshow_module_version_notification')) {
            $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">This Magic Slideshow module is intended only for CS Cart Version 3 and above.".
                       "<br/>Your version of CS Cart is ".PRODUCT_VERSION."</span>";
            fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magicslideshow_module_version_notification');
        }
    }

    if(!class_exists('JavaScriptPacker'))
        include_once(DIR_LIB.'packer/class.JavaScriptPacker.php');

    foreach($jsFiles as $fileName) {
        if(@is_file($module_directory.$fileName.'.js')) {
           //installed
        } else {
            if(@is_file($js_directory.$fileName.'.js') && is_writeable($module_directory)) {
                switch($fileName) {
                    case '/ajax':
                        // modify ajax.js
                        $c = file_get_contents($js_directory.$fileName.'.js');
                        $stop = '
        if(params && params.result_ids) {
            if((params.result_ids.search(/(?:product_images_|list_image_update_|product_quick_view_)\d+(?:_update)?|product_filters_\*/i) != -1) || (params.result_ids == \'pagination_contents\')) {
                var productIdMatch = params.result_ids.match(/.*?(?:product_images_|list_image_update_|product_quick_view_)([0-9]+)(?:_update)?.*/i);
                if(productIdMatch) {
                    fn_magictoolbox_tool_update("stop", "product", productIdMatch[1]);
                } else {
                    fn_magictoolbox_tool_update("stop", "category", "");
                }
            }
        }';
                        $start = '
        if(params && params.result_ids) {
            if((params.result_ids.search(/(?:product_images_|list_image_update_|product_quick_view_)\d+(?:_update)?|product_filters_\*/i) != -1) || (params.result_ids == \'pagination_contents\')) {
                var productIdMatch = params.result_ids.match(/.*?(?:product_images_|list_image_update_|product_quick_view_)([0-9]+)(?:_update)?.*/i);
                if(productIdMatch) {
                    fn_magictoolbox_tool_update("start", "product", productIdMatch[1]);
                } else {
                    fn_magictoolbox_tool_update("start", "category", "");
                }
            }
        }';
                        $c = preg_replace('/(ajaxRequest\: function\(url, params\)\s+?\{)/', '$1'.$stop, $c);
                        $c = preg_replace('/((?:\$|jQuery)\.toggleStatusBox\(\'hide\'\);)/', '$1'.$start, $c);
                        file_put_contents($module_directory.$fileName.'.js', $c);

                        $packer = new JavaScriptPacker(fn_get_contents($module_directory.$fileName.'.js'));
                        fn_put_contents($module_directory.$fileName.$suffix.'.js', $packer->pack());

                        break;
                    case '/core':
                        //modify core.js file
                        $c = file_get_contents($js_directory.$fileName.'.js');

                        $pattern = 'for (var k in data) {';
                        $replace = 'for (var k in data) { if(!data.hasOwnProperty(k)) {continue;}';
                        $c = str_replace($pattern, $replace, $c);

                        //NOTE: change function name since version 3.0.1 RC6
                        $pattern = '/((?:fn_scroller_)?init_callback[^\{]*\{)/i';
                        $replace = "$1\n\t\t\tif(carousel.list.parents('div.MagicToolboxSelectorsContainer').length || carousel.list.find('div.MagicToolboxContainer').length) {".
                        "\n\t\t\t\tcarousel.options.wrap = 'both';\n\t\t\t}";

                        $c = preg_replace($pattern, $replace, $c);

                        file_put_contents($module_directory.$fileName.'.js', $c);

                        $packer = new JavaScriptPacker(fn_get_contents($module_directory.$fileName.'.js'));
                        fn_put_contents($module_directory.$fileName.$suffix.'.js', $packer->pack());

                        break;
                }
            } else {
                //can't install
                $cancel = true;
                if(!is_writeable($module_directory) && !fn_notification_exists('E', 'magicslideshow_module_directory_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic Slideshow needs write access to the folder <b>'".$module_directory."'</b> for proper installation." .
                               "<br/>Please check this and reinstall Magic Slideshow.</span>";
                    fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magicslideshow_module_directory_notification');
                }
                if(!@is_file($js_directory.$fileName.'.js') && !fn_notification_exists('E', 'magicslideshow_file'.$fileName.'_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic Slideshow needs read access to the file <b>'".$js_directory.$fileName.".js'</b> for proper installation." .
                               "<br/>Please check this and reinstall Magic Slideshow.</span>";
                    fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magicslideshow_file'.$fileName.'_notification');
                }
            }
        }
    }

    if(!is_file($module_directory.'/tabs'.$suffix.'.js')) {
        $packer = new JavaScriptPacker(fn_get_contents($module_directory.'/tabs.js'));
        fn_put_contents($module_directory.'/tabs'.$suffix.'.js', $packer->pack());
    }


    //fix url's in css files
    $cancel = fn_magicslideshow_fix_css();


    if($cancel) {
        $args = func_get_args();
        if(!empty($args)) fn_redirect("addons.manage");
    }


    fn_magicslideshow_send_stat('install');

}

function fn_magicslideshow_fix_css() {

    $cancel = false;

    $path = dirname(__FILE__).'/core';

    $resourcesPath = Registry::get('config.current_path').substr(DIR_ADDONS, strlen(DIR_ROOT)).'magicslideshow/core';
    $resourcesPath = str_replace(array("//", "\\"), array("/", "/"), $resourcesPath);

    $list = glob($path.'/*');
    $files = array();
    if(is_array($list)) {
        for($i = 0; $i < count($list); $i++) {
            if(is_dir($list[$i])) {
                if(!in_array(basename($list[$i]), array('.svn', '.git'))) {
                    $add = glob($list[$i].'/*');
                    if(is_array($add)) {
                        $list = array_merge($list, $add);
                    }
                }
            } else if(preg_match('#\.css$#i', $list[$i])) {
                $files[] = $list[$i];
            }
        }
    }

    foreach($files as $file) {
        $cssPath = dirname($file);
        $cssRelPath = str_replace($path, '', $cssPath);
        $toolPath = $resourcesPath.$cssRelPath;
        $pattern = '#url\(\s*(\'|")?(?!data:|mhtml:|http(?:s)?:|/)([^\)\s\'"]+?)(?(1)\1)\s*\)#is';
        $replace = 'url($1'.$toolPath.'/$2$1)';
        $fileContents = file_get_contents($file);
        $fixedFileContents = preg_replace($pattern, $replace, $fileContents);
        if($fixedFileContents != $fileContents) {
            if(is_writeable($file)) {
                file_put_contents($file, $fixedFileContents);
            } else {
                //NOTE: install module anyway
                /*
                $cancel = true;
                if(!fn_notification_exists('E', 'magicslideshow_file_'.md5($file).'_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic Slideshow needs write access to the file <b>'".$file."'</b> for proper installation." .
                                "<br/>Please check this and reinstall Magic Slideshow.</span>";
                    fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magicslideshow_file_'.md5($file).'_notification');
                }
                */
            }
        }
    }

    return $cancel;

}

function fn_magicslideshow_after_install() {
    //NOTE: we need to change position of options in DB, that the content displayed in the right order
    $section = CSettings::instance()->get_section_by_name($_REQUEST['addon'], CSettings::ADDON_SECTION);
    $query = 'UPDATE ?:settings_objects SET ?:settings_objects.position = ?:settings_objects.object_id WHERE ?:settings_objects.section_id = ?s';
    db_query($query , $section['section_id']);
}

function fn_magicslideshow_uninstall() {

    $js_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ROOT.'/js');
    $module_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ADDONS.'/magicslideshow');
    $jsFiles = array('/ajax', '/core');
    $suffix = '_packed';

    foreach($jsFiles as $fileName) {
        if(@is_file($module_directory.$fileName.'.js')) {
            @unlink($module_directory.$fileName.'.js');
        }
        if(@is_file($module_directory.$fileName.$suffix.'.js')) {
            @unlink($module_directory.$fileName.$suffix.'.js');
        }
    }
    if(@is_file($module_directory.'/tabs'.$suffix.'.js')) {
        @unlink($module_directory.'/tabs'.$suffix.'.js');
    }

    fn_magicslideshow_send_stat('uninstall');

}

function fn_magicslideshow_send_stat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v1.4.7' || 'working' == 'v3.2.12') {
        return;
    }

    $hostname = 'www.magictoolbox.com';
    $url = $_SERVER['HTTP_HOST'].preg_replace('/\/[^\/]*?\.php.*$/i', '', $_SERVER['REQUEST_URI']);
    $url = urlencode(urldecode($url));
    $platformVersion = defined('PRODUCT_VERSION') ? PRODUCT_VERSION : '';
    $path = "api/stat/?action={$action}&tool_name=magicslideshow&license=trial&tool_version=v3.2.12&module_version=v1.4.7&platform_name=cscart3&platform_version={$platformVersion}&url={$url}";
    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers  = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }
}
