<?php

if ( !defined('AREA') ) { die('Access denied'); }

define('MT_DS', DIRECTORY_SEPARATOR);

function fn_magic360($output, &$view) {

    $block = '';
    $block_id = '';
    static $ajax = null;
    static $main_product_processed = false;
    static $products_search_processed = false;

    if($ajax === null) {
        $ajax = isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest');
                //&& in_array($_REQUEST['dispatch'], array('products.options', 'categories.view'))
    }

    $search = !$products_search_processed  && isset($view->_tpl_vars['layouts']) && (
              ($view->_tpl_vars['mode'] == 'search' && $view->_tpl_vars['controller'] == 'products') ||
              //NOTE: to support tags page
              ($view->_tpl_vars['controller'] == 'tags' && $view->_tpl_vars['mode'] == 'view')  );

    if($ajax) {
        //check block
        if(isset($view->_tpl_vars['obj_prefix']) && $view->_tpl_vars['obj_prefix'] != 'ajax') {
            if(substr($view->_tpl_vars['obj_prefix'], -3) == '000') {
                $block_id = substr($view->_tpl_vars['obj_prefix'], 0, -3);
                $block_data = Bm_Block::instance()->get_by_id($block_id);
                if(isset($block_data['content']['items']['filling'])) {
                    $block = $block_data['content']['items']['filling'];
                }
            }
        } else if(defined('MAGIC360_GET_PRODUCT_DETAILS_LAYOUT_POST_HOOK') ||
                  in_array($view->_tpl_vars['mode'], array('quick_view', 'options')) && $view->_tpl_vars['controller'] == 'products') {
            $block = 'product';
        }
    } else {
        if(!$main_product_processed && defined('MAGIC360_GET_PRODUCT_DETAILS_LAYOUT_POST_HOOK')) {
            if(isset($view->_tpl_vars['block']['type']) && $view->_tpl_vars['block']['type'] == 'main') {
                //$block_id = $view->_tpl_vars['block']['block_id'];
                $block = 'product';
                $main_product_processed = true;
            }
        } else {
            if(isset($view->_smarty_vars['capture']['magic360_capture']) || $search) {
            } else
            //process template if inclusion depth = 0
            //if($view->_inclusion_depth) return $output;
            //NOTICE: in some cases, this value is set to -1 for some reason, maybe it's a bug
            if($view->_inclusion_depth && $view->_inclusion_depth != -1) return $output;
        }
    }

    if(isset($view->_smarty_vars['capture']['magic360_capture'])) {
        $block = $view->_smarty_vars['capture']['magic360_capture'];
        unset($view->_smarty_vars['capture']['magic360_capture']);
    } else if($search) {
        $block = 'search';
        $products_search_processed = true;
    } else if(isset($view->_tpl_vars['block'],
                   $view->_tpl_vars['block']['content'],
                   $view->_tpl_vars['block']['content']['items'],
                   $view->_tpl_vars['block']['content']['items']['filling'])
             ) {
        $block = $view->_tpl_vars['block']['content']['items']['filling'];
        if($view->_tpl_vars['block']['type'] != 'products') {
            return $output;
        }
        $block_id = $view->_tpl_vars['block']['block_id'];
    }
    if(empty($block)) return $output;

    $blocks = array('product',
                    'head'//footer
                   );

    if($block == 'most_popular') {
        //NOTE: filling changed since v3.0.1 RC 5
        $block = 'popularity';
    } else if(isset($_REQUEST['sef_rewrite']) && $block == 'scripts') {
        //NOTE: for output headers on '404' (etc.) pages
        $simpleHeaders = true;
        $block = 'head';
    }

    if(!in_array($block, $blocks)) return $output;

    $tool = fn_magic360_load();

    if($block == 'head') {
        //NOTE: we need to apply headers always because we don't know whether the effect is applied to the block in the cache.
        //if($tool->params->paramExists('headers', $tool->params->generalProfile) && $tool->params->getValue('headers', $tool->params->generalProfile) == 'Yes') {
        if(isset($simpleHeaders)) {
            return fn_magic360_headers($output, true);
        }
        foreach($tool->params->getProfiles() as $block) {
            if(!$tool->params->checkValue('enable-effect', 'No', $block)) {
                return fn_magic360_headers($output);
            }
        }
        //}
        return $output;
    }

    if($tool->params->checkValue('enable-effect', 'No', $block)) return $output;

    //$tpl_vars = $view->get_template_vars();
    $tool->params->setValue('index-script', $view->get_template_vars('index_script'));
    $tool->params->setValue('block-id', $block_id);
    $tool->params->setValue('mode', $view->get_template_vars('mode'));

    switch($block) {
        case 'product':
            $products = ($block != 'product') ? $view->get_template_vars('products') : array($view->get_template_vars('product'));
            $output = fn_magic360_parse_circle($output, $products, $block);
        break;
        default:
    }
    return $output;
}

function fn_magic360_get_product_details_layout_post($result, $product_id) {
    //NOTE: to identify the main product template
    define('MAGIC360_GET_PRODUCT_DETAILS_LAYOUT_POST_HOOK', true);
}

function fn_magic360_dispatch_assign_template() {
    //NOTE: for register output filter on '404' (etc.) pages
    if(isset($_REQUEST['sef_rewrite'])) {
        $view = & Registry::get('view');
        $view->register_outputfilter('fn_magic360');
    }
}

function fn_magic360_load($block = false) {
    if(!isset($GLOBALS['magictoolbox']['magic360'])) {
        require_once(dirname(__FILE__).'/core/magic360.module.core.class.php');
        $GLOBALS['magictoolbox']['magic360'] = new Magic360ModuleCoreClass();
        $tool = &$GLOBALS['magictoolbox']['magic360'];

        $params = Registry::get('addons.magic360');

        $enabledOptions = db_get_hash_single_array('SELECT block, value FROM ?:addon_magic360_options WHERE name = \'enabled_options\'', array('block', 'value'));

        foreach($params as $p_name => $p_value) {
            $param_value = '';
            if(strpos($p_value, $p_name.'-') === 0) {
                $param_value = substr($p_value, strlen($p_name)+1);
            } else {
                $param_value = $p_value;
            }
            if(strpos($p_name, 'general-') === 0) {
                $tool->params->setValue(substr($p_name, 8), $param_value);
            } else {
                $pattern = '/(product|category|search|newest|recent_products|popularity|bestsellers|rating|manually|banners)-(.*)/is';
                $matches = array();
                if(preg_match($pattern, $p_name, $matches)) {
                    if(strpos($enabledOptions[$matches[1]], '|'.$matches[2].'|') !== false
                      ) {
                        $tool->params->setValue($matches[2], $param_value, $matches[1]);
                    }
                }
            }
        }
    } else {
        $tool = &$GLOBALS['magictoolbox']['magic360'];
    }
    return $tool;
}

function fn_magic360_headers($contents, $simplifiedMode = false) {
    $tool = fn_magic360_load();
    $tool->params->resetProfile();
    $http_path = Registry::get('config.http_path');
    $headers = '';
    $headers .= $tool->getHeadersTemplate($http_path.'/addons/magic360/core');
    if(!defined('MAGICTOOLBOX_FUNC_JS_INCLUDED')) {
        $headers .= '<script type="text/javascript" src="'.$http_path.'/addons/magic360/func.js"></script>'."\r\n";
        define('MAGICTOOLBOX_FUNC_JS_INCLUDED', true);
    }


    if($simplifiedMode) {
        return $contents."\r\n".$headers;
    }

    $pattern = '<!-- Magic (Zoom|Thumb)(?: Plus)? CS-Cart module[^>]*+>'.
               '[^<]*+<link\b[^>]*?href="[^"]*?magic(?:zoom(?:plus)?|thumb|scroll)\.css"[^>]*+>';
    $matches = array();
    if(preg_match_all('#'.$pattern.'#is', $contents, $matches, PREG_SET_ORDER)) {
        if($matches[0][1] == 'Zoom') {
            //NOTE: place magic360 headers before magiczoom(plus) headers
            $contents = str_replace($matches[0][0], $headers."\r\n".$matches[0][0], $contents);
        } else if(isset($matches[1])) {
            //NOTE: place magic360 headers before magicscroll headers (after magicthumb)
            $contents = str_replace($matches[1][0], $headers."\r\n".$matches[1][0], $contents);
        } else {
            $contents = preg_replace('#</head>#is', $headers.'</head>', $contents, 1);
        }
    } else
    $contents = preg_replace('#</head>#is', $headers.'</head>', $contents, 1);

    //$quickView = $tool->params->checkValue('mode', array('quick_view', 'options'));
    //NOTICE: we need headers for quick view
    //if(in_array($_REQUEST['dispatch'], array('categories.view', 'products.search', 'index.index'))) return $contents;

    if(defined('MAGICTOOLBOX_JS_FILES_SUBSTITUTION')) {
        return $contents;
    }
    define('MAGICTOOLBOX_JS_FILES_SUBSTITUTION', true);
    //absolute path
    $module_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ADDONS.'/magic360');

    $jsFiles = array('/ajax', '/core');

    //to prevent page break as a result not property install
    foreach($jsFiles as $key => $fileName) {
        if(!file_exists($module_directory.$fileName.'.js')) {
            unset($jsFiles[$key]);
        }
    }

    if(!empty($jsFiles)) {
        if(Registry::get('config.tweaks.js_compression')) {
            //$dir_cache = substr(DIR_CACHE, strlen(DIR_ROOT));
            $js_path = Registry::get('config.cache_path') . '/js';
            $suffix = '_packed';
            foreach($jsFiles as $fileName) {
                if(!is_file($module_directory.$fileName.$suffix.'.js') && is_writeable($module_directory)) {
                    if(!class_exists('JavaScriptPacker')) include_once(DIR_LIB.'packer/class.JavaScriptPacker.php');
                    $packer = new JavaScriptPacker(fn_get_contents($module_directory.$fileName.'.js'));
                    fn_put_contents($module_directory.$fileName.$suffix.'.js', $packer->pack());
                }
            }
        } else {
            $js_path = Registry::get('config.current_path') . '/js';
            $suffix = '';
        }

        //relative to the site root
        $module_path = Registry::get('config.current_path').substr(DIR_ADDONS, strlen(DIR_ROOT)).'magic360';

        foreach($jsFiles as $fileName) {
            $pattern = preg_quote($js_path.$fileName.'.js', '/');
            $contents = preg_replace('/'.$pattern.'/is', $module_path.$fileName.$suffix.'.js', $contents);
        }
    }

    return $contents;
}

function fn_magic360_parse_circle($contents, $products, $block) {
    $tool = fn_magic360_load();
    $tool->params->setProfile($block);
    switch($block) {
        case 'product':
            $rezult = db_get_row('SELECT gallery, columns FROM ?:addon_magic360_images WHERE id = ?i', $products[0]['product_id']);
            if(empty($rezult) || empty($rezult['gallery'])) break;
            $magic360Images = explode(';', $rezult['gallery']);
            $magic360ImagesCount = count($magic360Images);
            $magic360Columns = $rezult['columns'];
            $magic360Rows = 1;
            if($rezult['columns'] && $rezult['columns'] < $magic360ImagesCount) {
                $magic360Rows = floor($magic360ImagesCount/intval($rezult['columns']));
            }

            $baseImagePath = Registry::get('config.images_path').'magic360/';//Registry::get('config.http_images_path')
            $images_data = array();

            $old_locale = setlocale(LC_ALL, NULL);
            setlocale(LC_ALL, 'en_US.UTF8');

            foreach($magic360Images as $image_id => $image) {
                //DIR_IMAGES.'magic360/';
                $images_data[$image_id]['medium'] = fn_magic360_create_thumb($baseImagePath.$image, 'thumb', $tool, $products[0]['product_id']);
                $images_data[$image_id]['img'] = fn_magic360_create_thumb($baseImagePath.$image, 'original', $tool, $products[0]['product_id']);
            }

            $tool->params->setValue('columns', $magic360Columns, 'product');

            /*
            $container_width = $tool->params->getValue('thumb-max-width');
            if(!$container_width) {
                reset($images_data);
                $first_image = current($images_data);
                $image_path_full = str_replace(Registry::get('config.current_path'), $first_image['img'], DIR_ROOT);
                $first_image_size = getimagesize($image_path_full);
                $container_width = $first_image_size[0];
            }
            /**/

            setlocale(LC_ALL, $old_locale);

            $toolHTML = $tool->getMainTemplate($images_data, array("id" => "Magic360Image".$block.$products[0]['product_id']));

            if(isset($GLOBALS['magictoolbox']['cooperative_mode'])) {
                $s360IconPath = $tool->params->getValue('icon');
                if(!empty($s360IconPath) && file_exists(DIR_IMAGES.$s360IconPath)) {
                    $magic360SelectorClass = 'm360-selector active-selector';
                    if($tool->params->getValue('original-layout', 'product')) {
                        $magic360SelectorClass .= ' cm-thumbnails-mini';
                    }
                    $magic360Selector = '<a class="'.$magic360SelectorClass.'" title="360" href="#" onclick="return false;"><img src="'.
                        fn_magic360_create_thumb(Registry::get('config.images_path').$s360IconPath, 'selector', $tool, '360selector').
                        '" alt="360" /></a>';
                    if(in_array($GLOBALS['magictoolbox']['cooperative_mode'], array('magiczoom', 'magiczoomplus'))) {
                        $magic360Selector = preg_replace('#<a\b[^>]+?class="#i', '$0zoom-with-360 ', $magic360Selector);
                    }
                    $contents = str_replace('<!-- MAGIC360SELECTOR -->', $magic360Selector, $contents);
                } else {
                    $contents = str_replace('<!-- MAGIC360SELECTOR -->', '', $contents);
                }
                $contents = str_replace('<!-- MAGIC360 -->', $toolHTML, $contents);
                break;
            }

            //$toolHTML = '<div class="MagicToolboxContainer" style="min-width:'.$container_width.'px;">'.$toolHTML.'</div>';
            $toolHTML = '<div class="MagicToolboxContainer">'.$toolHTML.'</div>';

            $jcarousel = Registry::get('settings.Appearance.thumbnails_gallery') == 'Y';
            $additional_thumbnails_pattern = '<'.($jcarousel?'ul':'div').'[^>]+?class="[^"]*?(?:cm-)?product-thumbnails[^"]*"[^>]*>[^<]*(?:'.
                ($jcarousel?'<li[^>]*>':'').
                '<a[^>]+?class="[^"]*?cm-thumbnails-mini[^"]*"[^>]*>[^<]*'.
                '<img[^>]*>[^<]*'.
                '<\/a>[^<]*'.
                ($jcarousel?'<\/li>':'').
                ')+<\/'.($jcarousel?'ul':'div').'>';
            $contents = preg_replace('/'.$additional_thumbnails_pattern.'/is', '', $contents);

            $image_pattern = '(?:<span[^>]+?class="[^"]*?larger-image-wrap[^"]*"[^>]*>[^<]*'.
                '<a[^>]+?class="[^"]*?view-larger-image[^"]*"[^>]*>[^<]*'.
                '<\/a>[^<]*'.
                '<\/span>[^<]*)?'.
                '(?:<a[^>]+?id="det_img_link_[^"]*"[^>]*>[^<]*)?'.
                '<img[^>]+?id="det_img_'.$products[0]['product_id'].'[^"]*"[^>]*>[^<]*'.
                '(?:<\/a>[^<]*)?';
            $contents = preg_replace('/(?:'.$image_pattern.')+/is', $toolHTML, $contents, 1);//NOTE: $limit = 1 to prevent the replacement of product in product tabs(product id == block id)

            //$tool->params->setValue('headers', 'Yes', $tool->params->generalProfile);

            break;
    }
    return $contents;
}

function fn_magic360_create_thumb($src, $size, &$tool, $pid) {

    static $imageDir = '';
    static $imagesPathQuoted = '';
    static $imagehelper = null;

    if($imagehelper === null) {
        $imagesPathQuoted = preg_quote(Registry::get('config.images_path'), '/');
        $imageDir = str_replace(DIR_ROOT, '', DIR_IMAGES);
        //$config['images_path'] = $config['current_path'] . '/images/';
        require_once(dirname(__FILE__).'/core/magictoolbox.imagehelper.class.php');
        $imagehelper = new MagicToolboxImageHelperClass(DIR_ROOT, $imageDir.'magictoolbox_cache', $tool->params, null, Registry::get('config.http_path'));
    }

    $src = htmlspecialchars_decode($src, ENT_QUOTES);

    //preg_match('/^(.*?(product|detailed|banner|promo|magic360)\/(.*?\/)?)([^\/]*?)\.([^\.]*)$/is', $src, $matches);
    //if(empty($matches)) return $src;
    //list(, $path, $iType, $subDir, $name, $ext) = $matches;
    //if(empty($iType)) { $iType = 'product'; $subDir = '';}
    //if($subDir == $path) $subDir = '';
    //$img = $imageDir.$iType.'/'.$subDir.$name.'.'.$ext;

    preg_match('/^.*?'.$imagesPathQuoted.'(.*?)$/is', $src, $matches);
    if(empty($matches)) return $src;
    $img = $imageDir.$matches[1];

    $thumb = $imagehelper->create($img, $size, $pid);
    //NOTE: spike to get real size of image
    $GLOBALS['magictoolbox']['file_path'] = $imagehelper->file;
    if(MT_DS != '/') {
        $thumb = str_replace(MT_DS, '/', $thumb);
    }

    return $thumb;
}

function fn_magic360_js_functions() {

    if(Registry::get("addons.magic360.status") === 'D') {
        $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic 360 module should be enabled for proper operation of the settings page." .
                   "<br/>Please enable it before save settings.</span>";
        fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('warning').'</span>', $message, true, 'magic360_module_disabled_notification');
    }

    //$modulePath = Registry::get('config.current_path').substr(DIR_ADDONS, strlen(DIR_ROOT)).'magic360';
    return '
        <script type="text/javascript">
            //<![CDATA[
            function fn_magic360_prepare_custom_options(block, skip) {
                skip = (skip || \'\').split(\'|\');
                skip.push(\'enable-effect\');
                var enabledOptionsID = "#addon_option_magic360_" + block + "-enabled-options";
                var enabledOptions = $(enabledOptionsID).val();
                var sectionID = "#content_magic360_magic360_" + block;
                $(sectionID + " div.form-field").
                 each(function(){
                        $(this).
                         find("select, input[type=\'text\']").
                         each(function(){
                                var optionId = this.id.replace("addon_option_magic360_" + block + "-","");
                                if(jQuery.inArray(optionId, skip) !== -1) {
                                    return;
                                }
                                if(enabledOptions.indexOf("|" + optionId + "|") == -1) {
                                    $(this).attr("disabled", true).after("&nbsp;&nbsp;<a href=\"#\" >edit</a>");
                                } else {
                                    $(this).after("&nbsp;&nbsp;<a href=\"#\" >use default option</a>");
                                }
                                $(this).next().
                                    bind("click", {optionId: optionId, enabledOptionsID: enabledOptionsID},
                                                    function(event) {
                                                        var enabledOptions = $(event.data.enabledOptionsID).val();
                                                        if($(this).html() == "edit") {
                                                            $(this).html("use default option").prev().removeAttr("disabled");
                                                            enabledOptions = enabledOptions.concat(event.data.optionId + "|");
                                                        } else {
                                                            $(this).html("edit").prev().attr("disabled", true).val($("#addon_option_magic360_general-" + event.data.optionId).val().replace("general-", block + "-"));
                                                            var pattern = new RegExp("\\\\|" + event.data.optionId + "\\\\|", "g");
                                                            enabledOptions = enabledOptions.replace(pattern, "|");
                                                        }
                                                        $(event.data.enabledOptionsID).val(enabledOptions);
                                                        return false;
                                                }
                                        );

                              }).
                         end().
                         find("input[type=\'radio\']:checked").
                         each(function(){
                                var optionId = this.parentNode.id.replace("addon_option_magic360_" + block + "-","");
                                if(jQuery.inArray(optionId, skip) !== -1) {
                                    return;
                                }
                                if(enabledOptions.indexOf("|" + optionId + "|") == -1) {
                                    $(this.parentNode).find("input").attr("disabled", true).end().
                                     find(":last-child").after("&nbsp;&nbsp;<a href=\"#\" >edit</a>");
                                } else {
                                    $(this.parentNode).find(":last-child").after("&nbsp;&nbsp;<a href=\"#\" >use default option</a>");
                                }
                                $(this.parentNode).find(":last-child").
                                    bind("click", {optionId: optionId, enabledOptionsID: enabledOptionsID},
                                                    function(event) {
                                                        var enabledOptions = $(event.data.enabledOptionsID).val();
                                                        if($(this).html() == "edit") {
                                                            $(this).html("use default option");
                                                            $(this.parentNode).find("input").removeAttr("disabled");
                                                            enabledOptions = enabledOptions.concat(event.data.optionId + "|");
                                                        } else {
                                                            $(this).html("edit");
                                                            $(this.parentNode).find("input").attr("disabled", true).val([$("#addon_option_magic360_general-" + optionId + " input:checked").val().replace("general", block)]);
                                                            var pattern = new RegExp("\\\\|" + event.data.optionId + "\\\\|", "g");
                                                            enabledOptions = enabledOptions.replace(pattern, "|");
                                                        }
                                                        $(event.data.enabledOptionsID).val(enabledOptions);
                                                        return false;
                                                }
                                        );

                              });
                      });
            }
            function fn_magic360_clear_cache_field(data, params) {
                if(data.html) {
                    for (var k in data.html) {
                        $("#addon_option_magic360_cache-total-items").val(data.html[k]);
                        $("#addon_option_magic360_cache-unused-items").val("0 (0 bytes)");
                        break;
                    }
                }
            }
            //]]>
        </script>
';

}

function fn_magic360_prepare_custom_options($block) {

    static $addonOptions;
    static $enabledOptions;
    $headersBind = '';
    $generalParamsChangeBind = '';
    $includeOptionsJs = '';
    $initOptionsValidation = '';
    $magicscrollIcon = '';
    $blocks = array('product',
                   );

    if(!isset($addonOptions)) {
        $section = CSettings::instance()->get_section_by_name($_REQUEST['addon'], CSettings::ADDON_SECTION);
        $addonOptions = db_get_hash_single_array('SELECT name, value FROM ?:settings_objects WHERE section_id = \'?p\' AND type != \'H\'', array('name', 'value'), $section['section_id']);
        $enabledOptions = db_get_hash_single_array('SELECT block, value FROM ?:addon_magic360_options WHERE name = \'enabled_options\'', array('block', 'value'));
    }

    switch($block) {
        case 'general':
            if(isset($addonOptions['cache-path-to-cache'])) {
                $pathToCache = $addonOptions['cache-path-to-cache'];
            } else {
                $pathToCache = str_replace(DIR_ROOT, '', DIR_IMAGES).'magictoolbox_cache';
            }
            $tool = fn_magic360_load();
            require_once(dirname(__FILE__).'/core/magictoolbox.imagehelper.class.php');
            $imagehelper = new MagicToolboxImageHelperClass(DIR_ROOT, $pathToCache, $tool->params);
            $usedSubCache = $imagehelper->getOptionsHash();
            $cacheInfo = fn_magic360_getCacheInfo(DIR_ROOT.$pathToCache, $usedSubCache);
            return  '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magic360_cache-path-to-cache">Path to cache folder'.
                    '(<a onclick="return false;" class="cm-tooltip" title="Relative for site base path.">?</a>)<span class="hidden cm-tooltip-text"></span>'.
                    '</label>'.
                    '<input type="text" name="addon_data[options][cache-path-to-cache]" id="addon_option_magic360_cache-path-to-cache" value="'.$pathToCache.'" class="input-text" style="width:352px;" disabled="disabled" />'.
                    '</div>'.
                    '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magic360_cache-total-items">Total items:</label>'.
                    '<input type="text" name="addon_data[options][cache-total-items]" id="addon_option_magic360_cache-total-items" value="'.$cacheInfo['totalCount'].' ('.fn_magic360_format_size($cacheInfo['totalSize']).')" class="input-text" disabled="disabled" />'.
                    '</div>'.
                    '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magic360_cache-unused-items">Unused items:</label>'.
                    '<input type="text" name="addon_data[options][cache-unused-items]" id="addon_option_magic360_cache-unused-items" value="'.$cacheInfo['unusedCount'].' ('.fn_magic360_format_size($cacheInfo['unusedSize']).')" class="input-text" disabled="disabled" />'.
                    '</div>'.
                    '<div style="display: block;" class="form-field">'.
                    '<label for="addon_option_magic360_cache-what-clear">Empty cache:</label>'.
                    '<select id="addon_option_magic360_cache-what-clear" onchange="$(\'#magic360_clear_cache_field\').attr(\'href\', \''.INDEX_SCRIPT.'?dispatch=magic360_cache.\'+this.value).attr(\'rev\', this.value);">'.
                    '<option  selected="selected" value="clear_unused_items">Delete unused items</option>'.
                    '<option value="clear_all_items">Delete all items</option>'.
                    '</select>'.
                    '&nbsp;<a name="magic360_clear_cache_field" id="magic360_clear_cache_field" href="'.INDEX_SCRIPT.'?dispatch=magic360_cache.clear_unused_items" class="cm-ajax cm-confirm" rev="clear_unused_items" >Clear</a>'.
                    '</div>'
                    ;
            break;
        case 'product':
            //only after last block
            $blocks  = '"'.implode('", "', $blocks).'"';
            $headersBind = '$("#tabs_content_magic360 h2.subheader").css({\'background-color\': \'#F4F4F4\', \'cursor\': \'pointer\'}).slice(0, 1).prepend("&nbsp;<img alt=\"\" src=\"./skins/basic/admin/images/icons/advanced_search_expanded.gif\">").end().slice(1).prepend("&nbsp;<img alt=\"\" src=\"./skins/basic/admin/images/icons/advanced_search_collapsed.gif\">").end().bind("click", function(){$(this).find("img").each(function(){if(this.src.indexOf("advanced_search_collapsed") == -1) this.src = this.src.replace("advanced_search_expanded", "advanced_search_collapsed"); else this.src = this.src.replace("advanced_search_collapsed", "advanced_search_expanded");}).end().nextAll().each(function slideToggleNode(){if(typeof slideToggleNode.stop == "undefined" ) {if(this.tagName=="H2") slideToggleNode.stop = true; else $(this).slideToggle(250);}}); return false;}).slice(1, 2).nextAll("div.form-field").css("display", "none");$("#tabs_content_magic360 div").slice(1).find("h2.subheader:first").nextAll("div.form-field").css("display", "none");';
            $generalParamsChangeBind = '
$("#content_magic360_magic360_general").find("input[type=\'text\']").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.id.replace("addon_option_magic360_general-","");
var optioVal = $(this).val();
for(block in block_array) {
    $("#content_magic360_magic360_" + block_array[block]).
    find("#addon_option_magic360_" + block_array[block] + "-" + optionId + ":disabled").val(optioVal);
}
}).
end().find("select").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.id.replace("addon_option_magic360_general-","");
var optioVal = $(this).val().replace("general-" + optionId + "-", "");
for(block in block_array) {
    $("#content_magic360_magic360_" + block_array[block]).
    find("#addon_option_magic360_" + block_array[block] + "-" + optionId + ":disabled").val(block_array[block] + "-" + optionId + "-" + optioVal);
}
}).
end().find("input[type=\'radio\']").bind("change", function(){
var block_array = ['.$blocks.'];
var optionId = this.parentNode.id.replace("addon_option_magic360_general-","");
var optioVal = $(this).val().replace("general-" + optionId + "-", "");
for(block in block_array) {
    $("#content_magic360_magic360_" + block_array[block]).
    find("#addon_option_magic360_" + block_array[block] + "-" + optionId + " input:disabled").val([block_array[block] + "-" + optionId + "-" + optioVal]);
}
});';
        default:
    }

    $tool = fn_magic360_load();
    $skip = array();

    if($tool->type == 'standard') {
        foreach($tool->params->getParams() as $param) {
            if(in_array($param['group'], array('General', 'Scroll', 'Scroll Arrows', 'Scroll Slider', 'Scroll effect', 'Multiple images'))) {
                $skip[] = $param['id'];
            }
        }
    }

    $skip = implode('|', $skip);
    return $includeOptionsJs.'
        <input type="hidden" name="addon_data[options]['.$block.'-enabled-options]" id="addon_option_magic360_'.$block.'-enabled-options" value="'.$enabledOptions[$block].'" />
        <script type="text/javascript">
            //<![CDATA[
            fn_magic360_prepare_custom_options("'.$block.'", \''.$skip.'\');
            '.$headersBind.$generalParamsChangeBind.$initOptionsValidation.$magicscrollIcon.'
            //]]>
        </script>
    ';
}

function fn_magic360_getCacheInfo($path, $usedSubCache = null) {

    $totalSize = 0;
    $totalCount = 0;
    $usedSize = 0;
    $usedCount = 0;
    if (is_dir($path))
    if ($handle = opendir($path)) {
        while (false !== ($file = readdir($handle))) {
            $next = $path.DIRECTORY_SEPARATOR.$file;
            if ($file != '.' && $file != '..' && !is_link($next)) {
                if (is_dir($next)) {
                    $result = fn_magic360_getCacheInfo($next);
                    if($file == $usedSubCache) {
                        $usedSize += $result['totalSize'];
                        $usedCount += $result['totalCount'];
                    }
                    $totalSize += $result['totalSize'];
                    $totalCount += $result['totalCount'];
                } elseif (is_file($next)) {
                    $totalSize += filesize($next);
                    $totalCount++;
                }
            }
        }
        closedir($handle);
    }
    return array('totalSize' => $totalSize, 'totalCount' => $totalCount, 'unusedSize' => $totalSize-$usedSize, 'unusedCount' => $totalCount-$usedCount);
}

function fn_magic360_format_size($size) {
    $units = array(' bytes', ' KB', ' MB', ' GB', ' TB');
    for ($i = 0; $size >= 1024 && $i < 4; $i++) $size /= 1024;
    return round($size, 2).$units[$i];
}

function fn_magic360_install() {

    $js_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ROOT.'/js');
    $module_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ADDONS.'/magic360');
    $jsFiles = array('/ajax', '/core');
    $suffix = '_packed';
    $cancel = false;

    if(!defined('PRODUCT_VERSION') || version_compare(PRODUCT_VERSION, '3.0.0', '<')) {
        if(!fn_notification_exists('E', 'magic360_module_version_notification')) {
            $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">This Magic 360 module is intended only for CS Cart Version 3 and above.".
                       "<br/>Your version of CS Cart is ".PRODUCT_VERSION."</span>";
            fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magic360_module_version_notification');
        }
    }

    if(!class_exists('JavaScriptPacker'))
        include_once(DIR_LIB.'packer/class.JavaScriptPacker.php');

    foreach($jsFiles as $fileName) {
        if(@is_file($module_directory.$fileName.'.js')) {
           //installed
        } else {
            if(@is_file($js_directory.$fileName.'.js') && is_writeable($module_directory)) {
                switch($fileName) {
                    case '/ajax':
                        // modify ajax.js
                        $c = file_get_contents($js_directory.$fileName.'.js');
                        $stop = '
        if(params && params.result_ids) {
            if((params.result_ids.search(/(?:product_images_|list_image_update_|product_quick_view_)\d+(?:_update)?|product_filters_\*/i) != -1) || (params.result_ids == \'pagination_contents\')) {
                var productIdMatch = params.result_ids.match(/.*?(?:product_images_|list_image_update_|product_quick_view_)([0-9]+)(?:_update)?.*/i);
                if(productIdMatch) {
                    fn_magictoolbox_tool_update("stop", "product", productIdMatch[1]);
                } else {
                    fn_magictoolbox_tool_update("stop", "category", "");
                }
            }
        }';
                        $start = '
        if(params && params.result_ids) {
            if((params.result_ids.search(/(?:product_images_|list_image_update_|product_quick_view_)\d+(?:_update)?|product_filters_\*/i) != -1) || (params.result_ids == \'pagination_contents\')) {
                var productIdMatch = params.result_ids.match(/.*?(?:product_images_|list_image_update_|product_quick_view_)([0-9]+)(?:_update)?.*/i);
                if(productIdMatch) {
                    fn_magictoolbox_tool_update("start", "product", productIdMatch[1]);
                } else {
                    fn_magictoolbox_tool_update("start", "category", "");
                }
            }
        }';
                        $c = preg_replace('/(ajaxRequest\: function\(url, params\)\s+?\{)/', '$1'.$stop, $c);
                        $c = preg_replace('/((?:\$|jQuery)\.toggleStatusBox\(\'hide\'\);)/', '$1'.$start, $c);
                        file_put_contents($module_directory.$fileName.'.js', $c);

                        $packer = new JavaScriptPacker(fn_get_contents($module_directory.$fileName.'.js'));
                        fn_put_contents($module_directory.$fileName.$suffix.'.js', $packer->pack());

                        break;
                    case '/core':
                        //modify core.js file
                        $c = file_get_contents($js_directory.$fileName.'.js');

                        $pattern = 'for (var k in data) {';
                        $replace = 'for (var k in data) { if(!data.hasOwnProperty(k)) {continue;}';
                        $c = str_replace($pattern, $replace, $c);

                        //NOTE: change function name since version 3.0.1 RC6
                        $pattern = '/((?:fn_scroller_)?init_callback[^\{]*\{)/i';
                        $replace = "$1\n\t\t\tif(carousel.list.parents('div.MagicToolboxSelectorsContainer').length || carousel.list.find('div.MagicToolboxContainer').length) {".
                        "\n\t\t\t\tcarousel.options.wrap = 'both';\n\t\t\t}";

                        $c = preg_replace($pattern, $replace, $c);

                        file_put_contents($module_directory.$fileName.'.js', $c);

                        $packer = new JavaScriptPacker(fn_get_contents($module_directory.$fileName.'.js'));
                        fn_put_contents($module_directory.$fileName.$suffix.'.js', $packer->pack());

                        break;
                }
            } else {
                //can't install
                $cancel = true;
                if(!is_writeable($module_directory) && !fn_notification_exists('E', 'magic360_module_directory_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic 360 needs write access to the folder <b>'".$module_directory."'</b> for proper installation." .
                               "<br/>Please check this and reinstall Magic 360.</span>";
                    fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magic360_module_directory_notification');
                }
                if(!@is_file($js_directory.$fileName.'.js') && !fn_notification_exists('E', 'magic360_file'.$fileName.'_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic 360 needs read access to the file <b>'".$js_directory.$fileName.".js'</b> for proper installation." .
                               "<br/>Please check this and reinstall Magic 360.</span>";
                    fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magic360_file'.$fileName.'_notification');
                }
            }
        }
    }

    if(!is_file($module_directory.'/tabs'.$suffix.'.js')) {
        $packer = new JavaScriptPacker(fn_get_contents($module_directory.'/tabs.js'));
        fn_put_contents($module_directory.'/tabs'.$suffix.'.js', $packer->pack());
    }


    //fix url's in css files
    $cancel = fn_magic360_fix_css();

    @copy($module_directory.'/360icon.png', DIR_IMAGES.'360icon.png');

    if($cancel) {
        $args = func_get_args();
        if(!empty($args)) fn_redirect("addons.manage");
    }


    fn_magic360_send_stat('install');

}

function fn_magic360_fix_css() {

    $cancel = false;

    $path = dirname(__FILE__).'/core';

    $resourcesPath = Registry::get('config.current_path').substr(DIR_ADDONS, strlen(DIR_ROOT)).'magic360/core';
    $resourcesPath = str_replace(array("//", "\\"), array("/", "/"), $resourcesPath);

    $list = glob($path.'/*');
    $files = array();
    if(is_array($list)) {
        for($i = 0; $i < count($list); $i++) {
            if(is_dir($list[$i])) {
                if(!in_array(basename($list[$i]), array('.svn', '.git'))) {
                    $add = glob($list[$i].'/*');
                    if(is_array($add)) {
                        $list = array_merge($list, $add);
                    }
                }
            } else if(preg_match('#\.css$#i', $list[$i])) {
                $files[] = $list[$i];
            }
        }
    }

    foreach($files as $file) {
        $cssPath = dirname($file);
        $cssRelPath = str_replace($path, '', $cssPath);
        $toolPath = $resourcesPath.$cssRelPath;
        $pattern = '#url\(\s*(\'|")?(?!data:|mhtml:|http(?:s)?:|/)([^\)\s\'"]+?)(?(1)\1)\s*\)#is';
        $replace = 'url($1'.$toolPath.'/$2$1)';
        $fileContents = file_get_contents($file);
        $fixedFileContents = preg_replace($pattern, $replace, $fileContents);
        if($fixedFileContents != $fileContents) {
            if(is_writeable($file)) {
                file_put_contents($file, $fixedFileContents);
            } else {
                //NOTE: install module anyway
                /*
                $cancel = true;
                if(!fn_notification_exists('E', 'magic360_file_'.md5($file).'_notification')) {
                    $message = "<br/><span style=\"font-size: 16px; line-height: 20px; margin-top: 5px; display: block;\">Magic 360 needs write access to the file <b>'".$file."'</b> for proper installation." .
                                "<br/>Please check this and reinstall Magic 360.</span>";
                    fn_set_notification('E', '<span style="font-size: 18px">'.fn_get_lang_var('error').'</span>', $message, true, 'magic360_file_'.md5($file).'_notification');
                }
                */
            }
        }
    }

    return $cancel;

}

function fn_magic360_after_install() {
    //NOTE: we need to change position of options in DB, that the content displayed in the right order
    $section = CSettings::instance()->get_section_by_name($_REQUEST['addon'], CSettings::ADDON_SECTION);
    $query = 'UPDATE ?:settings_objects SET ?:settings_objects.position = ?:settings_objects.object_id WHERE ?:settings_objects.section_id = ?s';
    db_query($query , $section['section_id']);
}

function fn_magic360_uninstall() {

    $js_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ROOT.'/js');
    $module_directory = str_replace(array("//", "\\"), array("/", "/"), DIR_ADDONS.'/magic360');
    $jsFiles = array('/ajax', '/core');
    $suffix = '_packed';

    foreach($jsFiles as $fileName) {
        if(@is_file($module_directory.$fileName.'.js')) {
            @unlink($module_directory.$fileName.'.js');
        }
        if(@is_file($module_directory.$fileName.$suffix.'.js')) {
            @unlink($module_directory.$fileName.$suffix.'.js');
        }
    }
    if(@is_file($module_directory.'/tabs'.$suffix.'.js')) {
        @unlink($module_directory.'/tabs'.$suffix.'.js');
    }

    fn_magic360_send_stat('uninstall');

}

function fn_magic360_send_stat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v1.4.7' || 'working' == 'v4.6.13') {
        return;
    }

    $hostname = 'www.magictoolbox.com';
    $url = $_SERVER['HTTP_HOST'].preg_replace('/\/[^\/]*?\.php.*$/i', '', $_SERVER['REQUEST_URI']);
    $url = urlencode(urldecode($url));
    $platformVersion = defined('PRODUCT_VERSION') ? PRODUCT_VERSION : '';
    $path = "api/stat/?action={$action}&tool_name=magic360&license=trial&tool_version=v4.6.13&module_version=v1.4.7&platform_name=cscart3&platform_version={$platformVersion}&url={$url}";
    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers  = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }
}
