<?php

include('../admin.php');

$moduleDir = dirname(__FILE__) . '/../../magictoolbox';
$coreFile = $moduleDir.'/core/magiczoom.module.core.class.php';
if(file_exists($coreFile)) {
    require $coreFile;
    $tool = new MagicZoomModuleCoreClass;
} else {
    die("File: $coreFile does not exists");
}

$iniFile = $moduleDir . '/magiczoom.settings.ini';

if(!file_exists($iniFile)) {
    die("File: $iniFile does not exists");
}

if(isset($_POST['submit'])) {
    $params = array();
    foreach($tool->params->getParams() as $id => $param) {
        if(isset($_POST[$id])) {
            $params[] = $id;
            $value = trim($_POST[$id]);
            if($tool->params->getType($id) == 'array' && !in_array($value, $tool->params->getValues($id))) $value = $tool->params->getDefaultValue($id);
            $tool->params->setValue($id, $value);
        }
    }
    $tool->params->updateINI($iniFile, $params);
}

$tool->params->loadINI($iniFile);

require $moduleDir.'/magiczoom.settings.template.php';
