<?php
    /**
     *  Avactis module installer class
     */

    require_once(dirname(__FILE__) . '/magictoolbox.installer.core.class.php');

    class MagicToolboxAvactisModuleInstallerClass extends MagicToolboxCoreInstallerClass {

        function __construct() {
            $this->dir = dirname(dirname(__FILE__));
            $this->modDir = dirname(__FILE__).'/module';
            $this->resDir = preg_replace('/^(.*?\/)[^\/]+\/[^\/]+$/is', '$1', $_SERVER['SCRIPT_NAME']) . 'magictoolbox/core';
        }

        function isModuleInstalled() {
            $this->setStatus('check', 'module');
            if(file_exists($this->dir.'/magictoolbox/core/magiczoom.module.core.class.php')) {
                if('magiczoom' == 'magicscroll') {
                    $contents = file_get_contents($this->dir.'/magictoolbox/core/magicscroll.module.core.class.php');
                    if(!preg_match('/<!-- Magic Scroll Avactis module/', $contents)) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        function checkPlace() {
            $this->setStatus('check', 'place');
             if(!file_exists($this->dir . '/product-info.php')) {
                $this->setError('Wrong location: please upload the files from the ZIP archive to the Avactis store directory.');
                return false;
            }
            return true;
        }

        function checkPerm() {
            $this->setStatus('check', 'perm');
            $files = array(
                // directory
                '/avactis-system/admin',
                // file
                '/product-info.php',
                '/product-list.php'
            );
            list($result, $wrang) = $this->checkFilesPerm($files);
            if(!$result) {
                $this->setError('This installer need to modify some Avactis store files.');
                $this->setError('Please check write access for following files of your Avactis store:');
                $this->setError($wrang, '&nbsp;&nbsp;&nbsp;-&nbsp;');
                return false;
            }
            return true;
        }

        function backupFiles() {
            $this->setStatus('backup', 'files');
            $backups = array(
                '/product-info.php',
                '/product-list.php'
            );
            list($result, $wrang) = $this->createBackups($backups);
            if(!$result) {
                $this->setError('Can\'t create backups for following files:');
                $this->setError($wrang, '&nbsp;&nbsp;&nbsp;-&nbsp;');
                $this->setError('Please check write access');
                return false;
            }
            return true;
        }

        function restoreStep_backupFiles() {
            $this->removeBackups(array(
                '/product-info.php',
                '/product-list.php'
            ));
            return true;
        }

        function installFiles() {
            $this->setStatus('install', 'files');

            // copy folders
            $this->copyDir($this->modDir , $this->dir.'/');

            //rename product-info.php
            $c = file_get_contents($this->dir.'/product-info.php');

            $c = str_replace('include(\'init.php\');','include(\'init.php\'); include(\'magictoolbox/core/magiczoom.php\'); ob_start(); ',$c);
            $c = str_replace('?>','$content = ob_get_contents(); ob_end_clean(); magiczoom($content); ?>',$c);

            file_put_contents($this->dir.'/product-info.php', $c);

            //modify product-list.php

            //file_put_contents($this->dir.'/product-list.php', $c);

            return true;
        }

        function restoreStep_installFiles() {
            $this->restoreFromBackups(array(
                '/product-info.php',
                '/product-list.php'

            ));

            if (file_exists('product-info-original.php')) {
                unlink('product-info.php');
                rename('product-info-original.php','product-info.php');
            }

            $this->removeDir($this->dir . '/magictoolbox');
            @unlink($this->dir . '/avactis-system/admin/magiczoom.php');

        }

        function upgrade($files) {
            $path = $this->dir . '/magictoolbox/core/';
            foreach($files as $name => $file) {
                if(file_exists($path . $name)) {
                    unlink($path . $name);
                }
                file_put_contents($path . $name, $file);
                chmod($path . $name, 0755);
            }
            return true;
        }

        function getPlatformVersion() {
            if(file_exists($this->dir.'/avactis-system/core/version.php')) {
                require_once($this->dir.'/avactis-system/core/version.php');
                if(defined('PRODUCT_VERSION_NUMBER')) {
                    return PRODUCT_VERSION_NUMBER;
                }
            }
            return '';
        }

    }
