<?php
/*
error_reporting(E_ALL);
ini_set('display_errors', '1');
*/

function magicthumb($content = false) {
    $tool = & magicthumb_load_core_class();
    $content = setHeaders($content);

    if (strstr($GLOBALS['current_file'],'product-list')) {
        $GLOBALS['magictoolbox']['page'] = 'category';
    } else if (strstr($GLOBALS['current_file'],'product-info')) {
        $GLOBALS['magictoolbox']['page'] = 'product';
    } else {
        $GLOBALS['magictoolbox']['page'] = false;
    }

    $enabled_on_this_page = false;

    if ($tool->type == 'standard' && $GLOBALS['magictoolbox']['page']) { //do not apply MSS-like modules to category & product pages

        if ($GLOBALS['magictoolbox']['page'] == 'category' && !$tool->params->checkValue('use-effect-on-category-page', 'No')) {
            $enabled_on_this_page = true;
        }
        if ($GLOBALS['magictoolbox']['page'] == 'product' && !$tool->params->checkValue('use-effect-on-product-page', 'No')) {
            $enabled_on_this_page = true;
        }
    }
    if ($enabled_on_this_page) {
        $content = parseImages($content);
    }

    if (isset($GLOBALS['magictoolbox']['product_page']) && isset($GLOBALS['magictoolbox']['product_page'])) {
        $content = preg_replace('/class=\"product_img\"/is','class="magictoolbox_product_img"',$content); //will fix the css only for product page
    }

    echo $content;

}

function parseImages ($content = false) {
    $tool = & $GLOBALS['magictoolbox']['magicthumb'];
    if ($content && $tool->type == 'standard') {
        if ($GLOBALS['magictoolbox']['page'] == 'product') { //product page

            //parse main image
            $content = preg_replace_callback('/\<\!\-\- Preview block \-\-\>.*?<a.*?href=\"([^"]*)\".*?title=\"([^"]*)\".*?<\/div>/is','magicthumbCallback', $content); 

            //parse additional images
            preg_match('/\<\!\-\- Icons \-\-\>.*?<\/div>/is',$content,$selectors);
            $selectors_new = preg_replace_callback('/<a[^>]*?href=\"([^"]*)\" title=\"([^"]*)\".*?<\/a>/is','magicthumbCallback', $selectors); 

            $content = str_replace($selectors,$selectors_new,$content);

        }
        if ($GLOBALS['magictoolbox']['page'] == 'category') { //category page
            preg_match_all('/<form[^>]*?name=\"ProductForm_\d+\".*?\<\/form\>/is',$content,$pList);
            foreach ($pList[0] as $form) {
                $form_new = preg_replace_callback('/<a href=\"([^"]*)\".*?<img.*?src=\"([^"]*)\".*?alt=\"([^"]*)\".*?<\/a>/is','magicthumbCategoryCallback', $form);
                /*if (!$tool->params->checkValue('replace-discount-star','No')) {
                    $form_new = str_replace('class="discount_star"','class="discount_star" style="display:none;"',$form_new);
                }*/
                $content = str_replace($form,$form_new,$content);
            }
        }
    }
    return $content;
}

function magicthumbCallback ($matches) {

    $plugin = $GLOBALS['magictoolbox']['magicthumb'];
    $orig_img = $matches[1];
    $orig_img = str_replace($GLOBALS['application']->appIni['SITE_URL'],'',$orig_img);
    $title = $matches[2];

    $pdata = array_pop($GLOBALS['application']->pFactory->ObjectList);
    $pid = $pdata->_product_data['product_id'];

    $id = 'MainImage';

    $config = $GLOBALS['application']->appIni;

    $m = mysql_connect($config['DB_SERVER'],$config['DB_USER'],$config['DB_PASSWORD']);
    mysql_select_db($config['DB_NAME'],$m);

    /*$query = "SELECT `product_attr_value` FROM `".$config['DB_TABLE_PREFIX']."product_attributes` WHERE product_id=".$pid." and attribute_id=12";
    $result = mysql_query($query);
    $shortDescr = mysql_result($result,0);*/

    $query = "SELECT `product_attr_value` FROM `".$config['DB_TABLE_PREFIX']."product_attributes` WHERE product_id=".$pid." and attribute_id=13";
    $result = mysql_query($query);
    $description = mysql_result($result,0);

    mysql_close($m);

    if (!isset($GLOBALS['magictoolbox']['mainImageSet']) || !$GLOBALS['magictoolbox']['mainImageSet']) {
        $img = getThumb($orig_img,'original',$pid);
        $selector = getThumb($orig_img,'selector',$pid);
        $thumb = getThumb($orig_img,null,$pid);
        
        $result = $plugin->getMainTemplate(compact('img','thumb','id','title','description'));

        $medium = $thumb;
        $thumb = $selector;
        $GLOBALS['magictoolbox']['mainImage'] = $plugin->getSelectorTemplate(compact('img','medium','thumb','id','title','description'));

        $GLOBALS['magictoolbox']['mainImageSet'] = true;
    } else { //selectors

        $img = getThumb($orig_img,'original',$pid);
        $thumb = getThumb($orig_img,'selector',$pid);
        $medium = getThumb($orig_img,null,$pid);

        $result = $GLOBALS['magictoolbox']['mainImage'].$plugin->getSelectorTemplate(compact('img','medium','thumb','id','title','description'));
        $GLOBALS['magictoolbox']['mainImage'] = '';
    }
    $GLOBALS['magictoolbox']['product_page'] = true;
    

    return $result;
}

function magicthumbCategoryCallback ($matches) {

    $plugin = $GLOBALS['magictoolbox']['magicthumb'];
    $link = $matches[1];
    $title = $matches[3];
    $origThumb = $matches[2];

    $pid = preg_replace('/(.*?pid(\d+).*)/is','$2',$link);
    $id = 'Image_'.$pid;

    $config = $GLOBALS['application']->appIni;
    $url = $config['SITE_URL'];
    $image_dir = str_replace($url,'',$config['URL_IMAGES_DIR']);

    $m = mysql_connect($config['DB_SERVER'],$config['DB_USER'],$config['DB_PASSWORD']);
    mysql_select_db($config['DB_NAME'],$m);
    $query = "SELECT `product_attr_value` FROM `".$config['DB_TABLE_PREFIX']."product_attributes` WHERE product_id=".$pid." and attribute_id=9";
    $result = mysql_query($query);
    $largeImage = str_replace($config['SITE_URL'],'',mysql_result($result,0));
    if (!strstr($largeImage,$image_dir)) {
        $largeImage = $image_dir.$largeImage;
    }

    $query = "SELECT `product_attr_value` FROM `".$config['DB_TABLE_PREFIX']."product_attributes` WHERE product_id=".$pid." and attribute_id=13";
    $result = mysql_query($query);
    $description = mysql_result($result,0);

    mysql_close($m);

    /*if ($plugin->params->checkValue('link-to-product-page','No')) {
        $link = '';
    }*/

    $img = getThumb($largeImage,'original',$pid);
    $thumb = getThumb($largeImage,null,$pid);
    $result = $plugin->getMainTemplate(compact('img','thumb','id','title','description','link'));

    return $result;
}

function getThumb($src, $size = null, $pid = null) {
    if($size === null) $size = 'thumb';
    require_once('magictoolbox.imagehelper.class.php');
    $config = $GLOBALS['application']->appIni;
    $url = $config['SITE_URL'];
    $shop_dir = $config['SITE_PATH'];
    $image_dir = str_replace($url,'',$config['URL_IMAGES_DIR']);
    $imagehelper = new MagicToolboxImageHelperClass($shop_dir, '/'.  $image_dir . 'magictoolbox_cache', $GLOBALS['magictoolbox']['magicthumb']->params, null , $url);
    return $imagehelper->create('/' . $src, $size, $pid);
}

function setHeaders ($content) {
    $plugin = $GLOBALS['magictoolbox']['magicthumb'];
    $plugin->params->resetProfile();
    $headers = $plugin->getHeadersTemplate('magictoolbox/core','magictoolbox/core');
    $content = preg_replace('/\<\/head\>/is',"\n".$headers."\n</head>",$content,1);

    return $content;
}

function &magicthumb_load_core_class() {
    if(!isset($GLOBALS['magictoolbox'])) $GLOBALS['magictoolbox'] = array();
    if(!isset($GLOBALS['magictoolbox']['magicthumb'])) {
        /* load core class */
        require_once('magicthumb.module.core.class.php');
        $tool = new MagicThumbModuleCoreClass();
        $tool->params->loadINI(dirname(dirname(__FILE__)). '/magicthumb.settings.ini');
        /* add category for core params */
        $params = $tool->params->getParams();
        foreach($params as $k => $v) {
            $v['category'] = array(
                'name' => 'General options',
                'id' => 'general-options'
            );
            $params[$k] = $v;
        }
        $tool->params->appendParams($params);
        $GLOBALS['magictoolbox']['magicthumb'] = & $tool;
    } 
    return $GLOBALS['magictoolbox']['magicthumb'];
}

?>