<?php

/*------------------------------------------------------------------------
# com_virtuemart_magiczoomplus - Magic Zoom Plus for Joomla with VirtueMart
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magiczoomplus/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

if(!function_exists('com_install')) {
    function com_install() {
        return installMagiczoomplusForVirtueMart();
    }
}

if(!function_exists('com_uninstall')) {
    function com_uninstall() {
        return uninstallMagiczoomplusForVirtueMart();
    }
}

function installMagiczoomplusForVirtueMart() {

    $database = JFactory::getDBO();

    $doCreateTable = true;

    $database->setQuery("SHOW TABLES LIKE '".$database->getPrefix()."virtuemart_magiczoomplus_config'");
    $results = $database->loadResult();

    if($results) {
        $doCreateTable = false;
        $database->setQuery("SHOW COLUMNS FROM `#__virtuemart_magiczoomplus_config`");
        $results = $database->loadObjectList();
        $fields = '';
        foreach($results as $column) {
            $fields .= $column->Field.',';
        }
        //NOTE: check for old table
        if($fields != 'id,profile,name,value,default,') {
            $doCreateTable = true;
            $database->setQuery("DROP TABLE IF EXISTS `#__virtuemart_magiczoomplus_config_bak`;");
            $database->execute();
            $database->setQuery("RENAME TABLE `#__virtuemart_magiczoomplus_config` TO `#__virtuemart_magiczoomplus_config_bak`;");
            $database->execute();
        }
    }

    if($doCreateTable) {
        //NOTE: create empty table
        $database->setQuery("
CREATE TABLE IF NOT EXISTS `#__virtuemart_magiczoomplus_config` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `profile` VARCHAR(128) NOT NULL DEFAULT '',
    `name` VARCHAR(128) NOT NULL DEFAULT '',
    `value` TEXT,
    `default` TEXT,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
");
        $database->execute();
    }

    $database->setQuery("SELECT COUNT(*) as `count` FROM `#__virtuemart_magiczoomplus_config` LIMIT 1");
    $results = $database->loadObject();
    if($results->count == 0) {
        $query = <<<SQL
INSERT INTO `#__virtuemart_magiczoomplus_config` (`profile`, `name`, `value`, `default`) VALUES
 ('default', 'enable-effect', 'No', 'No'),
 ('default', 'template', 'bottom', 'bottom'),
 ('default', 'magicscroll', 'No', 'No'),
 ('default', 'thumb-max-width', '450', '450'),
 ('default', 'thumb-max-height', '450', '450'),
 ('default', 'zoomWidth', 'auto', 'auto'),
 ('default', 'zoomHeight', 'auto', 'auto'),
 ('default', 'zoomPosition', 'right', 'right'),
 ('default', 'zoomDistance', '15', '15'),
 ('default', 'centered-thumbnails', 'Yes', 'Yes'),
 ('default', 'square-images', 'disable', 'disable'),
 ('default', 'selectorTrigger', 'click', 'click'),
 ('default', 'multiple-images', 'Yes', 'Yes'),
 ('default', 'transitionEffect', 'Yes', 'Yes'),
 ('default', 'selector-max-width', '50', '50'),
 ('default', 'selector-max-height', '50', '50'),
 ('default', 'margin-between-thumbs', '1', '1'),
 ('default', 'preserve-additional-thumbnails-positions', 'No', 'No'),
 ('default', 'use-individual-titles', 'Yes', 'Yes'),
 ('default', 'lazyZoom', 'No', 'No'),
 ('default', 'link-to-product-page', 'Yes', 'Yes'),
 ('default', 'rightClick', 'No', 'No'),
 ('default', 'use-original-vm-thumbnails', 'No', 'No'),
 ('default', 'cssClass', '', ''),
 ('default', 'show-message', 'No', 'No'),
 ('default', 'message', 'Move your mouse over image or click to enlarge', 'Move your mouse over image or click to enlarge'),
 ('default', 'imagemagick', 'off', 'off'),
 ('default', 'image-quality', '75', '75'),
 ('default', 'zoomMode', 'zoom', 'zoom'),
 ('default', 'zoomOn', 'hover', 'hover'),
 ('default', 'upscale', 'Yes', 'Yes'),
 ('default', 'smoothing', 'Yes', 'Yes'),
 ('default', 'variableZoom', 'No', 'No'),
 ('default', 'zoomCaption', 'off', 'off'),
 ('default', 'expand', 'window', 'window'),
 ('default', 'expandZoomMode', 'zoom', 'zoom'),
 ('default', 'expandZoomOn', 'click', 'click'),
 ('default', 'expandCaption', 'Yes', 'Yes'),
 ('default', 'closeOnClickOutside', 'Yes', 'Yes'),
 ('default', 'watermark', '', ''),
 ('default', 'watermark-max-width', '30%', '30%'),
 ('default', 'watermark-max-height', '30%', '30%'),
 ('default', 'watermark-opacity', '50', '50'),
 ('default', 'watermark-position', 'center', 'center'),
 ('default', 'watermark-offset-x', '0', '0'),
 ('default', 'watermark-offset-y', '0', '0'),
 ('default', 'hint', 'once', 'once'),
 ('default', 'textHoverZoomHint', 'Hover to zoom', 'Hover to zoom'),
 ('default', 'textClickZoomHint', 'Click to zoom', 'Click to zoom'),
 ('default', 'textExpandHint', 'Click to expand', 'Click to expand'),
 ('default', 'textBtnClose', 'Close', 'Close'),
 ('default', 'textBtnNext', 'Next', 'Next'),
 ('default', 'textBtnPrev', 'Previous', 'Previous'),
 ('default', 'zoomModeForMobile', 'off', 'off'),
 ('default', 'textHoverZoomHintForMobile', 'Touch to zoom', 'Touch to zoom'),
 ('default', 'textClickZoomHintForMobile', 'Double tap or pinch to zoom', 'Double tap or pinch to zoom'),
 ('default', 'textExpandHintForMobile', 'Tap to expand', 'Tap to expand'),
 ('default', 'width', 'auto', 'auto'),
 ('default', 'height', 'auto', 'auto'),
 ('default', 'mode', 'scroll', 'scroll'),
 ('default', 'items', '3', '3'),
 ('default', 'speed', '600', '600'),
 ('default', 'autoplay', '0', '0'),
 ('default', 'loop', 'infinite', 'infinite'),
 ('default', 'step', 'auto', 'auto'),
 ('default', 'arrows', 'inside', 'inside'),
 ('default', 'pagination', 'No', 'No'),
 ('default', 'easing', 'cubic-bezier(.8, 0, .5, 1)', 'cubic-bezier(.8, 0, .5, 1)'),
 ('default', 'scrollOnWheel', 'auto', 'auto'),
 ('default', 'lazy-load', 'No', 'No'),
 ('default', 'scroll-extra-styles', '', ''),
 ('default', 'show-image-title', 'No', 'No'),
 ('browse', 'enable-effect', 'No', 'No'),
 ('browse', 'thumb-max-width', '450', '450'),
 ('browse', 'thumb-max-height', '450', '450'),
 ('browse', 'zoomWidth', 'auto', 'auto'),
 ('browse', 'zoomHeight', 'auto', 'auto'),
 ('browse', 'zoomPosition', 'inner', 'inner'),
 ('browse', 'zoomDistance', '15', '15'),
 ('browse', 'centered-thumbnails', 'Yes', 'Yes'),
 ('browse', 'square-images', 'disable', 'disable'),
 ('browse', 'lazyZoom', 'No', 'No'),
 ('browse', 'link-to-product-page', 'No', 'No'),
 ('browse', 'rightClick', 'No', 'No'),
 ('browse', 'use-original-vm-thumbnails', 'No', 'No'),
 ('browse', 'cssClass', '', ''),
 ('browse', 'show-message', 'No', 'No'),
 ('browse', 'message', 'Click to zoom', 'Click to zoom'),
 ('browse', 'imagemagick', 'off', 'off'),
 ('browse', 'image-quality', '75', '75'),
 ('browse', 'zoomMode', 'zoom', 'zoom'),
 ('browse', 'zoomOn', 'click', 'click'),
 ('browse', 'upscale', 'Yes', 'Yes'),
 ('browse', 'smoothing', 'Yes', 'Yes'),
 ('browse', 'variableZoom', 'No', 'No'),
 ('browse', 'zoomCaption', 'off', 'off'),
 ('browse', 'expand', 'off', 'off'),
 ('browse', 'expandZoomMode', 'zoom', 'zoom'),
 ('browse', 'expandZoomOn', 'click', 'click'),
 ('browse', 'expandCaption', 'Yes', 'Yes'),
 ('browse', 'closeOnClickOutside', 'Yes', 'Yes'),
 ('browse', 'watermark', '', ''),
 ('browse', 'watermark-max-width', '30%', '30%'),
 ('browse', 'watermark-max-height', '30%', '30%'),
 ('browse', 'watermark-opacity', '50', '50'),
 ('browse', 'watermark-position', 'center', 'center'),
 ('browse', 'watermark-offset-x', '0', '0'),
 ('browse', 'watermark-offset-y', '0', '0'),
 ('browse', 'hint', 'once', 'once'),
 ('browse', 'textHoverZoomHint', 'Hover to zoom', 'Hover to zoom'),
 ('browse', 'textClickZoomHint', 'Click to zoom', 'Click to zoom'),
 ('browse', 'textExpandHint', 'Click to expand', 'Click to expand'),
 ('browse', 'textBtnClose', 'Close', 'Close'),
 ('browse', 'textBtnNext', 'Next', 'Next'),
 ('browse', 'textBtnPrev', 'Previous', 'Previous'),
 ('browse', 'zoomModeForMobile', 'off', 'off'),
 ('browse', 'textHoverZoomHintForMobile', 'Touch to zoom', 'Touch to zoom'),
 ('browse', 'textClickZoomHintForMobile', 'Double tap or pinch to zoom', 'Double tap or pinch to zoom'),
 ('browse', 'textExpandHintForMobile', 'Tap to expand', 'Tap to expand'),
 ('details', 'enable-effect', 'Yes', 'Yes'),
 ('details', 'template', 'bottom', 'bottom'),
 ('details', 'magicscroll', 'No', 'No'),
 ('details', 'thumb-max-width', '450', '450'),
 ('details', 'thumb-max-height', '450', '450'),
 ('details', 'zoomWidth', 'auto', 'auto'),
 ('details', 'zoomHeight', 'auto', 'auto'),
 ('details', 'zoomPosition', 'right', 'right'),
 ('details', 'zoomDistance', '15', '15'),
 ('details', 'centered-thumbnails', 'Yes', 'Yes'),
 ('details', 'square-images', 'disable', 'disable'),
 ('details', 'selectorTrigger', 'click', 'click'),
 ('details', 'multiple-images', 'Yes', 'Yes'),
 ('details', 'transitionEffect', 'Yes', 'Yes'),
 ('details', 'selector-max-width', '50', '50'),
 ('details', 'selector-max-height', '50', '50'),
 ('details', 'margin-between-thumbs', '1', '1'),
 ('details', 'preserve-additional-thumbnails-positions', 'No', 'No'),
 ('details', 'use-individual-titles', 'Yes', 'Yes'),
 ('details', 'lazyZoom', 'No', 'No'),
 ('details', 'rightClick', 'No', 'No'),
 ('details', 'use-original-vm-thumbnails', 'No', 'No'),
 ('details', 'cssClass', '', ''),
 ('details', 'show-message', 'No', 'No'),
 ('details', 'message', 'Move your mouse over image or click to enlarge', 'Move your mouse over image or click to enlarge'),
 ('details', 'imagemagick', 'off', 'off'),
 ('details', 'image-quality', '75', '75'),
 ('details', 'zoomMode', 'zoom', 'zoom'),
 ('details', 'zoomOn', 'hover', 'hover'),
 ('details', 'upscale', 'Yes', 'Yes'),
 ('details', 'smoothing', 'Yes', 'Yes'),
 ('details', 'variableZoom', 'No', 'No'),
 ('details', 'zoomCaption', 'off', 'off'),
 ('details', 'expand', 'window', 'window'),
 ('details', 'expandZoomMode', 'zoom', 'zoom'),
 ('details', 'expandZoomOn', 'click', 'click'),
 ('details', 'expandCaption', 'Yes', 'Yes'),
 ('details', 'closeOnClickOutside', 'Yes', 'Yes'),
 ('details', 'watermark', '', ''),
 ('details', 'watermark-max-width', '30%', '30%'),
 ('details', 'watermark-max-height', '30%', '30%'),
 ('details', 'watermark-opacity', '50', '50'),
 ('details', 'watermark-position', 'center', 'center'),
 ('details', 'watermark-offset-x', '0', '0'),
 ('details', 'watermark-offset-y', '0', '0'),
 ('details', 'hint', 'once', 'once'),
 ('details', 'textHoverZoomHint', 'Hover to zoom', 'Hover to zoom'),
 ('details', 'textClickZoomHint', 'Click to zoom', 'Click to zoom'),
 ('details', 'textExpandHint', 'Click to expand', 'Click to expand'),
 ('details', 'textBtnClose', 'Close', 'Close'),
 ('details', 'textBtnNext', 'Next', 'Next'),
 ('details', 'textBtnPrev', 'Previous', 'Previous'),
 ('details', 'zoomModeForMobile', 'off', 'off'),
 ('details', 'textHoverZoomHintForMobile', 'Touch to zoom', 'Touch to zoom'),
 ('details', 'textClickZoomHintForMobile', 'Double tap or pinch to zoom', 'Double tap or pinch to zoom'),
 ('details', 'textExpandHintForMobile', 'Tap to expand', 'Tap to expand'),
 ('details', 'width', 'auto', 'auto'),
 ('details', 'height', 'auto', 'auto'),
 ('details', 'mode', 'scroll', 'scroll'),
 ('details', 'items', '3', '3'),
 ('details', 'speed', '600', '600'),
 ('details', 'autoplay', '0', '0'),
 ('details', 'loop', 'infinite', 'infinite'),
 ('details', 'step', 'auto', 'auto'),
 ('details', 'arrows', 'inside', 'inside'),
 ('details', 'pagination', 'No', 'No'),
 ('details', 'easing', 'cubic-bezier(.8, 0, .5, 1)', 'cubic-bezier(.8, 0, .5, 1)'),
 ('details', 'scrollOnWheel', 'auto', 'auto'),
 ('details', 'lazy-load', 'No', 'No'),
 ('details', 'scroll-extra-styles', '', ''),
 ('details', 'show-image-title', 'No', 'No'),
 ('default', 'version', '4.11.1', '4.11.1');
SQL;
        $database->setQuery($query);
        if(!$database->execute()) {
            return JError::raiseWarning(500, $database->getError());
        }
    }

    $url = 'index.php?option=com_virtuemart_magiczoomplus&task=install';
?>
<style>
.magictoolbox-message-container h1 {
    color: #468847;
}
.magictoolbox-message-container {
    color: #468847;   
    background-color: #DFF0D8;
    border: 1px solid #D6E9C6;
    border-radius: 4px;
    margin-bottom: 18px;
    padding: 8px 35px 8px 14px;
    text-shadow: 0 1px 0 rgba(255, 255, 255, 0.5);
}
</style>
<div class="magictoolbox-message-container">
<h1>Please wait...</h1>
<h2>The plugin will be installed automatically...</h2>
<h2>Please click <a href="<?php echo $url; ?>" style="color: black;">here</a> if you are not automatically redirected within <span id="redirect_timer">3</span> seconds</h2>
<script language="javascript" type="text/javascript">
var intervalCounter = 3;
var intervalID = setInterval(function() {
    if(intervalCounter) {
        intervalCounter--;
        document.getElementById('redirect_timer').innerHTML = intervalCounter;
    }
    if(!intervalCounter) {
        clearInterval(intervalID);
        document.location.href = '<?php echo $url; ?>';
    }
}, 1000);
</script>
</div>
<?php
    sendVirtueMartMagiczoomplusModuleStat('install');
    return true;
}

function uninstallMagiczoomplusForVirtueMart() {

    if(version_compare(JVERSION, '1.6.0', '<')) {
        //NOTE: need to load lang file for uninstall string
        $lang = JFactory::getLanguage();
        $lang->load('com_virtuemart_magiczoomplus', JPATH_ADMINISTRATOR, null, false);
    }

    $database = JFactory::getDBO();

    //NOTE: uninstall plugin
    if(version_compare(JVERSION, '1.6.0', '<')) {
        $query = "DELETE FROM `#__plugins` WHERE element='vmmagiczoomplus'";
    } else {
        $query = "DELETE FROM `#__extensions` WHERE element='vmmagiczoomplus'";
    }
    $database->setQuery($query);
    $database->execute();

    if(is_file(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_vmmagiczoomplus.ini')) {
        JFile::delete(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_vmmagiczoomplus.ini');
    }
    if(is_file(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_vmmagiczoomplus.sys.ini')) {
        JFile::delete(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_vmmagiczoomplus.sys.ini');
    }
    if(is_dir(JPATH_SITE.DS.'media'.DS.'plg_system_vmmagiczoomplus')) {
        JFolder::delete(JPATH_SITE.DS.'media'.DS.'plg_system_vmmagiczoomplus');
    }
    if(version_compare(JVERSION, '1.6.0', '<')) {
        if(is_dir(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagiczoomplus')) {
            JFolder::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagiczoomplus');
        }
        if(is_file(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagiczoomplus.php')) {
            JFile::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagiczoomplus.php');
        }
        if(is_file(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagiczoomplus.xml')) {
            JFile::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagiczoomplus.xml');
        }
    } else {
        if(is_dir(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagiczoomplus')) {
            JFolder::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagiczoomplus');
        }
    }


    echo '<div style="background-color: #C3D2E5;">
          <p style="color: #0055BB;font-weight: bold;">'.JText::_('COM_VIRTUEMART_MAGICZOOMPLUS_UNINSTALL_TEXT').'</p>
          </div>';

    sendVirtueMartMagiczoomplusModuleStat('uninstall');
    return true;

}

class com_virtuemart_magiczoomplusInstallerScript {

    function preflight($type, $parent) {
        return true;
    }

    function install($parent) {
        return installMagiczoomplusForVirtueMart();
    }

    function update($parent) {
        return installMagiczoomplusForVirtueMart();
    }

    function uninstall($parent) {
        return uninstallMagiczoomplusForVirtueMart();
    }

    function postflight($type, $parent) {
        return true;
    }

}

function sendVirtueMartMagiczoomplusModuleStat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v4.11.1' || 'working' == 'v5.3.7') {
        return;
    }

    /*

    $hostname = 'www.magictoolbox.com';

    $url = $_SERVER['HTTP_HOST'].JURI::root(true);
    $url = urlencode(urldecode($url));

    $platformVersion = '';
    if(file_exists(JPATH_BASE.DS.'components'.DS.'com_virtuemart'.DS.'version.php')) {
        include JPATH_BASE.DS.'components'.DS.'com_virtuemart'.DS.'version.php';
        if(!isset($shortversion)) {
            $vmVersion = new vmVersion();
            $shortversion = vmVersion::$shortversion;
        }
        $platformVersion = preg_replace('/^[a-zA-Z]+\s+(\d+(?:\.\d+)*).*?$/is', '$1', $shortversion);
    }

    $path = "api/stat/?action={$action}&tool_name=magiczoomplus&license=trial&tool_version=v5.3.7&module_version=v4.11.1&platform_name=virtuemart15&platform_version={$platformVersion}&url={$url}";

    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }

    */

}
