<?php

/*------------------------------------------------------------------------
# com_virtuemart_magicthumb - Magic Thumb for Joomla with VirtueMart
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magicthumb/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

require_once JPATH_COMPONENT.DS.'helpers'.DS.'helper.php';

//NOTE: Import joomla view library
jimport('joomla.application.component.view');

if(!defined('MAGICTOOLBOX_LEGACY_VIEW_DEFINED')) {
    define('MAGICTOOLBOX_LEGACY_VIEW_DEFINED', true);
    if(JVERSION_256) {
        class MagicToolboxLegacyView extends JViewLegacy {}
    } else {
        class MagicToolboxLegacyView extends JView {}
    }
}

class Virtuemart_MagicthumbViewDefault extends MagicToolboxLegacyView {

    function display($tpl = null) {

        if (JVERSION>'4') {
            $app = JFactory::getApplication();
            $app->input->set('hidemainmenu' , true );
            $this->profile = $app->input->get('profile' , false, 'get' );
        } else {
            JRequest::setVar('hidemainmenu', true);
            $this->profile = JRequest::getVar('profile', false, 'get');
        }

        $this->profiles = array('default' => 'Default values', 'browse' => 'Category browse page', 'details' => 'Product details page');

        $title = JText::_('COM_VIRTUEMART_MAGICTHUMB_MANAGER_SETTINGS');
        if($this->profile) {
            $title .= ' - '.$this->profiles[$this->profile];
        }
        JToolBarHelper::title($title, 'magicthumb.png');

        if($this->profile) {
            JToolBarHelper::save('save');//Save & Close
            JToolBarHelper::apply('apply');//Save
        }
        JToolBarHelper::cancel('cancel', 'Close');//Close

        require_once(JPATH_COMPONENT.DS.'virtuemart_plugin'.DS.'site'.DS.'vmmagicthumb'.DS.'classes'.DS.'magicthumb.module.core.class.php');
        //$classesFolded = JVERSION_16 ? 'vmmagicthumb'.DS.'vmmagicthumb'.DS.'classes' : 'vmmagicthumb'.DS.'classes';
        //require_once(JPATH_SITE.DS.'plugins'.DS.'system'.DS.$classesFolded.DS.'magicthumb.module.core.class.php');

        $this->tool = new MagicThumbModuleCoreClass();
        $database = JFactory::getDBO();
        $database->setQuery("SELECT `profile`, `name`, `value` FROM `#__virtuemart_magicthumb_config`");
        $results = $database->loadAssocList();
        if(!empty($results)) {
            foreach($results as $row) {
                $this->tool->params->setValue($row['name'], $row['value'], $row['profile']);
            }
        }

        $this->imageUrl = JURI::root().'media/com_virtuemart_magicthumb/images/';
        $this->paramsMap = array(
			'default' => array(
				'General' => array(
					'enable-effect',
					'template',
					'magicscroll',
				),
				'Positioning and Geometry' => array(
					'thumb-max-width',
					'thumb-max-height',
					'centered-thumbnails',
					'square-images',
				),
				'Expanded view' => array(
					'expandEffect',
					'expandSpeed',
					'expandImageSize',
					'expandTrigger',
					'expandAlign',
					'expandEasing',
					'gallerySpeed',
				),
				'Multiple images' => array(
					'multiple-images',
					'selector-max-width',
					'selector-max-height',
					'margin-between-thumbs',
					'preserve-additional-thumbnails-positions',
					'use-individual-titles',
					'selectorTrigger',
					'selectorEffect',
				),
				'Title and Caption' => array(
					'show-caption',
					'captionPosition',
				),
				'Miscellaneous' => array(
					'link-to-product-page',
					'use-original-vm-thumbnails',
					'keyboard',
					'cssClass',
					'rightClick',
					'lazyLoad',
					'autostart',
					'imagemagick',
					'image-quality',
				),
				'Buttons' => array(
					'buttons',
					'textBtnClose',
					'textBtnNext',
					'textBtnPrev',
				),
				'Watermark' => array(
					'watermark',
					'watermark-max-width',
					'watermark-max-height',
					'watermark-opacity',
					'watermark-position',
					'watermark-offset-x',
					'watermark-offset-y',
				),
				'Hint' => array(
					'hint',
					'textClickHint',
					'textHoverHint',
				),
				'Mobile' => array(
					'slideMobileEffect',
					'textClickHintForMobile',
				),
				'Scroll' => array(
					'width',
					'height',
					'mode',
					'items',
					'speed',
					'autoplay',
					'loop',
					'step',
					'arrows',
					'pagination',
					'easing',
					'scrollOnWheel',
					'lazy-load',
					'scroll-extra-styles',
					'show-image-title',
				),
			),
			'browse' => array(
				'General' => array(
					'enable-effect',
				),
				'Positioning and Geometry' => array(
					'thumb-max-width',
					'thumb-max-height',
					'centered-thumbnails',
					'square-images',
				),
				'Expanded view' => array(
					'expandEffect',
					'expandSpeed',
					'expandImageSize',
					'expandTrigger',
					'expandAlign',
					'expandEasing',
					'gallerySpeed',
				),
				'Title and Caption' => array(
					'show-caption',
					'captionPosition',
				),
				'Miscellaneous' => array(
					'link-to-product-page',
					'use-original-vm-thumbnails',
					'keyboard',
					'cssClass',
					'rightClick',
					'lazyLoad',
					'autostart',
					'imagemagick',
					'image-quality',
				),
				'Buttons' => array(
					'buttons',
					'textBtnClose',
					'textBtnNext',
					'textBtnPrev',
				),
				'Watermark' => array(
					'watermark',
					'watermark-max-width',
					'watermark-max-height',
					'watermark-opacity',
					'watermark-position',
					'watermark-offset-x',
					'watermark-offset-y',
				),
				'Hint' => array(
					'hint',
					'textClickHint',
					'textHoverHint',
				),
				'Mobile' => array(
					'slideMobileEffect',
					'textClickHintForMobile',
				),
			),
			'details' => array(
				'General' => array(
					'enable-effect',
					'template',
					'magicscroll',
				),
				'Positioning and Geometry' => array(
					'thumb-max-width',
					'thumb-max-height',
					'centered-thumbnails',
					'square-images',
				),
				'Expanded view' => array(
					'expandEffect',
					'expandSpeed',
					'expandImageSize',
					'expandTrigger',
					'expandAlign',
					'expandEasing',
					'gallerySpeed',
				),
				'Multiple images' => array(
					'multiple-images',
					'selector-max-width',
					'selector-max-height',
					'margin-between-thumbs',
					'preserve-additional-thumbnails-positions',
					'use-individual-titles',
					'selectorTrigger',
					'selectorEffect',
				),
				'Title and Caption' => array(
					'show-caption',
					'captionPosition',
				),
				'Miscellaneous' => array(
					'use-original-vm-thumbnails',
					'keyboard',
					'cssClass',
					'rightClick',
					'lazyLoad',
					'autostart',
					'imagemagick',
					'image-quality',
				),
				'Buttons' => array(
					'buttons',
					'textBtnClose',
					'textBtnNext',
					'textBtnPrev',
				),
				'Watermark' => array(
					'watermark',
					'watermark-max-width',
					'watermark-max-height',
					'watermark-opacity',
					'watermark-position',
					'watermark-offset-x',
					'watermark-offset-y',
				),
				'Hint' => array(
					'hint',
					'textClickHint',
					'textHoverHint',
				),
				'Mobile' => array(
					'slideMobileEffect',
					'textClickHintForMobile',
				),
				'Scroll' => array(
					'width',
					'height',
					'mode',
					'items',
					'speed',
					'autoplay',
					'loop',
					'step',
					'arrows',
					'pagination',
					'easing',
					'scrollOnWheel',
					'lazy-load',
					'scroll-extra-styles',
					'show-image-title',
				),
			),
		);
        $this->groups = array();
        foreach($this->paramsMap as $profileId => $groups) {
            foreach($groups as $groupName => $params) {
                if(!isset($this->groups[$groupName])) $this->groups[$groupName] = array();
                $_params = array();
                foreach($params as $param) {
                    $_params[$param] = '';
                }
                $this->groups[$groupName] = array_merge($this->groups[$groupName], $_params);
            }
        }

        if($this->profile) {
            $tpl = 'edit';
        }

        parent::display($tpl);

    }

}
