<?php

/*------------------------------------------------------------------------
# com_virtuemart_magic360 - Magic 360 for Joomla with VirtueMart
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magic360/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

if(!function_exists('com_install')) {
    function com_install() {
        return installMagic360ForVirtueMart();
    }
}

if(!function_exists('com_uninstall')) {
    function com_uninstall() {
        return uninstallMagic360ForVirtueMart();
    }
}

function installMagic360ForVirtueMart() {

    $database = JFactory::getDBO();

    $doCreateTable = true;

    $database->setQuery("SHOW TABLES LIKE '".$database->getPrefix()."virtuemart_magic360_config'");
    $results = $database->loadResult();

    if($results) {
        $doCreateTable = false;
        $database->setQuery("SHOW COLUMNS FROM `#__virtuemart_magic360_config`");
        $results = $database->loadObjectList();
        $fields = '';
        foreach($results as $column) {
            $fields .= $column->Field.',';
        }
        //NOTE: check for old table
        if($fields != 'id,profile,name,value,default,') {
            $doCreateTable = true;
            $database->setQuery("DROP TABLE IF EXISTS `#__virtuemart_magic360_config_bak`;");
            $database->execute();
            $database->setQuery("RENAME TABLE `#__virtuemart_magic360_config` TO `#__virtuemart_magic360_config_bak`;");
            $database->execute();
        }
    }

    if($doCreateTable) {
        //NOTE: create empty table
        $database->setQuery("
CREATE TABLE IF NOT EXISTS `#__virtuemart_magic360_config` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `profile` VARCHAR(128) NOT NULL DEFAULT '',
    `name` VARCHAR(128) NOT NULL DEFAULT '',
    `value` TEXT,
    `default` TEXT,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
");
        $database->execute();
    }

    $database->setQuery("SELECT COUNT(*) as `count` FROM `#__virtuemart_magic360_config` LIMIT 1");
    $results = $database->loadObject();
    if($results->count == 0) {
        $query = <<<SQL
INSERT INTO `#__virtuemart_magic360_config` (`profile`, `name`, `value`, `default`) VALUES
 ('default', 'enable-effect', 'No', 'No'),
 ('default', 'product-ids', 'all', 'all'),
 ('default', 'columns', '36', '36'),
 ('default', 'magnify', 'Yes', 'Yes'),
 ('default', 'magnifier-width', '80%', '80%'),
 ('default', 'magnifier-shape', 'inner', 'inner'),
 ('default', 'fullscreen', 'Yes', 'Yes'),
 ('default', 'spin', 'drag', 'drag'),
 ('default', 'autospin-direction', 'clockwise', 'clockwise'),
 ('default', 'sensitivityX', '50', '50'),
 ('default', 'sensitivityY', '50', '50'),
 ('default', 'mousewheel-step', '1', '1'),
 ('default', 'autospin-speed', '3600', '3600'),
 ('default', 'smoothing', 'Yes', 'Yes'),
 ('default', 'autospin', 'once', 'once'),
 ('default', 'autospin-start', 'load,hover', 'load,hover'),
 ('default', 'autospin-stop', 'click', 'click'),
 ('default', 'initialize-on', 'load', 'load'),
 ('default', 'start-column', '1', '1'),
 ('default', 'start-row', 'auto', 'auto'),
 ('default', 'loop-column', 'Yes', 'Yes'),
 ('default', 'loop-row', 'No', 'No'),
 ('default', 'reverse-column', 'No', 'No'),
 ('default', 'reverse-row', 'No', 'No'),
 ('default', 'column-increment', '1', '1'),
 ('default', 'row-increment', '1', '1'),
 ('default', 'thumb-max-width', '450', '450'),
 ('default', 'thumb-max-height', '450', '450'),
 ('default', 'square-images', 'disable', 'disable'),
 ('default', 'show-message', 'Yes', 'Yes'),
 ('default', 'message', 'Drag image to spin', 'Drag image to spin'),
 ('default', 'loading-text', 'Loading...', 'Loading...'),
 ('default', 'fullscreen-loading-text', 'Loading large spin...', 'Loading large spin...'),
 ('default', 'hint', 'Yes', 'Yes'),
 ('default', 'hint-text', 'Drag to spin', 'Drag to spin'),
 ('default', 'mobile-hint-text', 'Swipe to spin', 'Swipe to spin'),
 ('default', 'imagemagick', 'off', 'off'),
 ('default', 'image-quality', '75', '75'),
 ('default', 'watermark', '', ''),
 ('default', 'watermark-max-width', '30%', '30%'),
 ('default', 'watermark-max-height', '30%', '30%'),
 ('default', 'watermark-opacity', '50', '50'),
 ('default', 'watermark-position', 'center', 'center'),
 ('default', 'watermark-offset-x', '0', '0'),
 ('default', 'watermark-offset-y', '0', '0'),
 ('details', 'enable-effect', 'Yes', 'Yes'),
 ('details', 'product-ids', 'all', 'all'),
 ('details', 'columns', '36', '36'),
 ('details', 'magnify', 'Yes', 'Yes'),
 ('details', 'magnifier-width', '80%', '80%'),
 ('details', 'magnifier-shape', 'inner', 'inner'),
 ('details', 'fullscreen', 'Yes', 'Yes'),
 ('details', 'spin', 'drag', 'drag'),
 ('details', 'autospin-direction', 'clockwise', 'clockwise'),
 ('details', 'sensitivityX', '50', '50'),
 ('details', 'sensitivityY', '50', '50'),
 ('details', 'mousewheel-step', '1', '1'),
 ('details', 'autospin-speed', '3600', '3600'),
 ('details', 'smoothing', 'Yes', 'Yes'),
 ('details', 'autospin', 'once', 'once'),
 ('details', 'autospin-start', 'load,hover', 'load,hover'),
 ('details', 'autospin-stop', 'click', 'click'),
 ('details', 'initialize-on', 'load', 'load'),
 ('details', 'start-column', '1', '1'),
 ('details', 'start-row', 'auto', 'auto'),
 ('details', 'loop-column', 'Yes', 'Yes'),
 ('details', 'loop-row', 'No', 'No'),
 ('details', 'reverse-column', 'No', 'No'),
 ('details', 'reverse-row', 'No', 'No'),
 ('details', 'column-increment', '1', '1'),
 ('details', 'row-increment', '1', '1'),
 ('details', 'thumb-max-width', '450', '450'),
 ('details', 'thumb-max-height', '450', '450'),
 ('details', 'square-images', 'disable', 'disable'),
 ('details', 'show-message', 'Yes', 'Yes'),
 ('details', 'message', 'Drag image to spin', 'Drag image to spin'),
 ('details', 'loading-text', 'Loading...', 'Loading...'),
 ('details', 'fullscreen-loading-text', 'Loading large spin...', 'Loading large spin...'),
 ('details', 'hint', 'Yes', 'Yes'),
 ('details', 'hint-text', 'Drag to spin', 'Drag to spin'),
 ('details', 'mobile-hint-text', 'Swipe to spin', 'Swipe to spin'),
 ('details', 'imagemagick', 'off', 'off'),
 ('details', 'image-quality', '75', '75'),
 ('details', 'watermark', '', ''),
 ('details', 'watermark-max-width', '30%', '30%'),
 ('details', 'watermark-max-height', '30%', '30%'),
 ('details', 'watermark-opacity', '50', '50'),
 ('details', 'watermark-position', 'center', 'center'),
 ('details', 'watermark-offset-x', '0', '0'),
 ('details', 'watermark-offset-y', '0', '0'),
 ('default', 'version', '4.11.1', '4.11.1');
SQL;
        $database->setQuery($query);
        if(!$database->execute()) {
            return JError::raiseWarning(500, $database->getError());
        }
    }

    $url = 'index.php?option=com_virtuemart_magic360&task=install';
?>
<style>
.magictoolbox-message-container h1 {
    color: #468847;
}
.magictoolbox-message-container {
    color: #468847;   
    background-color: #DFF0D8;
    border: 1px solid #D6E9C6;
    border-radius: 4px;
    margin-bottom: 18px;
    padding: 8px 35px 8px 14px;
    text-shadow: 0 1px 0 rgba(255, 255, 255, 0.5);
}
</style>
<div class="magictoolbox-message-container">
<h1>Please wait...</h1>
<h2>The plugin will be installed automatically...</h2>
<h2>Please click <a href="<?php echo $url; ?>" style="color: black;">here</a> if you are not automatically redirected within <span id="redirect_timer">3</span> seconds</h2>
<script language="javascript" type="text/javascript">
var intervalCounter = 3;
var intervalID = setInterval(function() {
    if(intervalCounter) {
        intervalCounter--;
        document.getElementById('redirect_timer').innerHTML = intervalCounter;
    }
    if(!intervalCounter) {
        clearInterval(intervalID);
        document.location.href = '<?php echo $url; ?>';
    }
}, 1000);
</script>
</div>
<?php
    sendVirtueMartMagic360ModuleStat('install');
    return true;
}

function uninstallMagic360ForVirtueMart() {

    if(version_compare(JVERSION, '1.6.0', '<')) {
        //NOTE: need to load lang file for uninstall string
        $lang = JFactory::getLanguage();
        $lang->load('com_virtuemart_magic360', JPATH_ADMINISTRATOR, null, false);
    }

    $database = JFactory::getDBO();

    //NOTE: uninstall plugin
    if(version_compare(JVERSION, '1.6.0', '<')) {
        $query = "DELETE FROM `#__plugins` WHERE element='vmmagic360'";
    } else {
        $query = "DELETE FROM `#__extensions` WHERE element='vmmagic360'";
    }
    $database->setQuery($query);
    $database->execute();

    if(is_file(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_vmmagic360.ini')) {
        JFile::delete(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_vmmagic360.ini');
    }
    if(is_file(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_vmmagic360.sys.ini')) {
        JFile::delete(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_vmmagic360.sys.ini');
    }
    if(is_dir(JPATH_SITE.DS.'media'.DS.'plg_system_vmmagic360')) {
        JFolder::delete(JPATH_SITE.DS.'media'.DS.'plg_system_vmmagic360');
    }
    if(version_compare(JVERSION, '1.6.0', '<')) {
        if(is_dir(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagic360')) {
            JFolder::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagic360');
        }
        if(is_file(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagic360.php')) {
            JFile::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagic360.php');
        }
        if(is_file(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagic360.xml')) {
            JFile::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagic360.xml');
        }
    } else {
        if(is_dir(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagic360')) {
            JFolder::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagic360');
        }
    }


    echo '<div style="background-color: #C3D2E5;">
          <p style="color: #0055BB;font-weight: bold;">'.JText::_('COM_VIRTUEMART_MAGIC360_UNINSTALL_TEXT').'</p>
          </div>';

    sendVirtueMartMagic360ModuleStat('uninstall');
    return true;

}

class com_virtuemart_magic360InstallerScript {

    function preflight($type, $parent) {
        return true;
    }

    function install($parent) {
        return installMagic360ForVirtueMart();
    }

    function update($parent) {
        return installMagic360ForVirtueMart();
    }

    function uninstall($parent) {
        return uninstallMagic360ForVirtueMart();
    }

    function postflight($type, $parent) {
        return true;
    }

}

function sendVirtueMartMagic360ModuleStat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v4.11.1' || 'working' == 'v4.6.13') {
        return;
    }

    /*

    $hostname = 'www.magictoolbox.com';

    $url = $_SERVER['HTTP_HOST'].JURI::root(true);
    $url = urlencode(urldecode($url));

    $platformVersion = '';
    if(file_exists(JPATH_BASE.DS.'components'.DS.'com_virtuemart'.DS.'version.php')) {
        include JPATH_BASE.DS.'components'.DS.'com_virtuemart'.DS.'version.php';
        if(!isset($shortversion)) {
            $vmVersion = new vmVersion();
            $shortversion = vmVersion::$shortversion;
        }
        $platformVersion = preg_replace('/^[a-zA-Z]+\s+(\d+(?:\.\d+)*).*?$/is', '$1', $shortversion);
    }

    $path = "api/stat/?action={$action}&tool_name=magic360&license=trial&tool_version=v4.6.13&module_version=v4.11.1&platform_name=virtuemart15&platform_version={$platformVersion}&url={$url}";

    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }

    */

}
