<?php

/*------------------------------------------------------------------------
# com_virtuemart_magiczoom - Magic Zoom for Joomla with VirtueMart
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magiczoom/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

//ini_set('display_errors', true );
//error_reporting(E_ALL & ~E_NOTICE);

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

if(!defined('MAGICTOOLBOX_JURI_BASE')) {
    $url = JURI::base(true);//NOTE: without / at the end
    //NOTE: JURI::base() return URI according to $live_site variable in configuration
    //      this leads to problem with wrong protocol prefix (http/https)
    //      so this is a fix
    if(empty($_SERVER['HTTPS']) || (strtolower($_SERVER['HTTPS']) == 'off')) {
        $url = preg_replace('#^https:#i', 'http:', $url);
    } else {
        $url = preg_replace('#^http:#i', 'https:', $url);
    }
    define('MAGICTOOLBOX_JURI_BASE', $url);
}

class PlgSystemVMMagicZoom extends JPlugin {

    protected static $instance = null;

    protected $magiczoomSupportedBlocks = array('default', 'browse', 'details');

    public function __construct(&$subject, $config = array()) {
        parent::__construct($subject, $config);
        if(is_null(self::$instance)) {
            self::$instance = $this;
        }
        //$this->loadLanguage();

        //$vmXML = file_get_contents(JPATH_ADMINISTRATOR.'/components/com_virtuemart/virtuemart.xml');
        //$vmVersion = preg_replace('#^.*?<version[^>]*>(.*?)<\/version>.*#', '$1', $vmXML);
    }

    public static function getInstance() {
        if(is_null(self::$instance)) {
            self::$instance = new PlgSystemVMMagicZoom(JEventDispatcher::getInstance(), JPluginHelper::getPlugin('system', 'vmmagiczoom'));
        }
        return self::$instance;
    }

    public function onAfterRender() {

        $app = JFactory::getApplication();
        if ($app->isClient('administrator')) return;

        //NOTE: is this VirtueMart component page?
        if(!class_exists('vmVersion')) return true;

        
        //if(empty($view)) $view = trim(JRequest::getVar('view', '', 'get'));

        if (JVERSION>'4') {
            $app = JFactory::getApplication();
            $view = trim($app->input->getCmd('view', ''));
            $option = trim($app->input->getCmd('option', ''));
        } else {
            $view = trim(JRequest::getVar('view', ''));
            $option = trim(JRequest::getVar('option', '', 'post'));
        }        
        //category, productdetails

        //$page = trim(JRequest::getVar('page', ''));
        //if(empty($page)) $page = trim(JRequest::getVar('page', '', 'get'));


        $page = '';
        if($view == 'category' || $option == 'com_customfilters') $page = 'browse';
        //if($view == 'productdetails'/* || $view == 'shop.cart'*/) $page = 'details';
        if($view == 'productdetails' || !empty($_REQUEST['virtuemart_product_id'])/* || $view == 'shop.cart'*/) $page = 'details';

        $tool = $this->getToolObj();

        if(!in_array($page, $this->magiczoomSupportedBlocks) || $tool->params->checkValue('enable-effect', 'No', $page)) {
            return true;
        }

        $tool->params->setProfile($page);

        $contents = $app->getBody();

        //or
        //$contents = $app->getBody();
        //or
        //$jApplicationSite = JApplicationSite::getInstance('site');    
        //$contents = $jApplicationSite->getBody();
        $showHeaders = false;

        switch($page) {
            case 'details'://product

                if (JVERSION>'4') {
                    $app = JFactory::getApplication();
                    $virtuemart_product_id = trim($app->input->getCmd('virtuemart_product_id', ''));
                } else {
                    $virtuemart_product_id = JRequest::getVar('virtuemart_product_id', 0);
                }        

                if(is_array($virtuemart_product_id) and count($virtuemart_product_id) > 0) {
                    $virtuemart_product_id = (int)$virtuemart_product_id[0];
                } else {
                    $virtuemart_product_id = (int)$virtuemart_product_id;
                }

                if(method_exists('VmModel', 'getModel')) {
                    //NOTE: for VirtueMart 2.0.2 and above
                    $productModel = VmModel::getModel('product');
                } else {
                    //NOTE: for VirtueMart 2.0.0
                    $productModel = new VirtueMartModelProduct();
                }
                $product = $productModel->getProduct($virtuemart_product_id, true, true, true, 1);

                if(empty($product->images)) {
                    $productModel->addImages($product);
                }

                if(empty($product->images) && !empty($product->virtuemart_media_id)) {
                    $product->images = $this->getProductMedias($product);
                }


                if(empty($product->images)) return true;
                $image = $product->images[0];

                $useOriginal = $tool->params->checkValue('use-original-vm-thumbnails', 'Yes');

                if($useOriginal) {
                    $img = MAGICTOOLBOX_JURI_BASE.'/'.$image->file_url;
                    $thumb = MAGICTOOLBOX_JURI_BASE.'/'.$image->file_url;
                } else {
                    $thumb = $this->getResizedImage($image->file_url, 'thumb', $virtuemart_product_id);
                    if(empty($thumb)) return true;
                    $img = $this->getResizedImage($image->file_url, 'original', $virtuemart_product_id);
                }

                $title = $product->product_name;
                //$title = empty($product->product_name) ? $image->file_title : $product->product_name;
                $alt = $image->file_title;

                $mainHtml = $tool->getMainTemplate(array(
                    'id' => "Product{$virtuemart_product_id}",
                    'group' => "Product{$virtuemart_product_id}",
                    'img' => $img,
                    'thumb' => $thumb,
                    'title' => $title,
                    'alt' => $alt,
                    'description' => $product->product_desc,
                    'shortDescription' => $product->product_s_desc,
                ));
                $selectorsHtml = array();

                if(count($product->images) > 1) {
                    foreach($product->images as $image) {
                        if($useOriginal) {
                            $img = MAGICTOOLBOX_JURI_BASE.'/'.$image->file_url;
                            $thumb = MAGICTOOLBOX_JURI_BASE.'/'.$image->file_url;
                            $selector = MAGICTOOLBOX_JURI_BASE.'/'.$image->file_url;
                        } else {
                            $thumb = $this->getResizedImage($image->file_url, 'thumb', $virtuemart_product_id);
                            if(empty($thumb)) continue;
                            $img = $this->getResizedImage($image->file_url, 'original', $virtuemart_product_id);
                            $selector = $this->getResizedImage($image->file_url, 'selector', $virtuemart_product_id);
                        }
                        $title = !empty($image->file_description) ? $image->file_description : $product->product_name;
                        $title = true || $tool->params->checkValue('use-individual-titles', 'Yes') ? $title : $product->product_name;


                        $selectorsHtml[] = $tool->getSelectorTemplate(array(
                            'id' => "Product{$virtuemart_product_id}",
                            'img' => $img,
                            'medium' => $thumb,
                            'thumb' => $selector,
                            'title' => $title,
                            'width' => $useOriginal ? $tool->params->getValue('selector-max-width') : '',
                            'height' => $useOriginal ? $tool->params->getValue('selector-max-height') : '',
                        ));
                    }
                }
                $srollTool = $this->getToolObj(true);
                $html = MagicToolboxTemplateHelperClass::render(array(
                    'main' => $mainHtml,
                    'thumbs' => $selectorsHtml,
                    'magicscrollOptions' => $srollTool ? $srollTool->params->serialize(false, '', 'product-magicscroll-options') : '',
                    'pid' => $virtuemart_product_id,
                ));


                if (!empty($GLOBALS['magic360HTML'])) {
                    $html = preg_replace(
                        '#(<a id="[^"]*Product'.$virtuemart_product_id.'".*?</a>)#ims', 
                        '<div data-slide-id="zoom">$1</div><div data-slide-id="spin" style="display:none;">'.$GLOBALS['magic360HTML'].'</div>', 
                        $html
                    );
                    $html = preg_replace('#<a (data-[a-z]{1,}-id)#ims', '<a data-slide-id="zoom" $1', $html);
                    $w = $tool->params->getValue('selector-max-width');
                    $h = $tool->params->getValue('selector-max-height');
                    $spinSelector = '<a href="#" data-slide-id="spin"><img style="max-width:'.$w.'px;max-height:'.$h.'px;" src="//magictoolbox.sirv.com/shopify/icons/icon.spin.12.png"/></a>';
                    $html = preg_replace('#(<div id="MagicToolboxSelectors.*?)</div>#ims', '$1'.$spinSelector.'</div>', $html);
                    $html .= "
                    <script>
                    console.warn('x');
                    jQuery(document).ready(function($){
                        console.warn('x2');
                        $('a[data-slide-id]').on('click', function(e){
                            $(this).closest('.MagicToolboxContainer').find('div[data-slide-id]').hide();
                            $(this).closest('.MagicToolboxContainer').find('div[data-slide-id=\"'+$(this).attr('data-slide-id')+'\"]').show();
                            $(this).closest('.MagicToolboxContainer').find('.mz-thumb-selected, .mgt-active').removeClass('mz-thumb-selected').removeClass('mgt-active');
                            $(this).addClass('mz-thumb-selected').addClass('mgt-active');
                            e.preventDefault();
                        })
                    })
                    </script>";
                }


                //$pattern = '<img\b[^>]*?src="[^"]*?(?:'.$product->images[0]->file_url.'|'.$product->images[0]->file_url_thumb.')"[^>]*+>';
                $file_url = preg_quote($product->images[0]->file_url, '-()/');
                $pattern = '<img\b[^>]*?src="[^"]*?'.$file_url.'"[^>]*+>';

                $pattern = '(<a\b[^>]*+>[^<]*+)?'.
                            $pattern.
                           '(?(1)[^<]*+</a>)';

                // $matches = array();
                // preg_match_all("#{$pattern}#is", $contents, $matches, PREG_SET_ORDER);
                // debug_log($matches);

                $matched = false;
                if(preg_match("#{$pattern}#is", $contents)) {
                    $contents = preg_replace('#'.$pattern.'#is', $html, $contents, 1);
                    $matched = true;
                } else {
                    $pattern = '<img\b[^>]*?src="[^"]*?'.preg_quote($product->images[0]->file_url_thumb, '#').'"[^>]*+>';
                    $pattern = '(<a[^>]*vm\-additional\-images[^>]*>[^<]*+)'.
                                $pattern.
                               '(?(1)[^<]*+</a>)';
                    $matches = array();
                    preg_match_all("#{$pattern}#is", $contents, $matches, PREG_SET_ORDER);
                    foreach($matches as $match) {
                        if(strpos($match[0], 'featuredProductImage') !== false) {
                            continue;
                        }
                        $contents = str_replace($match[0], $html, $contents);
                        $matched = true;
                        break;
                    }
                }


                if(!$matched) break;

                //NOTE: cut selectors
                $pattern =  '<div\b[^>]*?\bclass="[^"]*?\b(?:additional(?:-|_)images|thumbnailListContainer)\b[^"]*+"[^>]*+>'.
                            '('.
                            '(?:'.
                               '[^<]++'.
                               '|'.
                               '<(?!/?div\b|!--)'.
                               '|'.
                               '<!--.*?-->'.
                               '|'.
                               '<div\b[^>]*+>'.
                                   '(?1)'.
                               '</div\s*+>'.
                            ')*+'.
                            ')'.
                            '</div\s*+>';
                $contents = preg_replace('#'.$pattern.'#is', '', $contents, 1);


                $showHeaders = true;

            break;
            case 'browse'://category

                $this->backupBlocks($contents);

                if (JVERSION>'4') {
                    $app = JFactory::getApplication();
                    $virtuemart_category_id = $app->input->getCmd('virtuemart_category_id', '');
                } else {
                    $virtuemart_category_id = (int)(JRequest::getVar('virtuemart_category_id', 0));
                }        

                if(empty($virtuemart_category_id)) {
                    //$virtuemart_category_id = vRequest::getInt('virtuemart_category_id', 0);
                    break;
                }

                if(method_exists('VmModel', 'getModel')) {
                    //NOTE: for VirtueMart 2.0.2 and above
                    $productModel = VmModel::getModel('product');
                } else {
                    //NOTE: for VirtueMart 2.0.0
                    $productModel = new VirtueMartModelProduct();
                }
                $products = $productModel->getProductsInCategory($virtuemart_category_id);
                //NOTE: to fill in $image->file_url_thumb
                $productModel->addImages($products, 1);

                $useOriginal = $tool->params->checkValue('use-original-vm-thumbnails', 'Yes');

                $useLink = $tool->params->checkValue('link-to-product-page', 'Yes');

                foreach($products as $product) {

                    $virtuemart_product_id = $product->virtuemart_product_id;

                    if(empty($product->images) && !empty($product->virtuemart_media_id)) {
                        $product->images = $this->getProductMedias($product);
                    }

                    if(empty($product->images)) continue;
                    $image = $product->images[0];

                    if(empty($image->file_url_thumb)) {
                        $image->file_url_thumb = str_replace('product/','product/resized/',preg_replace('/^(.*)(\.[a-z]{1,})$/ims','$1_[0-9]{1,}x[0-9]{1,}$2',$image->file_url));
                    }

                    if($useOriginal) {
                        $img = MAGICTOOLBOX_JURI_BASE.'/'.$image->file_url;
                        $thumb = MAGICTOOLBOX_JURI_BASE.'/'.$image->file_url_thumb;
                    } else {
                        $thumb = $this->getResizedImage($image->file_url, 'thumb', $virtuemart_product_id);
                        if(empty($thumb)) continue;
                        $img = $this->getResizedImage($image->file_url, 'original', $virtuemart_product_id);
                    }

                    $title = $product->product_name;
                    //$title = empty($product->product_name) ? $image->file_title : $product->product_name;
                    $alt = $image->file_title;

                    $html = $tool->getMainTemplate(array(
                        'id' => "Product{$virtuemart_product_id}",
                        'group' => "Category{$virtuemart_category_id}",
                        'img' => $img,
                        'thumb' => $thumb,
                        'title' => $title,
                        'alt' => $alt,
                        'description' => $product->product_desc,
                        'shortDescription' => $product->product_s_desc,
                        'link' => $useLink ? $product->link : false,
                    ));

                    //$pattern = '<img\b[^>]*?src="[^"]*?(?:'.$product->images[0]->file_url.'|'.$product->images[0]->file_url_thumb.')"[^>]*+>';
                    $pattern = '<img\b[^>]*?src="[^"]*?'.$product->images[0]->file_url_thumb.'"[^>]*+>';
                    $pattern = '(<a\b[^>]*+>[^<]*+)?'.
                                $pattern.
                               '(?(1)[^<]*+</a>)';

                    // $matches = array();
                    // preg_match_all("#{$pattern}#is", $contents, $matches, PREG_SET_ORDER);
                    // debug_log($matches);

                    $contents = preg_replace('#'.$pattern.'#is', $html, $contents, 1);

                }

                $this->backupBlocks($contents);

                $showHeaders = true;

            break;

        }

        if(!$showHeaders) return true;

        $tool->params->resetProfile();
        $url = MAGICTOOLBOX_JURI_BASE.'/media/plg_system_vmmagiczoom';
        $headers = array();
        $headers[] = "\n".$tool->getHeadersTemplate($url);
        if($page == 'details') {
            if($tool->params->checkValue('magicscroll', 'Yes', 'details')) {
                $srollTool = $this->getToolObj(true);
                $srollTool->params->resetProfile();
                $headers[] = "\n".$srollTool->getHeadersTemplate($url, null, false);
            }
            $headers[] = '<script type="text/javascript" src="'.$url.'/product.js"></script>';
        }

        if(strpos($contents, '<!-- Magic Slideshow ') !== false) {
            $contents = preg_replace('#<!-- Magic Slideshow #is', implode($headers).'$0', $contents, 1);
        } else
        $contents = preg_replace('#</head>#is', implode($headers).'</head>', $contents, 1);

        $app->setBody($contents);
        //or
        //$app->setBody($contents);
        //or
        //$jApplicationSite->setBody($contents);

        return true;

    }

    public function getToolObj($getScrollTool = false) {
        static $mainCoreClass = null;
        static $scrollCoreClass = null;
        if($mainCoreClass === null) {
            require_once(dirname(__FILE__).DS.'vmmagiczoom'.DS.'classes'.DS.'magiczoom.module.core.class.php');
            $mainCoreClass = new MagicZoomModuleCoreClass();
            $database = JFactory::getDBO();
            $database->setQuery("SELECT `profile`, `name`, `value` FROM `#__virtuemart_magiczoom_config`");
            //$database->setQuery("SELECT `profile`, `name`, `value` FROM `#__virtuemart_magiczoom_config` WHERE `disabled`='0'");
            $results = $database->loadAssocList();
            if(!empty($results)) {
                foreach($results as $row) {
                    $mainCoreClass->params->setValue($row['name'], $row['value'], $row['profile']);
                }
            }
            if($mainCoreClass->params->checkValue('magicscroll', 'Yes', 'details')) {
                require_once(dirname(__FILE__).DS.'vmmagiczoom'.DS.'classes'.DS.'magicscroll.module.core.class.php');
                $scrollCoreClass = new MagicScrollModuleCoreClass(false);
                $scrollCoreClass->params->appendParams($mainCoreClass->params->getParams('default'), 'default');
                //NOTE: load params in a separate profile, in order not to overwrite the options of MagicScroll module
                //$scrollCoreClass->params->appendParams($mainCoreClass->params->getParams('details'), 'product-magicscroll-options');
                $scrollCoreClass->params->resetProfile();//NOTE: need to reset to get all options with 'getParams' method
                foreach($scrollCoreClass->params->getParams() as $id => $param) {
                    $value = $mainCoreClass->params->getValue($id, 'details');
                    if($value !== null) {
                        $scrollCoreClass->params->setValue($id, $value, 'product-magicscroll-options');
                    }
                }
                $scrollCoreClass->params->setValue('orientation', ($mainCoreClass->params->checkValue('template', array('left', 'right'), 'details') ? 'vertical' : 'horizontal'), 'product-magicscroll-options');
                //NOTE: if Magic Scroll module installed we need to load settings before displaying custom options
                if(class_exists('PlgSystemVMMagicScroll') && method_exists('PlgSystemVMMagicScroll', 'getToolObj')) {
                    PlgSystemVMMagicScroll::getInstance()->getToolObj();
                }
            }

            require_once(dirname(__FILE__).DS.'vmmagiczoom'.DS.'classes'.DS.'magictoolbox.templatehelper.class.php');
            MagicToolboxTemplateHelperClass::setPath(dirname(__FILE__).DS.'vmmagiczoom'.DS.'templates');
            MagicToolboxTemplateHelperClass::setOptions($mainCoreClass->params);
        }
        return $getScrollTool ? $scrollCoreClass : $mainCoreClass;
    }

    public function backupBlocks(&$contents) {
        //NOTE: backup latest/featured/random blocks
        static $backups = null;
        static $doFixForSefPlugin = null;
        if($doFixForSefPlugin === null) {
            $doFixForSefPlugin = JPluginHelper::isEnabled('system', 'sef');//plg_system_sef
            if($doFixForSefPlugin) {
                $database = JFactory::getDBO();
                $database->setQuery("SELECT element, ordering FROM `#__extensions` WHERE type='plugin' AND (element='sef' OR element='vmmagiczoom')");
                $results = $database->loadObjectList('element');
                //NOTICE: if they are equal it may not work
                $doFixForSefPlugin = $results ? ((int)$results['sef']->ordering < (int)$results['vmmagiczoom']->ordering) : false;
            }
        }
        $modules = array('virtuemart_latestprod', 'virtuemart_featureprod', 'virtuemart_randomprod', 'mod_virtuemart_product');
        if($backups == null) {
            $backups = array();
            foreach($modules as $name) {
                $module = JModuleHelper::getModule($name);
                if(!$module) continue;
                $placeholder = 'MAGICTOOLBOX_'.strtoupper($name).'_PLACEHOLDER';
                if(empty($module->content)) continue;
                if($doFixForSefPlugin) {
                    //NOTE: this plugin change contents (onAfterRender event)
                    // so this is a spike
                    $module->content = preg_replace('#(src|href|poster)="(?!/|[a-zA-Z0-9]+:|\#|\')([^"]*)"#m', '$1="'.JURI::base(true).'/$2"', $module->content);
                }
                $backups[$placeholder] = $module->content;
                $contents = str_replace($module->content, $placeholder, $contents);
            }
            //NOTE: Joomla 1.5.20 with VirtueMart 2.0.0
            $modules = JModuleHelper::getModules('left');
            foreach ($modules as $module) {
                if($module->module == 'mod_virtuemart_product' && !empty($module->content)) {
                    $placeholder = 'MAGICTOOLBOX_'.strtoupper($name).'_'.$module->id.'_PLACEHOLDER';
                    $backups[$placeholder] = $module->content;
                    $contents = str_replace($module->content, $placeholder, $contents);
                }
            }
        } else {
            if(!empty($backups)) {
                foreach($backups as $placeholder => $value) {
                    $contents = str_replace($placeholder, $value, $contents);
                }
            }
            $backups = null;
        }
    }

    public function getProductMedias($product) {
        $database = JFactory::getDBO();
        $database->setQuery("SELECT * FROM `#__virtuemart_medias` WHERE virtuemart_media_id IN (".join(",", $product->virtuemart_media_id).")");
        $results = $database->loadObjectList();
        $images = array();
        if(!empty($results)) {
            foreach($results as $row) {
                $images[] = $row;
            }
        }
        return $images;
    }

    public function getResizedImage($file, $type = 'original', $id = null) {
        static $imageHelper = null;

        if(empty($file)) return '';

        $file = str_replace(array('%20', '/'), array(' ', DS), $file);

        if(!is_file(JPATH_SITE/*JPATH_ROOT*/.DS.$file)) return '';

        if($imageHelper === null) {
            require_once(dirname(__FILE__).DS.'vmmagiczoom'.DS.'classes'.DS.'magictoolbox.imagehelper.class.php');
            $tool = $this->getToolObj();
            $imageHelper = new MagicToolboxImageHelperClass(JPATH_SITE,
                                                            DS.'media'.DS.'plg_system_vmmagiczoom'.DS.'magictoolbox_cache',
                                                            $tool->params,
                                                            null,
                                                            MAGICTOOLBOX_JURI_BASE);
        }

        return $imageHelper->create(DS.$file, $type, $id);
    }




}
