<?php

/*------------------------------------------------------------------------
# com_virtuemart_magicthumb - Magic Thumb for Joomla with VirtueMart
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magicthumb/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

if(!function_exists('com_install')) {
    function com_install() {
        return installMagicthumbForVirtueMart();
    }
}

if(!function_exists('com_uninstall')) {
    function com_uninstall() {
        return uninstallMagicthumbForVirtueMart();
    }
}

function installMagicthumbForVirtueMart() {

    $database = JFactory::getDBO();

    $doCreateTable = true;

    $database->setQuery("SHOW TABLES LIKE '".$database->getPrefix()."virtuemart_magicthumb_config'");
    $results = $database->loadResult();

    if($results) {
        $doCreateTable = false;
        $database->setQuery("SHOW COLUMNS FROM `#__virtuemart_magicthumb_config`");
        $results = $database->loadObjectList();
        $fields = '';
        foreach($results as $column) {
            $fields .= $column->Field.',';
        }
        //NOTE: check for old table
        if($fields != 'id,profile,name,value,default,') {
            $doCreateTable = true;
            $database->setQuery("DROP TABLE IF EXISTS `#__virtuemart_magicthumb_config_bak`;");
            $database->execute();
            $database->setQuery("RENAME TABLE `#__virtuemart_magicthumb_config` TO `#__virtuemart_magicthumb_config_bak`;");
            $database->execute();
        }
    }

    if($doCreateTable) {
        //NOTE: create empty table
        $database->setQuery("
CREATE TABLE IF NOT EXISTS `#__virtuemart_magicthumb_config` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `profile` VARCHAR(128) NOT NULL DEFAULT '',
    `name` VARCHAR(128) NOT NULL DEFAULT '',
    `value` TEXT,
    `default` TEXT,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
");
        $database->execute();
    }

    $database->setQuery("SELECT COUNT(*) as `count` FROM `#__virtuemart_magicthumb_config` LIMIT 1");
    $results = $database->loadObject();
    if($results->count == 0) {
        $query = <<<SQL
INSERT INTO `#__virtuemart_magicthumb_config` (`profile`, `name`, `value`, `default`) VALUES
 ('default', 'enable-effect', 'No', 'No'),
 ('default', 'template', 'bottom', 'bottom'),
 ('default', 'magicscroll', 'No', 'No'),
 ('default', 'thumb-max-width', '450', '450'),
 ('default', 'thumb-max-height', '450', '450'),
 ('default', 'square-images', 'disable', 'disable'),
 ('default', 'expandEffect', 'expand', 'expand'),
 ('default', 'expandSpeed', '350', '350'),
 ('default', 'expandImageSize', 'fit-screen', 'fit-screen'),
 ('default', 'expandTrigger', 'click', 'click'),
 ('default', 'expandAlign', 'screen', 'screen'),
 ('default', 'expandEasing', 'ease-in-out', 'ease-in-out'),
 ('default', 'gallerySpeed', '250', '250'),
 ('default', 'selector-max-width', '50', '50'),
 ('default', 'selector-max-height', '50', '50'),
 ('default', 'use-individual-titles', 'Yes', 'Yes'),
 ('default', 'selectorTrigger', 'click', 'click'),
 ('default', 'selectorEffect', 'switch', 'switch'),
 ('default', 'show-caption', 'Yes', 'Yes'),
 ('default', 'captionPosition', 'bottom', 'bottom'),
 ('default', 'link-to-product-page', 'Yes', 'Yes'),
 ('default', 'use-original-vm-thumbnails', 'No', 'No'),
 ('default', 'keyboard', 'Yes', 'Yes'),
 ('default', 'cssClass', '', ''),
 ('default', 'rightClick', 'Yes', 'Yes'),
 ('default', 'lazyLoad', 'No', 'No'),
 ('default', 'autostart', 'Yes', 'Yes'),
 ('default', 'imagemagick', 'off', 'off'),
 ('default', 'image-quality', '75', '75'),
 ('default', 'buttons', 'auto', 'auto'),
 ('default', 'textBtnClose', 'Close', 'Close'),
 ('default', 'textBtnNext', 'Next', 'Next'),
 ('default', 'textBtnPrev', 'Previous', 'Previous'),
 ('default', 'watermark', '', ''),
 ('default', 'watermark-max-width', '30%', '30%'),
 ('default', 'watermark-max-height', '30%', '30%'),
 ('default', 'watermark-opacity', '50', '50'),
 ('default', 'watermark-position', 'center', 'center'),
 ('default', 'watermark-offset-x', '0', '0'),
 ('default', 'watermark-offset-y', '0', '0'),
 ('default', 'hint', 'once', 'once'),
 ('default', 'textClickHint', 'Click to expand', 'Click to expand'),
 ('default', 'textHoverHint', 'Hover to expand', 'Hover to expand'),
 ('default', 'slideMobileEffect', 'rotate', 'rotate'),
 ('default', 'textClickHintForMobile', 'Tap to expand', 'Tap to expand'),
 ('default', 'width', 'auto', 'auto'),
 ('default', 'height', 'auto', 'auto'),
 ('default', 'mode', 'scroll', 'scroll'),
 ('default', 'items', '3', '3'),
 ('default', 'speed', '600', '600'),
 ('default', 'autoplay', '0', '0'),
 ('default', 'loop', 'infinite', 'infinite'),
 ('default', 'step', 'auto', 'auto'),
 ('default', 'arrows', 'inside', 'inside'),
 ('default', 'pagination', 'No', 'No'),
 ('default', 'easing', 'cubic-bezier(.8, 0, .5, 1)', 'cubic-bezier(.8, 0, .5, 1)'),
 ('default', 'scrollOnWheel', 'auto', 'auto'),
 ('default', 'lazy-load', 'No', 'No'),
 ('default', 'scroll-extra-styles', '', ''),
 ('default', 'show-image-title', 'No', 'No'),
 ('browse', 'enable-effect', 'No', 'No'),
 ('browse', 'thumb-max-width', '450', '450'),
 ('browse', 'thumb-max-height', '450', '450'),
 ('browse', 'square-images', 'disable', 'disable'),
 ('browse', 'expandEffect', 'expand', 'expand'),
 ('browse', 'expandSpeed', '350', '350'),
 ('browse', 'expandImageSize', 'fit-screen', 'fit-screen'),
 ('browse', 'expandTrigger', 'click', 'click'),
 ('browse', 'expandAlign', 'screen', 'screen'),
 ('browse', 'expandEasing', 'ease-in-out', 'ease-in-out'),
 ('browse', 'gallerySpeed', '250', '250'),
 ('browse', 'show-caption', 'Yes', 'Yes'),
 ('browse', 'captionPosition', 'bottom', 'bottom'),
 ('browse', 'link-to-product-page', 'Yes', 'Yes'),
 ('browse', 'use-original-vm-thumbnails', 'No', 'No'),
 ('browse', 'keyboard', 'Yes', 'Yes'),
 ('browse', 'cssClass', '', ''),
 ('browse', 'rightClick', 'Yes', 'Yes'),
 ('browse', 'lazyLoad', 'No', 'No'),
 ('browse', 'autostart', 'Yes', 'Yes'),
 ('browse', 'imagemagick', 'off', 'off'),
 ('browse', 'image-quality', '75', '75'),
 ('browse', 'buttons', 'auto', 'auto'),
 ('browse', 'textBtnClose', 'Close', 'Close'),
 ('browse', 'textBtnNext', 'Next', 'Next'),
 ('browse', 'textBtnPrev', 'Previous', 'Previous'),
 ('browse', 'watermark', '', ''),
 ('browse', 'watermark-max-width', '30%', '30%'),
 ('browse', 'watermark-max-height', '30%', '30%'),
 ('browse', 'watermark-opacity', '50', '50'),
 ('browse', 'watermark-position', 'center', 'center'),
 ('browse', 'watermark-offset-x', '0', '0'),
 ('browse', 'watermark-offset-y', '0', '0'),
 ('browse', 'hint', 'once', 'once'),
 ('browse', 'textClickHint', 'Click to expand', 'Click to expand'),
 ('browse', 'textHoverHint', 'Hover to expand', 'Hover to expand'),
 ('browse', 'slideMobileEffect', 'rotate', 'rotate'),
 ('browse', 'textClickHintForMobile', 'Tap to expand', 'Tap to expand'),
 ('details', 'enable-effect', 'Yes', 'Yes'),
 ('details', 'template', 'bottom', 'bottom'),
 ('details', 'magicscroll', 'No', 'No'),
 ('details', 'thumb-max-width', '450', '450'),
 ('details', 'thumb-max-height', '450', '450'),
 ('details', 'square-images', 'disable', 'disable'),
 ('details', 'expandEffect', 'expand', 'expand'),
 ('details', 'expandSpeed', '350', '350'),
 ('details', 'expandImageSize', 'fit-screen', 'fit-screen'),
 ('details', 'expandTrigger', 'click', 'click'),
 ('details', 'expandAlign', 'screen', 'screen'),
 ('details', 'expandEasing', 'ease-in-out', 'ease-in-out'),
 ('details', 'gallerySpeed', '250', '250'),
 ('details', 'selector-max-width', '50', '50'),
 ('details', 'selector-max-height', '50', '50'),
 ('details', 'use-individual-titles', 'Yes', 'Yes'),
 ('details', 'selectorTrigger', 'click', 'click'),
 ('details', 'selectorEffect', 'switch', 'switch'),
 ('details', 'show-caption', 'Yes', 'Yes'),
 ('details', 'captionPosition', 'bottom', 'bottom'),
 ('details', 'use-original-vm-thumbnails', 'No', 'No'),
 ('details', 'keyboard', 'Yes', 'Yes'),
 ('details', 'cssClass', '', ''),
 ('details', 'rightClick', 'Yes', 'Yes'),
 ('details', 'lazyLoad', 'No', 'No'),
 ('details', 'autostart', 'Yes', 'Yes'),
 ('details', 'imagemagick', 'off', 'off'),
 ('details', 'image-quality', '75', '75'),
 ('details', 'buttons', 'auto', 'auto'),
 ('details', 'textBtnClose', 'Close', 'Close'),
 ('details', 'textBtnNext', 'Next', 'Next'),
 ('details', 'textBtnPrev', 'Previous', 'Previous'),
 ('details', 'watermark', '', ''),
 ('details', 'watermark-max-width', '30%', '30%'),
 ('details', 'watermark-max-height', '30%', '30%'),
 ('details', 'watermark-opacity', '50', '50'),
 ('details', 'watermark-position', 'center', 'center'),
 ('details', 'watermark-offset-x', '0', '0'),
 ('details', 'watermark-offset-y', '0', '0'),
 ('details', 'hint', 'once', 'once'),
 ('details', 'textClickHint', 'Click to expand', 'Click to expand'),
 ('details', 'textHoverHint', 'Hover to expand', 'Hover to expand'),
 ('details', 'slideMobileEffect', 'rotate', 'rotate'),
 ('details', 'textClickHintForMobile', 'Tap to expand', 'Tap to expand'),
 ('details', 'width', 'auto', 'auto'),
 ('details', 'height', 'auto', 'auto'),
 ('details', 'mode', 'scroll', 'scroll'),
 ('details', 'items', '3', '3'),
 ('details', 'speed', '600', '600'),
 ('details', 'autoplay', '0', '0'),
 ('details', 'loop', 'infinite', 'infinite'),
 ('details', 'step', 'auto', 'auto'),
 ('details', 'arrows', 'inside', 'inside'),
 ('details', 'pagination', 'No', 'No'),
 ('details', 'easing', 'cubic-bezier(.8, 0, .5, 1)', 'cubic-bezier(.8, 0, .5, 1)'),
 ('details', 'scrollOnWheel', 'auto', 'auto'),
 ('details', 'lazy-load', 'No', 'No'),
 ('details', 'scroll-extra-styles', '', ''),
 ('details', 'show-image-title', 'No', 'No'),
 ('default', 'version', '4.11.1', '4.11.1');
SQL;
        $database->setQuery($query);
        if(!$database->execute()) {
            return JError::raiseWarning(500, $database->getError());
        }
    }

    $url = 'index.php?option=com_virtuemart_magicthumb&task=install';
?>
<style>
.magictoolbox-message-container h1 {
    color: #468847;
}
.magictoolbox-message-container {
    color: #468847;   
    background-color: #DFF0D8;
    border: 1px solid #D6E9C6;
    border-radius: 4px;
    margin-bottom: 18px;
    padding: 8px 35px 8px 14px;
    text-shadow: 0 1px 0 rgba(255, 255, 255, 0.5);
}
</style>
<div class="magictoolbox-message-container">
<h1>Please wait...</h1>
<h2>The plugin will be installed automatically...</h2>
<h2>Please click <a href="<?php echo $url; ?>" style="color: black;">here</a> if you are not automatically redirected within <span id="redirect_timer">3</span> seconds</h2>
<script language="javascript" type="text/javascript">
var intervalCounter = 3;
var intervalID = setInterval(function() {
    if(intervalCounter) {
        intervalCounter--;
        document.getElementById('redirect_timer').innerHTML = intervalCounter;
    }
    if(!intervalCounter) {
        clearInterval(intervalID);
        document.location.href = '<?php echo $url; ?>';
    }
}, 1000);
</script>
</div>
<?php
    sendVirtueMartMagicthumbModuleStat('install');
    return true;
}

function uninstallMagicthumbForVirtueMart() {

    if(version_compare(JVERSION, '1.6.0', '<')) {
        //NOTE: need to load lang file for uninstall string
        $lang = JFactory::getLanguage();
        $lang->load('com_virtuemart_magicthumb', JPATH_ADMINISTRATOR, null, false);
    }

    $database = JFactory::getDBO();

    //NOTE: uninstall plugin
    if(version_compare(JVERSION, '1.6.0', '<')) {
        $query = "DELETE FROM `#__plugins` WHERE element='vmmagicthumb'";
    } else {
        $query = "DELETE FROM `#__extensions` WHERE element='vmmagicthumb'";
    }
    $database->setQuery($query);
    $database->execute();

    if(is_file(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_vmmagicthumb.ini')) {
        JFile::delete(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_vmmagicthumb.ini');
    }
    if(is_file(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_vmmagicthumb.sys.ini')) {
        JFile::delete(JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.plg_system_vmmagicthumb.sys.ini');
    }
    if(is_dir(JPATH_SITE.DS.'media'.DS.'plg_system_vmmagicthumb')) {
        JFolder::delete(JPATH_SITE.DS.'media'.DS.'plg_system_vmmagicthumb');
    }
    if(version_compare(JVERSION, '1.6.0', '<')) {
        if(is_dir(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagicthumb')) {
            JFolder::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagicthumb');
        }
        if(is_file(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagicthumb.php')) {
            JFile::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagicthumb.php');
        }
        if(is_file(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagicthumb.xml')) {
            JFile::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagicthumb.xml');
        }
    } else {
        if(is_dir(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagicthumb')) {
            JFolder::delete(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'vmmagicthumb');
        }
    }


    echo '<div style="background-color: #C3D2E5;">
          <p style="color: #0055BB;font-weight: bold;">'.JText::_('COM_VIRTUEMART_MAGICTHUMB_UNINSTALL_TEXT').'</p>
          </div>';

    sendVirtueMartMagicthumbModuleStat('uninstall');
    return true;

}

class com_virtuemart_magicthumbInstallerScript {

    function preflight($type, $parent) {
        return true;
    }

    function install($parent) {
        return installMagicthumbForVirtueMart();
    }

    function update($parent) {
        return installMagicthumbForVirtueMart();
    }

    function uninstall($parent) {
        return uninstallMagicthumbForVirtueMart();
    }

    function postflight($type, $parent) {
        return true;
    }

}

function sendVirtueMartMagicthumbModuleStat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v4.11.1' || 'working' == 'v3.0.20') {
        return;
    }

    /*

    $hostname = 'www.magictoolbox.com';

    $url = $_SERVER['HTTP_HOST'].JURI::root(true);
    $url = urlencode(urldecode($url));

    $platformVersion = '';
    if(file_exists(JPATH_BASE.DS.'components'.DS.'com_virtuemart'.DS.'version.php')) {
        include JPATH_BASE.DS.'components'.DS.'com_virtuemart'.DS.'version.php';
        if(!isset($shortversion)) {
            $vmVersion = new vmVersion();
            $shortversion = vmVersion::$shortversion;
        }
        $platformVersion = preg_replace('/^[a-zA-Z]+\s+(\d+(?:\.\d+)*).*?$/is', '$1', $shortversion);
    }

    $path = "api/stat/?action={$action}&tool_name=magicthumb&license=trial&tool_version=v3.0.20&module_version=v4.11.1&platform_name=virtuemart2&platform_version={$platformVersion}&url={$url}";

    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }

    */

}
