<?php

/*------------------------------------------------------------------------
# com_virtuemart_magicslideshow - Magic Slideshow for Joomla with VirtueMart
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magicslideshow/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

//ini_set('display_errors', true );
//error_reporting(E_ALL & ~E_NOTICE);

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

if(!defined('MAGICTOOLBOX_JURI_BASE')) {
    $url = JURI::base(true);//NOTE: without / at the end
    //NOTE: JURI::base() return URI according to $live_site variable in configuration
    //      this leads to problem with wrong protocol prefix (http/https)
    //      so this is a fix
    if(empty($_SERVER['HTTPS']) || (strtolower($_SERVER['HTTPS']) == 'off')) {
        $url = preg_replace('#^https:#i', 'http:', $url);
    } else {
        $url = preg_replace('#^http:#i', 'https:', $url);
    }
    define('MAGICTOOLBOX_JURI_BASE', $url);
}

class PlgSystemVMMagicSlideshow extends JPlugin {

    protected static $instance = null;

    protected $magicslideshowSupportedBlocks = array('default', 'details');

    public function __construct(&$subject, $config = array()) {
        parent::__construct($subject, $config);
        if(is_null(self::$instance)) {
            self::$instance = $this;
        }
        //$this->loadLanguage();

        //$vmXML = file_get_contents(JPATH_ADMINISTRATOR.'/components/com_virtuemart/virtuemart.xml');
        //$vmVersion = preg_replace('#^.*?<version[^>]*>(.*?)<\/version>.*#', '$1', $vmXML);
    }

    public static function getInstance() {
        if(is_null(self::$instance)) {
            self::$instance = new PlgSystemVMMagicSlideshow(JEventDispatcher::getInstance(), JPluginHelper::getPlugin('system', 'vmmagicslideshow'));
        }
        return self::$instance;
    }

    public function onAfterRender() {

        $app = JFactory::getApplication();
        if ($app->isClient('administrator')) return;

        //NOTE: is this VirtueMart component page?
        if(!class_exists('vmVersion')) return true;

        
        //if(empty($view)) $view = trim(JRequest::getVar('view', '', 'get'));

        if (JVERSION>'4') {
            $app = JFactory::getApplication();
            $view = trim($app->input->getCmd('view', ''));
            $option = trim($app->input->getCmd('option', ''));
        } else {
            $view = trim(JRequest::getVar('view', ''));
            $option = trim(JRequest::getVar('option', '', 'post'));
        }        
        //category, productdetails

        //$page = trim(JRequest::getVar('page', ''));
        //if(empty($page)) $page = trim(JRequest::getVar('page', '', 'get'));


        $page = '';
        if($view == 'category' || $option == 'com_customfilters') $page = 'browse';
        //if($view == 'productdetails'/* || $view == 'shop.cart'*/) $page = 'details';
        if($view == 'productdetails' || !empty($_REQUEST['virtuemart_product_id'])/* || $view == 'shop.cart'*/) $page = 'details';

        $tool = $this->getToolObj();

        if(!in_array($page, $this->magicslideshowSupportedBlocks) || $tool->params->checkValue('enable-effect', 'No', $page)) {
            return true;
        }

        $tool->params->setProfile($page);

        $contents = $app->getBody();

        //or
        //$contents = $app->getBody();
        //or
        //$jApplicationSite = JApplicationSite::getInstance('site');    
        //$contents = $jApplicationSite->getBody();
        $showHeaders = false;

        switch($page) {
            case 'details'://product

                if (JVERSION>'4') {
                    $app = JFactory::getApplication();
                    $virtuemart_product_id = trim($app->input->getCmd('virtuemart_product_id', ''));
                } else {
                    $virtuemart_product_id = JRequest::getVar('virtuemart_product_id', 0);
                }        

                if(is_array($virtuemart_product_id) and count($virtuemart_product_id) > 0) {
                    $virtuemart_product_id = (int)$virtuemart_product_id[0];
                } else {
                    $virtuemart_product_id = (int)$virtuemart_product_id;
                }

                if(method_exists('VmModel', 'getModel')) {
                    //NOTE: for VirtueMart 2.0.2 and above
                    $productModel = VmModel::getModel('product');
                } else {
                    //NOTE: for VirtueMart 2.0.0
                    $productModel = new VirtueMartModelProduct();
                }
                $product = $productModel->getProduct($virtuemart_product_id, true, true, true, 1);

                if(empty($product->images)) {
                    $productModel->addImages($product);
                }

                if(empty($product->images) && !empty($product->virtuemart_media_id)) {
                    $product->images = $this->getProductMedias($product);
                }


                if(empty($product->images)) return true;
                $image = $product->images[0];

                $useOriginal = $tool->params->checkValue('use-original-vm-thumbnails', 'Yes');

                if($useOriginal) {
                    $img = MAGICTOOLBOX_JURI_BASE.'/'.$image->file_url;
                    $thumb = MAGICTOOLBOX_JURI_BASE.'/'.$image->file_url;
                } else {
                    $thumb = $this->getResizedImage($image->file_url, 'thumb', $virtuemart_product_id);
                    if(empty($thumb)) return true;
                    $img = $this->getResizedImage($image->file_url, 'original', $virtuemart_product_id);
                }

                $title = $product->product_name;
                //$title = empty($product->product_name) ? $image->file_title : $product->product_name;
                $alt = $image->file_title;

                $magicslideshowData = array();
                foreach($product->images as $image) {
                    if($useOriginal) {
                        $thumb = MAGICTOOLBOX_JURI_BASE.'/'.$image->file_url;
                        $selector = MAGICTOOLBOX_JURI_BASE.'/'.$image->file_url;
                        $img = MAGICTOOLBOX_JURI_BASE.'/'.$image->file_url;
                    } else {
                        $thumb = $this->getResizedImage($image->file_url, 'thumb', $virtuemart_product_id);
                        if(empty($thumb)) continue;
                        $selector = $this->getResizedImage($image->file_url, 'selector', $virtuemart_product_id);
                        $img = $this->getResizedImage($image->file_url, 'original', $virtuemart_product_id);
                    }
                    $title = empty($image->file_title) ? $product->product_name : $image->file_title;
                    $title = $tool->params->checkValue('use-individual-titles', 'Yes') ? $title : $product->product_name;

                    $magicslideshowData[] = array(
                        'title' => $title,
                        'img' => $thumb,
                        'thumb' => $selector,
                        'fullscreen' => $img,
                    );
                }
                $html = $tool->getMainTemplate($magicslideshowData, array("id" => "Product{$virtuemart_product_id}MagicSlideshow"));




                //$pattern = '<img\b[^>]*?src="[^"]*?(?:'.$product->images[0]->file_url.'|'.$product->images[0]->file_url_thumb.')"[^>]*+>';
                $file_url = preg_quote($product->images[0]->file_url, '-()/');
                $pattern = '<img\b[^>]*?src="[^"]*?'.$file_url.'"[^>]*+>';

                $pattern = '(<a\b[^>]*+>[^<]*+)?'.
                            $pattern.
                           '(?(1)[^<]*+</a>)';

                // $matches = array();
                // preg_match_all("#{$pattern}#is", $contents, $matches, PREG_SET_ORDER);
                // debug_log($matches);

                $matched = false;
                if(preg_match("#{$pattern}#is", $contents)) {
                    $contents = preg_replace('#'.$pattern.'#is', $html, $contents, 1);
                    $matched = true;
                } else {
                    $pattern = '<img\b[^>]*?src="[^"]*?'.preg_quote($product->images[0]->file_url_thumb, '#').'"[^>]*+>';
                    $pattern = '(<a[^>]*vm\-additional\-images[^>]*>[^<]*+)'.
                                $pattern.
                               '(?(1)[^<]*+</a>)';
                    $matches = array();
                    preg_match_all("#{$pattern}#is", $contents, $matches, PREG_SET_ORDER);
                    foreach($matches as $match) {
                        if(strpos($match[0], 'featuredProductImage') !== false) {
                            continue;
                        }
                        $contents = str_replace($match[0], $html, $contents);
                        $matched = true;
                        break;
                    }
                }


                if(!$matched) break;

                //NOTE: cut selectors
                $pattern =  '<div\b[^>]*?\bclass="[^"]*?\b(?:additional(?:-|_)images|thumbnailListContainer)\b[^"]*+"[^>]*+>'.
                            '('.
                            '(?:'.
                               '[^<]++'.
                               '|'.
                               '<(?!/?div\b|!--)'.
                               '|'.
                               '<!--.*?-->'.
                               '|'.
                               '<div\b[^>]*+>'.
                                   '(?1)'.
                               '</div\s*+>'.
                            ')*+'.
                            ')'.
                            '</div\s*+>';
                $contents = preg_replace('#'.$pattern.'#is', '', $contents, 1);

                $contents = preg_replace('#<span class="vm-img-desc">.*?</span>#is', '<style type="text/css">.mss-caption { visibility:visible !important; } </style>', $contents, 1);

                $showHeaders = true;

            break;

        }

        if(!$showHeaders) return true;

        $tool->params->resetProfile();
        $url = MAGICTOOLBOX_JURI_BASE.'/media/plg_system_vmmagicslideshow';
        $headers = array();
        $headers[] = "\n".$tool->getHeadersTemplate($url);
        if($page == 'details') {
            $headers[] = '<script type="text/javascript" src="'.$url.'/product.js"></script>';
        }

        $contents = preg_replace('#</head>#is', implode($headers).'</head>', $contents, 1);

        $app->setBody($contents);
        //or
        //$app->setBody($contents);
        //or
        //$jApplicationSite->setBody($contents);

        return true;

    }

    public function getToolObj($getScrollTool = false) {
        static $mainCoreClass = null;
        static $scrollCoreClass = null;
        if($mainCoreClass === null) {
            require_once(dirname(__FILE__).DS.'vmmagicslideshow'.DS.'classes'.DS.'magicslideshow.module.core.class.php');
            $mainCoreClass = new MagicSlideshowModuleCoreClass();
            $database = JFactory::getDBO();
            $database->setQuery("SELECT `profile`, `name`, `value` FROM `#__virtuemart_magicslideshow_config`");
            //$database->setQuery("SELECT `profile`, `name`, `value` FROM `#__virtuemart_magicslideshow_config` WHERE `disabled`='0'");
            $results = $database->loadAssocList();
            if(!empty($results)) {
                foreach($results as $row) {
                    $mainCoreClass->params->setValue($row['name'], $row['value'], $row['profile']);
                }
                foreach($this->magicslideshowSupportedBlocks as $profile) {
                    $width = $mainCoreClass->params->getValue('selector-max-width', $profile);
                    $height = $mainCoreClass->params->getValue('selector-max-height', $profile);
                    if($width) {
                        $selectorsSize = $width;
                        if($height) {
                            $selectorsSize = $selectorsSize.'x'.$height;
                        }
                    } else if($height) {
                        $selectorsSize = $height;
                    } else {
                        $selectorsSize = 70;
                    }
                    $mainCoreClass->params->setValue('selectors-size', $selectorsSize, $profile);
                }
            }
        }
        return $getScrollTool ? $scrollCoreClass : $mainCoreClass;
    }

    public function backupBlocks(&$contents) {
        //NOTE: backup latest/featured/random blocks
        static $backups = null;
        static $doFixForSefPlugin = null;
        if($doFixForSefPlugin === null) {
            $doFixForSefPlugin = JPluginHelper::isEnabled('system', 'sef');//plg_system_sef
            if($doFixForSefPlugin) {
                $database = JFactory::getDBO();
                $database->setQuery("SELECT element, ordering FROM `#__extensions` WHERE type='plugin' AND (element='sef' OR element='vmmagicslideshow')");
                $results = $database->loadObjectList('element');
                //NOTICE: if they are equal it may not work
                $doFixForSefPlugin = $results ? ((int)$results['sef']->ordering < (int)$results['vmmagicslideshow']->ordering) : false;
            }
        }
        $modules = array('virtuemart_latestprod', 'virtuemart_featureprod', 'virtuemart_randomprod', 'mod_virtuemart_product');
        if($backups == null) {
            $backups = array();
            foreach($modules as $name) {
                $module = JModuleHelper::getModule($name);
                if(!$module) continue;
                $placeholder = 'MAGICTOOLBOX_'.strtoupper($name).'_PLACEHOLDER';
                if(empty($module->content)) continue;
                if($doFixForSefPlugin) {
                    //NOTE: this plugin change contents (onAfterRender event)
                    // so this is a spike
                    $module->content = preg_replace('#(src|href|poster)="(?!/|[a-zA-Z0-9]+:|\#|\')([^"]*)"#m', '$1="'.JURI::base(true).'/$2"', $module->content);
                }
                $backups[$placeholder] = $module->content;
                $contents = str_replace($module->content, $placeholder, $contents);
            }
            //NOTE: Joomla 1.5.20 with VirtueMart 2.0.0
            $modules = JModuleHelper::getModules('left');
            foreach ($modules as $module) {
                if($module->module == 'mod_virtuemart_product' && !empty($module->content)) {
                    $placeholder = 'MAGICTOOLBOX_'.strtoupper($name).'_'.$module->id.'_PLACEHOLDER';
                    $backups[$placeholder] = $module->content;
                    $contents = str_replace($module->content, $placeholder, $contents);
                }
            }
        } else {
            if(!empty($backups)) {
                foreach($backups as $placeholder => $value) {
                    $contents = str_replace($placeholder, $value, $contents);
                }
            }
            $backups = null;
        }
    }

    public function getProductMedias($product) {
        $database = JFactory::getDBO();
        $database->setQuery("SELECT * FROM `#__virtuemart_medias` WHERE virtuemart_media_id IN (".join(",", $product->virtuemart_media_id).")");
        $results = $database->loadObjectList();
        $images = array();
        if(!empty($results)) {
            foreach($results as $row) {
                $images[] = $row;
            }
        }
        return $images;
    }

    public function getResizedImage($file, $type = 'original', $id = null) {
        static $imageHelper = null;

        if(empty($file)) return '';

        $file = str_replace(array('%20', '/'), array(' ', DS), $file);

        if(!is_file(JPATH_SITE/*JPATH_ROOT*/.DS.$file)) return '';

        if($imageHelper === null) {
            require_once(dirname(__FILE__).DS.'vmmagicslideshow'.DS.'classes'.DS.'magictoolbox.imagehelper.class.php');
            $tool = $this->getToolObj();
            $imageHelper = new MagicToolboxImageHelperClass(JPATH_SITE,
                                                            DS.'media'.DS.'plg_system_vmmagicslideshow'.DS.'magictoolbox_cache',
                                                            $tool->params,
                                                            null,
                                                            MAGICTOOLBOX_JURI_BASE);
        }

        return $imageHelper->create(DS.$file, $type, $id);
    }




}
