<?php

/*------------------------------------------------------------------------
# mod_redshop_magiczoomplus - Magic Zoom Plus for Joomla with redSHOP
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magiczoomplus/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

require_once JPATH_COMPONENT.DS.'helpers'.DS.'helper.php';

//NOTE: Import joomla view library
jimport('joomla.application.component.view');

if(!defined('MAGICTOOLBOX_LEGACY_VIEW_DEFINED')) {
    define('MAGICTOOLBOX_LEGACY_VIEW_DEFINED', true);
    if(JVERSION_256) {
        class MagicToolboxLegacyView extends JViewLegacy {}
    } else {
        class MagicToolboxLegacyView extends JView {}
    }
}

class Redshop_MagiczoomplusViewDefault extends MagicToolboxLegacyView {

    function display($tpl = null) {

        //JRequest::setVar('hidemainmenu', true);

        $this->profile = JRequest::getVar('profile', false, 'get');
        $this->profiles = array('default' => 'Default values', 'details' => 'Product details page');

        $title = JText::_('COM_REDSHOP_MAGICZOOMPLUS_MANAGER_SETTINGS');
        if($this->profile) {
            $title .= ' - '.$this->profiles[$this->profile];
        }
        JToolBarHelper::title($title, 'magiczoomplus.png');

        if($this->profile) {
            JToolBarHelper::save('save');//Save & Close
            JToolBarHelper::apply('apply');//Save
        }
        JToolBarHelper::cancel('cancel', 'Close');//Close

        require_once(JPATH_COMPONENT.DS.'redshop_module'.DS.'site'.DS.'classes'.DS.'magiczoomplus.module.core.class.php');
        $this->tool = new MagicZoomPlusModuleCoreClass();
        $database = JFactory::getDBO();
        $database->setQuery("SELECT `profile`, `name`, `value` FROM `#__redshop_magiczoomplus_config`");
        $results = $database->loadAssocList();
        if(!empty($results)) {
            foreach($results as $row) {
                $this->tool->params->setValue($row['name'], $row['value'], $row['profile']);
            }
        }

        $this->imageUrl = JURI::root().'media/com_redshop_magiczoomplus/images/';
        $this->paramsMap = array(
			'default' => array(
				'General' => array(
					'enable-effect',
					'template',
					'magicscroll',
				),
				'Positioning and Geometry' => array(
					'thumb-max-width',
					'thumb-max-height',
					'zoomWidth',
					'zoomHeight',
					'zoomPosition',
					'zoomDistance',
					'square-images',
				),
				'Multiple images' => array(
					'selectorTrigger',
					'transitionEffect',
					'selector-max-width',
					'selector-max-height',
				),
				'Miscellaneous' => array(
					'lazyZoom',
					'rightClick',
					'cssClass',
					'show-message',
					'message',
					'imagemagick',
					'image-quality',
				),
				'Zoom mode' => array(
					'zoomMode',
					'zoomOn',
					'upscale',
					'smoothing',
					'variableZoom',
					'zoomCaption',
				),
				'Expand mode' => array(
					'expand',
					'expandZoomMode',
					'expandZoomOn',
					'expandCaption',
					'closeOnClickOutside',
				),
				'Watermark' => array(
					'watermark',
					'watermark-max-width',
					'watermark-max-height',
					'watermark-opacity',
					'watermark-position',
					'watermark-offset-x',
					'watermark-offset-y',
				),
				'Hint' => array(
					'hint',
					'textHoverZoomHint',
					'textClickZoomHint',
					'textExpandHint',
					'textBtnClose',
					'textBtnNext',
					'textBtnPrev',
				),
				'Mobile' => array(
					'zoomModeForMobile',
					'textHoverZoomHintForMobile',
					'textClickZoomHintForMobile',
					'textExpandHintForMobile',
				),
				'Scroll' => array(
					'width',
					'height',
					'mode',
					'items',
					'speed',
					'autoplay',
					'loop',
					'step',
					'arrows',
					'pagination',
					'easing',
					'scrollOnWheel',
					'lazy-load',
					'scroll-extra-styles',
					'show-image-title',
				),
			),
			'details' => array(
				'General' => array(
					'enable-effect',
					'template',
					'magicscroll',
				),
				'Positioning and Geometry' => array(
					'thumb-max-width',
					'thumb-max-height',
					'zoomWidth',
					'zoomHeight',
					'zoomPosition',
					'zoomDistance',
					'square-images',
				),
				'Multiple images' => array(
					'selectorTrigger',
					'transitionEffect',
					'selector-max-width',
					'selector-max-height',
				),
				'Miscellaneous' => array(
					'lazyZoom',
					'rightClick',
					'cssClass',
					'show-message',
					'message',
					'imagemagick',
					'image-quality',
				),
				'Zoom mode' => array(
					'zoomMode',
					'zoomOn',
					'upscale',
					'smoothing',
					'variableZoom',
					'zoomCaption',
				),
				'Expand mode' => array(
					'expand',
					'expandZoomMode',
					'expandZoomOn',
					'expandCaption',
					'closeOnClickOutside',
				),
				'Watermark' => array(
					'watermark',
					'watermark-max-width',
					'watermark-max-height',
					'watermark-opacity',
					'watermark-position',
					'watermark-offset-x',
					'watermark-offset-y',
				),
				'Hint' => array(
					'hint',
					'textHoverZoomHint',
					'textClickZoomHint',
					'textExpandHint',
					'textBtnClose',
					'textBtnNext',
					'textBtnPrev',
				),
				'Mobile' => array(
					'zoomModeForMobile',
					'textHoverZoomHintForMobile',
					'textClickZoomHintForMobile',
					'textExpandHintForMobile',
				),
				'Scroll' => array(
					'width',
					'height',
					'mode',
					'items',
					'speed',
					'autoplay',
					'loop',
					'step',
					'arrows',
					'pagination',
					'easing',
					'scrollOnWheel',
					'lazy-load',
					'scroll-extra-styles',
					'show-image-title',
				),
			),
		);
        $this->groups = array();
        foreach($this->paramsMap as $profileId => $groups) {
            foreach($groups as $groupName => $params) {
                if(!isset($this->groups[$groupName])) $this->groups[$groupName] = array();
                $_params = array();
                foreach($params as $param) {
                    $_params[$param] = '';
                }
                $this->groups[$groupName] = array_merge($this->groups[$groupName], $_params);
            }
        }

        if($this->profile) {
            $tpl = 'edit';
        }

        parent::display($tpl);

    }

}
