<?php

/*------------------------------------------------------------------------
# mod_redshop_magiczoom - Magic Zoom for Joomla with redSHOP
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magiczoom/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

if(!function_exists('com_install')) {
    function com_install() {
        return installMagiczoomForRedSHOP();
    }
}

if(!function_exists('com_uninstall')) {
    function com_uninstall() {
        return uninstallMagiczoomForRedSHOP();
    }
}

function installMagiczoomForRedSHOP() {

    $database = JFactory::getDBO();
    $database->setQuery("SELECT COUNT(*) as `count` FROM `#__redshop_magiczoom_config` LIMIT 1");
    $results = $database->loadObject();
    if($results->count) {
        $database->setQuery("DROP TABLE IF EXISTS `#__redshop_magiczoom_config_bak`;");
        $database->query();
        $database->setQuery("RENAME TABLE `#__redshop_magiczoom_config` TO `#__redshop_magiczoom_config_bak`;");
        if($database->query()) {
            //$database->setQuery("CREATE TABLE `#__redshop_magiczoom_config` LIKE `#__redshop_magiczoom_config_bak`;");
            $database->setQuery(
"CREATE TABLE IF NOT EXISTS `#__redshop_magiczoom_config` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `profile` VARCHAR(128) NOT NULL DEFAULT '',
    `name` VARCHAR(128) NOT NULL DEFAULT '',
    `value` TEXT,
    `default` TEXT,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
            );

            if($database->query()) {
                $results->count = 0;
            }
        }
    }
    if($results->count == 0) {
        $query = <<<SQL
INSERT INTO `#__redshop_magiczoom_config` (`profile`, `name`, `value`, `default`) VALUES
 ('default', 'enable-effect', 'Yes', 'Yes'),
 ('default', 'template', 'bottom', 'bottom'),
 ('default', 'magicscroll', 'No', 'No'),
 ('default', 'thumb-max-width', '250', '250'),
 ('default', 'thumb-max-height', '250', '250'),
 ('default', 'zoomWidth', 'auto', 'auto'),
 ('default', 'zoomHeight', 'auto', 'auto'),
 ('default', 'zoomPosition', 'right', 'right'),
 ('default', 'zoomDistance', '15', '15'),
 ('default', 'square-images', 'disable', 'disable'),
 ('default', 'selectorTrigger', 'click', 'click'),
 ('default', 'transitionEffect', 'Yes', 'Yes'),
 ('default', 'selector-max-width', '70', '70'),
 ('default', 'selector-max-height', '70', '70'),
 ('default', 'lazyZoom', 'No', 'No'),
 ('default', 'rightClick', 'No', 'No'),
 ('default', 'cssClass', '', ''),
 ('default', 'show-message', 'No', 'No'),
 ('default', 'message', 'Move your mouse over image', 'Move your mouse over image'),
 ('default', 'imagemagick', 'off', 'off'),
 ('default', 'image-quality', '75', '75'),
 ('default', 'zoomMode', 'zoom', 'zoom'),
 ('default', 'zoomOn', 'hover', 'hover'),
 ('default', 'upscale', 'Yes', 'Yes'),
 ('default', 'smoothing', 'Yes', 'Yes'),
 ('default', 'variableZoom', 'No', 'No'),
 ('default', 'zoomCaption', 'off', 'off'),
 ('default', 'watermark', '', ''),
 ('default', 'watermark-max-width', '30%', '30%'),
 ('default', 'watermark-max-height', '30%', '30%'),
 ('default', 'watermark-opacity', '50', '50'),
 ('default', 'watermark-position', 'center', 'center'),
 ('default', 'watermark-offset-x', '0', '0'),
 ('default', 'watermark-offset-y', '0', '0'),
 ('default', 'hint', 'once', 'once'),
 ('default', 'textHoverZoomHint', 'Hover to zoom', 'Hover to zoom'),
 ('default', 'textClickZoomHint', 'Click to zoom', 'Click to zoom'),
 ('default', 'zoomModeForMobile', 'off', 'off'),
 ('default', 'textHoverZoomHintForMobile', 'Touch to zoom', 'Touch to zoom'),
 ('default', 'textClickZoomHintForMobile', 'Double tap or pinch to zoom', 'Double tap or pinch to zoom'),
 ('default', 'width', 'auto', 'auto'),
 ('default', 'height', 'auto', 'auto'),
 ('default', 'mode', 'scroll', 'scroll'),
 ('default', 'items', '3', '3'),
 ('default', 'speed', '600', '600'),
 ('default', 'autoplay', '0', '0'),
 ('default', 'loop', 'infinite', 'infinite'),
 ('default', 'step', 'auto', 'auto'),
 ('default', 'arrows', 'inside', 'inside'),
 ('default', 'pagination', 'No', 'No'),
 ('default', 'easing', 'cubic-bezier(.8, 0, .5, 1)', 'cubic-bezier(.8, 0, .5, 1)'),
 ('default', 'scrollOnWheel', 'auto', 'auto'),
 ('default', 'lazy-load', 'No', 'No'),
 ('default', 'scroll-extra-styles', '', ''),
 ('default', 'show-image-title', 'No', 'No'),
 ('details', 'enable-effect', 'Yes', 'Yes'),
 ('details', 'template', 'bottom', 'bottom'),
 ('details', 'magicscroll', 'No', 'No'),
 ('details', 'thumb-max-width', '250', '250'),
 ('details', 'thumb-max-height', '250', '250'),
 ('details', 'zoomWidth', 'auto', 'auto'),
 ('details', 'zoomHeight', 'auto', 'auto'),
 ('details', 'zoomPosition', 'right', 'right'),
 ('details', 'zoomDistance', '15', '15'),
 ('details', 'square-images', 'disable', 'disable'),
 ('details', 'selectorTrigger', 'click', 'click'),
 ('details', 'transitionEffect', 'Yes', 'Yes'),
 ('details', 'selector-max-width', '70', '70'),
 ('details', 'selector-max-height', '70', '70'),
 ('details', 'lazyZoom', 'No', 'No'),
 ('details', 'rightClick', 'No', 'No'),
 ('details', 'cssClass', '', ''),
 ('details', 'show-message', 'No', 'No'),
 ('details', 'message', 'Move your mouse over image', 'Move your mouse over image'),
 ('details', 'imagemagick', 'off', 'off'),
 ('details', 'image-quality', '75', '75'),
 ('details', 'zoomMode', 'zoom', 'zoom'),
 ('details', 'zoomOn', 'hover', 'hover'),
 ('details', 'upscale', 'Yes', 'Yes'),
 ('details', 'smoothing', 'Yes', 'Yes'),
 ('details', 'variableZoom', 'No', 'No'),
 ('details', 'zoomCaption', 'off', 'off'),
 ('details', 'watermark', '', ''),
 ('details', 'watermark-max-width', '30%', '30%'),
 ('details', 'watermark-max-height', '30%', '30%'),
 ('details', 'watermark-opacity', '50', '50'),
 ('details', 'watermark-position', 'center', 'center'),
 ('details', 'watermark-offset-x', '0', '0'),
 ('details', 'watermark-offset-y', '0', '0'),
 ('details', 'hint', 'once', 'once'),
 ('details', 'textHoverZoomHint', 'Hover to zoom', 'Hover to zoom'),
 ('details', 'textClickZoomHint', 'Click to zoom', 'Click to zoom'),
 ('details', 'zoomModeForMobile', 'off', 'off'),
 ('details', 'textHoverZoomHintForMobile', 'Touch to zoom', 'Touch to zoom'),
 ('details', 'textClickZoomHintForMobile', 'Double tap or pinch to zoom', 'Double tap or pinch to zoom'),
 ('details', 'width', 'auto', 'auto'),
 ('details', 'height', 'auto', 'auto'),
 ('details', 'mode', 'scroll', 'scroll'),
 ('details', 'items', '3', '3'),
 ('details', 'speed', '600', '600'),
 ('details', 'autoplay', '0', '0'),
 ('details', 'loop', 'infinite', 'infinite'),
 ('details', 'step', 'auto', 'auto'),
 ('details', 'arrows', 'inside', 'inside'),
 ('details', 'pagination', 'No', 'No'),
 ('details', 'easing', 'cubic-bezier(.8, 0, .5, 1)', 'cubic-bezier(.8, 0, .5, 1)'),
 ('details', 'scrollOnWheel', 'auto', 'auto'),
 ('details', 'lazy-load', 'No', 'No'),
 ('details', 'scroll-extra-styles', '', ''),
 ('details', 'show-image-title', 'No', 'No'),
 ('default', 'version', '1.7.6', '1.7.6');
SQL;
        $database->setQuery($query);
        if(!$database->query()) {
            return JError::raiseWarning(500, $database->getError());
        }
    }

    $url = 'index.php?option=com_redshop_magiczoom&task=install';
?>
<style>
.magictoolbox-message-container h1 {
    color: #468847;
}
.magictoolbox-message-container {
    color: #468847;   
    background-color: #DFF0D8;
    border: 1px solid #D6E9C6;
    border-radius: 4px;
    margin-bottom: 18px;
    padding: 8px 35px 8px 14px;
    text-shadow: 0 1px 0 rgba(255, 255, 255, 0.5);
}
</style>
<div class="magictoolbox-message-container">
<h1>Please wait...</h1>
<h2>The frontend module will be installed automatically...</h2>
<h2>Please click <a href="<?php echo $url; ?>" style="color: black;">here</a> if you are not automatically redirected within <span id="redirect_timer">3</span> seconds</h2>
<script language="javascript" type="text/javascript">
var intervalCounter = 3;
var intervalID = setInterval(function() {
    if(intervalCounter) {
        intervalCounter--;
        document.getElementById('redirect_timer').innerHTML = intervalCounter;
    }
    if(!intervalCounter) {
        clearInterval(intervalID);
        document.location.href = '<?php echo $url; ?>';
    }
}, 1000);
</script>
</div>
<?php
    sendRedSHOPMagiczoomModuleStat('install');
    return true;
}

function uninstallMagiczoomForRedSHOP() {

    if(version_compare(JVERSION, '1.6.0', '<')) {
        //NOTE: need to load lang file for uninstall string
        $lang = JFactory::getLanguage();
        $lang->load('com_redshop_magiczoom', JPATH_ADMINISTRATOR, null, false);
    }

    //NOTE: uninstall module
    $module = 'mod_redshop_magiczoom';
    $database = JFactory::getDBO();
    $query = "SELECT `id` FROM `#__modules` WHERE module='{$module}'";
    $database->setQuery($query);
    $modIDs = version_compare(JVERSION, '1.7.0', '<') ? $database->loadResultArray() : $database->loadColumn();
    if(count($modIDs)) {
        $modID = implode(',', $modIDs);
        $query = 'DELETE FROM #__modules_menu WHERE moduleid IN ('.$modID.')';
        $database->setQuery($query);
        $database->query();
        $query = "DELETE FROM `#__modules` WHERE module='{$module}'";
        $database->setQuery($query);
        $database->query();
        if(version_compare(JVERSION, '1.6.0', '>=')) {
            $query = "DELETE FROM `#__extensions` WHERE element='{$module}'";
            $database->setQuery($query);
            $database->query();
        }
        //$query = "DELETE FROM `#__menu` WHERE link LIKE '%{$module}%'";
    }

    $manifest = file_exists(JPATH_SITE.DS.'modules'.DS.$module.DS."{$module}.xml") ? simplexml_load_file(JPATH_SITE.DS.'modules'.DS.$module.DS."{$module}.xml") : false;//SimpleXMLElement
    if($manifest) {
        $elements = array('media', 'languages');
        foreach($elements as $elementPath) {
            $element = $manifest->$elementPath;//SimpleXMLElement
            if(is_a($element, 'SimpleXMLElement') && count($element->children())) {
                switch($elementPath) {
                    case 'media':
                        $source = JPATH_SITE.DS.'media';
                        $destination = $element->attributes()->destination;
                        if($destination) {
                            $source = $source.DS.$destination;
                        }
                        break;
                    case 'languages':
                        $source = JPATH_SITE.DS.'language';
                        break;
                }
                foreach($element->children() as $child) {
                    if($child->getName() == 'language' && $child->attributes()->tag) {
                        $path = $source.DS.$child->attributes()->tag;
                        if(!JFolder::exists($path)) continue;
                        $path = $path.DS.$child;
                    } else {
                        $path = $source.DS.$child;
                    }
                    if(is_file($path)) {
                        JFile::delete($path);
                    } else if(is_dir($path)) {
                        $val = JFolder::delete($path);
                    }
                }
                //if($elementPath == 'media' && $destination) {
                //    JFolder::delete($source);
                //}
            }
        }
    }

    if(is_dir(JPATH_SITE.DS.'modules'.DS.$module)) {
        JFolder::delete(JPATH_SITE.DS.'modules'.DS.$module);
    }

    echo '<div style="background-color: #C3D2E5;">
          <p style="color: #0055BB;font-weight: bold;">'.JText::_('COM_REDSHOP_MAGICZOOM_UNINSTALL_TEXT').'</p>
          </div>';

    sendRedSHOPMagiczoomModuleStat('uninstall');
    return true;

}

class com_redshop_magiczoomInstallerScript {

    function preflight($type, $parent) {
        return true;
    }

    function install($parent) {
        return installMagiczoomForRedSHOP();
    }

    function update($parent) {
        return installMagiczoomForRedSHOP();
    }

    function uninstall($parent) {
        return uninstallMagiczoomForRedSHOP();
    }

    function postflight($type, $parent) {
        return true;
    }

}

function sendRedSHOPMagiczoomModuleStat($action = '') {

    //NOTE: don't send from working copy
    if('working' == 'v1.7.6' || 'working' == 'v5.3.7') {
        return;
    }

    $hostname = 'www.magictoolbox.com';

    $url = $_SERVER['HTTP_HOST'].JURI::root(true);
    $url = urlencode(urldecode($url));

    $platformVersion = '';
    if(file_exists(dirname(dirname(__FILE__)).DS.'com_redshop'.DS.'com_redshop.xml')) {
        $contents  = file_get_contents(dirname(dirname(__FILE__)).DS.'com_redshop'.DS.'com_redshop.xml');
        $match = array();
        if(preg_match('#<version>(\d+(?:\.\d+)+)[^<]*+</version>#i', $contents, $match)) {
            $platformVersion = $match[1];
        }
    }

    $path = "api/stat/?action={$action}&tool_name=magiczoom&license=trial&tool_version=v5.3.7&module_version=v1.7.6&platform_name=redshop&platform_version={$platformVersion}&url={$url}";

    $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
    if($handle) {
        $headers = "GET /{$path} HTTP/1.1\r\n";
        $headers .= "Host: {$hostname}\r\n";
        $headers .= "Connection: Close\r\n\r\n";
        fwrite($handle, $headers);
        fclose($handle);
    }

}
