<?php

/*------------------------------------------------------------------------
# mod_redshop_magiczoom - Magic Zoom for Joomla with redSHOP
# ------------------------------------------------------------------------
# Magic Toolbox
# Copyright 2011 MagicToolbox.com. All Rights Reserved.
# @license - http://www.opensource.org/licenses/artistic-license-2.0  Artistic License 2.0 (GPL compatible)
# Website: http://www.magictoolbox.com/magiczoom/modules/joomla/
# Technical Support: http://www.magictoolbox.com/contact/
/*-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access.');

/**
* Magic Zoom Module for redSHOP (Joomla component like VirtueMart)
* NOTE: This module requires the redSHOP component for Joomla!
*
* @version v1.7.6 [v1.6.103:v5.3.7]
* @author Magic Toolbox
* @copyright (C) 2025 Magic Toolbox
* @license http://www.magictoolbox.com/license/
**/

//NOTE: for DEBUG
/*
ini_set("display_errors", true );
error_reporting(E_ALL & ~E_NOTICE);
*/

//NOTE: we haven't redshop on this page
if(!class_exists('producthelper') && !class_exists('RedshopController')) return;

defined('_JEXEC') or die( 'Direct Access to this location is not allowed.' );

defined('DS') or define('DS', DIRECTORY_SEPARATOR);

require_once(dirname(__FILE__).DS.'classes'.DS.'magiczoom.module.core.class.php');
require_once(dirname(__FILE__).DS.'classes'.DS.'magicscroll.module.core.class.php');

class ModMagicZoomRedShop {

    var $params = array();
    var $conf = array();
    var $content = '';
    var $content_buffer = '';
    var $baseurl = '';
    var $jmpath = '';
    var $jmurl = '';
    var $page = '';
    var $coreClass = '';
    var $scrollClass = null;
    var $latestProd = '';
    var $featuredProd = '';
    var $randomProd = '';
    var $preserveAdditionalThumbnailsPositions= false;
    var $shouldBeReplaced = array("patterns" => array(), "replacements" => array());
    var $needHeaders = false;
    var $needScroll = false;

    function modMagicZoomRedShop ($params) {
        $this->params = $params;

        //$this->baseurl = JURI::base() . 'modules/mod_redshop_magiczoom/core';
        $this->baseurl = JURI::base(true).'/media/mod_redshop_magiczoom';

        $this->jmurl = JURI::base();
        $this->jmpath = dirname(dirname(dirname(__FILE__)));

        $coreClassName = 'MagicZoomModuleCoreClass';
        $this->coreClass = new $coreClassName();
        $this->scrollClass = new MagicScrollModuleCoreClass(false);

        $this->page = trim(JRequest::getVar('view', ''));

        $this->loadConf();

        $this->registerEvent('onAfterRender', 'modMagicZoomredSHOPLoad');
    }

    function registerEvent($event,$handler) {
        /* can't use $mainframe->registerEvent function when System.Cache plugin activated */
        $dispatcher = JDispatcher::getInstance();

        if(class_exists('joomlaVersion')) {
            //old joomla, 1.0.x
            $versionObj = new joomlaVersion();
        } elseif(class_exists('JVersion')) {
            $versionObj = new JVersion();
        }
        if(version_compare($versionObj->getShortVersion(), '1.6.0', '<')) {
            $obs = array("event" => $event, "handler" => $handler);
            $dispatcher->_observers = array_merge(array($obs), $dispatcher->_observers);
        } else {
            $dispatcher->register($event,$handler);
        }
    }

    function loadConf() {
        $this->conf = & $this->coreClass->params;

        $options = JFactory::getDBO();
        $options->setQuery("SELECT * FROM #__redshop_magiczoom_config");
        $options->query();
        $options = $options->loadObjectList();

        foreach($options as $option) {
            $this->conf->setValue($option->name, $option->value, $option->profile);
        }

        if($this->conf->checkValue('magicscroll', 'Yes', 'details')) {
            $this->scrollClass->params->appendParams($this->conf->getParams('default'), 'default');
            //NOTE: load params in a separate profile, in order not to overwrite the options of MagicScroll module
            $this->scrollClass->params->appendParams($this->conf->getParams('details'), 'product-magicscroll-options');
            $this->scrollClass->params->setValue('orientation', ($this->conf->checkValue('template', array('left', 'right'), 'details') ? 'vertical' : 'horizontal'), 'product-magicscroll-options');
        }
    }

    function load() {

        $this->content = JResponse::toString();
        $this->content_buffer = & $this->content;

        if($this->page == 'shop.browse' && $this->conf->checkValue('enable-effect', 'Yes', 'browse')) {
            $this->conf->setProfile('browse');

            $GLOBALS["magictoolbox_rewrite_done"] = false;

            // for VM 1.0 (browser_1.php page) 
            // and also for sites with Joomla SEF or sh404SEF plugin enabled in Joomla 1.5.x
            $pattern = '/<(script)\s*([^>]*)(?:>(.*?)<\/\1>|\/>)/s';
            $this->content_buffer = preg_replace_callback($pattern, array(&$this,"loadIMGCallback_VM10"), $this->content_buffer);

            // for VM 1.1 with Joomla SEF or sh404SEF plugin (!)enabled
            if($GLOBALS["magictoolbox_rewrite_done"] == false) {
                $pattern = "/<a[^>]*?href=\"[^\"]*\"[^>]*>\s*<img[^>]*?alt=\"[^\"]*\"[^>]*>.*?<\/a>/is";
                $this->content_buffer = preg_replace_callback($pattern, array(&$this,"loadIMGCallback_VM10"), $this->content_buffer);
            }

            // for VM 1.1 with Joomla SEF or sh404SEF plugin disabled
            if($GLOBALS["magictoolbox_rewrite_done"] == false) {
                $pattern = "/<a[^>]*?href=\"[^\"]*shop.product_details[^\"]*product_id=(\d+)[^\"]*\"[^>]*>\s*<img[^>]*>.*?<\/a>/is";
                $this->content_buffer = preg_replace_callback($pattern, array(&$this,"loadIMGCallback"), $this->content_buffer);
            }

            /* restore latest prod */
            $this->content_buffer = str_replace('__MAGICTOOLBOX_LATEST_PROD_BACKUP__', $modContentL, $this->content_buffer);

            /* restore featured prod */
            $this->content_buffer = str_replace('__MAGICTOOLBOX_FEATURED_PROD_BACKUP__', $modContentF, $this->content_buffer);

            /* restore random prod */
            $this->content_buffer = str_replace('__MAGICTOOLBOX_RANDOM_PROD_BACKUP__', $modContentF, $this->content_buffer);
        }

        if($this->page == 'product' && $this->conf->checkValue('enable-effect', 'Yes', 'details')) {
            $this->conf->setProfile('details');

            if (class_exists('producthelper')) {
                $producthelper = new producthelper();
            }
            
            $pid = JRequest::getInt('pid');

            if (class_exists('producthelper')) {
                $product = $producthelper->getProductById($pid);
            } else {
                $product = \Redshop\Product\Product::getProductById($pid);
            }

            if(JRequest::getString('_task', '') == 'displayAdditionImage') {
                extract($this->displayAdditionImage());
            } else {
                $img = 'product/' . $product->product_full_image;
                $title = $product->product_name;
                if (class_exists('producthelper')) {
                    $images = $producthelper->getAdditionMediaImage($pid, 'product');
                } else {
                    $images = RedshopHelperMedia::getAdditionMediaImage($pid, 'product');                
                }
                $subfolder = 'product/';
            }

            //$list = array();

			// attributes ================================================
            $html2 = '';
            $db = JFactory::getDBO();
			//$query = 'SELECT j1.attribute_id, j2.property_id, j2.property_main_image, j2.ordering
            $query = 'SELECT j2.*, j1.attribute_id, j2.property_id, j2.property_main_image, j2.ordering
				FROM #__redshop_product_attribute j1
				LEFT JOIN #__redshop_product_attribute_property j2 ON j1.attribute_id = j2.attribute_id AND j2.property_main_image <> ""
				WHERE j1.product_id = '.intval($pid).'
				ORDER BY j2.ordering';
        	$db->setQuery($query);
        	$db->query();
        	$aimages = $db->loadObjectList();

			$main1 = '';
			$thumbs1 = array();
        	
        	$mode = 'separate';
        	$mode = 'split';

			if ($mode!='separate') {
				$html2 .= '<script type="text/javascript">var MagicToolboxMainImages = [];</script>';
			}


        	if (count($aimages) && $this->coreClass->type == 'standard') {
				
				foreach($aimages as $image) {

				if ($image->property_main_image=='') continue;

                $attribute_id = $image->attribute_id;
				$property_id = $image->property_id;

				$main1 = '';
				if ($mode=='separate') $thumbs1 = array();

					$img1 = 'property/'.$image->property_main_image;
					if ($mode=='separate') {
						$mainid = $pid."_property_".$image->property_id;
					} else {
						$mainid = $pid;

					}

    				$arr = array(
                        'id' => $mainid,
                        'img' => $this->makeThumb($img1, 'original', $pid+"_"+$image->property_id),
                        'thumb' => $this->makeThumb($img1, 'thumb', $pid+"_"+$image->property_id),
                        //'medium' => $this->makeThumb($img1, 'thumb', $pid+"_"+$image->property_id),
                        'title' => $title
                    );
                    $main1 = $this->coreClass->getMainTemplate($arr);
					/*
					if ($mode!='separate') {
						$html2 .= '<script type="text/javascript">MagicToolboxMainImages['.$image->property_id.'] = {
							"small" : "'.$arr['img'].'",
							"large" : "'.$arr['thumb'].'"
						};</script>';
					}
                    */


                    $db = JFactory::getDBO();
        			$query = 'SELECT j3.media_id, j3.section_id, j3.media_name, j3.ordering
						FROM #__redshop_media j3
						WHERE j3.media_section = "property" AND j3.media_type = "images" AND j3.section_id = '.intval($image->property_id).'
						ORDER BY j3.ordering';

                	$db->setQuery($query);
                	$db->query();
                	$addimages = $db->loadObjectList();

                	$thumbs2 = array();
                    $done_attributes = array();

                	if (count($addimages) || $mode!='separate') {
                		$thumbs2[] = $this->coreClass->getSelectorTemplate(array(
                            'id' => $mainid,
                            'img' => $this->makeThumb($img1, 'original', $pid+"_"+$image->property_id),
                            'thumb' => $this->makeThumb($img1, 'selector', $pid+"_"+$image->property_id),
                            'medium' => $this->makeThumb($img1, 'thumb', $pid+"_"+$image->property_id),
                            'title' => $title
                        ));
                        if (count($addimages)) {
                    		foreach($addimages as $addimage) {
                                if(preg_match('#no_image#', $addimage->media_name)) continue;
    							$img1 = 'property/'.$addimage->media_name;
                        		$thumbs2[] = $this->coreClass->getSelectorTemplate(array(
                                    'id' => $mainid,
                                    'img' => $this->makeThumb($img1, 'original', $pid+"_media_"+$addimage->media_id),
                                    'thumb' => $this->makeThumb($img1, 'selector', $pid+"_media_"+$addimage->media_id),
                                    'medium' => $this->makeThumb($img1, 'thumb', $pid+"_media_"+$addimage->media_id),
                                    'title' => $title
                                ));
                    		}	
                		}

                		foreach($thumbs2 as $id => $thumb) {
                            if (!empty($done_attributes[$attribute_id][$property_id])) {
                			     $thumbs2[$id] = str_replace("<a","<a onclick=\"return updateAttributeDropdown(".$attribute_id.",".$property_id.")\"",$thumbs2[$id]);
                            } else {
                                unset($thumbs2[$id]);
                		    }
                            $done_attributes[$attribute_id][$property_id] = true;
                		}

                        if ($mode!='separate') {
                            //$thumbs2[0] = preg_replace('#<a\b#i', '<a data-attribute-property="MagicToolboxPropertySelector:'.$property_id.'"', $thumbs2[0]);
                            //NOTICE: fix PHP Notice:  Undefined offset: 0
                            reset($thumbs2);
                            $thumbs2firstKey = key($thumbs2);
                            $thumbs2[$thumbs2firstKey] = preg_replace('#<a\b#i', '<a data-attribute-property="MagicToolboxPropertySelector:'.$property_id.'"', $thumbs2[$thumbs2firstKey]);
                        }

                	}

                	$thumbs1 = array_merge($thumbs1,$thumbs2);

                	//$html .= '<div id="property_'.$image->property_id.'_main">'.$main.'</div>';
                	//$html .= '<div id="property_'.$image->property_id.'_selectors">'.join('',$thumbs).'</div>';

                    $magicscrollOptions = '';
                    if($this->conf->checkValue('magicscroll', 'Yes')) {
                        $magicscrollOptions = $this->scrollClass->params->serialize(false, '', 'product-magicscroll-options');
                    }

                    $str = $this->renderTemplate(array(
                        'main' => $main1,
                        'thumbs' => $thumbs1,
                        'magicscrollOptions' => $magicscrollOptions,
                        'pid' => $pid."_property_".$image->property_id,
                    ));

                   	$str = preg_replace("/style=\"(.*?)\"/ims","style=\"$1;display:none;\"",$str,1);

                   	if ($mode=='separate') {
                    	$html2 .= $str;
                    }

				}
			}            
			if ($mode!='separate') {
				$html2 .= '<script type="text/javascript">MagicToolboxAttributeMode="split";</script>';
			}
			// ================================================

            // main image
            if($this->coreClass->type == 'standard') {
                $arr = array(
                    'id' => $pid,
                    'img' => $this->makeThumb($img, 'original', $pid),
                    'thumb' => $this->makeThumb($img, 'thumb', $pid),
                    'title' => $title,
                    'shortDescription' => $product->product_s_desc,
                    'description' => $product->product_desc,
                );
                $main = $this->coreClass->getMainTemplate($arr);
            }

            // selectors
            $thumbs = array();
            if(count($images) > 0 || $mode!='separate' && count($thumbs1)>0) {
                // main image selector
                $thumbA = array(
                    'id' => $pid,
                    'img' => $this->makeThumb($img, 'original', $pid),
                    'thumb' => $this->makeThumb($img, 'selector', $pid),
                    'medium' => $this->makeThumb($img, 'thumb', $pid),
                    'title' => $title
                );
                if($this->coreClass->type == 'standard') {
                    $thumbA = $this->coreClass->getSelectorTemplate($thumbA);
                }
                $thumbs[] = $thumbA;
				if ($mode!='separate') {
                    $thumbs[0] = preg_replace('#<a\b#i', '<a data-attribute-property="MagicToolboxPropertySelector:0"', $thumbs[0]);
                }
                // other selectors
                foreach($images as $image) {
                    if(empty($image->media_name)) continue;
                    //NOTE: to skip double selector for main image
                    if(basename($img) == basename($image->media_name)) continue;
                    $thumbA = array(
                        'id' => $pid,
                        'img' => $this->makeThumb($subfolder . $image->media_name, 'original', $pid),
                        'thumb' => $this->makeThumb($subfolder . $image->media_name, 'selector', $pid),
                        'medium' => $this->makeThumb($subfolder . $image->media_name, 'thumb', $pid),
                        'alt' => $image->media_alternate_text,
                        'title' => $this->conf->checkValue('use-individual-titles', 'Yes') ? $image->media_alternate_text : $title
                    );
                    if($this->coreClass->type == 'standard') {
                        $thumbA = $this->coreClass->getSelectorTemplate($thumbA);
                    }
                    $thumbs[] = $thumbA;
                }


                if(!empty($attribute_id))
                foreach($thumbs as $id => $thumb) {
                	$thumbs[$id] = str_replace("<a","<a onclick=\"return updateAttributeDropdown(".$attribute_id.",0)\"",$thumbs[$id]);
                }

                if (count($thumbs1) && $mode!='separate') {
                	$thumbs = array_merge($thumbs,$thumbs1);
                }

                
                //NOTE: not show one selector
                if(count($thumbs) == 1) $thumbs = array();
            }

            $html = '';
            if($this->coreClass->type == 'standard') {
                $magicscrollOptions = '';
                if($this->conf->checkValue('magicscroll', 'Yes')) {
                    $magicscrollOptions = $this->scrollClass->params->serialize(false, '', 'product-magicscroll-options');
                }
                $html = $this->renderTemplate(array(
                    'main' => $main,
                    'thumbs' => $thumbs,
                    'magicscrollOptions' => $magicscrollOptions,
                    'pid' => $pid,
                )) . '<script type="text/javascript">MagicToolbox_productID = ' . $pid . ';</script>';
            } else {
                if(count($thumbs) > 1 && ($this->coreClass->type != 'circle' || $this->coreClass->isEnabled(count($images), $pid))) {
                    $html = $this->coreClass->getMainTemplate($thumbs, array('id' => 'detailed' . $pid));
                }
            }

            $html .= $html2;

            if(JRequest::getString('_task', '') == 'displayAdditionImage') {
                // product attributes/options
                die(str_replace('[RESPONSE]', $html, $tpl));
            }

            if(!empty($html)) {
                // replace main image
                $product_image_quoted = '(?:' . preg_quote($product->product_full_image, '/') . '|' . preg_quote($product->product_thumb_image, '/') . ')';
                $oldcontent = $this->content;
                $this->content = preg_replace(
                    '/<div class="product_image[^"]*"><div><a[^>]+?href=\'[^\']+?' . $product_image_quoted . '\'.*?<\/a><\/div>.*?<\/div>/is',
                    '<div id="additional_images' . $pid . '">' . $html . '</div>',
                    $this->content
                );

                if ($oldcontent == $this->content) {
                    $this->content = preg_replace(
                        '/<div class=\'productImageWrap\'[^>]*><div><a[^>]+?href=\'[^\']+?' . $product_image_quoted . '\'.*?<\/a><\/div>.*?<\/div>/is',
                        '<div id="additional_images' . $pid . '">' . $html . '</div>',
                        $this->content
                    );
                }

                if ($oldcontent == $this->content) {
                    $this->content = preg_replace(
                        '/<div><img[^>]+?id=\'main_image[^\']*?\'[^>]+?src=\'[^\']+?' . $product_image_quoted . '\'.*?\/><\/div>/is',
                        '<div id="additional_images' . $pid . '">' . $html . '</div>',
                        $this->content
                    );
                }

                if ($oldcontent == $this->content) {
                    $this->content = preg_replace(
                        '/<div><img[^>]+?id=\"main_image[^\"]*?\"[^>]+?src=\"[^\"]+?' . $product_image_quoted . '[^>]*?><\/div>/is',
                        '<div id="additional_images' . $pid . '">' . $html . '</div>',
                        $this->content
                    );
                    $this->content = preg_replace(
                        '/<div class="product_more_images"><span.*?<\/span><\/div>/ims',
                        '',
                        $this->content
                    );
                }


                if ($oldcontent == $this->content) {
                    //$this->content = preg_replace('/<div><a id=\'a_main_image[^>]*><img.*?id=\'main_image[^\']*?\'[^>]+?src=\'[^\']+?' . $product_image_quoted . '\'.*?\/><\/a><\/div>/is', '<div id="additional_images' . $pid . '">' . $html . '</div>', $this->content);
                    $this->content = preg_replace(
                        '/<div class="product_image[^"]*"><div class=\'productImageWrap\'[^>]*><div(?: class=\'product_image_box\')?><a[^>]+?href=\'[^\']+?' . $product_image_quoted . '\'.*?<\/a><\/div><\/div>.*?<\/div>/is',
                        '<div id="additional_images' . $pid . '">' . $html . '</div>',
                        $this->content
                    );
                }

                if ($oldcontent == $this->content) {
                    //$this->content = preg_replace('/<div><a id=\'a_main_image[^>]*><img.*?id=\'main_image[^\']*?\'[^>]+?src=\'[^\']+?' . $product_image_quoted . '\'.*?\/><\/a><\/div>/is', '<div id="additional_images' . $pid . '">' . $html . '</div>', $this->content);
                    $this->content = preg_replace(
                        '/<div[^>]*class=\'productImageWrap[^>]*>.*?<\/div><\/div>/is',
                        $html,
                        $this->content
                    );
                }
                
                //NOTE: remove original thumbnails
                $product_more_images_pattern =
                    '<div\b[^>]*?\bclass\s*+=\s*+"[^"]*?\b(?:product_more_images|redhoverImagebox)\b[^"]*+"[^>]*+>'.
                    '('.
                    '(?:'.
                        '[^<]++'.
                        '|'.
                        '<(?!/?div\b|!--)'.
                        '|'.
                        '<!--.*?-->'.
                        '|'.
                        '<div\b[^>]*+>'.
                            '(?1)'.
                        '</div\s*+>'.
                    ')*+'.
                    ')'.
                    '</div\s*+>';
                $this->content = preg_replace("#{$product_more_images_pattern}#is", '', $this->content);

				$this->content = preg_replace('/<div id="(additional_images.*?)">/', '<div style="display:none" id="$1"></div><div>', $this->content);
                //$this->content = preg_replace('/<div\b[^>]*?id=(?:"|\')(additional_images[^"\']*+)(?:"|\')[^>]*+>/', '<div style="display:none" id="$1"></div><div>', $this->content);

                $this->needHeaders = true;

                if(!$this->needScroll) {
                    $this->needScroll = $this->conf->checkValue('magicscroll', 'Yes');
                }
            }

        }

        //NOTE: commented out because this code from module for VM
        //if(in_array($this->coreClass->type, array('category', 'circle'))) {
        //    $this->content = str_replace('<!--MAGICTOOLBOXPLACEHOLDER-->', $this->loadCustomCircleModule(), $this->content);
        //}

        $this->conf->setProfile('default');

        /* load JS and CSS */
        if($this->needHeaders && !defined('MagicZoom_HEADERS_LOADED')) {
            $pattern = '/<\/head>/is';
            $this->content = preg_replace_callback($pattern, array(&$this,"loadJSCSSCallback"), $this->content, 1);
            define('MagicZoom_HEADERS_LOADED', true);
        }

        // for preserve additional thumbnails positions
        //dmp($this->shouldBeReplaced);
        $this->content_buffer = preg_replace($this->shouldBeReplaced["patterns"], $this->shouldBeReplaced["replacements"], $this->content_buffer);

        JResponse::setBody($this->content);
    }

    function getModuleContent($name) {
        $mod = JModuleHelper::getModule($name);
        if(!$mod) return false;
        return $mod->content;
    }

    function loadCustomCircleModule() {
        if($this->conf->checkValue('enable-effect', 'Yes', 'custom')) {
            $this->conf->setProfile('custom');
            $this->needHeaders = true;

            $mode = $this->params->get('mode', 'random products');
            $maxc = $this->params->get('maxc', 3); // 0 - no limit
            $maxp = $this->params->get('maxp', 10); // 0 - no limit
            $cids = $this->params->get('cids', '');
            $pids = $this->params->get('pids', '');

            if(!empty($cids)) {
                $cids = explode(',', $cids);
            }

            if(!empty($pids)) {
                $pids = explode(',', $pids);
            }

            $ids = array();

            switch($mode) {
                case 'random category':
                    $q = 'SELECT DISTINCT #__redshop_category.category_id
                            FROM #__redshop_category';
                    $q .= ' ORDER BY category_name DESC ';
                    $db=new ps_DB;
                    $db->query($q);
                    if($db->num_rows() > 0) {
                        $categories = array();
                        while($db->next_record()){
                            $categories[] = intval($db->f('category_id'));
                        }
                        if($maxc > 0) {
                            $cids = array_rand(array_flip($categories), $maxc);
                        } else {
                            $cids = $categories;
                        }
                    }
                case 'category':
                    $q = 'SELECT DISTINCT #__redshop_product.product_id
                            FROM #__redshop_product, #__redshop_product_category_xref, #__redshop_category
                            WHERE product_parent_id=\'\'
                                AND #__redshop_product.product_id=#__redshop_product_category_xref.product_id
                                AND #__redshop_category.category_id=#__redshop_product_category_xref.category_id
                                AND #__redshop_category.category_id IN (' . implode(',', $cids) . ')
                                AND #__redshop_product.product_publish=\'Y\'';
                    if(CHECK_STOCK && PSHOP_SHOW_OUT_OF_STOCK_PRODUCTS != '1') {
                        $q .= ' AND product_in_stock > 0 ';
                    }
                    $q .= ' ORDER BY product_name DESC ';
                    if($maxp > 0) {
                        $q .= ' LIMIT ' . intval($maxp);
                    }
                    $db=new ps_DB;
                    $db->query($q);
                    if($db->num_rows() > 0) {
                        while($db->next_record()){
                            $ids[] = intval($db->f('product_id'));
                        }
                    }
                    break;
                case 'random products':
                    $q = 'SELECT DISTINCT #__redshop_product.product_id
                            FROM #__redshop_product, #__redshop_product_category_xref, #__redshop_category
                            WHERE product_parent_id=\'\'
                                AND #__redshop_product.product_id=#__redshop_product_category_xref.product_id
                                AND #__redshop_category.category_id=#__redshop_product_category_xref.category_id
                                AND #__redshop_product.product_publish=\'Y\'';
                    if(!empty($cids)) {
                        $q .= ' AND #__redshop_category.category_id IN (' . implode(',', $cids) . ') ';
                    }
                    if(CHECK_STOCK && PSHOP_SHOW_OUT_OF_STOCK_PRODUCTS != '1') {
                        $q .= ' AND product_in_stock > 0 ';
                    }
                    $q .= ' ORDER BY product_name DESC ';
                    $db=new ps_DB;
                    $db->query($q);
                    if($db->num_rows() > 0) {
                        $products = array();
                        while($db->next_record()){
                            $products[] = intval($db->f('product_id'));
                        }
                        if($maxp > 0) {
                            $ids = array_rand(array_flip($products), $maxp);
                        } else {
                            $ids = $products;
                        }
                    }
                    break;
                case 'items':
                default:
                    $ids = $pids;
                    break;
            }

            if(count($ids) > 0) {
                $list = array();

                foreach($ids as $id) {
                    $data = $this->loadIMGCallback(array(false, intval($id)), true);
                    if($data) {
                        $list[] = $data;
                    }
                }

                if(count($list) > 0) {
                    return $this->coreClass->getMainTemplate($list, array('id' => 'custom'));
                }
            }
        }
        return '';
    }

    function loadJSCSSCallback($matches) {

        $out = $this->coreClass->getHeadersTemplate($this->baseurl);

        if($this->needScroll) {
            $this->scrollClass->params->resetProfile();
            $out .= $this->scrollClass->getHeadersTemplate($this->baseurl, null, false);
        }

        $out .= '<script type="text/javascript" src="' . $this->baseurl . '/utils.js"></script>';

        //$out .= "\n<link type=\"text/css\" href=\"{$this->baseurl}/module.css\" rel=\"stylesheet\" media=\"screen\" />\n";

        return $out . $matches[0];
    }

    function loadCircleModuleCallback($matches) {
        if(preg_match_all("/<a[^>]*?product_id=([0-9]*)[^>]*>\s*<img[^>]*>\s*<\/a>/is", $matches[0], $listMatches)) {
            $list = array();
            foreach($listMatches[0] as $k => $m) {
                $list[] = $this->loadIMGCallback(array($m, $listMatches[1][$k]));
            }
            $id = $this->randomProd ? 'random' : $this->latestProd ? 'latest' : 'featured';
            return $this->coreClass->getMainTemplate($list, array('id' => $id));
        }
        return $matches[0];
    }

    //used only for browse pages in VM 1.0
    function loadIMGCallback_VM10($matches) {
        if(preg_match_all("/https?:\/\/(.*?)\.(jpg|png|gif)(.*?)[\\\\\"\']/i", $matches[0], $images)){
            $img_big_src = substr($images[0][0], 0, strlen($images[0][0])-1);
            $img_big_src = urldecode($img_big_src);

            $db = new ps_DB;
            $q='SELECT * FROM #__redshop_product WHERE product_full_image LIKE \'%'.basename($img_big_src).'\' AND product_publish=\'Y\'';

            if(preg_match('/resized/', $img_big_src)) {
                $img_big_src = preg_replace('/^(.*?\.(?:jpg|png|gif))(?:\&|\?).*$/is', '$1', $img_big_src);
                $img_big_src = preg_replace('/^.*?=resized\//is', '', $img_big_src);
                $q='SELECT * FROM #__redshop_product WHERE product_thumb_image LIKE \'%'.basename($img_big_src).'\' AND product_publish=\'Y\'';
            }

            $db->query($q);
            if($db->num_rows() > 0) {
                $marr = array();
                $marr[0] = $matches[0];
                $marr[1] = $db->f("product_id");
                $GLOBALS["magictoolbox_rewrite_done"] = true;
                return $this->loadIMGCallback($marr);
            }
        }

        return $matches[0];
    }

    function loadIMGCallback($matches, $returnArray = false, $_pid = 0) {
        if(preg_match('/.*?class=(\'|")[^\'"]*?(Magic(Zoom|Thumb|Magnify|Slideshow|Scroll|Touch|360)(Plus)?)[^\'"]*?(\'|").*/is', $matches[0])) return $matches[0];
        // allow to show product when click on image (in latestProd module and browse pages)
        /*if($this->page == 'shop.browse') {
            $linkHref = preg_replace("/^.*?<a[^>]*?href=\"([^\"]*)\".*$/iUs", "$1", $matches[0]);
        } else {
            $linkHref = preg_replace("/^\s*<a[^>]*?href=\"([^\"]*)\".*$/iUs", "$1", $matches[0]);
        }
        if($linkHref == $matches[0]) {
            $linkHref = false;
            $linkOnclick = false;
        } else if(preg_match("/^\s*javascript\s*\:.*$/is", $linkHref)) {
            $linkOnclick = preg_replace("/^\s*javascript\s*\:(.*)$/is", "$1", $linkHref);
            $linkOnclick = str_replace("\\'", "'", $linkOnclick);
            $linkHref = false;
        } else {
            $linkOnclick = "document.location.href = '{$linkHref}';";
        }*/

        $db = new ps_DB;
        $zoom_id = '';
        $images = array();

        $title = '';
        $description_short = '';
        $description = '';

        if ($returnArray || $this->latestProd == true || $this->featuredProd == true || $this->randomProd == true || $this->page == 'shop.browse') {
            $product_id = $matches[1];

            if($this->conf->checkValue('link-to-product-page', 'Yes')) {
                $sess = new ps_session();
                $link_parameters = 'page=shop.product_details&amp;flypage=' . FLYPAGE . '&amp;product_id=' . intval($product_id);
                $link = $this->jmurl . $sess->url($link_parameters);
            } else { 
                $link = '';
            }

            $product = $this->getProductInfo($product_id);

            $description = $product["description"];
            $description_short = $product["description_short"];
            $title = $product["title"];

            if(!empty($product["img"])) {
                $img_big_src = $this->resolveImageUrl($product["img"]);
            }else{
                return $matches[0];
            }

            //$img_big_path = IMAGEPATH."product/".$product["img"];

            if(!empty($product["thumb"])) {
                $img_small = $this->resolveImageUrl($product["thumb"]);
            }else{
                return $matches[0];
            }

            //$db->query('SELECT * FROM #__redshop_product WHERE product_id='.$product_id.' AND product_publish=\'Y\'');
            //$img_big_src = IMAGEURL."product/".$db->f("product_full_image");
            //$img_small = "product/".$db->f("product_thumb_image");         
            //$description = $db->f("product_desc");
            //$description_short = $db->f("product_s_desc");
            //$title = $db->f("product_name");
            //$img_small_src = IMAGEURL."product/".$db->f("product_thumb_image");
            if($this->latestProd == true) $zoom_id = "LatestProd" . md5($img_big_src);
            if($this->featuredProd == true) $zoom_id = "FeaturedProd" . md5($img_big_src);
            if($this->randomProd == true) $zoom_id = "RandomProd" . md5($img_big_src);
            if($returnArray) $zoom_id = "Custom" . md5($img_big_src);
        }
        if($_pid || !$returnArray && $this->latestProd == false && $this->featuredProd == false && $this->randomProd == false && ($this->page == 'shop.product_details' || $this->page == 'shop.cart')) {

            $link = '';

            if($_pid) $product_id = $_pid;
            //if($this->VMversion == '1.1') $product_id = intval( vmGet($_REQUEST, "product_id", null) );
            //else $product_id = intval( mosGetParam($_REQUEST, "product_id", null) );

            $zoom_id = $product_id;

            $product = $this->getProductInfo($product_id);

            $description = $product["description"];
            $description_short = $product["description_short"];
            $title = $product["title"];

            if(!empty($product["img"])) {
                $img_big_src = $this->resolveImageUrl($product["img"]);
                $img_big_path = $this->resolveImagePath($product["img"]);
            } else {
                return $matches[0];
            }
            if(!empty($product["thumb"])) {
                $img_small = $this->resolveImageUrl($product["thumb"]);
            } else {
                return $matches[0];
            }

            if (!$this->isUrl($img_big_path) && !file_exists($img_big_path)) return $matches[0];

            //$img_small_src = IMAGEURL."product/".$product["product_thumb_image"];
            //$img_small_path = IMAGEPATH."product/".$product["product_thumb_image"];
            //if (!file_exists($img_small_path)) $img_small_src = $img_big_src;

            $path_big = pathinfo($img_big_src);
            //$path_small = pathinfo($img_small_src);

            //$path_big['basename'] = urlencode($path_big['basename']);
            //$path_small['basename'] = urlencode($path_small['basename']);

            //preg_match('/'.preg_quote($path_big['basename']).'/i', $matches[0], $img_big_match);
            //preg_match('/'.preg_quote($path_small['basename']).'/i', $matches[0], $img_small_match);
            preg_match('/'.preg_quote($path_big['basename']).'|'.preg_quote(rawurlencode($path_big['basename'])).'/i', $matches[0], $img_big_match);

            if (!$_pid && !$img_big_match /*&& !$img_small_match*/) return $matches[0];

            /*$dbi = new ps_DB();
            $dbi->query( "SELECT * FROM #__redshop_product_files WHERE file_product_id='$product_id' AND file_is_image='1' AND file_published='1'" );
            $images = $dbi->record;*/

            $dbi = new ps_DB();
            $query = "SELECT pf.* FROM #__redshop_product_files AS pf WHERE pf.file_product_id='%u' AND pf.file_is_image='1' AND pf.file_published='1'";
            $dbi->query(sprintf($query,$product_id));

            //if product has no images inherit them from parent product
            if(!$dbi->next_record()){
                $dbi->query("SELECT product_parent_id FROM #__redshop_product WHERE product_id='$product_id'");

                $product_parent_id  = $dbi->f("product_parent_id");
                if($product_parent_id) $product_id = $product_parent_id;
                $dbi->query(sprintf($query,$product_id));
            }

            $images = $dbi->record;
        }

        //$img_small_src = $img_big_src;

        if (!empty($img_big_src)) {
            if($this->coreClass->type == 'circle' && !$this->coreClass->isEnabled($images, $product_id)) {
                return $matches[0];
            }
            if(JModuleHelper::getModule('virtuemart_magic360flash')) {
                $GLOBALS["magictoolbox"]["magic360flashVM"]->conf->setProfile($this->conf->getProfile());
                if($GLOBALS["magictoolbox"]["magic360flashVM"]->coreClass->isEnabled($images, $product_id)) {
                    return $matches[0];
                }
                $GLOBALS["magictoolbox"]["magic360flashVM"]->conf->setProfile('default');
            }
            if(JModuleHelper::getModule('virtuemart_magic360')) {
                $GLOBALS["magictoolbox"]["magic360VM"]->conf->setProfile($this->conf->getProfile());
                if($GLOBALS["magictoolbox"]["magic360VM"]->coreClass->isEnabled($images, $product_id)) {
                    return $matches[0];
                }
                $GLOBALS["magictoolbox"]["magic360VM"]->conf->setProfile('default');
            }
            $this->needHeaders = true;

            if(!$this->needScroll) {
                $this->needScroll = $this->conf->checkValue('magicscroll', 'Yes');
            }

            if(!$_pid && ($returnArray || $this->latestProd || $this->featuredProd || $this->randomProd) && ($this->coreClass->type == 'category' || $this->coreClass->type == 'circle')) {
                return array(
                    //"img" => $this->makeThumb($img_big_src, "original", $product_id, $img_big_src),
                    "id" => $zoom_id,
                    "title" => $title,
                    //"description" => $description,
                    "medium" => $this->makeThumb($img_big_src, "thumb", $product_id, $img_small),
                    "thumb" => $this->makeThumb($img_big_src, "selector", $product_id),
                    'link' => $link
                );
            }

            $ret = array();

            $main = array();
            $thumbs = array();

            if($this->coreClass->type == 'category' || $this->coreClass->type == 'circle') {
                $list = array();
            }

            /*$alt = '';
            preg_match("/alt=\"(.*?)\"/", $matches[0], $alt);
            if (count($alt)) $alt = $alt[1];
            else $alt = ''; */

            $t = array(
                "img" => $this->makeThumb($img_big_src, 'original', $product_id, $img_big_src),
                "id" => $zoom_id,
                "title" => $title,
                "shortDescription" => $description_short,
                "description" => $description,
                "thumb" => $this->makeThumb($img_big_src, 'thumb', $product_id, $img_small),
                "link" => $link
            );
            if($this->coreClass->type == 'category' || $this->coreClass->type == 'circle') {
                //$list[] = $t;
            } else {
                $t = $this->coreClass->getMainTemplate($t);


                if($this->latestProd == false && $this->featuredProd == false && $this->randomProd == false && $this->conf->checkValue("preserve-lightbox","Yes")) {
                    $t = str_replace('<a ','<a onclick="magicLightBox(this);" ',$t);
                }

                if($this->latestProd == true || $this->featuredProd == true || $this->randomProd == true || $this->conf->checkValue("centered-thumbnails", "Yes")) {
                    $t = str_replace("<a ","<a style=\"margin:0 auto;\" ",$t);
                }

                $main = $t;
            }

            if(($this->page == "shop.product_details" || $this->page == 'shop.cart') && count($images) > 0) {

                //$style = '';
                $style = array(
                    'margin-bottom' => $this->conf->getValue("margin-between-thumbs").'px',
                    'margin-right' => $this->conf->getValue("margin-between-thumbs").'px',
                    'display' => 'block',
                    'float'   => 'left',
                );
                $style = 'style="'.$this->renderStyle($style).'"';

                $t = array(
                    "img" => $this->makeThumb($img_big_src, "original", $product_id, $img_big_src),
                    "id" => $zoom_id,
                    "title" => $title,
                    "description" => $description,
                    "medium" => $this->makeThumb($img_big_src, "thumb", $product_id, $img_small),
                    "thumb" => $this->makeThumb($img_big_src, "selector", $product_id)
                );
                if($this->coreClass->type == 'category' || $this->coreClass->type == 'circle') {
                    $list[] = $t;
                } else {
                    if($this->conf->checkValue('multiple-images', 'Yes')) {
                        $t = $this->coreClass->getSelectorTemplate($t);
                        $thumbs[] = str_replace("<a ","<a " . $style . " ",$t);
                    }
                }

                if($this->conf->checkValue("multiple-images", "Yes") || $this->coreClass->type == 'category' || $this->coreClass->type == 'circle'){
                    foreach($images as $img){
                        $tp = array(
                            "img" => $this->makeThumb($img->file_url, "original", $product_id, $img->file_url),
                            "id" => $zoom_id,
                            "title" => $this->conf->checkValue('use-individual-titles', 'Yes') ? stripslashes($img->file_title) : $title,
                            "shortDescription" => $description_short,
                            "description" =>$this->conf->checkValue('use-individual-titles', 'Yes') ? '' : $description,
                            "medium" => $this->makeThumb($img->file_name,"thumb", $product_id),
                            "thumb" => $this->makeThumb($img->file_name,"selector", $product_id)
                        );
                        if($this->coreClass->type == 'category' || $this->coreClass->type == 'circle') {
                            $list[] = $tp;
                        } else {
                                $t = $this->coreClass->getSelectorTemplate($tp);
                            if($this->conf->checkValue("preserve-additional-thumbnails-positions", "Yes")) {
                                $this->replaceThumbInFlypage($img, $t);
                            }
                            $thumbs[] = str_replace("<a ","<a " . $style . " ",$t);
                        }
                    }
                    if($this->preserveAdditionalThumbnailsPositions === true) {
                        $thumbs = array();
                    }
                }

            }

            if($this->coreClass->type == 'category' || $this->coreClass->type == 'circle') {
                if(count($list) < 2) {
                    return $matches[0];
                }
                if($returnArray) {
                    return $list;
                } else {
                    return $this->coreClass->getMainTemplate($list, array('id' => 'detailed' . $product_id));
                }
            } else {
                $magicscrollOptions = '';
                if($this->conf->checkValue('magicscroll', 'Yes')) {
                    $magicscrollOptions = $this->scrollClass->params->serialize(false, '', 'product-magicscroll-options');
                }
                $template = $this->conf->getValue('template');
                return $this->renderTemplate($template, array(
                    'main' => $main,
                    'thumbs' => $thumbs,
                    'magicscrollOptions' => $magicscrollOptions,
                    'classes' => $this->conf->checkValue('magicscroll', 'Yes') ? 'MagicScroll' : '',
                    'id' => 'MagicToolboxSelectors' . $zoom_id,
                    //'message' => $message,
                ));
            }

            //return '<div class="MagicToolboxContainer" style="text-align: ' . (($this->latestProd == true || $this->featuredProd == true || $this->randomProd == true || $this->conf->checkValue("centered-thumbnails", "Yes")) ? 'center' : 'left') . ' !important; ' . ($this->conf->checkValue("use-original-vm-thumbnails", "Yes")?'':('width: ' .$this->conf->getValue("thumb-max-width").'px;')) . '" >'.join($ret, ' ').'</div>';
        }
        else return $matches[0];
    }

    function replaceThumbInFlypage($img, $tpl) {
        $patterns = array(
            "/<a[^>]*>\s*<img[^>]*?src=\"(" . preg_quote($img->file_url, "/") . "[^\"]*)\"[^>]*>.*?<\/a>/is",
            "/<a[^>]*>\s*<img[^>]*?src=\"([^\"]*?virtuemart\/show_image_in_imgtag\.php\?[^\"]*?" . preg_quote($img->file_name, "/") . "[^\"]*)\"[^>]*>.*?<\/a>/is",
            "/<a[^>]*>\s*<img[^>]*?src=\"([^\"]*?virtuemart\/show_image_in_imgtag\.php\?[^\"]*?" . preg_quote(urlencode($img->file_name), "/") . "[^\"]*)\"[^>]*>.*?<\/a>/is"
        );
        foreach($patterns as $pattern) {
            if(preg_match($pattern, $this->content_buffer, $matches)) {
                if($this->conf->checkValue("use-original-vm-thumbnails", "Yes")) {
                    $tpl2 = preg_replace('/src=\".*?\"/is', 'src="' . $matches[1] . '"', $tpl);
                } else $tpl2 = $tpl;
                $this->preserveAdditionalThumbnailsPositions = true;
                // we can't replace becase main preg_replace will be restore all chnages
                //$this->content_buffer = preg_replace($pattern, $tpl, $this->content_buffer);
                $this->shouldBeReplaced["patterns"][] = $pattern;
                $this->shouldBeReplaced["replacements"][] = $tpl2;
                break;
            }
        }
    }

    function getProductInfo($id, $field = null, $value = null) {
        if($field !== null && $value !== null && !empty($value)) return $value;

        if(intval($id) < 1) return false;

        if(!isset($GLOBALS["magictoolbox"]["products_cache"])) $GLOBALS["magictoolbox"]["products_cache"] = array();

        if(isset($GLOBALS["magictoolbox"]["products_cache"][$id])) {
            // get from magictoolbox cashe
            $product = $GLOBALS["magictoolbox"]["products_cache"][$id];
        } else if(isset($GLOBALS["product_info"]) && isset($GLOBALS["product_info"][$id]) && isset($GLOBALS["product_info"][$id]["product_full_image"])) {
            // get from globals (virtuemart cashe)
            $parentID = $GLOBALS["product_info"][$id]["product_parent_id"];
            $product = array();
            $product["title"] = $GLOBALS["product_info"][$id]["product_name"];
            $product["description"] = $this->getProductInfo($parentID, "description", $GLOBALS["product_info"][$id]["product_desc"]);
            $product["description_short"] = $this->getProductInfo($parentID, "description_short", $GLOBALS["product_info"][$id]["product_s_desc"]);

            $product["img"] = $this->getProductInfo($parentID, "img", $GLOBALS["product_info"][$id]["product_full_image"]);
            $product["thumb"] = $this->getProductInfo($parentID, "thumb", $GLOBALS["product_info"][$id]["product_thumb_image"]);
        } else {
            //get from DB
            $db = new ps_DB;
            $db->query('SELECT * FROM #__redshop_product WHERE product_id='.$id.' AND product_publish=\'Y\'');
            $parentID = $db->f("product_parent_id");
            $product = array();
            $product["title"] = $db->f("product_name");
            $product["description"] = $this->getProductInfo($parentID, "description", $db->f("product_desc"));
            $product["description_short"] = $this->getProductInfo($parentID, "description_short", $db->f("product_s_desc"));

            $product["img"] = $this->getProductInfo($parentID, "img", $db->f("product_full_image"));
            $product["thumb"] = $this->getProductInfo($parentID, "thumb", $db->f("product_thumb_image"));
        }

        // add to cashe
        $GLOBALS["magictoolbox"]["products_cache"][$id] = $product;

        if($field !== null) return $product[$field];
        else return $product;
    }

    function makeThumb($filename, $size, $pid = null) {

        $imgpath = '/components/com_redshop/assets/images/';
        $noimage = $this->jmurl . '/components/com_redshop/assets/images/noimage.jpg';

        if(!file_exists($this->jmpath . $imgpath . $filename) || filesize($this->jmpath . $imgpath . $filename) == 0) {
            return $noImage;
        }

        require_once(dirname(__FILE__).DS.'classes'.DS.'magictoolbox.imagehelper.class.php');
        $helper = new MagicToolboxImageHelperClass($this->jmpath, $imgpath . 'product/magictoolbox_cache', $this->conf, null, $this->jmurl);
        return $helper->create($imgpath . $filename, $size, $pid);
    }

    function isUrl($string) {
        return preg_match('/^https?:\/\//',$string);
    }

    function resolveImageUrl($string) {
        if(!$this->isUrl($string)) {
            $string = IMAGEURL.'product/'.$string;
        }
        return $string;
    }

    function resolveImagePath($string,$thumb = false) {
        if(!$this->isUrl($string) && !file_exists($string)) {
            $string = IMAGEPATH.'product/'.($thumb?'resized/':'').basename($string);
        }
        return $string;
    }

    function renderStyle($css){
        $style = array();

        foreach($css as $attr => $value){
            $style[] = "$attr: $value";
        }
        return join('; ',$style);
    }

    function renderTemplate($options){
        require_once(dirname(__FILE__).DS.'classes'.DS.'magictoolbox.templatehelper.class.php');
        MagicToolboxTemplateHelperClass::setPath(dirname(__FILE__).DS.'templates');
        MagicToolboxTemplateHelperClass::setOptions($this->conf);
        return MagicToolboxTemplateHelperClass::render($options);
    }

    function getRow(&$db) {
        return $db->record[$db->row];
    }

    function displayAdditionImage() {
        //die('asdasdsa');
        // NOTE!
        // following code was copied from redshop product controller (components/com_redshop/controllers/product.php -> displayAdditionImage method)
        // and we have add come our modification
        // this is stupid way, but we have no another ways (redshop attributes has very very idiotic implementation. sory)
        // so this means that this code can be broken after next redshop update
        // просто мега MVC :D

        $url = JURI::base();
        $get = JRequest::get('get');
        $option = JRequest::getVar ( 'option' );
        $producthelper = new producthelper();
        $redTemplate = new Redtemplate ();
        $stockroomhelper = new rsstockroomhelper();

        $property_id = urldecode($get['property_id']);
        $subproperty_id = urldecode($get['subproperty_id']);

        $product_id = $get['product_id'];
        $accessory_id = $get['accessory_id'];
        $relatedprd_id = $get['relatedprd_id'];

        if($accessory_id!=0)
        {
            $accessory = $producthelper->getProductAccessory($accessory_id);
            $product_id = $accessory[0]->child_product_id;
        }

        $main_imgwidth = isset($get['main_imgwidth']) ? intval($get['main_imgwidth']) : 0;
        $main_imgheight = isset($get['main_imgheight']) ? intval($get['main_imgwidth']) : 0;

        $product = $producthelper->getProductById($product_id);
        $producttemplate = $redTemplate->getTemplate ( "product", $product->product_template );
        $producttemplate = $producttemplate[0]->template_desc;
        if (strstr ( $producttemplate, "{product_thumb_image_3}" )) {
            $pimg_tag = '{product_thumb_image_3}';
            $ph_thumb = PRODUCT_MAIN_IMAGE_HEIGHT_3;
            $pw_thumb = PRODUCT_MAIN_IMAGE_3;
        } elseif (strstr ( $producttemplate, "{product_thumb_image_2}" )) {
            $pimg_tag = '{product_thumb_image_2}';
            $ph_thumb = PRODUCT_MAIN_IMAGE_HEIGHT_2;
            $pw_thumb = PRODUCT_MAIN_IMAGE_2;
        } elseif (strstr ( $producttemplate, "{product_thumb_image_1}" )) {
            $pimg_tag = '{product_thumb_image_1}';
            $ph_thumb = PRODUCT_MAIN_IMAGE_HEIGHT;
            $pw_thumb = PRODUCT_MAIN_IMAGE;
        } else {
            $pimg_tag = '{product_thumb_image}';
            $ph_thumb = PRODUCT_MAIN_IMAGE_HEIGHT;
            $pw_thumb = PRODUCT_MAIN_IMAGE;
        }

        if (strstr ( $producttemplate, "{more_images_3}" )) {
            $mph_thumb = PRODUCT_ADDITIONAL_IMAGE_HEIGHT_3;
            $mpw_thumb = PRODUCT_ADDITIONAL_IMAGE_3;
        } elseif (strstr ( $producttemplate, "{more_images_2}" )) {
            $mph_thumb = PRODUCT_ADDITIONAL_IMAGE_HEIGHT_2;
            $mpw_thumb = PRODUCT_ADDITIONAL_IMAGE_2;
        } elseif (strstr ( $producttemplate, "{more_images_1}" )) {
            $mph_thumb = PRODUCT_ADDITIONAL_IMAGE_HEIGHT;
            $mpw_thumb = PRODUCT_ADDITIONAL_IMAGE;
        } else {
            $mph_thumb = PRODUCT_ADDITIONAL_IMAGE_HEIGHT;
            $mpw_thumb = PRODUCT_ADDITIONAL_IMAGE;
        }

        $pw_thumb = $main_imgwidth;
        $ph_thumb = $main_imgheight;

        $aHrefImageResponse = '';
        $aTitleImageResponse = '';
        $mainImageResponse = '';

        $prodadditionImg = '';
        $propadditionImg = '';
        $subpropadditionImg = '';


// -> MAGICTOOLBOX
        $subAdditionalImages = array();
        $propAdditionalImages = array();
        $prodAdditionalImages = array();
        $mAdditionalImages = array();
        $mMainImage = '';
        $mTitle = '';
        $mAdditionalSubfolder = 'property/';
        $propAdditionalSubfolder = 'property/';
// <- MAGICTOOLBOX

        $media_image = $producthelper->getAdditionMediaImage($product_id,"product");

// -> MAGICTOOLBOX
        $prodAdditionalImages = $media_image;
// <- MAGICTOOLBOX

        if (is_file ( JPATH_COMPONENT_SITE . "/assets/images/product/".$product->product_full_image ))
        {
            $aHrefImageResponse = $url."components/com_redshop/assets/images/product/".$product->product_full_image;
            $aTitleImageResponse = $product->product_name;
// -> MAGICTOOLBOX
            $mMainImage = 'product/'.$product->product_full_image;
            $mTitle = $aTitleImageResponse;
// <- MAGICTOOLBOX
            $mainImageResponse = "<img id='main_image".$product_id."' src='".$url."components/com_redshop/helpers/thumb.php?filename=product/".$product->product_full_image."&newxsize=".$pw_thumb."&newysize=".$ph_thumb."&swap=".USE_IMAGE_SIZE_SWAPPING."' alt='".$product->product_name."' title='".$product->product_name."'>";
            if(PRODUCT_HOVER_IMAGE_ENABLE)
            {
//                $mainImageResponse .= "<img id='main_image".$product_id."' src='".$url."components/com_redshop/helpers/thumb.php?filename=product/".$product->product_full_image."&newxsize=".PRODUCT_HOVER_IMAGE_WIDTH."&newysize=".PRODUCT_HOVER_IMAGE_HEIGHT."&swap=".USE_IMAGE_SIZE_SWAPPING."' alt='".$product->product_name."' title='".$product->product_name."' class='redImagepreview'>";
            }
        }
        $tmp_prodimg='';
        /*Edited*/
          $val_prodadd=count($media_image);

            for($m = 0; $m < count ( $media_image ); $m ++)
            {
                $thumb = $media_image [$m]->media_name;
                $alttext = $producthelper->getAltText ( 'product', $media_image [$m]->section_id, '', $media_image [$m]->media_id );
                if (! $alttext) {
                    $alttext = $media_image [$m]->media_name;
                }
                if ($media_image [$m]->media_name != $media_image [$m]->product_full_image)
                {
                    if ($media_image [$m]->media_name && is_file ( JPATH_COMPONENT_SITE . "/assets/images/product/".$media_image[$m]->media_name ))
                    {
                        if(PRODUCT_ADDIMG_IS_LIGHTBOX)
                        {
                            $prodadditionImg_div_start= "<div><a href='".$url."components/com_redshop/assets/images/product/".$thumb."' title='".$alttext."' rel='lightbox[product7]'>";
                            $prodadditionImg_div_end="</a></div>";
                        }
                        else
                        {
                            $img_path=$url."components/com_redshop/helpers/thumb.php?filename=product/".$thumb."&newxsize=".$pw_thumb."&newysize=".$ph_thumb."&swap=".USE_IMAGE_SIZE_SWAPPING;
                            $prodadditionImg_div_start="<div onmouseover='display_image_add(\"".$img_path."\",".$product_id.");'>";
                            $prodadditionImg_div_end="</div>";
                        }
                        $prodadditionImg .= $prodadditionImg_div_start;
                        $prodadditionImg .= "<img src='".$url."components/com_redshop/helpers/thumb.php?filename=product/".$thumb."&newxsize=".$mpw_thumb."&newysize=".$mph_thumb."&swap=".USE_IMAGE_SIZE_SWAPPING."' alt='".$alttext."' title='".$alttext."'>";
                        if(ADDITIONAL_HOVER_IMAGE_ENABLE)
                        {
                            $prodadditionImg .= "<img src='".$url."components/com_redshop/helpers/thumb.php?filename=product/".$thumb."&newxsize=".$mpw_thumb."&newysize=".$mph_thumb."&swap=".USE_IMAGE_SIZE_SWAPPING."' alt='".$alttext."' title='".$alttext."' class='redImagepreview'>";
                        }
                        $prodadditionImg .= $prodadditionImg_div_end;
                        $tmp_prodimg=$prodadditionImg;
                    }
                }
            }
        /*Edited*/
        if($val_prodadd==1)
        {
// -> MAGICTOOLBOX
            $prodAdditionalImages = array();
// <- MAGICTOOLBOX
            $prodadditionImg=" ";
            $propadditionImg=" ";
        }


        if($property_id>0)
        {
            $property = $producthelper->getAttibuteProperty($property_id);

            if (count($property)>0 && is_file ( JPATH_COMPONENT_SITE . "/assets/images/property/".$property[0]->property_main_image ))
            {
                $aHrefImageResponse = $url."components/com_redshop/assets/images/property/".$property[0]->property_main_image;
                $aTitleImageResponse = $property[0]->text;
// -> MAGICTOOLBOX
                $mMainImage = 'property/'.$property[0]->property_main_image;
                $mTitle = $aTitleImageResponse;
// <- MAGICTOOLBOX
                $mainImageResponse = "<img id='main_image".$product_id."' src='".$url."components/com_redshop/helpers/thumb.php?filename=property/".$property[0]->property_main_image."&newxsize=".$pw_thumb."&newysize=".$ph_thumb."&swap=".USE_IMAGE_SIZE_SWAPPING."' alt='".$property[0]->text."' title='".$property[0]->text."'>";
                   if(PRODUCT_HOVER_IMAGE_ENABLE)
                {
//                    $mainImageResponse .= "<img id='main_image".$product_id."' src='".$url."components/com_redshop/helpers/thumb.php?filename=product_attributes/".$property[0]->property_image."&newxsize=".PRODUCT_HOVER_IMAGE_WIDTH."&newysize=".PRODUCT_HOVER_IMAGE_HEIGHT."&swap=".USE_IMAGE_SIZE_SWAPPING."' alt='".$property[0]->text."' title='".$property[0]->text."' class='redImagepreview'>";
                }
            }
            //Display attribute image in cart
            if (count($property)>0 && is_file ( JPATH_COMPONENT_SITE . "/assets/images/product_attributes/".$property[0]->property_image ))
            {
                    $attrbimg=$url."components/com_redshop/assets/images/product_attributes/".$property[0]->property_image;
            }
            $media_image = $producthelper->getAdditionMediaImage($property_id,"property");

           /*Edited*/

           if(count($media_image)==0)
           {
                   $propadditionImg=$tmp_prodimg;
// -> MAGICTOOLBOX
                   $propAdditionalImages = $prodAdditionalImages;
                   $propAdditionalSubfolder = 'product/';
// <- MAGICTOOLBOX
           }
           else
           {
// -> MAGICTOOLBOX
                   $propAdditionalImages = $media_image;
// <- MAGICTOOLBOX

                     for($m = 0; $m < count ( $media_image ); $m ++)
                    {
                         $thumb = $media_image [$m]->media_name;
                        $alttext = $producthelper->getAltText ( 'product', $media_image [$m]->section_id, '', $media_image [$m]->media_id );
                        if (! $alttext)
                        {
                            $alttext = $thumb;
                        }

                        if ($thumb!=$media_image [$m]->property_image)
                        {
                            if ($thumb && is_file ( JPATH_COMPONENT_SITE . "/assets/images/property/".$thumb))
                            {
                                    if(PRODUCT_ADDIMG_IS_LIGHTBOX)
                                    {
                                        $propadditionImg_div_start= "<div><a href='".$url."components/com_redshop/assets/images/property/".$thumb."' title='".$alttext."' rel='lightbox[product7]'>";
                                        $propadditionImg_div_end="</a></div>";
                                    }
                                    else
                                    {
                                        $imgs_path=$url."components/com_redshop/helpers/thumb.php?filename=property/".$thumb."&newxsize=" . $pw_thumb . "&newysize=" . $ph_thumb . "&swap=" . USE_IMAGE_SIZE_SWAPPING;
                                        $propadditionImg_div_start="<div onmouseover='display_image_add(\"".$imgs_path."\",".$product_id.");'>";
                                        $propadditionImg_div_end="</div>";
                                    }
                                    $propadditionImg .= $propadditionImg_div_start;
                                    $propadditionImg .= "<img src='".$url."components/com_redshop/helpers/thumb.php?filename=property/".$thumb."&newxsize=" . $mpw_thumb . "&newysize=" . $mph_thumb . "&swap=" . USE_IMAGE_SIZE_SWAPPING . "' alt='" . $alttext . "' title='" . $alttext . "'>";
                                    if(ADDITIONAL_HOVER_IMAGE_ENABLE)
                                    {
                                        $propadditionImg .= "<img src='".$url."components/com_redshop/helpers/thumb.php?filename=property/".$thumb."&newxsize=" . $mpw_thumb . "&newysize=" . $mph_thumb . "&swap=" . USE_IMAGE_SIZE_SWAPPING . "' alt='" . $alttext . "' title='" . $alttext . "' class='redImagepreview'>";
                                    }
                                    $propadditionImg .= $propadditionImg_div_end;

                            }
                        }
                    }

           }


        }

        if($subproperty_id>0)
        {
            $subproperty = $producthelper->getAttibuteSubProperty($subproperty_id);
            if (count($subproperty)>0 && is_file ( JPATH_COMPONENT_SITE."/assets/images/subcolor/".$subproperty[0]->subattribute_color_image ))
            {
                $aHrefImageResponse = $url."components/com_redshop/assets/images/subcolor/".$subproperty[0]->subattribute_color_image;
                $aTitleImageResponse = $subproperty[0]->text;
// -> MAGICTOOLBOX
                $mMainImage = 'subcolor/'.$subproperty[0]->subattribute_color_image;
                $mTitle = $aTitleImageResponse;
// <- MAGICTOOLBOX
                $mainImageResponse = "<img id='main_image".$product_id."' src='".$url."components/com_redshop/helpers/thumb.php?filename=subcolor/".$subproperty[0]->subattribute_color_image."&newxsize=".$pw_thumb."&newysize=".$ph_thumb."&swap=".USE_IMAGE_SIZE_SWAPPING."' alt='".$subproperty[0]->text."' title='".$subproperty[0]->text."'>";
                if(PRODUCT_HOVER_IMAGE_ENABLE)
                {
//                    $mainImageResponse .= "<img id='main_image".$product_id."' src='".$url."components/com_redshop/helpers/thumb.php?filename=subcolor/".$subproperty[0]->subattribute_color_image."&newxsize=".PRODUCT_HOVER_IMAGE_WIDTH."&newysize=".PRODUCT_HOVER_IMAGE_HEIGHT."&swap=".USE_IMAGE_SIZE_SWAPPING."' alt='".$subproperty[0]->text."' title='".$subproperty[0]->text."' class='redImagepreview'>";
                }
            }

            $media_image = $producthelper->getAdditionMediaImage($subproperty_id,"subproperty");
// -> MAGICTOOLBOX
            $subAdditionalImages = $media_image;
// <- MAGICTOOLBOX
//            print_r($get['propertyid'];);
            for($m = 0; $m < count ( $media_image ); $m ++)
            {
                $thumb = $media_image [$m]->media_name;
                $alttext = $producthelper->getAltText ( 'product', $media_image [$m]->section_id, '', $media_image [$m]->media_id );
                if (! $alttext) {
                    $alttext = $thumb;
                }
                if ($thumb!=$media_image [$m]->subattribute_color_image)
                {
                    if ($thumb && is_file ( JPATH_COMPONENT_SITE . "/assets/images/property/".$thumb))
                    {
                        $subpropadditionImg .= "<div><a href='" . $url . "components/com_redshop/assets/images/property/".$thumb."' title='" . $alttext . "' rel='lightbox[product7]'>";
                        $subpropadditionImg .= "<img src='" . $url . "components/com_redshop/helpers/thumb.php?filename=property/" . $thumb . "&newxsize=" . $mpw_thumb . "&newysize=" . $mph_thumb . "&swap=" . USE_IMAGE_SIZE_SWAPPING . "' alt='" . $alttext . "' title='" . $alttext . "'>";
                        if(ADDITIONAL_HOVER_IMAGE_ENABLE)
                        {
                            $subpropadditionImg .= "<img src='" . $url . "components/com_redshop/helpers/thumb.php?filename=property/" . $thumb . "&newxsize=" . $mpw_thumb . "&newysize=" . $mph_thumb . "&swap=" . USE_IMAGE_SIZE_SWAPPING . "' alt='" . $alttext . "' title='" . $alttext . "' class='redImagepreview'>";
                        }
                        $subpropadditionImg .= "</a></div>";
                    }
                }
            }
        }

        $response = '';

        if($subpropadditionImg!='')
        {
// -> MAGICTOOLBOX
            $mAdditionalImages = $subAdditionalImages;
// <- MAGICTOOLBOX
            $response = "<div>".$subpropadditionImg."</div>";
        }
        else if($propadditionImg!='')
        {
// -> MAGICTOOLBOX
            $mAdditionalImages = $propAdditionalImages;
            $mAdditionalSubfolder = $propAdditionalSubfolder;
// <- MAGICTOOLBOX
            $response = "<div>".$propadditionImg."</div>";
        }
        else if($prodadditionImg!='')
        {
// -> MAGICTOOLBOX
            $mAdditionalImages = $prodAdditionalImages;
            $mAdditionalSubfolder = 'product/';
// <- MAGICTOOLBOX
            $response = "<div>".$prodadditionImg."</div>";
        }

        $ProductAttributeDelivery = '';
        $attributeFlag = false;
        if($accessory_id==0)
        {
            if($subproperty_id)
            {
                $ProductAttributeDelivery = $producthelper->getProductMinDeliveryTime($product_id,$subproperty_id,"subproperty",0);
                if($ProductAttributeDelivery)
                    $attributeFlag = true;
            }
            if($property_id && $attributeFlag == false)
            {
                $ProductAttributeDelivery = $producthelper->getProductMinDeliveryTime($product_id,$property_id,"property",0);
                if($ProductAttributeDelivery)
                    $attributeFlag = true;
            }
            if($product_id && $attributeFlag == false)
            {
                $ProductAttributeDelivery = $producthelper->getProductMinDeliveryTime($product_id);
            }
        }

        $stockamountTooltip = '';
        $stockamountSrc = '';
        $stockImgFlag = false;
        if($accessory_id==0)
        {
            if($subproperty_id)
            {
                $stockamountList = $stockroomhelper->getStockAmountImage($subproperty_id,"subproperty");
                if(count($stockamountList)>0)
                {
                    $stockImgFlag = true;
                }
            }
            if($property_id && $stockImgFlag == false)
            {
                $stockamountList = $stockroomhelper->getStockAmountImage($property_id,"property");
                if(count($stockamountList)>0)
                {
                    $stockImgFlag = true;
                }
            }
            if($product_id && $stockImgFlag == false)
            {
                $stockamountList = $stockroomhelper->getStockAmountImage($product_id);
            }
            if(count($stockamountList)>0)
            {
                $stockamountTooltip = $stockamountList[0]->stock_amount_image_tooltip;
                $stockamountSrc = $url.'components/com_redshop/assets/images/stockroom'.DS.$stockamountList[0]->stock_amount_image;
            }
        }

// -> MAGICTOOLBOX
        return array(
            'img' => $mMainImage,
            'title' => $mTitle,
            'images' => $mAdditionalImages,
            'subfolder' => $mAdditionalSubfolder,
            'tpl' => "`_`[RESPONSE]`_``_``_``_`".$stockamountSrc."`_`".$stockamountTooltip."`_`".$ProductAttributeDelivery."`_`". (isset($attrbimg) ? $attrbimg : '')
        );
        //echo "`_`".$response."`_`".$aHrefImageResponse."`_`".$aTitleImageResponse."`_`".$mainImageResponse."`_`".$stockamountSrc."`_`".$stockamountTooltip."`_`".$ProductAttributeDelivery."`_`".$attrbimg;
        //exit;
// <- MAGICTOOLBOX
    }
}

$GLOBALS["magictoolbox"]["magiczoomredSHOP"] = new ModMagicZoomRedShop($params);

if(in_array($GLOBALS["magictoolbox"]["magiczoomredSHOP"]->coreClass->type, array('category', 'circle'))) {
    echo '<!--MAGICTOOLBOXPLACEHOLDER-->';
}

function modMagicZoomredSHOPLoad() {
    $GLOBALS["magictoolbox"]["magiczoomredSHOP"]->load();
}
